# EFS40 EHSI by Bea Wolf (D-ECHO) based on A320 canvas avionics by Joshua Davidson

var EFS40_EHSI_main = nil;
var EFS40_EHSI_display = nil;

var canvas_EFS40_EHSI_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};
		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});
		
		var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}
		
		me.page = canvas_group;
		
		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if( du_status[1] >= 1 ){
			EFS40_EHSI_main.page.show();
		} else {
			EFS40_EHSI_main.page.hide();
		}
	},
};

var hdg_fail = 0;		# Stores Heading Reference Failures for use in the Fast Update Loop

var canvas_EFS40_EHSI_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_EFS40_EHSI_main , canvas_EFS40_EHSI_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["ehsi.compass",
		];
	},
	fast_update: func() {
		if( du_status[1] != 2 ) return;
		
		if( !hdg_fail ){
			me["ehsi.compass"].setRotation( -ahrs.heading.mag.getDoubleValue() * D2R );
		}
		
	},
	slow_update: func{
		if( du_status[1] != 2 ) return;

		hdg_fail = !ahrs.heading.valid.getBoolValue();
	},
};


var efs40_ehsi_update = maketimer(0.02, func {
	canvas_EFS40_EHSI_base.update();
});
efs40_ehsi_update.simulatedTime = 1;

var ehsi_main_fast_update = maketimer( 0.02, func{ EFS40_EHSI_main.fast_update(); } );
ehsi_main_fast_update.simulatedTime = 1;

var ehsi_main_slow_update = maketimer( 0.2, func{ EFS40_EHSI_main.slow_update(); } );
ehsi_main_slow_update.simulatedTime = 1;

var ls_ehsi = setlistener("sim/signals/fdm-initialized", func {
	EFS40_EHSI_display = canvas.new({
		"name": "EFS40_EHSI",
		"size": [600, 600],
		"view": [600, 600],
		"mipmapping": 1
	});
	EFS40_EHSI_display.addPlacement({"node": "ed462.screen.ehsi"});
	var groupMain = 

	EFS40_EHSI_main = canvas_EFS40_EHSI_main.new(EFS40_EHSI_display.createGroup(), instrument_path~"efs40-ehsi.svg");

	efs40_ehsi_update.start();
	ehsi_main_fast_update.start();
	ehsi_main_slow_update.start();
	
	removelistener(ls_ehsi);
});
