# Copyright 2018 Stuart Buchanan
# This file is part of FlightGear.
#
# FlightGear is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# FlightGear is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with FlightGear.  If not, see <http://www.gnu.org/licenses/>.
#
# EIS
var EISC208B =
{
	new : func (mfd, myCanvas, device, svg)
	{
		var obj = {
			parents : [
			EISC208B,
			MFDPage.new(mfd, myCanvas, device, svg, "EIS", "")
			],
		};
		
		obj.setController(fg1000.EISController.new(obj, svg));
		
		obj.addTextElements(["TRQDisplay", "ITTDisplay", "NgDisplay", "RPMDisplay", "OilPressDisplay", "OilTempDisplay", "FuelFlowDisplay", "BatAmpsDisplay", "BusVoltsDisplay", "PropAmpsDisplay"]);
		
		obj._oilPressurePointer = PFD.PointerElement.new(obj.pageName, svg, "OilPressPointer", 0.0, 115.0, 135);
		obj._oilTempPointer     = PFD.PointerElement.new(obj.pageName, svg, "OilTempPointer", 0.0, 245.0, 135);
		obj._leftFuelPointer    = PFD.PointerElement.new(obj.pageName, svg, "LeftFuelPointer", 0.0, 40.0, 135);
		obj._rightFuelPointer   = PFD.PointerElement.new(obj.pageName, svg, "RightFuelPointer", 0.0, 40.0, 135);
		
		obj._TRQPointer = PFD.RotatingElement.new(obj.pageName, svg, "TRQPointer", 0.0, 2700.0, 250.0, [150,100]);
		obj._ITTPointer = PFD.RotatingElement.new(obj.pageName, svg, "ITTPointer", 0.0, 2700.0, 250.0, [150,100]);
		obj._NgPointer = PFD.RotatingElement.new(obj.pageName, svg, "NgPointer", 0.0, 2700.0, 250.0, [150,100]);
		
		return obj;
	},
	
	updateEngineData : func(engineData) {
		me.setTextElement("TRQDisplay", sprintf("%i", -engineData.TRQ));
		me.setTextElement("ITTDisplay", sprintf("%i", (engineData.ITT - 32) / 1.8 ));
		me.setTextElement("NgDisplay",  sprintf("%i", engineData.Ng));
		me.setTextElement("RPMDisplay", sprintf("%i", engineData.RPM));
		me.setTextElement("OilPressDisplay", sprintf("%.1f", engineData.OilPressurePSI));
		me.setTextElement("OilTempDisplay",  sprintf("%.1f", (engineData.OilTemperatureF - 32) / 1.8 ));
		me.setTextElement("FuelFlowDisplay", sprintf("%.01f", engineData.FuelFlowGPH));
		me.setTextElement("BatAmpsDisplay", sprintf("%+.01f", engineData.BatAmps));
		me.setTextElement("BusVoltsDisplay", sprintf("%.01f", engineData.BusVolts));
		me.setTextElement("PropAmpsDisplay", sprintf("%.01f", engineData.PropAmps));
		
		me._oilPressurePointer.setValue(engineData.OilPressurePSI);
		me._oilTempPointer.setValue(engineData.OilTemperatureC);
		
		me._TRQPointer.setValue(engineData.TRQ);
		me._ITTPointer.setValue(engineData.ITT);
		me._NgPointer.setValue(engineData.Ng);
	},
	
	updateFuelData : func(fuelData) {
		me._leftFuelPointer.setValue(fuelData.LeftFuelUSGal);
		me._rightFuelPointer.setValue(fuelData.RightFuelUSGal);
	},
	
	# Menu tree .  engineMenu is referenced from most pages as softkey 0:
	# pg.addMenuItem(0, "ENGINE", pg, pg.mfd.EISPage.engineMenu);
	engineMenu : func(device, pg, menuitem) {
		pg.clearMenu();
		pg.resetMenuColors();
		pg.addMenuItem(0, "ENGINE", pg, pg.mfd.EIS.engineMenu);
		pg.addMenuItem(1, "LEAN", pg, pg.mfd.EIS.leanMenu);
		pg.addMenuItem(2, "SYSTEM", pg, pg.mfd.EIS.systemMenu);
		pg.addMenuItem(8, "BACK", pg, pg.topMenu);
		device.updateMenus();
	},
	
	leanMenu : func(device, pg, menuitem) {
		pg.clearMenu();
		pg.resetMenuColors();
		pg.addMenuItem(0, "ENGINE", pg, pg.mfd.EIS.engineMenu);
		pg.addMenuItem(1, "LEAN", pg, pg.mfd.EIS.leanMenu);
		pg.addMenuItem(2, "SYSTEM", pg, pg.mfd.EIS.systemMenu);
		pg.addMenuItem(3, "CYL SELECT", pg);
		pg.addMenuItem(4, "ASSIST", pg);
		pg.addMenuItem(9, "BACK", pg, pg.mfd.EIS.engineMenu);
		device.updateMenus();
	},
	
	systemMenu : func(device, pg, menuitem) {
		pg.clearMenu();
		pg.resetMenuColors();
		pg.addMenuItem(0, "ENGINE", pg, pg.mfd.EIS.engineMenu);
		pg.addMenuItem(1, "LEAN", pg, pg.mfd.EIS.leanMenu);
		pg.addMenuItem(2, "SYSTEM", pg, pg.mfd.EIS.systemMenu);
		pg.addMenuItem(3, "RST FUEL", pg, func(dev, pg, mi) { pg.mfd.EIS.getController().setFuelQuantity(0); });
		pg.addMenuItem(4, "GAL REM", pg, pg.mfd.EIS.galRemMenu);
		pg.addMenuItem(5, "BACK", pg, pg.mfd.EIS.engineMenu);
		device.updateMenus();
	},
	
	galRemMenu : func(device, pg, menuitem) {
		pg.clearMenu();
		pg.resetMenuColors();
		pg.addMenuItem(0, "ENGINE", pg, pg.mfd.EIS.engineMenu);
		pg.addMenuItem(1, "LEAN", pg, pg.mfd.EIS.leanMenu);
		pg.addMenuItem(2, "SYSTEM", pg, pg.mfd.EIS.systemMenu);
		pg.addMenuItem(3, "-10 GAL", pg, func(dev, pg, mi) { pg.mfd.EIS.getController().updateFuelQuantity(-10); } );
		pg.addMenuItem(4, "-1 GAL",  pg, func(dev, pg, mi) { pg.mfd.EIS.getController().updateFuelQuantity(-1); });
		pg.addMenuItem(5, "+1 GAL",  pg, func(dev, pg, mi) { pg.mfd.EIS.getController().updateFuelQuantity(1); });
		pg.addMenuItem(6, "+10 GAL", pg, func(dev, pg, mi) { pg.mfd.EIS.getController().updateFuelQuantity(10); });
		pg.addMenuItem(7, "44 GAL",  pg, func(dev, pg, mi) { pg.mfd.EIS.getController().setFuelQuantity(44); });
		pg.addMenuItem(8, "BACK", pg, pg.mfd.EIS.engineMenu);
		device.updateMenus();
	},
	
	offdisplay : func() {
		me._group.setVisible(0);
		
		# Reset the menu colours.  Shouldn't have to do this here, but
		# there's not currently an obvious other location to do so.
		for(var i = 0; i < 12; i +=1) {
			var name = sprintf("SoftKey%d",i);
			me.device.svg.getElementById(name ~ "-bg").setColorFill(0.0,0.0,0.0);
			me.device.svg.getElementById(name).setColor(1.0,1.0,1.0);
		}
		me.getController().offdisplay();
	},
	ondisplay : func() {
		me._group.setVisible(1);
		me.getController().ondisplay();
	},
	
	
};
