[0%]:   https://upload.wikimedia.org/wikipedia/commons/thumb/5/5c/Progress_00.svg/80px-Progress_00.svg.png "00%"
[10%]:  https://upload.wikimedia.org/wikipedia/commons/thumb/c/c4/Progress_10.svg/80px-Progress_10.svg.png "10%"
[20%]:  https://upload.wikimedia.org/wikipedia/commons/thumb/9/96/Progress_20.svg/80px-Progress_20.svg.png "20%"
[30%]:  https://upload.wikimedia.org/wikipedia/commons/thumb/2/22/Progress_30.svg/80px-Progress_30.svg.png "30%"
[40%]:  https://upload.wikimedia.org/wikipedia/commons/thumb/5/5c/Progress_40.svg/80px-Progress_40.svg.png "40%"
[50%]:  https://upload.wikimedia.org/wikipedia/commons/thumb/f/f2/Progress_50.svg/80px-Progress_50.svg.png "50%"
[60%]:  https://upload.wikimedia.org/wikipedia/commons/thumb/d/dd/Progress_60.svg/80px-Progress_60.svg.png "60%"
[70%]:  https://upload.wikimedia.org/wikipedia/commons/thumb/5/5e/Progress_70.svg/80px-Progress_70.svg.png "70%"
[80%]:  https://upload.wikimedia.org/wikipedia/commons/thumb/5/57/Progress_80.svg/80px-Progress_80.svg.png "80%"
[90%]:  https://upload.wikimedia.org/wikipedia/commons/thumb/b/ba/Progress_90.svg/80px-Progress_90.svg.png "90%"
[100%]: https://upload.wikimedia.org/wikipedia/commons/thumb/8/82/Progress_100.svg/80px-Progress_100.svg.png "100%"
[abandonned]: http://wiki.flightgear.org/images/thumb/3/30/Cross_32px.png/16px-Cross_32px.png         "abandonné"
[done]:       http://wiki.flightgear.org/images/thumb/7/75/Tick_32px.png/16px-Tick_32px.png           "fait"
[ongoing]:    http://wiki.flightgear.org/images/thumb/3/37/Ongoing.png/16px-Ongoing.png               "en cours"
[pending]:    http://wiki.flightgear.org/images/thumb/8/8d/Hourglass_32px.png/16px-Hourglass_32px.png "en attente"
[fixed]:      http://wiki.flightgear.org/images/thumb/8/85/WIP.png/26px-WIP.png                       "réparé"
[paused]:     http://wiki.flightgear.org/images/thumb/d/dc/Paused.png/16px-Paused.png                 "en pause"
[green-bug]:  https://upload.wikimedia.org/wikipedia/commons/thumb/6/63/Green_bug.svg/32px-Green_bug.svg.png "non blocking bug"
[red-bug]:    https://upload.wikimedia.org/wikipedia/commons/thumb/a/a4/Red_bug.svg/32px-Red_bug.svg.png "blocking bug"
[warning]:    https://upload.wikimedia.org/wikipedia/commons/thumb/1/12/Achtung-orange.svg/32px-Achtung-orange.svg.png "warning symbol"

![ZKV1000, in flight little after take off from LFBT](https://seb.lautre.net/bozon/index.php?f=158f605bd971f9)
ZKV1000 just after booting, installed in the Lancair 235 (all other instruments removed)  
[other pictures available here](https://seb.lautre.net/bozon/index.php?f=158cf95340742d)

# Thanks
Thanks to [www2](https://forum.flightgear.org/viewtopic.php?f=14&t=25291) the modeller of the [GDU104X project "Farmin/G1000"](http://wiki.flightgear.org/Project_Farmin/FG1000) I can continue the work began many years ago with a nicer (and working) 3D model instrument. Thanks to him/her for the SVG basis file too.  
Thanks to Hooray's nice efforts, and some examples ans snipsets of code here and there from the Canvas team.  
Thanks to all FlightGear community for the funny project I let too many years off side... Especially to authors of Avidyne Entegra 9 on extra500, from which the map is largely inspired (and many lines of code copied and adapted): Dirk Dittmann and Eric van den Berg 

# Origin
The first ZKV1000, which was completly XML animated, was completly abandonned. Moreover the Nasal code became unmaintanable from my point of view. Not sure this one is better, but I think
it is at least more modulable.

The origin is to simulate a Garmin Primus 1000, as near as possible of the [documentation found](# documentation).

But as we are in a simulation, the zkv1000 is **definitly not** a replica of the well-known G1000, as it takes the liberty to be integrated with some features that doesn't exit in
the real device, as well as some real features aren't scheduled to be implemented. But, it should be easy to add or remove features in order to get the real device. 
This is GPL-2 license though :)

# Objectives
There is no intention to provide a fully qualified G1000 in order to train or so, but this should be possible to be done from the zkv1000.

I'm particulary looking at these points:

1.  easy to implement new features
1.  optimized code (from my non-dev point of view...)
1.  easy to integrate in every cockpit with only few lines, and with easy use for the pilot
1.  near from the G1000 documentation but with some neat features added, and some unrelevant features in a sim removed

# Progress
Note: this is not because the progress bar show 100% that it means it is 100% bug free :)
Please report bug at <zkv1000@seb.lautre.net>.

* ![][100%]
  * Basic Flight Instrumentation: AI, IAS, ALT, HDG
  * Wind data widget
  * trends for altitude and speed (6s prevision)
  * TAS and Ground Speed display
  * VSI
  * 3D knobs rotate
  * map display on inflight page (with online maps downloading and caching)
  * display of NavAids on map
  * XPDR from SoftKeys and knob, with respect of delays from the manual
  * Selected altitude bug (widget off if IA within 100ft)
  * baro settings
  * SoftKeys menus navigation for PFD and MFD: not yet implemented function are logged in console ![][done], softkeys colorized when active ![][done], alerts with white backgroud and black text available ![][done]
  * CDI
  * OMI
  * Slipskid animation
  * Radio stack, including ID for NAV
  * windows management: selectable items, modifiable items, scrolling
  * display of V-speeds in ruler: Vx, Vy, Vr and Vglide (specific for aircraft, see installation instruction)
  * some aircraft specific data to retrieve from aircraft XML files (VNE, etc)
  * possibility to add a copilot's PFD, and other displays
  * EIS: separation for aircraft specifics (selected by the zkv1000 config)
  * Inset Map (PFD)
  * single-prop EIS: texts displayed, animations for fuel
  * ND and map display: synchronized tiles and navaids, range change, map heads up
  * rotation and zooming of online maps in-flight
  * simple Traffic Alert Collision Avoidance System (TCAS)
* ![][90%]
  * TMR/REF Timer ![][done], Vspeeds ![][done], minimums ![][pending] (don't understand the role of this)
  * angle of attack display (not sure about calculation): specific for each airplane (see Installation instructions below)
  * Bearing needs some checks to be sure it shows the correct information
  * XPDR: emergency code depending of the country (eg.: 1200 for US, 7700 for Europe), should be set in settings
* ![][80%]
  * route displayed on map: legs ![][done], current and next leg ![][done], TOC/TOD ![][ongoing], OBS ![][ongoing]
* ![][70%]
* ![][60%]
  * NOT TESTED: add the posssibility to only use Nasal part of the instrument. This in case of a cockpit which already includes needed objects and animations for screens, knobs and buttons in its config files
  * Map settings: declutter ![][ongoing], range/zoom ![][done]
* ![][50%]
  * EIS: animations for temperature for YaSim and JSBSim
* ![][40%]
  * use of [maketimer()](http://wiki.flightgear.org/Nasal_library#maketimer.28.29) instead of [settimer()](http://wiki.flightgear.org/Nasal_library#settimer.28.29) when possible
* ![][30%]
* ![][20%]
  * Setting pages (MFD): pages/sub-pages selection via FMS knob ![][done], pages content implementation ![][ongoing]
* ![][10%]
  * multikey for every part of the device (actually only power on)
  * Aircraft Maintainer's Guide
* ![][0%] (TODO list, unsorted)
  * make booting animation visible
  * make possible to include in the aircraft directory (instead of Instruments-3d)
  * separation of code for buttons and knobs scenarii and computing
  * CDI/GPS: scale depending of the flight phase
  * Alerts
  * TOPO map
  * Weather map
  * Flight planning (MFD)
  * PFD settings
  * replace the use of `clip` by a better system in map display (think also about INSET)
  * VS guidance
  * VNAV
  * scrolling lift in menus
  * tutorials
  * User's Guide
  * make any Vspeed available (not only Vx, Vy, Vr and Vglide), depending of their presence in aircraft config
  * [touchable screen](http://wiki.flightgear.org/Canvas_Event_Handling) ([other interesting link](http://wiki.flightgear.org/Touch_Animation))
  * many more...

# Installation
Just `git clone https://seb.lautre.net/git/seb/zkv1000.git` in your favorite `Instrumentation-3d` dir or directly in your aircraft files structure.  
Please note that the `Instruments-3d` dir is recommended as the zkv1000 wants to integrate the official `$FGDATA/Aircraft/Instruments-3d` some days  
Then somewhere in the XML configuration of your aircraft, put only few lines as described below
## Create the `zkv1000` Nasal namespace
In the `<nasal>` place of your aircraft configuration, tell FlightGear where to find the `zkv1000.nas` file

        <zkv1000>
            <file>Aircraft/Instruments-3d/zkv1000/zkv1000.nas</file>
        </zkv1000>

or

        <zkv1000>
            <file>Aircraft/My-Nice-Aircraft/arbitrary/dirs/zkv1000-or-not/zkv1000.nas</file>
        </zkv1000>

Actually `zkv1000.nas` is where everything begins, please have a look at this code, it would help you to follow the script.

## Set specific values for your aircraft
Specifics values for aircraft can be set via the aircraft configuration, in the `<instrumentation>` section, just add a section `<zkv1000>` and set here the needed values.

### Vspeeds
To see the Vspeeds bugs or the IAS background color change (Vne), set the corresponding V-speeds in knots by adding in your `<instrumentation><zkv1000>` section the following lines (here are the numbers for the Lancair-235, ![][warning] values are not to be used in real life).
If not set, defaults to 999 knots

        <alerts>
          <Vx>99</Vx>
          <Vy>110</Vy>
          <Vr>65</Vr>
          <Vglide>80</Vglide>
          <Vne>170</Vne>
        </alerts>

### EIS
This parameter tells the zkv1000 which kind of engines equips your aircraft, and the associated EIS.  
The Nasal script should include at least three things:

* a method called `displayClass.showEIS` in which you initialize the EIS, especially by selecting the shown, hide, clipped and texts elements
* a method called `displayClass.updateEIS` which is used to update the EIS display, it includes its own timer to refresh itself
* a SVG object with ID `EIS` (generally the background of the EIS display).  
  It should appears in the lists in `displayClass.showEIS`.  
  ![][warning] This object is used to compute the map width, so it is important to set it on the left of the screen

There are three ways too put an EIS in MFD:

#### use one of the included simple EIS provided with the zkv1000

        <eis>
          <type>single-prop</type>
        </eis>

Defaults to `none`, available entries are the `.nas` files located in `Nasal/EIS/` directory.

#### or use the one you specially have created for your aircraft

        <eis>
          <file>Aircraft/My-Nice-Aircraft/Nasal/EIS.nas</file>
        </eis>

or the one from another aircraft. Anyway if the EIS nasal file targeted doesn't exist, the fallback is the type `none`.

#### or you can give the absolute path (![][warning] not supported)

        </eis>
          <file>/home/foobar/fgfs-data/Nasal/testing-jet-jsbsim-EIS.nas</file>
        </eis>

Be aware that `canvas.parsesvg` uses only relative path and should not work properly if your .nas is outside of the FG tree.  
If you want to add your own EIS, just copy the `Models/EIS/single-prop.svg`, modify it to fit your needs, and refer to it in a function named `displayClass.showEIS`, another very important function is `displayClass.updateEIS` (example in [Nasal/EIS/single-prop.nas](zkv1000/blob/master/Nasal/EIS/single-prop.nas))  
You are even free to modify the softkeys map in order to get according menus, but this has to be described on another document (check [Nasal/softkeys.nas](zkv1000/master/blob/Nasal/softkeys.nas)).

No matter of the EIS width, as the map size and center are computed relative to the EIS width automatically.  

_Notes:_

  1. you can use `<file>` or `<type>` indifferently, they are actually identical.
  1. later on the MFD Engine pages will be managed by the file specified in this section

### Angle Of Attack (AOA)
You can specify the stall AoA in order to display it in the dedicated display.

        <alerts>
          <stall-aoa>15</stall-aoa>
          <approach-aoa>4</approach-aoa>
        </alerts>

* Values are in degrees.
* If `<stall-aoa>` is not specified or equals to `0` (zero) the AOA display won't be accessible.
* The `<approach-aoa>` is optionnal, if present a blue marker is visible on AOA display (not in real GarminP1000)

## 3D models
In the definition of your flightdeck (here are the values for the installation in the Lancair 235 in which I develop the device)
put it everywhere you want to. Note that the path `Aircraft/Instruments-3d/zkv1000` is dependant on the path where the zkv1000 is installed, this can be somewhere like `Aircraft/My-Nice-Aircraft/arbitrary/dirs/zkv1000-or-not`as mentionned earlier in this section.

        <model>
            <path>Aircraft/Instruments-3d/zkv1000/pfd-pilot.xml</path>
            <offsets>
                <x-m> -0.023 </x-m>
                <y-m> -0.235 </y-m>
                <z-m> -0.028 </z-m>
            </offsets>
        </model>
        <model>
            <path>Aircraft/Instruments-3d/zkv1000/mfd.xml</path>
            <offsets>
                <x-m>  0.03  </x-m>
                <y-m>  0.06  </y-m>
                <z-m> -0.028 </z-m>
                <heading-deg> -15 </heading-deg>
            </offsets>
        </model>

You can put as many devices as wanted, but generally they are two (PFD+MFD) or three (2 PFD+ 1 PFD), can be only one which is useful when you just want the PFD or the MFD in your cockpit.
The device are identified by a name, which should be unique unless they won't be independant.
This name is set by one of the property in the XML model file (`instrumentation/zkv1000/<NAME>/status`), which is a property telling if the device is switched off or not (or in reversionnary mode, later).
Actually there are only two "types of display": MFD or PFD, which is known by the first 3 letters of the name (case sensitive!)
Other devices as keyboard or non-display can also exists, as long as they don't have a `status` property...
Not sur I'm clear on this point though :)

## TCAS
To enable TCAS you need to make it serviceable in your aircraft before the ZKV1000 being powered on, so the best is to set it in the aircraft configuration files.
Actually it checks if the property `/instrumentation/tcas/serviceable` is set to boolean true value.

        <tcas>
          <name>tcas</name>
          <number>0</number>
          <serviceable type='bool'>true</serviceable>
          <inputs>
            <mode type="int">5</mode>
          </inputs>
        </tcas>

Moreover it only shows alerts with an annunciation "TRAFFIC" on PFD, and shows icons on maps (MFD and INSET), no decision is taken, no relation with transponder and no evasion scenari and no evasion scenario.

## Map tiles origin
By defaults the maps tiles come from `https://maps.wikimedia.org`, type `osm-intl` (please read [https://www.wikimedia.org/wiki/Maps]()), but you can choose your favorite one if you've got one. I've tested `opentopomap.org` and `thunderforest.com` (my favourite).
You can tell the zkv1000 the tile server, type and eventually apikey by using `--prop:` option while starting FlightGear session:

In case of apikey (or whatever added at the en of the URL):

        --prop:/sim/online-tiles-server=tile.thunderforest.com
        --prop:/sim/online-tiles-type=landscape
        --prop:/sim/online-tiles-apikey=?apikey=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

or if there is no type, just use type `/`:

        --prop:/sim/online-tiles-server=a.tile.opentopomap.org
        --prop:/sim/online-tiles-type=/

The only used protocol is `https` but you can provide your own template with option

        --prop:/sim/online-tiles-template=http://{server}/{type}/{z}/{x}/{y}.jpeg

An option is also available to tell the format of the tile image which can be used in template with the `{format}` anchor

        --prop:/sim/online-tiles-format=jpeg

## Switch it up
You can use the multikey (souvenirs, thanks to Melchior having that much expended this feature years ago :)) service by typing:
`:zo`

The `:z` will be the multikey entry for all multikeys of the zkv1000.

1. If you see a single red dot under the `ZKV100O xxx init` message (xxx = MFD or PFD), this is likely the sim is paused (press `p` by default to stop the pause).
1. If you see multiple dots under the `ZKV1000 xxx init` message, something wrong happened, time to check console
1. If you see only black screen on one of the screen, something really wrong happened, time to check console

# Known issues
Please send issues to <zkv1000@seb.lautre.net>  
[issues are listed here](https://seb.lautre.net/git/seb/zkv1000/issues)

# Documentation
Documentation is being actively written. There are two differents guides:

* [Aircraft Maintainer's Guide](http://wiki.flightgear.org/User:Zakharov/zkv1000_installation_guide)
* [User's Guide](http://wiki.flightgear.org/User:Zakharov/zkv1000_user_guide)

Here is a list of useful links:

* [Canvas in FG](http://wiki.flightgear.org/Category:Canvas)
* [Nasal](http://wiki.flightgear.org/Category:Nasal)
* the guides used to create the scenario from [Garmin website](http://support.garmin.com/support/manuals/searchManuals.faces)
    * [G1000 Pilot’s Guide for the Diamond DA42 (v0370.22)](http://static.garmin.com/pumac/190-00406-07_0B_Web.pdf) *(94 pages)*
    * [Pilot's Guide, Cirrus Perspective, SR2x (v0764.30)](http://static.garmin.com/pumac/190-00820-11_A.pdf) *(752 pages)*

# FG1000
There is an implementation of the Primus Garmin 1000 by Stuart Buchanan which is much more respectful of the Canvas principles, using new technology Emesary, with far better coding style, and with the intent to stay close as possible with the Garmin 1000 real device.  
The device is avaiblable in [FGData repo](https://sourceforge.net/p/flightgear/fgdata/ci/next/tree/Aircraft/Instruments-3d/FG1000) and has a [specific wiki page](http://wiki.flightgear.org/FG1000).
