##############
## Liveries ##
##############
aircraft.livery.init("Aircraft/Dragonfly/Models/Liveries");

###########################
## Override key controls ##
###########################
controls.startEngine = func(v = 1) {
	# Only operate in non-walker mode ('s' is also bound to walk-backward)
	var view_name = getprop("/sim/current-view/name");
	if (view_name == getprop("/sim/view[110]/name") or view_name == getprop("/sim/view[111]/name")) {
		return;
	}
	if (getprop("/engines/engine[0]/running"))
	{
		setprop("/controls/switches/starter", 0);
		return;
	}
	else {
		setprop("/controls/switches/starter", v);
	}
};
var mags = props.globals.getNode("/controls/engines/engine[0]/magnetos", 1);
var magL = props.globals.getNode("/controls/engines/engine[0]/left-magneto-switch", 1);
var magR = props.globals.getNode("/controls/engines/engine[0]/right-magneto-switch", 1);
controls.stepMagnetos = func(change) {
	if (!change) {
		return;
	} else if( change > 0 ){
		if ( mags.getValue() == 0 ){
			magL.setValue(1);
		} else if ( mags.getValue() == 1 ){
			magL.setValue(0);
			magR.setValue(1);
		} else if ( mags.getValue() == 2 ){
			magL.setValue(1);
			magR.setValue(1);
		}
	} else if ( change < 0 ){
		if ( mags.getValue() == 3 ){
			magL.setValue(0);
		} else if ( mags.getValue() == 2 ){
			magL.setValue(1);
			magR.setValue(0);
		} else if ( mags.getValue() == 1 ){
			magL.setValue(0);
			magR.setValue(0);
		}
	}
}

##########################
## Override help dialog ##
##########################
#gui.showHelpDialog = func( s ) {
#	if( s == "/sim/help" ){
#		gui.showDialog("dragonfly-help");
#	} else {
#		
#}

##########################
## Config Humans dialog ##
##########################
HumansConfig = func {
	#
	# in order to minimize mp-variables:
	# pilot/copilot = 0 no human model is shown, respectively
	# pilot/copilot = 1 human model without helmet
	# pilot/copilot = 2 human model with helmet
	#
	var pilot = 0;
	var copilot = 0;
	var show_humans = getprop("sim/model/humans/show-humans");
	var show_pilot = getprop("fdm/jsbsim/fcs/show-pilot");
	var show_pilot_helmet = getprop("sim/model/humans/pilot_helmet");
	var show_copilot = getprop("fdm/jsbsim/fcs/show-copilot");
	var mass_copilot = getprop("payload/weight[1]/weight-lb");
	var show_copilot_helmet = getprop("sim/model/humans/copilot_helmet");
	var always_show_humans = getprop("sim/model/humans/always-show-humans");
	
	if ( show_humans ) {
		if ( show_pilot ) {
			pilot = 1;
			if(show_pilot_helmet) pilot = 2;
		}
		if ( show_copilot ) {
			copilot = 1;
			if(show_copilot_helmet) copilot = 2;
		}
	}
	setprop("sim/model/humans/pilot",pilot);
	setprop("sim/model/humans/copilot",copilot);
}
setlistener("fdm/jsbsim/fcs/show-pilot", func() {
	HumansConfig();
});
setlistener("fdm/jsbsim/fcs/show-copilot", func() {
	HumansConfig();
});

#######################################################
## Find and save actual view-number of 'Mirror' view ##
## (to become independent from number of core-views) ##
#######################################################
find_and_save_ViewNumber = func(view_name){
	var list = props.globals.getNode("sim").getChildren("view");
	for(var i = 0; i < size(list); i += 1) {
		var name = list[i].getNode("name").getValue();
		if ( name == view_name ){
			setprop(list[i].getPath()~"/actual-view-number",i);
			return
		}
	}
	print("No view with name '",view_name,"' found!");
}
find_and_save_ViewNumber("Mirror View");
