#########################################################
############## General initializers #####################
#########################################################
#                                                        Guns
var n_gun1_ammo_count = "ai/submodels/submodel[0]/count";
var n_gun2_ammo_count = "ai/submodels/submodel[1]/count";
var n_gun3_ammo_count = "ai/submodels/submodel[2]/count";
var n_gun4_ammo_count = "ai/submodels/submodel[3]/count";
var n_gun5_ammo_count = "ai/submodels/submodel[4]/count";
var n_gun6_ammo_count = "ai/submodels/submodel[5]/count";

#########################################################
##################### reload guns #######################
#########################################################
# Guns generally cannot be reloaded in flight.  It requires landing,
# stop, and reload before taking off again.
#
# Note that tracers are modeled as bullets that include a visual model but
# no impact.  They fire along with 1 of every three or four bullets to simulate
# a tracer round every 4 rounds.

reload_guns  = func {

  var  groundspeed = getprop("velocities/groundspeed-kt");

  # only allow it if on ground or if it's already set to unlimited mode
  if ( groundspeed < 5 or getprop( r_gun1_ammo_count) == -1 ) {

    #                                           Guns
    setprop(n_gun1_ammo_count, 400);
    setprop(n_gun2_ammo_count, 400);
    setprop(n_gun3_ammo_count, 400);
    setprop(n_gun4_ammo_count, 400);
    setprop(n_gun5_ammo_count, 400);
    setprop(n_gun6_ammo_count, 400);

    # controls/armament/trigger1
    setprop("sim/multiplay/generic/int[10]", 0);

    gui.popupTip ("Guns reloaded--400 rounds in each gun.", 5);
  } else {
    gui.popupTip ("You must be on the ground and engines dead stopped to re-load guns.",5);
  }
}

#########################################################
################ unlimited ammo #########################
#########################################################
# For testing only, of course!
#

unlimited_guns = func {

  #                                           Guns
  setprop ( n_gun1_ammo_count, -1);
  setprop ( n_gun2_ammo_count, -1);
  setprop ( n_gun3_ammo_count, -1);
  setprop ( n_gun4_ammo_count, -1);
  setprop ( n_gun5_ammo_count, -1);
  setprop ( n_gun6_ammo_count, -1);

  gui.popupTip ("Guns set to unlimited mode--definitely not realistic and only for testing!  Select 'Reload Guns' to revert to limited ammo.",7);
}

######################################################################
###                                                                ###
###                         Guns fire                              ###
###                                                                ###
### BARANGER Emmanuel aka Helijah 19/01/2026 for F4F Wildcat       ###
######################################################################

fire_MG = func {

  # Guns
  # setprop("/controls/armament/trigger", 1);
  setprop("sim/multiplay/generic/int[10]", 1);
}

stop_MG = func {
  #setprop("/controls/armament/trigger", 0);
  setprop("sim/multiplay/generic/int[10]", 0);
}
