21 March 2018

> **Important**: [Review the documentation](https://docs.projectcalico.org/v3.0/getting-started/kubernetes/upgrade/) carefully before attempting an upgrade.
> You must upgrade to Calico v2.6.5 or later before you can upgrade to Calico v3.0.4.
{: .alert .alert-danger}

#### Bug Fixes

- Fixes a bug where the calico/cni container would ignore termination signals. [cni-plugin #487](https://github.com/projectcalico/cni-plugin/pull/487) (@ketkulka)

- Closes a number of race conditions and failure scenarios in IPAM block allocation and releasing. [libcalico-go #819](https://github.com/projectcalico/libcalico-go/pull/819) (@caseydavenport)

- Improves log output around IPAM block allocation and releasing. [libcalico-go #819](https://github.com/projectcalico/libcalico-go/pull/819) (@caseydavenport)

- Fixes a bug where IPs could be assigned from disabled IP pools. [libcalico-go #819](https://github.com/projectcalico/libcalico-go/pull/819) (@ozdanborne)

- Fixes a rare bug where a node could, in some circumstances, advertise /26 blocks that it didn't own [calico #1751](https://github.com/projectcalico/calico/pull/1751) (@caseydavenport)

#### Limitations

- **Offers only Kubernetes, OpenShift, and host endpoint integrations**: the
  OpenStack, Mesos, DC/OS, rkt, and Docker orchestrators have not been tested
  and are not supported. (Calico still supports Docker and rkt containers.)
  We plan to resume support for the OpenStack, Mesos, DC/OS, and Docker
  orchestrators in a future release.

- **GoBGP not supported**: Setting the `CALICO_NETWORKING_BACKEND` environment
  variable to `gobgp` is not supported. See [Configuring calico/node](https://docs.projectcalico.org/v3.0/reference/node/configuration)
  for more information. We plan to resume support for GoBPG in a future release.

- **Route reflectors cannot be clustered**: We plan to resume support for
  this in a future release.
