18 Oct 2019

#### Support top-level namespace and service account network policy selectors

Calico now supports two new top-level selectors to make writing Calico network policy easier. The `namespaceSelector` allows you to select the namespace(s) to apply a global network policy to.
This enables you to write a single network policy applicable to one or more namespaces. The `serviceAccountSelector` allows you apply a network policy only to the endpoints which have the specified service accounts attached to them.
This selector can be useful in writing network policy to target endpoints with specific service accounts.

For more information please see the how-to documentation for [namespace selectors](https://docs.projectcalico.org/v3.10/security/namespace-policy) and [service account selectors](https://docs.projectcalico.org/v3.10/security/service-accounts).

 - Support top-level namespaceSelector for global network policies and serviceAccountSelector for global and namespaced network policies [libcalico-go #1133](https://github.com/projectcalico/libcalico-go/pull/1133) (@rafaelvanoni)

#### Advertisement of Kubernetes Service ExternalIPs

Calico now supports BGP advertisement of Kubernetes service ExternalIPs in addition to advertising ClusterIPs. Advertising service external IPs allows for more flexible routing architectures.
Along with this feature, we moved the configuration of ClusterIPs into BGPConfiguration (along with ExternalIPs) and have deprecated the environment variable `CALICO_ADVERTISE_CLUSTER_IPS`.
We recommend replacing the deprecated `CALICO_ADVERTISE_CLUSTER_IPS` with a corresponding default BGPConfiguration resource.

For more information please see the [service advertisement how-to](https://docs.projectcalico.org/v3.10/networking/advertise-service-ips)

 - Support sending BGP advertisements for Kubernetes Service External IPs that fall within a set of whitelisted CIDR blocks. [libcalico-go #1123](https://github.com/projectcalico/libcalico-go/pull/1123) (@tompntn)
 - Advertise Whitelisted Service External IP's. [confd # 266](https://github.com/projectcalico/confd/pull/266) (@tompntn)
 - Configuration of Kubernetes service Cluster IP advertisement through BGPConfiguration resource. [libcalico-go #1134](https://github.com/projectcalico/libcalico-go/pull/1134) (@caseydavenport)
 - Support datastore-driven clusterIP updates. [confd # 272](https://github.com/projectcalico/confd/pull/272) (@caseydavenport)

#### calicoctl patch

calicoctl now supports the `patch` command and is similar to how `kubectl patch` works. The calicoctl patch command allows you update Calico resources in-place.
This feature improves the user experience of calicoctl by making it easier to modify Calico resources and making calicoctl feel more like kubectl.

For more information please see the reference page for [calicocctl patch](https://docs.projectcalico.org/v3.10/reference/calicoctl/patch).

 - Add calicoctl `patch`. [calicoctl #2054](https://github.com/projectcalico/calicoctl/pull/2054) (@syscll)

#### Bug fixes

 - Fix returning of resp.Body.Close() error. [node #329](https://github.com/projectcalico/node/pull/329) (@xieyanker)
 - Fix erroneous "Partial success" output. [calicoctl #2070](https://github.com/projectcalico/calicoctl/pull/2070) (@lmm)
 - Fix logging to be independent of go mod versions. [libcalico-go #1127](https://github.com/projectcalico/libcalico-go/pull/1127) (@neiljerram)

#### Other changes

 - Update calico/node to use a version of calico/bird based on upstream BIRD v1.6.7. [node #314](https://github.com/projectcalico/node/pull/314) (@neiljerram)
 - Add semaphore config. [node #324](https://github.com/projectcalico/node/pull/324) (@neiljerram)
 - The default IP pool block size is now configurable. Use the `CALICO_IPV4POOL_BLOCK_SIZE` and `CALICO_IPV6POOL_BLOCK_SIZE` environment variables to configure the default pool block size. [node #346](https://github.com/projectcalico/node/pull/346) (@halfcrazy)
 - The `CALICO_IPV4POOL_NODE_SELECTOR` and `CALICO_IPV6POOL_NODE_SELECTOR` environment variables were added for configuring default pool node selectors. [node #346](https://github.com/projectcalico/node/pull/346) (@tmjd)
 - Update calicoctl alpine image to 3.10. [calicoctl #2061](https://github.com/projectcalico/calicoctl/pull/2061) (@chenrui333)
 - Re-enable golangci-lint linters and fix lint warnings. [felix #2130](https://github.com/projectcalico/felix/pull/2130) (@rafaelvanoni)
 - Add support to watch stderr for FV containers. [felix #2137](https://github.com/projectcalico/felix/pull/2137)(@song-jiang)
 - Reduce severity of BPF log levels. [felix #2144](https://github.com/projectcalico/felix/pull/2144) (@tmjd)
 - Fix felix log level. [felix #2147](https://github.com/projectcalico/felix/pull/2147) (@neiljerram)
 - Run typha as non-root user. [typha #312](https://github.com/projectcalico/typha/pull/312)
 - Improve log for check command failing. [confd #271](https://github.com/projectcalico/confd/pull/271) (@neiljerram)
 - Move some testutils functions to utils_linux.go. [cni-plugin #787](https://github.com/projectcalico/cni-plugin/pull/787) (@song-jiang)
 - Add assertion that CI builds do not result in dirty state. [cni-plugin #790](https://github.com/projectcalico/cni-plugin/pull/790) (@caseydavenport)
 - Handle removing node for flannel migration controller. [kube-controllers #404](https://github.com/projectcalico/kube-controllers/pull/404) (@song-jiang)
 - Add flannel migration FV. [kube-controllers #406](https://github.com/projectcalico/kube-controllers/pull/406) (@song-jiang)
 - Ignore Windows reserved addresses. [libcalico-go #1129](https://github.com/projectcalico/libcalico-go/pull/1129) (@caseydavenport)
 - Use Kubernetes 1.16 in tests. [libcalico-go #1131](https://github.com/projectcalico/libcalico-go/pull/1131) (@caseydavenport)
 - Update Kubernetes client-go v12.0.0 for BoundServiceAccountTokenVolume support. [libcalico-go #1139](https://github.com/projectcalico/libcalico-go/pull/1139) (@caseydavenport)
 - Improve error handling when attaching FlexVolume mounts. [pod2daemon #23](https://github.com/projectcalico/pod2daemon/pull/23) (@rafaelvanoni)
 - Fix code warnings. [libcalico-go #1132](https://github.com/projectcalico/libcalico-go/pull/1132) (@beautytiger)
 - Clean up code. [felix #2150](https://github.com/projectcalico/felix/pull/2150) (@beautytiger)

