---
title: Getting Involved
canonical_url: 'https://docs.projectcalico.org/v3.2/reference/involved'
---

Calico is an open source project, and we'd love you to get involved.
Whether that might be by reading and participating on our slack,
or by diving into the code to propose enhancements or integrate with
other systems. To see the options for getting involved with Calico the
project, please take a look at the following.

## Join us on Slack

Our [public slack](https://slack.projectcalico.org) is the quickest way to get
in touch for help debugging any issues with Calico.

## Read the Source, Luke!

All of Calico's code is on [GitHub](https://github.com/projectcalico).  The following
list contains the most commonly encountered repositories:

Repository         | Description
-------------------|----------------------------
[felix](https://github.com/projectcalico/felix) | The felix policy enforcement agent.
[calicoctl](https://github.com/projectcalico/calicoctl) | Home of the calico/node and calicoctl components.
[cni-plugin](https://github.com/projectcalico/cni-plugin) | The Calico CNI plugin.
[libnetwork-plugin](https://github.com/projectcalico/libnetwork-plugin) | The Calico libnetwork plugin for Docker.
[k8s-policy](https://github.com/projectcalico/k8s-policy) | Kubernetes policy controller.
[libcalico](https://github.com/projectcalico/libcalico) | Python Calico library.
[libcalico-go](https://github.com/projectcalico/libcalico-go) | Golang Calico library.

## Contributing

Calico follows the "Fork & Pull" model of collaborative development,
with changes being offered to the main Calico codebase via Pull
Requests. So you can contribute a fix, change or enhancement by forking
one of our repositories and making a GitHub pull request. If you're
interested in doing that:

-   Thanks!
-   See the [GitHub docs](https://help.github.com/articles/using-pull-requests) for how
    to create a Pull Request.
-   Check our [contibution guide](contribute) for more information.
