---
title: Workload endpoint
description: API for this Calico resource.
canonical_url: '/reference/resources/workloadendpoint'
---

A workload endpoint resource (`WorkloadEndpoint`) represents an interface
connecting a {{site.prodname}} networked container or VM to its host.

Each endpoint may specify a set of labels and list of profiles that {{site.prodname}} will use
to apply policy to the interface.

A workload endpoint is a namespaced resource, that means a
[NetworkPolicy]({{ site.baseurl }}/reference/resources/networkpolicy)
in a specific namespace only applies to the WorkloadEndpoint in that namespace.
Two resources are in the same namespace if the namespace value is set the same
on both.

> **Note**: While `calicoctl` allows the user to fully manage Workload Endpoint resources,
> the lifecycle of these resources is generally handled by an orchestrator-specific
> plugin such as the {{site.prodname}} CNI plugin, the {{site.prodname}} Docker network plugin,
> or the {{site.prodname}} OpenStack Neutron Driver. In general, we recommend that you only
> use `calicoctl` to view this resource type.
{: .alert .alert-info}


### Sample YAML

```yaml
apiVersion: projectcalico.org/v3
kind: WorkloadEndpoint
metadata:
  name: node1-k8s-my--nginx--b1337a-eth0
  namespace: default
  labels:
    app: frontend
    projectcalico.org/namespace: default
    projectcalico.org/orchestrator: k8s
spec:
  node: node1
  orchestrator: k8s
  endpoint: eth0
  containerID: 1337495556942031415926535
  pod: my-nginx-b1337a
  endpoint: eth0
  interfaceName: cali0ef24ba
  mac: ca:fe:1d:52:bb:e9
  ipNetworks:
  - 192.168.0.0/32
  profiles:
  - profile1
  ports:
  - name: some-port
    port: 1234
    protocol: TCP
  - name: another-port
    port: 5432
    protocol: UDP
```

### Definitions

#### Metadata

| Field     | Description                                                        | Accepted Values                                          | Schema | Default   |
|-----------|--------------------------------------------------------------------|----------------------------------------------------------|--------|-----------|
| name      | The name of this workload endpoint resource. Required.             |  Alphanumeric string with optional `.`, `_`, or `-`      | string |           |
| namespace | Namespace provides an additional qualification to a resource name. |                                                          | string | "default" |
| labels    | A set of labels to apply to this endpoint.                         |                                                          |   map  |           |

#### Spec

| Field          | Description                                                   | Accepted Values | Schema                                 | Default |
|----------------|---------------------------------------------------------------|-----------------|----------------------------------------|---------|
| workload       | The name of the workload to which this endpoint belongs.      |                 | string                                 |
| orchestrator   | The orchestrator that created this endpoint.                  |                 | string                                 |
| node           | The node where this endpoint resides.                         |                 | string                                 |
| containerID    | The CNI CONTAINER_ID of the workload endpoint.                |                 | string                                 |
| pod            | Kubernetes pod name for this workload endpoint.               |                 | string                                 |
| endpoint       | Container network interface name.                             |                 | string                                 |
| ipNetworks     | The CIDRs assigned to the interface.                          |                 | List of strings                        |
| ipNATs         | List of 1:1 NAT mappings to apply to the endpoint.            |                 | List of [IPNATs](#ipnat)               |
| ipv4Gateway    | The gateway IPv4 address for traffic from the workload.       |                 | string                                 |
| ipv6Gateway    | The gateway IPv6 address for traffic from the workload.       |                 | string                                 |
| profiles       | List of profiles assigned to this endpoint.                   |                 | List of strings                        |
| interfaceName  | The name of the host-side interface attached to the workload. |                 | string                                 |
| mac            | The source MAC address of traffic generated by the workload.  |                 | IEEE 802 MAC-48, EUI-48, or EUI-64     |
| ports          | List on named ports that this workload exposes.               |                 | List of [WorkloadEndpointPorts](#endpointport) |


#### IPNAT

{% include content/ipnat.md %}

#### EndpointPort

A WorkloadEndpointPort associates a name with a particular TCP/UDP/SCTP port of the endpoint, allowing it to
be referenced as a named port in [policy rules](./networkpolicy#entityrule).

| Field    | Description                                                                                                                                            | Accepted Values      | Schema | Default  |
|----------|--------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------|--------|----------|
| name     | The name to attach to this port, allowing it to be referred to in [policy rules](./networkpolicy#entityrule). Names must be unique within an endpoint. |                      | string |          |
| protocol | The protocol of this named port.                                                                                                                       | `TCP`, `UDP`, `SCTP` | string |          |
| port     | The workload port number.                                                                                                                              | `1`-`65535`          | int    |          |
| hostPort | Port on the host that is forwarded to this port.                                                                                                       | `1`-`65535`          | int    |          |
| hostIP   | IP address on the host on which the hostPort is accessible.                                                                                            | `1`-`65535`          | int    |          |

> **Note**: On their own, WorkloadEndpointPort entries don't result in any change to the connectivity of the port.
> They only have an effect if they are referred to in policy.
{: .alert .alert-info}

> **Note**: The hostPort and hostIP fields are read-only and determined from Kubernetes hostPort configuration.
> These fields are used only when host ports are enabled in Calico.
{: .alert .alert-info}


### Supported operations

| Datastore type        | Create/Delete | Update | Get/List | Notes
|-----------------------|---------------|--------|----------|------
| etcdv3                | Yes           | Yes    | Yes      |
| Kubernetes API server | No            | Yes    | Yes      | WorkloadEndpoints are directly tied to a Kubernetes pod.
