30 May 2018

> **Important**: [Review the documentation](https://docs.projectcalico.org/v3.0/getting-started/kubernetes/upgrade/) carefully before attempting an upgrade.
> You must upgrade to {{site.prodname}} v2.6.5 or later before you can upgrade to {{site.prodname}} v3.0.8.
{: .alert .alert-danger}

#### Bug Fixes

 - Fix a bug in the CNI plugin where IP allocations were not properly updated on container restart [cni-plugin #537](https://github.com/projectcalico/cni-plugin/pull/537) (@caseydavenport)
 - The install-cni container now maintains the original mode on certificates copied from Kubernetes secrets. [cni-plugin #531](https://github.com/projectcalico/cni-plugin/pull/531) (@caseydavenport)
 - The install-cni container now writes the calico-kubeconfig file with mode 600 by default. It can be configured by setting the KUBECONFIG_MODE option. [cni-plugin #531](https://github.com/projectcalico/cni-plugin/pull/531) (@caseydavenport)
 - The install-cni container now only writes the calico-kubeconfig file when running as a Kubernetes pod. [cni-plugin #531](https://github.com/projectcalico/cni-plugin/pull/531) (@caseydavenport)
 - Fix etcd cert file existence check in calico/cni [cni-plugin #531](https://github.com/projectcalico/cni-plugin/pull/531) (@bjhaid)
 - When run as a pod, CNI will be configured with the Kubernetes certificate authority for TLS verification. [cni-plugin #531](https://github.com/projectcalico/cni-plugin/pull/531) (@tmjd)
 - For updated Kubernetes clusters that allow it, you may include both a pod and namespace selector on a NetworkPolicyPeer. [libcalico-go #871](https://github.com/projectcalico/libcalico-go/pull/871) (@spikecurtis)
 - Fix a bug where IPAM would not use existing IP blocks. [libcalico-go #869](https://github.com/projectcalico/libcalico-go/pull/869) (@gunjan5)

#### Limitations

- **Offers only Kubernetes, OpenShift, and host endpoint integrations**: the
  OpenStack, Mesos, DC/OS, rkt, and Docker orchestrators have not been tested
  and are not supported. ({{site.prodname}} still supports Docker and rkt containers.)
  We plan to resume support for the OpenStack, Mesos, DC/OS, and Docker
  orchestrators in a future release.

- **GoBGP not supported**: Setting the `CALICO_NETWORKING_BACKEND` environment
  variable to `gobgp` is not supported. See [Configuring {{site.nodecontainer}}](https://docs.projectcalico.org/v3.0/reference/node/configuration)
  for more information. We plan to resume support for GoBGP in a future release.

- **Route reflectors cannot be clustered**: We plan to resume support for
  this in a future release.
