09 Mar 2019

#### Calico IPAM for Kubernetes API datastore

You now have full feature parity for Calico IP address management (IPAM) irrespective of the datastore you are using with your Calico deployment. This enables all of Calico’s
IP address management features, such as multiple IP pools, per-pod, per-namespace, and per-node pool specification when using the Kubernetes API datastore
in addition to existing etcdv3 support.

Upgrading existing clusters using Calico with host-local IPAM is seamless - simply apply the v3.6 manifest and you’ll be using Calico IPAM!

GitHub PRs:
 - [libcalico-go #1010](https://github.com/projectcalico/libcalico-go/pull/1010) (@caseydavenport, @briansan)
 - [cni-plugin #683](https://github.com/projectcalico/cni-plugin/pull/683) (@briansan)
 - [cni-plugin #684](https://github.com/projectcalico/cni-plugin/pull/684) (@lwr20, @song-jiang)
 - [kube-controllers #340](https://github.com/projectcalico/kube-controllers/pull/340) (@caseydavenport)

#### Openstack enhancements

Calico v3.6 has several enhancements for your Openstack deployments for better operational efficiency and resiliency. Now you can write Calico policy rules with
substring matches which helps you collapse the number of rules in your deployments. Calico v3.6 now also supports multi-region environments.

GitHub PRs / commits:
 - [networking-calico changes](https://github.com/openstack/networking-calico/compare/3.4.0...3.6.0) (@neiljerram)
 - [libcalico-go #994](https://github.com/projectcalico/libcalico-go/pull/994) (@neiljerram)

#### Bug fixes

 - Fix issue in BIRD readiness reporting which can result in multiple nodes restarting at once [node #162](https://github.com/projectcalico/node/pull/162) (@tathagatachowdhury)
 - Fix kube-controllers performing unnecessary reprogramming of profiles [libcalico-go #1012](https://github.com/projectcalico/libcalico-go/pull/1012) (@song-jiang)
 - calico/node in route reflector mode now advertises service ClusterIPs to peers outside of the cluster. [confd #206](https://github.com/projectcalico/confd/pull/206) (@roshanirathi)

#### Other changes

 - Removed unnecessary logging in Dikastes for HTTP requests. [app-policy #70](https://github.com/projectcalico/app-policy/pull/70) (@song-jiang)
 - Selector syntax now supports operators for substring matching: "contains", "starts with" and "ends with". [libcalico-go #1036](https://github.com/projectcalico/libcalico-go/pull/1036) (@fasaxc)
 - Removed support for the K8S_API_TOKEN environment variable [libcalico-go #1023](https://github.com/projectcalico/libcalico-go/pull/1023) (@tathagatachowdhury)
 - OpenStack VM endpoints now have a label for the parent ID of the VM's project. [calico #2411](https://github.com/projectcalico/calico/pull/2411) (@neiljerram)
 - The CALICO_ROUTER_ID environment variable now supports a special value "hash", which derives the router ID from the nodename.  This is useful for IPv6-only systems. [confd #223](https://github.com/projectcalico/confd/pull/223) (@roshanirathi)
