/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.User;
import java.util.Date;

public class IRSIM
extends Output {
    public static void writeIRSIMFile(Cell cell, VarContext context, String filePath) {
        IRSIM out = new IRSIM();
        out.writeNetlist(cell, context, filePath);
    }

    private void writeNetlist(Cell cell, VarContext context, String filePath) {
        if (this.openTextOutputStream(filePath)) {
            return;
        }
        this.writeHeader(cell);
        IRSIMNetlister netlister = new IRSIMNetlister();
        Netlist netlist = cell.getNetlist(true);
        HierarchyEnumerator.enumerateCell(cell, context, netlist, netlister);
        if (this.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    private IRSIM() {
    }

    private void writeHeader(Cell cell) {
        double scale = Technology.getCurrent().getScale() / 10.0;
        this.printWriter.println("| units: " + scale + " tech: mocmos format: SU");
        this.printWriter.println("| IRSIM file for cell " + cell.noLibDescribe() + " from library " + cell.getLibrary().getName());
        this.emitCopyright("| ", "");
        if (User.isIncludeDateAndVersionInOutput()) {
            this.printWriter.println("| Created on " + TextUtils.formatDate(cell.getCreationDate()));
            this.printWriter.println("| Last revised on " + TextUtils.formatDate(cell.getRevisionDate()));
            this.printWriter.println("| Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion());
        } else {
            this.printWriter.println("| Written by Electric VLSI Design System");
        }
    }

    private class IRSIMCellInfo
    extends HierarchyEnumerator.CellInfo {
        private float mFactor;

        private IRSIMCellInfo() {
        }

        protected void extInit() {
            HierarchyEnumerator.CellInfo parent = this.getParentInfo();
            this.mFactor = parent == null ? 1.0f : ((IRSIMCellInfo)parent).getMFactor();
            Nodable ni = this.getContext().getNodable();
            if (ni == null) {
                return;
            }
            Variable mvar = ni.getVar("ATTR_M");
            if (mvar == null) {
                return;
            }
            Object mval = this.getContext().evalVar(mvar, null);
            if (mval == null) {
                return;
            }
            this.mFactor *= VarContext.objectToFloat(mval, 1.0f);
        }

        protected float getMFactor() {
            return this.mFactor;
        }
    }

    private class IRSIMNetlister
    extends HierarchyEnumerator.Visitor {
        private IRSIMNetlister() {
        }

        public HierarchyEnumerator.CellInfo newCellInfo() {
            return new IRSIMCellInfo();
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            ((IRSIMCellInfo)info).extInit();
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            IRSIMCellInfo iinfo = (IRSIMCellInfo)info;
            NodeProto np = no.getProto();
            if (!(np instanceof PrimitiveNode)) {
                return true;
            }
            PrimitiveNode pn = (PrimitiveNode)np;
            NodeInst ni = (NodeInst)no;
            if (!ni.isPrimitiveTransistor()) {
                return false;
            }
            boolean isNMOS = false;
            if (ni.getFunction() == NodeProto.Function.TRANMOS || ni.getFunction() == NodeProto.Function.TRA4NMOS) {
                isNMOS = true;
            }
            PortInst g = ni.getTransistorGatePort();
            PortInst d = ni.getTransistorDrainPort();
            PortInst s = ni.getTransistorSourcePort();
            if (g == null || d == null || s == null) {
                System.out.println("PortInst for " + ni + " null!");
                return false;
            }
            Netlist netlist = info.getNetlist();
            JNetwork gnet = netlist.getNetwork(g);
            JNetwork dnet = netlist.getNetwork(d);
            JNetwork snet = netlist.getNetwork(s);
            if (gnet == null || dnet == null || snet == null) {
                System.out.println("Warning, ignoring unconnected transistor " + ni + " in cell " + iinfo.getCell());
                return false;
            }
            if (isNMOS) {
                IRSIM.this.printWriter.print("n");
            } else {
                IRSIM.this.printWriter.print("p");
            }
            IRSIM.this.printWriter.print(" " + iinfo.getUniqueNetName(gnet, "/"));
            IRSIM.this.printWriter.print(" " + iinfo.getUniqueNetName(snet, "/"));
            IRSIM.this.printWriter.print(" " + iinfo.getUniqueNetName(dnet, "/"));
            Dimension2D dim = ni.getTransistorSize(iinfo.getContext());
            float m = iinfo.getMFactor();
            IRSIM.this.printWriter.print(" " + dim.getHeight());
            IRSIM.this.printWriter.print(" " + (double)m * dim.getWidth());
            IRSIM.this.printWriter.print(" " + ni.getAnchorCenterX());
            IRSIM.this.printWriter.print(" " + ni.getAnchorCenterY());
            if (isNMOS) {
                IRSIM.this.printWriter.print(" g=S_gnd");
            } else {
                IRSIM.this.printWriter.print(" g=S_vdd");
            }
            double sourceArea = 0.0;
            double sourcePerim = 0.0;
            double drainArea = 0.0;
            double drainPerim = 0.0;
            IRSIM.this.printWriter.print(" s=A_" + sourceArea + ",P_" + sourcePerim);
            IRSIM.this.printWriter.print(" d=A_" + drainArea + ",P_" + drainPerim);
            IRSIM.this.printWriter.println();
            return false;
        }
    }
}

