/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.NccRandom;
import com.sun.electric.tool.ncc.basic.Messenger;
import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.jemNets.NccNetlist;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NccGlobals {
    private static final int CODE_PART = 0;
    private static final int CODE_WIRE = 1;
    private static final int CODE_PORT = 2;
    private NccRandom randGen = new NccRandom();
    private final NccOptions options;
    private final Messenger messenger;
    private EquivRecord root;
    private EquivRecord parts;
    private EquivRecord wires;
    private EquivRecord ports;
    private Cell[] rootCells;
    public int passNumber;

    private List getNetObjs(int code, NccNetlist nets) {
        switch (code) {
            case 0: {
                return nets.getPartArray();
            }
            case 1: {
                return nets.getWireArray();
            }
            case 2: {
                return nets.getPortArray();
            }
        }
        this.messenger.error(true, "invalid code");
        return null;
    }

    private EquivRecord buildEquivRec(int code, List nccNets) {
        boolean atLeastOneNetObj = false;
        ArrayList<Circuit> ckts = new ArrayList<Circuit>();
        Iterator it = nccNets.iterator();
        while (it.hasNext()) {
            NccNetlist nets = (NccNetlist)it.next();
            List netObjs = this.getNetObjs(code, nets);
            if (netObjs.size() != 0) {
                atLeastOneNetObj = true;
            }
            ckts.add(Circuit.please(netObjs));
        }
        if (!atLeastOneNetObj) {
            return null;
        }
        return EquivRecord.newLeafRecord(code, ckts, this);
    }

    public NccGlobals(NccOptions options) {
        this.options = options;
        this.messenger = new Messenger(true);
    }

    public void setInitialNetlists(List nccNets) {
        this.parts = this.buildEquivRec(0, nccNets);
        this.wires = this.buildEquivRec(1, nccNets);
        this.ports = this.buildEquivRec(2, nccNets);
        ArrayList<EquivRecord> el = new ArrayList<EquivRecord>();
        if (this.parts != null) {
            el.add(this.parts);
        }
        if (this.wires != null) {
            el.add(this.wires);
        }
        if (this.ports != null) {
            el.add(this.ports);
        }
        this.root = EquivRecord.newRootRecord(el);
        this.rootCells = new Cell[nccNets.size()];
        int i = 0;
        Iterator it = nccNets.iterator();
        while (it.hasNext()) {
            NccNetlist nl = (NccNetlist)it.next();
            this.rootCells[i] = nl.getRootCell();
            ++i;
        }
    }

    public EquivRecord getRoot() {
        return this.root;
    }

    public EquivRecord getParts() {
        return this.parts;
    }

    public EquivRecord getWires() {
        return this.wires;
    }

    public EquivRecord getPorts() {
        return this.ports;
    }

    public int getNumNetlistsBeingCompared() {
        return this.rootCells.length;
    }

    public Cell[] getRootCells() {
        return this.rootCells;
    }

    public String[] getRootCellNames() {
        String[] rootCellNames = new String[this.rootCells.length];
        for (int i = 0; i < this.rootCells.length; ++i) {
            rootCellNames[i] = NccUtils.fullName(this.rootCells[i]);
        }
        return rootCellNames;
    }

    public void println(String msg) {
        if (this.options.verbose) {
            this.messenger.println(msg);
        }
    }

    public void println() {
        if (this.options.verbose) {
            this.messenger.println();
        }
    }

    public void print(String msg) {
        if (this.options.verbose) {
            this.messenger.print(msg);
        }
    }

    public void flush() {
        this.messenger.flush();
    }

    public void error(boolean pred, String msg) {
        this.messenger.error(pred, msg);
    }

    public void error(String msg) {
        this.messenger.error(true, msg);
    }

    public NccOptions getOptions() {
        return this.options;
    }

    public int getRandom() {
        return this.randGen.next();
    }

    public Messenger getMessenger() {
        return this.messenger;
    }
}

