/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.jemNets;

import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.jemNets.Part;
import com.sun.electric.tool.ncc.jemNets.PinType;
import com.sun.electric.tool.ncc.jemNets.Wire;
import java.util.HashSet;
import java.util.Set;

public class Resistor
extends Part {
    private static final Set PIN_TYPES = new HashSet();
    private static final int[] TERM_COEFFS;
    private float resistance;

    private void flip() {
        Wire w = this.pins[0];
        this.pins[0] = this.pins[1];
        this.pins[1] = w;
    }

    public Resistor(String name, double resist, Wire w1, Wire w2) {
        super(name, new Wire[]{w1, w2});
        this.resistance = (float)resist;
    }

    public boolean isThisGate(int x) {
        return false;
    }

    public int[] getTermCoefs() {
        return TERM_COEFFS;
    }

    public String valueString() {
        String sz = "R= " + this.resistance;
        return sz;
    }

    public Integer hashCodeForParallelMerge() {
        int hc = this.pins[0].hashCode() + this.pins[1].hashCode() + this.getClass().hashCode();
        return new Integer(hc);
    }

    public float resistance() {
        return this.resistance;
    }

    public boolean touchesAtGate(Wire w) {
        return false;
    }

    public void connect(Wire ss, Wire ee) {
        this.pins[0] = ss;
        this.pins[1] = ee;
        ss.add(this);
        ee.add(this);
    }

    public boolean parallelMerge(Part p) {
        if (p.getClass() != this.getClass()) {
            return false;
        }
        if (this == p) {
            return false;
        }
        Resistor r = (Resistor)p;
        if (this.pins[0] != r.pins[0]) {
            r.flip();
        }
        if (this.pins[0] != r.pins[0] || this.pins[1] != r.pins[1]) {
            return false;
        }
        float ff = 0.0f;
        float pp = r.resistance();
        float mm = this.resistance();
        if (pp != 0.0f && mm != 0.0f) {
            ff = ff * mm / (ff + mm);
        }
        this.resistance = ff;
        r.deleteMe();
        return true;
    }

    public int typeCode() {
        return 0;
    }

    public Set getPinTypes() {
        return PIN_TYPES;
    }

    public String typeString() {
        return "Resistor";
    }

    public String connectionString(int n) {
        String s = this.pins[0].getName();
        String e = this.pins[1].getName();
        return "S= " + s + " E= " + e;
    }

    public String connectionString(Wire w) {
        String s = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (s.length() != 0) {
                s = s + ",";
            }
            s = s + (i == 0 ? "S" : "E");
        }
        return s;
    }

    static {
        PIN_TYPES.add(new ResistorPinType());
        TERM_COEFFS = new int[]{Primes.get(1), Primes.get(1)};
    }

    private static class ResistorPinType
    implements PinType {
        private ResistorPinType() {
        }

        public int numConnectionsToPinOfThisType(Part p, Wire w) {
            int numConns = 0;
            for (int i = 0; i < p.pins.length; ++i) {
                if (p.pins[i] != w) continue;
                ++numConns;
            }
            return numConns;
        }

        public String description() {
            return "Resistor pin";
        }
    }
}

