/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.TextUtils;

public class CellName
implements Comparable {
    private final String name;
    private final View view;
    private final int version;
    private final int hash;

    private CellName(String name, View view, int version) {
        this.name = name;
        this.view = view;
        this.version = version;
        int h = 0;
        for (int i = 0; i < name.length(); ++i) {
            h = 31 * h + Character.toLowerCase(name.charAt(i));
        }
        h = h * 37 + view.getOrder();
        this.hash = h = h * 17 + version;
    }

    public String getName() {
        return this.name;
    }

    public View getView() {
        return this.view;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CellName) {
            CellName n = (CellName)obj;
            return this.hash == n.hash && this.name.equalsIgnoreCase(n.name) && this.view == n.view && this.version == n.version;
        }
        return false;
    }

    public boolean equalsIgnoreVersion(Object obj) {
        if (obj instanceof CellName) {
            CellName n = (CellName)obj;
            return this.name.equalsIgnoreCase(n.name) && this.view == n.view;
        }
        return false;
    }

    public int compareTo(Object o) {
        CellName n = (CellName)o;
        int cmp = TextUtils.nameSameNumeric(this.name, n.name);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.view.compareTo(n.view);
        if (cmp != 0) {
            return cmp;
        }
        if (this.version > 0) {
            return n.version > 0 ? n.version - this.version : 1;
        }
        return n.version > 0 ? -1 : 0;
    }

    public String toString() {
        return this.name + ";" + this.version + "{" + this.view.getAbbreviation() + "}";
    }

    public static CellName parseName(String name) {
        int nameEnd;
        String viewName;
        if (name == null) {
            return null;
        }
        View view = View.UNKNOWN;
        int openCurly = name.indexOf(123);
        int closeCurly = name.lastIndexOf(125);
        if (openCurly != -1 && closeCurly != -1 && (view = View.findView(viewName = name.substring(openCurly + 1, closeCurly))) == null) {
            System.out.println("Unknown view: " + viewName);
            return null;
        }
        int version = 0;
        int semiColon = name.indexOf(59);
        if (semiColon != -1) {
            String versionString = openCurly > semiColon ? name.substring(semiColon + 1, openCurly) : name.substring(semiColon + 1);
            try {
                version = Integer.parseInt(versionString);
            }
            catch (NumberFormatException e) {
                System.out.println(versionString + "is not a valid cell version number");
                return null;
            }
            if (version <= 0) {
                System.out.println("Cell versions must be positive, this is " + version);
                return null;
            }
        }
        if (semiColon == -1) {
            semiColon = name.length();
        }
        if (openCurly == -1) {
            openCurly = name.length();
        }
        if ((name = name.substring(0, nameEnd = Math.min(semiColon, openCurly))).length() == 0) {
            System.out.println("Cell name can't be empty");
            return null;
        }
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch != '\n' && ch != '}' && ch != ';' && ch != '|' && ch != ':') continue;
            System.out.println("Cell name " + name + " has invalid char '" + ch + "'");
            return null;
        }
        CellName n = new CellName(name, view, version);
        return n;
    }

    public static CellName newName(String name, View view, int version) {
        if (view == null) {
            view = View.UNKNOWN;
        }
        if (version < 0) {
            version = 0;
        }
        CellName n = CellName.parseName(name);
        CellName nn = new CellName(n.getName(), view, version);
        return nn;
    }
}

