/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.menus.MenuBar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;

public class ToolBarButton
extends AbstractButton
implements Accessible,
ActionListener {
    private static HashMap allButtons = new HashMap(15);
    public static ToolBarButton updater = new ToolBarButton(null, null);
    private String name;
    private static final ButtonLogger buttonLogger = new ButtonLogger();
    private static final String uiClassIDdefault = "ButtonUI";
    private static final String uiClassIDtoggle = "ToggleButtonUI";
    private String uiClassID;

    private ToolBarButton(String text, Icon icon) {
        this.setModel(new JToggleButton.ToggleButtonModel());
        this.uiClassID = uiClassIDtoggle;
        this.init(null, icon);
        this.name = text;
    }

    public String getName() {
        return this.name;
    }

    public static ToolBarButton newInstance(String text, Icon icon) {
        ArrayList buttonGroup;
        ToolBarButton b = new ToolBarButton(text, icon);
        b.addActionListener(MenuBar.repeatLastCommandListener);
        b.addActionListener(updater);
        b.addActionListener(MenuBar.MenuBarGroup.getUpdaterFor(""));
        b.addActionListener(buttonLogger);
        if (!allButtons.containsKey(text)) {
            buttonGroup = new ArrayList();
            allButtons.put(text, buttonGroup);
        } else {
            buttonGroup = (ArrayList)allButtons.get(text);
        }
        buttonGroup.add(b);
        return b;
    }

    public void addActionListener(ActionListener l) {
        this.removeActionListener(buttonLogger);
        super.addActionListener(l);
        super.addActionListener(buttonLogger);
    }

    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        String name = source instanceof ToolBarButton ? ((ToolBarButton)source).getName() : source.getText();
        ArrayList list = (ArrayList)allButtons.get(name);
        if (list == null) {
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            AbstractButton b = (AbstractButton)it.next();
            if (b == source) continue;
            String name2 = source instanceof ToolBarButton ? ((ToolBarButton)source).getName() : source.getText();
            b.setSelected(source.isSelected());
        }
    }

    public static void setIconForButton(String name, Icon icon) {
        ArrayList list = (ArrayList)allButtons.get(name);
        if (list == null) {
            return;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            AbstractButton b = (AbstractButton)it.next();
            b.setIcon(icon);
        }
    }

    public static boolean getButtonState(String name) {
        ArrayList list = (ArrayList)allButtons.get(name);
        if (list == null) {
            return false;
        }
        AbstractButton b = (AbstractButton)list.get(0);
        return b.isSelected();
    }

    public static void doClick(String name) {
        ArrayList list = (ArrayList)allButtons.get(name);
        if (list == null) {
            return;
        }
        AbstractButton b = (AbstractButton)list.get(0);
        b.doClick();
    }

    public void finished() {
        ActionListener[] actionListeners = this.getActionListeners();
        for (int j = 0; j < actionListeners.length; ++j) {
            ActionListener actionListener = actionListeners[j];
            this.removeActionListener(actionListener);
        }
        ArrayList list = (ArrayList)allButtons.get(this.getName());
        if (list == null) {
            return;
        }
        list.remove(this);
    }

    public void updateUI() {
        this.setUI((ButtonUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return this.uiClassID;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJButton
    extends AbstractButton.AccessibleAbstractButton {
        protected AccessibleJButton() {
            super(ToolBarButton.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }
    }

    private static class ButtonLogger
    implements ActionListener {
        private ButtonLogger() {
        }

        public void actionPerformed(ActionEvent e) {
            ToolBarButton b = (ToolBarButton)e.getSource();
            ActivityLogger.logToolBarButtonActivated(b);
        }
    }
}

