/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.MutableTextDescriptor;
import java.util.HashMap;

public class TextDescriptor
extends AbstractTextDescriptor {
    private final AbstractTextDescriptor.Display display;
    private final long bits;
    private final int colorIndex;
    private static final HashMap<TextDescriptor, TextDescriptor> allDescriptors = new HashMap();
    public static final TextDescriptor EMPTY = TextDescriptor.newTextDescriptor(new MutableTextDescriptor());

    private TextDescriptor(AbstractTextDescriptor descriptor) {
        boolean zeroYOff;
        AbstractTextDescriptor.Display display = descriptor.getDisplay();
        long bits = descriptor.lowLevelGet();
        if ((bits & 0xFL) >> 0 > 9L) {
            bits = bits & 0xFFFFFFFFFFFFFFF0L | 0L;
        }
        if ((bits & 0x30L) != 0L) {
            bits = bits & 0xFFFFFFFFFFFFFFCFL | 0x20L;
        }
        if ((bits & 0x7FFF00000000L) == 0L) {
            bits |= 0x10000000000L;
        }
        if (display == AbstractTextDescriptor.Display.NONE) {
            bits &= VTSEMANTIC;
        }
        boolean zeroXOff = (bits & 0x1FF000L) == 0L;
        boolean bl = zeroYOff = (bits & 0x7FC00000L) == 0L;
        if (zeroXOff) {
            bits &= 0xFFFFFFFFFFDFFFFFL;
        }
        if (zeroYOff) {
            bits &= 0xFFFFFFFF7FFFFFFFL;
        }
        if (zeroXOff && zeroYOff) {
            bits &= 0xE0FFFFFFFFFFFFFFL;
        }
        this.display = display;
        this.bits = bits;
        this.colorIndex = display != AbstractTextDescriptor.Display.NONE ? descriptor.getColorIndex() : 0;
    }

    private Object readResolve() {
        return TextDescriptor.getUniqueTextDescriptor(this);
    }

    public static TextDescriptor newTextDescriptor(AbstractTextDescriptor td) {
        if (td instanceof TextDescriptor) {
            return (TextDescriptor)td;
        }
        return TextDescriptor.getUniqueTextDescriptor(td);
    }

    private static TextDescriptor getUniqueTextDescriptor(AbstractTextDescriptor td) {
        TextDescriptor cacheTd = allDescriptors.get(td);
        if (cacheTd != null) {
            return cacheTd;
        }
        TextDescriptor itd = new TextDescriptor(td);
        if (!itd.equals(td) && (cacheTd = allDescriptors.get(itd)) != null) {
            return cacheTd;
        }
        allDescriptors.put(itd, itd);
        return itd;
    }

    public TextDescriptor withDisplay(boolean state) {
        if (this.isDisplay() == state) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setDisplay(state ? AbstractTextDescriptor.Display.SHOWN : AbstractTextDescriptor.Display.NONE);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withDisplay(AbstractTextDescriptor.Display display) {
        if (this.getDisplay() == display) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setDisplay(display);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withPos(AbstractTextDescriptor.Position p) {
        if (p == null) {
            throw new NullPointerException();
        }
        if (this.getPos() == p) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setPos(p);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withAbsSize(int s) {
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setAbsSize(s);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withRelSize(double s) {
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setRelSize(s);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withFace(int f) {
        if (this.getFace() == f) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setFace(f);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withRotation(AbstractTextDescriptor.Rotation r) {
        if (r == null) {
            r = AbstractTextDescriptor.Rotation.ROT0;
        }
        if (this.getRotation() == r) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setRotation(r);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withDispPart(AbstractTextDescriptor.DispPos dispPos) {
        if (dispPos == null) {
            throw new NullPointerException();
        }
        if (this.getDispPart() == dispPos) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setDispPart(dispPos);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withItalic(boolean state) {
        if (this.isItalic() == state) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setItalic(state);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withBold(boolean state) {
        if (this.isBold() == state) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setBold(state);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withUnderline(boolean state) {
        if (this.isUnderline() == state) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setUnderline(state);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withInterior(boolean state) {
        if (this.isInterior() == state) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setInterior(state);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withInherit(boolean state) {
        if (this.isInherit() == state) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setInherit(state);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withParam(boolean state) {
        if (this.isParam() == state) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setParam(state);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withOff(double xd, double yd) {
        if (this.getXOff() == xd && this.getYOff() == yd) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setOff(xd, yd);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withUnit(AbstractTextDescriptor.Unit u) {
        if (u == null) {
            u = AbstractTextDescriptor.Unit.NONE;
        }
        if (this.getUnit() == u) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setUnit(u);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withColorIndex(int colorIndex) {
        if (this.getColorIndex() == colorIndex) {
            return this;
        }
        MutableTextDescriptor td = new MutableTextDescriptor(this);
        td.setColorIndex(colorIndex);
        return TextDescriptor.newTextDescriptor(td);
    }

    public TextDescriptor withDisplayWithoutParam() {
        if (this.isDisplay() && !this.isParam()) {
            return this;
        }
        MutableTextDescriptor mtd = new MutableTextDescriptor(this);
        mtd.setDisplay(AbstractTextDescriptor.Display.SHOWN);
        mtd.setParam(false);
        return TextDescriptor.newTextDescriptor(mtd);
    }

    public static int cacheSize() {
        return allDescriptors.size();
    }

    public AbstractTextDescriptor.Display getDisplay() {
        return this.display;
    }

    public long lowLevelGet() {
        return this.bits;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public static TextDescriptor getNodeTextDescriptor() {
        return EditingPreferences.getThreadEditingPreferences().getTextDescriptor(AbstractTextDescriptor.TextType.NODE, true);
    }

    public static TextDescriptor getArcTextDescriptor() {
        return EditingPreferences.getThreadEditingPreferences().getTextDescriptor(AbstractTextDescriptor.TextType.ARC, true);
    }

    public static TextDescriptor getExportTextDescriptor() {
        return EditingPreferences.getThreadEditingPreferences().getTextDescriptor(AbstractTextDescriptor.TextType.EXPORT, true);
    }

    public static TextDescriptor getPortInstTextDescriptor() {
        return EditingPreferences.getThreadEditingPreferences().getTextDescriptor(AbstractTextDescriptor.TextType.PORT, true);
    }

    public static TextDescriptor getAnnotationTextDescriptor() {
        return EditingPreferences.getThreadEditingPreferences().getTextDescriptor(AbstractTextDescriptor.TextType.ANNOTATION, true);
    }

    public static TextDescriptor getInstanceTextDescriptor() {
        return EditingPreferences.getThreadEditingPreferences().getTextDescriptor(AbstractTextDescriptor.TextType.INSTANCE, true);
    }

    public static TextDescriptor getCellTextDescriptor() {
        return EditingPreferences.getThreadEditingPreferences().getTextDescriptor(AbstractTextDescriptor.TextType.CELL, true);
    }
}

