/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.NccGlobalsReportable;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.result.BenchmarkResults;
import com.sun.electric.tool.ncc.result.Permutation;
import com.sun.electric.tool.ncc.result.equivalence.Equivalence;
import com.sun.electric.tool.user.ncc.NccGuiInfo;
import java.io.Serializable;

public class NccResult
implements Serializable {
    static final long serialVersionUID = 0L;
    private final boolean exportMatch;
    private final boolean topologyMatch;
    private final boolean sizeMatch;
    private final boolean userAbort;
    private Cell[] rootCells;
    private String[] rootCellNames;
    private VarContext[] rootContexts;
    private Equivalence equivalence;
    private NccGuiInfo nccGuiInfo;
    private NccOptions options;
    private CellSummary summary;
    private Permutation exportPermutation;
    private BenchmarkResults benchResults;

    private Equivalence buildNetEquivalence(NccGlobalsReportable globalData) {
        HierarchyEnumerator.NodableNameProxy[][] equivNodes;
        HierarchyEnumerator.NetNameProxy[][] equivNets;
        if (globalData == null) {
            equivNets = new HierarchyEnumerator.NetNameProxy[][]{new HierarchyEnumerator.NetNameProxy[0], new HierarchyEnumerator.NetNameProxy[0]};
            equivNodes = new HierarchyEnumerator.NodableNameProxy[][]{new HierarchyEnumerator.NodableNameProxy[0], new HierarchyEnumerator.NodableNameProxy[0]};
        } else {
            equivNets = globalData.getEquivalentNets();
            equivNodes = globalData.getEquivalentNodes();
        }
        return new Equivalence(equivNets, equivNodes, this.rootCells, this.rootContexts);
    }

    private NccResult(boolean exportNameMatch, boolean topologyMatch, boolean sizeMatch, boolean userAbort, NccGlobalsReportable globalData) {
        this.exportMatch = exportNameMatch;
        this.topologyMatch = topologyMatch;
        this.sizeMatch = sizeMatch;
        this.userAbort = userAbort;
        if (userAbort) {
            return;
        }
        this.rootCells = globalData.getRootCells();
        this.rootCellNames = globalData.getRootCellNames();
        this.rootContexts = globalData.getRootContexts();
        this.equivalence = this.buildNetEquivalence(globalData);
        this.nccGuiInfo = globalData.getNccGuiInfo();
        this.options = globalData.getOptions();
        this.summary = new CellSummary(globalData.getPartCounts(), globalData.getPortCounts(), globalData.getWireCounts(), globalData.cantBuildNetlistBits());
        this.benchResults = globalData.getBenchmarkResults();
    }

    public static NccResult newResult(boolean exportNameMatch, boolean topologyMatch, boolean sizeMatch, NccGlobalsReportable globalData) {
        return new NccResult(exportNameMatch, topologyMatch, sizeMatch, false, globalData);
    }

    public static NccResult newUserAbortResult() {
        return new NccResult(false, false, false, true, null);
    }

    public Cell[] getRootCells() {
        return this.rootCells;
    }

    public String[] getRootCellNames() {
        return this.rootCellNames;
    }

    public VarContext[] getRootContexts() {
        return this.rootContexts;
    }

    public NccOptions getOptions() {
        return this.options;
    }

    public CellSummary getCellSummary() {
        return this.summary;
    }

    public boolean exportMatch() {
        return this.exportMatch;
    }

    public boolean topologyMatch() {
        return this.topologyMatch;
    }

    public boolean sizeMatch() {
        return this.sizeMatch;
    }

    public boolean userAbort() {
        return this.userAbort;
    }

    public boolean match() {
        return this.exportMatch && this.topologyMatch && this.sizeMatch;
    }

    public Equivalence getEquivalence() {
        return this.equivalence;
    }

    public String summary(boolean checkSizes) {
        String s = this.exportMatch ? "  exports match, " : "exports mismatch, ";
        s = this.topologyMatch ? s + "topologies match, " : s + "topologies mismatch, ";
        s = !checkSizes ? s + "sizes not checked" : (this.sizeMatch ? s + "sizes match" : s + "sizes mismatch");
        return s;
    }

    public boolean guiNeedsToReport() {
        if (this.userAbort) {
            return false;
        }
        return !this.exportMatch || !this.topologyMatch || !this.sizeMatch;
    }

    public NccGuiInfo getNccGuiInfo() {
        return this.nccGuiInfo;
    }

    public Permutation getExportPermutation() {
        return this.exportPermutation;
    }

    public void setExportPermutation(Permutation exportPermutation) {
        this.exportPermutation = exportPermutation;
    }

    public BenchmarkResults getBenchmarkResults() {
        return this.benchResults;
    }

    public static class CellSummary
    implements Serializable {
        static final long serialVersionUID = 0L;
        public final int[] numParts;
        public final int[] numPorts;
        public final int[] numWires;
        public final boolean[] cantBuildNetlist;

        public CellSummary(int[] parts, int[] ports, int[] wires, boolean[] cantBuildNetlistBits) {
            this.numParts = parts;
            this.numPorts = ports;
            this.numWires = wires;
            this.cantBuildNetlist = cantBuildNetlistBits;
        }
    }
}

