/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.project.DisplayedCells;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.project.ProjectDB;
import com.sun.electric.tool.project.ProjectLibrary;
import com.sun.electric.tool.project.Users;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckOutJob
extends Job {
    private List<Cell> checkOutCells;
    private ProjectDB pdb;
    private DisplayedCells displayedCells;
    private boolean autoCheckout;

    public static void checkOutThisCell() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        CheckOutJob.checkOut(cell);
    }

    public static void checkOut(Cell cell) {
        if (Users.needUserName()) {
            return;
        }
        if (Project.ensureRepository()) {
            return;
        }
        ArrayList<Cell> oneCell = new ArrayList<Cell>();
        oneCell.add(cell);
        new CheckOutJob(oneCell, false);
    }

    CheckOutJob(List<Cell> checkOutCells, boolean autoCheckout) {
        super("Check out cells", Project.getProjectTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
        this.checkOutCells = checkOutCells;
        this.autoCheckout = autoCheckout;
        this.pdb = Project.projectDB;
        this.displayedCells = new DisplayedCells();
        this.displayedCells.setCellsToBeChanged(checkOutCells);
        this.startJob();
    }

    @Override
    public boolean doIt() throws JobException {
        HashSet<ProjectLibrary> projectLibs = new HashSet<ProjectLibrary>();
        for (Cell oldVers : this.checkOutCells) {
            Library lib = oldVers.getLibrary();
            ProjectLibrary pl = this.pdb.findProjectLibrary(lib);
            projectLibs.add(pl);
        }
        ProjectLibrary.lockManyProjectFiles(projectLibs);
        try {
            CheckOutJob.preCheckOutCells(this.pdb, this.checkOutCells);
        }
        catch (JobException e) {
            ProjectLibrary.releaseManyProjectFiles(projectLibs);
            throw e;
        }
        Project.setChangeStatus(true);
        for (Cell oldVers : this.checkOutCells) {
            Cell newVers = CheckOutJob.bumpVersion(oldVers);
            if (newVers == null) continue;
            CheckOutJob.bumpRecordVersions(this.pdb, oldVers, newVers);
            this.displayedCells.swap(oldVers, newVers);
        }
        Project.setChangeStatus(false);
        ProjectLibrary.releaseManyProjectFiles(projectLibs);
        this.fieldVariableChanged("pdb");
        this.fieldVariableChanged("displayedCells");
        return true;
    }

    @Override
    public void terminateOK() {
        Iterator<Cell> createdCells;
        Project.projectDB = this.pdb;
        this.displayedCells.updateWindows();
        WindowFrame.wantToRedoLibraryTree();
        if (!this.autoCheckout && (createdCells = this.displayedCells.getCreatedCells()).hasNext()) {
            String owner;
            GenMath.MutableInteger val;
            Cell cell;
            Iterator<Cell> cIt;
            Library oLib;
            Cell newVers = createdCells.next();
            StringBuffer cellNames = new StringBuffer();
            int numCells = 0;
            Iterator<Cell> it = this.displayedCells.getCreatedCells();
            while (it.hasNext()) {
                Cell c = it.next();
                if (cellNames.length() > 0) {
                    cellNames.append(", ");
                }
                cellNames.append(c.describe(false));
                ++numCells;
            }
            if (numCells > 1) {
                System.out.println("Cells " + cellNames + " checked out for your use");
            } else {
                System.out.println("Cell " + cellNames + " checked out for your use");
            }
            HashMap<Cell, GenMath.MutableInteger> cellsMarked = new HashMap<Cell, GenMath.MutableInteger>();
            Iterator<Library> it2 = Library.getLibraries();
            while (it2.hasNext()) {
                Library oLib2 = it2.next();
                Iterator<Cell> cIt2 = oLib2.getCells();
                while (cIt2.hasNext()) {
                    Cell cell2 = cIt2.next();
                    cellsMarked.put(cell2, new GenMath.MutableInteger(0));
                }
            }
            GenMath.MutableInteger miNewVers = (GenMath.MutableInteger)cellsMarked.get(newVers);
            miNewVers.setValue(1);
            boolean propagated = true;
            while (propagated) {
                propagated = false;
                Iterator<Library> it3 = Library.getLibraries();
                while (it3.hasNext()) {
                    Library oLib3 = it3.next();
                    Iterator<Cell> cIt3 = oLib3.getCells();
                    while (cIt3.hasNext()) {
                        Cell cell3 = cIt3.next();
                        GenMath.MutableInteger val2 = (GenMath.MutableInteger)cellsMarked.get(cell3);
                        if (val2.intValue() != 1) continue;
                        propagated = true;
                        val2.setValue(2);
                        Iterator<NodeInst> nIt = cell3.getInstancesOf();
                        while (nIt.hasNext()) {
                            NodeInst ni = nIt.next();
                            GenMath.MutableInteger pVal = (GenMath.MutableInteger)cellsMarked.get(ni.getParent());
                            if (pVal.intValue() != 0) continue;
                            pVal.setValue(1);
                        }
                    }
                }
            }
            miNewVers.setValue(0);
            int total = 0;
            Iterator<Library> it4 = Library.getLibraries();
            while (it4.hasNext()) {
                oLib = it4.next();
                cIt = oLib.getCells();
                while (cIt.hasNext()) {
                    cell = cIt.next();
                    val = (GenMath.MutableInteger)cellsMarked.get(cell);
                    if (val.intValue() == 0 || Project.getCellStatus(cell) != 3) continue;
                    val.setValue(3);
                    ++total;
                }
            }
            if (total != 0) {
                System.out.println("*** Warning: the following cells are above this in the hierarchy");
                System.out.println("*** and are checked out to others.  This may cause problems");
                it4 = Library.getLibraries();
                while (it4.hasNext()) {
                    oLib = it4.next();
                    cIt = oLib.getCells();
                    while (cIt.hasNext()) {
                        cell = cIt.next();
                        val = (GenMath.MutableInteger)cellsMarked.get(cell);
                        if (val.intValue() != 3) continue;
                        System.out.println("    " + cell + " is checked out to " + Project.getCellOwner(cell));
                    }
                }
            }
            it4 = Library.getLibraries();
            while (it4.hasNext()) {
                oLib = it4.next();
                cIt = oLib.getCells();
                while (cIt.hasNext()) {
                    cell = cIt.next();
                    val = (GenMath.MutableInteger)cellsMarked.get(cell);
                    val.setValue(0);
                }
            }
            miNewVers.setValue(1);
            propagated = true;
            while (propagated) {
                propagated = false;
                it4 = Library.getLibraries();
                while (it4.hasNext()) {
                    oLib = it4.next();
                    cIt = oLib.getCells();
                    while (cIt.hasNext()) {
                        cell = cIt.next();
                        val = (GenMath.MutableInteger)cellsMarked.get(cell);
                        if (val.intValue() != 1) continue;
                        propagated = true;
                        val.setValue(2);
                        Iterator<NodeInst> nIt = cell.getNodes();
                        while (nIt.hasNext()) {
                            GenMath.MutableInteger subVal;
                            NodeInst ni = nIt.next();
                            if (!ni.isCellInstance() || (subVal = (GenMath.MutableInteger)cellsMarked.get(ni.getProto())).intValue() != 0) continue;
                            subVal.setValue(1);
                        }
                    }
                }
            }
            miNewVers.setValue(0);
            total = 0;
            it4 = Library.getLibraries();
            while (it4.hasNext()) {
                oLib = it4.next();
                cIt = oLib.getCells();
                while (cIt.hasNext()) {
                    cell = cIt.next();
                    val = (GenMath.MutableInteger)cellsMarked.get(cell);
                    if (val.intValue() == 0 || (owner = Project.getCellOwner(cell)).length() == 0 || owner.equals(Project.getCurrentUserName())) continue;
                    val.setValue(3);
                    ++total;
                }
            }
            if (total != 0) {
                System.out.println("*** Warning: the following cells are below this in the hierarchy");
                System.out.println("*** and are checked out to others.  This may cause problems");
                it4 = Library.getLibraries();
                while (it4.hasNext()) {
                    oLib = it4.next();
                    cIt = oLib.getCells();
                    while (cIt.hasNext()) {
                        cell = cIt.next();
                        val = (GenMath.MutableInteger)cellsMarked.get(cell);
                        if (val.intValue() != 3) continue;
                        owner = Project.getCellOwner(cell);
                        System.out.println("    " + cell + " is checked out to " + owner);
                    }
                }
            }
        }
    }

    private static Cell bumpVersion(Cell oldVers) throws JobException {
        Library lib = oldVers.getLibrary();
        Cell newVers = Cell.copyNodeProto(oldVers, lib, oldVers.getName(), true);
        if (newVers == null) {
            throw new JobException("Error making new version of cell " + oldVers.describe(false));
        }
        if (Project.useNewestVersion(oldVers, newVers)) {
            throw new JobException("Error replacing instances of cell " + oldVers.describe(false));
        }
        Project.markLocked(newVers, false);
        lib.setChanged();
        return newVers;
    }

    private static void bumpRecordVersions(ProjectDB pdb, Cell oldVers, Cell newVers) {
        ProjectLibrary pl = pdb.findProjectLibrary(oldVers.getLibrary());
        ProjectCell oldPC = pl.findProjectCell(oldVers);
        ProjectCell newPC = new ProjectCell(newVers, pl);
        newPC.setLibType(oldPC.getLibType());
        newPC.setComment("CHECKED OUT");
        newPC.setOwner(Project.getCurrentUserName());
        pl.linkProjectCellToCell(oldPC, null);
        pl.linkProjectCellToCell(newPC, newVers);
    }

    private static void preCheckOutCells(ProjectDB pdb, List<Cell> cellsToCheckOut) throws JobException {
        for (Cell oldVers : cellsToCheckOut) {
            ProjectLibrary pl = pdb.findProjectLibrary(oldVers.getLibrary());
            ProjectCell newestProjectCell = null;
            Iterator<ProjectCell> it = pl.getProjectCells();
            while (it.hasNext()) {
                ProjectCell pc = it.next();
                if (!pc.getCellName().equals(oldVers.getName()) || pc.getView() != oldVers.getView() || pc.getVersion() <= oldVers.getVersion() || newestProjectCell != null && newestProjectCell.getVersion() >= pc.getVersion()) continue;
                newestProjectCell = pc;
            }
            if (newestProjectCell != null) {
                if (newestProjectCell.getOwner().length() == 0) {
                    throw new JobException("A more recent version of cell " + oldVers.describe(false) + " is in the repository.  Do an update first.");
                }
                if (newestProjectCell.getOwner().equals(Project.getCurrentUserName())) {
                    throw new JobException("You already checked-out cell " + oldVers.describe(false) + ", but the changes are not in the current library.  Do an update first.");
                }
                throw new JobException("Cannot check-out cell " + oldVers.describe(false) + ".  It is checked-out to '" + newestProjectCell.getOwner() + "'");
            }
            ProjectCell pc = pl.findProjectCell(oldVers);
            if (pc == null) {
                throw new JobException("Cell " + oldVers.describe(false) + " is not in the project.  You must add it to the project before being able to check it out and in.");
            }
            if (pc.getOwner().length() != 0) {
                if (pc.getOwner().equals(Project.getCurrentUserName())) {
                    Project.markLocked(oldVers, false);
                    throw new JobException("Cell " + oldVers.describe(false) + " is already checked out to you.");
                }
                throw new JobException("Cannot check cell " + oldVers.describe(false) + " out because it is already checked out to '" + pc.getOwner() + "'");
            }
            if (pc.getVersion() <= oldVers.getVersion()) continue;
            throw new JobException("Cannot check out cell " + oldVers.describe(false) + " because you don't have the latest version (yours is " + oldVers.getVersion() + ", project has " + pc.getVersion() + ").  Do an 'update' first");
        }
    }
}

