/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.LogicSettableArray;
import com.sun.electric.tool.simulation.test.Netscan4Driver;
import com.sun.electric.tool.simulation.test.NetscanGeneric;

public class Netscan4
extends NetscanGeneric {
    public final int jtagPort;

    public Netscan4(String addressIP, int jtagPort) {
        Netscan4Driver.registerPort(addressIP, jtagPort);
        this.jtagPort = jtagPort;
        this.logicOutput = new LogicSettableArray(3);
        for (int gpio = 0; gpio < 3; ++gpio) {
            Netscan4Driver.setParallelIO(jtagPort, gpio, this.logicOutput.isLogicStateHigh(gpio));
        }
    }

    public String getAddressIP() {
        return Netscan4Driver.getAddressIP();
    }

    public int getJtagPort() {
        return this.jtagPort;
    }

    void configure(float tapVolt, long kiloHerz) {
        Netscan4Driver.configure(tapVolt, kiloHerz, this);
    }

    public void reset() {
        Netscan4Driver.reset();
    }

    public void tms_reset() {
        Netscan4Driver.tms_reset(this.jtagPort);
    }

    void disconnect() {
        Netscan4Driver.deregisterPort();
    }

    protected int hw_net_scan_ir(int numBits, short[] scanIn, short[] scanOut, int drBits) {
        return Netscan4Driver.hw_net_scan_ir(this.jtagPort, numBits, scanIn, scanOut, this);
    }

    protected int hw_net_scan_dr(int numBits, short[] scanIn, short[] scanOut) {
        return Netscan4Driver.hw_net_scan_dr(this.jtagPort, numBits, scanIn, scanOut, this);
    }

    void setLogicOutput(int index, boolean newLevel) {
        this.logicOutput.setLogicState(index, newLevel);
        Netscan4Driver.setParallelIO(this.jtagPort, index, newLevel);
    }
}

