/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.technology.Layer;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class RoutingDebug {
    private static RoutingDialog debugDialog = null;
    private static Color[] allColors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.CYAN, Color.MAGENTA, Color.YELLOW};
    private static Map<Integer, Color> netColors;
    private static Map<Integer, Integer> netAngles;
    private static int colorsAssigned;
    private static int angleAssigned;
    private static boolean displayEndBlockages;

    public static void startDebugging() {
        User.setRoutingMode(true);
        debugDialog = new RoutingDialog();
    }

    private static void endDebugging() {
        User.setRoutingMode(false);
        if (debugDialog != null) {
            debugDialog.setVisible(false);
            debugDialog.dispose();
            debugDialog = null;
        }
    }

    public static boolean isActive() {
        return debugDialog != null;
    }

    public static void setRouteDescription(String desc) {
        if (debugDialog != null) {
            debugDialog.routeDescription.setText(desc);
        }
    }

    public static void debugRoute(SeaOfGatesEngine.NeededRoute nr) {
        if (debugDialog != null) {
            debugDialog.nr = nr;
            System.out.println("Routing from " + nr.getAtoBDirection().getFromPortInst().getNodeInst().describe(false) + ", port " + nr.getAtoBDirection().getFromPortInst().getPortProto().getName() + " at (" + nr.getAtoBDirection().getFromX() + "," + nr.getAtoBDirection().getFromY() + "), M" + (nr.getAtoBDirection().getFromZ() + 1));
            System.out.println("Routing to   " + nr.getAtoBDirection().getToPortInst().getNodeInst().describe(false) + ", port " + nr.getAtoBDirection().getToPortInst().getPortProto().getName() + " at (" + nr.getAtoBDirection().getToX() + "," + nr.getAtoBDirection().getToY() + "), M" + (nr.getAtoBDirection().getToZ() + 1));
        }
    }

    public static void identifyNewDebugPoint(SeaOfGatesEngine.SearchVertex sv) {
        if (debugDialog != null) {
            debugDialog.identifyNewDebugPoint(sv);
        }
    }

    public static void endProcessingSV(SeaOfGatesEngine.SearchVertex sv, String details) {
        SVState svs;
        if (debugDialog != null && (svs = (SVState)debugDialog.svInfo.get(sv)) != null) {
            svs.details = details;
        }
    }

    public static void mouseMoved(MouseEvent evt) {
        if (debugDialog == null) {
            return;
        }
        EditWindow wnd = (EditWindow)evt.getSource();
        Point2D dbClick = wnd.screenToDatabase(evt.getX(), evt.getY());
        double bestDist = Double.MAX_VALUE;
        SeaOfGatesEngine.SearchVertex bestSV = null;
        for (SeaOfGatesEngine.SearchVertex sv : debugDialog.svInfo.keySet()) {
            double dY;
            double off = (double)sv.getZ() * debugDialog.layerOffset;
            double dX = sv.getX() + off - dbClick.getX();
            double dist = Math.sqrt(dX * dX + (dY = sv.getY() + off - dbClick.getY()) * dY);
            if (!(dist < bestDist)) continue;
            bestDist = dist;
            bestSV = sv;
        }
        if (bestDist < 1.0) {
            SVState svs = (SVState)debugDialog.svInfo.get(bestSV);
            debugDialog.model.clear();
            if (svs.details == null) {
                String msg = "Did not get propagated. Cost=" + bestSV.getCost();
                if (bestSV.getLast() != null) {
                    msg = msg + ", previous point at (" + TextUtils.formatDouble(bestSV.getLast().getX()) + "," + TextUtils.formatDouble(bestSV.getLast().getY()) + ",M" + (bestSV.getLast().getZ() + 1) + ")";
                }
                debugDialog.model.addElement(msg);
            } else {
                String[] parts = svs.details.split("/");
                for (int i = 0; i < parts.length; ++i) {
                    String part = parts[i];
                    if (part.indexOf(124) >= 0) {
                        int j;
                        String[] subParts = part.split("\\|");
                        int firstLen = subParts[0].length();
                        String leading = "";
                        for (j = 0; j < firstLen; ++j) {
                            leading = leading + " ";
                        }
                        debugDialog.model.addElement(subParts[0]);
                        for (j = 1; j < subParts.length; ++j) {
                            debugDialog.model.addElement(leading + subParts[j]);
                        }
                        continue;
                    }
                    debugDialog.model.addElement(parts[i]);
                }
            }
        }
    }

    public static boolean isDisplayEndBlockages() {
        return debugDialog != null && displayEndBlockages;
    }

    public static void showGeometryAtRouteEnds(SeaOfGatesEngine.NeededRoute nr) {
        displayEndBlockages = false;
        if (debugDialog == null) {
            return;
        }
        double examineSurround = 10.0;
        colorsAssigned = 0;
        angleAssigned = 45;
        netColors = new HashMap<Integer, Color>();
        netAngles = new HashMap<Integer, Integer>();
        double lowestX = Double.MAX_VALUE;
        double lowestY = Double.MAX_VALUE;
        debugDialog.wnd.getRulerHighlighter().clear();
        Rectangle2D.Double headBound = new Rectangle2D.Double(nr.getAtoBDirection().getFromX() - examineSurround, nr.getAtoBDirection().getFromY() - examineSurround, examineSurround * 2.0, examineSurround * 2.0);
        for (int i = 0; i < debugDialog.router.getNumMetals(); ++i) {
            Layer layer = debugDialog.router.getMetalLayer(i);
            RTNode metalTree = nr.getMetalTree(layer);
            if (metalTree == null) continue;
            RTNode.Search sea = new RTNode.Search(headBound, metalTree, true);
            while (sea.hasNext()) {
                SeaOfGatesEngine.SOGBound sBound = (SeaOfGatesEngine.SOGBound)sea.next();
                RoutingDebug.showGeometryPiece(sBound);
                if (sBound.getBounds().getMinX() < lowestX) {
                    lowestX = sBound.getBounds().getMinX();
                }
                if (!(sBound.getBounds().getMinY() < lowestY)) continue;
                lowestY = sBound.getBounds().getMinY();
            }
        }
        Rectangle2D.Double tailBound = new Rectangle2D.Double(nr.getAtoBDirection().getToX() - examineSurround, nr.getAtoBDirection().getToY() - examineSurround, examineSurround * 2.0, examineSurround * 2.0);
        for (int i = 0; i < debugDialog.router.getNumMetals(); ++i) {
            Layer layer = debugDialog.router.getMetalLayer(i);
            RTNode metalTree = nr.getMetalTree(layer);
            if (metalTree == null) continue;
            RTNode.Search sea = new RTNode.Search(tailBound, metalTree, true);
            while (sea.hasNext()) {
                SeaOfGatesEngine.SOGBound sBound = (SeaOfGatesEngine.SOGBound)sea.next();
                RoutingDebug.showGeometryPiece(sBound);
                if (sBound.getBounds().getMinX() < lowestX) {
                    lowestX = sBound.getBounds().getMinX();
                }
                if (!(sBound.getBounds().getMinY() < lowestY)) continue;
                lowestY = sBound.getBounds().getMinY();
            }
        }
        double pos = lowestY - 3.0;
        for (Integer netIDI : netColors.keySet()) {
            Color color = netColors.get(netIDI);
            Integer angle = netAngles.get(netIDI);
            Rectangle2D.Double bound = new Rectangle2D.Double(lowestX, pos, 4.0, 2.0);
            RoutingDebug.showStripedRect(bound, color, angle);
            debugDialog.wnd.getRulerHighlighter().addMessage(debugDialog.cell, "Net " + netIDI, new EPoint(lowestX + 5.0, pos + 1.0));
            pos -= 3.0;
        }
        debugDialog.wnd.getRulerHighlighter().finished();
    }

    private static void showStripedRect(Rectangle2D bound, Color color, int angle) {
        Highlight h = debugDialog.wnd.getRulerHighlighter().addArea(bound, debugDialog.cell);
        h.setColor(color);
        double gapX = 0.5;
        double gapY = 0.5;
        double lX = bound.getMinX();
        double hX = bound.getMaxX();
        double lY = bound.getMinY();
        double hY = bound.getMaxY();
        if (angle == 0) {
            for (double y = RoutingDebug.gridValue(lY, gapY); y < hY; y += gapY) {
                h = debugDialog.wnd.getRulerHighlighter().addLine(new Point2D.Double(lX, y), new Point2D.Double(hX, y), debugDialog.cell, false, false);
                h.setColor(color);
            }
            return;
        }
        if (angle == 90) {
            for (double x2 = RoutingDebug.gridValue(lX, gapX); x2 < hX; x2 += gapX) {
                h = debugDialog.wnd.getRulerHighlighter().addLine(new Point2D.Double(x2, lY), new Point2D.Double(x2, hY), debugDialog.cell, false, false);
                h.setColor(color);
            }
            return;
        }
        double s = DBMath.sin(angle * 10);
        double c = DBMath.cos(angle * 10);
        gapX /= Math.abs(s);
        gapY /= Math.abs(c);
        if (angle <= 45 || angle >= 135) {
            double length;
            double pos;
            if (angle < 90) {
                pos = RoutingDebug.gridValue(lX - gapX, gapX);
                length = (hX - pos) / c;
            } else {
                pos = RoutingDebug.gridValue(hX + gapX, gapX);
                length = (lX - pos) / c;
            }
            for (double y = RoutingDebug.gridValue(lY - bound.getWidth() - gapY, gapY); y < hY + bound.getWidth(); y += gapY) {
                Point2D.Double pt1 = new Point2D.Double(pos, y);
                Point2D.Double pt2 = new Point2D.Double(pos + c * length, y + s * length);
                boolean gone = DBMath.clipLine(pt1, pt2, lX, hX, lY, hY);
                if (gone) continue;
                h = debugDialog.wnd.getRulerHighlighter().addLine(pt1, pt2, debugDialog.cell, false, false);
                h.setColor(color);
            }
        } else {
            double pos = RoutingDebug.gridValue(lY - gapY, gapY);
            double length = (hY - pos) / s;
            for (double x3 = RoutingDebug.gridValue(lX - bound.getHeight() - gapX, gapX); x3 < hX + bound.getHeight(); x3 += gapX) {
                Point2D.Double pt1 = new Point2D.Double(x3, pos);
                Point2D.Double pt2 = new Point2D.Double(x3 + c * length, pos + s * length);
                boolean gone = DBMath.clipLine(pt1, pt2, lX, hX, lY, hY);
                if (gone) continue;
                h = debugDialog.wnd.getRulerHighlighter().addLine(pt1, pt2, debugDialog.cell, false, false);
                h.setColor(color);
            }
        }
    }

    private static double gridValue(double v, double gap) {
        int iv = (int)Math.round(v / gap);
        return (double)iv * gap;
    }

    private static void showGeometryPiece(SeaOfGatesEngine.SOGBound sBound) {
        Integer netIDI = sBound.getNetID();
        Color color = netColors.get(netIDI);
        Integer angle = netAngles.get(netIDI);
        if (color == null) {
            color = allColors[colorsAssigned];
            netColors.put(netIDI, color);
            colorsAssigned = (colorsAssigned + 1) % allColors.length;
            angle = angleAssigned;
            netAngles.put(netIDI, angle);
            angleAssigned = (angleAssigned + 41) % 180;
        }
        RoutingDebug.showStripedRect(sBound.getBounds(), color, angle);
    }

    private static class RoutingDialog
    extends EModelessDialog {
        private SeaOfGatesEngine router;
        private SeaOfGatesEngine.NeededRoute nr;
        private EditWindow wnd;
        private Cell cell;
        private boolean runningToEnd = false;
        private int svOrder = 1;
        private List<Highlight> tempHighlights = new ArrayList<Highlight>();
        private Map<SeaOfGatesEngine.SearchVertex, SVState> svInfo = new HashMap<SeaOfGatesEngine.SearchVertex, SVState>();
        private Map<String, Highlight> anchorHighlights = new HashMap<String, Highlight>();
        private Map<String, Integer> anchorHeight = new HashMap<String, Integer>();
        private double goalWidth = 0.005;
        private double layerOffset = 0.04;
        private JLabel routeDescription;
        private JList list;
        private DefaultListModel model;

        public RoutingDialog() {
            super(TopLevel.getCurrentJFrame());
            this.wnd = EditWindow.getCurrent();
            this.wnd.getRulerHighlighter().clear();
            this.cell = this.wnd.getCell();
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Debug Routing");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    RoutingDebug.endDebugging();
                }
            });
            JButton next2 = new JButton("Step");
            next2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.step();
                }
            });
            this.getRootPane().setDefaultButton(next2);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 0.5;
            this.getContentPane().add((Component)next2, gbc);
            JButton run2 = new JButton("Run");
            run2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.run();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 0.5;
            this.getContentPane().add((Component)run2, gbc);
            JButton showEndBlockage = new JButton("Show End Blockage");
            showEndBlockage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    RoutingDialog.this.showEndBlockages();
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 0.5;
            this.getContentPane().add((Component)showEndBlockage, gbc);
            this.routeDescription = new JLabel("");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 2;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)this.routeDescription, gbc);
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.list.setSelectionMode(0);
            JScrollPane Center = new JScrollPane();
            Center.setMinimumSize(new Dimension(700, 50));
            Center.setPreferredSize(new Dimension(700, 300));
            Center.setViewportView(this.list);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 2;
            gbc.fill = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.weighty = 1.0;
            gbc.weightx = 1.0;
            this.getContentPane().add((Component)Center, gbc);
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    RoutingDialog.this.listClick(evt);
                }
            });
            this.pack();
            this.finishInitialization();
            this.setVisible(true);
        }

        private void listClick(MouseEvent evt) {
            int index = this.list.getSelectedIndex();
            System.out.println("CLICKED ON INDEX " + index);
        }

        private void showEndBlockages() {
            this.router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
            SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
            prefs.getOptionsFromPreferences();
            displayEndBlockages = true;
            this.router.setPrefs(prefs);
            SeaOfGates.seaOfGatesRoute(this.cell, this.router);
        }

        private void run() {
            SeaOfGatesEngine.SearchVertex result2;
            this.router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
            SeaOfGates.SeaOfGatesOptions prefs = new SeaOfGates.SeaOfGatesOptions();
            prefs.getOptionsFromPreferences();
            this.router.setPrefs(prefs);
            SeaOfGates.seaOfGatesRoute(this.cell, this.router);
            if (this.nr == null) {
                return;
            }
            this.runningToEnd = true;
            do {
                SeaOfGatesEngine.SearchVertex sv;
                if ((sv = this.nr.getAtoBDirection().getNextSearchVertex()) == SeaOfGatesEngine.svExhausted) continue;
                this.startProcessingSV(sv);
            } while ((result2 = this.advanceOneStep()) == null);
            for (String anchorLoc : this.anchorHeight.keySet()) {
                Integer height = this.anchorHeight.get(anchorLoc);
                if (height <= 0) continue;
                String[] anchorCoords = anchorLoc.split("/");
                double x2 = TextUtils.atof(anchorCoords[0]);
                double y = TextUtils.atof(anchorCoords[1]);
                double off = (double)height.intValue() * this.layerOffset;
                Highlight h = this.wnd.getRulerHighlighter().addLine(new EPoint(x2, y), new EPoint(x2 + off, y + off), this.cell, false, false);
                h.setColor(Color.BLACK);
            }
            this.wnd.getRulerHighlighter().finished();
        }

        private void step() {
            for (Highlight h : this.tempHighlights) {
                this.wnd.getRulerHighlighter().remove(h);
            }
            this.tempHighlights.clear();
            SeaOfGatesEngine.SearchVertex result2 = this.advanceOneStep();
            if (result2 != null) {
                return;
            }
            SeaOfGatesEngine.SearchVertex sv = this.nr.getAtoBDirection().getNextSearchVertex();
            if (sv != SeaOfGatesEngine.svExhausted) {
                this.startProcessingSV(sv);
                double off = (double)sv.getZ() * this.layerOffset;
                Highlight h = this.wnd.getRulerHighlighter().addLine(new EPoint(sv.getX() + off - 9.0, sv.getY() + off - 9.0), new EPoint(sv.getX() + off + 9.0, sv.getY() + off + 9.0), this.cell, true, false);
                h.setColor(Color.RED);
                this.tempHighlights.add(h);
                h = this.wnd.getRulerHighlighter().addLine(new EPoint(sv.getX() + off - 9.0, sv.getY() + off + 9.0), new EPoint(sv.getX() + off + 9.0, sv.getY() + off - 9.0), this.cell, true, false);
                h.setColor(Color.RED);
                this.tempHighlights.add(h);
                System.out.println("AT (" + TextUtils.formatDouble(sv.getX()) + "," + TextUtils.formatDouble(sv.getY()) + ",M" + (sv.getZ() + 1) + ")C=" + sv.getCost());
            }
            this.wnd.getRulerHighlighter().finished();
        }

        private SeaOfGatesEngine.SearchVertex advanceOneStep() {
            SeaOfGatesEngine.SearchVertex result2 = this.nr.getAtoBDirection().advanceWavefront();
            if (result2 != null) {
                String resA;
                if (result2 == SeaOfGatesEngine.svAborted) {
                    resA = "Aborted by user";
                } else if (result2 == SeaOfGatesEngine.svExhausted) {
                    resA = "Examined all possibilities";
                } else if (result2 == SeaOfGatesEngine.svLimited) {
                    resA = "Stopped after " + this.router.getPrefs().complexityLimit + " steps";
                } else {
                    this.showGoalSV(result2);
                    resA = "Success!";
                }
                System.out.println("Result: " + resA);
            }
            return result2;
        }

        @Override
        protected void escapePressed() {
            RoutingDebug.endDebugging();
        }

        private void showGoalSV(SeaOfGatesEngine.SearchVertex sv) {
            SeaOfGatesEngine.SearchVertex svLast;
            this.identifyNewDebugPoint(sv);
            SVState svs = this.svInfo.get(sv);
            if (svs != null) {
                Highlight.Message msg = (Highlight.Message)svs.label;
                msg.setInfo("!!GOAL!!");
            }
            while ((svLast = sv.getLast()) != null) {
                if (sv.getZ() != svLast.getZ()) {
                    int lowZ = Math.min(sv.getZ(), svLast.getZ());
                    int highZ = Math.max(sv.getZ(), svLast.getZ());
                    double lowOff = (double)lowZ * this.layerOffset;
                    double highOff = (double)highZ * this.layerOffset;
                    Highlight h = this.wnd.getRulerHighlighter().addLine(new EPoint(sv.getX() + lowOff, sv.getY() + lowOff + this.goalWidth), new EPoint(sv.getX() + highOff - this.goalWidth, sv.getY() + highOff), this.cell, true, false);
                    h.setColor(Color.WHITE);
                    h = this.wnd.getRulerHighlighter().addLine(new EPoint(sv.getX() + lowOff + this.goalWidth, sv.getY() + lowOff), new EPoint(sv.getX() + highOff, sv.getY() + highOff - this.goalWidth), this.cell, true, false);
                    h.setColor(Color.WHITE);
                } else {
                    double off = (double)sv.getZ() * this.layerOffset;
                    if (sv.getX() != svLast.getX()) {
                        Highlight h = this.wnd.getRulerHighlighter().addLine(new EPoint(sv.getX() + off, sv.getY() + off - this.goalWidth), new EPoint(svLast.getX() + off, svLast.getY() + off - this.goalWidth), this.cell, true, false);
                        h.setColor(Color.WHITE);
                        h = this.wnd.getRulerHighlighter().addLine(new EPoint(sv.getX() + off, sv.getY() + off + this.goalWidth), new EPoint(svLast.getX() + off, svLast.getY() + off + this.goalWidth), this.cell, true, false);
                        h.setColor(Color.WHITE);
                    } else {
                        Highlight h = this.wnd.getRulerHighlighter().addLine(new EPoint(sv.getX() + off - this.goalWidth, sv.getY() + off), new EPoint(svLast.getX() + off - this.goalWidth, svLast.getY() + off), this.cell, true, false);
                        h.setColor(Color.WHITE);
                        h = this.wnd.getRulerHighlighter().addLine(new EPoint(sv.getX() + off + this.goalWidth, sv.getY() + off), new EPoint(svLast.getX() + off + this.goalWidth, svLast.getY() + off), this.cell, true, false);
                        h.setColor(Color.WHITE);
                    }
                }
                sv = svLast;
            }
        }

        private void startProcessingSV(SeaOfGatesEngine.SearchVertex sv) {
            SVState svs = this.svInfo.get(sv);
            if (svs != null && sv.getLast() != null) {
                Highlight.Message msg = (Highlight.Message)svs.label;
                msg.setInfo(this.svOrder + "");
                ++this.svOrder;
            }
        }

        public void identifyNewDebugPoint(SeaOfGatesEngine.SearchVertex sv) {
            if (sv.getLast() == null) {
                double x2 = sv.getX();
                double y = sv.getY();
                double off = (double)sv.getZ() * this.layerOffset;
                Highlight h = this.wnd.getRulerHighlighter().addMessage(this.cell, "START", new EPoint(x2 + off, y + off));
                SVState svs = new SVState(h);
                this.svInfo.put(sv, svs);
                return;
            }
            if (sv.getZ() != sv.getLast().getZ()) {
                int lowZ = Math.min(sv.getZ(), sv.getLast().getZ());
                int highZ = Math.max(sv.getZ(), sv.getLast().getZ());
                double lowOff = (double)lowZ * this.layerOffset;
                double highOff = (double)highZ * this.layerOffset;
                Highlight h = this.wnd.getRulerHighlighter().addLine(new EPoint(sv.getX() + lowOff, sv.getY() + lowOff), new EPoint(sv.getX() + highOff, sv.getY() + highOff), this.cell, true, false);
                h.setColor(Color.WHITE);
            } else {
                double off = (double)sv.getZ() * this.layerOffset;
                Highlight h = this.wnd.getRulerHighlighter().addLine(new EPoint(sv.getX() + off, sv.getY() + off), new EPoint(sv.getLast().getX() + off, sv.getLast().getY() + off), this.cell, false, false);
                Layer lay = this.router.getMetalLayer(sv.getZ());
                h.setColor(lay.getGraphics().getColor());
            }
            String anchorLoc = TextUtils.formatDouble(sv.getX()) + "/" + TextUtils.formatDouble(sv.getY());
            Highlight anchorHigh = this.anchorHighlights.get(anchorLoc);
            Integer height = this.anchorHeight.get(anchorLoc);
            int lowZ = Math.min(sv.getZ(), sv.getLast().getZ());
            if (height == null) {
                height = lowZ;
            } else {
                int lowest = Math.min(height, lowZ);
                if (!this.runningToEnd && anchorHigh != null && lowZ < height) {
                    this.wnd.removeHighlight(anchorHigh);
                    this.anchorHighlights.remove(anchorLoc);
                }
                height = lowest;
            }
            this.anchorHeight.put(anchorLoc, height);
            if (!this.runningToEnd && height > 0) {
                double off = (double)height.intValue() * this.layerOffset;
                anchorHigh = this.wnd.addHighlightLine(new EPoint(sv.getX(), sv.getY()), new EPoint(sv.getX() + off, sv.getY() + off), this.cell, false, false);
                anchorHigh.setColor(Color.BLACK);
                this.anchorHighlights.put(anchorLoc, anchorHigh);
            }
            double x3 = sv.getX();
            double y = sv.getY();
            double off = (double)sv.getZ() * this.layerOffset;
            Highlight h = this.wnd.getRulerHighlighter().addMessage(this.cell, "M" + (sv.getZ() + 1), new EPoint(x3 + off, y + off));
            SVState svs = new SVState(h);
            this.svInfo.put(sv, svs);
        }
    }

    private static class SVState {
        Highlight label;
        String details;

        SVState(Highlight l) {
            this.label = l;
        }
    }
}

