/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.ObjectQTree;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortOriginal;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.InteractiveRouter;
import com.sun.electric.tool.routing.Route;
import com.sun.electric.tool.routing.RouteElement;
import com.sun.electric.tool.routing.RouteElementArc;
import com.sun.electric.tool.routing.RouteElementPort;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.SimpleWirer;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.ECoord;
import com.sun.electric.util.math.EDimension;
import com.sun.electric.util.math.FixpRectangle;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class AutoStitch {
    private static final boolean ZEROSIZEPINS = true;
    private InteractiveRouter router;
    private final EditingPreferences ep;
    private List<Route> allRoutes;
    private List<NodeInst> possibleInlinePins;
    private Map<PortInst, Double> truePinSize;
    private Set<NodeInst> nodeMark;
    private EDimension alignment;
    private boolean includePureLayerNodes;

    public static void autoStitch(boolean highlighted, boolean forced) {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        ArrayList<NodeInst> nodesToStitch = null;
        ArrayList<ArcInst> arcsToStitch = null;
        RectangularShape limitBound = null;
        if (highlighted) {
            nodesToStitch = new ArrayList<NodeInst>();
            arcsToStitch = new ArrayList<ArcInst>();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            List<Geometric> highs = wnd.getHighlightedEObjs(true, true);
            limitBound = wnd.getHighlightedArea();
            for (Geometric geom : highs) {
                Geometric eObj = geom;
                if (eObj instanceof PortInst) {
                    eObj = ((PortInst)((Object)eObj)).getNodeInst();
                }
                if (eObj instanceof NodeInst) {
                    PrimitiveNode pnp;
                    NodeInst ni = (NodeInst)eObj;
                    if (!ni.isCellInstance() && ((pnp = (PrimitiveNode)ni.getProto()).getTechnology() == Generic.tech() || pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
                    nodesToStitch.add((NodeInst)eObj);
                    continue;
                }
                if (!(eObj instanceof ArcInst)) continue;
                arcsToStitch.add((ArcInst)eObj);
            }
            if (nodesToStitch.size() == 0 && arcsToStitch.size() == 0) {
                if (forced) {
                    System.out.println("Nothing selected to auto-route");
                }
                return;
            }
        }
        double lX = 0.0;
        double hX = 0.0;
        double lY = 0.0;
        double hY = 0.0;
        if (limitBound != null) {
            lX = limitBound.getMinX();
            hX = limitBound.getMaxX();
            lY = limitBound.getMinY();
            hY = limitBound.getMaxY();
        }
        new AutoStitchJob(cell, nodesToStitch, arcsToStitch, lX, hX, lY, hY, forced);
    }

    public static void runAutoStitch(Cell cell, List<NodeInst> nodesToStitch, List<ArcInst> arcsToStitch, Job job, PolyMerge stayInside, Rectangle2D limitBound, boolean forced, boolean includePureLayerNodes, EditingPreferences ep, AutoOptions prefs, boolean showProgress, EDimension alignment) {
        if (cell.isAllLocked()) {
            System.out.println("WARNING: Cell " + cell.describe(false) + " is locked: no changes can be made");
            return;
        }
        AutoStitch as = new AutoStitch(ep);
        as.alignment = alignment;
        as.includePureLayerNodes = includePureLayerNodes;
        as.runNow(cell, nodesToStitch, arcsToStitch, job, stayInside, limitBound, forced, prefs, showProgress);
    }

    private AutoStitch(EditingPreferences ep) {
        this.ep = ep;
        this.possibleInlinePins = new ArrayList<NodeInst>();
        this.truePinSize = new HashMap<PortInst, Double>();
        this.router = new SimpleWirer(ep);
    }

    private List<ArcInst> getArcsToStitch(Cell cell, List<ArcInst> arcsToStitch) {
        ArrayList<ArcInst> newArcsToStitch = new ArrayList<ArcInst>();
        if (arcsToStitch == null) {
            Iterator<ArcInst> it = cell.getArcs();
            while (it.hasNext()) {
                newArcsToStitch.add(it.next());
            }
        } else {
            for (ArcInst ai : arcsToStitch) {
                if (!ai.isLinked()) continue;
                newArcsToStitch.add(ai);
            }
        }
        return newArcsToStitch;
    }

    private List<NodeInst> getNodesToStitch(Cell cell, List<NodeInst> nodesToStitch) {
        ArrayList<NodeInst> newNodesToStitch = new ArrayList<NodeInst>();
        if (nodesToStitch == null) {
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                PrimitiveNode pnp;
                NodeInst ni = it.next();
                if (ni.isIconOfParent() || !ni.isCellInstance() && ((pnp = (PrimitiveNode)ni.getProto()).getTechnology() == Generic.tech() || !this.includePureLayerNodes && pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
                newNodesToStitch.add(ni);
            }
        } else {
            for (NodeInst ni : nodesToStitch) {
                if (!ni.isLinked()) continue;
                newNodesToStitch.add(ni);
            }
        }
        return newNodesToStitch;
    }

    private void runNow(Cell cell, List<NodeInst> origNodesToStitch, List<ArcInst> origArcsToStitch, Job job, PolyMerge stayInside, Rectangle2D limitBound, boolean forced, AutoOptions prefs, boolean showProgress) {
        if (showProgress) {
            Job.getUserInterface().setProgressNote("Initializing routing");
        }
        ArcProto preferredArc = prefs.preferredArc;
        List<NodeInst> nodesToStitch = this.getNodesToStitch(cell, origNodesToStitch);
        List<ArcInst> arcsToStitch = this.getArcsToStitch(cell, origArcsToStitch);
        this.nodeMark = new HashSet<NodeInst>();
        for (NodeInst ni : nodesToStitch) {
            this.nodeMark.add(ni);
        }
        HashMap<ArcProto, Integer> arcsCreatedMap = new HashMap<ArcProto, Integer>();
        HashMap<NodeProto, Integer> nodesCreatedMap = new HashMap<NodeProto, Integer>();
        this.allRoutes = new ArrayList<Route>();
        int totalToStitch = nodesToStitch.size() + arcsToStitch.size();
        if (prefs.createExports) {
            totalToStitch *= 2;
        }
        totalToStitch += arcsToStitch.size();
        int soFar = 0;
        if (job != null && job.checkAbort()) {
            return;
        }
        if (prefs.createExports) {
            if (showProgress) {
                Job.getUserInterface().setProgressNote("Routing " + totalToStitch + " objects with export creation...");
            }
            GatherNetworksVisitor gatherNetworks = new GatherNetworksVisitor();
            HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)gatherNetworks);
            HashMap<Long, List<PolyConnection>> overlapMap = new HashMap<Long, List<PolyConnection>>();
            for (NodeInst ni : nodesToStitch) {
                if (showProgress && ++soFar % 100 == 0) {
                    if (job != null && job.checkAbort()) {
                        return;
                    }
                    Job.getUserInterface().setProgressValue(soFar * 100 / totalToStitch);
                }
                this.checkExportCreationStitching(ni, overlapMap, gatherNetworks);
            }
            for (ArcInst ai : arcsToStitch) {
                if (showProgress && ++soFar % 100 == 0) {
                    if (job != null && job.checkAbort()) {
                        return;
                    }
                    Job.getUserInterface().setProgressValue(soFar * 100 / totalToStitch);
                }
                if (!this.arcTooWide(ai) || !ai.isLinked()) continue;
                this.checkExportCreationStitching(ai, overlapMap, gatherNetworks);
            }
            if (showProgress) {
                Job.getUserInterface().setProgressNote("Gathering " + totalToStitch + " objects for export creation...");
            }
            for (Long netID : overlapMap.keySet()) {
                List polyConns = (List)overlapMap.get(netID);
                this.makeExport(polyConns);
            }
            this.makeConnections(showProgress, arcsCreatedMap, nodesCreatedMap, stayInside);
            this.allRoutes = new ArrayList<Route>();
            if (showProgress) {
                Job.getUserInterface().setProgressNote("Initializing routing");
            }
            nodesToStitch = this.getNodesToStitch(cell, origNodesToStitch);
            arcsToStitch = this.getArcsToStitch(cell, origArcsToStitch);
        }
        HashMap<NodeInst, ObjectQTree> nodePortBounds = new HashMap<NodeInst, ObjectQTree>();
        Iterator<NodeInst> nIt = cell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            ERectangle niBounds = ni.getBounds();
            ObjectQTree oqt = new ObjectQTree(niBounds);
            Iterator<PortInst> it = ni.getPortInsts();
            while (it.hasNext()) {
                PortInst pi = it.next();
                PortProto pp = pi.getPortProto();
                PortOriginal fp = new PortOriginal(ni, pp);
                FixpTransform trans = fp.getTransformToTop();
                NodeInst rNi = fp.getBottomNodeInst();
                double xSize = rNi.getXSize();
                double ySize = rNi.getYSize();
                if (rNi.getFunction() == PrimitiveNode.Function.PIN) {
                    double pinSize;
                    xSize = ySize = (pinSize = this.getPortSize(pi));
                }
                Rectangle2D.Double bounds = new Rectangle2D.Double(rNi.getAnchorCenterX() - xSize / 2.0, rNi.getAnchorCenterY() - ySize / 2.0, xSize, ySize);
                DBMath.transformRect(bounds, trans);
                if (oqt.add(pi, bounds)) continue;
                System.out.println("ERROR: Cell " + cell.describe(false) + ", node " + ni.describe(false) + ", port " + pp.getName() + " could not be added to quad-tree (bounds are " + bounds.getMinX() + "<=X<=" + bounds.getMaxX() + " and " + bounds.getMinY() + "<=Y<=" + bounds.getMaxY() + ")");
            }
            nodePortBounds.put(ni, oqt);
        }
        HashMap<ArcProto, Layer> arcLayers = new HashMap<ArcProto, Layer>();
        StitchingTopology top = new StitchingTopology(cell);
        if (showProgress) {
            Job.getUserInterface().setProgressNote("Routing " + totalToStitch + " objects...");
        }
        for (ArcInst ai : arcsToStitch) {
            if (showProgress && ++soFar % 100 == 0) {
                if (job != null && job.checkAbort()) {
                    return;
                }
                Job.getUserInterface().setProgressValue(soFar * 100 / totalToStitch);
            }
            this.checkDaisyChain(ai, nodePortBounds, stayInside, top);
        }
        if (this.allRoutes.size() > 0) {
            System.out.println("Auto-routing detected " + this.allRoutes.size() + " daisy-chained arcs");
            for (Route route : this.allRoutes) {
                boolean failure2 = Router.createRouteNoJob(route, cell, arcsCreatedMap, nodesCreatedMap, this.ep);
                if (!failure2) continue;
                System.out.println("AUTO STITCHER FAILED TO MAKE DAISY-CHAIN ARC");
            }
            this.allRoutes = new ArrayList<Route>();
            top = new StitchingTopology(cell);
            nodesToStitch = this.getNodesToStitch(cell, origNodesToStitch);
            arcsToStitch = this.getArcsToStitch(cell, origArcsToStitch);
        }
        for (NodeInst ni : nodesToStitch) {
            if (showProgress && ++soFar % 100 == 0) {
                if (job != null && job.checkAbort()) {
                    return;
                }
                Job.getUserInterface().setProgressValue(soFar * 100 / totalToStitch);
            }
            this.checkStitching(ni, nodePortBounds, arcLayers, stayInside, top, limitBound, preferredArc);
        }
        for (ArcInst ai : arcsToStitch) {
            if (showProgress && ++soFar % 100 == 0) {
                if (job != null && job.checkAbort()) {
                    return;
                }
                Job.getUserInterface().setProgressValue(soFar * 100 / totalToStitch);
            }
            if (!ai.isLinked() || !this.arcTooWide(ai)) continue;
            this.checkStitching(ai, nodePortBounds, arcLayers, stayInside, top, limitBound, preferredArc);
        }
        this.makeConnections(showProgress, arcsCreatedMap, nodesCreatedMap, stayInside);
        boolean beep = User.isPlayClickSoundsWhenCreatingArcs();
        if (forced) {
            Router.reportRoutingResults("AUTO ROUTING", arcsCreatedMap, nodesCreatedMap, beep);
        }
        if (showProgress) {
            if (job != null && job.checkAbort()) {
                return;
            }
            Job.getUserInterface().setProgressValue(0);
            Job.getUserInterface().setProgressNote("Cleaning up pins...");
        }
        ArrayList<CircuitChangeJobs.Reconnect> pinsToPassThrough = new ArrayList<CircuitChangeJobs.Reconnect>();
        for (NodeInst ni : this.possibleInlinePins) {
            CircuitChangeJobs.Reconnect re;
            if (!ni.isInlinePin() || (re = CircuitChangeJobs.Reconnect.erasePassThru(ni, false, true, this.ep)) == null) continue;
            pinsToPassThrough.add(re);
        }
        if (pinsToPassThrough.size() > 0) {
            CircuitChangeJobs.CleanupChanges ccJob = new CircuitChangeJobs.CleanupChanges(cell, true, Collections.<NodeInst>emptySet(), pinsToPassThrough, new HashMap<NodeInst, EPoint>(), new ArrayList<NodeInst>(), new HashSet<ArcInst>(), 0, 0, 0);
            try {
                ccJob.doIt();
            }
            catch (JobException e) {
                // empty catch block
            }
        }
    }

    private double getPortSize(PortInst pi) {
        NodeInst bottomNi;
        Double size2 = this.truePinSize.get(pi);
        if (size2 != null) {
            return size2;
        }
        double widestArc = 0.0;
        PortInst bottomPort = pi;
        while (true) {
            bottomNi = bottomPort.getNodeInst();
            PortProto bottomPp = bottomPort.getPortProto();
            Iterator<Connection> it = bottomPort.getConnections();
            while (it.hasNext()) {
                int end;
                Connection con = it.next();
                ArcInst ai = con.getArc();
                if (!ai.isExtended(end = con.getEndIndex())) continue;
                widestArc = Math.max(ai.getLambdaBaseWidth(), widestArc);
            }
            if (!bottomNi.isCellInstance()) break;
            bottomPort = ((Export)bottomPp).getOriginalPort();
        }
        if (widestArc > bottomNi.getXSize() && widestArc > bottomNi.getYSize()) {
            widestArc = Math.max(bottomNi.getXSize(), bottomNi.getYSize());
        }
        this.truePinSize.put(pi, new Double(widestArc));
        return widestArc;
    }

    private void makeConnections(boolean showProgress, Map<ArcProto, Integer> arcsCreatedMap, Map<NodeProto, Integer> nodesCreatedMap, PolyMerge stayInside) {
        int totalToStitch = this.allRoutes.size();
        int soFar = 0;
        if (showProgress) {
            Job.getUserInterface().setProgressValue(0);
            Job.getUserInterface().setProgressNote("Creating " + totalToStitch + " wires...");
        }
        Collections.sort(this.allRoutes, new CompRoutes());
        for (Route route : this.allRoutes) {
            if (showProgress && ++soFar % 100 == 0) {
                Job.getUserInterface().setProgressValue(soFar * 100 / totalToStitch);
            }
            RouteElement re = (RouteElement)route.get(0);
            Cell c = re.getCell();
            RouteElementPort start = route.getStart();
            RouteElementPort end = route.getEnd();
            PortInst startPi = start.getPortInst();
            PortInst endPi = end.getPortInst();
            if (startPi != null && endPi != null) {
                boolean already = false;
                Iterator<Connection> cIt = startPi.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    ArcInst existingAI = con.getArc();
                    if (existingAI.getHead() == con) {
                        if (existingAI.getTail().getPortInst() != endPi) continue;
                        already = true;
                        break;
                    }
                    if (existingAI.getHead().getPortInst() != endPi) continue;
                    already = true;
                    break;
                }
                if (already) continue;
            }
            Router.createRouteNoJob(route, c, arcsCreatedMap, nodesCreatedMap, this.ep);
        }
    }

    private void checkDaisyChain(ArcInst ai, Map<NodeInst, ObjectQTree> nodePortBounds, PolyMerge stayInside, StitchingTopology top) {
        if (ai.getProto() == Schematics.tech().bus_arc) {
            return;
        }
        Cell cell = ai.getParent();
        Network arcNet = top.getArcNetwork(ai);
        EPoint e1 = ai.getHeadLocation();
        EPoint e2 = ai.getTailLocation();
        ArrayList<DaisyChainPoint> daisyPoints = new ArrayList<DaisyChainPoint>();
        ERectangle searchBounds = ai.getBounds();
        Iterator<Geometric> it = cell.searchIterator(searchBounds);
        while (it.hasNext()) {
            NodeInst ni;
            ObjectQTree oqt;
            Set set;
            Geometric geom = it.next();
            if (!(geom instanceof NodeInst) || (set = (oqt = nodePortBounds.get(ni = (NodeInst)geom)).find(searchBounds)) == null) continue;
            for (Object obj : set) {
                Network portNet;
                Poly portPoly;
                Point2D closest;
                PortInst pi = (PortInst)obj;
                if (!pi.getPortProto().getBasePort().connectsTo(ai.getProto()) || !DBMath.pointInRect(closest = GenMath.closestPointToSegment((Point2D)e1, (Point2D)e2, (Point2D)(portPoly = pi.getPoly()).getCenter()), (Rectangle2D)portPoly.getBounds2D()) || (portNet = top.getPortNetwork(pi)) == arcNet) continue;
                daisyPoints.add(new DaisyChainPoint(pi, closest));
            }
        }
        if (daisyPoints.size() <= 1) {
            return;
        }
        Collections.sort(daisyPoints, new SortDaisyPoints());
        Route route = new Route();
        String name = ai.getName();
        name = null;
        RouteElementPort headRE = RouteElementPort.existingPortInst(ai.getHeadPortInst(), ai.getHeadLocation(), this.ep);
        RouteElementPort tailRE = RouteElementPort.existingPortInst(ai.getTailPortInst(), ai.getTailLocation(), this.ep);
        DaisyChainPoint firstDCP = (DaisyChainPoint)daisyPoints.get(0);
        DaisyChainPoint lastDCP = (DaisyChainPoint)daisyPoints.get(daisyPoints.size() - 1);
        double distOK = firstDCP.location.distance(ai.getHeadLocation()) + lastDCP.location.distance(ai.getTailLocation());
        double distSwap = firstDCP.location.distance(ai.getTailLocation()) + lastDCP.location.distance(ai.getHeadLocation());
        if (distOK > distSwap) {
            RouteElementPort swap = headRE;
            headRE = tailRE;
            tailRE = swap;
        }
        for (DaisyChainPoint dcp : daisyPoints) {
            RouteElementPort dcpRE = RouteElementPort.existingPortInst(dcp.pi, dcp.location, this.ep);
            if (headRE != null && headRE.getPortInst() != tailRE.getPortInst()) {
                RouteElementArc re = RouteElementArc.newArc(cell, ai.getProto(), ai.getLambdaBaseWidth(), headRE, dcpRE, headRE.getConnectingSite().getCenter(), dcpRE.getConnectingSite().getCenter(), name, ai.getTextDescriptor(ArcInst.ARC_NAME), ai, ai.isHeadExtended(), ai.isTailExtended(), stayInside);
                route.add(re);
            }
            headRE = dcpRE;
            name = null;
        }
        if (tailRE != null && headRE.getPortInst() != tailRE.getPortInst()) {
            RouteElementArc re = RouteElementArc.newArc(cell, ai.getProto(), ai.getLambdaBaseWidth(), headRE, tailRE, headRE.getConnectingSite().getCenter(), tailRE.getConnectingSite().getCenter(), name, ai.getTextDescriptor(ArcInst.ARC_NAME), ai, ai.isHeadExtended(), ai.isTailExtended(), stayInside);
            route.add(re);
        }
        this.allRoutes.add(route);
    }

    private void checkStitching(Geometric geom, Map<NodeInst, ObjectQTree> nodePortBounds, Map<ArcProto, Layer> arcLayers, PolyMerge stayInside, StitchingTopology top, Rectangle2D limitBound, ArcProto preferredArc) {
        Cell cell = geom.getParent();
        NodeInst ni = null;
        if (geom instanceof NodeInst) {
            ni = (NodeInst)geom;
        }
        ArrayList<Geometric> geomsInArea = new ArrayList<Geometric>();
        ERectangle geomBounds = geom.getBounds();
        double epsilon = DBMath.getEpsilon();
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(((RectangularShape)geomBounds).getMinX() - epsilon, ((RectangularShape)geomBounds).getMinY() - epsilon, ((RectangularShape)geomBounds).getWidth() + epsilon * 2.0, ((RectangularShape)geomBounds).getHeight() + epsilon * 2.0);
        Iterator<Geometric> it = cell.searchIterator(searchBounds);
        while (it.hasNext()) {
            Geometric oGeom = it.next();
            if (oGeom == geom) continue;
            geomsInArea.add(oGeom);
        }
        for (Geometric oGeom : geomsInArea) {
            PrimitiveNode pnp;
            if (oGeom instanceof ArcInst) {
                ArcInst oAi = (ArcInst)oGeom;
                if (ni == null) {
                    if (!this.arcTooWide(oAi)) continue;
                    this.compareTwoArcs((ArcInst)geom, oAi, stayInside, top);
                    continue;
                }
                if (ni.isCellInstance()) {
                    this.compareNodeInstWithArc(ni, oAi, stayInside, top, nodePortBounds);
                    continue;
                }
                this.compareNodePrimWithArc(ni, oAi, stayInside, top);
                continue;
            }
            NodeInst oNi = (NodeInst)oGeom;
            if (!oNi.isCellInstance() && ((pnp = (PrimitiveNode)oNi.getProto()).getTechnology() == Generic.tech() || !this.includePureLayerNodes && pnp.getFunction() == PrimitiveNode.Function.NODE)) continue;
            if (ni == null) {
                if (oNi.isCellInstance()) {
                    this.compareNodeInstWithArc(oNi, (ArcInst)geom, stayInside, top, nodePortBounds);
                    continue;
                }
                this.compareNodePrimWithArc(oNi, (ArcInst)geom, stayInside, top);
                continue;
            }
            this.compareTwoNodes(ni, oNi, nodePortBounds, arcLayers, stayInside, top, limitBound, preferredArc);
        }
    }

    private void compareTwoNodes(NodeInst ni, NodeInst oNi, Map<NodeInst, ObjectQTree> nodePortBounds, Map<ArcProto, Layer> arcLayers, PolyMerge stayInside, StitchingTopology top, Rectangle2D limitBound, ArcProto preferredArc) {
        block26: {
            block27: {
                Rectangle2D.Double biggerBounds;
                if (this.nodeMark.contains(oNi) && oNi.getNodeIndex() <= ni.getNodeIndex()) {
                    return;
                }
                ERectangle oBounds = oNi.getBounds();
                if (!ni.isCellInstance()) break block27;
                ObjectQTree oqt = nodePortBounds.get(ni);
                Set set = oqt.find(biggerBounds = new Rectangle2D.Double(((RectangularShape)oBounds).getMinX() - 1.0, ((RectangularShape)oBounds).getMinY() - 1.0, ((RectangularShape)oBounds).getWidth() + 2.0, ((RectangularShape)oBounds).getHeight() + 2.0));
                if (set == null) break block26;
                block0: for (Object obj : set) {
                    PortInst pi = (PortInst)obj;
                    PortProto pp = pi.getPortProto();
                    FixpTransform trans = ni.rotateOut();
                    NodeInst rNi = ni;
                    PortProto rPp = pp;
                    while (rNi.isCellInstance()) {
                        FixpTransform temp = rNi.translateOut();
                        temp.preConcatenate(trans);
                        Export e = (Export)rPp;
                        rNi = e.getOriginalPort().getNodeInst();
                        rPp = e.getOriginalPort().getPortProto();
                        trans = rNi.rotateOut();
                        trans.preConcatenate(temp);
                    }
                    ArcProto[] connections = pp.getBasePort().getConnections();
                    for (int i = 0; i < connections.length; ++i) {
                        this.findSmallestLayer(connections[i], arcLayers);
                    }
                    boolean usePortPoly = false;
                    Poly[] nodePolys = this.shapeOfNode(rNi);
                    int tot = nodePolys.length;
                    if (tot == 0 || rNi.getProto() == Generic.tech().simProbeNode) {
                        usePortPoly = true;
                        tot = 1;
                    }
                    Netlist subNetlist = rNi.getParent().getNetlist();
                    for (int j = 0; j < tot; ++j) {
                        Layer layer = null;
                        Poly poly = null;
                        if (usePortPoly) {
                            poly = ni.getShapeOfPort(pp);
                            layer = poly.getLayer();
                        } else {
                            poly = nodePolys[j];
                            if (poly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, poly.getPort())) continue;
                            poly.transform(trans);
                            layer = poly.getLayer();
                            if (layer != null) {
                                layer = layer.getNonPseudoLayer();
                            }
                        }
                        boolean connected = false;
                        for (int pass = 0; pass < 2; ++pass) {
                            for (int i = 0; i < connections.length; ++i) {
                                ArcProto ap = connections[i];
                                if (pass != 0 ? ap == preferredArc || ap.getTechnology() != rNi.getProto().getTechnology() : ap != preferredArc) continue;
                                if (!usePortPoly) {
                                    Layer oLayer = arcLayers.get(ap);
                                    if (!layer.getTechnology().sameLayer(oLayer, layer)) continue;
                                }
                                if (connected = this.testPoly(ni, pp, ap, poly, oNi, top, nodePortBounds, arcLayers, stayInside, limitBound)) break;
                            }
                            if (connected) break;
                        }
                        if (connected) continue block0;
                    }
                }
                break block26;
            }
            FixpTransform trans = ni.rotateOut();
            double oX = oNi.getAnchorCenterX();
            double oY = oNi.getAnchorCenterY();
            boolean usePortPoly = false;
            Poly[] polys = this.shapeOfNode(ni);
            int tot = polys.length;
            if (tot == 0 || ni.getProto() == Generic.tech().simProbeNode) {
                usePortPoly = true;
                tot = 1;
            }
            for (int j = 0; j < tot; ++j) {
                double dist;
                double y;
                Iterator<PortProto> pIt;
                double bestDist;
                PortProto bestPp;
                PortProto rPp = null;
                Poly polyPtr = null;
                if (usePortPoly) {
                    bestPp = null;
                    bestDist = 0.0;
                    pIt = ni.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto tPp = pIt.next();
                        Poly portPoly = ni.getShapeOfPort(tPp);
                        double x2 = portPoly.getCenterX();
                        y = portPoly.getCenterY();
                        dist = Math.abs(x2 - oX) + Math.abs(y - oY);
                        if (bestPp == null) {
                            bestDist = dist;
                            bestPp = tPp;
                        }
                        if (dist > bestDist) continue;
                        bestPp = tPp;
                        bestDist = dist;
                    }
                    if (bestPp == null) continue;
                    rPp = bestPp;
                    polyPtr = ni.getShapeOfPort(rPp);
                } else {
                    polyPtr = polys[j];
                    if (polyPtr.getPort() == null) continue;
                    bestPp = null;
                    bestDist = 0.0;
                    pIt = ni.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto tPp = pIt.next();
                        if (!top.portsConnected(ni, tPp, polyPtr.getPort())) continue;
                        Poly portPoly = ni.getShapeOfPort(tPp);
                        double x3 = portPoly.getCenterX();
                        y = portPoly.getCenterY();
                        dist = Math.abs(x3 - oX) + Math.abs(y - oY);
                        if (bestPp == null) {
                            bestDist = dist;
                        }
                        if (dist > bestDist) continue;
                        bestPp = tPp;
                        bestDist = dist;
                    }
                    if (bestPp == null) continue;
                    rPp = bestPp;
                    polyPtr.transform(trans);
                }
                Layer layer = polyPtr.getLayer();
                if (layer != null) {
                    layer = layer.getNonPseudoLayer();
                }
                boolean found = false;
                Iterator<Connection> cIt = ni.getConnections();
                while (cIt.hasNext()) {
                    Connection con = cIt.next();
                    PortInst pi = con.getPortInst();
                    if (!top.portsConnected(ni, rPp, pi.getPortProto()) || con.getArc().getHeadPortInst().getNodeInst() != oNi && con.getArc().getTailPortInst().getNodeInst() != oNi) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                boolean connected = false;
                ArcProto[] connections = rPp.getBasePort().getConnections();
                for (int pass = 0; pass < 2; ++pass) {
                    for (int i = 0; i < connections.length; ++i) {
                        ArcProto ap = connections[i];
                        if (pass != 0 ? ap == preferredArc : ap != preferredArc) continue;
                        if (ap.getTechnology() != ni.getProto().getTechnology()) break;
                        this.findSmallestLayer(ap, arcLayers);
                        if (!usePortPoly) {
                            Layer oLayer = arcLayers.get(ap);
                            if (!ap.getTechnology().sameLayer(oLayer, layer)) continue;
                        }
                        if (connected = this.testPoly(ni, rPp, ap, polyPtr, oNi, top, nodePortBounds, arcLayers, stayInside, limitBound)) break;
                    }
                    if (connected) break;
                }
                if (!connected) {
                    continue;
                }
                break;
            }
        }
    }

    private void compareTwoArcs(ArcInst ai1, ArcInst ai2, PolyMerge stayInside, StitchingTopology top) {
        Network net2;
        if (ai1.getProto() != ai2.getProto()) {
            return;
        }
        Network net1 = top.getArcNetwork(ai1);
        if (net1 == (net2 = top.getArcNetwork(ai2))) {
            return;
        }
        Poly[] polys1 = ai1.getProto().getTechnology().getShapeOfArc(ai1);
        int tot1 = polys1.length;
        Poly[] polys2 = ai2.getProto().getTechnology().getShapeOfArc(ai2);
        int tot2 = polys2.length;
        for (int i1 = 0; i1 < tot1; ++i1) {
            Poly poly1 = polys1[i1];
            Layer layer1 = poly1.getLayer();
            Layer.Function fun = layer1.getFunction();
            if (!fun.isMetal() && !fun.isDiff() && !fun.isPoly()) continue;
            FixpRectangle bounds1 = poly1.getBounds2D();
            for (int i2 = 0; i2 < tot2; ++i2) {
                FixpRectangle bounds2;
                Poly poly2 = polys2[i2];
                if (layer1 != poly2.getLayer() || !bounds1.intersects(bounds2 = poly2.getBounds2D())) continue;
                Rectangle2D.Double intersection2 = new Rectangle2D.Double();
                Rectangle2D.intersect(bounds1, bounds2, intersection2);
                double x2 = intersection2.getCenterX();
                double y = intersection2.getCenterY();
                this.connectObjects(ai1, net1, ai2, net2, ai1.getParent(), new Point2D.Double(x2, y), stayInside, top);
                return;
            }
        }
    }

    private void compareNodeInstWithArc(NodeInst ni, ArcInst ai, PolyMerge stayInside, StitchingTopology top, Map<NodeInst, ObjectQTree> nodePortBounds) {
        ERectangle aBounds;
        Rectangle2D.Double biggerBounds;
        Network arcNet = top.getArcNetwork(ai);
        ObjectQTree oqt = nodePortBounds.get(ni);
        Set set = oqt.find(biggerBounds = new Rectangle2D.Double(((RectangularShape)(aBounds = ai.getBounds())).getMinX() - 1.0, ((RectangularShape)aBounds).getMinY() - 1.0, ((RectangularShape)aBounds).getWidth() + 2.0, ((RectangularShape)aBounds).getHeight() + 2.0));
        if (set == null || set.size() == 0) {
            return;
        }
        for (Poly arcPoly : ai.getProto().getTechnology().getShapeOfArc(ai)) {
            Layer arcLayer = arcPoly.getLayer();
            Layer.Function arcLayerFun = arcLayer.getFunction();
            if (!arcLayerFun.isMetal() && !arcLayerFun.isDiff() && !arcLayerFun.isPoly()) continue;
            for (Object obj : set) {
                PortInst pi = (PortInst)obj;
                Network portNet = top.getPortNetwork(pi);
                if (portNet == arcNet) continue;
                FixpTransform trans = ni.rotateOut();
                NodeInst rNi = ni;
                PortProto rPp = pi.getPortProto();
                while (rNi.isCellInstance()) {
                    FixpTransform temp = rNi.translateOut();
                    temp.preConcatenate(trans);
                    Export e = (Export)rPp;
                    rNi = e.getOriginalPort().getNodeInst();
                    rPp = e.getOriginalPort().getPortProto();
                    trans = rNi.rotateOut();
                    trans.preConcatenate(temp);
                }
                for (Poly baseNodePoly : this.shapeOfNode(rNi)) {
                    Layer nodeLayer = baseNodePoly.getLayer();
                    if (nodeLayer == null || (nodeLayer = nodeLayer.getNonPseudoLayer()).getFunction() != arcLayerFun) continue;
                    baseNodePoly.transform(trans);
                    double polyDist = arcPoly.separation(baseNodePoly);
                    if (polyDist >= DBMath.getEpsilon()) continue;
                    Poly portPoly = pi.getPoly();
                    double portCX = portPoly.getCenterX();
                    double portCY = portPoly.getCenterY();
                    FixpRectangle arcBounds = arcPoly.getBounds2D();
                    double aCX = ((RectangularShape)arcBounds).getCenterX();
                    double aCY = ((RectangularShape)arcBounds).getCenterY();
                    Point2D.Double bend1 = new Point2D.Double(portCX, aCY);
                    Point2D.Double bend2 = new Point2D.Double(aCX, portCY);
                    if (stayInside != null) {
                        if (!stayInside.contains(arcLayer, bend1)) {
                            bend1 = bend2;
                        }
                    } else if (!arcPoly.contains(bend1)) {
                        bend1 = bend2;
                    }
                    this.connectObjects(ai, arcNet, pi, portNet, ai.getParent(), bend1, stayInside, top);
                    return;
                }
            }
        }
    }

    private void compareNodePrimWithArc(NodeInst ni, ArcInst ai, PolyMerge stayInside, StitchingTopology top) {
        Network arcNet = top.getArcNetwork(ai);
        Poly[] nodePolys = this.shapeOfNode(ni);
        int nTot = nodePolys.length;
        FixpTransform trans = ni.rotateOut();
        for (Poly arcPoly : ai.getProto().getTechnology().getShapeOfArc(ai)) {
            Layer arcLayer = arcPoly.getLayer();
            Layer.Function arcLayerFun = arcLayer.getFunction();
            if (!arcLayerFun.isMetal() && !arcLayerFun.isDiff() && !arcLayerFun.isPoly()) continue;
            FixpRectangle arcBounds = arcPoly.getBounds2D();
            double aCX = ((RectangularShape)arcBounds).getCenterX();
            double aCY = ((RectangularShape)arcBounds).getCenterY();
            for (int j = 0; j < nTot; ++j) {
                double polyDist;
                Poly nodePoly = nodePolys[j];
                nodePoly.transform(trans);
                Layer nodeLayer = nodePoly.getLayer();
                if (nodeLayer != null) {
                    nodeLayer = nodeLayer.getNonPseudoLayer();
                }
                if (nodeLayer.getFunction() != arcLayerFun || (polyDist = arcPoly.separation(nodePoly)) >= DBMath.getEpsilon() || nodePoly.getPort() == null) continue;
                PortProto bestPp = null;
                double bestDist = 0.0;
                Iterator<PortProto> pIt = ni.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto tPp = pIt.next();
                    if (!top.portsConnected(ni, tPp, nodePoly.getPort())) continue;
                    Poly portPoly = ni.getShapeOfPort(tPp);
                    double portCX = portPoly.getCenterX();
                    double portCY = portPoly.getCenterY();
                    double dist = Math.abs(portCX - aCX) + Math.abs(portCY - aCY);
                    if (bestPp == null) {
                        bestDist = dist;
                    }
                    if (dist > bestDist) continue;
                    bestPp = tPp;
                    bestDist = dist;
                }
                if (bestPp == null) continue;
                PortInst pi = ni.findPortInstFromEquivalentProto(bestPp);
                Poly portPoly = ni.getShapeOfPort(bestPp);
                double portCX = portPoly.getCenterX();
                double portCY = portPoly.getCenterY();
                Network nodeNet = top.getPortNetwork(pi);
                if (arcNet == nodeNet) continue;
                if (this.alignment != null) {
                    if (this.alignment.getWidth() > 0.0) {
                        portCX = (double)Math.round(portCX / this.alignment.getWidth()) * this.alignment.getWidth();
                        aCX = (double)Math.round(aCX / this.alignment.getWidth()) * this.alignment.getWidth();
                    }
                    if (this.alignment.getHeight() > 0.0) {
                        portCY = (double)Math.round(portCY / this.alignment.getHeight()) * this.alignment.getHeight();
                        aCY = (double)Math.round(aCY / this.alignment.getHeight()) * this.alignment.getHeight();
                    }
                }
                Point2D.Double bend1 = new Point2D.Double(portCX, aCY);
                Point2D.Double bend2 = new Point2D.Double(aCX, portCY);
                if (stayInside != null) {
                    if (!stayInside.contains(arcLayer, bend1)) {
                        bend1 = bend2;
                    }
                } else if (!arcPoly.contains(bend1)) {
                    bend1 = bend2;
                }
                this.connectObjects(ai, arcNet, pi, nodeNet, ai.getParent(), bend1, stayInside, top);
                return;
            }
        }
    }

    private boolean testPoly(NodeInst ni, PortProto pp, ArcProto ap, Poly poly, NodeInst oNi, StitchingTopology top, Map<NodeInst, ObjectQTree> nodePortBounds, Map<ArcProto, Layer> arcLayers, PolyMerge stayInside, Rectangle2D limitBound) {
        boolean connectionsMade;
        block24: {
            Network net;
            block23: {
                Rectangle2D.Double biggerBounds;
                PortInst pi = ni.findPortInstFromEquivalentProto(pp);
                Name portNK = pp.getNameKey();
                connectionsMade = false;
                TreeSet<Network> netsConnectedTo = new TreeSet<Network>();
                net = top.getNodeNetwork(ni, pp);
                if (net == null) {
                    return false;
                }
                netsConnectedTo.add(net);
                if (!oNi.isCellInstance()) break block23;
                FixpRectangle bounds = poly.getBounds2D();
                ObjectQTree oqt = nodePortBounds.get(oNi);
                Set set = oqt.find(biggerBounds = new Rectangle2D.Double(((RectangularShape)bounds).getMinX() - 1.0, ((RectangularShape)bounds).getMinY() - 1.0, ((RectangularShape)bounds).getWidth() + 2.0, ((RectangularShape)bounds).getHeight() + 2.0));
                if (set == null) break block24;
                block0: for (Object obj : set) {
                    Poly[] polys;
                    int tot;
                    PortInst oPi = (PortInst)obj;
                    PortProto mPp = oPi.getPortProto();
                    if (!mPp.getBasePort().connectsTo(ap)) continue;
                    Network oNet = null;
                    Name oPortNK = mPp.getNameKey();
                    if (portNK.isBus() && oPortNK.isBus()) {
                        if (portNK.busWidth() != oPortNK.busWidth()) continue;
                        ap = Schematics.tech().bus_arc;
                    } else {
                        oNet = top.getPortNetwork(oNi.findPortInstFromEquivalentProto(mPp));
                        if (net != null && oNet == net) continue;
                    }
                    boolean ignore = false;
                    Iterator<Connection> piit = oPi.getConnections();
                    while (piit.hasNext()) {
                        Connection conn = piit.next();
                        ArcInst ai = conn.getArc();
                        if (ai.getHeadPortInst() == pi) {
                            ignore = true;
                        }
                        if (ai.getTailPortInst() != pi) continue;
                        ignore = true;
                    }
                    if (ignore) continue;
                    FixpTransform trans = oNi.rotateOut();
                    NodeInst rNi = oNi;
                    PortProto rPp = mPp;
                    while (rNi.isCellInstance()) {
                        FixpTransform temp = rNi.translateOut();
                        temp.preConcatenate(trans);
                        Export e = (Export)rPp;
                        rNi = e.getOriginalPort().getNodeInst();
                        rPp = e.getOriginalPort().getPortProto();
                        trans = rNi.rotateOut();
                        trans.preConcatenate(temp);
                    }
                    Cell subcell = (Cell)oNi.getProto();
                    Netlist netlist = subcell.getNetlist();
                    if (mPp instanceof Export) {
                        Export mPpe = (Export)mPp;
                        Network netm = netlist.getNetwork(mPpe, 0);
                        assert (netm != null);
                        if (netsConnectedTo.contains(netm)) continue;
                        netsConnectedTo.add(netm);
                    }
                    if ((tot = (polys = this.shapeOfNode(rNi)).length) == 0) {
                        Poly oPoly = oNi.getShapeOfPort(mPp);
                        if (!this.comparePoly(oNi, mPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, top, limitBound)) continue;
                        connectionsMade = true;
                        continue;
                    }
                    Netlist subNetlist = rNi.getParent().getNetlist();
                    for (int j = 0; j < tot; ++j) {
                        Poly oPoly = polys[j];
                        if (oPoly.getPort() == null || !subNetlist.portsConnected(rNi, rPp, oPoly.getPort())) continue;
                        if (ni.getProto() != Generic.tech().simProbeNode) {
                            Layer oLayer = oPoly.getLayer();
                            if (oLayer != null) {
                                oLayer = oLayer.getNonPseudoLayer();
                            }
                            Layer apLayer = arcLayers.get(ap);
                            if (!oLayer.getTechnology().sameLayer(oLayer, apLayer)) continue;
                        }
                        oPoly.transform(trans);
                        if (!this.comparePoly(oNi, mPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, top, limitBound)) continue;
                        connectionsMade = true;
                        continue block0;
                    }
                }
                break block24;
            }
            FixpTransform trans = oNi.rotateOut();
            double ox = poly.getCenterX();
            double oy = poly.getCenterY();
            Poly[] polys = this.shapeOfNode(oNi);
            int tot = polys.length;
            if (tot == 0) {
                PortProto bestPp = null;
                double bestDist = 0.0;
                Iterator<PortProto> pIt = oNi.getProto().getPorts();
                while (pIt.hasNext()) {
                    PortProto rPp = pIt.next();
                    Poly portPoly = oNi.getShapeOfPort(rPp);
                    double dist = Math.abs(portPoly.getCenterX() - ox) + Math.abs(portPoly.getCenterY() - oy);
                    if (bestPp == null) {
                        bestDist = dist;
                        bestPp = rPp;
                    }
                    if (dist > bestDist) continue;
                    bestPp = rPp;
                    bestDist = dist;
                }
                if (bestPp != null) {
                    Poly oPoly;
                    PortProto rPp = bestPp;
                    Network oNet = top.getPortNetwork(oNi.findPortInstFromEquivalentProto(bestPp));
                    if ((net == null || oNet != net) && rPp.getBasePort().connectsTo(ap) && this.comparePoly(oNi, rPp, oPoly = oNi.getShapeOfPort(rPp), oNet, ni, pp, poly, net, ap, stayInside, top, limitBound)) {
                        return true;
                    }
                }
            } else {
                for (int j = 0; j < tot; ++j) {
                    PortProto rPp;
                    Layer apLayer;
                    Poly oPoly = polys[j];
                    if (oPoly.getPort() == null) continue;
                    Layer oLayer = oPoly.getLayer();
                    if (oLayer != null) {
                        oLayer = oLayer.getNonPseudoLayer();
                    }
                    if (!(apLayer = arcLayers.get(ap)).getTechnology().sameLayer(apLayer, oLayer)) continue;
                    PortInst oPi = oNi.findPortInstFromEquivalentProto(oPoly.getPort());
                    Network oNet = top.getPortNetwork(oPi);
                    if (net != null && oNet == net) continue;
                    PortProto bestPp = null;
                    double bestDist = 0.0;
                    Iterator<PortProto> pIt = oNi.getProto().getPorts();
                    while (pIt.hasNext()) {
                        PortProto rPp2 = pIt.next();
                        if (!top.portsConnected(oNi, rPp2, oPoly.getPort())) continue;
                        Poly portPoly = oNi.getShapeOfPort(rPp2);
                        double dist = Math.abs(ox - portPoly.getCenterX()) + Math.abs(oy - portPoly.getCenterY());
                        if (bestPp == null) {
                            bestDist = dist;
                        }
                        if (dist > bestDist) continue;
                        bestPp = rPp2;
                        bestDist = dist;
                    }
                    if (bestPp == null || !(rPp = bestPp).getBasePort().connectsTo(ap)) continue;
                    oPoly.transform(trans);
                    if (!this.comparePoly(oNi, rPp, oPoly, oNet, ni, pp, poly, net, ap, stayInside, top, limitBound)) continue;
                    return true;
                }
            }
        }
        return connectionsMade;
    }

    private boolean comparePoly(NodeInst oNi, PortProto opp, Poly oPoly, Network oNet, NodeInst ni, PortProto pp, Poly poly, Network net, ArcProto ap, PolyMerge stayInside, StitchingTopology top, Rectangle2D limitBound) {
        Point2D.Double tPortCenter;
        double tDist;
        PortProto tPp;
        double sep = poly.separation(oPoly);
        if (sep > DBMath.getEpsilon()) {
            return false;
        }
        Poly portPoly = ni.getShapeOfPort(pp);
        Point2D.Double portCenter = new Point2D.Double(portPoly.getCenterX(), portPoly.getCenterY());
        Poly oPortPoly = oNi.getShapeOfPort(opp);
        Point2D.Double oPortCenter = new Point2D.Double(oPortPoly.getCenterX(), oPortPoly.getCenterY());
        if (stayInside == null && (ni.isCellInstance() || oNi.isCellInstance())) {
            FixpRectangle polyBounds = portPoly.getBounds2D();
            FixpRectangle oPolyBounds = oPortPoly.getBounds2D();
            if ((((RectangularShape)polyBounds).getMinX() > ((RectangularShape)oPolyBounds).getMaxX() || ((RectangularShape)oPolyBounds).getMinX() > ((RectangularShape)polyBounds).getMaxX()) && (((RectangularShape)polyBounds).getMinY() > ((RectangularShape)oPolyBounds).getMaxY() || ((RectangularShape)oPolyBounds).getMinY() > ((RectangularShape)polyBounds).getMaxY())) {
                return false;
            }
        }
        double dist = portCenter.distance(oPortCenter);
        Iterator<PortProto> it = oNi.getProto().getPorts();
        while (it.hasNext()) {
            tPp = it.next();
            if (tPp == opp || !top.portsConnected(oNi, tPp, opp) || !tPp.getBasePort().connectsTo(ap) || (tDist = portCenter.distance(tPortCenter = new Point2D.Double((portPoly = oNi.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
            dist = tDist;
            opp = tPp;
            oPortCenter.setLocation(tPortCenter);
        }
        it = ni.getProto().getPorts();
        while (it.hasNext()) {
            tPp = it.next();
            if (tPp == pp || !top.portsConnected(ni, tPp, pp) || !tPp.getBasePort().connectsTo(ap) || (tDist = oPortCenter.distance(tPortCenter = new Point2D.Double((portPoly = ni.getShapeOfPort(tPp)).getCenterX(), portPoly.getCenterY()))) >= dist) continue;
            dist = tDist;
            pp = tPp;
            portCenter.setLocation(tPortCenter);
        }
        if (limitBound != null && !DBMath.pointInRect(portCenter, limitBound) && !DBMath.pointInRect(oPortCenter, limitBound)) {
            return false;
        }
        double x2 = (((Point2D)oPortCenter).getX() + ((Point2D)portCenter).getX()) / 2.0;
        double y = (((Point2D)oPortCenter).getY() + ((Point2D)portCenter).getY()) / 2.0;
        if (this.alignment != null) {
            if (this.alignment.getWidth() > 0.0) {
                x2 = (double)Math.round(x2 / this.alignment.getWidth()) * this.alignment.getWidth();
            }
            if (this.alignment.getHeight() > 0.0) {
                y = (double)Math.round(y / this.alignment.getHeight()) * this.alignment.getHeight();
            }
        }
        PortInst pi = ni.findPortInstFromEquivalentProto(pp);
        PortInst opi = oNi.findPortInstFromEquivalentProto(opp);
        ArcProto oldAP = User.getUserTool().getCurrentArcProto();
        User.getUserTool().setCurrentArcProtoTemporarily(ap);
        boolean didConnect = this.connectObjects(pi, net, opi, oNet, ni.getParent(), new Point2D.Double(x2, y), stayInside, top);
        User.getUserTool().setCurrentArcProtoTemporarily(oldAP);
        return didConnect;
    }

    private boolean connectObjects(ElectricObject eobj1, Network net1, ElectricObject eobj2, Network net2, Cell cell, Point2D ctr, PolyMerge stayInside, StitchingTopology top) {
        NodeInst ni1 = null;
        if (eobj1 instanceof NodeInst) {
            ni1 = (NodeInst)eobj1;
        } else if (eobj1 instanceof PortInst) {
            ni1 = ((PortInst)eobj1).getNodeInst();
        }
        NodeInst ni2 = null;
        if (eobj2 instanceof NodeInst) {
            ni2 = (NodeInst)eobj2;
        } else if (eobj2 instanceof PortInst) {
            ni2 = ((PortInst)eobj2).getNodeInst();
        }
        Rectangle2D nullRect = null;
        Route route = this.router.planRoute(cell, eobj1, eobj2, ctr, stayInside, this.ep, true, true, nullRect, this.alignment);
        if (route.size() == 0) {
            return false;
        }
        this.allRoutes.add(route);
        top.connect(net1, net2);
        if (ni1 != null && ni1.getFunction().isPin() && !ni1.hasExports() && !ni1.hasConnections() && !this.possibleInlinePins.contains(ni1)) {
            this.possibleInlinePins.add(ni1);
        }
        if (ni2 != null && ni2.getFunction().isPin() && !ni2.hasExports() && !ni2.hasConnections() && !this.possibleInlinePins.contains(ni2)) {
            this.possibleInlinePins.add(ni2);
        }
        return true;
    }

    private void checkExportCreationStitching(Geometric geom, Map<Long, List<PolyConnection>> overlapMap, GatherNetworksVisitor gatherNetworks) {
        Cell cell = geom.getParent();
        NodeInst ni = null;
        if (geom instanceof NodeInst) {
            ni = (NodeInst)geom;
        }
        ArrayList<Geometric> geomsInArea = new ArrayList<Geometric>();
        ERectangle geomBounds = geom.getBounds();
        double epsilon = DBMath.getEpsilon();
        Rectangle2D.Double searchBounds = new Rectangle2D.Double(((RectangularShape)geomBounds).getMinX() - epsilon, ((RectangularShape)geomBounds).getMinY() - epsilon, ((RectangularShape)geomBounds).getWidth() + epsilon * 2.0, ((RectangularShape)geomBounds).getHeight() + epsilon * 2.0);
        Iterator<Geometric> it = cell.searchIterator(searchBounds);
        while (it.hasNext()) {
            Geometric oGeom = it.next();
            if (oGeom == geom) continue;
            geomsInArea.add(oGeom);
        }
        for (Geometric oGeom : geomsInArea) {
            if (oGeom instanceof ArcInst) {
                ArcInst oAi = (ArcInst)oGeom;
                if (ni == null || !ni.isCellInstance()) continue;
                this.compareNodeInstWithArcMakeExport(ni, oAi, overlapMap, gatherNetworks);
                continue;
            }
            NodeInst oNi = (NodeInst)oGeom;
            if (!oNi.isCellInstance()) {
                PrimitiveNode pnp = (PrimitiveNode)oNi.getProto();
                if (pnp.getTechnology() == Generic.tech() || !this.includePureLayerNodes && pnp.getFunction() == PrimitiveNode.Function.NODE || !this.includePureLayerNodes || pnp.getFunction() != PrimitiveNode.Function.NODE) continue;
                boolean hasValidLayer = false;
                Iterator<Layer> layIt = pnp.getLayerIterator();
                while (layIt.hasNext()) {
                    Layer l = layIt.next();
                    if (!l.getFunction().isMetal() && !l.getFunction().isDiff() && !l.getFunction().isPoly()) continue;
                    hasValidLayer = true;
                    break;
                }
                if (!hasValidLayer) continue;
            }
            if (ni == null) {
                if (!oNi.isCellInstance()) continue;
                this.compareNodeInstWithArcMakeExport(oNi, (ArcInst)geom, overlapMap, gatherNetworks);
                continue;
            }
            if (!ni.isCellInstance()) continue;
            this.compareTwoNodesMakeExport(ni, oNi, overlapMap, gatherNetworks);
        }
    }

    private void compareNodeInstWithArcMakeExport(NodeInst ni, ArcInst ai, Map<Long, List<PolyConnection>> overlapMap, GatherNetworksVisitor gatherNetworks) {
        Layer arcLayer;
        Layer.Function arcLayerFun;
        Poly arcPoly = null;
        Poly[] arcPolys = ai.getProto().getTechnology().getShapeOfArc(ai);
        int aTot = arcPolys.length;
        for (int i = 0; !(i >= aTot || (arcLayerFun = (arcLayer = (arcPoly = arcPolys[i]).getLayer()).getFunction()).isMetal() || arcLayerFun.isDiff() || arcLayerFun.isPoly()); ++i) {
            arcPoly = null;
        }
        if (arcPoly == null) {
            return;
        }
        int netID = gatherNetworks.getGlobalNetworkID(VarContext.globalContext, ai.getHeadPortInst());
        SubPolygon sp2 = new SubPolygon(arcPoly, VarContext.globalContext, netID, ai);
        ArcTouchVisitor atv = new ArcTouchVisitor(ai, arcPoly, ni, false, gatherNetworks);
        HierarchyEnumerator.enumerateCell(ni.getParent(), VarContext.globalContext, (HierarchyEnumerator.Visitor)atv);
        SubPolygon sp3 = atv.getExportDrillLocation();
        if (sp3 != null) {
            this.registerPoly(overlapMap, new PolyConnection(sp3, sp2));
            return;
        }
        atv.setDoArcs(true);
        HierarchyEnumerator.enumerateCell(ni.getParent(), VarContext.globalContext, (HierarchyEnumerator.Visitor)atv);
        sp3 = atv.getExportDrillLocation();
        if (sp3 != null) {
            this.registerPoly(overlapMap, new PolyConnection(sp3, sp2));
        }
    }

    private void makeExport(List<PolyConnection> polys) {
        if (polys.size() == 0) {
            return;
        }
        Point2D sp1AtTop = null;
        Point2D sp2AtTop = null;
        for (PolyConnection p : polys) {
            sp1AtTop = this.isExportedToTop(p.sp1);
            sp2AtTop = this.isExportedToTop(p.sp2);
            if (sp1AtTop == null || sp2AtTop == null) continue;
            return;
        }
        if (sp1AtTop != null) {
            sp1AtTop = new Point2D.Double(sp1AtTop.getX(), sp1AtTop.getY());
        }
        if (sp2AtTop != null) {
            sp2AtTop = new Point2D.Double(sp2AtTop.getX(), sp2AtTop.getY());
        }
        PolyConnection p = polys.get(0);
        ArrayList<Line2D> overlappingEdges = new ArrayList<Line2D>();
        List<PolyBase> intersectionList = p.sp1.poly.getIntersection(p.sp2.poly, overlappingEdges);
        PolyBase preferredExportArea = null;
        if (intersectionList != null && intersectionList.size() > 0) {
            preferredExportArea = intersectionList.get(0);
        } else if (overlappingEdges.size() > 0) {
            preferredExportArea = new PolyBase(((Line2D)overlappingEdges.get(0)).getBounds());
        }
        ArcProto ap = null;
        if (p.sp1.theObj instanceof ArcInst) {
            ap = ((ArcInst)p.sp1.theObj).getProto();
        }
        if (p.sp2.theObj instanceof ArcInst) {
            ap = ((ArcInst)p.sp2.theObj).getProto();
        }
        if (ap == null) {
            ap = Router.getArcToUse(p.sp1.poly.getPort(), p.sp2.poly.getPort());
        }
        if (sp1AtTop == null && p.sp1.theObj instanceof NodeInst) {
            sp1AtTop = this.makeExportDrill((NodeInst)p.sp1.theObj, p.sp1.poly.getPort(), p.sp1.context, preferredExportArea, ap);
        }
        if (sp2AtTop == null && p.sp2.theObj instanceof NodeInst) {
            sp2AtTop = this.makeExportDrill((NodeInst)p.sp2.theObj, p.sp2.poly.getPort(), p.sp2.context, preferredExportArea, ap);
        }
        if (sp1AtTop == null && p.sp1.theObj instanceof ArcInst && sp2AtTop != null) {
            this.makeExportDrillOnArc(sp2AtTop, p.sp1, preferredExportArea);
        }
        if (sp2AtTop == null && p.sp2.theObj instanceof ArcInst && sp1AtTop != null) {
            this.makeExportDrillOnArc(sp1AtTop, p.sp2, preferredExportArea);
        }
    }

    private Point2D isExportedToTop(SubPolygon sp2) {
        Geometric geom = sp2.theObj;
        if (geom instanceof NodeInst) {
            NodeInst ni = (NodeInst)geom;
            PortInst pi = ni.findPortInstFromEquivalentProto(sp2.poly.getPort());
            return this.isExportedToTop(pi, sp2.context);
        }
        if (geom instanceof ArcInst) {
            ArcInst ai = (ArcInst)geom;
            PortInst pi1 = ai.getHead().getPortInst();
            PortInst pi2 = ai.getTail().getPortInst();
            Point2D point1 = this.isExportedToTop(pi1, sp2.context);
            if (point1 != null) {
                return point1;
            }
            return this.isExportedToTop(pi2, sp2.context);
        }
        return null;
    }

    private Point2D isExportedToTop(PortInst pi, VarContext context) {
        while (context != VarContext.globalContext) {
            if (pi.getExports().hasNext()) {
                Export e = pi.getExports().next();
                Nodable no = context.getNodable();
                if (no instanceof NodeInst) {
                    NodeInst ni = (NodeInst)no;
                    pi = ni.findPortInstFromEquivalentProto(e);
                    context = context.pop();
                    continue;
                }
                return null;
            }
            return null;
        }
        return pi.getCenter();
    }

    private Point2D makeExportDrill(NodeInst ni, PortProto exportThis, VarContext where, PolyBase preferredExportArea, ArcProto ap) {
        PortInst pi;
        Point2D.Double topCoord = new Point2D.Double(0.0, 0.0);
        while (where != VarContext.globalContext && (pi = ni.findPortInstFromEquivalentProto(exportThis)) != null) {
            Iterator<Export> eIt = pi.getExports();
            boolean existingExportFound = false;
            if (eIt.hasNext()) {
                exportThis = eIt.next();
            } else {
                ERectangle bounds = ni.getBounds();
                Cell cell = ni.getParent();
                String exportName = this.getExportNameInCell(cell, pi);
                if (!ni.isCellInstance() && preferredExportArea != null && ap != null) {
                    Nodable no;
                    PrimitiveNode pn = (PrimitiveNode)ni.getProto();
                    Iterator<Nodable> noit = where.getPathIterator();
                    while (noit.hasNext() && (no = noit.next()) instanceof NodeInst) {
                        NodeInst niHier = (NodeInst)no;
                        FixpTransform trans = niHier.transformIn();
                        preferredExportArea.transform(trans);
                    }
                    Netlist netlist = cell.getNetlist();
                    Network net = netlist.getNetwork(pi);
                    Iterator<Export> eit = cell.getExports();
                    while (eit.hasNext()) {
                        Export ex = eit.next();
                        PortInst expi = ex.getOriginalPort();
                        if (!preferredExportArea.contains(expi.getCenter()) || net != netlist.getNetwork(expi) || !ex.connectsTo(ap)) continue;
                        existingExportFound = true;
                        exportThis = ex;
                        break;
                    }
                    if (!existingExportFound) {
                        Point2D center = preferredExportArea.getCenter();
                        if (this.alignment != null) {
                            double x2 = ((Point2D)center).getX();
                            double y = ((Point2D)center).getY();
                            if (this.alignment.getWidth() > 0.0) {
                                x2 = (double)Math.round(x2 / this.alignment.getWidth()) * this.alignment.getWidth();
                            }
                            if (this.alignment.getHeight() > 0.0) {
                                y = (double)Math.round(y / this.alignment.getHeight()) * this.alignment.getHeight();
                            }
                            center = new Point2D.Double(x2, y);
                        }
                        if (DBMath.pointInRect(center, (Rectangle2D)bounds) && (!preferredExportArea.contains(pi.getCenter()) || pn.getFunction() == PrimitiveNode.Function.NODE)) {
                            PrimitiveNode pin = ap.findPinProto();
                            NodeInst pinNi = NodeInst.newInstance(pin, this.ep, center, pin.getDefWidth(this.ep), pin.getDefHeight(this.ep), cell);
                            Route route = this.router.planRoute(cell, pinNi.getOnlyPortInst(), pi, center, null, this.ep, false, false, null, null);
                            if (!Router.createRouteNoJob(route, cell, new HashMap<ArcProto, Integer>(), new HashMap<NodeProto, Integer>(), this.ep)) {
                                pi = pinNi.getOnlyPortInst();
                            } else if (pinNi != null) {
                                pinNi.kill();
                            }
                        }
                    }
                }
                if (!existingExportFound) {
                    exportThis = Export.newInstance(cell, pi, exportName, this.ep);
                }
            }
            ni = where.getNodable().getNodeInst();
            where = where.pop();
            FixpTransform trans = ni.transformOut();
            trans.transform(pi.getPoly().getCenter(), topCoord);
        }
        return topCoord;
    }

    private void makeExportDrillOnArc(Point2D topLoc, SubPolygon sp2, PolyBase preferredExportArea) {
        ArcInst lowAI = (ArcInst)sp2.theObj;
        if (!lowAI.isLinked()) {
            return;
        }
        String arcName = lowAI.getName();
        if (lowAI.getNameKey().isTempname()) {
            arcName = null;
        }
        int angle = lowAI.getAngle();
        ArcProto ap = lowAI.getProto();
        double width = lowAI.getLambdaBaseWidth();
        Cell cell = lowAI.getParent();
        Iterator<Nodable> noit = sp2.context.getPathIterator();
        while (noit.hasNext()) {
            NodeInst niHier = noit.next().getNodeInst();
            FixpTransform trans = niHier.transformIn();
            trans.transform(topLoc, topLoc);
            if (preferredExportArea == null) continue;
            preferredExportArea.transform(trans);
        }
        Netlist netlist = cell.getNetlist();
        Network net = netlist.getNetwork(lowAI, 0);
        Iterator<Export> eit = cell.getExports();
        while (eit.hasNext()) {
            Export ex = eit.next();
            PortInst expi = ex.getOriginalPort();
            if (!preferredExportArea.contains(expi.getCenter()) || net != netlist.getNetwork(expi) || !ex.connectsTo(ap)) continue;
            this.makeExportDrill(ex.getOriginalPort().getNodeInst(), ex, sp2.context.pop(), preferredExportArea, ap);
            return;
        }
        NodeInst ni = null;
        if (GenMath.distToLine(lowAI.getHeadLocation(), lowAI.getTailLocation(), topLoc) > 0.0) {
            return;
        }
        PrimitiveNode pNp = lowAI.getProto().findPinProto();
        ni = NodeInst.makeInstance(pNp, this.ep, topLoc, pNp.getDefWidth(this.ep), pNp.getDefHeight(this.ep), cell);
        ArcInst newAi1 = ArcInst.makeInstanceBase(ap, this.ep, width, lowAI.getHeadPortInst(), ni.getOnlyPortInst(), lowAI.getHeadLocation(), topLoc, null);
        ArcInst newAi2 = ArcInst.makeInstanceBase(ap, this.ep, width, ni.getOnlyPortInst(), lowAI.getTailPortInst(), topLoc, lowAI.getTailLocation(), null);
        newAi1.setHeadNegated(lowAI.isHeadNegated());
        newAi1.setHeadExtended(lowAI.isHeadExtended());
        newAi1.setHeadArrowed(lowAI.isHeadArrowed());
        newAi2.setTailNegated(lowAI.isTailNegated());
        newAi2.setTailExtended(lowAI.isTailExtended());
        newAi2.setTailArrowed(lowAI.isTailArrowed());
        lowAI.kill();
        if (arcName != null) {
            if (lowAI.getHeadLocation().distance(topLoc) > lowAI.getTailLocation().distance(topLoc)) {
                newAi1.setName(arcName, this.ep);
                newAi1.copyTextDescriptorFrom(lowAI, ArcInst.ARC_NAME);
            } else {
                newAi2.setName(arcName, this.ep);
                newAi2.copyTextDescriptorFrom(lowAI, ArcInst.ARC_NAME);
            }
        }
        newAi1.setAngle(angle);
        newAi2.setAngle(angle);
        this.makeExportDrill(ni, ni.getOnlyPortInst().getPortProto(), sp2.context, preferredExportArea, ap);
    }

    private String getExportNameInCell(Cell cell, PortInst pi) {
        Netlist nl = cell.getNetlist();
        Network net = nl.getNetwork(pi);
        String exportName = null;
        Iterator<String> nIt = net.getExportedNames();
        while (nIt.hasNext()) {
            String eName = nIt.next();
            if (eName.startsWith("E") && eName.length() > 1 && TextUtils.isDigit(eName.charAt(1)) || exportName != null && exportName.length() >= eName.length()) continue;
            exportName = eName;
        }
        if (exportName == null) {
            exportName = "E1";
        }
        exportName = ElectricObject.uniqueObjectName(exportName, cell, PortProto.class, false, true);
        return exportName;
    }

    private void compareTwoNodesMakeExport(NodeInst ni1, NodeInst ni2, Map<Long, List<PolyConnection>> overlapMap, GatherNetworksVisitor gatherNetworks) {
        if (!ni2.isCellInstance()) {
            NodeInst swap = ni1;
            ni1 = ni2;
            ni2 = swap;
        }
        if (!ni2.isCellInstance()) {
            return;
        }
        if (ni1.getProto().getTechnology() != ni2.getProto().getTechnology()) {
            return;
        }
        Rectangle2D bound1 = ni1.getBounds();
        Rectangle2D bound2 = ni2.getBounds();
        if (!DBMath.rectsIntersect(bound1 = new Rectangle2D.Double(bound1.getMinX() - DBMath.getEpsilon(), bound1.getMinY() - DBMath.getEpsilon(), bound1.getWidth() + DBMath.getEpsilon() * 2.0, bound1.getHeight() + DBMath.getEpsilon() * 2.0), bound2 = new Rectangle2D.Double(((RectangularShape)bound2).getMinX() - DBMath.getEpsilon(), ((RectangularShape)bound2).getMinY() - DBMath.getEpsilon(), ((RectangularShape)bound2).getWidth() + DBMath.getEpsilon() * 2.0, ((RectangularShape)bound2).getHeight() + DBMath.getEpsilon() * 2.0))) {
            return;
        }
        Rectangle2D intersectArea = bound1.createIntersection(bound2);
        RTNode<SubPolygon> rtree = null;
        if (ni1.isCellInstance()) {
            GatherPolygonVisitor gpv = new GatherPolygonVisitor(intersectArea, ni1, gatherNetworks);
            HierarchyEnumerator.enumerateCell(ni1.getParent(), VarContext.globalContext, (HierarchyEnumerator.Visitor)gpv);
            rtree = gpv.getRTree();
        } else {
            rtree = RTNode.makeTopLevel();
            Technology tech = ni1.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni1, true, true, null);
            FixpTransform trans = ni1.rotateOut();
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                poly.transform(trans);
                int netID = -1;
                if (poly.getPort() != null) {
                    netID = gatherNetworks.getGlobalNetworkID(VarContext.globalContext, ni1.findPortInstFromEquivalentProto(poly.getPort()));
                }
                if (!DBMath.rectsIntersect(poly.getBounds2D(), intersectArea)) continue;
                rtree = RTNode.linkGeom(null, rtree, new SubPolygon(poly, VarContext.globalContext, netID, ni1));
            }
        }
        CheckPolygonVisitor cpv = new CheckPolygonVisitor(rtree, intersectArea, ni2, gatherNetworks);
        HierarchyEnumerator.enumerateCell(ni2.getParent(), VarContext.globalContext, (HierarchyEnumerator.Visitor)cpv);
        List<PolyConnection> polysFound = cpv.getFoundConnections();
        for (PolyConnection p : polysFound) {
            this.registerPoly(overlapMap, p);
        }
    }

    private void registerPoly(Map<Long, List<PolyConnection>> overlapMap, PolyConnection p) {
        long netID2;
        long netID1;
        if (p.sp1.netID > p.sp2.netID) {
            SubPolygon spTemp = p.sp1;
            p.sp1 = p.sp2;
            p.sp2 = spTemp;
        }
        if ((netID1 = (long)p.sp1.netID) == (netID2 = (long)p.sp2.netID)) {
            return;
        }
        if (netID1 < 0L || netID2 < 0L) {
            System.out.println("Ignoring poly " + p.sp1.theObj.describe(false) + ", netID is " + netID1);
            System.out.println("Ignoring poly " + p.sp2.theObj.describe(false) + ", netID is " + netID2);
            return;
        }
        Long key = new Long(netID1 << 32 | netID2);
        List<PolyConnection> polys = overlapMap.get(key);
        if (polys == null) {
            polys = new ArrayList<PolyConnection>();
            overlapMap.put(key, polys);
        }
        polys.add(p);
    }

    private boolean arcTooWide(ArcInst ai) {
        boolean headTooWide = true;
        NodeInst hNi = ai.getHeadPortInst().getNodeInst();
        if (hNi.isCellInstance()) {
            headTooWide = false;
        } else if (ai.getLambdaBaseWidth() <= hNi.getLambdaBaseXSize() && ai.getLambdaBaseWidth() <= hNi.getLambdaBaseYSize()) {
            headTooWide = false;
        }
        boolean tailTooWide = true;
        NodeInst tNi = ai.getTailPortInst().getNodeInst();
        if (tNi.isCellInstance()) {
            tailTooWide = false;
        } else if (ai.getLambdaBaseWidth() <= tNi.getLambdaBaseXSize() && ai.getLambdaBaseWidth() <= tNi.getLambdaBaseYSize()) {
            tailTooWide = false;
        }
        return headTooWide || tailTooWide;
    }

    private Poly[] shapeOfNode(NodeInst ni) {
        Technology tech = ni.getProto().getTechnology();
        if (tech.isSchematics()) {
            return new Poly[0];
        }
        Poly[] nodePolys = tech.getShapeOfNode(ni, true, true, null);
        if (nodePolys.length == 0) {
            return nodePolys;
        }
        if (ni.getFunction().isPin()) {
            boolean gotOne = false;
            Rectangle2D.Double coverage = null;
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = it.next();
                ArcInst ai = con.getArc();
                if (ai.getLambdaBaseWidth() >= ni.getLambdaBaseXSize() && ai.getLambdaBaseWidth() >= ni.getLambdaBaseYSize() && ai.isHeadExtended() && ai.isTailExtended()) {
                    gotOne = true;
                    break;
                }
                Poly[] arcPolys = ai.getProto().getTechnology().getShapeOfArc(ai);
                if (arcPolys.length == 0) continue;
                Poly arcPoly = arcPolys[0];
                FixpRectangle arcBounds = arcPoly.getBounds2D();
                Rectangle2D.Double arcBoundsLimited = new Rectangle2D.Double();
                Rectangle2D.intersect(nodePolys[0].getBounds2D(), arcBounds, arcBoundsLimited);
                if (coverage == null) {
                    coverage = arcBoundsLimited;
                    continue;
                }
                Rectangle2D.union(coverage, arcBoundsLimited, coverage);
            }
            if (!gotOne) {
                if (coverage == null) {
                    return new Poly[0];
                }
                Poly newPoly = new Poly(coverage);
                newPoly.setStyle(nodePolys[0].getStyle());
                newPoly.setLayer(nodePolys[0].getLayerOrPseudoLayer());
                newPoly.setPort(nodePolys[0].getPort());
                FixpTransform trans = ni.rotateIn();
                newPoly.transform(trans);
                nodePolys[0] = newPoly;
            }
        }
        return nodePolys;
    }

    private void findSmallestLayer(ArcProto ap, Map<ArcProto, Layer> arcLayers) {
        if (arcLayers.get(ap) != null) {
            return;
        }
        Layer smallestLayer = ap.getLayer(0);
        ECoord smallestExtend = ap.getLayerExtend(0);
        for (int arcLayer = 1; arcLayer < ap.getNumArcLayers(); ++arcLayer) {
            ECoord extend = ap.getLayerExtend(arcLayer);
            if (extend.compareTo(smallestExtend) >= 0) continue;
            smallestLayer = ap.getLayer(arcLayer);
            smallestExtend = extend;
        }
        arcLayers.put(ap, smallestLayer);
    }

    public static class AutoOptions
    implements Serializable {
        public boolean createExports;
        public ArcProto preferredArc;

        public AutoOptions(boolean factory) {
            if (factory) {
                this.createExports = false;
                this.preferredArc = Technology.getCurrent().getArcs().next();
            } else {
                this.createExports = Routing.isAutoStitchCreateExports();
                this.preferredArc = Routing.getPreferredRoutingArcProto();
            }
        }
    }

    private static class StitchingTopology {
        private Netlist netlist;
        private Map<Network, List<Network>> connected;

        StitchingTopology(Cell cell) {
            this.netlist = cell.getNetlist();
            if (this.netlist == null) {
                System.out.println("Auto-router cannot get netlist information for cell " + cell.describe(false));
            }
            this.connected = new HashMap<Network, List<Network>>();
        }

        Network getNodeNetwork(NodeInst ni, PortProto pp) {
            Network net = this.netlist.getNetwork(ni, pp, 0);
            return this.getRealNet(net);
        }

        Network getPortNetwork(PortInst pi) {
            Network net = this.netlist.getNetwork(pi);
            return this.getRealNet(net);
        }

        Network getArcNetwork(ArcInst ai) {
            Network net = this.netlist.getNetwork(ai, 0);
            return this.getRealNet(net);
        }

        boolean portsConnected(NodeInst ni, PortProto pp1, PortProto pp2) {
            return this.netlist.portsConnected(ni, pp1, pp2);
        }

        private Network getRealNet(Network net) {
            List<Network> nets = this.connected.get(net);
            if (nets == null) {
                return net;
            }
            return nets.get(0);
        }

        public void connect(Network net1, Network net2) {
            List<Network> conNets1 = this.connected.get(net1);
            List<Network> conNets2 = this.connected.get(net2);
            if (conNets1 == null && conNets2 == null) {
                ArrayList<Network> both = new ArrayList<Network>();
                both.add(net1);
                both.add(net2);
                this.connected.put(net1, both);
                this.connected.put(net2, both);
                return;
            }
            if (conNets1 == null) {
                if (!conNets2.contains(net1)) {
                    conNets2.add(net1);
                }
                this.connected.put(net1, conNets2);
                return;
            }
            if (conNets2 == null) {
                if (!conNets1.contains(net2)) {
                    conNets1.add(net2);
                }
                this.connected.put(net2, conNets1);
                return;
            }
            ArrayList<Network> combined = new ArrayList<Network>();
            for (Network net : conNets1) {
                combined.add(net);
            }
            for (Network net : conNets2) {
                if (combined.contains(net)) continue;
                combined.add(net);
            }
            for (Network net : combined) {
                this.connected.put(net, combined);
            }
        }
    }

    private static class CompRoutes
    implements Comparator<Route> {
        private CompRoutes() {
        }

        @Override
        public int compare(Route r1, Route r2) {
            int res;
            NodeInst n2e;
            NodeInst n2s;
            NodeInst n1e;
            boolean r2ToArc;
            RouteElementPort r1s = r1.getStart();
            RouteElementPort r1e = r1.getEnd();
            RouteElementPort r2s = r2.getStart();
            RouteElementPort r2e = r2.getEnd();
            boolean r1ToArc = r1s.getPortInst() == null || r1e.getPortInst() == null;
            boolean bl = r2ToArc = r2s.getPortInst() == null || r2e.getPortInst() == null;
            if (r1ToArc && !r2ToArc) {
                return 1;
            }
            if (!r1ToArc && r2ToArc) {
                return -1;
            }
            if (r1ToArc && r2ToArc) {
                ArcProto ap1 = null;
                ArcProto ap2 = null;
                if (r1s.getNewArcs().hasNext()) {
                    ap1 = ((RouteElementArc)r1s.getNewArcs().next()).getArcProto();
                }
                if (r1e.getNewArcs().hasNext()) {
                    ap1 = ((RouteElementArc)r1e.getNewArcs().next()).getArcProto();
                }
                if (r2s.getNewArcs().hasNext()) {
                    ap2 = ((RouteElementArc)r2s.getNewArcs().next()).getArcProto();
                }
                if (r2e.getNewArcs().hasNext()) {
                    ap2 = ((RouteElementArc)r2e.getNewArcs().next()).getArcProto();
                }
                if (ap1 == null || ap2 == null) {
                    return 0;
                }
                return ap1.compareTo(ap2);
            }
            NodeInst n1s = r1s.getPortInst().getNodeInst();
            if (n1s.compareTo(n1e = r1e.getPortInst().getNodeInst()) < 0) {
                NodeInst s = n1s;
                n1s = n1e;
                n1e = s;
                RouteElementPort se = r1s;
                r1s = r1e;
                r1e = se;
            }
            if ((n2s = r2s.getPortInst().getNodeInst()).compareTo(n2e = r2e.getPortInst().getNodeInst()) < 0) {
                NodeInst s = n2s;
                n2s = n2e;
                n2e = s;
                RouteElementPort se = r2s;
                r2s = r2e;
                r2e = se;
            }
            if ((res = n1s.compareTo(n2s)) != 0) {
                return res;
            }
            res = n1e.compareTo(n2e);
            if (res != 0) {
                return res;
            }
            res = r1s.getPortInst().getPortProto().getName().compareTo(r2s.getPortInst().getPortProto().getName());
            if (res != 0) {
                return res;
            }
            res = r1e.getPortInst().getPortProto().getName().compareTo(r2e.getPortInst().getPortProto().getName());
            if (res != 0) {
                return res;
            }
            return 0;
        }
    }

    private class GatherNetworksVisitor
    extends HierarchyEnumerator.Visitor {
        private Map<String, Map<PortInst, Integer>> networkToNetID = new HashMap<String, Map<PortInst, Integer>>();

        private GatherNetworksVisitor() {
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            VarContext context = info.getContext();
            String key = context.getInstPath(".");
            Map<PortInst, Integer> netIdMap = this.networkToNetID.get(key);
            if (netIdMap == null) {
                netIdMap = new HashMap<PortInst, Integer>();
                this.networkToNetID.put(key, netIdMap);
            }
            Netlist netlist = info.getNetlist();
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                Iterator<PortInst> pit = ni.getPortInsts();
                while (pit.hasNext()) {
                    PortInst pi = pit.next();
                    Network net = netlist.getNetwork(pi);
                    if (net == null) continue;
                    int netID = info.getNetID(net);
                    netIdMap.put(pi, new Integer(netID));
                }
            }
        }

        @Override
        public boolean visitNodeInst(Nodable ni, HierarchyEnumerator.CellInfo info) {
            return true;
        }

        private int getGlobalNetworkID(VarContext context, PortInst pi) {
            if (pi == null) {
                return -1;
            }
            if (context == null) {
                return -1;
            }
            String key = context.getInstPath(".");
            Map<PortInst, Integer> netIdMap = this.networkToNetID.get(key);
            if (netIdMap == null) {
                return -1;
            }
            if (!netIdMap.containsKey(pi)) {
                return -1;
            }
            return netIdMap.get(pi);
        }
    }

    private class GatherPolygonVisitor
    extends HierarchyEnumerator.Visitor {
        private RTNode<SubPolygon> rtree = RTNode.makeTopLevel();
        private Rectangle2D intersectArea;
        private NodeInst cellOfInterest;
        private GatherNetworksVisitor gatherNetworks;

        public GatherPolygonVisitor(Rectangle2D intersectArea, NodeInst cellOfInterest, GatherNetworksVisitor gatherNetworks) {
            this.intersectArea = intersectArea;
            this.cellOfInterest = cellOfInterest;
            this.gatherNetworks = gatherNetworks;
        }

        public RTNode<SubPolygon> getRTree() {
            return this.rtree;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            FixpTransform toTop = info.getTransformToRoot();
            Iterator<Geometric> it = info.getCell().getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (ni.isCellInstance()) continue;
                FixpTransform nodeTrans = ni.rotateOut(toTop);
                Technology tech = ni.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni, true, true, null);
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    Layer.Function nodeLayerFun = poly.getLayer().getFunction();
                    if (!nodeLayerFun.isMetal() && !nodeLayerFun.isDiff() && !nodeLayerFun.isPoly() || poly.getPort() == null) continue;
                    poly.transform(nodeTrans);
                    if (!DBMath.rectsIntersect(poly.getBounds2D(), this.intersectArea)) continue;
                    int netID = this.gatherNetworks.getGlobalNetworkID(info.getContext(), ni.findPortInstFromEquivalentProto(poly.getPort()));
                    this.rtree = RTNode.linkGeom(null, this.rtree, new SubPolygon(poly, info.getContext(), netID, ni));
                }
            }
            it = info.getCell().getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                Technology tech = ai.getProto().getTechnology();
                Poly[] arcPolyList = tech.getShapeOfArc(ai);
                for (int i = 0; i < arcPolyList.length; ++i) {
                    Poly poly = arcPolyList[i];
                    Layer.Function arcLayerFun = poly.getLayer().getFunction();
                    if (!arcLayerFun.isMetal() && !arcLayerFun.isDiff() && !arcLayerFun.isPoly()) continue;
                    ((PolyBase)poly).transform(toTop);
                    if (!DBMath.rectsIntersect(poly.getBounds2D(), this.intersectArea)) continue;
                    int netID = this.gatherNetworks.getGlobalNetworkID(info.getContext(), ai.getHeadPortInst());
                    this.rtree = RTNode.linkGeom(null, this.rtree, new SubPolygon(poly, info.getContext(), netID, ai));
                }
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = no.getNodeInst();
            if (info.isRootCell() && ni != this.cellOfInterest) {
                return false;
            }
            if (!ni.isCellInstance()) {
                return false;
            }
            ERectangle b = ni.getBounds();
            Rectangle2D.Double bounds = new Rectangle2D.Double(((RectangularShape)b).getMinX(), ((RectangularShape)b).getMinY(), ((RectangularShape)b).getWidth(), ((RectangularShape)b).getHeight());
            FixpTransform trans = info.getTransformToRoot();
            DBMath.transformRect(bounds, trans);
            return DBMath.rectsIntersect(bounds, this.intersectArea);
        }
    }

    private class CheckPolygonVisitor
    extends HierarchyEnumerator.Visitor {
        private RTNode<SubPolygon> rtree;
        private Rectangle2D intersectArea;
        private NodeInst cellOfInterest;
        private List<PolyConnection> connectionsFound;
        private GatherNetworksVisitor gatherNetworks;

        public CheckPolygonVisitor(RTNode<SubPolygon> rtree, Rectangle2D intersectArea, NodeInst cellOfInterest, GatherNetworksVisitor gatherNetworks) {
            this.rtree = rtree;
            this.intersectArea = intersectArea;
            this.cellOfInterest = cellOfInterest;
            this.gatherNetworks = gatherNetworks;
            this.connectionsFound = new ArrayList<PolyConnection>();
        }

        public List<PolyConnection> getFoundConnections() {
            return this.connectionsFound;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            FixpTransform toTop = info.getTransformToRoot();
            Iterator<Geometric> it = info.getCell().getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (ni.isCellInstance()) continue;
                FixpTransform nodeTrans = ni.rotateOut(toTop);
                Technology tech = ni.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfNode(ni, true, true, null);
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    if (poly.getPort() == null) continue;
                    poly.transform(nodeTrans);
                    if (!DBMath.rectsIntersect(poly.getBounds2D(), this.intersectArea)) continue;
                    RTNode.Search<SubPolygon> sea = new RTNode.Search<SubPolygon>(poly.getBounds2D(), this.rtree, true);
                    while (sea.hasNext()) {
                        SubPolygon sp2 = (SubPolygon)sea.next();
                        if (sp2.poly.getLayer() != poly.getLayer() || sp2.poly.separation(poly) >= DBMath.getEpsilon()) continue;
                        int netID = this.gatherNetworks.getGlobalNetworkID(info.getContext(), ni.findPortInstFromEquivalentProto(poly.getPort()));
                        SubPolygon sp22 = new SubPolygon(poly, info.getContext(), netID, ni);
                        this.addConnection(sp2, sp22);
                    }
                }
            }
            it = info.getCell().getArcs();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                Technology tech = ai.getProto().getTechnology();
                Poly[] arcPolyList = tech.getShapeOfArc(ai);
                for (int i = 0; i < arcPolyList.length; ++i) {
                    Poly poly = arcPolyList[i];
                    ((PolyBase)poly).transform(toTop);
                    if (!DBMath.rectsIntersect(poly.getBounds2D(), this.intersectArea)) continue;
                    RTNode.Search<SubPolygon> sea = new RTNode.Search<SubPolygon>(poly.getBounds2D(), this.rtree, true);
                    while (sea.hasNext()) {
                        SubPolygon sp3 = (SubPolygon)sea.next();
                        if (sp3.poly.getLayer() != poly.getLayer() || sp3.poly.separation(poly) > 0.0) continue;
                        int netID = this.gatherNetworks.getGlobalNetworkID(info.getContext(), ai.getHeadPortInst());
                        SubPolygon sp2 = new SubPolygon(poly, info.getContext(), netID, ai);
                        this.addConnection(sp3, sp2);
                    }
                }
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = no.getNodeInst();
            if (info.isRootCell() && ni != this.cellOfInterest) {
                return false;
            }
            if (!ni.isCellInstance()) {
                return false;
            }
            ERectangle b = ni.getBounds();
            Rectangle2D.Double bounds = new Rectangle2D.Double(((RectangularShape)b).getMinX(), ((RectangularShape)b).getMinY(), ((RectangularShape)b).getWidth(), ((RectangularShape)b).getHeight());
            FixpTransform trans = info.getTransformToRoot();
            DBMath.transformRect(bounds, trans);
            return DBMath.rectsIntersect(bounds, this.intersectArea);
        }

        private void addConnection(SubPolygon sp1, SubPolygon sp2) {
            double distance = sp1.poly.getCenter().distance(sp2.poly.getCenter());
            boolean found = false;
            for (PolyConnection pc : this.connectionsFound) {
                int oldNodeCount;
                if (pc.sp1.netID != sp1.netID || pc.sp2.netID != sp2.netID) continue;
                boolean replace = distance < pc.distance;
                int newNodeCount = (sp1.theObj instanceof NodeInst ? 1 : 0) + (sp2.theObj instanceof NodeInst ? 1 : 0);
                if (newNodeCount > (oldNodeCount = (pc.sp1.theObj instanceof NodeInst ? 1 : 0) + (pc.sp2.theObj instanceof NodeInst ? 1 : 0))) {
                    replace = true;
                } else if (newNodeCount < oldNodeCount) {
                    replace = false;
                }
                if (replace) {
                    pc.sp1 = sp1;
                    pc.sp2 = sp2;
                    pc.distance = distance;
                }
                found = true;
                break;
            }
            if (!found) {
                this.connectionsFound.add(new PolyConnection(sp1, sp2));
            }
        }
    }

    private static class PolyConnection {
        SubPolygon sp1;
        SubPolygon sp2;
        double distance;

        PolyConnection(SubPolygon sp1, SubPolygon sp2) {
            this.sp1 = sp1;
            this.sp2 = sp2;
            this.distance = sp1.poly.getCenter().distance(sp2.poly.getCenter());
        }
    }

    private static class SubPolygon
    implements RTBounds {
        PolyBase poly;
        int netID;
        VarContext context;
        Geometric theObj;

        SubPolygon(PolyBase poly, VarContext context, int netID, Geometric theObj) {
            this.poly = poly;
            this.context = context;
            this.netID = netID;
            this.theObj = theObj;
        }

        @Override
        public FixpRectangle getBounds() {
            return this.poly.getBounds2D();
        }
    }

    private class ArcTouchVisitor
    extends HierarchyEnumerator.Visitor {
        private ArcInst arcOfInterest;
        private Poly arcPoly;
        private int arcNetID;
        private NodeInst cellOfInterest;
        private boolean doArcs;
        private Rectangle2D arcBounds;
        private SubPolygon bestSubPolygon;
        private GatherNetworksVisitor gatherNetworks;

        public ArcTouchVisitor(ArcInst arcOfInterest, Poly arcPoly, NodeInst cellOfInterest, boolean doArcs, GatherNetworksVisitor gatherNetworks) {
            this.arcOfInterest = arcOfInterest;
            this.arcPoly = arcPoly;
            this.cellOfInterest = cellOfInterest;
            this.doArcs = doArcs;
            this.arcNetID = -1;
            this.arcBounds = arcPoly.getBounds2D();
            this.bestSubPolygon = null;
            this.gatherNetworks = gatherNetworks;
        }

        public SubPolygon getExportDrillLocation() {
            return this.bestSubPolygon;
        }

        public void setDoArcs(boolean doArcs) {
            this.doArcs = doArcs;
        }

        @Override
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        @Override
        public void exitCell(HierarchyEnumerator.CellInfo info) {
            if (info.isRootCell()) {
                return;
            }
            Netlist nl = info.getNetlist();
            if (this.doArcs) {
                Iterator<ArcInst> it = info.getCell().getArcs();
                while (it.hasNext()) {
                    ArcInst ai = it.next();
                    ArcProto ap = ai.getProto();
                    FixpTransform arcTrans = info.getTransformToRoot();
                    Technology tech = ap.getTechnology();
                    Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
                    for (int i = 0; i < arcInstPolyList.length; ++i) {
                        SubPolygon sp2;
                        Poly poly = arcInstPolyList[i];
                        if (poly.getLayer() != this.arcPoly.getLayer()) continue;
                        int netID = -1;
                        Network net = nl.getNetwork(ai, 0);
                        if (net != null) {
                            netID = info.getNetID(net);
                        }
                        if (netID == this.arcNetID) continue;
                        ((PolyBase)poly).transform(arcTrans);
                        double dist = poly.separation(this.arcPoly);
                        if (dist >= DBMath.getEpsilon()) continue;
                        int netIDglobal = this.gatherNetworks.getGlobalNetworkID(info.getContext(), ai.getHeadPortInst());
                        this.bestSubPolygon = sp2 = new SubPolygon(poly, info.getContext(), netIDglobal, ai);
                    }
                }
            } else {
                Iterator<NodeInst> it = info.getCell().getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    if (ni.isCellInstance()) continue;
                    PrimitiveNode pNp = (PrimitiveNode)ni.getProto();
                    FixpTransform nodeTrans = ni.rotateOut(info.getTransformToRoot());
                    Technology tech = pNp.getTechnology();
                    Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, true, true, null);
                    for (int i = 0; i < nodeInstPolyList.length; ++i) {
                        Poly poly = nodeInstPolyList[i];
                        if (poly.getLayer() != this.arcPoly.getLayer()) continue;
                        int netID = -1;
                        int netIDglobal = -1;
                        if (poly.getPort() != null) {
                            netIDglobal = this.gatherNetworks.getGlobalNetworkID(info.getContext(), ni.findPortInstFromEquivalentProto(poly.getPort()));
                            Network net = nl.getNetwork(ni, poly.getPort(), 0);
                            if (net != null) {
                                netID = info.getNetID(net);
                            }
                        }
                        if (netID == this.arcNetID) continue;
                        ((PolyBase)poly).transform(nodeTrans);
                        double dist = poly.separation(this.arcPoly);
                        if (dist >= DBMath.getEpsilon()) continue;
                        SubPolygon sp3 = new SubPolygon(poly, info.getContext(), netIDglobal, ni);
                        if (this.bestSubPolygon != null && !ni.hasExports()) continue;
                        this.bestSubPolygon = sp3;
                    }
                }
            }
        }

        @Override
        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            NodeInst ni = no.getNodeInst();
            if (info.isRootCell()) {
                Netlist nl;
                Network net;
                if (ni != this.cellOfInterest) {
                    return false;
                }
                if (this.arcNetID < 0 && (net = (nl = info.getNetlist()).getNetwork(this.arcOfInterest, 0)) != null) {
                    this.arcNetID = info.getNetID(net);
                }
                return true;
            }
            if (!ni.isCellInstance()) {
                return false;
            }
            ERectangle b = ni.getBounds();
            Rectangle2D.Double bounds = new Rectangle2D.Double(((RectangularShape)b).getMinX(), ((RectangularShape)b).getMinY(), ((RectangularShape)b).getWidth(), ((RectangularShape)b).getHeight());
            FixpTransform trans = info.getTransformToRoot();
            DBMath.transformRect(bounds, trans);
            return DBMath.rectsIntersect(bounds, this.arcBounds);
        }
    }

    private static class SortDaisyPoints
    implements Comparator<DaisyChainPoint> {
        private SortDaisyPoints() {
        }

        @Override
        public int compare(DaisyChainPoint dcp1, DaisyChainPoint dcp2) {
            if (dcp1.location.getX() < dcp2.location.getX()) {
                return 1;
            }
            if (dcp1.location.getX() > dcp2.location.getX()) {
                return -1;
            }
            if (dcp1.location.getY() < dcp2.location.getY()) {
                return 1;
            }
            if (dcp1.location.getY() > dcp2.location.getY()) {
                return -1;
            }
            return 0;
        }
    }

    private static class DaisyChainPoint {
        PortInst pi;
        EPoint location;

        DaisyChainPoint(PortInst p, Point2D loc) {
            this.pi = p;
            this.location = EPoint.fromLambda(loc.getX(), loc.getY());
        }
    }

    private static class AutoStitchJob
    extends Job {
        private Cell cell;
        private List<NodeInst> nodesToStitch;
        private List<ArcInst> arcsToStitch;
        private double lX;
        private double hX;
        private double lY;
        private double hY;
        private boolean forced;
        private AutoOptions prefs;
        private EDimension alignment;

        private AutoStitchJob(Cell cell, List<NodeInst> nodesToStitch, List<ArcInst> arcsToStitch, double lX, double hX, double lY, double hY, boolean forced) {
            super("Auto-Stitch", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.nodesToStitch = nodesToStitch;
            this.arcsToStitch = arcsToStitch;
            this.lX = lX;
            this.hX = hX;
            this.lY = lY;
            this.hY = hY;
            this.forced = forced;
            this.setReportExecutionFlag(true);
            this.prefs = new AutoOptions(false);
            ECoord resolution = cell.getTechnology().getFactoryResolution();
            this.alignment = new EDimension(resolution, resolution);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Rectangle2D.Double limitBound = null;
            if (this.lX != this.hX && this.lY != this.hY) {
                limitBound = new Rectangle2D.Double(this.lX, this.lY, this.hX - this.lX, this.hY - this.lY);
            }
            EditingPreferences ep = this.getEditingPreferences();
            AutoStitch.runAutoStitch(this.cell, this.nodesToStitch, this.arcsToStitch, this, null, limitBound, this.forced, false, ep, this.prefs, false, this.alignment);
            return true;
        }
    }
}

