/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.hierarchy;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.CellTree;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.Environment;
import com.sun.electric.database.ImmutableArcInst;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.BatchChanges;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.ExportId;
import com.sun.electric.database.id.NodeProtoId;
import com.sun.electric.database.id.PortProtoId;
import com.sun.electric.database.id.PrimitiveNodeId;
import com.sun.electric.database.id.PrimitivePortId;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.TechPool;
import com.sun.electric.tool.Tool;
import com.sun.electric.util.collections.ImmutableArrayList;
import com.sun.electric.util.math.FixpTransform;
import com.sun.electric.util.math.GenMath;
import com.sun.electric.util.math.Orientation;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceBuilder {
    final Logger logger = LoggerFactory.getLogger(ReplaceBuilder.class);
    final Snapshot oldSnapshot;
    final EditingPreferences ep;
    final Tool oldTool;
    final Environment oldEnvironment;
    final TechPool oldTechPool;
    final ImmutableArrayList<CellTree> oldCellTrees;

    ReplaceBuilder(Snapshot oldSnapshot, EditingPreferences ep) {
        this.oldSnapshot = oldSnapshot;
        this.ep = ep;
        this.oldTool = oldSnapshot.tool;
        this.oldEnvironment = oldSnapshot.environment;
        this.oldTechPool = this.oldEnvironment.techPool;
        this.oldCellTrees = oldSnapshot.cellTrees;
    }

    Snapshot update(Iterable<BatchChanges.NodeReplacement> replacements) {
        Map<Integer, BatchChanges.NodeReplacement> map1;
        HashMap<CellId, HashMap<Integer, BatchChanges.NodeReplacement>> map2 = new HashMap<CellId, HashMap<Integer, BatchChanges.NodeReplacement>>();
        for (BatchChanges.NodeReplacement r : replacements) {
            CellId cellId = r.cellId;
            int nodeId = r.nodeId;
            map1 = (HashMap<Integer, BatchChanges.NodeReplacement>)map2.get(cellId);
            if (map1 == null) {
                map1 = new HashMap<Integer, BatchChanges.NodeReplacement>();
                map2.put(cellId, (HashMap<Integer, BatchChanges.NodeReplacement>)map1);
            }
            map1.put(nodeId, r);
        }
        CellBackup[] curCellBackups = new CellBackup[this.oldCellTrees.size()];
        for (CellId cellId : this.oldSnapshot.getCellsDownTop()) {
            CellBackup oldCellBackup = this.oldSnapshot.getCell(cellId);
            map1 = (Map)map2.get(cellId);
            if (map1 != null) {
                CellBuilder cb = new CellBuilder(cellId);
                curCellBackups[cellId.cellIndex] = cb.update(map1);
                continue;
            }
            curCellBackups[cellId.cellIndex] = oldCellBackup;
        }
        Snapshot newSnapshot = this.oldSnapshot.with(this.oldTool, this.oldEnvironment, curCellBackups, null);
        this.logger.debug("Snapshot is ready");
        return newSnapshot;
    }

    static class MaxNodeSuffix {
        final CellBuilder b;
        final Name basename;
        int insertionPoint;
        int maxSuffix = -1;
        final List<ImmutableNodeInst> addedNodes = new ArrayList<ImmutableNodeInst>();

        MaxNodeSuffix(CellBuilder b, Name basename) {
            Name name;
            this.b = b;
            this.basename = basename;
            this.insertionPoint = b.searchNodeInsertionPoint(basename.toString());
            if (this.insertionPoint > 0 && (name = b.oldCellRevision.nodes.get((int)(this.insertionPoint - 1)).name).isTempname() && name.getBasename() == basename) {
                this.maxSuffix = name.getNumSuffix();
            }
        }

        Name getNextName() {
            return this.basename.findSuffixed(this.maxSuffix + 1);
        }

        void add(ImmutableNodeInst n) {
            ++this.maxSuffix;
            assert (n.name.getBasename() == this.basename);
            assert (n.name.getNumSuffix() == this.maxSuffix);
            this.addedNodes.add(n);
        }
    }

    class CellBuilder {
        final CellId cellId;
        final CellTree oldCellTree;
        final CellBackup oldCellBackup;
        final CellRevision oldCellRevision;
        final ImmutableCell oldCell;
        final BitSet deletedNodeInds = new BitSet();
        int curNodesCount;
        int lastNodeId;
        final Map<Name, MaxNodeSuffix> maxNodeSuffixesOrdered = new TreeMap<Name, MaxNodeSuffix>();
        final Map<Integer, ImmutableNodeInst> replacedNodes = new HashMap<Integer, ImmutableNodeInst>();
        final BitSet deletedArcInds = new BitSet();
        int curArcsCount;
        int lastArcId;
        int arcInsertionPoint;
        int maxArcSuffix = -1;
        final List<ImmutableArcInst> addedArcs = new ArrayList<ImmutableArcInst>();
        final Map<Integer, ImmutableArcInst> replacedArcs = new HashMap<Integer, ImmutableArcInst>();
        final BitSet deletedExportInds = new BitSet();
        int curExportsCount;
        final Map<ExportId, ImmutableExport> replacedExports = new HashMap<ExportId, ImmutableExport>();

        CellBuilder(CellId cellId) {
            Name name;
            this.cellId = cellId;
            this.oldCellTree = ReplaceBuilder.this.oldSnapshot.getCellTree(cellId);
            this.oldCellBackup = this.oldCellTree.top;
            this.oldCellRevision = this.oldCellBackup.cellRevision;
            this.oldCell = this.oldCellRevision.d;
            this.curNodesCount = this.oldCellRevision.nodes.size();
            this.lastNodeId = this.oldCellRevision.getMaxNodeId();
            this.curArcsCount = this.oldCellRevision.arcs.size();
            this.lastArcId = this.oldCellRevision.getMaxArcId();
            this.arcInsertionPoint = this.searchArcInsertionPoint(ImmutableArcInst.BASENAME.toString());
            if (this.arcInsertionPoint > 0 && (name = this.oldCellRevision.arcs.get((int)(this.arcInsertionPoint - 1)).name).isTempname()) {
                assert (name.getBasename() == ImmutableArcInst.BASENAME);
                this.maxArcSuffix = name.getNumSuffix();
            }
            this.curExportsCount = this.oldCellRevision.exports.size();
        }

        CellBackup update(Map<Integer, BatchChanges.NodeReplacement> replacements) {
            Iterator<ImmutableNodeInst> nit = this.oldCellRevision.nodes.iterator();
            int nodeInd = 0;
            while (nit.hasNext()) {
                ImmutableNodeInst n = nit.next();
                BatchChanges.NodeReplacement r = replacements.get(n.nodeId);
                if (r != null) {
                    this.replaceNode(nodeInd, n, r);
                }
                ++nodeInd;
            }
            Iterator<ImmutableArcInst> ait = this.oldCellRevision.arcs.iterator();
            int arcInd = 0;
            while (ait.hasNext()) {
                ImmutableArcInst a = ait.next();
                PortProtoId newTailPortId = this.portMap(replacements, a.tailNodeId, a.tailPortId);
                PortProtoId newHeadPortId = this.portMap(replacements, a.headNodeId, a.headPortId);
                if (newTailPortId == null || newHeadPortId == null) {
                    this.deletedArcInds.set(arcInd);
                    --this.curArcsCount;
                } else if (newTailPortId != a.tailPortId || newHeadPortId != a.headPortId) {
                    ImmutableArcInst newA = this.replaceArc(a, newTailPortId, newHeadPortId);
                    this.replacedArcs.put(a.arcId, newA);
                }
                ++arcInd;
            }
            Iterator<ImmutableExport> eit = this.oldCellRevision.exports.iterator();
            int exportInd = 0;
            while (eit.hasNext()) {
                ImmutableExport e = eit.next();
                PortProtoId newOriginalPortId = this.portMap(replacements, e.originalNodeId, e.originalPortId);
                if (newOriginalPortId == null) {
                    this.deletedExportInds.set(exportInd);
                    --this.curExportsCount;
                } else if (newOriginalPortId != e.originalPortId) {
                    ImmutableExport newE = e.withOriginalPort(e.originalNodeId, newOriginalPortId);
                    this.replacedExports.put(e.exportId, newE);
                }
                ++exportInd;
            }
            return this.commit();
        }

        private Name getBaseName(NodeProtoId protoId, PrimitiveNode.Function function) {
            if (protoId instanceof CellId) {
                CellId cellId = (CellId)protoId;
                return cellId.cellName.getBasename();
            }
            PrimitiveNodeId pnId = (PrimitiveNodeId)protoId;
            PrimitiveNode pn = ReplaceBuilder.this.oldTechPool.getPrimitiveNode(pnId);
            int newTechBits = pn.getPrimitiveFunctionBits(function);
            return ReplaceBuilder.this.oldTechPool.getPrimitiveNode(pnId).getPrimitiveFunction(newTechBits).getBasename();
        }

        private MaxNodeSuffix getMaxSuffix(NodeProtoId protoId, PrimitiveNode.Function function) {
            Name basename = this.getBaseName(protoId, function);
            MaxNodeSuffix ms = this.maxNodeSuffixesOrdered.get(basename);
            if (ms != null) {
                return ms;
            }
            ms = new MaxNodeSuffix(this, basename);
            this.maxNodeSuffixesOrdered.put(basename, ms);
            return ms;
        }

        private void replaceNode(int nodeInd, ImmutableNodeInst n, BatchChanges.NodeReplacement r) {
            Name baseName;
            NodeProtoId newProtoId = r.newProtoId;
            MaxNodeSuffix maxSuffix = null;
            Name newName = n.name;
            if (n.name.isTempname() && (baseName = this.getBaseName(newProtoId, r.newFunction)) != n.name.getBasename()) {
                maxSuffix = this.getMaxSuffix(newProtoId, r.newFunction);
                newName = maxSuffix.getNextName();
            }
            ImmutableNodeInst newN = r.newImmutableInst(ReplaceBuilder.this.oldSnapshot, ReplaceBuilder.this.ep).withName(newName);
            if (newName != n.name) {
                maxSuffix.add(newN);
                this.deletedNodeInds.set(nodeInd);
            }
            this.replacedNodes.put(n.nodeId, newN);
        }

        private Poly getShapeOfPort(ImmutableNodeInst n, PortProtoId portId) {
            if (n.protoId instanceof CellId) {
                CellRevision subCell = ReplaceBuilder.this.oldSnapshot.getCellRevision((CellId)n.protoId);
                ImmutableExport export = subCell.getExport((ExportId)portId);
                ImmutableNodeInst origN = subCell.getNodeById(export.originalNodeId);
                Poly poly = this.getShapeOfPort(origN, export.originalPortId);
                poly.transform(new FixpTransform(n.anchor, n.orient));
                return poly;
            }
            Poly.Builder polyBuilder = Poly.newLambdaBuilder();
            return polyBuilder.getShape(n, ReplaceBuilder.this.oldTechPool.getPrimitivePort((PrimitivePortId)portId));
        }

        ImmutableArcInst replaceArc(ImmutableArcInst a, PortProtoId newTailPortId, PortProtoId newHeadPortId) {
            boolean zigzag;
            EPoint newTailPoint = a.tailLocation;
            if (newTailPortId != a.tailPortId) {
                assert (newTailPortId != null);
                ImmutableNodeInst n = this.replacedNodes.get(a.tailNodeId);
                Poly poly = this.getShapeOfPort(n, newTailPortId);
                if (!poly.isInside(a.tailLocation)) {
                    newTailPoint = poly.getCenter();
                }
            }
            EPoint newHeadPoint = a.headLocation;
            if (newHeadPortId != a.headPortId) {
                assert (newHeadPortId != null);
                ImmutableNodeInst n = this.replacedNodes.get(a.headNodeId);
                Poly poly = this.getShapeOfPort(n, newHeadPortId);
                if (!poly.isInside(a.headLocation)) {
                    newHeadPoint = poly.getCenter();
                }
            }
            boolean bl = zigzag = a.isFixedAngle() && (newTailPoint.getGridX() != newHeadPoint.getGridX() || newTailPoint.getGridY() != newHeadPoint.getGridY()) && GenMath.figureAngle(newTailPoint, newHeadPoint) % 1800 != a.getDefinedAngle() % 1800;
            if (zigzag && !a.isRigid() && a.getDefinedAngle() % 900 == 0 && (newTailPortId == a.tailPortId || newHeadPortId == a.headPortId)) {
                boolean otherIsHead = newHeadPortId == a.headPortId;
                int otherNodeId = otherIsHead ? a.headNodeId : a.tailNodeId;
                ImmutableNodeInst adjustThisNode = this.oldCellRevision.getNodeById(otherNodeId);
                if (!this.replacedNodes.containsKey(otherNodeId) && !this.oldCellRevision.hasExportsOnNode(adjustThisNode)) {
                    BitSet headEnds = new BitSet();
                    List<ImmutableArcInst> connList = this.oldCellRevision.getConnectionsOnNode(headEnds, adjustThisNode);
                    boolean adjustable = true;
                    for (ImmutableArcInst oa : connList) {
                        boolean adj = oa == a || (oa.tailNodeId != adjustThisNode.nodeId || oa.headNodeId != adjustThisNode.nodeId) && !this.replacedArcs.containsKey(oa.arcId) && !oa.isRigid() && oa.getDefinedAngle() % 900 == 0 && (a.getDefinedAngle() / 900 & 1) != (oa.getDefinedAngle() / 900 & 1);
                        adjustable = adjustable && adj;
                    }
                    if (adjustable) {
                        long dY;
                        long dX;
                        EPoint newPoint;
                        if (a.getDefinedAngle() % 1800 == 0) {
                            if (otherIsHead) {
                                newPoint = EPoint.fromGrid(newHeadPoint.getGridX(), newTailPoint.getGridY());
                                dX = 0L;
                                dY = newTailPoint.getGridY() - newHeadPoint.getGridY();
                            } else {
                                newPoint = EPoint.fromGrid(newTailPoint.getGridX(), newHeadPoint.getGridY());
                                dX = 0L;
                                dY = newHeadPoint.getGridY() - newTailPoint.getGridY();
                            }
                        } else if (otherIsHead) {
                            newPoint = EPoint.fromGrid(newTailPoint.getGridX(), newHeadPoint.getGridY());
                            dX = newTailPoint.getGridX() - newHeadPoint.getGridX();
                            dY = 0L;
                        } else {
                            newPoint = EPoint.fromGrid(newHeadPoint.getGridX(), newTailPoint.getGridY());
                            dX = newHeadPoint.getGridX() - newTailPoint.getGridX();
                            dY = 0L;
                        }
                        if (otherIsHead) {
                            newHeadPoint = newPoint;
                        } else {
                            newTailPoint = newPoint;
                        }
                        assert (!this.replacedNodes.containsKey(adjustThisNode.nodeId));
                        EPoint oldAnchor = adjustThisNode.anchor;
                        EPoint newAnchor = EPoint.fromGrid(oldAnchor.getGridX() + dX, oldAnchor.getGridY() + dY);
                        this.replacedNodes.put(adjustThisNode.nodeId, adjustThisNode.withAnchor(newAnchor));
                        for (int connInd = 0; connInd < connList.size(); ++connInd) {
                            ImmutableArcInst oa = connList.get(connInd);
                            assert (!this.replacedArcs.containsKey(oa.arcId));
                            if (oa == a) continue;
                            ImmutableArcInst newOA = headEnds.get(connInd) ? oa.withLocations(oa.tailLocation, newPoint) : oa.withLocations(newPoint, oa.headLocation);
                            this.replacedArcs.put(oa.arcId, newOA);
                        }
                        return a.withConnections(a.tailNodeId, newTailPortId, a.headNodeId, newHeadPortId).withLocations(newTailPoint, newHeadPoint);
                    }
                }
            }
            if (zigzag) {
                EPoint c = EPoint.fromGrid(newTailPoint.getGridX(), newHeadPoint.getGridY());
                ArcProto ap = ReplaceBuilder.this.oldTechPool.getArcProto(a.protoId);
                PrimitiveNode pinNp = ap.findOverridablePinProto(ReplaceBuilder.this.ep);
                PrimitivePortId pinPpId = pinNp.getPort(0).getId();
                double psx = pinNp.getDefWidth(ReplaceBuilder.this.ep);
                double psy = pinNp.getDefHeight(ReplaceBuilder.this.ep);
                int pinId = ++this.lastNodeId;
                MaxNodeSuffix maxSuffix = this.getMaxSuffix(pinNp.getId(), PrimitiveNode.Function.UNKNOWN);
                Name name = maxSuffix.getNextName();
                TextDescriptor nameTd = ReplaceBuilder.this.ep.getNodeTextDescriptor();
                Orientation orient = Orientation.IDENT;
                EPoint anchor = c;
                EPoint size2 = pinNp.getDefSize(ReplaceBuilder.this.ep);
                int flags = 0;
                int techBits = 0;
                TextDescriptor protoTd = ReplaceBuilder.this.ep.getInstanceTextDescriptor();
                ImmutableNodeInst pinN = ImmutableNodeInst.newInstance(pinId, pinNp.getId(), name, nameTd, orient, anchor, size2, flags, techBits, protoTd);
                maxSuffix.add(pinN);
                ++this.curNodesCount;
                ImmutableArcInst newAi1 = a.withConnections(pinId, pinPpId, a.headNodeId, newHeadPortId).withLocations(c, newHeadPoint);
                ImmutableArcInst newAi2 = a.withConnections(pinId, pinPpId, a.tailNodeId, newTailPortId).withLocations(c, newTailPoint);
                int arcId = ++this.lastArcId;
                assert (this.maxArcSuffix < Integer.MAX_VALUE);
                ++this.maxArcSuffix;
                Name arcName = ImmutableArcInst.BASENAME.findSuffixed(this.maxArcSuffix);
                if (newTailPortId == a.tailPortId) {
                    this.addedArcs.add(newAi1.withArcId(arcId).withName(arcName));
                    ++this.curArcsCount;
                    return newAi2;
                }
                this.addedArcs.add(newAi2.withArcId(arcId).withName(arcName));
                ++this.curArcsCount;
                return newAi1;
            }
            return a.withConnections(a.tailNodeId, newTailPortId, a.headNodeId, newHeadPortId).withLocations(newTailPoint, newHeadPoint);
        }

        CellBackup commit() {
            ImmutableArcInst newA;
            ImmutableArcInst a;
            int oldArcIndex;
            ImmutableNodeInst[] newNodes = new ImmutableNodeInst[this.curNodesCount];
            Iterator<ImmutableNodeInst> nit = this.oldCellRevision.nodes.iterator();
            int oldNodeIndex = 0;
            int newNodeIndex = 0;
            for (MaxNodeSuffix maxSuffix : this.maxNodeSuffixesOrdered.values()) {
                while (oldNodeIndex < maxSuffix.insertionPoint) {
                    ImmutableNodeInst n = nit.next();
                    if (!this.deletedNodeInds.get(oldNodeIndex)) {
                        ImmutableNodeInst newN = this.replacedNodes.get(n.nodeId);
                        newNodes[newNodeIndex++] = newN != null ? newN : n;
                    }
                    ++oldNodeIndex;
                }
                for (ImmutableNodeInst n : maxSuffix.addedNodes) {
                    newNodes[newNodeIndex++] = n;
                }
            }
            while (oldNodeIndex < this.oldCellRevision.nodes.size()) {
                ImmutableNodeInst n = nit.next();
                if (!this.deletedNodeInds.get(oldNodeIndex)) {
                    ImmutableNodeInst newN = this.replacedNodes.get(n.nodeId);
                    newNodes[newNodeIndex++] = newN != null ? newN : n;
                }
                ++oldNodeIndex;
            }
            assert (!nit.hasNext());
            assert (newNodeIndex == newNodes.length);
            ImmutableArcInst[] newArcs = new ImmutableArcInst[this.curArcsCount];
            Iterator<ImmutableArcInst> ait = this.oldCellRevision.arcs.iterator();
            int newArcIndex = 0;
            for (oldArcIndex = 0; ait.hasNext() && oldArcIndex < this.arcInsertionPoint; ++oldArcIndex) {
                a = ait.next();
                if (this.deletedArcInds.get(oldArcIndex)) continue;
                newA = this.replacedArcs.get(a.arcId);
                newArcs[newArcIndex++] = newA != null ? newA : a;
            }
            for (ImmutableArcInst a2 : this.addedArcs) {
                newArcs[newArcIndex++] = a2;
            }
            assert (oldArcIndex == this.arcInsertionPoint);
            while (oldArcIndex < this.oldCellRevision.arcs.size()) {
                a = ait.next();
                if (!this.deletedArcInds.get(oldArcIndex)) {
                    newA = this.replacedArcs.get(a.arcId);
                    newArcs[newArcIndex++] = newA != null ? newA : a;
                }
                ++oldArcIndex;
            }
            assert (!ait.hasNext());
            assert (newArcIndex == newArcs.length);
            ImmutableExport[] newExports = new ImmutableExport[this.curExportsCount];
            Iterator<ImmutableExport> eit = this.oldCellRevision.exports.iterator();
            int newExportIndex = 0;
            for (int oldExportIndex = 0; oldExportIndex < this.oldCellRevision.exports.size(); ++oldExportIndex) {
                ImmutableExport e = eit.next();
                if (this.deletedExportInds.get(oldExportIndex)) continue;
                ImmutableExport newE = this.replacedExports.get(e.exportId);
                newExports[newExportIndex++] = newE != null ? newE : e;
            }
            assert (!eit.hasNext());
            assert (newExportIndex == newExports.length);
            return this.oldCellBackup.with(this.oldCell, newNodes, newArcs, newExports, ReplaceBuilder.this.oldTechPool);
        }

        PortProtoId portMap(Map<Integer, BatchChanges.NodeReplacement> replacements, int nodeId, PortProtoId ppId) {
            int portIndex;
            BatchChanges.NodeReplacement r = replacements.get(nodeId);
            if (r == null) {
                return ppId;
            }
            ImmutableNodeInst oldN = this.oldCellRevision.getNodeById(nodeId);
            assert (ppId.parentId == oldN.protoId);
            if (ppId instanceof ExportId) {
                ExportId exportId = (ExportId)ppId;
                portIndex = ReplaceBuilder.this.oldSnapshot.getCellRevision(exportId.getParentId()).getExportIndexByExportId(exportId);
            } else {
                portIndex = ReplaceBuilder.this.oldTechPool.getPrimitivePort((PrimitivePortId)ppId).getPortIndex();
            }
            return r.assoc[portIndex];
        }

        int searchNodeInsertionPoint(String basename) {
            assert (basename.endsWith("@0"));
            char nextChar = (char)(basename.charAt(basename.length() - 2) + '\u0001');
            String nextName = basename.substring(0, basename.length() - 2) + nextChar;
            int index = this.oldCellRevision.nodes.searchByName(nextName);
            return index >= 0 ? index : -(index + 1);
        }

        private int searchArcInsertionPoint(String basename) {
            assert (basename.endsWith("@0"));
            char nextChar = (char)(basename.charAt(basename.length() - 2) + '\u0001');
            String nextName = basename.substring(0, basename.length() - 2) + nextChar;
            int index = this.oldCellRevision.arcs.searchByName(nextName);
            return index >= 0 ? index : -(index + 1);
        }
    }
}

