/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.Member;
import gnu.bytecode.Type;
import gnu.bytecode.ZipLoader;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.Keyword;
import gnu.expr.LambdaExp;
import gnu.expr.LangExp;
import gnu.expr.Language;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.NameLookup;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.expr.ThisExp;
import gnu.kawa.functions.AppendValues;
import gnu.kawa.functions.CompileNamedPart;
import gnu.kawa.functions.GetNamedPart;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.reflect.ClassMethods;
import gnu.kawa.reflect.FieldLocation;
import gnu.kawa.reflect.SlotGet;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.kawa.xml.MakeAttribute;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.Location;
import gnu.mapping.Namespace;
import gnu.mapping.SimpleSymbol;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.text.SourceLocator;
import gnu.text.SourceMessages;
import gnu.xml.NamespaceBinding;
import java.util.Stack;
import java.util.Vector;
import kawa.lang.AutoloadProcedure;
import kawa.lang.Macro;
import kawa.lang.PatternScope;
import kawa.lang.Quote;
import kawa.lang.Syntax;
import kawa.lang.SyntaxForm;
import kawa.lang.SyntaxForms;
import kawa.lang.TemplateScope;
import kawa.standard.IfFeature;
import kawa.standard.begin;
import kawa.standard.require;

public class Translator
extends Compilation {
    private Environment env;
    public Macro currentMacroDefinition;
    public PatternScope patternScope;
    public Declaration templateScopeDecl;
    Object currentMacroMark = null;
    public Declaration matchArray;
    private Stack<Declaration> renamedAliasStack;
    public Stack formStack = new Stack();
    public int firstForm;
    public Object pendingForm;
    public LambdaExp curMethodLambda;
    public NamespaceBinding xmlElementNamespaces = NamespaceBinding.predefinedXML;
    public static final Declaration getNamedPartDecl;
    private static Expression errorExp;
    Syntax currentSyntax;
    Declaration macroContext;
    PairWithPosition positionPair;
    Vector notedAccess;

    public Translator(Language language, SourceMessages messages, NameLookup lexical) {
        super(language, messages, lexical);
        this.env = Environment.getCurrent();
    }

    public final Environment getGlobalEnvironment() {
        return this.env;
    }

    public Expression parse(Object input) {
        return this.rewrite(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Expression rewrite_car(Pair pair, SyntaxForm syntax2) {
        if (syntax2 == null || syntax2.getScope() == this.current_scope || pair.getCar() instanceof SyntaxForm) {
            return this.rewrite_car(pair, false);
        }
        ScopeExp save_scope = this.current_scope;
        try {
            this.setCurrentScope(syntax2.getScope());
            Expression expression = this.rewrite_car(pair, false);
            return expression;
        }
        finally {
            this.setCurrentScope(save_scope);
        }
    }

    public final Expression rewrite_car(Pair pair, boolean function2) {
        Object car = pair.getCar();
        if (pair instanceof PairWithPosition) {
            return this.rewrite_with_position(car, function2, (PairWithPosition)pair);
        }
        return this.rewrite(car, function2);
    }

    public Syntax getCurrentSyntax() {
        return this.currentSyntax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Expression apply_rewrite(Syntax syntax2, Pair form) {
        Expression exp = errorExp;
        Syntax saveSyntax = this.currentSyntax;
        this.currentSyntax = syntax2;
        try {
            exp = syntax2.rewriteForm(form, this);
        }
        finally {
            this.currentSyntax = saveSyntax;
        }
        return exp;
    }

    static ReferenceExp getOriginalRef(Declaration decl) {
        Expression value;
        if (decl != null && decl.isAlias() && !decl.isIndirectBinding() && (value = decl.getValue()) instanceof ReferenceExp) {
            return (ReferenceExp)value;
        }
        return null;
    }

    public final boolean selfEvaluatingSymbol(Object obj) {
        return ((LispLanguage)this.getLanguage()).selfEvaluatingSymbol(obj);
    }

    public final boolean matches(Object form, String literal) {
        return this.matches(form, null, literal);
    }

    public boolean matches(Object form, SyntaxForm syntax2, String literal) {
        ReferenceExp rexp;
        if (syntax2 != null) {
            // empty if block
        }
        if (form instanceof SyntaxForm) {
            form = ((SyntaxForm)form).getDatum();
        }
        if (form instanceof SimpleSymbol && !this.selfEvaluatingSymbol(form) && (rexp = Translator.getOriginalRef(this.lexical.lookup(form, -1))) != null) {
            form = rexp.getSymbol();
        }
        return form instanceof SimpleSymbol && ((Symbol)form).getLocalPart() == literal;
    }

    public boolean matches(Object form, SyntaxForm syntax2, Symbol literal) {
        ReferenceExp rexp;
        if (syntax2 != null) {
            // empty if block
        }
        if (form instanceof SyntaxForm) {
            form = ((SyntaxForm)form).getDatum();
        }
        if (form instanceof SimpleSymbol && !this.selfEvaluatingSymbol(form) && (rexp = Translator.getOriginalRef(this.lexical.lookup(form, -1))) != null) {
            form = rexp.getSymbol();
        }
        return form == literal;
    }

    public Object matchQuoted(Pair pair) {
        if (this.matches(pair.getCar(), "quote") && pair.getCdr() instanceof Pair && (pair = (Pair)pair.getCdr()).getCdr() == LList.Empty) {
            return pair.getCar();
        }
        return null;
    }

    public Declaration lookup(Object name, int namespace) {
        Declaration decl = this.lexical.lookup(name, namespace);
        if (decl != null && this.getLanguage().hasNamespace(decl, namespace)) {
            return decl;
        }
        return this.currentModule().lookup(name, this.getLanguage(), namespace);
    }

    public Declaration lookupGlobal(Object name) {
        return this.lookupGlobal(name, -1);
    }

    public Declaration lookupGlobal(Object name, int namespace) {
        ModuleExp module = this.currentModule();
        Declaration decl = module.lookup(name, this.getLanguage(), namespace);
        if (decl == null) {
            decl = module.getNoDefine(name);
            decl.setIndirectBinding(true);
        }
        return decl;
    }

    Syntax check_if_Syntax(Declaration decl) {
        Declaration d = Declaration.followAliases(decl);
        Object obj = null;
        Expression dval = d.getValue();
        if (dval != null && d.getFlag(32768L)) {
            try {
                if (decl.getValue() instanceof ReferenceExp) {
                    Declaration context = ((ReferenceExp)decl.getValue()).contextDecl();
                    if (context != null) {
                        this.macroContext = context;
                    } else if (this.current_scope instanceof TemplateScope) {
                        this.macroContext = ((TemplateScope)this.current_scope).macroContext;
                    }
                } else if (this.current_scope instanceof TemplateScope) {
                    this.macroContext = ((TemplateScope)this.current_scope).macroContext;
                }
                obj = dval.eval(this.env);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                this.error('e', "unable to evaluate macro for " + decl.getSymbol());
            }
        } else if (decl.getFlag(32768L) && !decl.needsContext()) {
            StaticFieldLocation loc = StaticFieldLocation.make(decl);
            obj = loc.get(null);
        }
        return obj instanceof Syntax ? (Syntax)obj : null;
    }

    public Expression rewrite_pair(Pair p, boolean function2) {
        Object cdr;
        int cdr_length;
        Expression func = this.rewrite_car(p, true);
        Object proc = null;
        if (func instanceof QuoteExp && (proc = func.valueIfConstant()) instanceof Syntax) {
            return this.apply_rewrite((Syntax)proc, p);
        }
        ReferenceExp ref = null;
        if (func instanceof ReferenceExp) {
            ref = (ReferenceExp)func;
            Declaration decl = ref.getBinding();
            if (decl == null) {
                String name;
                Symbol symbol;
                Object sym = ref.getSymbol();
                if (sym instanceof Symbol && !this.selfEvaluatingSymbol(sym)) {
                    symbol = (Symbol)sym;
                    name = symbol.getName();
                } else {
                    name = sym.toString();
                    symbol = this.env.getSymbol(name);
                }
                proc = this.env.get(symbol, this.getLanguage().hasSeparateFunctionNamespace() ? EnvironmentKey.FUNCTION : null, null);
                if (proc instanceof Syntax) {
                    return this.apply_rewrite((Syntax)proc, p);
                }
                if (proc instanceof AutoloadProcedure) {
                    try {
                        proc = ((AutoloadProcedure)proc).getLoaded();
                    }
                    catch (RuntimeException ex) {
                        proc = null;
                    }
                }
            } else {
                Declaration saveContext = this.macroContext;
                Syntax syntax2 = this.check_if_Syntax(decl);
                if (syntax2 != null) {
                    Expression e = this.apply_rewrite(syntax2, p);
                    this.macroContext = saveContext;
                    return e;
                }
            }
            ref.setProcedureName(true);
            if (this.getLanguage().hasSeparateFunctionNamespace()) {
                func.setFlag(2);
            }
        }
        if ((cdr_length = Translator.listLength(cdr = p.getCdr())) == -1) {
            return this.syntaxError("circular list is not allowed after " + p.getCar());
        }
        if (cdr_length < 0) {
            return this.syntaxError("dotted list [" + cdr + "] is not allowed after " + p.getCar());
        }
        boolean mapKeywordsToAttributes = false;
        Stack<Expression> vec = new Stack<Expression>();
        ScopeExp save_scope = this.current_scope;
        int i = 0;
        while (i < cdr_length) {
            if (cdr instanceof SyntaxForm) {
                SyntaxForm sf = (SyntaxForm)cdr;
                cdr = sf.getDatum();
                this.setCurrentScope(sf.getScope());
            }
            Pair cdr_pair = (Pair)cdr;
            Expression arg = this.rewrite_car(cdr_pair, false);
            ++i;
            if (mapKeywordsToAttributes) {
                Object value;
                if ((i & 1) == 0) {
                    Expression[] aargs = new Expression[]{(Expression)vec.pop(), arg};
                    arg = new ApplyExp(MakeAttribute.makeAttribute, aargs);
                } else if (arg instanceof QuoteExp && (value = ((QuoteExp)arg).getValue()) instanceof Keyword && i < cdr_length) {
                    arg = new QuoteExp(((Keyword)value).asSymbol());
                } else {
                    mapKeywordsToAttributes = false;
                }
            }
            vec.addElement(arg);
            cdr = cdr_pair.getCdr();
        }
        Object[] args = new Expression[vec.size()];
        vec.copyInto(args);
        if (save_scope != this.current_scope) {
            this.setCurrentScope(save_scope);
        }
        if (func instanceof ReferenceExp && ((ReferenceExp)func).getBinding() == getNamedPartDecl) {
            Object part1 = args[0];
            Object part2 = args[1];
            Symbol sym = this.namespaceResolve((Expression)part1, (Expression)part2);
            if (sym != null) {
                return this.rewrite((Object)sym, function2);
            }
            return CompileNamedPart.makeExp((Expression)part1, (Expression)part2);
        }
        return this.makeApply(func, (Expression[])args);
    }

    public ApplyExp makeApply(Expression func, Expression[] args) {
        return new ApplyExp(func, args);
    }

    public Namespace namespaceResolvePrefix(Expression context) {
        if (context instanceof ReferenceExp) {
            Object val;
            ReferenceExp rexp = (ReferenceExp)context;
            Declaration decl = rexp.getBinding();
            if (decl == null || decl.getFlag(65536L)) {
                Object rsym = rexp.getSymbol();
                Symbol sym = rsym instanceof Symbol ? (Symbol)rsym : this.env.getSymbol(rsym.toString());
                val = this.env.get(sym, null);
            } else {
                val = decl.isNamespaceDecl() ? decl.getConstantValue() : null;
            }
            if (val instanceof Namespace) {
                Namespace ns = (Namespace)val;
                String uri = ns.getName();
                if (uri != null && uri.startsWith("class:")) {
                    return null;
                }
                return ns;
            }
        }
        return null;
    }

    public Symbol namespaceResolve(Namespace ns, Expression member) {
        if (ns != null && member instanceof QuoteExp) {
            String mem = ((QuoteExp)member).getValue().toString().intern();
            return ns.getSymbol(mem);
        }
        return null;
    }

    public Symbol namespaceResolve(Expression context, Expression member) {
        return this.namespaceResolve(this.namespaceResolvePrefix(context), member);
    }

    public static Object stripSyntax(Object obj) {
        while (obj instanceof SyntaxForm) {
            obj = ((SyntaxForm)obj).getDatum();
        }
        return obj;
    }

    public static Object safeCar(Object obj) {
        while (obj instanceof SyntaxForm) {
            obj = ((SyntaxForm)obj).getDatum();
        }
        if (!(obj instanceof Pair)) {
            return null;
        }
        return Translator.stripSyntax(((Pair)obj).getCar());
    }

    public static Object safeCdr(Object obj) {
        while (obj instanceof SyntaxForm) {
            obj = ((SyntaxForm)obj).getDatum();
        }
        if (!(obj instanceof Pair)) {
            return null;
        }
        return Translator.stripSyntax(((Pair)obj).getCdr());
    }

    public static int listLength(Object obj) {
        int n = 0;
        Object slow = obj;
        Object fast = obj;
        while (true) {
            if (fast instanceof SyntaxForm) {
                fast = ((SyntaxForm)fast).getDatum();
                continue;
            }
            while (slow instanceof SyntaxForm) {
                slow = ((SyntaxForm)slow).getDatum();
            }
            if (fast == LList.Empty) {
                return n;
            }
            if (!(fast instanceof Pair)) {
                return -1 - n;
            }
            ++n;
            Object next = ((Pair)fast).getCdr();
            while (next instanceof SyntaxForm) {
                next = ((SyntaxForm)next).getDatum();
            }
            if (next == LList.Empty) {
                return n;
            }
            if (!(next instanceof Pair)) {
                return -1 - n;
            }
            slow = ((Pair)slow).getCdr();
            fast = ((Pair)next).getCdr();
            ++n;
            if (fast == slow) break;
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rewriteInBody(Object exp) {
        if (exp instanceof SyntaxForm) {
            SyntaxForm sf = (SyntaxForm)exp;
            ScopeExp save_scope = this.current_scope;
            try {
                this.setCurrentScope(sf.getScope());
                this.rewriteInBody(sf.getDatum());
            }
            finally {
                this.setCurrentScope(save_scope);
            }
        } else if (exp instanceof Values) {
            Object[] vals = ((Values)exp).getValues();
            for (int i = 0; i < vals.length; ++i) {
                this.rewriteInBody(vals[i]);
            }
        } else {
            this.formStack.add(this.rewrite(exp, false));
        }
    }

    public Object namespaceResolve(Object name) {
        Pair p;
        if (!(name instanceof SimpleSymbol) && name instanceof Pair && Translator.safeCar(p = (Pair)name) == LispLanguage.lookup_sym && p.getCdr() instanceof Pair && (p = (Pair)p.getCdr()).getCdr() instanceof Pair) {
            Expression part2;
            Expression part1 = this.rewrite(p.getCar());
            Symbol sym = this.namespaceResolve(part1, part2 = this.rewrite(((Pair)p.getCdr()).getCar()));
            if (sym != null) {
                return sym;
            }
            String combinedName = CompileNamedPart.combineName(part1, part2);
            if (combinedName != null) {
                return Namespace.EmptyNamespace.getSymbol(combinedName);
            }
        }
        return name;
    }

    public Expression rewrite(Object exp) {
        return this.rewrite(exp, 'N');
    }

    public Expression rewrite(Object exp, boolean function2) {
        return this.rewrite(exp, function2 ? (char)'F' : 'N');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite(Object exp, char mode) {
        boolean function2;
        if (exp instanceof SyntaxForm) {
            SyntaxForm sf = (SyntaxForm)exp;
            ScopeExp save_scope = this.current_scope;
            try {
                Expression s;
                this.setCurrentScope(sf.getScope());
                Expression expression = s = this.rewrite(sf.getDatum(), mode);
                return expression;
            }
            finally {
                this.setCurrentScope(save_scope);
            }
        }
        boolean bl = function2 = mode != 'N';
        if (exp instanceof PairWithPosition) {
            return this.rewrite_with_position(exp, function2, (PairWithPosition)exp);
        }
        if (exp instanceof Pair) {
            return this.rewrite_pair((Pair)exp, function2);
        }
        if (exp instanceof Symbol && !this.selfEvaluatingSymbol(exp)) {
            boolean separate;
            Object nameToLookup;
            Declaration cdecl;
            Declaration decl;
            block41: {
                String dname;
                int decl_nesting;
                decl = this.lexical.lookup(exp, function2);
                cdecl = null;
                ScopeExp scope = this.current_scope;
                int n = decl_nesting = decl == null ? -1 : ScopeExp.nesting(decl.context);
                if (exp instanceof Symbol && ((Symbol)exp).hasEmptyNamespace()) {
                    dname = exp.toString();
                } else {
                    dname = null;
                    scope = null;
                }
                while (scope != null) {
                    if (scope instanceof LambdaExp && scope.outer instanceof ClassExp && ((LambdaExp)scope).isClassMethod()) {
                        PrimProcedure[] methods;
                        boolean contextStatic;
                        if (decl_nesting >= ScopeExp.nesting(scope.outer)) break;
                        LambdaExp caller = (LambdaExp)scope;
                        ClassExp cexp = (ClassExp)scope.outer;
                        ClassType ctype = cexp.getClassType();
                        Member part = SlotGet.lookupMember(ctype, dname, ctype);
                        boolean bl2 = contextStatic = caller == cexp.clinitMethod || caller != cexp.initMethod && caller.nameDecl.isStatic();
                        if (part != null || (methods = ClassMethods.getMethods(ctype, dname, contextStatic ? (char)'S' : 'V', ctype, this.language)).length != 0) {
                            ReferenceExp part1 = contextStatic ? new ReferenceExp(((ClassExp)caller.outer).nameDecl) : new ThisExp(caller.firstDecl());
                            return CompileNamedPart.makeExp((Expression)part1, QuoteExp.getInstance(dname));
                        }
                    }
                    scope = scope.outer;
                }
                if (decl != null) {
                    nameToLookup = decl.getSymbol();
                    exp = null;
                    ReferenceExp rexp = Translator.getOriginalRef(decl);
                    if (rexp != null && (decl = rexp.getBinding()) == null) {
                        nameToLookup = exp = rexp.getSymbol();
                    }
                } else {
                    nameToLookup = exp;
                }
                Symbol symbol = (Symbol)exp;
                separate = this.getLanguage().hasSeparateFunctionNamespace();
                if (decl != null) {
                    if (this.current_scope instanceof TemplateScope && decl.needsContext()) {
                        cdecl = ((TemplateScope)this.current_scope).macroContext;
                    } else if (decl.getFlag(0x100000L) && !decl.isStatic()) {
                        scope = this.currentScope();
                        while (true) {
                            if (scope == null) {
                                throw new Error("internal error: missing " + decl);
                            }
                            if (scope.outer == decl.context) break;
                            scope = scope.outer;
                        }
                        cdecl = scope.firstDecl();
                    }
                } else {
                    Expression e;
                    Location loc = this.env.lookup(symbol, function2 && separate ? EnvironmentKey.FUNCTION : null);
                    if (loc != null) {
                        loc = loc.getBase();
                    }
                    if (loc instanceof FieldLocation) {
                        FieldLocation floc = (FieldLocation)loc;
                        try {
                            decl = floc.getDeclaration();
                            if (!this.inlineOk(null) && decl != getNamedPartDecl && !Translator.isObjectSyntax(floc.getDeclaringClass(), floc.getMemberName())) {
                                decl = null;
                                break block41;
                            }
                            if (this.immediate) {
                                if (!decl.isStatic()) {
                                    cdecl = new Declaration("(module-instance)");
                                    cdecl.setValue(new QuoteExp(floc.getInstance()));
                                }
                                break block41;
                            }
                            if (decl.isStatic()) {
                                ClassLoader floader;
                                Class fclass = floc.getRClass();
                                if (fclass == null || (floader = fclass.getClassLoader()) instanceof ZipLoader || floader instanceof ArrayClassLoader) {
                                    decl = null;
                                }
                                break block41;
                            }
                            decl = null;
                        }
                        catch (Throwable ex) {
                            this.error('e', "exception loading '" + exp + "' - " + ex.getMessage());
                            decl = null;
                        }
                    } else if (!(mode == 'M' || loc != null && loc.isBound() || (e = this.checkDefaultBinding(symbol, this)) == null)) {
                        return e;
                    }
                }
            }
            if (decl != null) {
                Field dfield = decl.field;
                if (!function2 && dfield != null && Translator.isObjectSyntax(dfield.getDeclaringClass(), dfield.getName())) {
                    return QuoteExp.getInstance(Object.class);
                }
                if (decl.getContext() instanceof PatternScope) {
                    return this.syntaxError("reference to pattern variable " + decl.getName() + " outside syntax template");
                }
            }
            ReferenceExp rexp = new ReferenceExp(nameToLookup, decl);
            rexp.setContextDecl(cdecl);
            rexp.setLine(this);
            if (function2 && separate) {
                rexp.setFlag(2);
            }
            return rexp;
        }
        if (exp instanceof LangExp) {
            return this.rewrite(((LangExp)exp).getLangValue(), function2);
        }
        if (exp instanceof Expression) {
            return (Expression)exp;
        }
        if (exp == Special.abstractSpecial) {
            return QuoteExp.abstractExp;
        }
        if (exp == Special.nativeSpecial) {
            return QuoteExp.nativeExp;
        }
        return QuoteExp.getInstance(Quote.quote(exp, this), this);
    }

    public Expression checkDefaultBinding(Symbol name, Translator tr) {
        return null;
    }

    public static void setLine(Expression exp, Object location2) {
        if (location2 instanceof SourceLocator) {
            exp.setLocation((SourceLocator)location2);
        }
    }

    public static void setLine(Declaration decl, Object location2) {
        if (location2 instanceof SourceLocator) {
            decl.setLocation((SourceLocator)location2);
        }
    }

    public Object pushPositionOf(Object pair) {
        if (pair instanceof SyntaxForm) {
            pair = ((SyntaxForm)pair).getDatum();
        }
        if (!(pair instanceof PairWithPosition)) {
            return null;
        }
        PairWithPosition ppair = (PairWithPosition)pair;
        PairWithPosition saved = this.positionPair == null || this.positionPair.getFileName() != this.getFileName() || this.positionPair.getLineNumber() != this.getLineNumber() || this.positionPair.getColumnNumber() != this.getColumnNumber() ? new PairWithPosition(this, this, this.positionPair) : this.positionPair;
        this.setLine(pair);
        this.positionPair = ppair;
        return saved;
    }

    public void popPositionOf(Object saved) {
        if (saved == null) {
            return;
        }
        this.setLine(saved);
        this.positionPair = (PairWithPosition)saved;
        if (this.positionPair.getCar() == this) {
            this.positionPair = (PairWithPosition)this.positionPair.getCdr();
        }
    }

    public void setLineOf(Expression exp) {
        if (exp instanceof QuoteExp) {
            return;
        }
        exp.setLocation(this);
    }

    public Type exp2Type(Pair typeSpecPair) {
        return this.exp2Type(typeSpecPair, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type exp2Type(Pair typeSpecPair, Declaration decl, SyntaxForm syntax2) {
        Object saved = this.pushPositionOf(typeSpecPair);
        try {
            Expression texp = this.rewrite_car(typeSpecPair, syntax2);
            texp = InlineCalls.inlineCalls(texp, this);
            if (texp instanceof ErrorExp) {
                Type type = null;
                return type;
            }
            Type type = this.getLanguage().getTypeFor(texp);
            if (type == null) {
                try {
                    Object t = texp.eval(this.env);
                    if (t instanceof Class) {
                        type = Type.make((Class)t);
                    } else if (t instanceof Type) {
                        type = (Type)t;
                    }
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            if (type == null) {
                if (texp instanceof ReferenceExp) {
                    this.error('e', "unknown type name '" + ((ReferenceExp)texp).getName() + '\'');
                } else {
                    this.error('e', "invalid type spec (must be \"type\" or 'type or <type>)");
                }
                type = Type.pointer_type;
            }
            if (decl != null) {
                decl.setType(texp, type);
            }
            Type type2 = type;
            return type2;
        }
        finally {
            this.popPositionOf(saved);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite_with_position(Object exp, boolean function2, PairWithPosition pair) {
        Expression result;
        Object saved = this.pushPositionOf(pair);
        try {
            result = exp == pair ? this.rewrite_pair(pair, function2) : this.rewrite(exp, function2);
            this.setLineOf(result);
        }
        finally {
            this.popPositionOf(saved);
        }
        return result;
    }

    public static Object wrapSyntax(Object form, SyntaxForm syntax2) {
        if (syntax2 == null || form instanceof Expression) {
            return form;
        }
        return SyntaxForms.fromDatumIfNeeded(form, syntax2);
    }

    public Object popForms(int first) {
        Object r;
        int last = this.formStack.size();
        if (last == first) {
            return Values.empty;
        }
        if (last == first + 1) {
            r = this.formStack.elementAt(first);
        } else {
            Values vals = new Values();
            for (int i = first; i < last; ++i) {
                vals.writeObject(this.formStack.elementAt(i));
            }
            r = vals;
        }
        this.formStack.setSize(first);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanForm(Object st, ScopeExp defs2) {
        if (st instanceof SyntaxForm) {
            SyntaxForm sf = (SyntaxForm)st;
            ScopeExp save_scope = this.currentScope();
            try {
                this.setCurrentScope(sf.getScope());
                int first = this.formStack.size();
                this.scanForm(sf.getDatum(), defs2);
                this.formStack.add(Translator.wrapSyntax(this.popForms(first), sf));
                return;
            }
            finally {
                this.setCurrentScope(save_scope);
            }
        }
        if (st instanceof Values) {
            if (st == Values.empty) {
                st = QuoteExp.voidExp;
            } else {
                Object[] vals = ((Values)st).getValues();
                for (int i = 0; i < vals.length; ++i) {
                    this.scanForm(vals[i], defs2);
                }
                return;
            }
        }
        if (st instanceof Pair) {
            Pair st_pair = (Pair)st;
            Declaration saveContext = this.macroContext;
            Syntax syntax2 = null;
            ScopeExp savedScope = this.current_scope;
            Object savedPosition = this.pushPositionOf(st);
            if (st instanceof SourceLocator && defs2.getLineNumber() < 0) {
                defs2.setLocation((SourceLocator)st);
            }
            try {
                Pair p;
                Object obj = st_pair.getCar();
                if (obj instanceof SyntaxForm) {
                    SyntaxForm sf = (SyntaxForm)st_pair.getCar();
                    this.setCurrentScope(sf.getScope());
                    obj = sf.getDatum();
                }
                if (obj instanceof Pair && (p = (Pair)obj).getCar() == LispLanguage.lookup_sym && p.getCdr() instanceof Pair && (p = (Pair)p.getCdr()).getCdr() instanceof Pair) {
                    Expression part1 = this.rewrite(p.getCar());
                    Expression part2 = this.rewrite(((Pair)p.getCdr()).getCar());
                    Object value1 = part1.valueIfConstant();
                    Object value2 = part2.valueIfConstant();
                    if (value1 instanceof Class && value2 instanceof Symbol) {
                        try {
                            obj = GetNamedPart.getNamedPart(value1, (Symbol)value2);
                            if (obj instanceof Syntax) {
                                syntax2 = (Syntax)obj;
                            }
                        }
                        catch (Throwable ex) {
                            obj = null;
                        }
                    } else {
                        obj = this.namespaceResolve(part1, part2);
                    }
                }
                if (obj instanceof Symbol && !this.selfEvaluatingSymbol(obj)) {
                    Expression func = this.rewrite(obj, 'M');
                    if (func instanceof ReferenceExp) {
                        Declaration decl = ((ReferenceExp)func).getBinding();
                        if (decl != null) {
                            syntax2 = this.check_if_Syntax(decl);
                        } else if ((obj = this.resolve(obj, true)) instanceof Syntax) {
                            syntax2 = (Syntax)obj;
                        }
                    }
                } else if (obj == begin.begin) {
                    syntax2 = (Syntax)obj;
                }
            }
            finally {
                if (savedScope != this.current_scope) {
                    this.setCurrentScope(savedScope);
                }
                this.popPositionOf(savedPosition);
            }
            if (syntax2 != null) {
                String save_filename = this.getFileName();
                int save_line = this.getLineNumber();
                int save_column = this.getColumnNumber();
                try {
                    this.setLine(st_pair);
                    syntax2.scanForm(st_pair, defs2, this);
                    return;
                }
                finally {
                    this.macroContext = saveContext;
                    this.setLine(save_filename, save_line, save_column);
                }
            }
        }
        this.formStack.add(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LList scanBody(Object body, ScopeExp defs2, boolean makeList) {
        LList list = makeList ? LList.Empty : null;
        Pair lastPair = null;
        while (body != LList.Empty) {
            if (body instanceof SyntaxForm) {
                SyntaxForm sf = (SyntaxForm)body;
                ScopeExp save_scope = this.current_scope;
                try {
                    LList lList;
                    this.setCurrentScope(sf.getScope());
                    int first = this.formStack.size();
                    LList f = this.scanBody(sf.getDatum(), defs2, makeList);
                    if (makeList) {
                        f = (LList)SyntaxForms.fromDatumIfNeeded(f, sf);
                        if (lastPair == null) {
                            lList = f;
                            return lList;
                        }
                        lastPair.setCdrBackdoor(f);
                        lList = list;
                        return lList;
                    }
                    this.formStack.add(Translator.wrapSyntax(this.popForms(first), sf));
                    lList = null;
                    return lList;
                }
                finally {
                    this.setCurrentScope(save_scope);
                }
            }
            if (body instanceof Pair) {
                Pair pair = (Pair)body;
                int first = this.formStack.size();
                this.scanForm(pair.getCar(), defs2);
                if (this.getState() == 2) {
                    if (pair.getCar() != this.pendingForm) {
                        pair = Translator.makePair(pair, this.pendingForm, pair.getCdr());
                    }
                    this.pendingForm = new Pair(begin.begin, pair);
                    if (list != LList.Empty) {
                        this.formStack.add(new Pair(begin.begin, list));
                    }
                    return LList.Empty;
                }
                int fsize = this.formStack.size();
                if (makeList) {
                    for (int i = first; i < fsize; ++i) {
                        Pair npair = Translator.makePair(pair, this.formStack.elementAt(i), LList.Empty);
                        if (lastPair == null) {
                            list = npair;
                        } else {
                            lastPair.setCdrBackdoor(npair);
                        }
                        lastPair = npair;
                    }
                    this.formStack.setSize(first);
                }
                body = pair.getCdr();
                continue;
            }
            this.formStack.add(this.syntaxError("body is not a proper list"));
            break;
        }
        return list;
    }

    public static Pair makePair(Pair pair, Object car, Object cdr) {
        if (pair instanceof PairWithPosition) {
            return new PairWithPosition((PairWithPosition)pair, car, cdr);
        }
        return new Pair(car, cdr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression rewrite_body(Object exp) {
        Object saved = this.pushPositionOf(exp);
        LetExp defs2 = new LetExp();
        int first = this.formStack.size();
        defs2.outer = this.current_scope;
        this.current_scope = defs2;
        try {
            LList list = this.scanBody(exp, defs2, true);
            if (list.isEmpty()) {
                this.formStack.add(this.syntaxError("body with no expressions"));
            }
            int ndecls = 0;
            for (Declaration decl = defs2.firstDecl(); decl != null; decl = decl.nextDecl()) {
                if (decl.getFlag(0x10000000L)) continue;
                ++ndecls;
                decl.setInitValue(QuoteExp.undefined_exp);
            }
            this.rewriteBody(list);
            Expression body = this.makeBody(first, null);
            this.setLineOf(body);
            if (ndecls == 0) {
                Expression expression = body;
                return expression;
            }
            defs2.setBody(body);
            this.setLineOf(defs2);
            LetExp letExp = defs2;
            return letExp;
        }
        finally {
            this.pop(defs2);
            this.popPositionOf(saved);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteBody(LList forms) {
        while (forms != LList.Empty) {
            Pair pair = (Pair)forms;
            Object saved = this.pushPositionOf(pair);
            try {
                this.rewriteInBody(pair.getCar());
            }
            finally {
                this.popPositionOf(saved);
            }
            forms = (LList)pair.getCdr();
        }
    }

    private Expression makeBody(int first, ScopeExp scope) {
        int nforms = this.formStack.size() - first;
        if (nforms == 0) {
            return QuoteExp.voidExp;
        }
        if (nforms == 1) {
            return (Expression)this.formStack.pop();
        }
        Expression[] exps = new Expression[nforms];
        for (int i = 0; i < nforms; ++i) {
            exps[i] = (Expression)this.formStack.elementAt(first + i);
        }
        this.formStack.setSize(first);
        if (scope instanceof ModuleExp) {
            return new ApplyExp(AppendValues.appendValues, exps);
        }
        return this.makeBody(exps);
    }

    public boolean appendBodyValues() {
        return false;
    }

    public Expression makeBody(Expression[] exps) {
        if (this.appendBodyValues()) {
            return new ApplyExp(AppendValues.appendValues, exps);
        }
        return new BeginExp(exps);
    }

    public void noteAccess(Object name, ScopeExp scope) {
        if (this.notedAccess == null) {
            this.notedAccess = new Vector();
        }
        this.notedAccess.addElement(name);
        this.notedAccess.addElement(scope);
    }

    public void processAccesses() {
        if (this.notedAccess == null) {
            return;
        }
        int sz = this.notedAccess.size();
        ScopeExp saveScope = this.current_scope;
        for (int i = 0; i < sz; i += 2) {
            Declaration decl;
            Object name = this.notedAccess.elementAt(i);
            ScopeExp scope = (ScopeExp)this.notedAccess.elementAt(i + 1);
            if (this.current_scope != scope) {
                this.setCurrentScope(scope);
            }
            if ((decl = this.lexical.lookup(name, -1)) == null || decl.getFlag(65536L)) continue;
            decl.getContext().currentLambda().capture(decl);
            decl.setCanRead(true);
            decl.setSimple(false);
            decl.setFlag(524288L);
        }
        if (this.current_scope != saveScope) {
            this.setCurrentScope(saveScope);
        }
    }

    public void finishModule(ModuleExp mexp) {
        boolean moduleStatic = mexp.isStatic();
        for (Declaration decl = mexp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            if (decl.getFlag(512L)) {
                String msg1 = "'";
                String msg2 = decl.getFlag(1024L) ? "' exported but never defined" : (decl.getFlag(2048L) ? "' declared static but never defined" : "' declared but never defined");
                this.error('e', decl, msg1, msg2);
            }
            if (mexp.getFlag(16384) || this.generateMain && !this.immediate) {
                if (decl.getFlag(1024L)) {
                    if (decl.isPrivate()) {
                        if (decl.getFlag(0x1000000L)) {
                            this.error('e', decl, "'", "' is declared both private and exported");
                        }
                        decl.setPrivate(false);
                    }
                } else if (!IfFeature.isProvide(decl)) {
                    decl.setPrivate(true);
                }
            }
            if (moduleStatic) {
                decl.setFlag(2048L);
                continue;
            }
            if ((!mexp.getFlag(65536) || decl.getFlag(2048L)) && Compilation.moduleStatic >= 0 && !mexp.getFlag(131072)) continue;
            decl.setFlag(4096L);
        }
    }

    static void vectorReverse(Vector vec, int start, int count) {
        int j = count / 2;
        int last = start + count - 1;
        for (int i = 0; i < j; ++i) {
            Object tmp = vec.elementAt(start + i);
            vec.setElementAt(vec.elementAt(last - i), start + i);
            vec.setElementAt(tmp, last - i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveModule(ModuleExp mexp) {
        int numPending = this.pendingImports == null ? 0 : this.pendingImports.size();
        int i = 0;
        while (i < numPending) {
            ModuleInfo info = (ModuleInfo)this.pendingImports.elementAt(i++);
            ScopeExp defs2 = (ScopeExp)this.pendingImports.elementAt(i++);
            Expression posExp = (Expression)this.pendingImports.elementAt(i++);
            Integer savedSize = (Integer)this.pendingImports.elementAt(i++);
            if (mexp != defs2) continue;
            ReferenceExp savePos = new ReferenceExp((Object)null);
            savePos.setLine(this);
            this.setLine(posExp);
            int beforeSize = this.formStack.size();
            require.importDefinitions(null, info, null, this.formStack, defs2, this);
            int desiredPosition = savedSize;
            if (savedSize != beforeSize) {
                int curSize = this.formStack.size();
                int count = curSize - desiredPosition;
                Translator.vectorReverse(this.formStack, desiredPosition, beforeSize - desiredPosition);
                Translator.vectorReverse(this.formStack, beforeSize, curSize - beforeSize);
                Translator.vectorReverse(this.formStack, desiredPosition, count);
            }
            this.setLine(savePos);
        }
        this.pendingImports = null;
        this.processAccesses();
        this.setModule(mexp);
        Compilation save_comp = Compilation.setSaveCurrent(this);
        try {
            this.rewriteInBody(this.popForms(this.firstForm));
            mexp.body = this.makeBody(this.firstForm, mexp);
            if (!this.immediate) {
                this.lexical.pop(mexp);
            }
        }
        finally {
            Compilation.restoreCurrent(save_comp);
        }
    }

    public Declaration makeRenamedAlias(Declaration decl, ScopeExp templateScope) {
        if (templateScope == null) {
            return decl;
        }
        return this.makeRenamedAlias(decl.getSymbol(), decl, templateScope);
    }

    public Declaration makeRenamedAlias(Object name, Declaration decl, ScopeExp templateScope) {
        Declaration alias = new Declaration(name);
        alias.setAlias(true);
        alias.setPrivate(true);
        alias.context = templateScope;
        ReferenceExp ref = new ReferenceExp(decl);
        ref.setDontDereference(true);
        alias.noteValue(ref);
        return alias;
    }

    public void pushRenamedAlias(Declaration alias) {
        Declaration decl = Translator.getOriginalRef(alias).getBinding();
        ScopeExp templateScope = alias.context;
        decl.setSymbol(null);
        Declaration old = templateScope.lookup(alias.getSymbol());
        if (old != null) {
            templateScope.remove(old);
        }
        templateScope.addDeclaration(alias);
        if (this.renamedAliasStack == null) {
            this.renamedAliasStack = new Stack();
        }
        this.renamedAliasStack.push(old);
        this.renamedAliasStack.push(alias);
    }

    public void popRenamedAlias(int count) {
        while (--count >= 0) {
            Declaration alias = this.renamedAliasStack.pop();
            ScopeExp templateScope = alias.getContext();
            Declaration decl = Translator.getOriginalRef(alias).getBinding();
            decl.setSymbol(alias.getSymbol());
            templateScope.remove(alias);
            Declaration old = this.renamedAliasStack.pop();
            if (old == null) continue;
            templateScope.addDeclaration(old);
        }
    }

    public Declaration define(Object name, SyntaxForm nameSyntax, ScopeExp defs2) {
        boolean aliasNeeded = nameSyntax != null && nameSyntax.getScope() != this.currentScope();
        Object declName = aliasNeeded ? new String(name.toString()) : name;
        Declaration decl = defs2.getDefine(declName, 'w', this);
        if (aliasNeeded) {
            Declaration alias = this.makeRenamedAlias(name, decl, nameSyntax.getScope());
            nameSyntax.getScope().addDeclaration(alias);
        }
        this.push(decl);
        return decl;
    }

    static boolean isObjectSyntax(ClassType declaringClass, String fieldName) {
        return "objectSyntax".equals(fieldName) && "kawa.standard.object".equals(declaringClass.getName());
    }

    static {
        String cname = "gnu.kawa.functions.GetNamedPart";
        String fname = "getNamedPart";
        getNamedPartDecl = Declaration.getDeclarationFromStatic(cname, fname);
        LispLanguage.getNamedPartLocation.setDeclaration(getNamedPartDecl);
        errorExp = new ErrorExp("unknown syntax error");
    }
}

