/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.ModuleExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.mapping.CallContext;

public class ThisExp
extends ReferenceExp {
    public static final String THIS_NAME = new String("$this$");
    static int EVAL_TO_CONTEXT = 1;
    ScopeExp context;

    public final boolean isForContext() {
        return (this.flags & EVAL_TO_CONTEXT) != 0;
    }

    public void apply(CallContext callContext) throws Throwable {
        if (this.isForContext()) {
            callContext.writeValue(this.context);
        } else {
            super.apply(callContext);
        }
    }

    public ScopeExp getContextScope() {
        return this.context;
    }

    public ThisExp() {
        super((Object)THIS_NAME);
    }

    public ThisExp(ScopeExp scopeExp) {
        super((Object)THIS_NAME);
        this.context = scopeExp;
    }

    public ThisExp(Declaration declaration) {
        super(THIS_NAME, declaration);
    }

    public ThisExp(ClassType classType) {
        this(new Declaration((Object)THIS_NAME, classType));
    }

    public static ThisExp makeGivingContext(ScopeExp scopeExp) {
        ThisExp thisExp = new ThisExp(scopeExp);
        thisExp.flags |= EVAL_TO_CONTEXT;
        return thisExp;
    }

    public void compile(Compilation compilation, Target target) {
        if (target instanceof IgnoreTarget) {
            return;
        }
        if (this.isForContext()) {
            CodeAttr codeAttr = compilation.getCode();
            if (compilation.method.getStaticFlag()) {
                codeAttr.emitGetStatic(compilation.moduleInstanceMainField);
            } else {
                codeAttr.emitPushThis();
            }
            target.compileFromStack(compilation, this.getType());
        } else {
            super.compile(compilation, target);
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkThisExp(this);
    }

    public final Type getType() {
        if (this.binding != null) {
            return this.binding.getType();
        }
        if (this.context instanceof ClassExp || this.context instanceof ModuleExp) {
            return this.context.getType();
        }
        return Type.pointer_type;
    }
}

