/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.ClassType;
import gnu.kawa.functions.GetNamedPart;
import gnu.mapping.Namespace;
import gnu.mapping.WrappedException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Hashtable;

public class ClassNamespace
extends Namespace
implements Externalizable {
    ClassType ctype;

    public ClassType getClassType() {
        return this.ctype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassNamespace getInstance(String string, ClassType classType) {
        Hashtable hashtable2 = nsTable;
        synchronized (hashtable2) {
            Object v = nsTable.get(string);
            if (v instanceof ClassNamespace) {
                return (ClassNamespace)v;
            }
            ClassNamespace classNamespace = new ClassNamespace(classType);
            nsTable.put(string, classNamespace);
            return classNamespace;
        }
    }

    public ClassNamespace() {
    }

    public ClassNamespace(ClassType classType) {
        this.setName("class:" + classType.getName());
        this.ctype = classType;
    }

    public Object get(String string) {
        try {
            return GetNamedPart.getTypePart(this.ctype, string);
        }
        catch (Throwable throwable) {
            throw WrappedException.wrapIfNeeded(throwable);
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.ctype);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ctype = (ClassType)objectInput.readObject();
        this.setName("class:" + this.ctype.getName());
    }

    public Object readResolve() throws ObjectStreamException {
        String string = this.getName();
        if (string != null) {
            Namespace namespace = (Namespace)nsTable.get(string);
            if (namespace instanceof ClassNamespace) {
                return namespace;
            }
            nsTable.put(string, this);
        }
        return this;
    }
}

