/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

#include "InspectorBackendDispatcher.h"
#include "InspectorFrontendRouter.h"
#include "InspectorProtocolTypes.h"

namespace Inspector {

class AlternateBackendDispatcher {
public:
    void setBackendDispatcher(RefPtr<BackendDispatcher>&& dispatcher) { m_backendDispatcher = WTFMove(dispatcher); }
    BackendDispatcher* backendDispatcher() const { return m_backendDispatcher.get(); }
private:
    RefPtr<BackendDispatcher> m_backendDispatcher;
};


class AlternateAnimationBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateAnimationBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void requestEffectTarget(long callId, const String& in_animationId) = 0;
    virtual void resolveAnimation(long callId, const String& in_animationId, const String* in_objectGroup) = 0;
    virtual void startTracking(long callId) = 0;
    virtual void stopTracking(long callId) = 0;
};

class AlternateApplicationCacheBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateApplicationCacheBackendDispatcher() { }
    virtual void getFramesWithManifests(long callId) = 0;
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void getManifestForFrame(long callId, const String& in_frameId) = 0;
    virtual void getApplicationCacheForFrame(long callId, const String& in_frameId) = 0;
};

class AlternateAuditBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateAuditBackendDispatcher() { }
    virtual void setup(long callId, const int* in_contextId) = 0;
    virtual void run(long callId, const String& in_test, const int* in_contextId) = 0;
    virtual void teardown(long callId) = 0;
};

class AlternateBrowserBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateBrowserBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateCPUProfilerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateCPUProfilerBackendDispatcher() { }
    virtual void startTracking(long callId) = 0;
    virtual void stopTracking(long callId) = 0;
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class AlternateCSSBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateCSSBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void getMatchedStylesForNode(long callId, int in_nodeId, const bool* in_includePseudo, const bool* in_includeInherited) = 0;
    virtual void getInlineStylesForNode(long callId, int in_nodeId) = 0;
    virtual void getComputedStyleForNode(long callId, int in_nodeId) = 0;
    virtual void getAllStyleSheets(long callId) = 0;
    virtual void getStyleSheet(long callId, const String& in_styleSheetId) = 0;
    virtual void getStyleSheetText(long callId, const String& in_styleSheetId) = 0;
    virtual void setStyleSheetText(long callId, const String& in_styleSheetId, const String& in_text) = 0;
    virtual void setStyleText(long callId, const JSON::Object& in_styleId, const String& in_text) = 0;
    virtual void setRuleSelector(long callId, const JSON::Object& in_ruleId, const String& in_selector) = 0;
    virtual void createStyleSheet(long callId, const String& in_frameId) = 0;
    virtual void addRule(long callId, const String& in_styleSheetId, const String& in_selector) = 0;
    virtual void getSupportedCSSProperties(long callId) = 0;
    virtual void getSupportedSystemFontFamilyNames(long callId) = 0;
    virtual void forcePseudoState(long callId, int in_nodeId, const JSON::Array& in_forcedPseudoClasses) = 0;
};

class AlternateCanvasBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateCanvasBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void requestNode(long callId, const String& in_canvasId) = 0;
    virtual void requestContent(long callId, const String& in_canvasId) = 0;
    virtual void requestClientNodes(long callId, const String& in_canvasId) = 0;
    virtual void resolveContext(long callId, const String& in_canvasId, const String* in_objectGroup) = 0;
    virtual void setRecordingAutoCaptureFrameCount(long callId, int in_count) = 0;
    virtual void startRecording(long callId, const String& in_canvasId, const int* in_frameCount, const int* in_memoryLimit) = 0;
    virtual void stopRecording(long callId, const String& in_canvasId) = 0;
#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
    virtual void requestShaderSource(long callId, const String& in_programId, const String& in_shaderType) = 0;
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
#if (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
    virtual void updateShader(long callId, const String& in_programId, const String& in_shaderType, const String& in_source) = 0;
#endif // (defined(ENABLE_WEBGL) && ENABLE_WEBGL) || (defined(ENABLE_WEBGPU) && ENABLE_WEBGPU)
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual void setShaderProgramDisabled(long callId, const String& in_programId, bool in_disabled) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual void setShaderProgramHighlighted(long callId, const String& in_programId, bool in_highlighted) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
};

class AlternateConsoleBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateConsoleBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void clearMessages(long callId) = 0;
    virtual void getLoggingChannels(long callId) = 0;
    virtual void setLoggingChannelLevel(long callId, const String& in_source, const String& in_level) = 0;
};

class AlternateDOMBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDOMBackendDispatcher() { }
    virtual void getDocument(long callId) = 0;
    virtual void requestChildNodes(long callId, int in_nodeId, const int* in_depth) = 0;
    virtual void querySelector(long callId, int in_nodeId, const String& in_selector) = 0;
    virtual void querySelectorAll(long callId, int in_nodeId, const String& in_selector) = 0;
    virtual void setNodeName(long callId, int in_nodeId, const String& in_name) = 0;
    virtual void setNodeValue(long callId, int in_nodeId, const String& in_value) = 0;
    virtual void removeNode(long callId, int in_nodeId) = 0;
    virtual void setAttributeValue(long callId, int in_nodeId, const String& in_name, const String& in_value) = 0;
    virtual void setAttributesAsText(long callId, int in_nodeId, const String& in_text, const String* in_name) = 0;
    virtual void removeAttribute(long callId, int in_nodeId, const String& in_name) = 0;
    virtual void getSupportedEventNames(long callId) = 0;
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual void getDataBindingsForNode(long callId, int in_nodeId) = 0;
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual void getAssociatedDataForNode(long callId, int in_nodeId) = 0;
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual void getEventListenersForNode(long callId, int in_nodeId) = 0;
    virtual void setEventListenerDisabled(long callId, int in_eventListenerId, bool in_disabled) = 0;
    virtual void setBreakpointForEventListener(long callId, int in_eventListenerId) = 0;
    virtual void removeBreakpointForEventListener(long callId, int in_eventListenerId) = 0;
    virtual void getAccessibilityPropertiesForNode(long callId, int in_nodeId) = 0;
    virtual void getOuterHTML(long callId, int in_nodeId) = 0;
    virtual void setOuterHTML(long callId, int in_nodeId, const String& in_outerHTML) = 0;
    virtual void insertAdjacentHTML(long callId, int in_nodeId, const String& in_position, const String& in_html) = 0;
    virtual void performSearch(long callId, const String& in_query, const JSON::Array* in_nodeIds, const bool* in_caseSensitive) = 0;
    virtual void getSearchResults(long callId, const String& in_searchId, int in_fromIndex, int in_toIndex) = 0;
    virtual void discardSearchResults(long callId, const String& in_searchId) = 0;
    virtual void requestNode(long callId, const String& in_objectId) = 0;
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    virtual void setInspectModeEnabled(long callId, bool in_enabled, const JSON::Object* in_highlightConfig) = 0;
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual void setInspectModeEnabled(long callId, bool in_enabled, const JSON::Object* in_highlightConfig, const bool* in_showRulers) = 0;
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual void highlightRect(long callId, int in_x, int in_y, int in_width, int in_height, const JSON::Object* in_color, const JSON::Object* in_outlineColor, const bool* in_usePageCoordinates) = 0;
    virtual void highlightQuad(long callId, const JSON::Array& in_quad, const JSON::Object* in_color, const JSON::Object* in_outlineColor, const bool* in_usePageCoordinates) = 0;
    virtual void highlightSelector(long callId, const JSON::Object& in_highlightConfig, const String& in_selectorString, const String* in_frameId) = 0;
    virtual void highlightNode(long callId, const JSON::Object& in_highlightConfig, const int* in_nodeId, const String* in_objectId) = 0;
    virtual void highlightNodeList(long callId, const JSON::Array& in_nodeIds, const JSON::Object& in_highlightConfig) = 0;
    virtual void hideHighlight(long callId) = 0;
    virtual void highlightFrame(long callId, const String& in_frameId, const JSON::Object* in_contentColor, const JSON::Object* in_contentOutlineColor) = 0;
    virtual void pushNodeByPathToFrontend(long callId, const String& in_path) = 0;
    virtual void resolveNode(long callId, const int* in_nodeId, const String* in_objectId, const int* in_executionContextId, const String* in_objectGroup) = 0;
    virtual void getAttributes(long callId, int in_nodeId) = 0;
    virtual void moveTo(long callId, int in_nodeId, int in_targetNodeId, const int* in_insertBeforeNodeId) = 0;
    virtual void undo(long callId) = 0;
    virtual void redo(long callId) = 0;
    virtual void markUndoableState(long callId) = 0;
    virtual void focus(long callId, int in_nodeId) = 0;
    virtual void setInspectedNode(long callId, int in_nodeId) = 0;
    virtual void setAllowEditingUserAgentShadowTrees(long callId, bool in_allow) = 0;
    virtual void describeNode(long callId, const String& in_objectId) = 0;
    virtual void scrollIntoViewIfNeeded(long callId, const String& in_objectId, const JSON::Object* in_rect) = 0;
    virtual void getContentQuads(long callId, const String& in_objectId) = 0;
    virtual void setInputFiles(long callId, const String& in_objectId, const JSON::Array& in_files) = 0;
};

class AlternateDOMDebuggerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDOMDebuggerBackendDispatcher() { }
    virtual void setDOMBreakpoint(long callId, int in_nodeId, const String& in_type) = 0;
    virtual void removeDOMBreakpoint(long callId, int in_nodeId, const String& in_type) = 0;
    virtual void setEventBreakpoint(long callId, const String& in_breakpointType, const String* in_eventName) = 0;
    virtual void removeEventBreakpoint(long callId, const String& in_breakpointType, const String* in_eventName) = 0;
    virtual void setURLBreakpoint(long callId, const String& in_url, const bool* in_isRegex) = 0;
    virtual void removeURLBreakpoint(long callId, const String& in_url) = 0;
};

class AlternateDOMStorageBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDOMStorageBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void getDOMStorageItems(long callId, const JSON::Object& in_storageId) = 0;
    virtual void setDOMStorageItem(long callId, const JSON::Object& in_storageId, const String& in_key, const String& in_value) = 0;
    virtual void removeDOMStorageItem(long callId, const JSON::Object& in_storageId, const String& in_key) = 0;
    virtual void clearDOMStorageItems(long callId, const JSON::Object& in_storageId) = 0;
};

class AlternateDatabaseBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDatabaseBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void getDatabaseTableNames(long callId, const String& in_databaseId) = 0;
    virtual void executeSQL(long callId, const String& in_databaseId, const String& in_query) = 0;
};

class AlternateDebuggerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDebuggerBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void setAsyncStackTraceDepth(long callId, int in_depth) = 0;
    virtual void setBreakpointsActive(long callId, bool in_active) = 0;
    virtual void setBreakpointByUrl(long callId, int in_lineNumber, const String* in_url, const String* in_urlRegex, const int* in_columnNumber, const JSON::Object* in_options) = 0;
    virtual void setBreakpoint(long callId, const JSON::Object& in_location, const JSON::Object* in_options) = 0;
    virtual void removeBreakpoint(long callId, const String& in_breakpointId) = 0;
    virtual void continueUntilNextRunLoop(long callId) = 0;
    virtual void continueToLocation(long callId, const JSON::Object& in_location) = 0;
    virtual void stepNext(long callId) = 0;
    virtual void stepOver(long callId) = 0;
    virtual void stepInto(long callId) = 0;
    virtual void stepOut(long callId) = 0;
    virtual void pause(long callId) = 0;
    virtual void resume(long callId) = 0;
    virtual void searchInContent(long callId, const String& in_scriptId, const String& in_query, const bool* in_caseSensitive, const bool* in_isRegex) = 0;
    virtual void getScriptSource(long callId, const String& in_scriptId) = 0;
    virtual void getFunctionDetails(long callId, const String& in_functionId) = 0;
    virtual void setPauseOnDebuggerStatements(long callId, bool in_enabled) = 0;
    virtual void setPauseOnExceptions(long callId, const String& in_state) = 0;
    virtual void setPauseOnAssertions(long callId, bool in_enabled) = 0;
    virtual void setPauseOnMicrotasks(long callId, bool in_enabled) = 0;
    virtual void setPauseForInternalScripts(long callId, bool in_shouldPause) = 0;
    virtual void evaluateOnCallFrame(long callId, const String& in_callFrameId, const String& in_expression, const String* in_objectGroup, const bool* in_includeCommandLineAPI, const bool* in_doNotPauseOnExceptionsAndMuteConsole, const bool* in_returnByValue, const bool* in_generatePreview, const bool* in_saveResult, const bool* in_emulateUserGesture) = 0;
    virtual void setShouldBlackboxURL(long callId, const String& in_url, bool in_shouldBlackbox, const bool* in_caseSensitive, const bool* in_isRegex) = 0;
};

class AlternateDialogBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateDialogBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void handleJavaScriptDialog(long callId, bool in_accept, const String* in_promptText) = 0;
};

class AlternateEmulationBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateEmulationBackendDispatcher() { }
    virtual void setDeviceMetricsOverride(long callId, int in_width, int in_height, double in_deviceScaleFactor, bool in_fixedLayout) = 0;
    virtual void setJavaScriptEnabled(long callId, bool in_enabled) = 0;
    virtual void setAuthCredentials(long callId, const String* in_username, const String* in_password) = 0;
    virtual void setActiveAndFocused(long callId, const bool* in_active) = 0;
    virtual void grantPermissions(long callId, const String& in_origin, const JSON::Array& in_permissions) = 0;
    virtual void resetPermissions(long callId) = 0;
};

class AlternateHeapBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateHeapBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void gc(long callId) = 0;
    virtual void snapshot(long callId) = 0;
    virtual void startTracking(long callId) = 0;
    virtual void stopTracking(long callId) = 0;
    virtual void getPreview(long callId, int in_heapObjectId) = 0;
    virtual void getRemoteObject(long callId, int in_heapObjectId, const String* in_objectGroup) = 0;
};

#if defined(ENABLE_INDEXED_DATABASE) && ENABLE_INDEXED_DATABASE
class AlternateIndexedDBBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateIndexedDBBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void requestDatabaseNames(long callId, const String& in_securityOrigin) = 0;
    virtual void requestDatabase(long callId, const String& in_securityOrigin, const String& in_databaseName) = 0;
    virtual void requestData(long callId, const String& in_securityOrigin, const String& in_databaseName, const String& in_objectStoreName, const String& in_indexName, int in_skipCount, int in_pageSize, const JSON::Object* in_keyRange) = 0;
    virtual void clearObjectStore(long callId, const String& in_securityOrigin, const String& in_databaseName, const String& in_objectStoreName) = 0;
};
#endif // defined(ENABLE_INDEXED_DATABASE) && ENABLE_INDEXED_DATABASE

class AlternateInputBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateInputBackendDispatcher() { }
    virtual void dispatchKeyEvent(long callId, const String& in_type, const int* in_modifiers, const String* in_text, const String* in_unmodifiedText, const String* in_code, const String* in_key, const int* in_windowsVirtualKeyCode, const int* in_nativeVirtualKeyCode, const bool* in_autoRepeat, const bool* in_isKeypad, const bool* in_isSystemKey, const JSON::Array* in_macCommands) = 0;
    virtual void dispatchMouseEvent(long callId, const String& in_type, int in_x, int in_y, const int* in_modifiers, const String* in_button, const int* in_buttons, const int* in_clickCount, const int* in_deltaX, const int* in_deltaY) = 0;
};

class AlternateInspectorBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateInspectorBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void initialized(long callId) = 0;
};

class AlternateLayerTreeBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateLayerTreeBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void layersForNode(long callId, int in_nodeId) = 0;
    virtual void reasonsForCompositingLayer(long callId, const String& in_layerId) = 0;
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateMemoryBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateMemoryBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void startTracking(long callId) = 0;
    virtual void stopTracking(long callId) = 0;
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class AlternateNetworkBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateNetworkBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void setExtraHTTPHeaders(long callId, const JSON::Object& in_headers) = 0;
    virtual void getResponseBody(long callId, const String& in_requestId) = 0;
    virtual void setResourceCachingDisabled(long callId, bool in_disabled) = 0;
    virtual void loadResource(long callId, const String& in_frameId, const String& in_url) = 0;
    virtual void getSerializedCertificate(long callId, const String& in_requestId) = 0;
    virtual void resolveWebSocket(long callId, const String& in_requestId, const String* in_objectGroup) = 0;
    virtual void setInterceptionEnabled(long callId, bool in_enabled) = 0;
    virtual void addInterception(long callId, const String& in_url, const String& in_stage, const bool* in_caseSensitive, const bool* in_isRegex) = 0;
    virtual void removeInterception(long callId, const String& in_url, const String& in_stage, const bool* in_caseSensitive, const bool* in_isRegex) = 0;
    virtual void interceptContinue(long callId, const String& in_requestId, const String& in_stage) = 0;
    virtual void interceptWithRequest(long callId, const String& in_requestId, const String* in_url, const String* in_method, const JSON::Object* in_headers, const String* in_postData) = 0;
    virtual void interceptWithResponse(long callId, const String& in_requestId, const String& in_content, bool in_base64Encoded, const String* in_mimeType, const int* in_status, const String* in_statusText, const JSON::Object* in_headers) = 0;
    virtual void interceptRequestWithResponse(long callId, const String& in_requestId, const String& in_content, bool in_base64Encoded, const String& in_mimeType, int in_status, const String& in_statusText, const JSON::Object& in_headers) = 0;
    virtual void interceptRequestWithError(long callId, const String& in_requestId, const String& in_errorType) = 0;
    virtual void setEmulateOfflineState(long callId, bool in_offline) = 0;
};

class AlternatePageBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternatePageBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void reload(long callId, const bool* in_ignoreCache, const bool* in_revalidateAllResources) = 0;
    virtual void goBack(long callId) = 0;
    virtual void goForward(long callId) = 0;
    virtual void navigate(long callId, const String& in_url) = 0;
    virtual void overrideUserAgent(long callId, const String* in_value) = 0;
    virtual void overrideSetting(long callId, const String& in_setting, const bool* in_value) = 0;
    virtual void getCookies(long callId) = 0;
    virtual void setCookie(long callId, const JSON::Object& in_cookie) = 0;
    virtual void deleteCookie(long callId, const String& in_cookieName, const String& in_url) = 0;
    virtual void getResourceTree(long callId) = 0;
    virtual void getResourceContent(long callId, const String& in_frameId, const String& in_url) = 0;
    virtual void setBootstrapScript(long callId, const String* in_source) = 0;
    virtual void searchInResource(long callId, const String& in_frameId, const String& in_url, const String& in_query, const bool* in_caseSensitive, const bool* in_isRegex, const String* in_requestId) = 0;
    virtual void searchInResources(long callId, const String& in_text, const bool* in_caseSensitive, const bool* in_isRegex) = 0;
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual void setShowRulers(long callId, bool in_result) = 0;
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual void setShowPaintRects(long callId, bool in_result) = 0;
    virtual void setEmulatedMedia(long callId, const String& in_media) = 0;
#if (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
    virtual void setForcedAppearance(long callId, const String& in_appearance) = 0;
#endif // (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
    virtual void setTimeZone(long callId, const String* in_timeZone) = 0;
    virtual void setTouchEmulationEnabled(long callId, bool in_enabled) = 0;
    virtual void snapshotNode(long callId, int in_nodeId) = 0;
    virtual void snapshotRect(long callId, int in_x, int in_y, int in_width, int in_height, const String& in_coordinateSystem) = 0;
#if (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
    virtual void archive(long callId) = 0;
#endif // (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
    virtual void insertText(long callId, const String& in_text) = 0;
    virtual void accessibilitySnapshot(long callId, const String* in_objectId) = 0;
    virtual void setInterceptFileChooserDialog(long callId, bool in_enabled) = 0;
    virtual void setDefaultBackgroundColorOverride(long callId, const JSON::Object* in_color) = 0;
    virtual void createUserWorld(long callId, const String& in_name) = 0;
    virtual void setBypassCSP(long callId, bool in_enabled) = 0;
    virtual void crash(long callId) = 0;
    virtual void setScreenSizeOverride(long callId, int in_width, int in_height) = 0;
    virtual void setOrientationOverride(long callId, const int* in_angle) = 0;
};

class AlternatePlaywrightBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternatePlaywrightBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void close(long callId) = 0;
    virtual void createContext(long callId, const String* in_proxyServer, const String* in_proxyBypassList) = 0;
    virtual void deleteContext(long callId, const String& in_browserContextId) = 0;
    virtual void createPage(long callId, const String* in_browserContextId) = 0;
    virtual void navigate(long callId, const String& in_url, const String& in_pageProxyId, const String* in_frameId, const String* in_referrer) = 0;
    virtual void setIgnoreCertificateErrors(long callId, const String* in_browserContextId, bool in_ignore) = 0;
    virtual void getAllCookies(long callId, const String* in_browserContextId) = 0;
    virtual void setCookies(long callId, const String* in_browserContextId, const JSON::Array& in_cookies) = 0;
    virtual void deleteAllCookies(long callId, const String* in_browserContextId) = 0;
    virtual void setGeolocationOverride(long callId, const String* in_browserContextId, const JSON::Object* in_geolocation) = 0;
    virtual void setLanguages(long callId, const JSON::Array& in_languages, const String* in_browserContextId) = 0;
    virtual void setDownloadBehavior(long callId, const String* in_behavior, const String* in_downloadPath, const String* in_browserContextId) = 0;
};

class AlternateRuntimeBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateRuntimeBackendDispatcher() { }
    virtual void parse(long callId, const String& in_source) = 0;
    virtual void evaluate(long callId, const String& in_expression, const String* in_objectGroup, const bool* in_includeCommandLineAPI, const bool* in_doNotPauseOnExceptionsAndMuteConsole, const int* in_contextId, const bool* in_returnByValue, const bool* in_generatePreview, const bool* in_saveResult, const bool* in_emulateUserGesture) = 0;
    virtual void awaitPromise(long callId, const String& in_promiseObjectId, const bool* in_returnByValue, const bool* in_generatePreview, const bool* in_saveResult) = 0;
    virtual void callFunctionOn(long callId, const String& in_objectId, const String& in_functionDeclaration, const JSON::Array* in_arguments, const bool* in_doNotPauseOnExceptionsAndMuteConsole, const bool* in_returnByValue, const bool* in_generatePreview, const bool* in_emulateUserGesture) = 0;
    virtual void getPreview(long callId, const String& in_objectId) = 0;
    virtual void getProperties(long callId, const String& in_objectId, const bool* in_ownProperties, const int* in_fetchStart, const int* in_fetchCount, const bool* in_generatePreview) = 0;
    virtual void getDisplayableProperties(long callId, const String& in_objectId, const int* in_fetchStart, const int* in_fetchCount, const bool* in_generatePreview) = 0;
    virtual void getCollectionEntries(long callId, const String& in_objectId, const String* in_objectGroup, const int* in_fetchStart, const int* in_fetchCount) = 0;
    virtual void saveResult(long callId, const JSON::Object& in_value, const int* in_contextId) = 0;
    virtual void setSavedResultAlias(long callId, const String* in_alias) = 0;
    virtual void releaseObject(long callId, const String& in_objectId) = 0;
    virtual void releaseObjectGroup(long callId, const String& in_objectGroup) = 0;
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void getRuntimeTypesForVariablesAtOffsets(long callId, const JSON::Array& in_locations) = 0;
    virtual void enableTypeProfiler(long callId) = 0;
    virtual void disableTypeProfiler(long callId) = 0;
    virtual void enableControlFlowProfiler(long callId) = 0;
    virtual void disableControlFlowProfiler(long callId) = 0;
    virtual void getBasicBlocks(long callId, const String& in_sourceID) = 0;
};

class AlternateScreencastBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateScreencastBackendDispatcher() { }
    virtual void start(long callId, const String& in_file, int in_width, int in_height, const double* in_scale) = 0;
    virtual void stop(long callId) = 0;
};

class AlternateScriptProfilerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateScriptProfilerBackendDispatcher() { }
    virtual void startTracking(long callId, const bool* in_includeSamples) = 0;
    virtual void stopTracking(long callId) = 0;
};

#if defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER
class AlternateServiceWorkerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateServiceWorkerBackendDispatcher() { }
    virtual void getInitializationInfo(long callId) = 0;
};
#endif // defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER

class AlternateTargetBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateTargetBackendDispatcher() { }
    virtual void setPauseOnStart(long callId, bool in_pauseOnStart) = 0;
    virtual void resume(long callId, const String& in_targetId) = 0;
    virtual void sendMessageToTarget(long callId, const String& in_targetId, const String& in_message) = 0;
    virtual void activate(long callId, const String& in_targetId) = 0;
    virtual void close(long callId, const String& in_targetId, const bool* in_runBeforeUnload) = 0;
};

class AlternateTimelineBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateTimelineBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void start(long callId, const int* in_maxCallStackDepth) = 0;
    virtual void stop(long callId) = 0;
    virtual void setAutoCaptureEnabled(long callId, bool in_enabled) = 0;
    virtual void setInstruments(long callId, const JSON::Array& in_instruments) = 0;
};

class AlternateWorkerBackendDispatcher : public AlternateBackendDispatcher {
public:
    virtual ~AlternateWorkerBackendDispatcher() { }
    virtual void enable(long callId) = 0;
    virtual void disable(long callId) = 0;
    virtual void initialized(long callId, const String& in_workerId) = 0;
    virtual void sendMessageToWorker(long callId, const String& in_workerId, const String& in_message) = 0;
};

} // namespace Inspector

#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
