/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

#include <JavaScriptCore/BuiltinUtils.h>
#include <JavaScriptCore/Identifier.h>
#include <JavaScriptCore/JSFunction.h>
#include <JavaScriptCore/UnlinkedFunctionExecutable.h>

namespace JSC {
class FunctionExecutable;
}

namespace WebCore {

/* WritableStreamInternals */
extern const char* const s_writableStreamInternalsIsWritableStreamCode;
extern const int s_writableStreamInternalsIsWritableStreamCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsIsWritableStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsIsWritableStreamCodeConstructorKind;
extern const char* const s_writableStreamInternalsIsWritableStreamDefaultWriterCode;
extern const int s_writableStreamInternalsIsWritableStreamDefaultWriterCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsIsWritableStreamDefaultWriterCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsIsWritableStreamDefaultWriterCodeConstructorKind;
extern const char* const s_writableStreamInternalsAcquireWritableStreamDefaultWriterCode;
extern const int s_writableStreamInternalsAcquireWritableStreamDefaultWriterCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsAcquireWritableStreamDefaultWriterCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsAcquireWritableStreamDefaultWriterCodeConstructorKind;
extern const char* const s_writableStreamInternalsCreateWritableStreamCode;
extern const int s_writableStreamInternalsCreateWritableStreamCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsCreateWritableStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsCreateWritableStreamCodeConstructorKind;
extern const char* const s_writableStreamInternalsPrivateInitializeWritableStreamCode;
extern const int s_writableStreamInternalsPrivateInitializeWritableStreamCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsPrivateInitializeWritableStreamCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsPrivateInitializeWritableStreamCodeConstructorKind;
extern const char* const s_writableStreamInternalsIsWritableStreamLockedCode;
extern const int s_writableStreamInternalsIsWritableStreamLockedCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsIsWritableStreamLockedCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsIsWritableStreamLockedCodeConstructorKind;
extern const char* const s_writableStreamInternalsSetUpWritableStreamDefaultWriterCode;
extern const int s_writableStreamInternalsSetUpWritableStreamDefaultWriterCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsSetUpWritableStreamDefaultWriterCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsSetUpWritableStreamDefaultWriterCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamAbortCode;
extern const int s_writableStreamInternalsWritableStreamAbortCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamAbortCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamAbortCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamCloseCode;
extern const int s_writableStreamInternalsWritableStreamCloseCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamCloseCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamAddWriteRequestCode;
extern const int s_writableStreamInternalsWritableStreamAddWriteRequestCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamAddWriteRequestCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamAddWriteRequestCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCode;
extern const int s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDealWithRejectionCode;
extern const int s_writableStreamInternalsWritableStreamDealWithRejectionCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDealWithRejectionCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDealWithRejectionCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamFinishErroringCode;
extern const int s_writableStreamInternalsWritableStreamFinishErroringCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamFinishErroringCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamFinishErroringCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamFinishInFlightCloseCode;
extern const int s_writableStreamInternalsWritableStreamFinishInFlightCloseCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamFinishInFlightCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamFinishInFlightCloseCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCode;
extern const int s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamFinishInFlightWriteCode;
extern const int s_writableStreamInternalsWritableStreamFinishInFlightWriteCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamFinishInFlightWriteCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamFinishInFlightWriteCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCode;
extern const int s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCode;
extern const int s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCode;
extern const int s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCode;
extern const int s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCode;
extern const int s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamStartErroringCode;
extern const int s_writableStreamInternalsWritableStreamStartErroringCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamStartErroringCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamStartErroringCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamUpdateBackpressureCode;
extern const int s_writableStreamInternalsWritableStreamUpdateBackpressureCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamUpdateBackpressureCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamUpdateBackpressureCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultWriterAbortCode;
extern const int s_writableStreamInternalsWritableStreamDefaultWriterAbortCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterAbortCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterAbortCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultWriterCloseCode;
extern const int s_writableStreamInternalsWritableStreamDefaultWriterCloseCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterCloseCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCode;
extern const int s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCode;
extern const int s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCode;
extern const int s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCode;
extern const int s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultWriterReleaseCode;
extern const int s_writableStreamInternalsWritableStreamDefaultWriterReleaseCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterReleaseCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterReleaseCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultWriterWriteCode;
extern const int s_writableStreamInternalsWritableStreamDefaultWriterWriteCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterWriteCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterWriteCodeConstructorKind;
extern const char* const s_writableStreamInternalsSetUpWritableStreamDefaultControllerCode;
extern const int s_writableStreamInternalsSetUpWritableStreamDefaultControllerCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsSetUpWritableStreamDefaultControllerCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsSetUpWritableStreamDefaultControllerCodeConstructorKind;
extern const char* const s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCode;
extern const int s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCode;
extern const int s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCodeConstructorKind;
extern const char* const s_writableStreamInternalsIsCloseSentinelCode;
extern const int s_writableStreamInternalsIsCloseSentinelCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsIsCloseSentinelCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsIsCloseSentinelCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCode;
extern const int s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultControllerCloseCode;
extern const int s_writableStreamInternalsWritableStreamDefaultControllerCloseCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerCloseCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultControllerErrorCode;
extern const int s_writableStreamInternalsWritableStreamDefaultControllerErrorCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerErrorCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerErrorCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCode;
extern const int s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCode;
extern const int s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCode;
extern const int s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCode;
extern const int s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCode;
extern const int s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCode;
extern const int s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCodeConstructorKind;
extern const char* const s_writableStreamInternalsWritableStreamDefaultControllerWriteCode;
extern const int s_writableStreamInternalsWritableStreamDefaultControllerWriteCodeLength;
extern const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerWriteCodeConstructAbility;
extern const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerWriteCodeConstructorKind;

#define WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_DATA(macro) \
    macro(isWritableStream, writableStreamInternalsIsWritableStream, 1) \
    macro(isWritableStreamDefaultWriter, writableStreamInternalsIsWritableStreamDefaultWriter, 1) \
    macro(acquireWritableStreamDefaultWriter, writableStreamInternalsAcquireWritableStreamDefaultWriter, 1) \
    macro(createWritableStream, writableStreamInternalsCreateWritableStream, 6) \
    macro(privateInitializeWritableStream, writableStreamInternalsPrivateInitializeWritableStream, 2) \
    macro(isWritableStreamLocked, writableStreamInternalsIsWritableStreamLocked, 1) \
    macro(setUpWritableStreamDefaultWriter, writableStreamInternalsSetUpWritableStreamDefaultWriter, 2) \
    macro(writableStreamAbort, writableStreamInternalsWritableStreamAbort, 2) \
    macro(writableStreamClose, writableStreamInternalsWritableStreamClose, 1) \
    macro(writableStreamAddWriteRequest, writableStreamInternalsWritableStreamAddWriteRequest, 1) \
    macro(writableStreamCloseQueuedOrInFlight, writableStreamInternalsWritableStreamCloseQueuedOrInFlight, 1) \
    macro(writableStreamDealWithRejection, writableStreamInternalsWritableStreamDealWithRejection, 2) \
    macro(writableStreamFinishErroring, writableStreamInternalsWritableStreamFinishErroring, 1) \
    macro(writableStreamFinishInFlightClose, writableStreamInternalsWritableStreamFinishInFlightClose, 1) \
    macro(writableStreamFinishInFlightCloseWithError, writableStreamInternalsWritableStreamFinishInFlightCloseWithError, 2) \
    macro(writableStreamFinishInFlightWrite, writableStreamInternalsWritableStreamFinishInFlightWrite, 1) \
    macro(writableStreamFinishInFlightWriteWithError, writableStreamInternalsWritableStreamFinishInFlightWriteWithError, 2) \
    macro(writableStreamHasOperationMarkedInFlight, writableStreamInternalsWritableStreamHasOperationMarkedInFlight, 1) \
    macro(writableStreamMarkCloseRequestInFlight, writableStreamInternalsWritableStreamMarkCloseRequestInFlight, 1) \
    macro(writableStreamMarkFirstWriteRequestInFlight, writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlight, 1) \
    macro(writableStreamRejectCloseAndClosedPromiseIfNeeded, writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeeded, 1) \
    macro(writableStreamStartErroring, writableStreamInternalsWritableStreamStartErroring, 2) \
    macro(writableStreamUpdateBackpressure, writableStreamInternalsWritableStreamUpdateBackpressure, 2) \
    macro(writableStreamDefaultWriterAbort, writableStreamInternalsWritableStreamDefaultWriterAbort, 2) \
    macro(writableStreamDefaultWriterClose, writableStreamInternalsWritableStreamDefaultWriterClose, 1) \
    macro(writableStreamDefaultWriterCloseWithErrorPropagation, writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagation, 1) \
    macro(writableStreamDefaultWriterEnsureClosedPromiseRejected, writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejected, 2) \
    macro(writableStreamDefaultWriterEnsureReadyPromiseRejected, writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejected, 2) \
    macro(writableStreamDefaultWriterGetDesiredSize, writableStreamInternalsWritableStreamDefaultWriterGetDesiredSize, 1) \
    macro(writableStreamDefaultWriterRelease, writableStreamInternalsWritableStreamDefaultWriterRelease, 1) \
    macro(writableStreamDefaultWriterWrite, writableStreamInternalsWritableStreamDefaultWriterWrite, 2) \
    macro(setUpWritableStreamDefaultController, writableStreamInternalsSetUpWritableStreamDefaultController, 8) \
    macro(setUpWritableStreamDefaultControllerFromUnderlyingSink, writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSink, 5) \
    macro(writableStreamDefaultControllerAdvanceQueueIfNeeded, writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeeded, 1) \
    macro(isCloseSentinel, writableStreamInternalsIsCloseSentinel, 0) \
    macro(writableStreamDefaultControllerClearAlgorithms, writableStreamInternalsWritableStreamDefaultControllerClearAlgorithms, 1) \
    macro(writableStreamDefaultControllerClose, writableStreamInternalsWritableStreamDefaultControllerClose, 1) \
    macro(writableStreamDefaultControllerError, writableStreamInternalsWritableStreamDefaultControllerError, 2) \
    macro(writableStreamDefaultControllerErrorIfNeeded, writableStreamInternalsWritableStreamDefaultControllerErrorIfNeeded, 2) \
    macro(writableStreamDefaultControllerGetBackpressure, writableStreamInternalsWritableStreamDefaultControllerGetBackpressure, 1) \
    macro(writableStreamDefaultControllerGetChunkSize, writableStreamInternalsWritableStreamDefaultControllerGetChunkSize, 2) \
    macro(writableStreamDefaultControllerGetDesiredSize, writableStreamInternalsWritableStreamDefaultControllerGetDesiredSize, 1) \
    macro(writableStreamDefaultControllerProcessClose, writableStreamInternalsWritableStreamDefaultControllerProcessClose, 1) \
    macro(writableStreamDefaultControllerProcessWrite, writableStreamInternalsWritableStreamDefaultControllerProcessWrite, 2) \
    macro(writableStreamDefaultControllerWrite, writableStreamInternalsWritableStreamDefaultControllerWrite, 3) \

#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_ISWRITABLESTREAM 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_ISWRITABLESTREAMDEFAULTWRITER 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_ACQUIREWRITABLESTREAMDEFAULTWRITER 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_CREATEWRITABLESTREAM 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_PRIVATEINITIALIZEWRITABLESTREAM 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_ISWRITABLESTREAMLOCKED 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_SETUPWRITABLESTREAMDEFAULTWRITER 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMABORT 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMCLOSE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMADDWRITEREQUEST 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMCLOSEQUEUEDORINFLIGHT 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEALWITHREJECTION 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMFINISHERRORING 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMFINISHINFLIGHTCLOSE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMFINISHINFLIGHTCLOSEWITHERROR 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMFINISHINFLIGHTWRITE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMFINISHINFLIGHTWRITEWITHERROR 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMHASOPERATIONMARKEDINFLIGHT 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMMARKCLOSEREQUESTINFLIGHT 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMMARKFIRSTWRITEREQUESTINFLIGHT 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMREJECTCLOSEANDCLOSEDPROMISEIFNEEDED 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMSTARTERRORING 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMUPDATEBACKPRESSURE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTWRITERABORT 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTWRITERCLOSE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTWRITERCLOSEWITHERRORPROPAGATION 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTWRITERENSURECLOSEDPROMISEREJECTED 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTWRITERENSUREREADYPROMISEREJECTED 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTWRITERGETDESIREDSIZE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTWRITERRELEASE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTWRITERWRITE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_SETUPWRITABLESTREAMDEFAULTCONTROLLER 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_SETUPWRITABLESTREAMDEFAULTCONTROLLERFROMUNDERLYINGSINK 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTCONTROLLERADVANCEQUEUEIFNEEDED 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_ISCLOSESENTINEL 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTCONTROLLERCLEARALGORITHMS 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTCONTROLLERCLOSE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTCONTROLLERERROR 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTCONTROLLERERRORIFNEEDED 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTCONTROLLERGETBACKPRESSURE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTCONTROLLERGETCHUNKSIZE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTCONTROLLERGETDESIREDSIZE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTCONTROLLERPROCESSCLOSE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTCONTROLLERPROCESSWRITE 1
#define WEBCORE_BUILTIN_WRITABLESTREAMINTERNALS_WRITABLESTREAMDEFAULTCONTROLLERWRITE 1

#define WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(macro) \
    macro(writableStreamInternalsIsWritableStreamCode, isWritableStream, static_cast<const char*>(nullptr), s_writableStreamInternalsIsWritableStreamCodeLength) \
    macro(writableStreamInternalsIsWritableStreamDefaultWriterCode, isWritableStreamDefaultWriter, static_cast<const char*>(nullptr), s_writableStreamInternalsIsWritableStreamDefaultWriterCodeLength) \
    macro(writableStreamInternalsAcquireWritableStreamDefaultWriterCode, acquireWritableStreamDefaultWriter, static_cast<const char*>(nullptr), s_writableStreamInternalsAcquireWritableStreamDefaultWriterCodeLength) \
    macro(writableStreamInternalsCreateWritableStreamCode, createWritableStream, static_cast<const char*>(nullptr), s_writableStreamInternalsCreateWritableStreamCodeLength) \
    macro(writableStreamInternalsPrivateInitializeWritableStreamCode, privateInitializeWritableStream, static_cast<const char*>(nullptr), s_writableStreamInternalsPrivateInitializeWritableStreamCodeLength) \
    macro(writableStreamInternalsIsWritableStreamLockedCode, isWritableStreamLocked, static_cast<const char*>(nullptr), s_writableStreamInternalsIsWritableStreamLockedCodeLength) \
    macro(writableStreamInternalsSetUpWritableStreamDefaultWriterCode, setUpWritableStreamDefaultWriter, static_cast<const char*>(nullptr), s_writableStreamInternalsSetUpWritableStreamDefaultWriterCodeLength) \
    macro(writableStreamInternalsWritableStreamAbortCode, writableStreamAbort, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamAbortCodeLength) \
    macro(writableStreamInternalsWritableStreamCloseCode, writableStreamClose, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamCloseCodeLength) \
    macro(writableStreamInternalsWritableStreamAddWriteRequestCode, writableStreamAddWriteRequest, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamAddWriteRequestCodeLength) \
    macro(writableStreamInternalsWritableStreamCloseQueuedOrInFlightCode, writableStreamCloseQueuedOrInFlight, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCodeLength) \
    macro(writableStreamInternalsWritableStreamDealWithRejectionCode, writableStreamDealWithRejection, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDealWithRejectionCodeLength) \
    macro(writableStreamInternalsWritableStreamFinishErroringCode, writableStreamFinishErroring, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamFinishErroringCodeLength) \
    macro(writableStreamInternalsWritableStreamFinishInFlightCloseCode, writableStreamFinishInFlightClose, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamFinishInFlightCloseCodeLength) \
    macro(writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCode, writableStreamFinishInFlightCloseWithError, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCodeLength) \
    macro(writableStreamInternalsWritableStreamFinishInFlightWriteCode, writableStreamFinishInFlightWrite, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamFinishInFlightWriteCodeLength) \
    macro(writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCode, writableStreamFinishInFlightWriteWithError, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCodeLength) \
    macro(writableStreamInternalsWritableStreamHasOperationMarkedInFlightCode, writableStreamHasOperationMarkedInFlight, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCodeLength) \
    macro(writableStreamInternalsWritableStreamMarkCloseRequestInFlightCode, writableStreamMarkCloseRequestInFlight, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCodeLength) \
    macro(writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCode, writableStreamMarkFirstWriteRequestInFlight, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCodeLength) \
    macro(writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCode, writableStreamRejectCloseAndClosedPromiseIfNeeded, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCodeLength) \
    macro(writableStreamInternalsWritableStreamStartErroringCode, writableStreamStartErroring, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamStartErroringCodeLength) \
    macro(writableStreamInternalsWritableStreamUpdateBackpressureCode, writableStreamUpdateBackpressure, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamUpdateBackpressureCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultWriterAbortCode, writableStreamDefaultWriterAbort, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultWriterAbortCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultWriterCloseCode, writableStreamDefaultWriterClose, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultWriterCloseCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCode, writableStreamDefaultWriterCloseWithErrorPropagation, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCode, writableStreamDefaultWriterEnsureClosedPromiseRejected, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCode, writableStreamDefaultWriterEnsureReadyPromiseRejected, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCode, writableStreamDefaultWriterGetDesiredSize, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultWriterReleaseCode, writableStreamDefaultWriterRelease, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultWriterReleaseCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultWriterWriteCode, writableStreamDefaultWriterWrite, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultWriterWriteCodeLength) \
    macro(writableStreamInternalsSetUpWritableStreamDefaultControllerCode, setUpWritableStreamDefaultController, static_cast<const char*>(nullptr), s_writableStreamInternalsSetUpWritableStreamDefaultControllerCodeLength) \
    macro(writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCode, setUpWritableStreamDefaultControllerFromUnderlyingSink, static_cast<const char*>(nullptr), s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCode, writableStreamDefaultControllerAdvanceQueueIfNeeded, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCodeLength) \
    macro(writableStreamInternalsIsCloseSentinelCode, isCloseSentinel, static_cast<const char*>(nullptr), s_writableStreamInternalsIsCloseSentinelCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCode, writableStreamDefaultControllerClearAlgorithms, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultControllerCloseCode, writableStreamDefaultControllerClose, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultControllerCloseCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultControllerErrorCode, writableStreamDefaultControllerError, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultControllerErrorCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCode, writableStreamDefaultControllerErrorIfNeeded, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCode, writableStreamDefaultControllerGetBackpressure, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCode, writableStreamDefaultControllerGetChunkSize, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCode, writableStreamDefaultControllerGetDesiredSize, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultControllerProcessCloseCode, writableStreamDefaultControllerProcessClose, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultControllerProcessWriteCode, writableStreamDefaultControllerProcessWrite, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCodeLength) \
    macro(writableStreamInternalsWritableStreamDefaultControllerWriteCode, writableStreamDefaultControllerWrite, static_cast<const char*>(nullptr), s_writableStreamInternalsWritableStreamDefaultControllerWriteCodeLength) \

#define WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(macro) \
    macro(acquireWritableStreamDefaultWriter) \
    macro(createWritableStream) \
    macro(isCloseSentinel) \
    macro(isWritableStream) \
    macro(isWritableStreamDefaultWriter) \
    macro(isWritableStreamLocked) \
    macro(privateInitializeWritableStream) \
    macro(setUpWritableStreamDefaultController) \
    macro(setUpWritableStreamDefaultControllerFromUnderlyingSink) \
    macro(setUpWritableStreamDefaultWriter) \
    macro(writableStreamAbort) \
    macro(writableStreamAddWriteRequest) \
    macro(writableStreamClose) \
    macro(writableStreamCloseQueuedOrInFlight) \
    macro(writableStreamDealWithRejection) \
    macro(writableStreamDefaultControllerAdvanceQueueIfNeeded) \
    macro(writableStreamDefaultControllerClearAlgorithms) \
    macro(writableStreamDefaultControllerClose) \
    macro(writableStreamDefaultControllerError) \
    macro(writableStreamDefaultControllerErrorIfNeeded) \
    macro(writableStreamDefaultControllerGetBackpressure) \
    macro(writableStreamDefaultControllerGetChunkSize) \
    macro(writableStreamDefaultControllerGetDesiredSize) \
    macro(writableStreamDefaultControllerProcessClose) \
    macro(writableStreamDefaultControllerProcessWrite) \
    macro(writableStreamDefaultControllerWrite) \
    macro(writableStreamDefaultWriterAbort) \
    macro(writableStreamDefaultWriterClose) \
    macro(writableStreamDefaultWriterCloseWithErrorPropagation) \
    macro(writableStreamDefaultWriterEnsureClosedPromiseRejected) \
    macro(writableStreamDefaultWriterEnsureReadyPromiseRejected) \
    macro(writableStreamDefaultWriterGetDesiredSize) \
    macro(writableStreamDefaultWriterRelease) \
    macro(writableStreamDefaultWriterWrite) \
    macro(writableStreamFinishErroring) \
    macro(writableStreamFinishInFlightClose) \
    macro(writableStreamFinishInFlightCloseWithError) \
    macro(writableStreamFinishInFlightWrite) \
    macro(writableStreamFinishInFlightWriteWithError) \
    macro(writableStreamHasOperationMarkedInFlight) \
    macro(writableStreamMarkCloseRequestInFlight) \
    macro(writableStreamMarkFirstWriteRequestInFlight) \
    macro(writableStreamRejectCloseAndClosedPromiseIfNeeded) \
    macro(writableStreamStartErroring) \
    macro(writableStreamUpdateBackpressure) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

class WritableStreamInternalsBuiltinsWrapper : private JSC::WeakHandleOwner {
public:
    explicit WritableStreamInternalsBuiltinsWrapper(JSC::VM& vm)
        : m_vm(vm)
        WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(INITIALIZE_BUILTIN_NAMES)
#define INITIALIZE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) , m_##name##Source(JSC::makeSource(StringImpl::createFromLiteral(s_##name, length), { }))
        WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(INITIALIZE_BUILTIN_SOURCE_MEMBERS)
#undef INITIALIZE_BUILTIN_SOURCE_MEMBERS
    {
    }

#define EXPOSE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
    JSC::UnlinkedFunctionExecutable* name##Executable(); \
    const JSC::SourceCode& name##Source() const { return m_##name##Source; }
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(EXPOSE_BUILTIN_EXECUTABLES)
#undef EXPOSE_BUILTIN_EXECUTABLES

    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_IDENTIFIER_ACCESSOR)

    void exportNames();

private:
    JSC::VM& m_vm;

    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_NAMES)

#define DECLARE_BUILTIN_SOURCE_MEMBERS(name, functionName, overriddenName, length) \
    JSC::SourceCode m_##name##Source;\
    JSC::Weak<JSC::UnlinkedFunctionExecutable> m_##name##Executable;
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS

};

#define DEFINE_BUILTIN_EXECUTABLES(name, functionName, overriddenName, length) \
inline JSC::UnlinkedFunctionExecutable* WritableStreamInternalsBuiltinsWrapper::name##Executable() \
{\
    if (!m_##name##Executable) {\
        JSC::Identifier executableName = functionName##PublicName();\
        if (overriddenName)\
            executableName = JSC::Identifier::fromString(m_vm, overriddenName);\
        m_##name##Executable = JSC::Weak<JSC::UnlinkedFunctionExecutable>(JSC::createBuiltinExecutable(m_vm, m_##name##Source, executableName, s_##name##ConstructorKind, s_##name##ConstructAbility), this, &m_##name##Executable);\
    }\
    return m_##name##Executable.get();\
}
WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_EXECUTABLES)
#undef DEFINE_BUILTIN_EXECUTABLES

inline void WritableStreamInternalsBuiltinsWrapper::exportNames()
{
#define EXPORT_FUNCTION_NAME(name) m_vm.propertyNames->appendExternalName(name##PublicName(), name##PrivateName());
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(EXPORT_FUNCTION_NAME)
#undef EXPORT_FUNCTION_NAME
}

class WritableStreamInternalsBuiltinFunctions {
public:
    explicit WritableStreamInternalsBuiltinFunctions(JSC::VM& vm) : m_vm(vm) { }

    void init(JSC::JSGlobalObject&);
    void visit(JSC::SlotVisitor&);

public:
    JSC::VM& m_vm;

#define DECLARE_BUILTIN_SOURCE_MEMBERS(functionName) \
    JSC::WriteBarrier<JSC::JSFunction> m_##functionName##Function;
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_BUILTIN_SOURCE_MEMBERS)
#undef DECLARE_BUILTIN_SOURCE_MEMBERS
};

inline void WritableStreamInternalsBuiltinFunctions::init(JSC::JSGlobalObject& globalObject)
{
#define EXPORT_FUNCTION(codeName, functionName, overriddenName, length)\
    m_##functionName##Function.set(m_vm, &globalObject, JSC::JSFunction::create(m_vm, codeName##Generator(m_vm), &globalObject));
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(EXPORT_FUNCTION)
#undef EXPORT_FUNCTION
}

inline void WritableStreamInternalsBuiltinFunctions::visit(JSC::SlotVisitor& visitor)
{
#define VISIT_FUNCTION(name) visitor.append(m_##name##Function);
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(VISIT_FUNCTION)
#undef VISIT_FUNCTION
}


} // namespace WebCore
