/*
 * THIS FILE WAS AUTOMATICALLY GENERATED, DO NOT EDIT.
 *
 * Copyright (C) 2017-2020 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "SettingsBase.h"
#include <wtf/RefCounted.h>

namespace WebCore {

class Page;

class Settings : public SettingsBase, public RefCounted<Settings> {
    WTF_MAKE_NONCOPYABLE(Settings); WTF_MAKE_FAST_ALLOCATED;
public:
    WEBCORE_EXPORT static Ref<Settings> create(Page*);
    WEBCORE_EXPORT virtual ~Settings();

    bool CSSOMViewScrollingAPIEnabled() const { return m_values.CSSOMViewScrollingAPIEnabled; }
    void setCSSOMViewScrollingAPIEnabled(bool CSSOMViewScrollingAPIEnabled) { m_values.CSSOMViewScrollingAPIEnabled = CSSOMViewScrollingAPIEnabled; }
    bool CSSOMViewSmoothScrollingEnabled() const { return m_values.CSSOMViewSmoothScrollingEnabled; }
    void setCSSOMViewSmoothScrollingEnabled(bool CSSOMViewSmoothScrollingEnabled) { m_values.CSSOMViewSmoothScrollingEnabled = CSSOMViewSmoothScrollingEnabled; }
    bool acceleratedCompositedAnimationsEnabled() const { return m_values.acceleratedCompositedAnimationsEnabled; }
    WEBCORE_EXPORT void setAcceleratedCompositedAnimationsEnabled(bool);
    bool acceleratedCompositingEnabled() const { return m_values.acceleratedCompositingEnabled; }
    WEBCORE_EXPORT void setAcceleratedCompositingEnabled(bool);
    bool acceleratedCompositingForFixedPositionEnabled() const { return m_values.acceleratedCompositingForFixedPositionEnabled; }
    void setAcceleratedCompositingForFixedPositionEnabled(bool acceleratedCompositingForFixedPositionEnabled) { m_values.acceleratedCompositingForFixedPositionEnabled = acceleratedCompositingForFixedPositionEnabled; }
    bool acceleratedDrawingEnabled() const { return m_values.acceleratedDrawingEnabled; }
    void setAcceleratedDrawingEnabled(bool acceleratedDrawingEnabled) { m_values.acceleratedDrawingEnabled = acceleratedDrawingEnabled; }
    bool acceleratedFiltersEnabled() const { return m_values.acceleratedFiltersEnabled; }
    void setAcceleratedFiltersEnabled(bool acceleratedFiltersEnabled) { m_values.acceleratedFiltersEnabled = acceleratedFiltersEnabled; }
    bool aggressiveTileRetentionEnabled() const { return m_values.aggressiveTileRetentionEnabled; }
    void setAggressiveTileRetentionEnabled(bool aggressiveTileRetentionEnabled) { m_values.aggressiveTileRetentionEnabled = aggressiveTileRetentionEnabled; }
    bool allowContentSecurityPolicySourceStarToMatchAnyProtocol() const { return m_values.allowContentSecurityPolicySourceStarToMatchAnyProtocol; }
    void setAllowContentSecurityPolicySourceStarToMatchAnyProtocol(bool allowContentSecurityPolicySourceStarToMatchAnyProtocol) { m_values.allowContentSecurityPolicySourceStarToMatchAnyProtocol = allowContentSecurityPolicySourceStarToMatchAnyProtocol; }
    bool allowCrossOriginSubresourcesToAskForCredentials() const { return m_values.allowCrossOriginSubresourcesToAskForCredentials; }
    void setAllowCrossOriginSubresourcesToAskForCredentials(bool allowCrossOriginSubresourcesToAskForCredentials) { m_values.allowCrossOriginSubresourcesToAskForCredentials = allowCrossOriginSubresourcesToAskForCredentials; }
    bool allowDisplayOfInsecureContent() const { return m_values.allowDisplayOfInsecureContent; }
    void setAllowDisplayOfInsecureContent(bool allowDisplayOfInsecureContent) { m_values.allowDisplayOfInsecureContent = allowDisplayOfInsecureContent; }
    bool allowFileAccessFromFileURLs() const { return m_values.allowFileAccessFromFileURLs; }
    void setAllowFileAccessFromFileURLs(bool allowFileAccessFromFileURLs) { m_values.allowFileAccessFromFileURLs = allowFileAccessFromFileURLs; }
    bool allowMediaContentTypesRequiringHardwareSupportAsFallback() const { return m_values.allowMediaContentTypesRequiringHardwareSupportAsFallback; }
    void setAllowMediaContentTypesRequiringHardwareSupportAsFallback(bool allowMediaContentTypesRequiringHardwareSupportAsFallback) { m_values.allowMediaContentTypesRequiringHardwareSupportAsFallback = allowMediaContentTypesRequiringHardwareSupportAsFallback; }
    bool allowMultiElementImplicitSubmission() const { return m_values.allowMultiElementImplicitSubmission; }
    void setAllowMultiElementImplicitSubmission(bool allowMultiElementImplicitSubmission) { m_values.allowMultiElementImplicitSubmission = allowMultiElementImplicitSubmission; }
    bool allowRunningOfInsecureContent() const { return m_values.allowRunningOfInsecureContent; }
    void setAllowRunningOfInsecureContent(bool allowRunningOfInsecureContent) { m_values.allowRunningOfInsecureContent = allowRunningOfInsecureContent; }
    bool allowSettingAnyXHRHeaderFromFileURLs() const { return m_values.allowSettingAnyXHRHeaderFromFileURLs; }
    void setAllowSettingAnyXHRHeaderFromFileURLs(bool allowSettingAnyXHRHeaderFromFileURLs) { m_values.allowSettingAnyXHRHeaderFromFileURLs = allowSettingAnyXHRHeaderFromFileURLs; }
    bool allowTopNavigationToDataURLs() const { return m_values.allowTopNavigationToDataURLs; }
    void setAllowTopNavigationToDataURLs(bool allowTopNavigationToDataURLs) { m_values.allowTopNavigationToDataURLs = allowTopNavigationToDataURLs; }
    bool allowUniversalAccessFromFileURLs() const { return m_values.allowUniversalAccessFromFileURLs; }
    void setAllowUniversalAccessFromFileURLs(bool allowUniversalAccessFromFileURLs) { m_values.allowUniversalAccessFromFileURLs = allowUniversalAccessFromFileURLs; }
    bool allowsInlineMediaPlayback() const { return m_values.allowsInlineMediaPlayback; }
    void setAllowsInlineMediaPlayback(bool allowsInlineMediaPlayback) { m_values.allowsInlineMediaPlayback = allowsInlineMediaPlayback; }
    bool allowsInlineMediaPlaybackAfterFullscreen() const { return m_values.allowsInlineMediaPlaybackAfterFullscreen; }
    void setAllowsInlineMediaPlaybackAfterFullscreen(bool allowsInlineMediaPlaybackAfterFullscreen) { m_values.allowsInlineMediaPlaybackAfterFullscreen = allowsInlineMediaPlaybackAfterFullscreen; }
    bool allowsPictureInPictureMediaPlayback() const { return m_values.allowsPictureInPictureMediaPlayback; }
    void setAllowsPictureInPictureMediaPlayback(bool allowsPictureInPictureMediaPlayback) { m_values.allowsPictureInPictureMediaPlayback = allowsPictureInPictureMediaPlayback; }
    bool alwaysUseAcceleratedOverflowScroll() const { return m_values.alwaysUseAcceleratedOverflowScroll; }
    void setAlwaysUseAcceleratedOverflowScroll(bool alwaysUseAcceleratedOverflowScroll) { m_values.alwaysUseAcceleratedOverflowScroll = alwaysUseAcceleratedOverflowScroll; }
    bool animatedImageAsyncDecodingEnabled() const { return m_values.animatedImageAsyncDecodingEnabled; }
    void setAnimatedImageAsyncDecodingEnabled(bool animatedImageAsyncDecodingEnabled) { m_values.animatedImageAsyncDecodingEnabled = animatedImageAsyncDecodingEnabled; }
    bool animatedImageDebugCanvasDrawingEnabled() const { return m_values.animatedImageDebugCanvasDrawingEnabled; }
    void setAnimatedImageDebugCanvasDrawingEnabled(bool animatedImageDebugCanvasDrawingEnabled) { m_values.animatedImageDebugCanvasDrawingEnabled = animatedImageDebugCanvasDrawingEnabled; }
    bool appleMailPaginationQuirkEnabled() const { return m_values.appleMailPaginationQuirkEnabled; }
    void setAppleMailPaginationQuirkEnabled(bool appleMailPaginationQuirkEnabled) { m_values.appleMailPaginationQuirkEnabled = appleMailPaginationQuirkEnabled; }
    bool aspectRatioEnabled() const { return m_values.aspectRatioEnabled; }
    void setAspectRatioEnabled(bool aspectRatioEnabled) { m_values.aspectRatioEnabled = aspectRatioEnabled; }
    bool aspectRatioOfImgFromWidthAndHeightEnabled() const { return m_values.aspectRatioOfImgFromWidthAndHeightEnabled; }
    void setAspectRatioOfImgFromWidthAndHeightEnabled(bool aspectRatioOfImgFromWidthAndHeightEnabled) { m_values.aspectRatioOfImgFromWidthAndHeightEnabled = aspectRatioOfImgFromWidthAndHeightEnabled; }
    bool asyncClipboardAPIEnabled() const { return m_values.asyncClipboardAPIEnabled; }
    void setAsyncClipboardAPIEnabled(bool asyncClipboardAPIEnabled) { m_values.asyncClipboardAPIEnabled = asyncClipboardAPIEnabled; }
    bool asyncFrameScrollingEnabled() const { return m_values.asyncFrameScrollingEnabled; }
    WEBCORE_EXPORT void setAsyncFrameScrollingEnabled(bool);
    bool asyncOverflowScrollingEnabled() const { return m_values.asyncOverflowScrollingEnabled; }
    WEBCORE_EXPORT void setAsyncOverflowScrollingEnabled(bool);
    bool asynchronousSpellCheckingEnabled() const { return m_values.asynchronousSpellCheckingEnabled; }
    void setAsynchronousSpellCheckingEnabled(bool asynchronousSpellCheckingEnabled) { m_values.asynchronousSpellCheckingEnabled = asynchronousSpellCheckingEnabled; }
    bool audioPlaybackRequiresUserGesture() const { return m_values.audioPlaybackRequiresUserGesture; }
    void setAudioPlaybackRequiresUserGesture(bool audioPlaybackRequiresUserGesture) { m_values.audioPlaybackRequiresUserGesture = audioPlaybackRequiresUserGesture; }
    WEBCORE_EXPORT bool authorAndUserStylesEnabled() const;
    WEBCORE_EXPORT void setAuthorAndUserStylesEnabled(bool);
    bool autoscrollForDragAndDropEnabled() const { return m_values.autoscrollForDragAndDropEnabled; }
    void setAutoscrollForDragAndDropEnabled(bool autoscrollForDragAndDropEnabled) { m_values.autoscrollForDragAndDropEnabled = autoscrollForDragAndDropEnabled; }
    Seconds backForwardCacheExpirationInterval() const { return m_values.backForwardCacheExpirationInterval; }
    void setBackForwardCacheExpirationInterval(Seconds backForwardCacheExpirationInterval) { m_values.backForwardCacheExpirationInterval = backForwardCacheExpirationInterval; }
    bool backForwardCacheSupportsPlugins() const { return m_values.backForwardCacheSupportsPlugins; }
    void setBackForwardCacheSupportsPlugins(bool backForwardCacheSupportsPlugins) { m_values.backForwardCacheSupportsPlugins = backForwardCacheSupportsPlugins; }
    bool backgroundShouldExtendBeyondPage() const { return m_values.backgroundShouldExtendBeyondPage; }
    WEBCORE_EXPORT void setBackgroundShouldExtendBeyondPage(bool);
    bool backspaceKeyNavigationEnabled() const { return m_values.backspaceKeyNavigationEnabled; }
    void setBackspaceKeyNavigationEnabled(bool backspaceKeyNavigationEnabled) { m_values.backspaceKeyNavigationEnabled = backspaceKeyNavigationEnabled; }
    bool beaconAPIEnabled() const { return m_values.beaconAPIEnabled; }
    void setBeaconAPIEnabled(bool beaconAPIEnabled) { m_values.beaconAPIEnabled = beaconAPIEnabled; }
    bool blankAnchorTargetImpliesNoOpenerEnabled() const { return m_values.blankAnchorTargetImpliesNoOpenerEnabled; }
    void setBlankAnchorTargetImpliesNoOpenerEnabled(bool blankAnchorTargetImpliesNoOpenerEnabled) { m_values.blankAnchorTargetImpliesNoOpenerEnabled = blankAnchorTargetImpliesNoOpenerEnabled; }
    bool canvasUsesAcceleratedDrawing() const { return m_values.canvasUsesAcceleratedDrawing; }
    void setCanvasUsesAcceleratedDrawing(bool canvasUsesAcceleratedDrawing) { m_values.canvasUsesAcceleratedDrawing = canvasUsesAcceleratedDrawing; }
    bool caretBrowsingEnabled() const { return m_values.caretBrowsingEnabled; }
    void setCaretBrowsingEnabled(bool caretBrowsingEnabled) { m_values.caretBrowsingEnabled = caretBrowsingEnabled; }
    bool clientCoordinatesRelativeToLayoutViewport() const { return m_values.clientCoordinatesRelativeToLayoutViewport; }
    WEBCORE_EXPORT void setClientCoordinatesRelativeToLayoutViewport(bool);
    ClipboardAccessPolicy clipboardAccessPolicy() const { return m_values.clipboardAccessPolicy; }
    void setClipboardAccessPolicy(ClipboardAccessPolicy clipboardAccessPolicy) { m_values.clipboardAccessPolicy = clipboardAccessPolicy; }
    bool colorFilterEnabled() const { return m_values.colorFilterEnabled; }
    WEBCORE_EXPORT void setColorFilterEnabled(bool);
    bool constantPropertiesEnabled() const { return m_values.constantPropertiesEnabled; }
    void setConstantPropertiesEnabled(bool constantPropertiesEnabled) { m_values.constantPropertiesEnabled = constantPropertiesEnabled; }
    bool contactPickerAPIEnabled() const { return m_values.contactPickerAPIEnabled; }
    void setContactPickerAPIEnabled(bool contactPickerAPIEnabled) { m_values.contactPickerAPIEnabled = contactPickerAPIEnabled; }
    bool contentDispositionAttachmentSandboxEnabled() const { return m_values.contentDispositionAttachmentSandboxEnabled; }
    void setContentDispositionAttachmentSandboxEnabled(bool contentDispositionAttachmentSandboxEnabled) { m_values.contentDispositionAttachmentSandboxEnabled = contentDispositionAttachmentSandboxEnabled; }
    bool cookieEnabled() const { return m_values.cookieEnabled; }
    void setCookieEnabled(bool cookieEnabled) { m_values.cookieEnabled = cookieEnabled; }
    bool coreMathMLEnabled() const { return m_values.coreMathMLEnabled; }
    WEBCORE_EXPORT void setCoreMathMLEnabled(bool);
    bool crossOriginCheckInGetMatchedCSSRulesDisabled() const { return m_values.crossOriginCheckInGetMatchedCSSRulesDisabled; }
    void setCrossOriginCheckInGetMatchedCSSRulesDisabled(bool crossOriginCheckInGetMatchedCSSRulesDisabled) { m_values.crossOriginCheckInGetMatchedCSSRulesDisabled = crossOriginCheckInGetMatchedCSSRulesDisabled; }
    bool cssColor4() const { return m_values.cssColor4; }
    void setCSSColor4(bool cssColor4) { m_values.cssColor4 = cssColor4; }
    bool cssColorContrastEnabled() const { return m_values.cssColorContrastEnabled; }
    void setCSSColorContrastEnabled(bool cssColorContrastEnabled) { m_values.cssColorContrastEnabled = cssColorContrastEnabled; }
    bool cssColorMixEnabled() const { return m_values.cssColorMixEnabled; }
    void setCSSColorMixEnabled(bool cssColorMixEnabled) { m_values.cssColorMixEnabled = cssColorMixEnabled; }
    bool cssContainmentEnabled() const { return m_values.cssContainmentEnabled; }
    void setCSSContainmentEnabled(bool cssContainmentEnabled) { m_values.cssContainmentEnabled = cssContainmentEnabled; }
    bool cssCustomPropertiesAndValuesEnabled() const { return m_values.cssCustomPropertiesAndValuesEnabled; }
    void setCSSCustomPropertiesAndValuesEnabled(bool cssCustomPropertiesAndValuesEnabled) { m_values.cssCustomPropertiesAndValuesEnabled = cssCustomPropertiesAndValuesEnabled; }
    bool cssIndividualTransformPropertiesEnabled() const { return m_values.cssIndividualTransformPropertiesEnabled; }
    void setCSSIndividualTransformPropertiesEnabled(bool cssIndividualTransformPropertiesEnabled) { m_values.cssIndividualTransformPropertiesEnabled = cssIndividualTransformPropertiesEnabled; }
    bool cssRelativeColorSyntaxEnabled() const { return m_values.cssRelativeColorSyntaxEnabled; }
    void setCSSRelativeColorSyntaxEnabled(bool cssRelativeColorSyntaxEnabled) { m_values.cssRelativeColorSyntaxEnabled = cssRelativeColorSyntaxEnabled; }
    bool dataTransferItemsEnabled() const { return m_values.dataTransferItemsEnabled; }
    void setDataTransferItemsEnabled(bool dataTransferItemsEnabled) { m_values.dataTransferItemsEnabled = dataTransferItemsEnabled; }
    double defaultFixedFontSize() const { return m_values.defaultFixedFontSize; }
    WEBCORE_EXPORT void setDefaultFixedFontSize(double);
    double defaultFontSize() const { return m_values.defaultFontSize; }
    WEBCORE_EXPORT void setDefaultFontSize(double);
    const String& defaultTextEncodingName() const { return m_values.defaultTextEncodingName; }
    void setDefaultTextEncodingName(const String& defaultTextEncodingName) { m_values.defaultTextEncodingName = defaultTextEncodingName; }
    const String& defaultVideoPosterURL() const { return m_values.defaultVideoPosterURL; }
    void setDefaultVideoPosterURL(const String& defaultVideoPosterURL) { m_values.defaultVideoPosterURL = defaultVideoPosterURL; }
    bool deferredCSSParserEnabled() const { return m_values.deferredCSSParserEnabled; }
    void setDeferredCSSParserEnabled(bool deferredCSSParserEnabled) { m_values.deferredCSSParserEnabled = deferredCSSParserEnabled; }
    bool developerExtrasEnabled() const { return m_values.developerExtrasEnabled; }
    void setDeveloperExtrasEnabled(bool developerExtrasEnabled) { m_values.developerExtrasEnabled = developerExtrasEnabled; }
    uint32_t deviceHeight() const { return m_values.deviceHeight; }
    void setDeviceHeight(uint32_t deviceHeight) { m_values.deviceHeight = deviceHeight; }
    uint32_t deviceWidth() const { return m_values.deviceWidth; }
    void setDeviceWidth(uint32_t deviceWidth) { m_values.deviceWidth = deviceWidth; }
    bool diagnosticLoggingEnabled() const { return m_values.diagnosticLoggingEnabled; }
    void setDiagnosticLoggingEnabled(bool diagnosticLoggingEnabled) { m_values.diagnosticLoggingEnabled = diagnosticLoggingEnabled; }
    bool disableScreenSizeOverride() const { return m_values.disableScreenSizeOverride; }
    void setDisableScreenSizeOverride(bool disableScreenSizeOverride) { m_values.disableScreenSizeOverride = disableScreenSizeOverride; }
    bool disabledAdaptationsMetaTagEnabled() const { return m_values.disabledAdaptationsMetaTagEnabled; }
    void setDisabledAdaptationsMetaTagEnabled(bool disabledAdaptationsMetaTagEnabled) { m_values.disabledAdaptationsMetaTagEnabled = disabledAdaptationsMetaTagEnabled; }
    bool disallowSyncXHRDuringPageDismissalEnabled() const { return m_values.disallowSyncXHRDuringPageDismissalEnabled; }
    void setDisallowSyncXHRDuringPageDismissalEnabled(bool disallowSyncXHRDuringPageDismissalEnabled) { m_values.disallowSyncXHRDuringPageDismissalEnabled = disallowSyncXHRDuringPageDismissalEnabled; }
    bool displayListDrawingEnabled() const { return m_values.displayListDrawingEnabled; }
    void setDisplayListDrawingEnabled(bool displayListDrawingEnabled) { m_values.displayListDrawingEnabled = displayListDrawingEnabled; }
    bool dnsPrefetchingEnabled() const { return m_values.dnsPrefetchingEnabled; }
    WEBCORE_EXPORT void setDNSPrefetchingEnabled(bool);
    bool domPasteAccessRequestsEnabled() const { return m_values.domPasteAccessRequestsEnabled; }
    void setDOMPasteAccessRequestsEnabled(bool domPasteAccessRequestsEnabled) { m_values.domPasteAccessRequestsEnabled = domPasteAccessRequestsEnabled; }
    bool domPasteAllowed() const { return m_values.domPasteAllowed; }
    void setDOMPasteAllowed(bool domPasteAllowed) { m_values.domPasteAllowed = domPasteAllowed; }
    bool domTimersThrottlingEnabled() const { return m_values.domTimersThrottlingEnabled; }
    void setDOMTimersThrottlingEnabled(bool domTimersThrottlingEnabled) { m_values.domTimersThrottlingEnabled = domTimersThrottlingEnabled; }
    bool downloadableBinaryFontsEnabled() const { return m_values.downloadableBinaryFontsEnabled; }
    void setDownloadableBinaryFontsEnabled(bool downloadableBinaryFontsEnabled) { m_values.downloadableBinaryFontsEnabled = downloadableBinaryFontsEnabled; }
    EditableLinkBehavior editableLinkBehavior() const { return m_values.editableLinkBehavior; }
    void setEditableLinkBehavior(EditableLinkBehavior editableLinkBehavior) { m_values.editableLinkBehavior = editableLinkBehavior; }
    EditingBehaviorType editingBehaviorType() const { return m_values.editingBehaviorType; }
    void setEditingBehaviorType(EditingBehaviorType editingBehaviorType) { m_values.editingBehaviorType = editingBehaviorType; }
    bool enableInheritURIQueryComponent() const { return m_values.enableInheritURIQueryComponent; }
    void setEnableInheritURIQueryComponent(bool enableInheritURIQueryComponent) { m_values.enableInheritURIQueryComponent = enableInheritURIQueryComponent; }
    bool enterKeyHintEnabled() const { return m_values.enterKeyHintEnabled; }
    void setEnterKeyHintEnabled(bool enterKeyHintEnabled) { m_values.enterKeyHintEnabled = enterKeyHintEnabled; }
    bool fixedBackgroundsPaintRelativeToDocument() const { return m_values.fixedBackgroundsPaintRelativeToDocument; }
    void setFixedBackgroundsPaintRelativeToDocument(bool fixedBackgroundsPaintRelativeToDocument) { m_values.fixedBackgroundsPaintRelativeToDocument = fixedBackgroundsPaintRelativeToDocument; }
    bool fixedElementsLayoutRelativeToFrame() const { return m_values.fixedElementsLayoutRelativeToFrame; }
    void setFixedElementsLayoutRelativeToFrame(bool fixedElementsLayoutRelativeToFrame) { m_values.fixedElementsLayoutRelativeToFrame = fixedElementsLayoutRelativeToFrame; }
    bool focusVisibleEnabled() const { return m_values.focusVisibleEnabled; }
    void setFocusVisibleEnabled(bool focusVisibleEnabled) { m_values.focusVisibleEnabled = focusVisibleEnabled; }
    bool fontFallbackPrefersPictographs() const { return m_values.fontFallbackPrefersPictographs; }
    WEBCORE_EXPORT void setFontFallbackPrefersPictographs(bool);
    FontLoadTimingOverride fontLoadTimingOverride() const { return m_values.fontLoadTimingOverride; }
    void setFontLoadTimingOverride(FontLoadTimingOverride fontLoadTimingOverride) { m_values.fontLoadTimingOverride = fontLoadTimingOverride; }
    FontRenderingMode fontRenderingMode() const { return m_values.fontRenderingMode; }
    void setFontRenderingMode(FontRenderingMode fontRenderingMode) { m_values.fontRenderingMode = fontRenderingMode; }
    bool forceCompositingMode() const { return m_values.forceCompositingMode; }
    void setForceCompositingMode(bool forceCompositingMode) { m_values.forceCompositingMode = forceCompositingMode; }
    bool forceFTPDirectoryListings() const { return m_values.forceFTPDirectoryListings; }
    void setForceFTPDirectoryListings(bool forceFTPDirectoryListings) { m_values.forceFTPDirectoryListings = forceFTPDirectoryListings; }
    bool isForcePendingWebGLPolicy() const { return m_values.forcePendingWebGLPolicy; }
    void setForcePendingWebGLPolicy(bool forcePendingWebGLPolicy) { m_values.forcePendingWebGLPolicy = forcePendingWebGLPolicy; }
    bool forceWebGLUsesLowPower() const { return m_values.forceWebGLUsesLowPower; }
    void setForceWebGLUsesLowPower(bool forceWebGLUsesLowPower) { m_values.forceWebGLUsesLowPower = forceWebGLUsesLowPower; }
    ForcedAccessibilityValue forcedColorsAreInvertedAccessibilityValue() const { return m_values.forcedColorsAreInvertedAccessibilityValue; }
    void setForcedColorsAreInvertedAccessibilityValue(ForcedAccessibilityValue forcedColorsAreInvertedAccessibilityValue) { m_values.forcedColorsAreInvertedAccessibilityValue = forcedColorsAreInvertedAccessibilityValue; }
    ForcedAccessibilityValue forcedDisplayIsMonochromeAccessibilityValue() const { return m_values.forcedDisplayIsMonochromeAccessibilityValue; }
    void setForcedDisplayIsMonochromeAccessibilityValue(ForcedAccessibilityValue forcedDisplayIsMonochromeAccessibilityValue) { m_values.forcedDisplayIsMonochromeAccessibilityValue = forcedDisplayIsMonochromeAccessibilityValue; }
    ForcedAccessibilityValue forcedPrefersContrastAccessibilityValue() const { return m_values.forcedPrefersContrastAccessibilityValue; }
    void setForcedPrefersContrastAccessibilityValue(ForcedAccessibilityValue forcedPrefersContrastAccessibilityValue) { m_values.forcedPrefersContrastAccessibilityValue = forcedPrefersContrastAccessibilityValue; }
    ForcedAccessibilityValue forcedPrefersReducedMotionAccessibilityValue() const { return m_values.forcedPrefersReducedMotionAccessibilityValue; }
    void setForcedPrefersReducedMotionAccessibilityValue(ForcedAccessibilityValue forcedPrefersReducedMotionAccessibilityValue) { m_values.forcedPrefersReducedMotionAccessibilityValue = forcedPrefersReducedMotionAccessibilityValue; }
    ForcedAccessibilityValue forcedSupportsHighDynamicRangeValue() const { return m_values.forcedSupportsHighDynamicRangeValue; }
    WEBCORE_EXPORT void setForcedSupportsHighDynamicRangeValue(ForcedAccessibilityValue);
    FrameFlattening frameFlattening() const { return m_values.frameFlattening; }
    WEBCORE_EXPORT void setFrameFlattening(FrameFlattening);
    const String& ftpDirectoryTemplatePath() const { return m_values.ftpDirectoryTemplatePath; }
    void setFTPDirectoryTemplatePath(const String& ftpDirectoryTemplatePath) { m_values.ftpDirectoryTemplatePath = ftpDirectoryTemplatePath; }
    bool geolocationFloorLevelEnabled() const { return m_values.geolocationFloorLevelEnabled; }
    void setGeolocationFloorLevelEnabled(bool geolocationFloorLevelEnabled) { m_values.geolocationFloorLevelEnabled = geolocationFloorLevelEnabled; }
    bool googleAntiFlickerOptimizationQuirkEnabled() const { return m_values.googleAntiFlickerOptimizationQuirkEnabled; }
    void setGoogleAntiFlickerOptimizationQuirkEnabled(bool googleAntiFlickerOptimizationQuirkEnabled) { m_values.googleAntiFlickerOptimizationQuirkEnabled = googleAntiFlickerOptimizationQuirkEnabled; }
    bool hdrMediaCapabilitiesEnabled() const { return m_values.hdrMediaCapabilitiesEnabled; }
    void setHDRMediaCapabilitiesEnabled(bool hdrMediaCapabilitiesEnabled) { m_values.hdrMediaCapabilitiesEnabled = hdrMediaCapabilitiesEnabled; }
    bool hiddenPageCSSAnimationSuspensionEnabled() const { return m_values.hiddenPageCSSAnimationSuspensionEnabled; }
    WEBCORE_EXPORT void setHiddenPageCSSAnimationSuspensionEnabled(bool);
    bool hiddenPageDOMTimerThrottlingAutoIncreases() const { return m_values.hiddenPageDOMTimerThrottlingAutoIncreases; }
    WEBCORE_EXPORT void setHiddenPageDOMTimerThrottlingAutoIncreases(bool);
    bool hiddenPageDOMTimerThrottlingEnabled() const { return m_values.hiddenPageDOMTimerThrottlingEnabled; }
    WEBCORE_EXPORT void setHiddenPageDOMTimerThrottlingEnabled(bool);
    HTMLParserScriptingFlagPolicy htmlParserScriptingFlagPolicy() const { return m_values.htmlParserScriptingFlagPolicy; }
    void setHTMLParserScriptingFlagPolicy(HTMLParserScriptingFlagPolicy htmlParserScriptingFlagPolicy) { m_values.htmlParserScriptingFlagPolicy = htmlParserScriptingFlagPolicy; }
    bool httpEquivEnabled() const { return m_values.httpEquivEnabled; }
    void setHttpEquivEnabled(bool httpEquivEnabled) { m_values.httpEquivEnabled = httpEquivEnabled; }
    bool hyperlinkAuditingEnabled() const { return m_values.hyperlinkAuditingEnabled; }
    void setHyperlinkAuditingEnabled(bool hyperlinkAuditingEnabled) { m_values.hyperlinkAuditingEnabled = hyperlinkAuditingEnabled; }
    WEBCORE_EXPORT bool iceCandidateFilteringEnabled() const;
    WEBCORE_EXPORT void setICECandidateFilteringEnabled(bool);
    bool imageSubsamplingEnabled() const { return m_values.imageSubsamplingEnabled; }
    void setImageSubsamplingEnabled(bool imageSubsamplingEnabled) { m_values.imageSubsamplingEnabled = imageSubsamplingEnabled; }
    WEBCORE_EXPORT bool areImagesEnabled() const;
    WEBCORE_EXPORT void setImagesEnabled(bool);
    bool inProcessCookieCacheEnabled() const { return m_values.inProcessCookieCacheEnabled; }
    void setInProcessCookieCacheEnabled(bool inProcessCookieCacheEnabled) { m_values.inProcessCookieCacheEnabled = inProcessCookieCacheEnabled; }
    bool incompleteImageBorderEnabled() const { return m_values.incompleteImageBorderEnabled; }
    void setIncompleteImageBorderEnabled(bool incompleteImageBorderEnabled) { m_values.incompleteImageBorderEnabled = incompleteImageBorderEnabled; }
    double incrementalRenderingSuppressionTimeoutInSeconds() const { return m_values.incrementalRenderingSuppressionTimeoutInSeconds; }
    void setIncrementalRenderingSuppressionTimeoutInSeconds(double incrementalRenderingSuppressionTimeoutInSeconds) { m_values.incrementalRenderingSuppressionTimeoutInSeconds = incrementalRenderingSuppressionTimeoutInSeconds; }
    bool inlineMediaPlaybackRequiresPlaysInlineAttribute() const { return m_values.inlineMediaPlaybackRequiresPlaysInlineAttribute; }
    void setInlineMediaPlaybackRequiresPlaysInlineAttribute(bool inlineMediaPlaybackRequiresPlaysInlineAttribute) { m_values.inlineMediaPlaybackRequiresPlaysInlineAttribute = inlineMediaPlaybackRequiresPlaysInlineAttribute; }
    bool inputEventsEnabled() const { return m_values.inputEventsEnabled; }
    void setInputEventsEnabled(bool inputEventsEnabled) { m_values.inputEventsEnabled = inputEventsEnabled; }
    bool interactiveFormValidationEnabled() const { return m_values.interactiveFormValidationEnabled; }
    void setInteractiveFormValidationEnabled(bool interactiveFormValidationEnabled) { m_values.interactiveFormValidationEnabled = interactiveFormValidationEnabled; }
    bool invisibleAutoplayNotPermitted() const { return m_values.invisibleAutoplayNotPermitted; }
    void setInvisibleAutoplayNotPermitted(bool invisibleAutoplayNotPermitted) { m_values.invisibleAutoplayNotPermitted = invisibleAutoplayNotPermitted; }
    bool isAccessibilityIsolatedTreeEnabled() const { return m_values.isAccessibilityIsolatedTreeEnabled; }
    void setIsAccessibilityIsolatedTreeEnabled(bool isAccessibilityIsolatedTreeEnabled) { m_values.isAccessibilityIsolatedTreeEnabled = isAccessibilityIsolatedTreeEnabled; }
    bool isFirstPartyWebsiteDataRemovalDisabled() const { return m_values.isFirstPartyWebsiteDataRemovalDisabled; }
    void setIsFirstPartyWebsiteDataRemovalDisabled(bool isFirstPartyWebsiteDataRemovalDisabled) { m_values.isFirstPartyWebsiteDataRemovalDisabled = isFirstPartyWebsiteDataRemovalDisabled; }
    bool isFirstPartyWebsiteDataRemovalLiveOnTestingEnabled() const { return m_values.isFirstPartyWebsiteDataRemovalLiveOnTestingEnabled; }
    void setIsFirstPartyWebsiteDataRemovalLiveOnTestingEnabled(bool isFirstPartyWebsiteDataRemovalLiveOnTestingEnabled) { m_values.isFirstPartyWebsiteDataRemovalLiveOnTestingEnabled = isFirstPartyWebsiteDataRemovalLiveOnTestingEnabled; }
    bool isFirstPartyWebsiteDataRemovalReproTestingEnabled() const { return m_values.isFirstPartyWebsiteDataRemovalReproTestingEnabled; }
    void setIsFirstPartyWebsiteDataRemovalReproTestingEnabled(bool isFirstPartyWebsiteDataRemovalReproTestingEnabled) { m_values.isFirstPartyWebsiteDataRemovalReproTestingEnabled = isFirstPartyWebsiteDataRemovalReproTestingEnabled; }
    bool isLoggedInAPIEnabled() const { return m_values.isLoggedInAPIEnabled; }
    void setIsLoggedInAPIEnabled(bool isLoggedInAPIEnabled) { m_values.isLoggedInAPIEnabled = isLoggedInAPIEnabled; }
    bool isPerActivityStateCPUUsageMeasurementEnabled() const { return m_values.isPerActivityStateCPUUsageMeasurementEnabled; }
    void setIsPerActivityStateCPUUsageMeasurementEnabled(bool isPerActivityStateCPUUsageMeasurementEnabled) { m_values.isPerActivityStateCPUUsageMeasurementEnabled = isPerActivityStateCPUUsageMeasurementEnabled; }
    bool isPostBackgroundingCPUUsageMeasurementEnabled() const { return m_values.isPostBackgroundingCPUUsageMeasurementEnabled; }
    void setIsPostBackgroundingCPUUsageMeasurementEnabled(bool isPostBackgroundingCPUUsageMeasurementEnabled) { m_values.isPostBackgroundingCPUUsageMeasurementEnabled = isPostBackgroundingCPUUsageMeasurementEnabled; }
    bool isPostBackgroundingMemoryUsageMeasurementEnabled() const { return m_values.isPostBackgroundingMemoryUsageMeasurementEnabled; }
    void setIsPostBackgroundingMemoryUsageMeasurementEnabled(bool isPostBackgroundingMemoryUsageMeasurementEnabled) { m_values.isPostBackgroundingMemoryUsageMeasurementEnabled = isPostBackgroundingMemoryUsageMeasurementEnabled; }
    bool isPostLoadCPUUsageMeasurementEnabled() const { return m_values.isPostLoadCPUUsageMeasurementEnabled; }
    void setIsPostLoadCPUUsageMeasurementEnabled(bool isPostLoadCPUUsageMeasurementEnabled) { m_values.isPostLoadCPUUsageMeasurementEnabled = isPostLoadCPUUsageMeasurementEnabled; }
    bool isPostLoadMemoryUsageMeasurementEnabled() const { return m_values.isPostLoadMemoryUsageMeasurementEnabled; }
    void setIsPostLoadMemoryUsageMeasurementEnabled(bool isPostLoadMemoryUsageMeasurementEnabled) { m_values.isPostLoadMemoryUsageMeasurementEnabled = isPostLoadMemoryUsageMeasurementEnabled; }
    bool isSameSiteStrictEnforcementEnabled() const { return m_values.isSameSiteStrictEnforcementEnabled; }
    void setIsSameSiteStrictEnforcementEnabled(bool isSameSiteStrictEnforcementEnabled) { m_values.isSameSiteStrictEnforcementEnabled = isSameSiteStrictEnforcementEnabled; }
    bool isThirdPartyCookieBlockingDisabled() const { return m_values.isThirdPartyCookieBlockingDisabled; }
    void setIsThirdPartyCookieBlockingDisabled(bool isThirdPartyCookieBlockingDisabled) { m_values.isThirdPartyCookieBlockingDisabled = isThirdPartyCookieBlockingDisabled; }
    bool isJavaEnabled() const { return m_values.javaEnabled; }
    void setJavaEnabled(bool javaEnabled) { m_values.javaEnabled = javaEnabled; }
    bool isJavaEnabledForLocalFiles() const { return m_values.javaEnabledForLocalFiles; }
    void setJavaEnabledForLocalFiles(bool javaEnabledForLocalFiles) { m_values.javaEnabledForLocalFiles = javaEnabledForLocalFiles; }
    bool javaScriptCanAccessClipboard() const { return m_values.javaScriptCanAccessClipboard; }
    void setJavaScriptCanAccessClipboard(bool javaScriptCanAccessClipboard) { m_values.javaScriptCanAccessClipboard = javaScriptCanAccessClipboard; }
    bool javaScriptCanOpenWindowsAutomatically() const { return m_values.javaScriptCanOpenWindowsAutomatically; }
    void setJavaScriptCanOpenWindowsAutomatically(bool javaScriptCanOpenWindowsAutomatically) { m_values.javaScriptCanOpenWindowsAutomatically = javaScriptCanOpenWindowsAutomatically; }
    JSC::RuntimeFlags javaScriptRuntimeFlags() const { return m_values.javaScriptRuntimeFlags; }
    void setJavaScriptRuntimeFlags(JSC::RuntimeFlags javaScriptRuntimeFlags) { m_values.javaScriptRuntimeFlags = javaScriptRuntimeFlags; }
    bool langAttributeAwareFormControlUIEnabled() const { return m_values.langAttributeAwareFormControlUIEnabled; }
    void setLangAttributeAwareFormControlUIEnabled(bool langAttributeAwareFormControlUIEnabled) { m_values.langAttributeAwareFormControlUIEnabled = langAttributeAwareFormControlUIEnabled; }
    bool largeImageAsyncDecodingEnabled() const { return m_values.largeImageAsyncDecodingEnabled; }
    void setLargeImageAsyncDecodingEnabled(bool largeImageAsyncDecodingEnabled) { m_values.largeImageAsyncDecodingEnabled = largeImageAsyncDecodingEnabled; }
    uint32_t layoutFallbackWidth() const { return m_values.layoutFallbackWidth; }
    void setLayoutFallbackWidth(uint32_t layoutFallbackWidth) { m_values.layoutFallbackWidth = layoutFallbackWidth; }
    double layoutViewportHeightExpansionFactor() const { return m_values.layoutViewportHeightExpansionFactor; }
    WEBCORE_EXPORT void setLayoutViewportHeightExpansionFactor(double);
    bool lazyIframeLoadingEnabled() const { return m_values.lazyIframeLoadingEnabled; }
    void setLazyIframeLoadingEnabled(bool lazyIframeLoadingEnabled) { m_values.lazyIframeLoadingEnabled = lazyIframeLoadingEnabled; }
    bool lazyImageLoadingEnabled() const { return m_values.lazyImageLoadingEnabled; }
    void setLazyImageLoadingEnabled(bool lazyImageLoadingEnabled) { m_values.lazyImageLoadingEnabled = lazyImageLoadingEnabled; }
    bool legacyBeforeLoadEventEnabled() const { return m_values.legacyBeforeLoadEventEnabled; }
    void setLegacyBeforeLoadEventEnabled(bool legacyBeforeLoadEventEnabled) { m_values.legacyBeforeLoadEventEnabled = legacyBeforeLoadEventEnabled; }
    bool legacyLineLayoutVisualCoverageEnabled() const { return m_values.legacyLineLayoutVisualCoverageEnabled; }
    WEBCORE_EXPORT void setLegacyLineLayoutVisualCoverageEnabled(bool);
    bool linkPreconnectEnabled() const { return m_values.linkPreconnectEnabled; }
    void setLinkPreconnectEnabled(bool linkPreconnectEnabled) { m_values.linkPreconnectEnabled = linkPreconnectEnabled; }
    bool linkPrefetchEnabled() const { return m_values.linkPrefetchEnabled; }
    void setLinkPrefetchEnabled(bool linkPrefetchEnabled) { m_values.linkPrefetchEnabled = linkPrefetchEnabled; }
    bool linkPreloadEnabled() const { return m_values.linkPreloadEnabled; }
    void setLinkPreloadEnabled(bool linkPreloadEnabled) { m_values.linkPreloadEnabled = linkPreloadEnabled; }
    bool linkPreloadResponsiveImagesEnabled() const { return m_values.linkPreloadResponsiveImagesEnabled; }
    void setLinkPreloadResponsiveImagesEnabled(bool linkPreloadResponsiveImagesEnabled) { m_values.linkPreloadResponsiveImagesEnabled = linkPreloadResponsiveImagesEnabled; }
    bool liveRangeSelectionEnabled() const { return m_values.liveRangeSelectionEnabled; }
    void setLiveRangeSelectionEnabled(bool liveRangeSelectionEnabled) { m_values.liveRangeSelectionEnabled = liveRangeSelectionEnabled; }
    bool loadDeferringEnabled() const { return m_values.loadDeferringEnabled; }
    void setLoadDeferringEnabled(bool loadDeferringEnabled) { m_values.loadDeferringEnabled = loadDeferringEnabled; }
    bool loadsImagesAutomatically() const { return m_values.loadsImagesAutomatically; }
    WEBCORE_EXPORT void setLoadsImagesAutomatically(bool);
    bool loadsSiteIconsIgnoringImageLoadingSetting() const { return m_values.loadsSiteIconsIgnoringImageLoadingSetting; }
    void setLoadsSiteIconsIgnoringImageLoadingSetting(bool loadsSiteIconsIgnoringImageLoadingSetting) { m_values.loadsSiteIconsIgnoringImageLoadingSetting = loadsSiteIconsIgnoringImageLoadingSetting; }
    bool localFileContentSniffingEnabled() const { return m_values.localFileContentSniffingEnabled; }
    void setLocalFileContentSniffingEnabled(bool localFileContentSniffingEnabled) { m_values.localFileContentSniffingEnabled = localFileContentSniffingEnabled; }
    const String& localStorageDatabasePath() const { return m_values.localStorageDatabasePath; }
    void setLocalStorageDatabasePath(const String& localStorageDatabasePath) { m_values.localStorageDatabasePath = localStorageDatabasePath; }
    bool localStorageEnabled() const { return m_values.localStorageEnabled; }
    void setLocalStorageEnabled(bool localStorageEnabled) { m_values.localStorageEnabled = localStorageEnabled; }
    bool logsPageMessagesToSystemConsoleEnabled() const { return m_values.logsPageMessagesToSystemConsoleEnabled; }
    void setLogsPageMessagesToSystemConsoleEnabled(bool logsPageMessagesToSystemConsoleEnabled) { m_values.logsPageMessagesToSystemConsoleEnabled = logsPageMessagesToSystemConsoleEnabled; }
    bool mainContentUserGestureOverrideEnabled() const { return m_values.mainContentUserGestureOverrideEnabled; }
    void setMainContentUserGestureOverrideEnabled(bool mainContentUserGestureOverrideEnabled) { m_values.mainContentUserGestureOverrideEnabled = mainContentUserGestureOverrideEnabled; }
    double maxParseDuration() const { return m_values.maxParseDuration; }
    void setMaxParseDuration(double maxParseDuration) { m_values.maxParseDuration = maxParseDuration; }
    uint32_t maximumAccelerated2dCanvasSize() const { return m_values.maximumAccelerated2dCanvasSize; }
    void setMaximumAccelerated2dCanvasSize(uint32_t maximumAccelerated2dCanvasSize) { m_values.maximumAccelerated2dCanvasSize = maximumAccelerated2dCanvasSize; }
    uint32_t maximumHTMLParserDOMTreeDepth() const { return m_values.maximumHTMLParserDOMTreeDepth; }
    void setMaximumHTMLParserDOMTreeDepth(uint32_t maximumHTMLParserDOMTreeDepth) { m_values.maximumHTMLParserDOMTreeDepth = maximumHTMLParserDOMTreeDepth; }
    bool mediaCapabilitiesEnabled() const { return m_values.mediaCapabilitiesEnabled; }
    void setMediaCapabilitiesEnabled(bool mediaCapabilitiesEnabled) { m_values.mediaCapabilitiesEnabled = mediaCapabilitiesEnabled; }
    bool mediaCapabilitiesExtensionsEnabled() const { return m_values.mediaCapabilitiesExtensionsEnabled; }
    void setMediaCapabilitiesExtensionsEnabled(bool mediaCapabilitiesExtensionsEnabled) { m_values.mediaCapabilitiesExtensionsEnabled = mediaCapabilitiesExtensionsEnabled; }
    bool mediaControlsScaleWithPageZoom() const { return m_values.mediaControlsScaleWithPageZoom; }
    void setMediaControlsScaleWithPageZoom(bool mediaControlsScaleWithPageZoom) { m_values.mediaControlsScaleWithPageZoom = mediaControlsScaleWithPageZoom; }
    bool mediaDataLoadsAutomatically() const { return m_values.mediaDataLoadsAutomatically; }
    void setMediaDataLoadsAutomatically(bool mediaDataLoadsAutomatically) { m_values.mediaDataLoadsAutomatically = mediaDataLoadsAutomatically; }
    const String& mediaKeysStorageDirectory() const { return m_values.mediaKeysStorageDirectory; }
    void setMediaKeysStorageDirectory(const String& mediaKeysStorageDirectory) { m_values.mediaKeysStorageDirectory = mediaKeysStorageDirectory; }
    bool mediaPreloadingEnabled() const { return m_values.mediaPreloadingEnabled; }
    void setMediaPreloadingEnabled(bool mediaPreloadingEnabled) { m_values.mediaPreloadingEnabled = mediaPreloadingEnabled; }
    bool mediaSourceEnabled() const { return m_values.mediaSourceEnabled; }
    void setMediaSourceEnabled(bool mediaSourceEnabled) { m_values.mediaSourceEnabled = mediaSourceEnabled; }
    const String& mediaTypeOverride() const { return m_values.mediaTypeOverride; }
    WEBCORE_EXPORT void setMediaTypeOverride(const String&);
    bool mediaUserGestureInheritsFromDocument() const { return m_values.mediaUserGestureInheritsFromDocument; }
    void setMediaUserGestureInheritsFromDocument(bool mediaUserGestureInheritsFromDocument) { m_values.mediaUserGestureInheritsFromDocument = mediaUserGestureInheritsFromDocument; }
    uint32_t minimumAccelerated2dCanvasSize() const { return m_values.minimumAccelerated2dCanvasSize; }
    void setMinimumAccelerated2dCanvasSize(uint32_t minimumAccelerated2dCanvasSize) { m_values.minimumAccelerated2dCanvasSize = minimumAccelerated2dCanvasSize; }
    double minimumFontSize() const { return m_values.minimumFontSize; }
    WEBCORE_EXPORT void setMinimumFontSize(double);
    double minimumLogicalFontSize() const { return m_values.minimumLogicalFontSize; }
    WEBCORE_EXPORT void setMinimumLogicalFontSize(double);
    bool needsAcrobatFrameReloadingQuirk() const { return m_values.needsAdobeFrameReloadingQuirk; }
    void setNeedsAdobeFrameReloadingQuirk(bool needsAdobeFrameReloadingQuirk) { m_values.needsAdobeFrameReloadingQuirk = needsAdobeFrameReloadingQuirk; }
    bool needsDeferKeyDownAndKeyPressTimersUntilNextEditingCommandQuirk() const { return m_values.needsDeferKeyDownAndKeyPressTimersUntilNextEditingCommandQuirk; }
    void setNeedsDeferKeyDownAndKeyPressTimersUntilNextEditingCommandQuirk(bool needsDeferKeyDownAndKeyPressTimersUntilNextEditingCommandQuirk) { m_values.needsDeferKeyDownAndKeyPressTimersUntilNextEditingCommandQuirk = needsDeferKeyDownAndKeyPressTimersUntilNextEditingCommandQuirk; }
    bool needsFrameNameFallbackToIdQuirk() const { return m_values.needsFrameNameFallbackToIdQuirk; }
    void setNeedsFrameNameFallbackToIdQuirk(bool needsFrameNameFallbackToIdQuirk) { m_values.needsFrameNameFallbackToIdQuirk = needsFrameNameFallbackToIdQuirk; }
    bool needsKeyboardEventDisambiguationQuirks() const { return m_values.needsKeyboardEventDisambiguationQuirks; }
    void setNeedsKeyboardEventDisambiguationQuirks(bool needsKeyboardEventDisambiguationQuirks) { m_values.needsKeyboardEventDisambiguationQuirks = needsKeyboardEventDisambiguationQuirks; }
    WEBCORE_EXPORT bool needsSiteSpecificQuirks() const;
    void setNeedsSiteSpecificQuirks(bool needsSiteSpecificQuirks) { m_values.needsSiteSpecificQuirks = needsSiteSpecificQuirks; }
    bool needsStorageAccessFromFileURLsQuirk() const { return m_values.needsStorageAccessFromFileURLsQuirk; }
    void setNeedsStorageAccessFromFileURLsQuirk(bool needsStorageAccessFromFileURLsQuirk) { m_values.needsStorageAccessFromFileURLsQuirk = needsStorageAccessFromFileURLsQuirk; }
    bool offlineWebApplicationCacheEnabled() const { return m_values.offlineWebApplicationCacheEnabled; }
    void setOfflineWebApplicationCacheEnabled(bool offlineWebApplicationCacheEnabled) { m_values.offlineWebApplicationCacheEnabled = offlineWebApplicationCacheEnabled; }
    bool overscrollBehaviorEnabled() const { return m_values.overscrollBehaviorEnabled; }
    void setOverscrollBehaviorEnabled(bool overscrollBehaviorEnabled) { m_values.overscrollBehaviorEnabled = overscrollBehaviorEnabled; }
    bool paginateDuringLayoutEnabled() const { return m_values.paginateDuringLayoutEnabled; }
    void setPaginateDuringLayoutEnabled(bool paginateDuringLayoutEnabled) { m_values.paginateDuringLayoutEnabled = paginateDuringLayoutEnabled; }
    bool passiveTouchListenersAsDefaultOnDocument() const { return m_values.passiveTouchListenersAsDefaultOnDocument; }
    void setPassiveTouchListenersAsDefaultOnDocument(bool passiveTouchListenersAsDefaultOnDocument) { m_values.passiveTouchListenersAsDefaultOnDocument = passiveTouchListenersAsDefaultOnDocument; }
    bool passiveWheelListenersAsDefaultOnDocument() const { return m_values.passiveWheelListenersAsDefaultOnDocument; }
    void setPassiveWheelListenersAsDefaultOnDocument(bool passiveWheelListenersAsDefaultOnDocument) { m_values.passiveWheelListenersAsDefaultOnDocument = passiveWheelListenersAsDefaultOnDocument; }
    double passwordEchoDurationInSeconds() const { return m_values.passwordEchoDurationInSeconds; }
    void setPasswordEchoDurationInSeconds(double passwordEchoDurationInSeconds) { m_values.passwordEchoDurationInSeconds = passwordEchoDurationInSeconds; }
    bool passwordEchoEnabled() const { return m_values.passwordEchoEnabled; }
    void setPasswordEchoEnabled(bool passwordEchoEnabled) { m_values.passwordEchoEnabled = passwordEchoEnabled; }
    PDFImageCachingPolicy pdfImageCachingPolicy() const { return m_values.pdfImageCachingPolicy; }
    void setPdfImageCachingPolicy(PDFImageCachingPolicy pdfImageCachingPolicy) { m_values.pdfImageCachingPolicy = pdfImageCachingPolicy; }
    MediaPlayerEnums::PitchCorrectionAlgorithm pitchCorrectionAlgorithm() const { return m_values.pitchCorrectionAlgorithm; }
    void setPitchCorrectionAlgorithm(MediaPlayerEnums::PitchCorrectionAlgorithm pitchCorrectionAlgorithm) { m_values.pitchCorrectionAlgorithm = pitchCorrectionAlgorithm; }
    bool arePluginsEnabled() const { return m_values.pluginsEnabled; }
    WEBCORE_EXPORT void setPluginsEnabled(bool);
    bool preferMIMETypeForImages() const { return m_values.preferMIMETypeForImages; }
    void setPreferMIMETypeForImages(bool preferMIMETypeForImages) { m_values.preferMIMETypeForImages = preferMIMETypeForImages; }
    bool preferPageRenderingUpdatesNear60FPSEnabled() const { return m_values.preferPageRenderingUpdatesNear60FPSEnabled; }
    void setPreferPageRenderingUpdatesNear60FPSEnabled(bool preferPageRenderingUpdatesNear60FPSEnabled) { m_values.preferPageRenderingUpdatesNear60FPSEnabled = preferPageRenderingUpdatesNear60FPSEnabled; }
    bool preventKeyboardDOMEventDispatch() const { return m_values.preventKeyboardDOMEventDispatch; }
    void setPreventKeyboardDOMEventDispatch(bool preventKeyboardDOMEventDispatch) { m_values.preventKeyboardDOMEventDispatch = preventKeyboardDOMEventDispatch; }
    bool privateClickMeasurementEnabled() const { return m_values.privateClickMeasurementEnabled; }
    void setPrivateClickMeasurementEnabled(bool privateClickMeasurementEnabled) { m_values.privateClickMeasurementEnabled = privateClickMeasurementEnabled; }
    bool privateClickMeasurementFraudPreventionEnabled() const { return m_values.privateClickMeasurementFraudPreventionEnabled; }
    void setPrivateClickMeasurementFraudPreventionEnabled(bool privateClickMeasurementFraudPreventionEnabled) { m_values.privateClickMeasurementFraudPreventionEnabled = privateClickMeasurementFraudPreventionEnabled; }
    bool punchOutWhiteBackgroundsInDarkMode() const { return m_values.punchOutWhiteBackgroundsInDarkMode; }
    WEBCORE_EXPORT void setPunchOutWhiteBackgroundsInDarkMode(bool);
    bool quickTimePluginReplacementEnabled() const { return m_values.quickTimePluginReplacementEnabled; }
    void setQuickTimePluginReplacementEnabled(bool quickTimePluginReplacementEnabled) { m_values.quickTimePluginReplacementEnabled = quickTimePluginReplacementEnabled; }
    bool referrerPolicyAttributeEnabled() const { return m_values.referrerPolicyAttributeEnabled; }
    void setReferrerPolicyAttributeEnabled(bool referrerPolicyAttributeEnabled) { m_values.referrerPolicyAttributeEnabled = referrerPolicyAttributeEnabled; }
    bool repaintOutsideLayoutEnabled() const { return m_values.repaintOutsideLayoutEnabled; }
    void setRepaintOutsideLayoutEnabled(bool repaintOutsideLayoutEnabled) { m_values.repaintOutsideLayoutEnabled = repaintOutsideLayoutEnabled; }
    bool requestAnimationFrameEnabled() const { return m_values.requestAnimationFrameEnabled; }
    void setRequestAnimationFrameEnabled(bool requestAnimationFrameEnabled) { m_values.requestAnimationFrameEnabled = requestAnimationFrameEnabled; }
    bool requestIdleCallbackEnabled() const { return m_values.requestIdleCallbackEnabled; }
    void setRequestIdleCallbackEnabled(bool requestIdleCallbackEnabled) { m_values.requestIdleCallbackEnabled = requestIdleCallbackEnabled; }
    bool requiresUserGestureToLoadVideo() const { return m_values.requiresUserGestureToLoadVideo; }
    void setRequiresUserGestureToLoadVideo(bool requiresUserGestureToLoadVideo) { m_values.requiresUserGestureToLoadVideo = requiresUserGestureToLoadVideo; }
    bool resourceLoadSchedulingEnabled() const { return m_values.resourceLoadSchedulingEnabled; }
    void setResourceLoadSchedulingEnabled(bool resourceLoadSchedulingEnabled) { m_values.resourceLoadSchedulingEnabled = resourceLoadSchedulingEnabled; }
    WEBCORE_EXPORT bool isScriptEnabled() const;
    void setScriptEnabled(bool scriptEnabled) { m_values.scriptEnabled = scriptEnabled; }
    bool scriptMarkupEnabled() const { return m_values.scriptMarkupEnabled; }
    void setScriptMarkupEnabled(bool scriptMarkupEnabled) { m_values.scriptMarkupEnabled = scriptMarkupEnabled; }
    bool scrollingCoordinatorEnabled() const { return m_values.scrollingCoordinatorEnabled; }
    void setScrollingCoordinatorEnabled(bool scrollingCoordinatorEnabled) { m_values.scrollingCoordinatorEnabled = scrollingCoordinatorEnabled; }
    bool scrollingPerformanceTestingEnabled() const { return m_values.scrollingPerformanceTestingEnabled; }
    WEBCORE_EXPORT void setScrollingPerformanceTestingEnabled(bool);
    bool scrollingTreeIncludesFrames() const { return m_values.scrollingTreeIncludesFrames; }
    void setScrollingTreeIncludesFrames(bool scrollingTreeIncludesFrames) { m_values.scrollingTreeIncludesFrames = scrollingTreeIncludesFrames; }
    bool selectTrailingWhitespaceEnabled() const { return m_values.selectTrailingWhitespaceEnabled; }
    void setSelectTrailingWhitespaceEnabled(bool selectTrailingWhitespaceEnabled) { m_values.selectTrailingWhitespaceEnabled = selectTrailingWhitespaceEnabled; }
    bool selectionAcrossShadowBoundariesEnabled() const { return m_values.selectionAcrossShadowBoundariesEnabled; }
    void setSelectionAcrossShadowBoundariesEnabled(bool selectionAcrossShadowBoundariesEnabled) { m_values.selectionAcrossShadowBoundariesEnabled = selectionAcrossShadowBoundariesEnabled; }
    bool selectionPaintingWithoutSelectionGapsEnabled() const { return m_values.selectionPaintingWithoutSelectionGapsEnabled; }
    void setSelectionPaintingWithoutSelectionGapsEnabled(bool selectionPaintingWithoutSelectionGapsEnabled) { m_values.selectionPaintingWithoutSelectionGapsEnabled = selectionPaintingWithoutSelectionGapsEnabled; }
    uint32_t sessionStorageQuota() const { return m_values.sessionStorageQuota; }
    void setSessionStorageQuota(uint32_t sessionStorageQuota) { m_values.sessionStorageQuota = sessionStorageQuota; }
    bool shouldAllowUserInstalledFonts() const { return m_values.shouldAllowUserInstalledFonts; }
    WEBCORE_EXPORT void setShouldAllowUserInstalledFonts(bool);
    bool shouldConvertInvalidURLsToBlank() const { return m_values.shouldConvertInvalidURLsToBlank; }
    void setShouldConvertInvalidURLsToBlank(bool shouldConvertInvalidURLsToBlank) { m_values.shouldConvertInvalidURLsToBlank = shouldConvertInvalidURLsToBlank; }
    bool shouldConvertPositionStyleOnCopy() const { return m_values.shouldConvertPositionStyleOnCopy; }
    void setShouldConvertPositionStyleOnCopy(bool shouldConvertPositionStyleOnCopy) { m_values.shouldConvertPositionStyleOnCopy = shouldConvertPositionStyleOnCopy; }
    bool shouldDecidePolicyBeforeLoadingQuickLookPreview() const { return m_values.shouldDecidePolicyBeforeLoadingQuickLookPreview; }
    void setShouldDecidePolicyBeforeLoadingQuickLookPreview(bool shouldDecidePolicyBeforeLoadingQuickLookPreview) { m_values.shouldDecidePolicyBeforeLoadingQuickLookPreview = shouldDecidePolicyBeforeLoadingQuickLookPreview; }
    bool shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint() const { return m_values.shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint; }
    void setShouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint(bool shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint) { m_values.shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint = shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint; }
    bool shouldDispatchSyntheticMouseEventsWhenModifyingSelection() const { return m_values.shouldDispatchSyntheticMouseEventsWhenModifyingSelection; }
    void setShouldDispatchSyntheticMouseEventsWhenModifyingSelection(bool shouldDispatchSyntheticMouseEventsWhenModifyingSelection) { m_values.shouldDispatchSyntheticMouseEventsWhenModifyingSelection = shouldDispatchSyntheticMouseEventsWhenModifyingSelection; }
    bool shouldDispatchSyntheticMouseOutAfterSyntheticClick() const { return m_values.shouldDispatchSyntheticMouseOutAfterSyntheticClick; }
    void setShouldDispatchSyntheticMouseOutAfterSyntheticClick(bool shouldDispatchSyntheticMouseOutAfterSyntheticClick) { m_values.shouldDispatchSyntheticMouseOutAfterSyntheticClick = shouldDispatchSyntheticMouseOutAfterSyntheticClick; }
    bool shouldIgnoreFontLoadCompletions() const { return m_values.shouldIgnoreFontLoadCompletions; }
    void setShouldIgnoreFontLoadCompletions(bool shouldIgnoreFontLoadCompletions) { m_values.shouldIgnoreFontLoadCompletions = shouldIgnoreFontLoadCompletions; }
    bool shouldIgnoreMetaViewport() const { return m_values.shouldIgnoreMetaViewport; }
    void setShouldIgnoreMetaViewport(bool shouldIgnoreMetaViewport) { m_values.shouldIgnoreMetaViewport = shouldIgnoreMetaViewport; }
    bool shouldInjectUserScriptsInInitialEmptyDocument() const { return m_values.shouldInjectUserScriptsInInitialEmptyDocument; }
    void setShouldInjectUserScriptsInInitialEmptyDocument(bool shouldInjectUserScriptsInInitialEmptyDocument) { m_values.shouldInjectUserScriptsInInitialEmptyDocument = shouldInjectUserScriptsInInitialEmptyDocument; }
    bool shouldPrintBackgrounds() const { return m_values.shouldPrintBackgrounds; }
    void setShouldPrintBackgrounds(bool shouldPrintBackgrounds) { m_values.shouldPrintBackgrounds = shouldPrintBackgrounds; }
    bool shouldRespectImageOrientation() const { return m_values.shouldRespectImageOrientation; }
    void setShouldRespectImageOrientation(bool shouldRespectImageOrientation) { m_values.shouldRespectImageOrientation = shouldRespectImageOrientation; }
    bool shouldRestrictBaseURLSchemes() const { return m_values.shouldRestrictBaseURLSchemes; }
    void setShouldRestrictBaseURLSchemes(bool shouldRestrictBaseURLSchemes) { m_values.shouldRestrictBaseURLSchemes = shouldRestrictBaseURLSchemes; }
    bool shouldSuppressTextInputFromEditingDuringProvisionalNavigation() const { return m_values.shouldSuppressTextInputFromEditingDuringProvisionalNavigation; }
    void setShouldSuppressTextInputFromEditingDuringProvisionalNavigation(bool shouldSuppressTextInputFromEditingDuringProvisionalNavigation) { m_values.shouldSuppressTextInputFromEditingDuringProvisionalNavigation = shouldSuppressTextInputFromEditingDuringProvisionalNavigation; }
    bool shouldUseServiceWorkerShortTimeout() const { return m_values.shouldUseServiceWorkerShortTimeout; }
    void setShouldUseServiceWorkerShortTimeout(bool shouldUseServiceWorkerShortTimeout) { m_values.shouldUseServiceWorkerShortTimeout = shouldUseServiceWorkerShortTimeout; }
    WEBCORE_EXPORT bool showDebugBorders() const;
    WEBCORE_EXPORT void setShowDebugBorders(bool);
    WEBCORE_EXPORT bool showRepaintCounter() const;
    WEBCORE_EXPORT void setShowRepaintCounter(bool);
    bool showTiledScrollingIndicator() const { return m_values.showTiledScrollingIndicator; }
    void setShowTiledScrollingIndicator(bool showTiledScrollingIndicator) { m_values.showTiledScrollingIndicator = showTiledScrollingIndicator; }
    bool showsToolTipOverTruncatedText() const { return m_values.showsToolTipOverTruncatedText; }
    void setShowsToolTipOverTruncatedText(bool showsToolTipOverTruncatedText) { m_values.showsToolTipOverTruncatedText = showsToolTipOverTruncatedText; }
    bool showsURLsInToolTips() const { return m_values.showsURLsInToolTips; }
    void setShowsURLsInToolTips(bool showsURLsInToolTips) { m_values.showsURLsInToolTips = showsURLsInToolTips; }
    bool shrinksStandaloneImagesToFit() const { return m_values.shrinksStandaloneImagesToFit; }
    void setShrinksStandaloneImagesToFit(bool shrinksStandaloneImagesToFit) { m_values.shrinksStandaloneImagesToFit = shrinksStandaloneImagesToFit; }
    bool simpleLineLayoutEnabled() const { return m_values.simpleLineLayoutEnabled; }
    WEBCORE_EXPORT void setSimpleLineLayoutEnabled(bool);
    bool smartInsertDeleteEnabled() const { return m_values.smartInsertDeleteEnabled; }
    void setSmartInsertDeleteEnabled(bool smartInsertDeleteEnabled) { m_values.smartInsertDeleteEnabled = smartInsertDeleteEnabled; }
    bool spatialNavigationEnabled() const { return m_values.spatialNavigationEnabled; }
    void setSpatialNavigationEnabled(bool spatialNavigationEnabled) { m_values.spatialNavigationEnabled = spatialNavigationEnabled; }
    bool speechRecognitionEnabled() const { return m_values.speechRecognitionEnabled; }
    void setSpeechRecognitionEnabled(bool speechRecognitionEnabled) { m_values.speechRecognitionEnabled = speechRecognitionEnabled; }
    bool springTimingFunctionEnabled() const { return m_values.springTimingFunctionEnabled; }
    void setSpringTimingFunctionEnabled(bool springTimingFunctionEnabled) { m_values.springTimingFunctionEnabled = springTimingFunctionEnabled; }
    bool standalone() const { return m_values.standalone; }
    void setStandalone(bool standalone) { m_values.standalone = standalone; }
    bool storageAccessAPIEnabled() const { return m_values.storageAccessAPIEnabled; }
    void setStorageAccessAPIEnabled(bool storageAccessAPIEnabled) { m_values.storageAccessAPIEnabled = storageAccessAPIEnabled; }
    bool storageAccessAPIPerPageScopeEnabled() const { return m_values.storageAccessAPIPerPageScopeEnabled; }
    void setStorageAccessAPIPerPageScopeEnabled(bool storageAccessAPIPerPageScopeEnabled) { m_values.storageAccessAPIPerPageScopeEnabled = storageAccessAPIPerPageScopeEnabled; }
    StorageBlockingPolicy storageBlockingPolicy() const { return m_values.storageBlockingPolicy; }
    WEBCORE_EXPORT void setStorageBlockingPolicy(StorageBlockingPolicy);
    bool subpixelAntialiasedLayerTextEnabled() const { return m_values.subpixelAntialiasedLayerTextEnabled; }
    WEBCORE_EXPORT void setSubpixelAntialiasedLayerTextEnabled(bool);
    bool subresourceIntegrityEnabled() const { return m_values.subresourceIntegrityEnabled; }
    void setSubresourceIntegrityEnabled(bool subresourceIntegrityEnabled) { m_values.subresourceIntegrityEnabled = subresourceIntegrityEnabled; }
    bool suppressesIncrementalRendering() const { return m_values.suppressesIncrementalRendering; }
    void setSuppressesIncrementalRendering(bool suppressesIncrementalRendering) { m_values.suppressesIncrementalRendering = suppressesIncrementalRendering; }
    bool syntheticEditingCommandsEnabled() const { return m_values.syntheticEditingCommandsEnabled; }
    void setSyntheticEditingCommandsEnabled(bool syntheticEditingCommandsEnabled) { m_values.syntheticEditingCommandsEnabled = syntheticEditingCommandsEnabled; }
    TextDirection systemLayoutDirection() const { return m_values.systemLayoutDirection; }
    void setSystemLayoutDirection(TextDirection systemLayoutDirection) { m_values.systemLayoutDirection = systemLayoutDirection; }
    bool telephoneNumberParsingEnabled() const { return m_values.telephoneNumberParsingEnabled; }
    void setTelephoneNumberParsingEnabled(bool telephoneNumberParsingEnabled) { m_values.telephoneNumberParsingEnabled = telephoneNumberParsingEnabled; }
    bool temporaryTileCohortRetentionEnabled() const { return m_values.temporaryTileCohortRetentionEnabled; }
    void setTemporaryTileCohortRetentionEnabled(bool temporaryTileCohortRetentionEnabled) { m_values.temporaryTileCohortRetentionEnabled = temporaryTileCohortRetentionEnabled; }
    bool textAreasAreResizable() const { return m_values.textAreasAreResizable; }
    WEBCORE_EXPORT void setTextAreasAreResizable(bool);
    TextDirectionSubmenuInclusionBehavior textDirectionSubmenuInclusionBehavior() const { return m_values.textDirectionSubmenuInclusionBehavior; }
    void setTextDirectionSubmenuInclusionBehavior(TextDirectionSubmenuInclusionBehavior textDirectionSubmenuInclusionBehavior) { m_values.textDirectionSubmenuInclusionBehavior = textDirectionSubmenuInclusionBehavior; }
    bool textInteractionEnabled() const { return m_values.textInteractionEnabled; }
    void setTextInteractionEnabled(bool textInteractionEnabled) { m_values.textInteractionEnabled = textInteractionEnabled; }
    bool thirdPartyIframeRedirectBlockingEnabled() const { return m_values.thirdPartyIframeRedirectBlockingEnabled; }
    void setThirdPartyIframeRedirectBlockingEnabled(bool thirdPartyIframeRedirectBlockingEnabled) { m_values.thirdPartyIframeRedirectBlockingEnabled = thirdPartyIframeRedirectBlockingEnabled; }
    Seconds timeWithoutMouseMovementBeforeHidingControls() const { return m_values.timeWithoutMouseMovementBeforeHidingControls; }
    void setTimeWithoutMouseMovementBeforeHidingControls(Seconds timeWithoutMouseMovementBeforeHidingControls) { m_values.timeWithoutMouseMovementBeforeHidingControls = timeWithoutMouseMovementBeforeHidingControls; }
    bool treatIPAddressAsDomain() const { return m_values.treatIPAddressAsDomain; }
    void setTreatIPAddressAsDomain(bool treatIPAddressAsDomain) { m_values.treatIPAddressAsDomain = treatIPAddressAsDomain; }
    bool treatsAnyTextCSSLinkAsStylesheet() const { return m_values.treatsAnyTextCSSLinkAsStylesheet; }
    void setTreatsAnyTextCSSLinkAsStylesheet(bool treatsAnyTextCSSLinkAsStylesheet) { m_values.treatsAnyTextCSSLinkAsStylesheet = treatsAnyTextCSSLinkAsStylesheet; }
    bool undoManagerAPIEnabled() const { return m_values.undoManagerAPIEnabled; }
    void setUndoManagerAPIEnabled(bool undoManagerAPIEnabled) { m_values.undoManagerAPIEnabled = undoManagerAPIEnabled; }
    bool unhandledPromiseRejectionToConsoleEnabled() const { return m_values.unhandledPromiseRejectionToConsoleEnabled; }
    void setUnhandledPromiseRejectionToConsoleEnabled(bool unhandledPromiseRejectionToConsoleEnabled) { m_values.unhandledPromiseRejectionToConsoleEnabled = unhandledPromiseRejectionToConsoleEnabled; }
    bool unifiedTextCheckerEnabled() const { return m_values.unifiedTextCheckerEnabled; }
    void setUnifiedTextCheckerEnabled(bool unifiedTextCheckerEnabled) { m_values.unifiedTextCheckerEnabled = unifiedTextCheckerEnabled; }
    bool useAnonymousModeWhenFetchingMaskImages() const { return m_values.useAnonymousModeWhenFetchingMaskImages; }
    void setUseAnonymousModeWhenFetchingMaskImages(bool useAnonymousModeWhenFetchingMaskImages) { m_values.useAnonymousModeWhenFetchingMaskImages = useAnonymousModeWhenFetchingMaskImages; }
    bool useGiantTiles() const { return m_values.useGiantTiles; }
    void setUseGiantTiles(bool useGiantTiles) { m_values.useGiantTiles = useGiantTiles; }
    bool useImageDocumentForSubframePDF() const { return m_values.useImageDocumentForSubframePDF; }
    void setUseImageDocumentForSubframePDF(bool useImageDocumentForSubframePDF) { m_values.useImageDocumentForSubframePDF = useImageDocumentForSubframePDF; }
    bool useLegacyBackgroundSizeShorthandBehavior() const { return m_values.useLegacyBackgroundSizeShorthandBehavior; }
    void setUseLegacyBackgroundSizeShorthandBehavior(bool useLegacyBackgroundSizeShorthandBehavior) { m_values.useLegacyBackgroundSizeShorthandBehavior = useLegacyBackgroundSizeShorthandBehavior; }
    bool useLegacyTextAlignPositionedElementBehavior() const { return m_values.useLegacyTextAlignPositionedElementBehavior; }
    void setUseLegacyTextAlignPositionedElementBehavior(bool useLegacyTextAlignPositionedElementBehavior) { m_values.useLegacyTextAlignPositionedElementBehavior = useLegacyTextAlignPositionedElementBehavior; }
    bool usePreHTML5ParserQuirks() const { return m_values.usePreHTML5ParserQuirks; }
    void setUsePreHTML5ParserQuirks(bool usePreHTML5ParserQuirks) { m_values.usePreHTML5ParserQuirks = usePreHTML5ParserQuirks; }
    bool useThemeColorForScrollAreaBackgroundColor() const { return m_values.useThemeColorForScrollAreaBackgroundColor; }
    void setUseThemeColorForScrollAreaBackgroundColor(bool useThemeColorForScrollAreaBackgroundColor) { m_values.useThemeColorForScrollAreaBackgroundColor = useThemeColorForScrollAreaBackgroundColor; }
    UserInterfaceDirectionPolicy userInterfaceDirectionPolicy() const { return m_values.userInterfaceDirectionPolicy; }
    void setUserInterfaceDirectionPolicy(UserInterfaceDirectionPolicy userInterfaceDirectionPolicy) { m_values.userInterfaceDirectionPolicy = userInterfaceDirectionPolicy; }
    const URL& userStyleSheetLocation() const { return m_values.userStyleSheetLocation; }
    WEBCORE_EXPORT void setUserStyleSheetLocation(const URL&);
    bool usesBackForwardCache() const { return m_values.usesBackForwardCache; }
    WEBCORE_EXPORT void setUsesBackForwardCache(bool);
    bool usesEncodingDetector() const { return m_values.usesEncodingDetector; }
    void setUsesEncodingDetector(bool usesEncodingDetector) { m_values.usesEncodingDetector = usesEncodingDetector; }
    uint32_t validationMessageTimerMagnification() const { return m_values.validationMessageTimerMagnification; }
    void setValidationMessageTimerMagnification(uint32_t validationMessageTimerMagnification) { m_values.validationMessageTimerMagnification = validationMessageTimerMagnification; }
    bool videoPlaybackRequiresUserGesture() const { return m_values.videoPlaybackRequiresUserGesture; }
    void setVideoPlaybackRequiresUserGesture(bool videoPlaybackRequiresUserGesture) { m_values.videoPlaybackRequiresUserGesture = videoPlaybackRequiresUserGesture; }
    bool viewportFitEnabled() const { return m_values.viewportFitEnabled; }
    void setViewportFitEnabled(bool viewportFitEnabled) { m_values.viewportFitEnabled = viewportFitEnabled; }
    uint32_t visibleDebugOverlayRegions() const { return m_values.visibleDebugOverlayRegions; }
    void setVisibleDebugOverlayRegions(uint32_t visibleDebugOverlayRegions) { m_values.visibleDebugOverlayRegions = visibleDebugOverlayRegions; }
    bool visualViewportAPIEnabled() const { return m_values.visualViewportAPIEnabled; }
    void setVisualViewportAPIEnabled(bool visualViewportAPIEnabled) { m_values.visualViewportAPIEnabled = visualViewportAPIEnabled; }
    bool visualViewportEnabled() const { return m_values.visualViewportEnabled; }
    WEBCORE_EXPORT void setVisualViewportEnabled(bool);
    bool wantsBalancedSetDefersLoadingBehavior() const { return m_values.wantsBalancedSetDefersLoadingBehavior; }
    void setWantsBalancedSetDefersLoadingBehavior(bool wantsBalancedSetDefersLoadingBehavior) { m_values.wantsBalancedSetDefersLoadingBehavior = wantsBalancedSetDefersLoadingBehavior; }
    bool webAnimationsCompositeOperationsEnabled() const { return m_values.webAnimationsCompositeOperationsEnabled; }
    void setWebAnimationsCompositeOperationsEnabled(bool webAnimationsCompositeOperationsEnabled) { m_values.webAnimationsCompositeOperationsEnabled = webAnimationsCompositeOperationsEnabled; }
    bool webAnimationsMutableTimelinesEnabled() const { return m_values.webAnimationsMutableTimelinesEnabled; }
    void setWebAnimationsMutableTimelinesEnabled(bool webAnimationsMutableTimelinesEnabled) { m_values.webAnimationsMutableTimelinesEnabled = webAnimationsMutableTimelinesEnabled; }
    bool webGLEnabled() const { return m_values.webGLEnabled; }
    void setWebGLEnabled(bool webGLEnabled) { m_values.webGLEnabled = webGLEnabled; }
    bool webGLErrorsToConsoleEnabled() const { return m_values.webGLErrorsToConsoleEnabled; }
    void setWebGLErrorsToConsoleEnabled(bool webGLErrorsToConsoleEnabled) { m_values.webGLErrorsToConsoleEnabled = webGLErrorsToConsoleEnabled; }
    WEBCORE_EXPORT bool webRTCEncryptionEnabled() const;
    void setWebRTCEncryptionEnabled(bool webRTCEncryptionEnabled) { m_values.webRTCEncryptionEnabled = webRTCEncryptionEnabled; }
    WEBCORE_EXPORT bool webSecurityEnabled() const;
    void setWebSecurityEnabled(bool webSecurityEnabled) { m_values.webSecurityEnabled = webSecurityEnabled; }
    bool webShareEnabled() const { return m_values.webShareEnabled; }
    void setWebShareEnabled(bool webShareEnabled) { m_values.webShareEnabled = webShareEnabled; }
    bool webShareFileAPIEnabled() const { return m_values.webShareFileAPIEnabled; }
    void setWebShareFileAPIEnabled(bool webShareFileAPIEnabled) { m_values.webShareFileAPIEnabled = webShareFileAPIEnabled; }
    bool webkitImageReadyEventEnabled() const { return m_values.webkitImageReadyEventEnabled; }
    void setWebkitImageReadyEventEnabled(bool webkitImageReadyEventEnabled) { m_values.webkitImageReadyEventEnabled = webkitImageReadyEventEnabled; }
    bool wheelEventGesturesBecomeNonBlocking() const { return m_values.wheelEventGesturesBecomeNonBlocking; }
    void setWheelEventGesturesBecomeNonBlocking(bool wheelEventGesturesBecomeNonBlocking) { m_values.wheelEventGesturesBecomeNonBlocking = wheelEventGesturesBecomeNonBlocking; }
    bool windowFocusRestricted() const { return m_values.windowFocusRestricted; }
    void setWindowFocusRestricted(bool windowFocusRestricted) { m_values.windowFocusRestricted = windowFocusRestricted; }
    bool xssAuditorEnabled() const { return m_values.xssAuditorEnabled; }
    void setXSSAuditorEnabled(bool xssAuditorEnabled) { m_values.xssAuditorEnabled = xssAuditorEnabled; }
    bool youTubeFlashPluginReplacementEnabled() const { return m_values.youTubeFlashPluginReplacementEnabled; }
    void setYouTubeFlashPluginReplacementEnabled(bool youTubeFlashPluginReplacementEnabled) { m_values.youTubeFlashPluginReplacementEnabled = youTubeFlashPluginReplacementEnabled; }
#if ENABLE(APPLE_PAY)
    bool applePayCapabilityDisclosureAllowed() const { return m_values.applePayCapabilityDisclosureAllowed; }
    void setApplePayCapabilityDisclosureAllowed(bool applePayCapabilityDisclosureAllowed) { m_values.applePayCapabilityDisclosureAllowed = applePayCapabilityDisclosureAllowed; }
    bool applePayEnabled() const { return m_values.applePayEnabled; }
    void setApplePayEnabled(bool applePayEnabled) { m_values.applePayEnabled = applePayEnabled; }
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI)
    bool applePayRemoteUIEnabled() const { return m_values.applePayRemoteUIEnabled; }
    void setApplePayRemoteUIEnabled(bool applePayRemoteUIEnabled) { m_values.applePayRemoteUIEnabled = applePayRemoteUIEnabled; }
#endif
#if ENABLE(APP_HIGHLIGHTS)
    bool appHighlightsEnabled() const { return m_values.appHighlightsEnabled; }
    void setAppHighlightsEnabled(bool appHighlightsEnabled) { m_values.appHighlightsEnabled = appHighlightsEnabled; }
#endif
#if ENABLE(CORE_IMAGE_ACCELERATED_FILTER_RENDER)
    bool coreImageAcceleratedFilterRenderEnabled() const { return m_values.coreImageAcceleratedFilterRenderEnabled; }
    WEBCORE_EXPORT void setCoreImageAcceleratedFilterRenderEnabled(bool);
#endif
#if ENABLE(CSS_TRANSFORM_STYLE_OPTIMIZED_3D)
    bool cssTransformStyleOptimized3DEnabled() const { return m_values.cssTransformStyleOptimized3DEnabled; }
    void setCSSTransformStyleOptimized3DEnabled(bool cssTransformStyleOptimized3DEnabled) { m_values.cssTransformStyleOptimized3DEnabled = cssTransformStyleOptimized3DEnabled; }
#endif
#if ENABLE(DATA_DETECTION)
    DataDetectorType dataDetectorTypes() const { return m_values.dataDetectorTypes; }
    void setDataDetectorTypes(DataDetectorType dataDetectorTypes) { m_values.dataDetectorTypes = dataDetectorTypes; }
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
    bool dateTimeInputsEditableComponentsEnabled() const { return m_values.dateTimeInputsEditableComponentsEnabled; }
    void setDateTimeInputsEditableComponentsEnabled(bool dateTimeInputsEditableComponentsEnabled) { m_values.dateTimeInputsEditableComponentsEnabled = dateTimeInputsEditableComponentsEnabled; }
#endif
#if ENABLE(DEVICE_ORIENTATION)
    bool deviceOrientationEventEnabled() const { return m_values.deviceOrientationEventEnabled; }
    void setDeviceOrientationEventEnabled(bool deviceOrientationEventEnabled) { m_values.deviceOrientationEventEnabled = deviceOrientationEventEnabled; }
    bool deviceOrientationPermissionAPIEnabled() const { return m_values.deviceOrientationPermissionAPIEnabled; }
    void setDeviceOrientationPermissionAPIEnabled(bool deviceOrientationPermissionAPIEnabled) { m_values.deviceOrientationPermissionAPIEnabled = deviceOrientationPermissionAPIEnabled; }
#endif
#if ENABLE(DOWNLOAD_ATTRIBUTE)
    bool downloadAttributeEnabled() const { return m_values.downloadAttributeEnabled; }
    void setDownloadAttributeEnabled(bool downloadAttributeEnabled) { m_values.downloadAttributeEnabled = downloadAttributeEnabled; }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    bool encryptedMediaAPIEnabled() const { return m_values.encryptedMediaAPIEnabled; }
    void setEncryptedMediaAPIEnabled(bool encryptedMediaAPIEnabled) { m_values.encryptedMediaAPIEnabled = encryptedMediaAPIEnabled; }
#endif
#if ENABLE(FULLSCREEN_API)
    bool fullScreenEnabled() const { return m_values.fullScreenEnabled; }
    void setFullScreenEnabled(bool fullScreenEnabled) { m_values.fullScreenEnabled = fullScreenEnabled; }
#endif
#if ENABLE(GAMEPAD)
    bool gamepadsEnabled() const { return m_values.gamepadsEnabled; }
    void setGamepadsEnabled(bool gamepadsEnabled) { m_values.gamepadsEnabled = gamepadsEnabled; }
#endif
#if ENABLE(INPUT_TYPE_COLOR)
    bool inputTypeColorEnabled() const { return m_values.inputTypeColorEnabled; }
    void setInputTypeColorEnabled(bool inputTypeColorEnabled) { m_values.inputTypeColorEnabled = inputTypeColorEnabled; }
#endif
#if ENABLE(INPUT_TYPE_DATE)
    bool inputTypeDateEnabled() const { return m_values.inputTypeDateEnabled; }
    void setInputTypeDateEnabled(bool inputTypeDateEnabled) { m_values.inputTypeDateEnabled = inputTypeDateEnabled; }
#endif
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
    bool inputTypeDateTimeLocalEnabled() const { return m_values.inputTypeDateTimeLocalEnabled; }
    void setInputTypeDateTimeLocalEnabled(bool inputTypeDateTimeLocalEnabled) { m_values.inputTypeDateTimeLocalEnabled = inputTypeDateTimeLocalEnabled; }
#endif
#if ENABLE(INPUT_TYPE_MONTH)
    bool inputTypeMonthEnabled() const { return m_values.inputTypeMonthEnabled; }
    void setInputTypeMonthEnabled(bool inputTypeMonthEnabled) { m_values.inputTypeMonthEnabled = inputTypeMonthEnabled; }
#endif
#if ENABLE(INPUT_TYPE_TIME)
    bool inputTypeTimeEnabled() const { return m_values.inputTypeTimeEnabled; }
    void setInputTypeTimeEnabled(bool inputTypeTimeEnabled) { m_values.inputTypeTimeEnabled = inputTypeTimeEnabled; }
#endif
#if ENABLE(INPUT_TYPE_WEEK)
    bool inputTypeWeekEnabled() const { return m_values.inputTypeWeekEnabled; }
    void setInputTypeWeekEnabled(bool inputTypeWeekEnabled) { m_values.inputTypeWeekEnabled = inputTypeWeekEnabled; }
#endif
#if ENABLE(INTERSECTION_OBSERVER)
    bool intersectionObserverEnabled() const { return m_values.intersectionObserverEnabled; }
    void setIntersectionObserverEnabled(bool intersectionObserverEnabled) { m_values.intersectionObserverEnabled = intersectionObserverEnabled; }
#endif
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
    bool iOSFormControlRefreshEnabled() const { return m_values.iOSFormControlRefreshEnabled; }
    void setIOSFormControlRefreshEnabled(bool iOSFormControlRefreshEnabled) { m_values.iOSFormControlRefreshEnabled = iOSFormControlRefreshEnabled; }
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    bool legacyEncryptedMediaAPIEnabled() const { return m_values.legacyEncryptedMediaAPIEnabled; }
    void setLegacyEncryptedMediaAPIEnabled(bool legacyEncryptedMediaAPIEnabled) { m_values.legacyEncryptedMediaAPIEnabled = legacyEncryptedMediaAPIEnabled; }
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS)
    bool mediaControlsContextMenusEnabled() const { return m_values.mediaControlsContextMenusEnabled; }
    void setMediaControlsContextMenusEnabled(bool mediaControlsContextMenusEnabled) { m_values.mediaControlsContextMenusEnabled = mediaControlsContextMenusEnabled; }
#endif
#if ENABLE(MEDIA_SESSION)
    bool mediaSessionEnabled() const { return m_values.mediaSessionEnabled; }
    void setMediaSessionEnabled(bool mediaSessionEnabled) { m_values.mediaSessionEnabled = mediaSessionEnabled; }
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
    bool mediaSessionCoordinatorEnabled() const { return m_values.mediaSessionCoordinatorEnabled; }
    void setMediaSessionCoordinatorEnabled(bool mediaSessionCoordinatorEnabled) { m_values.mediaSessionCoordinatorEnabled = mediaSessionCoordinatorEnabled; }
#endif
#if ENABLE(MEDIA_SESSION_PLAYLIST)
    bool mediaSessionPlaylistEnabled() const { return m_values.mediaSessionPlaylistEnabled; }
    void setMediaSessionPlaylistEnabled(bool mediaSessionPlaylistEnabled) { m_values.mediaSessionPlaylistEnabled = mediaSessionPlaylistEnabled; }
#endif
#if ENABLE(MEDIA_SOURCE)
    uint32_t maximumSourceBufferSize() const { return m_values.maximumSourceBufferSize; }
    void setMaximumSourceBufferSize(uint32_t maximumSourceBufferSize) { m_values.maximumSourceBufferSize = maximumSourceBufferSize; }
    bool sourceBufferChangeTypeEnabled() const { return m_values.sourceBufferChangeTypeEnabled; }
    void setSourceBufferChangeTypeEnabled(bool sourceBufferChangeTypeEnabled) { m_values.sourceBufferChangeTypeEnabled = sourceBufferChangeTypeEnabled; }
#endif
#if ENABLE(MEDIA_STREAM)
    bool exposeSpeakersEnabled() const { return m_values.exposeSpeakersEnabled; }
    void setExposeSpeakersEnabled(bool exposeSpeakersEnabled) { m_values.exposeSpeakersEnabled = exposeSpeakersEnabled; }
    bool interruptAudioOnPageVisibilityChangeEnabled() const { return m_values.interruptAudioOnPageVisibilityChangeEnabled; }
    void setInterruptAudioOnPageVisibilityChangeEnabled(bool interruptAudioOnPageVisibilityChangeEnabled) { m_values.interruptAudioOnPageVisibilityChangeEnabled = interruptAudioOnPageVisibilityChangeEnabled; }
    WEBCORE_EXPORT bool mediaCaptureRequiresSecureConnection() const;
    void setMediaCaptureRequiresSecureConnection(bool mediaCaptureRequiresSecureConnection) { m_values.mediaCaptureRequiresSecureConnection = mediaCaptureRequiresSecureConnection; }
    const String& mediaDeviceIdentifierStorageDirectory() const { return m_values.mediaDeviceIdentifierStorageDirectory; }
    void setMediaDeviceIdentifierStorageDirectory(const String& mediaDeviceIdentifierStorageDirectory) { m_values.mediaDeviceIdentifierStorageDirectory = mediaDeviceIdentifierStorageDirectory; }
    bool mediaDevicesEnabled() const { return m_values.mediaDevicesEnabled; }
    void setMediaDevicesEnabled(bool mediaDevicesEnabled) { m_values.mediaDevicesEnabled = mediaDevicesEnabled; }
    bool mediaRecorderEnabled() const { return m_values.mediaRecorderEnabled; }
    void setMediaRecorderEnabled(bool mediaRecorderEnabled) { m_values.mediaRecorderEnabled = mediaRecorderEnabled; }
    bool mediaStreamEnabled() const { return m_values.mediaStreamEnabled; }
    void setMediaStreamEnabled(bool mediaStreamEnabled) { m_values.mediaStreamEnabled = mediaStreamEnabled; }
    WEBCORE_EXPORT bool mockCaptureDevicesEnabled() const;
    WEBCORE_EXPORT void setMockCaptureDevicesEnabled(bool);
    bool perElementSpeakerSelectionEnabled() const { return m_values.perElementSpeakerSelectionEnabled; }
    void setPerElementSpeakerSelectionEnabled(bool perElementSpeakerSelectionEnabled) { m_values.perElementSpeakerSelectionEnabled = perElementSpeakerSelectionEnabled; }
    bool screenCaptureEnabled() const { return m_values.screenCaptureEnabled; }
    void setScreenCaptureEnabled(bool screenCaptureEnabled) { m_values.screenCaptureEnabled = screenCaptureEnabled; }
    bool speakerSelectionRequiresUserGesture() const { return m_values.speakerSelectionRequiresUserGesture; }
    void setSpeakerSelectionRequiresUserGesture(bool speakerSelectionRequiresUserGesture) { m_values.speakerSelectionRequiresUserGesture = speakerSelectionRequiresUserGesture; }
#endif
#if ENABLE(MODEL_ELEMENT)
    bool modelElementEnabled() const { return m_values.modelElementEnabled; }
    void setModelElementEnabled(bool modelElementEnabled) { m_values.modelElementEnabled = modelElementEnabled; }
#endif
#if ENABLE(NOTIFICATIONS)
    bool notificationsEnabled() const { return m_values.notificationsEnabled; }
    void setNotificationsEnabled(bool notificationsEnabled) { m_values.notificationsEnabled = notificationsEnabled; }
#endif
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
    bool legacyOverflowScrollingTouchEnabled() const { return m_values.legacyOverflowScrollingTouchEnabled; }
    WEBCORE_EXPORT void setLegacyOverflowScrollingTouchEnabled(bool);
#endif
#if ENABLE(PAYMENT_REQUEST)
    bool paymentRequestEnabled() const { return m_values.paymentRequestEnabled; }
    void setPaymentRequestEnabled(bool paymentRequestEnabled) { m_values.paymentRequestEnabled = paymentRequestEnabled; }
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    bool pictureInPictureAPIEnabled() const { return m_values.pictureInPictureAPIEnabled; }
    void setPictureInPictureAPIEnabled(bool pictureInPictureAPIEnabled) { m_values.pictureInPictureAPIEnabled = pictureInPictureAPIEnabled; }
#endif
#if ENABLE(RESIZE_OBSERVER)
    bool resizeObserverEnabled() const { return m_values.resizeObserverEnabled; }
    void setResizeObserverEnabled(bool resizeObserverEnabled) { m_values.resizeObserverEnabled = resizeObserverEnabled; }
#endif
#if ENABLE(RESOURCE_USAGE)
    bool resourceUsageOverlayVisible() const { return m_values.resourceUsageOverlayVisible; }
    WEBCORE_EXPORT void setResourceUsageOverlayVisible(bool);
#endif
#if ENABLE(RUBBER_BANDING)
    bool rubberBandingForSubScrollableRegionsEnabled() const { return m_values.rubberBandingForSubScrollableRegionsEnabled; }
    void setRubberBandingForSubScrollableRegionsEnabled(bool rubberBandingForSubScrollableRegionsEnabled) { m_values.rubberBandingForSubScrollableRegionsEnabled = rubberBandingForSubScrollableRegionsEnabled; }
#endif
#if ENABLE(SERVICE_CONTROLS)
    bool serviceControlsEnabled() const { return m_values.serviceControlsEnabled; }
    void setServiceControlsEnabled(bool serviceControlsEnabled) { m_values.serviceControlsEnabled = serviceControlsEnabled; }
#endif
#if ENABLE(SMOOTH_SCROLLING)
    bool scrollAnimatorEnabled() const { return m_values.scrollAnimatorEnabled; }
    void setScrollAnimatorEnabled(bool scrollAnimatorEnabled) { m_values.scrollAnimatorEnabled = scrollAnimatorEnabled; }
#endif
#if ENABLE(TEXT_AUTOSIZING)
    bool idempotentModeAutosizingOnlyHonorsPercentages() const { return m_values.idempotentModeAutosizingOnlyHonorsPercentages; }
    void setIdempotentModeAutosizingOnlyHonorsPercentages(bool idempotentModeAutosizingOnlyHonorsPercentages) { m_values.idempotentModeAutosizingOnlyHonorsPercentages = idempotentModeAutosizingOnlyHonorsPercentages; }
    double minimumZoomFontSize() const { return m_values.minimumZoomFontSize; }
    void setMinimumZoomFontSize(double minimumZoomFontSize) { m_values.minimumZoomFontSize = minimumZoomFontSize; }
    bool shouldEnableTextAutosizingBoost() const { return m_values.shouldEnableTextAutosizingBoost; }
    WEBCORE_EXPORT void setShouldEnableTextAutosizingBoost(bool);
    bool textAutosizingEnabled() const { return m_values.textAutosizingEnabled; }
    WEBCORE_EXPORT void setTextAutosizingEnabled(bool);
    bool textAutosizingUsesIdempotentMode() const { return m_values.textAutosizingUsesIdempotentMode; }
    WEBCORE_EXPORT void setTextAutosizingUsesIdempotentMode(bool);
    uint32_t textAutosizingWindowSizeOverrideHeight() const { return m_values.textAutosizingWindowSizeOverrideHeight; }
    WEBCORE_EXPORT void setTextAutosizingWindowSizeOverrideHeight(uint32_t);
    uint32_t textAutosizingWindowSizeOverrideWidth() const { return m_values.textAutosizingWindowSizeOverrideWidth; }
    WEBCORE_EXPORT void setTextAutosizingWindowSizeOverrideWidth(uint32_t);
#endif
#if ENABLE(TOUCH_EVENTS)
    bool isTouchEventEmulationEnabled() const { return m_values.touchEventEmulationEnabled; }
    void setTouchEventEmulationEnabled(bool touchEventEmulationEnabled) { m_values.touchEventEmulationEnabled = touchEventEmulationEnabled; }
#endif
#if ENABLE(VIDEO)
    bool genericCueAPIEnabled() const { return m_values.genericCueAPIEnabled; }
    void setGenericCueAPIEnabled(bool genericCueAPIEnabled) { m_values.genericCueAPIEnabled = genericCueAPIEnabled; }
    bool mediaEnabled() const { return m_values.mediaEnabled; }
    void setMediaEnabled(bool mediaEnabled) { m_values.mediaEnabled = mediaEnabled; }
    bool shouldDisplayCaptions() const { return m_values.shouldDisplayCaptions; }
    void setShouldDisplayCaptions(bool shouldDisplayCaptions) { m_values.shouldDisplayCaptions = shouldDisplayCaptions; }
    bool shouldDisplaySubtitles() const { return m_values.shouldDisplaySubtitles; }
    void setShouldDisplaySubtitles(bool shouldDisplaySubtitles) { m_values.shouldDisplaySubtitles = shouldDisplaySubtitles; }
    bool shouldDisplayTextDescriptions() const { return m_values.shouldDisplayTextDescriptions; }
    void setShouldDisplayTextDescriptions(bool shouldDisplayTextDescriptions) { m_values.shouldDisplayTextDescriptions = shouldDisplayTextDescriptions; }
    bool videoQualityIncludesDisplayCompositingEnabled() const { return m_values.videoQualityIncludesDisplayCompositingEnabled; }
    void setVideoQualityIncludesDisplayCompositingEnabled(bool videoQualityIncludesDisplayCompositingEnabled) { m_values.videoQualityIncludesDisplayCompositingEnabled = videoQualityIncludesDisplayCompositingEnabled; }
#endif
#if ENABLE(VP9)
    bool vp9DecoderEnabled() const { return m_values.vp9DecoderEnabled; }
    void setVP9DecoderEnabled(bool vp9DecoderEnabled) { m_values.vp9DecoderEnabled = vp9DecoderEnabled; }
#endif
#if ENABLE(WEB_ARCHIVE)
    bool webArchiveDebugModeEnabled() const { return m_values.webArchiveDebugModeEnabled; }
    void setWebArchiveDebugModeEnabled(bool webArchiveDebugModeEnabled) { m_values.webArchiveDebugModeEnabled = webArchiveDebugModeEnabled; }
#endif
#if ENABLE(WEB_AUDIO)
    bool audioWorkletEnabled() const { return m_values.audioWorkletEnabled; }
    void setAudioWorkletEnabled(bool audioWorkletEnabled) { m_values.audioWorkletEnabled = audioWorkletEnabled; }
    bool modernUnprefixedWebAudioEnabled() const { return m_values.modernUnprefixedWebAudioEnabled; }
    void setModernUnprefixedWebAudioEnabled(bool modernUnprefixedWebAudioEnabled) { m_values.modernUnprefixedWebAudioEnabled = modernUnprefixedWebAudioEnabled; }
    bool prefixedWebAudioEnabled() const { return m_values.prefixedWebAudioEnabled; }
    void setPrefixedWebAudioEnabled(bool prefixedWebAudioEnabled) { m_values.prefixedWebAudioEnabled = prefixedWebAudioEnabled; }
    bool webAudioEnabled() const { return m_values.webAudioEnabled; }
    void setWebAudioEnabled(bool webAudioEnabled) { m_values.webAudioEnabled = webAudioEnabled; }
#endif
#if ENABLE(WEB_AUTHN)
    bool webAuthenticationEnabled() const { return m_values.webAuthenticationEnabled; }
    void setWebAuthenticationEnabled(bool webAuthenticationEnabled) { m_values.webAuthenticationEnabled = webAuthenticationEnabled; }
#endif
#if ENABLE(WEB_RTC)
    bool webRTCInsertableStreamsEnabled() const { return m_values.webRTCInsertableStreamsEnabled; }
    void setWebRTCInsertableStreamsEnabled(bool webRTCInsertableStreamsEnabled) { m_values.webRTCInsertableStreamsEnabled = webRTCInsertableStreamsEnabled; }
    bool webRTCPlatformCodecsInGPUProcessEnabled() const { return m_values.webRTCPlatformCodecsInGPUProcessEnabled; }
    void setWebRTCPlatformCodecsInGPUProcessEnabled(bool webRTCPlatformCodecsInGPUProcessEnabled) { m_values.webRTCPlatformCodecsInGPUProcessEnabled = webRTCPlatformCodecsInGPUProcessEnabled; }
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    bool allowsAirPlayForMediaPlayback() const { return m_values.allowsAirPlayForMediaPlayback; }
    void setAllowsAirPlayForMediaPlayback(bool allowsAirPlayForMediaPlayback) { m_values.allowsAirPlayForMediaPlayback = allowsAirPlayForMediaPlayback; }
    bool remotePlaybackEnabled() const { return m_values.remotePlaybackEnabled; }
    void setRemotePlaybackEnabled(bool remotePlaybackEnabled) { m_values.remotePlaybackEnabled = remotePlaybackEnabled; }
#endif
#if PLATFORM(IOS_FAMILY)
    bool allowViewportShrinkToFitContent() const { return m_values.allowViewportShrinkToFitContent; }
    void setAllowViewportShrinkToFitContent(bool allowViewportShrinkToFitContent) { m_values.allowViewportShrinkToFitContent = allowViewportShrinkToFitContent; }
    bool contentChangeObserverEnabled() const { return m_values.contentChangeObserverEnabled; }
    void setContentChangeObserverEnabled(bool contentChangeObserverEnabled) { m_values.contentChangeObserverEnabled = contentChangeObserverEnabled; }
#endif
#if USE(SYSTEM_PREVIEW)
    bool systemPreviewEnabled() const { return m_values.systemPreviewEnabled; }
    void setSystemPreviewEnabled(bool systemPreviewEnabled) { m_values.systemPreviewEnabled = systemPreviewEnabled; }
#endif

    WEBCORE_EXPORT void setAuthorAndUserStylesEnabledInspectorOverride(Optional<bool>);
    WEBCORE_EXPORT void setICECandidateFilteringEnabledInspectorOverride(Optional<bool>);
    WEBCORE_EXPORT void setImagesEnabledInspectorOverride(Optional<bool>);
    void setMediaCaptureRequiresSecureConnectionInspectorOverride(Optional<bool> mediaCaptureRequiresSecureConnectionInspectorOverride) { m_values.mediaCaptureRequiresSecureConnectionInspectorOverride = mediaCaptureRequiresSecureConnectionInspectorOverride; }
    WEBCORE_EXPORT void setMockCaptureDevicesEnabledInspectorOverride(Optional<bool>);
    void setNeedsSiteSpecificQuirksInspectorOverride(Optional<bool> needsSiteSpecificQuirksInspectorOverride) { m_values.needsSiteSpecificQuirksInspectorOverride = needsSiteSpecificQuirksInspectorOverride; }
    void setScriptEnabledInspectorOverride(Optional<bool> scriptEnabledInspectorOverride) { m_values.scriptEnabledInspectorOverride = scriptEnabledInspectorOverride; }
    WEBCORE_EXPORT void setShowDebugBordersInspectorOverride(Optional<bool>);
    WEBCORE_EXPORT void setShowRepaintCounterInspectorOverride(Optional<bool>);
    void setWebRTCEncryptionEnabledInspectorOverride(Optional<bool> webRTCEncryptionEnabledInspectorOverride) { m_values.webRTCEncryptionEnabledInspectorOverride = webRTCEncryptionEnabledInspectorOverride; }
    void setWebSecurityEnabledInspectorOverride(Optional<bool> webSecurityEnabledInspectorOverride) { m_values.webSecurityEnabledInspectorOverride = webSecurityEnabledInspectorOverride; }
    FontGenericFamilies& fontGenericFamilies() final { return m_values.fontGenericFamilies; }
    const FontGenericFamilies& fontGenericFamilies() const final { return m_values.fontGenericFamilies; }

    struct Values {
        void initialize();
        Values isolatedCopy() const;

        Optional<bool> authorAndUserStylesEnabledInspectorOverride;
        Optional<bool> iceCandidateFilteringEnabledInspectorOverride;
        Optional<bool> imagesEnabledInspectorOverride;
        Optional<bool> mediaCaptureRequiresSecureConnectionInspectorOverride;
        Optional<bool> mockCaptureDevicesEnabledInspectorOverride;
        Optional<bool> needsSiteSpecificQuirksInspectorOverride;
        Optional<bool> scriptEnabledInspectorOverride;
        Optional<bool> showDebugBordersInspectorOverride;
        Optional<bool> showRepaintCounterInspectorOverride;
        Optional<bool> webRTCEncryptionEnabledInspectorOverride;
        Optional<bool> webSecurityEnabledInspectorOverride;

        FontGenericFamilies fontGenericFamilies;
        Seconds backForwardCacheExpirationInterval;
        ClipboardAccessPolicy clipboardAccessPolicy;
        double defaultFixedFontSize;
        double defaultFontSize;
        String defaultTextEncodingName;
        String defaultVideoPosterURL;
        uint32_t deviceHeight;
        uint32_t deviceWidth;
        EditableLinkBehavior editableLinkBehavior;
        EditingBehaviorType editingBehaviorType;
        FontLoadTimingOverride fontLoadTimingOverride;
        FontRenderingMode fontRenderingMode;
        ForcedAccessibilityValue forcedColorsAreInvertedAccessibilityValue;
        ForcedAccessibilityValue forcedDisplayIsMonochromeAccessibilityValue;
        ForcedAccessibilityValue forcedPrefersContrastAccessibilityValue;
        ForcedAccessibilityValue forcedPrefersReducedMotionAccessibilityValue;
        ForcedAccessibilityValue forcedSupportsHighDynamicRangeValue;
        FrameFlattening frameFlattening;
        String ftpDirectoryTemplatePath;
        HTMLParserScriptingFlagPolicy htmlParserScriptingFlagPolicy;
        double incrementalRenderingSuppressionTimeoutInSeconds;
        JSC::RuntimeFlags javaScriptRuntimeFlags;
        uint32_t layoutFallbackWidth;
        double layoutViewportHeightExpansionFactor;
        String localStorageDatabasePath;
        double maxParseDuration;
        uint32_t maximumAccelerated2dCanvasSize;
        uint32_t maximumHTMLParserDOMTreeDepth;
        String mediaKeysStorageDirectory;
        String mediaTypeOverride;
        uint32_t minimumAccelerated2dCanvasSize;
        double minimumFontSize;
        double minimumLogicalFontSize;
        double passwordEchoDurationInSeconds;
        PDFImageCachingPolicy pdfImageCachingPolicy;
        MediaPlayerEnums::PitchCorrectionAlgorithm pitchCorrectionAlgorithm;
        uint32_t sessionStorageQuota;
        StorageBlockingPolicy storageBlockingPolicy;
        TextDirection systemLayoutDirection;
        TextDirectionSubmenuInclusionBehavior textDirectionSubmenuInclusionBehavior;
        Seconds timeWithoutMouseMovementBeforeHidingControls;
        UserInterfaceDirectionPolicy userInterfaceDirectionPolicy;
        URL userStyleSheetLocation;
        uint32_t validationMessageTimerMagnification;
        uint32_t visibleDebugOverlayRegions;
#if ENABLE(DATA_DETECTION)
        DataDetectorType dataDetectorTypes;
#endif
#if ENABLE(MEDIA_SOURCE)
        uint32_t maximumSourceBufferSize;
#endif
#if ENABLE(MEDIA_STREAM)
        String mediaDeviceIdentifierStorageDirectory;
#endif
#if ENABLE(TEXT_AUTOSIZING)
        double minimumZoomFontSize;
        uint32_t textAutosizingWindowSizeOverrideHeight;
        uint32_t textAutosizingWindowSizeOverrideWidth;
#endif
        bool CSSOMViewScrollingAPIEnabled : 1;
        bool CSSOMViewSmoothScrollingEnabled : 1;
        bool acceleratedCompositedAnimationsEnabled : 1;
        bool acceleratedCompositingEnabled : 1;
        bool acceleratedCompositingForFixedPositionEnabled : 1;
        bool acceleratedDrawingEnabled : 1;
        bool acceleratedFiltersEnabled : 1;
        bool aggressiveTileRetentionEnabled : 1;
        bool allowContentSecurityPolicySourceStarToMatchAnyProtocol : 1;
        bool allowCrossOriginSubresourcesToAskForCredentials : 1;
        bool allowDisplayOfInsecureContent : 1;
        bool allowFileAccessFromFileURLs : 1;
        bool allowMediaContentTypesRequiringHardwareSupportAsFallback : 1;
        bool allowMultiElementImplicitSubmission : 1;
        bool allowRunningOfInsecureContent : 1;
        bool allowSettingAnyXHRHeaderFromFileURLs : 1;
        bool allowTopNavigationToDataURLs : 1;
        bool allowUniversalAccessFromFileURLs : 1;
        bool allowsInlineMediaPlayback : 1;
        bool allowsInlineMediaPlaybackAfterFullscreen : 1;
        bool allowsPictureInPictureMediaPlayback : 1;
        bool alwaysUseAcceleratedOverflowScroll : 1;
        bool animatedImageAsyncDecodingEnabled : 1;
        bool animatedImageDebugCanvasDrawingEnabled : 1;
        bool appleMailPaginationQuirkEnabled : 1;
        bool aspectRatioEnabled : 1;
        bool aspectRatioOfImgFromWidthAndHeightEnabled : 1;
        bool asyncClipboardAPIEnabled : 1;
        bool asyncFrameScrollingEnabled : 1;
        bool asyncOverflowScrollingEnabled : 1;
        bool asynchronousSpellCheckingEnabled : 1;
        bool audioPlaybackRequiresUserGesture : 1;
        bool authorAndUserStylesEnabled : 1;
        bool autoscrollForDragAndDropEnabled : 1;
        bool backForwardCacheSupportsPlugins : 1;
        bool backgroundShouldExtendBeyondPage : 1;
        bool backspaceKeyNavigationEnabled : 1;
        bool beaconAPIEnabled : 1;
        bool blankAnchorTargetImpliesNoOpenerEnabled : 1;
        bool canvasUsesAcceleratedDrawing : 1;
        bool caretBrowsingEnabled : 1;
        bool clientCoordinatesRelativeToLayoutViewport : 1;
        bool colorFilterEnabled : 1;
        bool constantPropertiesEnabled : 1;
        bool contactPickerAPIEnabled : 1;
        bool contentDispositionAttachmentSandboxEnabled : 1;
        bool cookieEnabled : 1;
        bool coreMathMLEnabled : 1;
        bool crossOriginCheckInGetMatchedCSSRulesDisabled : 1;
        bool cssColor4 : 1;
        bool cssColorContrastEnabled : 1;
        bool cssColorMixEnabled : 1;
        bool cssContainmentEnabled : 1;
        bool cssCustomPropertiesAndValuesEnabled : 1;
        bool cssIndividualTransformPropertiesEnabled : 1;
        bool cssRelativeColorSyntaxEnabled : 1;
        bool dataTransferItemsEnabled : 1;
        bool deferredCSSParserEnabled : 1;
        bool developerExtrasEnabled : 1;
        bool diagnosticLoggingEnabled : 1;
        bool disableScreenSizeOverride : 1;
        bool disabledAdaptationsMetaTagEnabled : 1;
        bool disallowSyncXHRDuringPageDismissalEnabled : 1;
        bool displayListDrawingEnabled : 1;
        bool dnsPrefetchingEnabled : 1;
        bool domPasteAccessRequestsEnabled : 1;
        bool domPasteAllowed : 1;
        bool domTimersThrottlingEnabled : 1;
        bool downloadableBinaryFontsEnabled : 1;
        bool enableInheritURIQueryComponent : 1;
        bool enterKeyHintEnabled : 1;
        bool fixedBackgroundsPaintRelativeToDocument : 1;
        bool fixedElementsLayoutRelativeToFrame : 1;
        bool focusVisibleEnabled : 1;
        bool fontFallbackPrefersPictographs : 1;
        bool forceCompositingMode : 1;
        bool forceFTPDirectoryListings : 1;
        bool forcePendingWebGLPolicy : 1;
        bool forceWebGLUsesLowPower : 1;
        bool geolocationFloorLevelEnabled : 1;
        bool googleAntiFlickerOptimizationQuirkEnabled : 1;
        bool hdrMediaCapabilitiesEnabled : 1;
        bool hiddenPageCSSAnimationSuspensionEnabled : 1;
        bool hiddenPageDOMTimerThrottlingAutoIncreases : 1;
        bool hiddenPageDOMTimerThrottlingEnabled : 1;
        bool httpEquivEnabled : 1;
        bool hyperlinkAuditingEnabled : 1;
        bool iceCandidateFilteringEnabled : 1;
        bool imageSubsamplingEnabled : 1;
        bool imagesEnabled : 1;
        bool inProcessCookieCacheEnabled : 1;
        bool incompleteImageBorderEnabled : 1;
        bool inlineMediaPlaybackRequiresPlaysInlineAttribute : 1;
        bool inputEventsEnabled : 1;
        bool interactiveFormValidationEnabled : 1;
        bool invisibleAutoplayNotPermitted : 1;
        bool isAccessibilityIsolatedTreeEnabled : 1;
        bool isFirstPartyWebsiteDataRemovalDisabled : 1;
        bool isFirstPartyWebsiteDataRemovalLiveOnTestingEnabled : 1;
        bool isFirstPartyWebsiteDataRemovalReproTestingEnabled : 1;
        bool isLoggedInAPIEnabled : 1;
        bool isPerActivityStateCPUUsageMeasurementEnabled : 1;
        bool isPostBackgroundingCPUUsageMeasurementEnabled : 1;
        bool isPostBackgroundingMemoryUsageMeasurementEnabled : 1;
        bool isPostLoadCPUUsageMeasurementEnabled : 1;
        bool isPostLoadMemoryUsageMeasurementEnabled : 1;
        bool isSameSiteStrictEnforcementEnabled : 1;
        bool isThirdPartyCookieBlockingDisabled : 1;
        bool javaEnabled : 1;
        bool javaEnabledForLocalFiles : 1;
        bool javaScriptCanAccessClipboard : 1;
        bool javaScriptCanOpenWindowsAutomatically : 1;
        bool langAttributeAwareFormControlUIEnabled : 1;
        bool largeImageAsyncDecodingEnabled : 1;
        bool lazyIframeLoadingEnabled : 1;
        bool lazyImageLoadingEnabled : 1;
        bool legacyBeforeLoadEventEnabled : 1;
        bool legacyLineLayoutVisualCoverageEnabled : 1;
        bool linkPreconnectEnabled : 1;
        bool linkPrefetchEnabled : 1;
        bool linkPreloadEnabled : 1;
        bool linkPreloadResponsiveImagesEnabled : 1;
        bool liveRangeSelectionEnabled : 1;
        bool loadDeferringEnabled : 1;
        bool loadsImagesAutomatically : 1;
        bool loadsSiteIconsIgnoringImageLoadingSetting : 1;
        bool localFileContentSniffingEnabled : 1;
        bool localStorageEnabled : 1;
        bool logsPageMessagesToSystemConsoleEnabled : 1;
        bool mainContentUserGestureOverrideEnabled : 1;
        bool mediaCapabilitiesEnabled : 1;
        bool mediaCapabilitiesExtensionsEnabled : 1;
        bool mediaControlsScaleWithPageZoom : 1;
        bool mediaDataLoadsAutomatically : 1;
        bool mediaPreloadingEnabled : 1;
        bool mediaSourceEnabled : 1;
        bool mediaUserGestureInheritsFromDocument : 1;
        bool needsAdobeFrameReloadingQuirk : 1;
        bool needsDeferKeyDownAndKeyPressTimersUntilNextEditingCommandQuirk : 1;
        bool needsFrameNameFallbackToIdQuirk : 1;
        bool needsKeyboardEventDisambiguationQuirks : 1;
        bool needsSiteSpecificQuirks : 1;
        bool needsStorageAccessFromFileURLsQuirk : 1;
        bool offlineWebApplicationCacheEnabled : 1;
        bool overscrollBehaviorEnabled : 1;
        bool paginateDuringLayoutEnabled : 1;
        bool passiveTouchListenersAsDefaultOnDocument : 1;
        bool passiveWheelListenersAsDefaultOnDocument : 1;
        bool passwordEchoEnabled : 1;
        bool pluginsEnabled : 1;
        bool preferMIMETypeForImages : 1;
        bool preferPageRenderingUpdatesNear60FPSEnabled : 1;
        bool preventKeyboardDOMEventDispatch : 1;
        bool privateClickMeasurementEnabled : 1;
        bool privateClickMeasurementFraudPreventionEnabled : 1;
        bool punchOutWhiteBackgroundsInDarkMode : 1;
        bool quickTimePluginReplacementEnabled : 1;
        bool referrerPolicyAttributeEnabled : 1;
        bool repaintOutsideLayoutEnabled : 1;
        bool requestAnimationFrameEnabled : 1;
        bool requestIdleCallbackEnabled : 1;
        bool requiresUserGestureToLoadVideo : 1;
        bool resourceLoadSchedulingEnabled : 1;
        bool scriptEnabled : 1;
        bool scriptMarkupEnabled : 1;
        bool scrollingCoordinatorEnabled : 1;
        bool scrollingPerformanceTestingEnabled : 1;
        bool scrollingTreeIncludesFrames : 1;
        bool selectTrailingWhitespaceEnabled : 1;
        bool selectionAcrossShadowBoundariesEnabled : 1;
        bool selectionPaintingWithoutSelectionGapsEnabled : 1;
        bool shouldAllowUserInstalledFonts : 1;
        bool shouldConvertInvalidURLsToBlank : 1;
        bool shouldConvertPositionStyleOnCopy : 1;
        bool shouldDecidePolicyBeforeLoadingQuickLookPreview : 1;
        bool shouldDeferAsynchronousScriptsUntilAfterDocumentLoadOrFirstPaint : 1;
        bool shouldDispatchSyntheticMouseEventsWhenModifyingSelection : 1;
        bool shouldDispatchSyntheticMouseOutAfterSyntheticClick : 1;
        bool shouldIgnoreFontLoadCompletions : 1;
        bool shouldIgnoreMetaViewport : 1;
        bool shouldInjectUserScriptsInInitialEmptyDocument : 1;
        bool shouldPrintBackgrounds : 1;
        bool shouldRespectImageOrientation : 1;
        bool shouldRestrictBaseURLSchemes : 1;
        bool shouldSuppressTextInputFromEditingDuringProvisionalNavigation : 1;
        bool shouldUseServiceWorkerShortTimeout : 1;
        bool showDebugBorders : 1;
        bool showRepaintCounter : 1;
        bool showTiledScrollingIndicator : 1;
        bool showsToolTipOverTruncatedText : 1;
        bool showsURLsInToolTips : 1;
        bool shrinksStandaloneImagesToFit : 1;
        bool simpleLineLayoutEnabled : 1;
        bool smartInsertDeleteEnabled : 1;
        bool spatialNavigationEnabled : 1;
        bool speechRecognitionEnabled : 1;
        bool springTimingFunctionEnabled : 1;
        bool standalone : 1;
        bool storageAccessAPIEnabled : 1;
        bool storageAccessAPIPerPageScopeEnabled : 1;
        bool subpixelAntialiasedLayerTextEnabled : 1;
        bool subresourceIntegrityEnabled : 1;
        bool suppressesIncrementalRendering : 1;
        bool syntheticEditingCommandsEnabled : 1;
        bool telephoneNumberParsingEnabled : 1;
        bool temporaryTileCohortRetentionEnabled : 1;
        bool textAreasAreResizable : 1;
        bool textInteractionEnabled : 1;
        bool thirdPartyIframeRedirectBlockingEnabled : 1;
        bool treatIPAddressAsDomain : 1;
        bool treatsAnyTextCSSLinkAsStylesheet : 1;
        bool undoManagerAPIEnabled : 1;
        bool unhandledPromiseRejectionToConsoleEnabled : 1;
        bool unifiedTextCheckerEnabled : 1;
        bool useAnonymousModeWhenFetchingMaskImages : 1;
        bool useGiantTiles : 1;
        bool useImageDocumentForSubframePDF : 1;
        bool useLegacyBackgroundSizeShorthandBehavior : 1;
        bool useLegacyTextAlignPositionedElementBehavior : 1;
        bool usePreHTML5ParserQuirks : 1;
        bool useThemeColorForScrollAreaBackgroundColor : 1;
        bool usesBackForwardCache : 1;
        bool usesEncodingDetector : 1;
        bool videoPlaybackRequiresUserGesture : 1;
        bool viewportFitEnabled : 1;
        bool visualViewportAPIEnabled : 1;
        bool visualViewportEnabled : 1;
        bool wantsBalancedSetDefersLoadingBehavior : 1;
        bool webAnimationsCompositeOperationsEnabled : 1;
        bool webAnimationsMutableTimelinesEnabled : 1;
        bool webGLEnabled : 1;
        bool webGLErrorsToConsoleEnabled : 1;
        bool webRTCEncryptionEnabled : 1;
        bool webSecurityEnabled : 1;
        bool webShareEnabled : 1;
        bool webShareFileAPIEnabled : 1;
        bool webkitImageReadyEventEnabled : 1;
        bool wheelEventGesturesBecomeNonBlocking : 1;
        bool windowFocusRestricted : 1;
        bool xssAuditorEnabled : 1;
        bool youTubeFlashPluginReplacementEnabled : 1;
#if ENABLE(APPLE_PAY)
        bool applePayCapabilityDisclosureAllowed : 1;
        bool applePayEnabled : 1;
#endif
#if ENABLE(APPLE_PAY_REMOTE_UI)
        bool applePayRemoteUIEnabled : 1;
#endif
#if ENABLE(APP_HIGHLIGHTS)
        bool appHighlightsEnabled : 1;
#endif
#if ENABLE(CORE_IMAGE_ACCELERATED_FILTER_RENDER)
        bool coreImageAcceleratedFilterRenderEnabled : 1;
#endif
#if ENABLE(CSS_TRANSFORM_STYLE_OPTIMIZED_3D)
        bool cssTransformStyleOptimized3DEnabled : 1;
#endif
#if ENABLE(DATA_DETECTION)
#endif
#if ENABLE(DATE_AND_TIME_INPUT_TYPES)
        bool dateTimeInputsEditableComponentsEnabled : 1;
#endif
#if ENABLE(DEVICE_ORIENTATION)
        bool deviceOrientationEventEnabled : 1;
        bool deviceOrientationPermissionAPIEnabled : 1;
#endif
#if ENABLE(DOWNLOAD_ATTRIBUTE)
        bool downloadAttributeEnabled : 1;
#endif
#if ENABLE(ENCRYPTED_MEDIA)
        bool encryptedMediaAPIEnabled : 1;
#endif
#if ENABLE(FULLSCREEN_API)
        bool fullScreenEnabled : 1;
#endif
#if ENABLE(GAMEPAD)
        bool gamepadsEnabled : 1;
#endif
#if ENABLE(INPUT_TYPE_COLOR)
        bool inputTypeColorEnabled : 1;
#endif
#if ENABLE(INPUT_TYPE_DATE)
        bool inputTypeDateEnabled : 1;
#endif
#if ENABLE(INPUT_TYPE_DATETIMELOCAL)
        bool inputTypeDateTimeLocalEnabled : 1;
#endif
#if ENABLE(INPUT_TYPE_MONTH)
        bool inputTypeMonthEnabled : 1;
#endif
#if ENABLE(INPUT_TYPE_TIME)
        bool inputTypeTimeEnabled : 1;
#endif
#if ENABLE(INPUT_TYPE_WEEK)
        bool inputTypeWeekEnabled : 1;
#endif
#if ENABLE(INTERSECTION_OBSERVER)
        bool intersectionObserverEnabled : 1;
#endif
#if ENABLE(IOS_FORM_CONTROL_REFRESH)
        bool iOSFormControlRefreshEnabled : 1;
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
        bool legacyEncryptedMediaAPIEnabled : 1;
#endif
#if ENABLE(MEDIA_CONTROLS_CONTEXT_MENUS)
        bool mediaControlsContextMenusEnabled : 1;
#endif
#if ENABLE(MEDIA_SESSION)
        bool mediaSessionEnabled : 1;
#endif
#if ENABLE(MEDIA_SESSION_COORDINATOR)
        bool mediaSessionCoordinatorEnabled : 1;
#endif
#if ENABLE(MEDIA_SESSION_PLAYLIST)
        bool mediaSessionPlaylistEnabled : 1;
#endif
#if ENABLE(MEDIA_SOURCE)
        bool sourceBufferChangeTypeEnabled : 1;
#endif
#if ENABLE(MEDIA_STREAM)
        bool exposeSpeakersEnabled : 1;
        bool interruptAudioOnPageVisibilityChangeEnabled : 1;
        bool mediaCaptureRequiresSecureConnection : 1;
        bool mediaDevicesEnabled : 1;
        bool mediaRecorderEnabled : 1;
        bool mediaStreamEnabled : 1;
        bool mockCaptureDevicesEnabled : 1;
        bool perElementSpeakerSelectionEnabled : 1;
        bool screenCaptureEnabled : 1;
        bool speakerSelectionRequiresUserGesture : 1;
#endif
#if ENABLE(MODEL_ELEMENT)
        bool modelElementEnabled : 1;
#endif
#if ENABLE(NOTIFICATIONS)
        bool notificationsEnabled : 1;
#endif
#if ENABLE(OVERFLOW_SCROLLING_TOUCH)
        bool legacyOverflowScrollingTouchEnabled : 1;
#endif
#if ENABLE(PAYMENT_REQUEST)
        bool paymentRequestEnabled : 1;
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
        bool pictureInPictureAPIEnabled : 1;
#endif
#if ENABLE(RESIZE_OBSERVER)
        bool resizeObserverEnabled : 1;
#endif
#if ENABLE(RESOURCE_USAGE)
        bool resourceUsageOverlayVisible : 1;
#endif
#if ENABLE(RUBBER_BANDING)
        bool rubberBandingForSubScrollableRegionsEnabled : 1;
#endif
#if ENABLE(SERVICE_CONTROLS)
        bool serviceControlsEnabled : 1;
#endif
#if ENABLE(SMOOTH_SCROLLING)
        bool scrollAnimatorEnabled : 1;
#endif
#if ENABLE(TEXT_AUTOSIZING)
        bool idempotentModeAutosizingOnlyHonorsPercentages : 1;
        bool shouldEnableTextAutosizingBoost : 1;
        bool textAutosizingEnabled : 1;
        bool textAutosizingUsesIdempotentMode : 1;
#endif
#if ENABLE(TOUCH_EVENTS)
        bool touchEventEmulationEnabled : 1;
#endif
#if ENABLE(VIDEO)
        bool genericCueAPIEnabled : 1;
        bool mediaEnabled : 1;
        bool shouldDisplayCaptions : 1;
        bool shouldDisplaySubtitles : 1;
        bool shouldDisplayTextDescriptions : 1;
        bool videoQualityIncludesDisplayCompositingEnabled : 1;
#endif
#if ENABLE(VP9)
        bool vp9DecoderEnabled : 1;
#endif
#if ENABLE(WEB_ARCHIVE)
        bool webArchiveDebugModeEnabled : 1;
#endif
#if ENABLE(WEB_AUDIO)
        bool audioWorkletEnabled : 1;
        bool modernUnprefixedWebAudioEnabled : 1;
        bool prefixedWebAudioEnabled : 1;
        bool webAudioEnabled : 1;
#endif
#if ENABLE(WEB_AUTHN)
        bool webAuthenticationEnabled : 1;
#endif
#if ENABLE(WEB_RTC)
        bool webRTCInsertableStreamsEnabled : 1;
        bool webRTCPlatformCodecsInGPUProcessEnabled : 1;
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
        bool allowsAirPlayForMediaPlayback : 1;
        bool remotePlaybackEnabled : 1;
#endif
#if PLATFORM(IOS_FAMILY)
        bool allowViewportShrinkToFitContent : 1;
        bool contentChangeObserverEnabled : 1;
#endif
#if USE(SYSTEM_PREVIEW)
        bool systemPreviewEnabled : 1;
#endif
    };
    const Values& values() const { return m_values; }

private:
    WEBCORE_EXPORT explicit Settings(Page*);

    Values m_values;
};

}
