/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#pragma once

#include "InspectorBackendDispatcher.h"
#include "InspectorProtocolObjects.h"
#include <tuple>
#include <wtf/Expected.h>
#include <wtf/text/WTFString.h>

namespace Inspector {



#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
class AlternateAnimationBackendDispatcher;
class AlternateApplicationCacheBackendDispatcher;
class AlternateAuditBackendDispatcher;
class AlternateBrowserBackendDispatcher;
#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateCPUProfilerBackendDispatcher;
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateCSSBackendDispatcher;
class AlternateCanvasBackendDispatcher;
class AlternateConsoleBackendDispatcher;
class AlternateDOMBackendDispatcher;
class AlternateDOMDebuggerBackendDispatcher;
class AlternateDOMStorageBackendDispatcher;
class AlternateDatabaseBackendDispatcher;
class AlternateDebuggerBackendDispatcher;
class AlternateDialogBackendDispatcher;
class AlternateEmulationBackendDispatcher;
class AlternateHeapBackendDispatcher;
class AlternateIndexedDBBackendDispatcher;
class AlternateInputBackendDispatcher;
class AlternateInspectorBackendDispatcher;
class AlternateLayerTreeBackendDispatcher;
#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateMemoryBackendDispatcher;
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class AlternateNetworkBackendDispatcher;
class AlternatePageBackendDispatcher;
class AlternatePlaywrightBackendDispatcher;
class AlternateRuntimeBackendDispatcher;
class AlternateScreencastBackendDispatcher;
class AlternateScriptProfilerBackendDispatcher;
#if defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER
class AlternateServiceWorkerBackendDispatcher;
#endif // defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER
class AlternateTargetBackendDispatcher;
class AlternateTimelineBackendDispatcher;
class AlternateWorkerBackendDispatcher;
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)

class JS_EXPORT_PRIVATE AnimationBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::DOM::Styleable> /* effectTarget */> requestEffectTarget(const String& animationId) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::Runtime::RemoteObject> /* object */> resolveAnimation(const String& animationId, const String& opt_objectGroup) = 0;
    virtual Protocol::ErrorStringOr<void> startTracking() = 0;
    virtual Protocol::ErrorStringOr<void> stopTracking() = 0;
protected:
    virtual ~AnimationBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ApplicationCacheBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::ApplicationCache::FrameWithManifest>> /* frameIds */> getFramesWithManifests() = 0;
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<String /* manifestURL */> getManifestForFrame(const String& frameId) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::ApplicationCache::ApplicationCache> /* applicationCache */> getApplicationCacheForFrame(const String& frameId) = 0;
protected:
    virtual ~ApplicationCacheBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE AuditBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> setup(std::optional<int>&& opt_contextId) = 0;
    virtual Protocol::ErrorStringOr<std::tuple<Ref<Protocol::Runtime::RemoteObject> /* result */, std::optional<bool> /* opt_wasThrown */>> run(const String& test, std::optional<int>&& opt_contextId) = 0;
    virtual Protocol::ErrorStringOr<void> teardown() = 0;
protected:
    virtual ~AuditBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE BrowserBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
protected:
    virtual ~BrowserBackendDispatcherHandler();
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class JS_EXPORT_PRIVATE CPUProfilerBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> startTracking() = 0;
    virtual Protocol::ErrorStringOr<void> stopTracking() = 0;
protected:
    virtual ~CPUProfilerBackendDispatcherHandler();
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class JS_EXPORT_PRIVATE CSSBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<std::tuple<RefPtr<JSON::ArrayOf<Protocol::CSS::RuleMatch>> /* opt_matchedCSSRules */, RefPtr<JSON::ArrayOf<Protocol::CSS::PseudoIdMatches>> /* opt_pseudoElements */, RefPtr<JSON::ArrayOf<Protocol::CSS::InheritedStyleEntry>> /* opt_inherited */>> getMatchedStylesForNode(int nodeId, std::optional<bool>&& opt_includePseudo, std::optional<bool>&& opt_includeInherited) = 0;
    virtual Protocol::ErrorStringOr<std::tuple<RefPtr<Protocol::CSS::CSSStyle> /* opt_inlineStyle */, RefPtr<Protocol::CSS::CSSStyle> /* opt_attributesStyle */>> getInlineStylesForNode(int nodeId) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::CSS::CSSComputedStyleProperty>> /* computedStyle */> getComputedStyleForNode(int nodeId) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::CSS::Font> /* primaryFont */> getFontDataForNode(int nodeId) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::CSS::CSSStyleSheetHeader>> /* headers */> getAllStyleSheets() = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::CSS::CSSStyleSheetBody> /* styleSheet */> getStyleSheet(const String& styleSheetId) = 0;
    virtual Protocol::ErrorStringOr<String /* text */> getStyleSheetText(const String& styleSheetId) = 0;
    virtual Protocol::ErrorStringOr<void> setStyleSheetText(const String& styleSheetId, const String& text) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::CSS::CSSStyle> /* style */> setStyleText(Ref<JSON::Object>&& styleId, const String& text) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::CSS::CSSRule> /* rule */> setRuleSelector(Ref<JSON::Object>&& ruleId, const String& selector) = 0;
    virtual Protocol::ErrorStringOr<String /* styleSheetId */> createStyleSheet(const String& frameId) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::CSS::CSSRule> /* rule */> addRule(const String& styleSheetId, const String& selector) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::CSS::CSSPropertyInfo>> /* cssProperties */> getSupportedCSSProperties() = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<String>> /* fontFamilyNames */> getSupportedSystemFontFamilyNames() = 0;
    virtual Protocol::ErrorStringOr<void> forcePseudoState(int nodeId, Ref<JSON::Array>&& forcedPseudoClasses) = 0;
    virtual Protocol::ErrorStringOr<void> setLayoutContextTypeChangedMode(Protocol::CSS::LayoutContextTypeChangedMode mode) = 0;
protected:
    virtual ~CSSBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE CanvasBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<int /* nodeId */> requestNode(const String& canvasId) = 0;
    virtual Protocol::ErrorStringOr<String /* content */> requestContent(const String& canvasId) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<int>> /* clientNodeIds */> requestClientNodes(const String& canvasId) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::Runtime::RemoteObject> /* object */> resolveContext(const String& canvasId, const String& opt_objectGroup) = 0;
    virtual Protocol::ErrorStringOr<void> setRecordingAutoCaptureFrameCount(int count) = 0;
    virtual Protocol::ErrorStringOr<void> startRecording(const String& canvasId, std::optional<int>&& opt_frameCount, std::optional<int>&& opt_memoryLimit) = 0;
    virtual Protocol::ErrorStringOr<void> stopRecording(const String& canvasId) = 0;
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual Protocol::ErrorStringOr<String /* source */> requestShaderSource(const String& programId, Protocol::Canvas::ShaderType shaderType) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual Protocol::ErrorStringOr<void> updateShader(const String& programId, Protocol::Canvas::ShaderType shaderType, const String& source) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual Protocol::ErrorStringOr<void> setShaderProgramDisabled(const String& programId, bool disabled) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    virtual Protocol::ErrorStringOr<void> setShaderProgramHighlighted(const String& programId, bool highlighted) = 0;
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
protected:
    virtual ~CanvasBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ConsoleBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<void> clearMessages() = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::Console::Channel>> /* channels */> getLoggingChannels() = 0;
    virtual Protocol::ErrorStringOr<void> setLoggingChannelLevel(Protocol::Console::ChannelSource source, Protocol::Console::ChannelLevel level) = 0;
protected:
    virtual ~ConsoleBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<Ref<Protocol::DOM::Node> /* root */> getDocument() = 0;
    virtual Protocol::ErrorStringOr<void> requestChildNodes(int nodeId, std::optional<int>&& opt_depth) = 0;
    virtual Protocol::ErrorStringOr<std::optional<int> /* opt_nodeId */> querySelector(int nodeId, const String& selector) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<int>> /* nodeIds */> querySelectorAll(int nodeId, const String& selector) = 0;
    virtual Protocol::ErrorStringOr<int /* nodeId */> setNodeName(int nodeId, const String& name) = 0;
    virtual Protocol::ErrorStringOr<void> setNodeValue(int nodeId, const String& value) = 0;
    virtual Protocol::ErrorStringOr<void> removeNode(int nodeId) = 0;
    virtual Protocol::ErrorStringOr<void> setAttributeValue(int nodeId, const String& name, const String& value) = 0;
    virtual Protocol::ErrorStringOr<void> setAttributesAsText(int nodeId, const String& text, const String& opt_name) = 0;
    virtual Protocol::ErrorStringOr<void> removeAttribute(int nodeId, const String& name) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<String>> /* eventNames */> getSupportedEventNames() = 0;
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::DOM::DataBinding>> /* dataBindings */> getDataBindingsForNode(int nodeId) = 0;
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual Protocol::ErrorStringOr<String /* opt_associatedData */> getAssociatedDataForNode(int nodeId) = 0;
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::DOM::EventListener>> /* listeners */> getEventListenersForNode(int nodeId, std::optional<bool>&& opt_includeAncestors) = 0;
    virtual Protocol::ErrorStringOr<void> setEventListenerDisabled(int eventListenerId, bool disabled) = 0;
    virtual Protocol::ErrorStringOr<void> setBreakpointForEventListener(int eventListenerId, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Protocol::ErrorStringOr<void> removeBreakpointForEventListener(int eventListenerId) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::DOM::AccessibilityProperties> /* properties */> getAccessibilityPropertiesForNode(int nodeId) = 0;
    virtual Protocol::ErrorStringOr<String /* outerHTML */> getOuterHTML(int nodeId) = 0;
    virtual Protocol::ErrorStringOr<void> setOuterHTML(int nodeId, const String& outerHTML) = 0;
    virtual Protocol::ErrorStringOr<void> insertAdjacentHTML(int nodeId, const String& position, const String& html) = 0;
    virtual Protocol::ErrorStringOr<std::tuple<String /* searchId */, int /* resultCount */>> performSearch(const String& query, RefPtr<JSON::Array>&& opt_nodeIds, std::optional<bool>&& opt_caseSensitive) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<int>> /* nodeIds */> getSearchResults(const String& searchId, int fromIndex, int toIndex) = 0;
    virtual Protocol::ErrorStringOr<void> discardSearchResults(const String& searchId) = 0;
    virtual Protocol::ErrorStringOr<int /* nodeId */> requestNode(const String& objectId) = 0;
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    virtual Protocol::ErrorStringOr<void> setInspectModeEnabled(bool enabled, RefPtr<JSON::Object>&& opt_highlightConfig) = 0;
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Protocol::ErrorStringOr<void> setInspectModeEnabled(bool enabled, RefPtr<JSON::Object>&& opt_highlightConfig, std::optional<bool>&& opt_showRulers) = 0;
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Protocol::ErrorStringOr<void> highlightRect(int x, int y, int width, int height, RefPtr<JSON::Object>&& opt_color, RefPtr<JSON::Object>&& opt_outlineColor, std::optional<bool>&& opt_usePageCoordinates) = 0;
    virtual Protocol::ErrorStringOr<void> highlightQuad(Ref<JSON::Array>&& quad, RefPtr<JSON::Object>&& opt_color, RefPtr<JSON::Object>&& opt_outlineColor, std::optional<bool>&& opt_usePageCoordinates) = 0;
    virtual Protocol::ErrorStringOr<void> highlightSelector(Ref<JSON::Object>&& highlightConfig, const String& selectorString, const String& opt_frameId) = 0;
    virtual Protocol::ErrorStringOr<void> highlightNode(Ref<JSON::Object>&& highlightConfig, std::optional<int>&& opt_nodeId, const String& opt_objectId) = 0;
    virtual Protocol::ErrorStringOr<void> highlightNodeList(Ref<JSON::Array>&& nodeIds, Ref<JSON::Object>&& highlightConfig) = 0;
    virtual Protocol::ErrorStringOr<void> hideHighlight() = 0;
    virtual Protocol::ErrorStringOr<void> highlightFrame(const String& frameId, RefPtr<JSON::Object>&& opt_contentColor, RefPtr<JSON::Object>&& opt_contentOutlineColor) = 0;
    virtual Protocol::ErrorStringOr<void> showGridOverlay(int nodeId, Ref<JSON::Object>&& gridColor, std::optional<bool>&& opt_showLineNames, std::optional<bool>&& opt_showLineNumbers, std::optional<bool>&& opt_showExtendedGridLines, std::optional<bool>&& opt_showTrackSizes, std::optional<bool>&& opt_showAreaNames) = 0;
    virtual Protocol::ErrorStringOr<void> hideGridOverlay(std::optional<int>&& opt_nodeId) = 0;
    virtual Protocol::ErrorStringOr<void> showFlexOverlay(int nodeId, Ref<JSON::Object>&& flexColor, std::optional<bool>&& opt_showOrderNumbers) = 0;
    virtual Protocol::ErrorStringOr<void> hideFlexOverlay(std::optional<int>&& opt_nodeId) = 0;
    virtual Protocol::ErrorStringOr<int /* nodeId */> pushNodeByPathToFrontend(const String& path) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::Runtime::RemoteObject> /* object */> resolveNode(std::optional<int>&& opt_nodeId, const String& opt_objectId, const String& opt_frameId, std::optional<int>&& opt_executionContextId, const String& opt_objectGroup) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<String>> /* attributes */> getAttributes(int nodeId) = 0;
    virtual Protocol::ErrorStringOr<int /* nodeId */> moveTo(int nodeId, int targetNodeId, std::optional<int>&& opt_insertBeforeNodeId) = 0;
    virtual Protocol::ErrorStringOr<void> undo() = 0;
    virtual Protocol::ErrorStringOr<void> redo() = 0;
    virtual Protocol::ErrorStringOr<void> markUndoableState() = 0;
    virtual Protocol::ErrorStringOr<void> focus(int nodeId) = 0;
    virtual Protocol::ErrorStringOr<void> setInspectedNode(int nodeId) = 0;
    virtual Protocol::ErrorStringOr<void> setAllowEditingUserAgentShadowTrees(bool allow) = 0;
    virtual Protocol::ErrorStringOr<std::tuple<String /* opt_contentFrameId */, String /* opt_ownerFrameId */>> describeNode(const String& objectId) = 0;
    virtual Protocol::ErrorStringOr<void> scrollIntoViewIfNeeded(const String& objectId, RefPtr<JSON::Object>&& opt_rect) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::DOM::Quad>> /* quads */> getContentQuads(const String& objectId) = 0;
    virtual Protocol::ErrorStringOr<void> setInputFiles(const String& objectId, RefPtr<JSON::Array>&& opt_files, RefPtr<JSON::Array>&& opt_paths) = 0;
protected:
    virtual ~DOMBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMDebuggerBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> setDOMBreakpoint(int nodeId, Protocol::DOMDebugger::DOMBreakpointType type, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Protocol::ErrorStringOr<void> removeDOMBreakpoint(int nodeId, Protocol::DOMDebugger::DOMBreakpointType type) = 0;
    virtual Protocol::ErrorStringOr<void> setEventBreakpoint(Protocol::DOMDebugger::EventBreakpointType breakpointType, const String& opt_eventName, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Protocol::ErrorStringOr<void> removeEventBreakpoint(Protocol::DOMDebugger::EventBreakpointType breakpointType, const String& opt_eventName) = 0;
    virtual Protocol::ErrorStringOr<void> setURLBreakpoint(const String& url, std::optional<bool>&& opt_isRegex, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Protocol::ErrorStringOr<void> removeURLBreakpoint(const String& url, std::optional<bool>&& opt_isRegex) = 0;
protected:
    virtual ~DOMDebuggerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DOMStorageBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::DOMStorage::Item>> /* entries */> getDOMStorageItems(Ref<JSON::Object>&& storageId) = 0;
    virtual Protocol::ErrorStringOr<void> setDOMStorageItem(Ref<JSON::Object>&& storageId, const String& key, const String& value) = 0;
    virtual Protocol::ErrorStringOr<void> removeDOMStorageItem(Ref<JSON::Object>&& storageId, const String& key) = 0;
    virtual Protocol::ErrorStringOr<void> clearDOMStorageItems(Ref<JSON::Object>&& storageId) = 0;
protected:
    virtual ~DOMStorageBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DatabaseBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<String>> /* tableNames */> getDatabaseTableNames(const String& databaseId) = 0;
    class JS_EXPORT_PRIVATE ExecuteSQLCallback : public BackendDispatcher::CallbackBase {
    public:
        ExecuteSQLCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(RefPtr<JSON::ArrayOf<String>>&& opt_columnNames, RefPtr<JSON::ArrayOf<JSON::Value>>&& opt_values, RefPtr<Protocol::Database::Error>&& opt_sqlError);
    };
    virtual void executeSQL(const String& databaseId, const String& query, Ref<ExecuteSQLCallback>&&) = 0;
protected:
    virtual ~DatabaseBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DebuggerBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<void> setAsyncStackTraceDepth(int depth) = 0;
    virtual Protocol::ErrorStringOr<void> setBreakpointsActive(bool active) = 0;
    virtual Protocol::ErrorStringOr<std::tuple<String /* breakpointId */, Ref<JSON::ArrayOf<Protocol::Debugger::Location>> /* locations */>> setBreakpointByUrl(int lineNumber, const String& opt_url, const String& opt_urlRegex, std::optional<int>&& opt_columnNumber, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Protocol::ErrorStringOr<std::tuple<String /* breakpointId */, Ref<Protocol::Debugger::Location> /* actualLocation */>> setBreakpoint(Ref<JSON::Object>&& location, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Protocol::ErrorStringOr<void> removeBreakpoint(const String& breakpointId) = 0;
    virtual Protocol::ErrorStringOr<void> addSymbolicBreakpoint(const String& symbol, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Protocol::ErrorStringOr<void> removeSymbolicBreakpoint(const String& symbol, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual Protocol::ErrorStringOr<void> continueUntilNextRunLoop() = 0;
    virtual Protocol::ErrorStringOr<void> continueToLocation(Ref<JSON::Object>&& location) = 0;
    virtual Protocol::ErrorStringOr<void> stepNext() = 0;
    virtual Protocol::ErrorStringOr<void> stepOver() = 0;
    virtual Protocol::ErrorStringOr<void> stepInto() = 0;
    virtual Protocol::ErrorStringOr<void> stepOut() = 0;
    virtual Protocol::ErrorStringOr<void> pause() = 0;
    virtual Protocol::ErrorStringOr<void> resume() = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::GenericTypes::SearchMatch>> /* result */> searchInContent(const String& scriptId, const String& query, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual Protocol::ErrorStringOr<String /* scriptSource */> getScriptSource(const String& scriptId) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::Debugger::FunctionDetails> /* details */> getFunctionDetails(const String& functionId) = 0;
    virtual Protocol::ErrorStringOr<void> setPauseOnDebuggerStatements(bool enabled, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Protocol::ErrorStringOr<void> setPauseOnExceptions(const String& state, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Protocol::ErrorStringOr<void> setPauseOnAssertions(bool enabled, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Protocol::ErrorStringOr<void> setPauseOnMicrotasks(bool enabled, RefPtr<JSON::Object>&& opt_options) = 0;
    virtual Protocol::ErrorStringOr<void> setPauseForInternalScripts(bool shouldPause) = 0;
    virtual Protocol::ErrorStringOr<std::tuple<Ref<Protocol::Runtime::RemoteObject> /* result */, std::optional<bool> /* opt_wasThrown */, std::optional<int> /* opt_savedResultIndex */>> evaluateOnCallFrame(const String& callFrameId, const String& expression, const String& opt_objectGroup, std::optional<bool>&& opt_includeCommandLineAPI, std::optional<bool>&& opt_doNotPauseOnExceptionsAndMuteConsole, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_saveResult, std::optional<bool>&& opt_emulateUserGesture) = 0;
    virtual Protocol::ErrorStringOr<void> setShouldBlackboxURL(const String& url, bool shouldBlackbox, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual Protocol::ErrorStringOr<void> setBlackboxBreakpointEvaluations(bool blackboxBreakpointEvaluations) = 0;
protected:
    virtual ~DebuggerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE DialogBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<void> handleJavaScriptDialog(bool accept, const String& opt_promptText) = 0;
protected:
    virtual ~DialogBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE EmulationBackendDispatcherHandler {
public:
    class JS_EXPORT_PRIVATE SetDeviceMetricsOverrideCallback : public BackendDispatcher::CallbackBase {
    public:
        SetDeviceMetricsOverrideCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void setDeviceMetricsOverride(int width, int height, bool fixedLayout, std::optional<double>&& opt_deviceScaleFactor, Ref<SetDeviceMetricsOverrideCallback>&&) = 0;
    virtual Protocol::ErrorStringOr<void> setJavaScriptEnabled(bool enabled) = 0;
    virtual Protocol::ErrorStringOr<void> setAuthCredentials(const String& opt_username, const String& opt_password) = 0;
    virtual Protocol::ErrorStringOr<void> setActiveAndFocused(std::optional<bool>&& opt_active) = 0;
    virtual Protocol::ErrorStringOr<void> grantPermissions(const String& origin, Ref<JSON::Array>&& permissions) = 0;
    virtual Protocol::ErrorStringOr<void> resetPermissions() = 0;
protected:
    virtual ~EmulationBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE HeapBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<void> gc() = 0;
    virtual Protocol::ErrorStringOr<std::tuple<double /* timestamp */, String /* snapshotData */>> snapshot() = 0;
    virtual Protocol::ErrorStringOr<void> startTracking() = 0;
    virtual Protocol::ErrorStringOr<void> stopTracking() = 0;
    virtual Protocol::ErrorStringOr<std::tuple<String /* opt_string */, RefPtr<Protocol::Debugger::FunctionDetails> /* opt_functionDetails */, RefPtr<Protocol::Runtime::ObjectPreview> /* opt_preview */>> getPreview(int heapObjectId) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::Runtime::RemoteObject> /* result */> getRemoteObject(int heapObjectId, const String& opt_objectGroup) = 0;
protected:
    virtual ~HeapBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE IndexedDBBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    class JS_EXPORT_PRIVATE RequestDatabaseNamesCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDatabaseNamesCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<JSON::ArrayOf<String>>&& databaseNames);
    };
    virtual void requestDatabaseNames(const String& securityOrigin, Ref<RequestDatabaseNamesCallback>&&) = 0;
    class JS_EXPORT_PRIVATE RequestDatabaseCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDatabaseCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<Protocol::IndexedDB::DatabaseWithObjectStores>&& databaseWithObjectStores);
    };
    virtual void requestDatabase(const String& securityOrigin, const String& databaseName, Ref<RequestDatabaseCallback>&&) = 0;
    class JS_EXPORT_PRIVATE RequestDataCallback : public BackendDispatcher::CallbackBase {
    public:
        RequestDataCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<JSON::ArrayOf<Protocol::IndexedDB::DataEntry>>&& objectStoreDataEntries, bool hasMore);
    };
    virtual void requestData(const String& securityOrigin, const String& databaseName, const String& objectStoreName, const String& indexName, int skipCount, int pageSize, RefPtr<JSON::Object>&& opt_keyRange, Ref<RequestDataCallback>&&) = 0;
    class JS_EXPORT_PRIVATE ClearObjectStoreCallback : public BackendDispatcher::CallbackBase {
    public:
        ClearObjectStoreCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void clearObjectStore(const String& securityOrigin, const String& databaseName, const String& objectStoreName, Ref<ClearObjectStoreCallback>&&) = 0;
protected:
    virtual ~IndexedDBBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE InputBackendDispatcherHandler {
public:
    class JS_EXPORT_PRIVATE DispatchKeyEventCallback : public BackendDispatcher::CallbackBase {
    public:
        DispatchKeyEventCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void dispatchKeyEvent(const String& type, std::optional<int>&& opt_modifiers, const String& opt_text, const String& opt_unmodifiedText, const String& opt_code, const String& opt_key, std::optional<int>&& opt_windowsVirtualKeyCode, std::optional<int>&& opt_nativeVirtualKeyCode, std::optional<bool>&& opt_autoRepeat, std::optional<bool>&& opt_isKeypad, std::optional<bool>&& opt_isSystemKey, RefPtr<JSON::Array>&& opt_macCommands, Ref<DispatchKeyEventCallback>&&) = 0;
    class JS_EXPORT_PRIVATE DispatchMouseEventCallback : public BackendDispatcher::CallbackBase {
    public:
        DispatchMouseEventCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void dispatchMouseEvent(const String& type, int x, int y, std::optional<int>&& opt_modifiers, const String& opt_button, std::optional<int>&& opt_buttons, std::optional<int>&& opt_clickCount, std::optional<int>&& opt_deltaX, std::optional<int>&& opt_deltaY, Ref<DispatchMouseEventCallback>&&) = 0;
    class JS_EXPORT_PRIVATE DispatchWheelEventCallback : public BackendDispatcher::CallbackBase {
    public:
        DispatchWheelEventCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void dispatchWheelEvent(int x, int y, std::optional<int>&& opt_modifiers, std::optional<int>&& opt_deltaX, std::optional<int>&& opt_deltaY, Ref<DispatchWheelEventCallback>&&) = 0;
    class JS_EXPORT_PRIVATE DispatchTapEventCallback : public BackendDispatcher::CallbackBase {
    public:
        DispatchTapEventCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void dispatchTapEvent(int x, int y, std::optional<int>&& opt_modifiers, Ref<DispatchTapEventCallback>&&) = 0;
protected:
    virtual ~InputBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE InspectorBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<void> initialized() = 0;
protected:
    virtual ~InspectorBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE LayerTreeBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::LayerTree::Layer>> /* layers */> layersForNode(int nodeId) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::LayerTree::CompositingReasons> /* compositingReasons */> reasonsForCompositingLayer(const String& layerId) = 0;
protected:
    virtual ~LayerTreeBackendDispatcherHandler();
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class JS_EXPORT_PRIVATE MemoryBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<void> startTracking() = 0;
    virtual Protocol::ErrorStringOr<void> stopTracking() = 0;
protected:
    virtual ~MemoryBackendDispatcherHandler();
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class JS_EXPORT_PRIVATE NetworkBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<void> setExtraHTTPHeaders(Ref<JSON::Object>&& headers) = 0;
    virtual Protocol::ErrorStringOr<std::tuple<String /* body */, bool /* base64Encoded */>> getResponseBody(const String& requestId) = 0;
    virtual Protocol::ErrorStringOr<void> setResourceCachingDisabled(bool disabled) = 0;
    class JS_EXPORT_PRIVATE LoadResourceCallback : public BackendDispatcher::CallbackBase {
    public:
        LoadResourceCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& content, const String& mimeType, int status);
    };
    virtual void loadResource(const String& frameId, const String& url, Ref<LoadResourceCallback>&&) = 0;
    virtual Protocol::ErrorStringOr<String /* serializedCertificate */> getSerializedCertificate(const String& requestId) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::Runtime::RemoteObject> /* object */> resolveWebSocket(const String& requestId, const String& opt_objectGroup) = 0;
    virtual Protocol::ErrorStringOr<void> setInterceptionEnabled(bool enabled) = 0;
    virtual Protocol::ErrorStringOr<void> addInterception(const String& url, Protocol::Network::NetworkStage stage, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual Protocol::ErrorStringOr<void> removeInterception(const String& url, Protocol::Network::NetworkStage stage, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
    virtual Protocol::ErrorStringOr<void> interceptContinue(const String& requestId, Protocol::Network::NetworkStage stage) = 0;
    virtual Protocol::ErrorStringOr<void> interceptWithRequest(const String& requestId, const String& opt_url, const String& opt_method, RefPtr<JSON::Object>&& opt_headers, const String& opt_postData) = 0;
    virtual Protocol::ErrorStringOr<void> interceptWithResponse(const String& requestId, const String& content, bool base64Encoded, const String& opt_mimeType, std::optional<int>&& opt_status, const String& opt_statusText, RefPtr<JSON::Object>&& opt_headers) = 0;
    virtual Protocol::ErrorStringOr<void> interceptRequestWithResponse(const String& requestId, const String& content, bool base64Encoded, const String& mimeType, int status, const String& statusText, Ref<JSON::Object>&& headers) = 0;
    virtual Protocol::ErrorStringOr<void> interceptRequestWithError(const String& requestId, Protocol::Network::ResourceErrorType errorType) = 0;
#if defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
    virtual Protocol::ErrorStringOr<void> setEmulatedConditions(std::optional<int>&& opt_bytesPerSecondLimit) = 0;
#endif // defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
    virtual Protocol::ErrorStringOr<void> setEmulateOfflineState(bool offline) = 0;
protected:
    virtual ~NetworkBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE PageBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<void> reload(std::optional<bool>&& opt_ignoreCache, std::optional<bool>&& opt_revalidateAllResources) = 0;
    virtual Protocol::ErrorStringOr<void> goBack() = 0;
    virtual Protocol::ErrorStringOr<void> goForward() = 0;
    virtual Protocol::ErrorStringOr<void> navigate(const String& url) = 0;
    virtual Protocol::ErrorStringOr<void> overrideUserAgent(const String& opt_value) = 0;
    virtual Protocol::ErrorStringOr<void> overridePlatform(const String& opt_value) = 0;
    virtual Protocol::ErrorStringOr<void> overrideSetting(Protocol::Page::Setting setting, std::optional<bool>&& opt_value) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::Page::Cookie>> /* cookies */> getCookies() = 0;
    virtual Protocol::ErrorStringOr<void> setCookie(Ref<JSON::Object>&& cookie) = 0;
    virtual Protocol::ErrorStringOr<void> deleteCookie(const String& cookieName, const String& url) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::Page::FrameResourceTree> /* frameTree */> getResourceTree() = 0;
    virtual Protocol::ErrorStringOr<std::tuple<String /* content */, bool /* base64Encoded */>> getResourceContent(const String& frameId, const String& url) = 0;
    virtual Protocol::ErrorStringOr<void> setBootstrapScript(const String& opt_source, const String& opt_worldName) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::GenericTypes::SearchMatch>> /* result */> searchInResource(const String& frameId, const String& url, const String& query, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex, const String& opt_requestId) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::Page::SearchResult>> /* result */> searchInResources(const String& text, std::optional<bool>&& opt_caseSensitive, std::optional<bool>&& opt_isRegex) = 0;
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Protocol::ErrorStringOr<void> setShowRulers(bool result) = 0;
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    virtual Protocol::ErrorStringOr<void> setShowPaintRects(bool result) = 0;
    virtual Protocol::ErrorStringOr<void> setEmulatedMedia(const String& media) = 0;
#if (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
    virtual Protocol::ErrorStringOr<void> setForcedAppearance(std::optional<Protocol::Page::Appearance>&& opt_appearance) = 0;
#endif // (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
    virtual Protocol::ErrorStringOr<void> setForcedReducedMotion(std::optional<Protocol::Page::ReducedMotion>&& opt_reducedMotion) = 0;
    virtual Protocol::ErrorStringOr<void> setForcedColors(std::optional<Protocol::Page::ForcedColors>&& opt_forcedColors) = 0;
    virtual Protocol::ErrorStringOr<void> setTimeZone(const String& opt_timeZone) = 0;
    virtual Protocol::ErrorStringOr<void> setTouchEmulationEnabled(bool enabled) = 0;
    virtual Protocol::ErrorStringOr<String /* dataURL */> snapshotNode(int nodeId) = 0;
    virtual Protocol::ErrorStringOr<String /* dataURL */> snapshotRect(int x, int y, int width, int height, Protocol::Page::CoordinateSystem coordinateSystem, std::optional<bool>&& opt_omitDeviceScaleFactor) = 0;
#if (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
    virtual Protocol::ErrorStringOr<String /* data */> archive() = 0;
#endif // (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
    virtual Protocol::ErrorStringOr<void> setScreenSizeOverride(std::optional<int>&& opt_width, std::optional<int>&& opt_height) = 0;
    virtual Protocol::ErrorStringOr<void> insertText(const String& text) = 0;
    virtual Protocol::ErrorStringOr<void> setComposition(const String& text, int selectionStart, int selectionLength, std::optional<int>&& opt_replacementStart, std::optional<int>&& opt_replacementLength) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::Page::AXNode> /* axNode */> accessibilitySnapshot(const String& opt_objectId) = 0;
    virtual Protocol::ErrorStringOr<void> setInterceptFileChooserDialog(bool enabled) = 0;
    virtual Protocol::ErrorStringOr<void> setDefaultBackgroundColorOverride(RefPtr<JSON::Object>&& opt_color) = 0;
    virtual Protocol::ErrorStringOr<void> createUserWorld(const String& name) = 0;
    virtual Protocol::ErrorStringOr<void> setBypassCSP(bool enabled) = 0;
    virtual Protocol::ErrorStringOr<void> crash() = 0;
    virtual Protocol::ErrorStringOr<void> setOrientationOverride(std::optional<int>&& opt_angle) = 0;
    virtual Protocol::ErrorStringOr<void> setVisibleContentRects(RefPtr<JSON::Object>&& opt_unobscuredContentRect, RefPtr<JSON::Object>&& opt_contentInsets, RefPtr<JSON::Object>&& opt_obscuredInsets, RefPtr<JSON::Object>&& opt_unobscuredInsets) = 0;
    virtual Protocol::ErrorStringOr<void> updateScrollingState() = 0;
protected:
    virtual ~PageBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE PlaywrightBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    class JS_EXPORT_PRIVATE CloseCallback : public BackendDispatcher::CallbackBase {
    public:
        CloseCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void close(Ref<CloseCallback>&&) = 0;
    virtual Protocol::ErrorStringOr<String /* browserContextId */> createContext(const String& opt_proxyServer, const String& opt_proxyBypassList) = 0;
    class JS_EXPORT_PRIVATE DeleteContextCallback : public BackendDispatcher::CallbackBase {
    public:
        DeleteContextCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void deleteContext(const String& browserContextId, Ref<DeleteContextCallback>&&) = 0;
    virtual Protocol::ErrorStringOr<String /* pageProxyId */> createPage(const String& opt_browserContextId) = 0;
    class JS_EXPORT_PRIVATE NavigateCallback : public BackendDispatcher::CallbackBase {
    public:
        NavigateCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(const String& opt_loaderId);
    };
    virtual void navigate(const String& url, const String& pageProxyId, const String& opt_frameId, const String& opt_referrer, Ref<NavigateCallback>&&) = 0;
    virtual Protocol::ErrorStringOr<void> grantFileReadAccess(const String& pageProxyId, Ref<JSON::Array>&& paths) = 0;
    virtual Protocol::ErrorStringOr<void> setIgnoreCertificateErrors(const String& opt_browserContextId, bool ignore) = 0;
    class JS_EXPORT_PRIVATE GetAllCookiesCallback : public BackendDispatcher::CallbackBase {
    public:
        GetAllCookiesCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<JSON::ArrayOf<Protocol::Playwright::Cookie>>&& cookies);
    };
    virtual void getAllCookies(const String& opt_browserContextId, Ref<GetAllCookiesCallback>&&) = 0;
    class JS_EXPORT_PRIVATE SetCookiesCallback : public BackendDispatcher::CallbackBase {
    public:
        SetCookiesCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void setCookies(const String& opt_browserContextId, Ref<JSON::Array>&& cookies, Ref<SetCookiesCallback>&&) = 0;
    class JS_EXPORT_PRIVATE DeleteAllCookiesCallback : public BackendDispatcher::CallbackBase {
    public:
        DeleteAllCookiesCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void deleteAllCookies(const String& opt_browserContextId, Ref<DeleteAllCookiesCallback>&&) = 0;
    virtual Protocol::ErrorStringOr<void> setGeolocationOverride(const String& opt_browserContextId, RefPtr<JSON::Object>&& opt_geolocation) = 0;
    virtual Protocol::ErrorStringOr<void> setLanguages(Ref<JSON::Array>&& languages, const String& opt_browserContextId) = 0;
    virtual Protocol::ErrorStringOr<void> setDownloadBehavior(const String& opt_behavior, const String& opt_downloadPath, const String& opt_browserContextId) = 0;
    virtual Protocol::ErrorStringOr<void> cancelDownload(const String& uuid) = 0;
protected:
    virtual ~PlaywrightBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE RuntimeBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<std::tuple<Protocol::Runtime::SyntaxErrorType /* result */, String /* opt_message */, RefPtr<Protocol::Runtime::ErrorRange> /* opt_range */>> parse(const String& source) = 0;
    virtual Protocol::ErrorStringOr<std::tuple<Ref<Protocol::Runtime::RemoteObject> /* result */, std::optional<bool> /* opt_wasThrown */, std::optional<int> /* opt_savedResultIndex */>> evaluate(const String& expression, const String& opt_objectGroup, std::optional<bool>&& opt_includeCommandLineAPI, std::optional<bool>&& opt_doNotPauseOnExceptionsAndMuteConsole, std::optional<int>&& opt_contextId, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_saveResult, std::optional<bool>&& opt_emulateUserGesture) = 0;
    class JS_EXPORT_PRIVATE AwaitPromiseCallback : public BackendDispatcher::CallbackBase {
    public:
        AwaitPromiseCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<Protocol::Runtime::RemoteObject>&& result, std::optional<bool>&& opt_wasThrown, std::optional<int>&& opt_savedResultIndex);
    };
    virtual void awaitPromise(const String& promiseObjectId, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_saveResult, Ref<AwaitPromiseCallback>&&) = 0;
    class JS_EXPORT_PRIVATE CallFunctionOnCallback : public BackendDispatcher::CallbackBase {
    public:
        CallFunctionOnCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess(Ref<Protocol::Runtime::RemoteObject>&& result, std::optional<bool>&& opt_wasThrown);
    };
    virtual void callFunctionOn(const String& objectId, const String& functionDeclaration, RefPtr<JSON::Array>&& opt_arguments, std::optional<bool>&& opt_doNotPauseOnExceptionsAndMuteConsole, std::optional<bool>&& opt_returnByValue, std::optional<bool>&& opt_generatePreview, std::optional<bool>&& opt_emulateUserGesture, std::optional<bool>&& opt_awaitPromise, Ref<CallFunctionOnCallback>&&) = 0;
    virtual Protocol::ErrorStringOr<void> addBinding(const String& name) = 0;
    virtual Protocol::ErrorStringOr<Ref<Protocol::Runtime::ObjectPreview> /* preview */> getPreview(const String& objectId) = 0;
    virtual Protocol::ErrorStringOr<std::tuple<Ref<JSON::ArrayOf<Protocol::Runtime::PropertyDescriptor>> /* properties */, RefPtr<JSON::ArrayOf<Protocol::Runtime::InternalPropertyDescriptor>> /* opt_internalProperties */>> getProperties(const String& objectId, std::optional<bool>&& opt_ownProperties, std::optional<int>&& opt_fetchStart, std::optional<int>&& opt_fetchCount, std::optional<bool>&& opt_generatePreview) = 0;
    virtual Protocol::ErrorStringOr<std::tuple<Ref<JSON::ArrayOf<Protocol::Runtime::PropertyDescriptor>> /* properties */, RefPtr<JSON::ArrayOf<Protocol::Runtime::InternalPropertyDescriptor>> /* opt_internalProperties */>> getDisplayableProperties(const String& objectId, std::optional<int>&& opt_fetchStart, std::optional<int>&& opt_fetchCount, std::optional<bool>&& opt_generatePreview) = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::Runtime::CollectionEntry>> /* entries */> getCollectionEntries(const String& objectId, const String& opt_objectGroup, std::optional<int>&& opt_fetchStart, std::optional<int>&& opt_fetchCount) = 0;
    virtual Protocol::ErrorStringOr<std::optional<int> /* opt_savedResultIndex */> saveResult(Ref<JSON::Object>&& value, std::optional<int>&& opt_contextId) = 0;
    virtual Protocol::ErrorStringOr<void> setSavedResultAlias(const String& opt_alias) = 0;
    virtual Protocol::ErrorStringOr<void> releaseObject(const String& objectId) = 0;
    virtual Protocol::ErrorStringOr<void> releaseObjectGroup(const String& objectGroup) = 0;
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::Runtime::TypeDescription>> /* types */> getRuntimeTypesForVariablesAtOffsets(Ref<JSON::Array>&& locations) = 0;
    virtual Protocol::ErrorStringOr<void> enableTypeProfiler() = 0;
    virtual Protocol::ErrorStringOr<void> disableTypeProfiler() = 0;
    virtual Protocol::ErrorStringOr<void> enableControlFlowProfiler() = 0;
    virtual Protocol::ErrorStringOr<void> disableControlFlowProfiler() = 0;
    virtual Protocol::ErrorStringOr<Ref<JSON::ArrayOf<Protocol::Runtime::BasicBlock>> /* basicBlocks */> getBasicBlocks(const String& sourceID) = 0;
protected:
    virtual ~RuntimeBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ScreencastBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<String /* screencastId */> startVideo(const String& file, int width, int height, int toolbarHeight) = 0;
    class JS_EXPORT_PRIVATE StopVideoCallback : public BackendDispatcher::CallbackBase {
    public:
        StopVideoCallback(Ref<BackendDispatcher>&&, int id);
        void sendSuccess();
    };
    virtual void stopVideo(Ref<StopVideoCallback>&&) = 0;
    virtual Protocol::ErrorStringOr<int /* generation */> startScreencast(int width, int height, int toolbarHeight, int quality) = 0;
    virtual Protocol::ErrorStringOr<void> stopScreencast() = 0;
    virtual Protocol::ErrorStringOr<void> screencastFrameAck(int generation) = 0;
protected:
    virtual ~ScreencastBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE ScriptProfilerBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> startTracking(std::optional<bool>&& opt_includeSamples) = 0;
    virtual Protocol::ErrorStringOr<void> stopTracking() = 0;
protected:
    virtual ~ScriptProfilerBackendDispatcherHandler();
};

#if defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER
class JS_EXPORT_PRIVATE ServiceWorkerBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<Ref<Protocol::ServiceWorker::Configuration> /* info */> getInitializationInfo() = 0;
protected:
    virtual ~ServiceWorkerBackendDispatcherHandler();
};
#endif // defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER

class JS_EXPORT_PRIVATE TargetBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> setPauseOnStart(bool pauseOnStart) = 0;
    virtual Protocol::ErrorStringOr<void> resume(const String& targetId) = 0;
    virtual Protocol::ErrorStringOr<void> sendMessageToTarget(const String& targetId, const String& message) = 0;
    virtual Protocol::ErrorStringOr<void> activate(const String& targetId) = 0;
    virtual Protocol::ErrorStringOr<void> close(const String& targetId, std::optional<bool>&& opt_runBeforeUnload) = 0;
protected:
    virtual ~TargetBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE TimelineBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<void> start(std::optional<int>&& opt_maxCallStackDepth) = 0;
    virtual Protocol::ErrorStringOr<void> stop() = 0;
    virtual Protocol::ErrorStringOr<void> setAutoCaptureEnabled(bool enabled) = 0;
    virtual Protocol::ErrorStringOr<void> setInstruments(Ref<JSON::Array>&& instruments) = 0;
protected:
    virtual ~TimelineBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE WorkerBackendDispatcherHandler {
public:
    virtual Protocol::ErrorStringOr<void> enable() = 0;
    virtual Protocol::ErrorStringOr<void> disable() = 0;
    virtual Protocol::ErrorStringOr<void> initialized(const String& workerId) = 0;
    virtual Protocol::ErrorStringOr<void> sendMessageToWorker(const String& workerId, const String& message) = 0;
protected:
    virtual ~WorkerBackendDispatcherHandler();
};

class JS_EXPORT_PRIVATE AnimationBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<AnimationBackendDispatcher> create(BackendDispatcher&, AnimationBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestEffectTarget(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveAnimation(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void startTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateAnimationBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateAnimationBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    AnimationBackendDispatcher(BackendDispatcher&, AnimationBackendDispatcherHandler*);
    AnimationBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE ApplicationCacheBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ApplicationCacheBackendDispatcher> create(BackendDispatcher&, ApplicationCacheBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void getFramesWithManifests(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getManifestForFrame(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getApplicationCacheForFrame(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateApplicationCacheBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateApplicationCacheBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    ApplicationCacheBackendDispatcher(BackendDispatcher&, ApplicationCacheBackendDispatcherHandler*);
    ApplicationCacheBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE AuditBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<AuditBackendDispatcher> create(BackendDispatcher&, AuditBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void setup(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void run(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void teardown(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateAuditBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateAuditBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    AuditBackendDispatcher(BackendDispatcher&, AuditBackendDispatcherHandler*);
    AuditBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE BrowserBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<BrowserBackendDispatcher> create(BackendDispatcher&, BrowserBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateBrowserBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateBrowserBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    BrowserBackendDispatcher(BackendDispatcher&, BrowserBackendDispatcherHandler*);
    BrowserBackendDispatcherHandler* m_agent { nullptr };
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class JS_EXPORT_PRIVATE CPUProfilerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<CPUProfilerBackendDispatcher> create(BackendDispatcher&, CPUProfilerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void startTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateCPUProfilerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateCPUProfilerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    CPUProfilerBackendDispatcher(BackendDispatcher&, CPUProfilerBackendDispatcherHandler*);
    CPUProfilerBackendDispatcherHandler* m_agent { nullptr };
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class JS_EXPORT_PRIVATE CSSBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<CSSBackendDispatcher> create(BackendDispatcher&, CSSBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getMatchedStylesForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getInlineStylesForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getComputedStyleForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getFontDataForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getAllStyleSheets(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getStyleSheet(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getStyleSheetText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setStyleSheetText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setStyleText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setRuleSelector(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void createStyleSheet(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addRule(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSupportedCSSProperties(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSupportedSystemFontFamilyNames(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void forcePseudoState(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setLayoutContextTypeChangedMode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateCSSBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateCSSBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    CSSBackendDispatcher(BackendDispatcher&, CSSBackendDispatcherHandler*);
    CSSBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE CanvasBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<CanvasBackendDispatcher> create(BackendDispatcher&, CanvasBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestContent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestClientNodes(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setRecordingAutoCaptureFrameCount(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void startRecording(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopRecording(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    void requestShaderSource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    void updateShader(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    void setShaderProgramDisabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
    void setShaderProgramHighlighted(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateCanvasBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateCanvasBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    CanvasBackendDispatcher(BackendDispatcher&, CanvasBackendDispatcherHandler*);
    CanvasBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE ConsoleBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ConsoleBackendDispatcher> create(BackendDispatcher&, ConsoleBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void clearMessages(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getLoggingChannels(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setLoggingChannelLevel(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateConsoleBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateConsoleBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    ConsoleBackendDispatcher(BackendDispatcher&, ConsoleBackendDispatcherHandler*);
    ConsoleBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DOMBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMBackendDispatcher> create(BackendDispatcher&, DOMBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void getDocument(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestChildNodes(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void querySelector(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void querySelectorAll(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setNodeName(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setNodeValue(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setAttributeValue(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setAttributesAsText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeAttribute(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSupportedEventNames(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    void getDataBindingsForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
#if defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    void getAssociatedDataForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS) && ENABLE_INSPECTOR_ALTERNATE_DISPATCHERS
    void getEventListenersForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setEventListenerDisabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBreakpointForEventListener(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeBreakpointForEventListener(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getAccessibilityPropertiesForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getOuterHTML(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setOuterHTML(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void insertAdjacentHTML(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void performSearch(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSearchResults(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void discardSearchResults(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
    void setInspectModeEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void setInspectModeEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void highlightRect(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void highlightQuad(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void highlightSelector(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void highlightNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void highlightNodeList(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void hideHighlight(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void highlightFrame(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void showGridOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void hideGridOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void showFlexOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void hideFlexOverlay(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void pushNodeByPathToFrontend(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getAttributes(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void moveTo(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void undo(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void redo(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void markUndoableState(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void focus(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setInspectedNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setAllowEditingUserAgentShadowTrees(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void describeNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void scrollIntoViewIfNeeded(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getContentQuads(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setInputFiles(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    DOMBackendDispatcher(BackendDispatcher&, DOMBackendDispatcherHandler*);
    DOMBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DOMDebuggerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMDebuggerBackendDispatcher> create(BackendDispatcher&, DOMDebuggerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void setDOMBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeDOMBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setEventBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeEventBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setURLBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeURLBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMDebuggerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMDebuggerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    DOMDebuggerBackendDispatcher(BackendDispatcher&, DOMDebuggerBackendDispatcherHandler*);
    DOMDebuggerBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DOMStorageBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DOMStorageBackendDispatcher> create(BackendDispatcher&, DOMStorageBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getDOMStorageItems(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setDOMStorageItem(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeDOMStorageItem(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void clearDOMStorageItems(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDOMStorageBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDOMStorageBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    DOMStorageBackendDispatcher(BackendDispatcher&, DOMStorageBackendDispatcherHandler*);
    DOMStorageBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DatabaseBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DatabaseBackendDispatcher> create(BackendDispatcher&, DatabaseBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getDatabaseTableNames(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void executeSQL(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDatabaseBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDatabaseBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    DatabaseBackendDispatcher(BackendDispatcher&, DatabaseBackendDispatcherHandler*);
    DatabaseBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DebuggerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DebuggerBackendDispatcher> create(BackendDispatcher&, DebuggerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setAsyncStackTraceDepth(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBreakpointsActive(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBreakpointByUrl(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addSymbolicBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeSymbolicBreakpoint(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void continueUntilNextRunLoop(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void continueToLocation(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stepNext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stepOver(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stepInto(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stepOut(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void pause(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resume(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void searchInContent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getScriptSource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getFunctionDetails(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setPauseOnDebuggerStatements(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setPauseOnExceptions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setPauseOnAssertions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setPauseOnMicrotasks(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setPauseForInternalScripts(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void evaluateOnCallFrame(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setShouldBlackboxURL(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBlackboxBreakpointEvaluations(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDebuggerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDebuggerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    DebuggerBackendDispatcher(BackendDispatcher&, DebuggerBackendDispatcherHandler*);
    DebuggerBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE DialogBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<DialogBackendDispatcher> create(BackendDispatcher&, DialogBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void handleJavaScriptDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateDialogBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateDialogBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    DialogBackendDispatcher(BackendDispatcher&, DialogBackendDispatcherHandler*);
    DialogBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE EmulationBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<EmulationBackendDispatcher> create(BackendDispatcher&, EmulationBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void setDeviceMetricsOverride(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setJavaScriptEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setAuthCredentials(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setActiveAndFocused(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void grantPermissions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resetPermissions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateEmulationBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateEmulationBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    EmulationBackendDispatcher(BackendDispatcher&, EmulationBackendDispatcherHandler*);
    EmulationBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE HeapBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<HeapBackendDispatcher> create(BackendDispatcher&, HeapBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void gc(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void snapshot(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void startTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getPreview(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getRemoteObject(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateHeapBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateHeapBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    HeapBackendDispatcher(BackendDispatcher&, HeapBackendDispatcherHandler*);
    HeapBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE IndexedDBBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<IndexedDBBackendDispatcher> create(BackendDispatcher&, IndexedDBBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestDatabaseNames(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestDatabase(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void requestData(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void clearObjectStore(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateIndexedDBBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateIndexedDBBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    IndexedDBBackendDispatcher(BackendDispatcher&, IndexedDBBackendDispatcherHandler*);
    IndexedDBBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE InputBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<InputBackendDispatcher> create(BackendDispatcher&, InputBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void dispatchKeyEvent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void dispatchMouseEvent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void dispatchWheelEvent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void dispatchTapEvent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateInputBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateInputBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    InputBackendDispatcher(BackendDispatcher&, InputBackendDispatcherHandler*);
    InputBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE InspectorBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<InspectorBackendDispatcher> create(BackendDispatcher&, InspectorBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void initialized(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateInspectorBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateInspectorBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    InspectorBackendDispatcher(BackendDispatcher&, InspectorBackendDispatcherHandler*);
    InspectorBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE LayerTreeBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<LayerTreeBackendDispatcher> create(BackendDispatcher&, LayerTreeBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void layersForNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void reasonsForCompositingLayer(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateLayerTreeBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateLayerTreeBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    LayerTreeBackendDispatcher(BackendDispatcher&, LayerTreeBackendDispatcherHandler*);
    LayerTreeBackendDispatcherHandler* m_agent { nullptr };
};

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
class JS_EXPORT_PRIVATE MemoryBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<MemoryBackendDispatcher> create(BackendDispatcher&, MemoryBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void startTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateMemoryBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateMemoryBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    MemoryBackendDispatcher(BackendDispatcher&, MemoryBackendDispatcherHandler*);
    MemoryBackendDispatcherHandler* m_agent { nullptr };
};
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

class JS_EXPORT_PRIVATE NetworkBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<NetworkBackendDispatcher> create(BackendDispatcher&, NetworkBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setExtraHTTPHeaders(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getResponseBody(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setResourceCachingDisabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void loadResource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getSerializedCertificate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resolveWebSocket(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setInterceptionEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addInterception(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void removeInterception(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void interceptContinue(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void interceptWithRequest(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void interceptWithResponse(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void interceptRequestWithResponse(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void interceptRequestWithError(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
    void setEmulatedConditions(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // defined(ENABLE_INSPECTOR_NETWORK_THROTTLING) && ENABLE_INSPECTOR_NETWORK_THROTTLING
    void setEmulateOfflineState(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateNetworkBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateNetworkBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    NetworkBackendDispatcher(BackendDispatcher&, NetworkBackendDispatcherHandler*);
    NetworkBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE PageBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<PageBackendDispatcher> create(BackendDispatcher&, PageBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void reload(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void goBack(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void goForward(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void navigate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void overrideUserAgent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void overridePlatform(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void overrideSetting(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void deleteCookie(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getResourceTree(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getResourceContent(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBootstrapScript(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void searchInResource(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void searchInResources(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void setShowRulers(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // !(defined(WTF_PLATFORM_IOS_FAMILY) && WTF_PLATFORM_IOS_FAMILY)
    void setShowPaintRects(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setEmulatedMedia(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
    void setForcedAppearance(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // (defined(ENABLE_DARK_MODE_CSS) && ENABLE_DARK_MODE_CSS) || (defined(HAVE_OS_DARK_MODE_SUPPORT) && HAVE_OS_DARK_MODE_SUPPORT)
    void setForcedReducedMotion(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setForcedColors(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setTimeZone(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setTouchEmulationEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void snapshotNode(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void snapshotRect(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
    void archive(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#endif // (defined(ENABLE_WEB_ARCHIVE) && ENABLE_WEB_ARCHIVE) && (defined(USE_CF) && USE_CF)
    void setScreenSizeOverride(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void insertText(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setComposition(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void accessibilitySnapshot(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setInterceptFileChooserDialog(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setDefaultBackgroundColorOverride(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void createUserWorld(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setBypassCSP(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void crash(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setOrientationOverride(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setVisibleContentRects(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void updateScrollingState(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternatePageBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternatePageBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    PageBackendDispatcher(BackendDispatcher&, PageBackendDispatcherHandler*);
    PageBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE PlaywrightBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<PlaywrightBackendDispatcher> create(BackendDispatcher&, PlaywrightBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void close(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void createContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void deleteContext(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void createPage(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void navigate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void grantFileReadAccess(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setIgnoreCertificateErrors(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getAllCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void deleteAllCookies(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setGeolocationOverride(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setLanguages(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setDownloadBehavior(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void cancelDownload(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternatePlaywrightBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternatePlaywrightBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    PlaywrightBackendDispatcher(BackendDispatcher&, PlaywrightBackendDispatcherHandler*);
    PlaywrightBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE RuntimeBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<RuntimeBackendDispatcher> create(BackendDispatcher&, RuntimeBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void parse(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void evaluate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void awaitPromise(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void callFunctionOn(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void addBinding(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getPreview(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getProperties(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getDisplayableProperties(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getCollectionEntries(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void saveResult(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setSavedResultAlias(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void releaseObject(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void releaseObjectGroup(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getRuntimeTypesForVariablesAtOffsets(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void enableTypeProfiler(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disableTypeProfiler(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void enableControlFlowProfiler(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disableControlFlowProfiler(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void getBasicBlocks(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateRuntimeBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateRuntimeBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    RuntimeBackendDispatcher(BackendDispatcher&, RuntimeBackendDispatcherHandler*);
    RuntimeBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE ScreencastBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ScreencastBackendDispatcher> create(BackendDispatcher&, ScreencastBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void startVideo(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopVideo(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void startScreencast(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopScreencast(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void screencastFrameAck(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateScreencastBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateScreencastBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    ScreencastBackendDispatcher(BackendDispatcher&, ScreencastBackendDispatcherHandler*);
    ScreencastBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE ScriptProfilerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ScriptProfilerBackendDispatcher> create(BackendDispatcher&, ScriptProfilerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void startTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stopTracking(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateScriptProfilerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateScriptProfilerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    ScriptProfilerBackendDispatcher(BackendDispatcher&, ScriptProfilerBackendDispatcherHandler*);
    ScriptProfilerBackendDispatcherHandler* m_agent { nullptr };
};

#if defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER
class JS_EXPORT_PRIVATE ServiceWorkerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<ServiceWorkerBackendDispatcher> create(BackendDispatcher&, ServiceWorkerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void getInitializationInfo(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateServiceWorkerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateServiceWorkerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    ServiceWorkerBackendDispatcher(BackendDispatcher&, ServiceWorkerBackendDispatcherHandler*);
    ServiceWorkerBackendDispatcherHandler* m_agent { nullptr };
};
#endif // defined(ENABLE_SERVICE_WORKER) && ENABLE_SERVICE_WORKER

class JS_EXPORT_PRIVATE TargetBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<TargetBackendDispatcher> create(BackendDispatcher&, TargetBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void setPauseOnStart(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void resume(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void sendMessageToTarget(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void activate(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void close(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateTargetBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateTargetBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    TargetBackendDispatcher(BackendDispatcher&, TargetBackendDispatcherHandler*);
    TargetBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE TimelineBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<TimelineBackendDispatcher> create(BackendDispatcher&, TimelineBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void start(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void stop(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setAutoCaptureEnabled(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void setInstruments(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateTimelineBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateTimelineBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    TimelineBackendDispatcher(BackendDispatcher&, TimelineBackendDispatcherHandler*);
    TimelineBackendDispatcherHandler* m_agent { nullptr };
};

class JS_EXPORT_PRIVATE WorkerBackendDispatcher final : public SupplementalBackendDispatcher {
public:
    static Ref<WorkerBackendDispatcher> create(BackendDispatcher&, WorkerBackendDispatcherHandler*);
    void dispatch(long protocol_requestId, const String& protocol_method, Ref<JSON::Object>&& protocol_message) final;
private:
    void enable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void disable(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void initialized(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
    void sendMessageToWorker(long protocol_requestId, RefPtr<JSON::Object>&& protocol_parameters);
#if ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
public:
    void setAlternateDispatcher(AlternateWorkerBackendDispatcher* alternateDispatcher) { m_alternateDispatcher = alternateDispatcher; }
private:
    AlternateWorkerBackendDispatcher* m_alternateDispatcher { nullptr };
#endif // ENABLE(INSPECTOR_ALTERNATE_DISPATCHERS)
private:
    WorkerBackendDispatcher(BackendDispatcher&, WorkerBackendDispatcherHandler*);
    WorkerBackendDispatcherHandler* m_agent { nullptr };
};

} // namespace Inspector
