/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "Element.h"
#include "JSDOMWrapper.h"
#include "JSNode.h"
#include <JavaScriptCore/Snippet.h>

namespace WebCore {

class WEBCORE_EXPORT JSElement : public JSNode {
public:
    using Base = JSNode;
    using DOMWrapped = Element;
    static JSElement* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<Element>&& impl)
    {
        JSElement* ptr = new (NotNull, JSC::allocateCell<JSElement>(globalObject->vm())) JSElement(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static Element* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::JSType(JSElementType), StructureFlags), info(), JSC::NonArray);
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    template<typename, JSC::SubspaceAccess mode> static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        if constexpr (mode == JSC::SubspaceAccess::Concurrently)
            return nullptr;
        return subspaceForImpl(vm);
    }
    static JSC::GCClient::IsoSubspace* subspaceForImpl(JSC::VM& vm);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);

    // Custom attributes
    JSC::JSValue ariaControlsElements(JSC::JSGlobalObject&) const;
    JSC::JSValue ariaDescribedByElements(JSC::JSGlobalObject&) const;
    JSC::JSValue ariaDetailsElements(JSC::JSGlobalObject&) const;
    JSC::JSValue ariaErrorMessageElements(JSC::JSGlobalObject&) const;
    JSC::JSValue ariaFlowToElements(JSC::JSGlobalObject&) const;
    JSC::JSValue ariaLabelledByElements(JSC::JSGlobalObject&) const;
    JSC::JSValue ariaOwnsElements(JSC::JSGlobalObject&) const;
    Element& wrapped() const
    {
        return static_cast<Element&>(Base::wrapped());
    }
protected:
    JSElement(JSC::Structure*, JSDOMGlobalObject&, Ref<Element>&&);

    void finishCreation(JSC::VM&);
};

WEBCORE_EXPORT JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, Element&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Element* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<Element>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<Element>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

#if ENABLE(JIT)
Ref<JSC::Snippet> checkSubClassSnippetForJSElement();
#endif
template<> struct JSDOMWrapperConverterTraits<Element> {
    using WrapperClass = JSElement;
    using ToWrappedReturnType = Element*;
};

} // namespace WebCore
#include "JSElementCustom.h"
