/*
 * Copyright (c) 2007, 2015, 2022 -2022 Apple Inc. All rights reserved.
 * Copyright (c) 2013 Google Inc. All rights reserved.
 * Copyright (c) 2014, 2015, 2016, 2019, 2022 Apple Inc. All rights reserved.
 * Copyright (c) 2014, 2017 -2017 Apple Inc. All rights reserved.
 * Copyright (c) 2015 Andy VanWagoner <andy@vanwagoner.family>.
 * Copyright (c) 2015 Jordan Harband. All rights reserved.
 * Copyright (c) 2015, 2016 -2016 Apple Inc. All rights reserved.
 * Copyright (c) 2015, 2016 -2016 Yusuke Suzuki <utatane.tea@gmail.com>.
 * Copyright (c) 2015, 2016, 2017 Yusuke Suzuki <utatane.tea@gmail.com>.
 * Copyright (c) 2016 Caitlin Potter <caitp@igalia.com>.
 * Copyright (c) 2016 Yusuke Suzuki <utatane.tea@gmail.com>
 * Copyright (c) 2016, 2017 -2017 Yusuke Suzuki <utatane.tea@gmail.com>.
 * Copyright (c) 2016, 2017, 2018 Oleksandr Skachkov <gskachkov@gmail.com>.
 * Copyright (c) 2016, 2018 -2018 Apple Inc. All rights reserved.
 * Copyright (c) 2016, 2019 -2019 Apple Inc. All rights reserved.
 * Copyright (c) 2017 Caio Lima <ticaiolima@gmail.com>.
 * Copyright (c) 2018 Yusuke Suzuki <yusukesuzuki@slowstart.org>.
 * Copyright (c) 2019 Alexey Shvayka <shvaikalesh@gmail.com>.
 * Copyright (c) 2021 Igalia S.L.
 * Copyright (c) 2022 Jarred Sumner. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

namespace JSC {
class FunctionExecutable;
class VM;

enum class ConstructAbility : uint8_t;
enum class ConstructorKind : uint8_t;
enum class ImplementationVisibility : uint8_t;
}

namespace JSC {

extern const char s_JSCCombinedCode[];

extern const unsigned s_JSCCombinedCodeLength;

/* ArrayConstructor */
extern const char* const s_arrayConstructorOfCode;
extern const int s_arrayConstructorOfCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorOfCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorOfCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorOfCodeImplementationVisibility;
extern const char* const s_arrayConstructorFromCode;
extern const int s_arrayConstructorFromCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorFromCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorFromCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorFromCodeImplementationVisibility;
extern const char* const s_arrayConstructorIsArrayCode;
extern const int s_arrayConstructorIsArrayCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorIsArrayCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorIsArrayCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorIsArrayCodeImplementationVisibility;
extern const char* const s_arrayConstructorDefaultAsyncFromAsyncIteratorCode;
extern const int s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeImplementationVisibility;
extern const char* const s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCode;
extern const int s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeImplementationVisibility;
extern const char* const s_arrayConstructorFromAsyncCode;
extern const int s_arrayConstructorFromAsyncCodeLength;
extern const JSC::ConstructAbility s_arrayConstructorFromAsyncCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayConstructorFromAsyncCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayConstructorFromAsyncCodeImplementationVisibility;

#define JSC_FOREACH_ARRAYCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(of, arrayConstructorOf, 0) \
    macro(from, arrayConstructorFrom, 1) \
    macro(isArray, arrayConstructorIsArray, 1) \
    macro(defaultAsyncFromAsyncIterator, arrayConstructorDefaultAsyncFromAsyncIterator, 4) \
    macro(defaultAsyncFromAsyncArrayLike, arrayConstructorDefaultAsyncFromAsyncArrayLike, 3) \
    macro(fromAsync, arrayConstructorFromAsync, 1) \

/* ArrayIteratorPrototype */
extern const char* const s_arrayIteratorPrototypeNextCode;
extern const int s_arrayIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_arrayIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayIteratorPrototypeNextCodeImplementationVisibility;
extern const char* const s_arrayIteratorPrototypeArrayIteratorNextHelperCode;
extern const int s_arrayIteratorPrototypeArrayIteratorNextHelperCodeLength;
extern const JSC::ConstructAbility s_arrayIteratorPrototypeArrayIteratorNextHelperCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayIteratorPrototypeArrayIteratorNextHelperCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayIteratorPrototypeArrayIteratorNextHelperCodeImplementationVisibility;

#define JSC_FOREACH_ARRAYITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, arrayIteratorPrototypeNext, 0) \
    macro(arrayIteratorNextHelper, arrayIteratorPrototypeArrayIteratorNextHelper, 2) \

/* ArrayPrototype */
extern const char* const s_arrayPrototypeReduceCode;
extern const int s_arrayPrototypeReduceCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeReduceCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeReduceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeReduceCodeImplementationVisibility;
extern const char* const s_arrayPrototypeReduceRightCode;
extern const int s_arrayPrototypeReduceRightCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeReduceRightCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeReduceRightCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeReduceRightCodeImplementationVisibility;
extern const char* const s_arrayPrototypeEveryCode;
extern const int s_arrayPrototypeEveryCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeEveryCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeEveryCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeEveryCodeImplementationVisibility;
extern const char* const s_arrayPrototypeForEachCode;
extern const int s_arrayPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeForEachCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeForEachCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeForEachCodeImplementationVisibility;
extern const char* const s_arrayPrototypeFilterCode;
extern const int s_arrayPrototypeFilterCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFilterCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFilterCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFilterCodeImplementationVisibility;
extern const char* const s_arrayPrototypeGroupCode;
extern const int s_arrayPrototypeGroupCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeGroupCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeGroupCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeGroupCodeImplementationVisibility;
extern const char* const s_arrayPrototypeGroupToMapCode;
extern const int s_arrayPrototypeGroupToMapCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeGroupToMapCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeGroupToMapCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeGroupToMapCodeImplementationVisibility;
extern const char* const s_arrayPrototypeMapCode;
extern const int s_arrayPrototypeMapCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeMapCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeMapCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeMapCodeImplementationVisibility;
extern const char* const s_arrayPrototypeSomeCode;
extern const int s_arrayPrototypeSomeCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeSomeCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeSomeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeSomeCodeImplementationVisibility;
extern const char* const s_arrayPrototypeFillCode;
extern const int s_arrayPrototypeFillCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFillCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFillCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFillCodeImplementationVisibility;
extern const char* const s_arrayPrototypeFindCode;
extern const int s_arrayPrototypeFindCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFindCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFindCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFindCodeImplementationVisibility;
extern const char* const s_arrayPrototypeFindLastCode;
extern const int s_arrayPrototypeFindLastCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFindLastCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFindLastCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFindLastCodeImplementationVisibility;
extern const char* const s_arrayPrototypeFindIndexCode;
extern const int s_arrayPrototypeFindIndexCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFindIndexCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFindIndexCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFindIndexCodeImplementationVisibility;
extern const char* const s_arrayPrototypeFindLastIndexCode;
extern const int s_arrayPrototypeFindLastIndexCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFindLastIndexCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFindLastIndexCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFindLastIndexCodeImplementationVisibility;
extern const char* const s_arrayPrototypeIncludesCode;
extern const int s_arrayPrototypeIncludesCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeIncludesCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeIncludesCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeIncludesCodeImplementationVisibility;
extern const char* const s_arrayPrototypeSortStringComparatorCode;
extern const int s_arrayPrototypeSortStringComparatorCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeSortStringComparatorCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeSortStringComparatorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeSortStringComparatorCodeImplementationVisibility;
extern const char* const s_arrayPrototypeSortCompactCode;
extern const int s_arrayPrototypeSortCompactCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeSortCompactCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeSortCompactCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeSortCompactCodeImplementationVisibility;
extern const char* const s_arrayPrototypeSortCommitCode;
extern const int s_arrayPrototypeSortCommitCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeSortCommitCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeSortCommitCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeSortCommitCodeImplementationVisibility;
extern const char* const s_arrayPrototypeSortMergeCode;
extern const int s_arrayPrototypeSortMergeCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeSortMergeCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeSortMergeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeSortMergeCodeImplementationVisibility;
extern const char* const s_arrayPrototypeSortMergeSortCode;
extern const int s_arrayPrototypeSortMergeSortCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeSortMergeSortCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeSortMergeSortCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeSortMergeSortCodeImplementationVisibility;
extern const char* const s_arrayPrototypeSortBucketSortCode;
extern const int s_arrayPrototypeSortBucketSortCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeSortBucketSortCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeSortBucketSortCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeSortBucketSortCodeImplementationVisibility;
extern const char* const s_arrayPrototypeSortCode;
extern const int s_arrayPrototypeSortCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeSortCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeSortCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeSortCodeImplementationVisibility;
extern const char* const s_arrayPrototypeConcatSlowPathCode;
extern const int s_arrayPrototypeConcatSlowPathCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeConcatSlowPathCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeConcatSlowPathCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeConcatSlowPathCodeImplementationVisibility;
extern const char* const s_arrayPrototypeConcatCode;
extern const int s_arrayPrototypeConcatCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeConcatCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeConcatCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeConcatCodeImplementationVisibility;
extern const char* const s_arrayPrototypeMaxWithPositivesCode;
extern const int s_arrayPrototypeMaxWithPositivesCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeMaxWithPositivesCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeMaxWithPositivesCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeMaxWithPositivesCodeImplementationVisibility;
extern const char* const s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCode;
extern const int s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCodeImplementationVisibility;
extern const char* const s_arrayPrototypeCopyWithinCode;
extern const int s_arrayPrototypeCopyWithinCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeCopyWithinCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeCopyWithinCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeCopyWithinCodeImplementationVisibility;
extern const char* const s_arrayPrototypeFlatIntoArrayCode;
extern const int s_arrayPrototypeFlatIntoArrayCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFlatIntoArrayCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFlatIntoArrayCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFlatIntoArrayCodeImplementationVisibility;
extern const char* const s_arrayPrototypeFlatCode;
extern const int s_arrayPrototypeFlatCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFlatCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFlatCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFlatCodeImplementationVisibility;
extern const char* const s_arrayPrototypeFlatIntoArrayWithCallbackCode;
extern const int s_arrayPrototypeFlatIntoArrayWithCallbackCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFlatIntoArrayWithCallbackCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFlatIntoArrayWithCallbackCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFlatIntoArrayWithCallbackCodeImplementationVisibility;
extern const char* const s_arrayPrototypeFlatMapCode;
extern const int s_arrayPrototypeFlatMapCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeFlatMapCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeFlatMapCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeFlatMapCodeImplementationVisibility;
extern const char* const s_arrayPrototypeAtCode;
extern const int s_arrayPrototypeAtCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeAtCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeAtCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeAtCodeImplementationVisibility;
extern const char* const s_arrayPrototypeToReversedCode;
extern const int s_arrayPrototypeToReversedCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeToReversedCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeToReversedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeToReversedCodeImplementationVisibility;
extern const char* const s_arrayPrototypeToSortedCode;
extern const int s_arrayPrototypeToSortedCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeToSortedCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeToSortedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeToSortedCodeImplementationVisibility;
extern const char* const s_arrayPrototypeToSplicedCode;
extern const int s_arrayPrototypeToSplicedCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeToSplicedCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeToSplicedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeToSplicedCodeImplementationVisibility;
extern const char* const s_arrayPrototypeWithCode;
extern const int s_arrayPrototypeWithCodeLength;
extern const JSC::ConstructAbility s_arrayPrototypeWithCodeConstructAbility;
extern const JSC::ConstructorKind s_arrayPrototypeWithCodeConstructorKind;
extern const JSC::ImplementationVisibility s_arrayPrototypeWithCodeImplementationVisibility;

#define JSC_FOREACH_ARRAYPROTOTYPE_BUILTIN_DATA(macro) \
    macro(reduce, arrayPrototypeReduce, 1) \
    macro(reduceRight, arrayPrototypeReduceRight, 1) \
    macro(every, arrayPrototypeEvery, 1) \
    macro(forEach, arrayPrototypeForEach, 1) \
    macro(filter, arrayPrototypeFilter, 1) \
    macro(group, arrayPrototypeGroup, 1) \
    macro(groupToMap, arrayPrototypeGroupToMap, 1) \
    macro(map, arrayPrototypeMap, 1) \
    macro(some, arrayPrototypeSome, 1) \
    macro(fill, arrayPrototypeFill, 1) \
    macro(find, arrayPrototypeFind, 1) \
    macro(findLast, arrayPrototypeFindLast, 1) \
    macro(findIndex, arrayPrototypeFindIndex, 1) \
    macro(findLastIndex, arrayPrototypeFindLastIndex, 1) \
    macro(includes, arrayPrototypeIncludes, 1) \
    macro(sortStringComparator, arrayPrototypeSortStringComparator, 2) \
    macro(sortCompact, arrayPrototypeSortCompact, 4) \
    macro(sortCommit, arrayPrototypeSortCommit, 4) \
    macro(sortMerge, arrayPrototypeSortMerge, 6) \
    macro(sortMergeSort, arrayPrototypeSortMergeSort, 2) \
    macro(sortBucketSort, arrayPrototypeSortBucketSort, 4) \
    macro(sort, arrayPrototypeSort, 1) \
    macro(concatSlowPath, arrayPrototypeConcatSlowPath, 0) \
    macro(concat, arrayPrototypeConcat, 1) \
    macro(maxWithPositives, arrayPrototypeMaxWithPositives, 2) \
    macro(minWithMaybeNegativeZeroAndPositive, arrayPrototypeMinWithMaybeNegativeZeroAndPositive, 2) \
    macro(copyWithin, arrayPrototypeCopyWithin, 2) \
    macro(flatIntoArray, arrayPrototypeFlatIntoArray, 5) \
    macro(flat, arrayPrototypeFlat, 0) \
    macro(flatIntoArrayWithCallback, arrayPrototypeFlatIntoArrayWithCallback, 6) \
    macro(flatMap, arrayPrototypeFlatMap, 1) \
    macro(at, arrayPrototypeAt, 1) \
    macro(toReversed, arrayPrototypeToReversed, 0) \
    macro(toSorted, arrayPrototypeToSorted, 1) \
    macro(toSpliced, arrayPrototypeToSpliced, 2) \
    macro(with, arrayPrototypeWith, 2) \

/* AsyncFromSyncIteratorPrototype */
extern const char* const s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCode;
extern const int s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeImplementationVisibility;
extern const char* const s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCode;
extern const int s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeImplementationVisibility;
extern const char* const s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCode;
extern const int s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeImplementationVisibility;
extern const char* const s_asyncFromSyncIteratorPrototypeNextCode;
extern const int s_asyncFromSyncIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeNextCodeImplementationVisibility;
extern const char* const s_asyncFromSyncIteratorPrototypeReturnCode;
extern const int s_asyncFromSyncIteratorPrototypeReturnCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeReturnCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeReturnCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeReturnCodeImplementationVisibility;
extern const char* const s_asyncFromSyncIteratorPrototypeThrowCode;
extern const int s_asyncFromSyncIteratorPrototypeThrowCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeThrowCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeThrowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeThrowCodeImplementationVisibility;
extern const char* const s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCode;
extern const int s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeImplementationVisibility;
extern const char* const s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorConstructorCode;
extern const int s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorConstructorCodeLength;
extern const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorConstructorCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorConstructorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorConstructorCodeImplementationVisibility;

#define JSC_FOREACH_ASYNCFROMSYNCITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(asyncFromSyncIteratorOnRejected, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejected, 2) \
    macro(asyncFromSyncIteratorOnFulfilledContinue, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinue, 2) \
    macro(asyncFromSyncIteratorOnFulfilledDone, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDone, 2) \
    macro(next, asyncFromSyncIteratorPrototypeNext, 1) \
    macro(return, asyncFromSyncIteratorPrototypeReturn, 1) \
    macro(throw, asyncFromSyncIteratorPrototypeThrow, 1) \
    macro(createAsyncFromSyncIterator, asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIterator, 2) \
    macro(AsyncFromSyncIterator, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorConstructor, 2) \

/* AsyncFunctionPrototype */
extern const char* const s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCode;
extern const int s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeLength;
extern const JSC::ConstructAbility s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeImplementationVisibility;
extern const char* const s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCode;
extern const int s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeLength;
extern const JSC::ConstructAbility s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeImplementationVisibility;
extern const char* const s_asyncFunctionPrototypeAsyncFunctionResumeCode;
extern const int s_asyncFunctionPrototypeAsyncFunctionResumeCodeLength;
extern const JSC::ConstructAbility s_asyncFunctionPrototypeAsyncFunctionResumeCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncFunctionPrototypeAsyncFunctionResumeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncFunctionPrototypeAsyncFunctionResumeCodeImplementationVisibility;

#define JSC_FOREACH_ASYNCFUNCTIONPROTOTYPE_BUILTIN_DATA(macro) \
    macro(asyncFunctionResumeOnFulfilled, asyncFunctionPrototypeAsyncFunctionResumeOnFulfilled, 2) \
    macro(asyncFunctionResumeOnRejected, asyncFunctionPrototypeAsyncFunctionResumeOnRejected, 2) \
    macro(asyncFunctionResume, asyncFunctionPrototypeAsyncFunctionResume, 3) \

/* AsyncGeneratorPrototype */
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeIsExecutionStateCode;
extern const int s_asyncGeneratorPrototypeIsExecutionStateCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeIsExecutionStateCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeIsExecutionStateCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeIsExecutionStateCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeIsSuspendYieldStateCode;
extern const int s_asyncGeneratorPrototypeIsSuspendYieldStateCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeIsSuspendYieldStateCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeIsSuspendYieldStateCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeIsSuspendYieldStateCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorRejectCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorResolveCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorYieldCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAwaitValueCode;
extern const int s_asyncGeneratorPrototypeAwaitValueCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAwaitValueCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAwaitValueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAwaitValueCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCode;
extern const int s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCode;
extern const int s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCode;
extern const int s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCode;
extern const int s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeNextCode;
extern const int s_asyncGeneratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeNextCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeReturnCode;
extern const int s_asyncGeneratorPrototypeReturnCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeReturnCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeReturnCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeReturnCodeImplementationVisibility;
extern const char* const s_asyncGeneratorPrototypeThrowCode;
extern const int s_asyncGeneratorPrototypeThrowCodeLength;
extern const JSC::ConstructAbility s_asyncGeneratorPrototypeThrowCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncGeneratorPrototypeThrowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncGeneratorPrototypeThrowCodeImplementationVisibility;

#define JSC_FOREACH_ASYNCGENERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(asyncGeneratorQueueIsEmpty, asyncGeneratorPrototypeAsyncGeneratorQueueIsEmpty, 1) \
    macro(asyncGeneratorQueueEnqueue, asyncGeneratorPrototypeAsyncGeneratorQueueEnqueue, 2) \
    macro(asyncGeneratorQueueDequeue, asyncGeneratorPrototypeAsyncGeneratorQueueDequeue, 1) \
    macro(isExecutionState, asyncGeneratorPrototypeIsExecutionState, 1) \
    macro(isSuspendYieldState, asyncGeneratorPrototypeIsSuspendYieldState, 1) \
    macro(asyncGeneratorReject, asyncGeneratorPrototypeAsyncGeneratorReject, 2) \
    macro(asyncGeneratorResolve, asyncGeneratorPrototypeAsyncGeneratorResolve, 3) \
    macro(asyncGeneratorYieldAwaited, asyncGeneratorPrototypeAsyncGeneratorYieldAwaited, 2) \
    macro(asyncGeneratorYieldOnRejected, asyncGeneratorPrototypeAsyncGeneratorYieldOnRejected, 2) \
    macro(asyncGeneratorYield, asyncGeneratorPrototypeAsyncGeneratorYield, 3) \
    macro(awaitValue, asyncGeneratorPrototypeAwaitValue, 3) \
    macro(doAsyncGeneratorBodyCallOnFulfilledNormal, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormal, 2) \
    macro(doAsyncGeneratorBodyCallOnFulfilledReturn, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturn, 2) \
    macro(doAsyncGeneratorBodyCall, asyncGeneratorPrototypeDoAsyncGeneratorBodyCall, 3) \
    macro(asyncGeneratorResumeNextOnFulfilled, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilled, 2) \
    macro(asyncGeneratorResumeNextOnRejected, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejected, 2) \
    macro(asyncGeneratorResumeNext, asyncGeneratorPrototypeAsyncGeneratorResumeNext, 1) \
    macro(asyncGeneratorEnqueue, asyncGeneratorPrototypeAsyncGeneratorEnqueue, 3) \
    macro(next, asyncGeneratorPrototypeNext, 1) \
    macro(return, asyncGeneratorPrototypeReturn, 1) \
    macro(throw, asyncGeneratorPrototypeThrow, 1) \

/* AsyncIteratorPrototype */
extern const char* const s_asyncIteratorPrototypeSymbolAsyncIteratorGetterCode;
extern const int s_asyncIteratorPrototypeSymbolAsyncIteratorGetterCodeLength;
extern const JSC::ConstructAbility s_asyncIteratorPrototypeSymbolAsyncIteratorGetterCodeConstructAbility;
extern const JSC::ConstructorKind s_asyncIteratorPrototypeSymbolAsyncIteratorGetterCodeConstructorKind;
extern const JSC::ImplementationVisibility s_asyncIteratorPrototypeSymbolAsyncIteratorGetterCodeImplementationVisibility;

#define JSC_FOREACH_ASYNCITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(symbolAsyncIteratorGetter, asyncIteratorPrototypeSymbolAsyncIteratorGetter, 0) \

/* DatePrototype */
extern const char* const s_datePrototypeToDateTimeOptionsAnyAllCode;
extern const int s_datePrototypeToDateTimeOptionsAnyAllCodeLength;
extern const JSC::ConstructAbility s_datePrototypeToDateTimeOptionsAnyAllCodeConstructAbility;
extern const JSC::ConstructorKind s_datePrototypeToDateTimeOptionsAnyAllCodeConstructorKind;
extern const JSC::ImplementationVisibility s_datePrototypeToDateTimeOptionsAnyAllCodeImplementationVisibility;
extern const char* const s_datePrototypeToLocaleStringCode;
extern const int s_datePrototypeToLocaleStringCodeLength;
extern const JSC::ConstructAbility s_datePrototypeToLocaleStringCodeConstructAbility;
extern const JSC::ConstructorKind s_datePrototypeToLocaleStringCodeConstructorKind;
extern const JSC::ImplementationVisibility s_datePrototypeToLocaleStringCodeImplementationVisibility;
extern const char* const s_datePrototypeToDateTimeOptionsDateDateCode;
extern const int s_datePrototypeToDateTimeOptionsDateDateCodeLength;
extern const JSC::ConstructAbility s_datePrototypeToDateTimeOptionsDateDateCodeConstructAbility;
extern const JSC::ConstructorKind s_datePrototypeToDateTimeOptionsDateDateCodeConstructorKind;
extern const JSC::ImplementationVisibility s_datePrototypeToDateTimeOptionsDateDateCodeImplementationVisibility;
extern const char* const s_datePrototypeToLocaleDateStringCode;
extern const int s_datePrototypeToLocaleDateStringCodeLength;
extern const JSC::ConstructAbility s_datePrototypeToLocaleDateStringCodeConstructAbility;
extern const JSC::ConstructorKind s_datePrototypeToLocaleDateStringCodeConstructorKind;
extern const JSC::ImplementationVisibility s_datePrototypeToLocaleDateStringCodeImplementationVisibility;
extern const char* const s_datePrototypeToDateTimeOptionsTimeTimeCode;
extern const int s_datePrototypeToDateTimeOptionsTimeTimeCodeLength;
extern const JSC::ConstructAbility s_datePrototypeToDateTimeOptionsTimeTimeCodeConstructAbility;
extern const JSC::ConstructorKind s_datePrototypeToDateTimeOptionsTimeTimeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_datePrototypeToDateTimeOptionsTimeTimeCodeImplementationVisibility;
extern const char* const s_datePrototypeToLocaleTimeStringCode;
extern const int s_datePrototypeToLocaleTimeStringCodeLength;
extern const JSC::ConstructAbility s_datePrototypeToLocaleTimeStringCodeConstructAbility;
extern const JSC::ConstructorKind s_datePrototypeToLocaleTimeStringCodeConstructorKind;
extern const JSC::ImplementationVisibility s_datePrototypeToLocaleTimeStringCodeImplementationVisibility;

#define JSC_FOREACH_DATEPROTOTYPE_BUILTIN_DATA(macro) \
    macro(toDateTimeOptionsAnyAll, datePrototypeToDateTimeOptionsAnyAll, 1) \
    macro(toLocaleString, datePrototypeToLocaleString, 0) \
    macro(toDateTimeOptionsDateDate, datePrototypeToDateTimeOptionsDateDate, 1) \
    macro(toLocaleDateString, datePrototypeToLocaleDateString, 0) \
    macro(toDateTimeOptionsTimeTime, datePrototypeToDateTimeOptionsTimeTime, 1) \
    macro(toLocaleTimeString, datePrototypeToLocaleTimeString, 0) \

/* FunctionPrototype */
extern const char* const s_functionPrototypeCallCode;
extern const int s_functionPrototypeCallCodeLength;
extern const JSC::ConstructAbility s_functionPrototypeCallCodeConstructAbility;
extern const JSC::ConstructorKind s_functionPrototypeCallCodeConstructorKind;
extern const JSC::ImplementationVisibility s_functionPrototypeCallCodeImplementationVisibility;
extern const char* const s_functionPrototypeApplyCode;
extern const int s_functionPrototypeApplyCodeLength;
extern const JSC::ConstructAbility s_functionPrototypeApplyCodeConstructAbility;
extern const JSC::ConstructorKind s_functionPrototypeApplyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_functionPrototypeApplyCodeImplementationVisibility;
extern const char* const s_functionPrototypeSymbolHasInstanceCode;
extern const int s_functionPrototypeSymbolHasInstanceCodeLength;
extern const JSC::ConstructAbility s_functionPrototypeSymbolHasInstanceCodeConstructAbility;
extern const JSC::ConstructorKind s_functionPrototypeSymbolHasInstanceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_functionPrototypeSymbolHasInstanceCodeImplementationVisibility;

#define JSC_FOREACH_FUNCTIONPROTOTYPE_BUILTIN_DATA(macro) \
    macro(call, functionPrototypeCall, 1) \
    macro(apply, functionPrototypeApply, 2) \
    macro(symbolHasInstance, functionPrototypeSymbolHasInstance, 1) \

/* GeneratorPrototype */
extern const char* const s_generatorPrototypeGeneratorResumeCode;
extern const int s_generatorPrototypeGeneratorResumeCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeGeneratorResumeCodeConstructAbility;
extern const JSC::ConstructorKind s_generatorPrototypeGeneratorResumeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_generatorPrototypeGeneratorResumeCodeImplementationVisibility;
extern const char* const s_generatorPrototypeNextCode;
extern const int s_generatorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_generatorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_generatorPrototypeNextCodeImplementationVisibility;
extern const char* const s_generatorPrototypeReturnCode;
extern const int s_generatorPrototypeReturnCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeReturnCodeConstructAbility;
extern const JSC::ConstructorKind s_generatorPrototypeReturnCodeConstructorKind;
extern const JSC::ImplementationVisibility s_generatorPrototypeReturnCodeImplementationVisibility;
extern const char* const s_generatorPrototypeThrowCode;
extern const int s_generatorPrototypeThrowCodeLength;
extern const JSC::ConstructAbility s_generatorPrototypeThrowCodeConstructAbility;
extern const JSC::ConstructorKind s_generatorPrototypeThrowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_generatorPrototypeThrowCodeImplementationVisibility;

#define JSC_FOREACH_GENERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(generatorResume, generatorPrototypeGeneratorResume, 6) \
    macro(next, generatorPrototypeNext, 1) \
    macro(return, generatorPrototypeReturn, 1) \
    macro(throw, generatorPrototypeThrow, 1) \

/* GlobalObject */
extern const char* const s_globalObjectIsFiniteCode;
extern const int s_globalObjectIsFiniteCodeLength;
extern const JSC::ConstructAbility s_globalObjectIsFiniteCodeConstructAbility;
extern const JSC::ConstructorKind s_globalObjectIsFiniteCodeConstructorKind;
extern const JSC::ImplementationVisibility s_globalObjectIsFiniteCodeImplementationVisibility;
extern const char* const s_globalObjectIsNaNCode;
extern const int s_globalObjectIsNaNCodeLength;
extern const JSC::ConstructAbility s_globalObjectIsNaNCodeConstructAbility;
extern const JSC::ConstructorKind s_globalObjectIsNaNCodeConstructorKind;
extern const JSC::ImplementationVisibility s_globalObjectIsNaNCodeImplementationVisibility;

#define JSC_FOREACH_GLOBALOBJECT_BUILTIN_DATA(macro) \
    macro(isFinite, globalObjectIsFinite, 1) \
    macro(isNaN, globalObjectIsNaN, 1) \

/* GlobalOperations */
extern const char* const s_globalOperationsToIntegerOrInfinityCode;
extern const int s_globalOperationsToIntegerOrInfinityCodeLength;
extern const JSC::ConstructAbility s_globalOperationsToIntegerOrInfinityCodeConstructAbility;
extern const JSC::ConstructorKind s_globalOperationsToIntegerOrInfinityCodeConstructorKind;
extern const JSC::ImplementationVisibility s_globalOperationsToIntegerOrInfinityCodeImplementationVisibility;
extern const char* const s_globalOperationsToLengthCode;
extern const int s_globalOperationsToLengthCodeLength;
extern const JSC::ConstructAbility s_globalOperationsToLengthCodeConstructAbility;
extern const JSC::ConstructorKind s_globalOperationsToLengthCodeConstructorKind;
extern const JSC::ImplementationVisibility s_globalOperationsToLengthCodeImplementationVisibility;
extern const char* const s_globalOperationsSpeciesGetterCode;
extern const int s_globalOperationsSpeciesGetterCodeLength;
extern const JSC::ConstructAbility s_globalOperationsSpeciesGetterCodeConstructAbility;
extern const JSC::ConstructorKind s_globalOperationsSpeciesGetterCodeConstructorKind;
extern const JSC::ImplementationVisibility s_globalOperationsSpeciesGetterCodeImplementationVisibility;
extern const char* const s_globalOperationsSpeciesConstructorCode;
extern const int s_globalOperationsSpeciesConstructorCodeLength;
extern const JSC::ConstructAbility s_globalOperationsSpeciesConstructorCodeConstructAbility;
extern const JSC::ConstructorKind s_globalOperationsSpeciesConstructorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_globalOperationsSpeciesConstructorCodeImplementationVisibility;

#define JSC_FOREACH_GLOBALOPERATIONS_BUILTIN_DATA(macro) \
    macro(toIntegerOrInfinity, globalOperationsToIntegerOrInfinity, 1) \
    macro(toLength, globalOperationsToLength, 1) \
    macro(speciesGetter, globalOperationsSpeciesGetter, 0) \
    macro(speciesConstructor, globalOperationsSpeciesConstructor, 2) \

/* InternalPromiseConstructor */
extern const char* const s_internalPromiseConstructorInternalAllCode;
extern const int s_internalPromiseConstructorInternalAllCodeLength;
extern const JSC::ConstructAbility s_internalPromiseConstructorInternalAllCodeConstructAbility;
extern const JSC::ConstructorKind s_internalPromiseConstructorInternalAllCodeConstructorKind;
extern const JSC::ImplementationVisibility s_internalPromiseConstructorInternalAllCodeImplementationVisibility;

#define JSC_FOREACH_INTERNALPROMISECONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(internalAll, internalPromiseConstructorInternalAll, 1) \

/* IteratorHelpers */
extern const char* const s_iteratorHelpersPerformIterationCode;
extern const int s_iteratorHelpersPerformIterationCodeLength;
extern const JSC::ConstructAbility s_iteratorHelpersPerformIterationCodeConstructAbility;
extern const JSC::ConstructorKind s_iteratorHelpersPerformIterationCodeConstructorKind;
extern const JSC::ImplementationVisibility s_iteratorHelpersPerformIterationCodeImplementationVisibility;
extern const char* const s_iteratorHelpersWrappedIteratorCode;
extern const int s_iteratorHelpersWrappedIteratorCodeLength;
extern const JSC::ConstructAbility s_iteratorHelpersWrappedIteratorCodeConstructAbility;
extern const JSC::ConstructorKind s_iteratorHelpersWrappedIteratorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_iteratorHelpersWrappedIteratorCodeImplementationVisibility;
extern const char* const s_iteratorHelpersBuiltinSetIterableCode;
extern const int s_iteratorHelpersBuiltinSetIterableCodeLength;
extern const JSC::ConstructAbility s_iteratorHelpersBuiltinSetIterableCodeConstructAbility;
extern const JSC::ConstructorKind s_iteratorHelpersBuiltinSetIterableCodeConstructorKind;
extern const JSC::ImplementationVisibility s_iteratorHelpersBuiltinSetIterableCodeImplementationVisibility;
extern const char* const s_iteratorHelpersBuiltinMapIterableCode;
extern const int s_iteratorHelpersBuiltinMapIterableCodeLength;
extern const JSC::ConstructAbility s_iteratorHelpersBuiltinMapIterableCodeConstructAbility;
extern const JSC::ConstructorKind s_iteratorHelpersBuiltinMapIterableCodeConstructorKind;
extern const JSC::ImplementationVisibility s_iteratorHelpersBuiltinMapIterableCodeImplementationVisibility;

#define JSC_FOREACH_ITERATORHELPERS_BUILTIN_DATA(macro) \
    macro(performIteration, iteratorHelpersPerformIteration, 1) \
    macro(wrappedIterator, iteratorHelpersWrappedIterator, 1) \
    macro(builtinSetIterable, iteratorHelpersBuiltinSetIterable, 1) \
    macro(builtinMapIterable, iteratorHelpersBuiltinMapIterable, 1) \

/* IteratorPrototype */
extern const char* const s_iteratorPrototypeSymbolIteratorGetterCode;
extern const int s_iteratorPrototypeSymbolIteratorGetterCodeLength;
extern const JSC::ConstructAbility s_iteratorPrototypeSymbolIteratorGetterCodeConstructAbility;
extern const JSC::ConstructorKind s_iteratorPrototypeSymbolIteratorGetterCodeConstructorKind;
extern const JSC::ImplementationVisibility s_iteratorPrototypeSymbolIteratorGetterCodeImplementationVisibility;

#define JSC_FOREACH_ITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(symbolIteratorGetter, iteratorPrototypeSymbolIteratorGetter, 0) \

/* MapIteratorPrototype */
extern const char* const s_mapIteratorPrototypeMapIteratorNextCode;
extern const int s_mapIteratorPrototypeMapIteratorNextCodeLength;
extern const JSC::ConstructAbility s_mapIteratorPrototypeMapIteratorNextCodeConstructAbility;
extern const JSC::ConstructorKind s_mapIteratorPrototypeMapIteratorNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_mapIteratorPrototypeMapIteratorNextCodeImplementationVisibility;
extern const char* const s_mapIteratorPrototypeNextCode;
extern const int s_mapIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_mapIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_mapIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_mapIteratorPrototypeNextCodeImplementationVisibility;

#define JSC_FOREACH_MAPITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(mapIteratorNext, mapIteratorPrototypeMapIteratorNext, 2) \
    macro(next, mapIteratorPrototypeNext, 0) \

/* MapPrototype */
extern const char* const s_mapPrototypeForEachCode;
extern const int s_mapPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_mapPrototypeForEachCodeConstructAbility;
extern const JSC::ConstructorKind s_mapPrototypeForEachCodeConstructorKind;
extern const JSC::ImplementationVisibility s_mapPrototypeForEachCodeImplementationVisibility;

#define JSC_FOREACH_MAPPROTOTYPE_BUILTIN_DATA(macro) \
    macro(forEach, mapPrototypeForEach, 1) \

/* ModuleLoader */
extern const char* const s_moduleLoaderSetStateToMaxCode;
extern const int s_moduleLoaderSetStateToMaxCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderSetStateToMaxCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderSetStateToMaxCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderSetStateToMaxCodeImplementationVisibility;
extern const char* const s_moduleLoaderNewRegistryEntryCode;
extern const int s_moduleLoaderNewRegistryEntryCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderNewRegistryEntryCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderNewRegistryEntryCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderNewRegistryEntryCodeImplementationVisibility;
extern const char* const s_moduleLoaderEnsureRegisteredCode;
extern const int s_moduleLoaderEnsureRegisteredCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderEnsureRegisteredCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderEnsureRegisteredCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderEnsureRegisteredCodeImplementationVisibility;
extern const char* const s_moduleLoaderForceFulfillPromiseCode;
extern const int s_moduleLoaderForceFulfillPromiseCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderForceFulfillPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderForceFulfillPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderForceFulfillPromiseCodeImplementationVisibility;
extern const char* const s_moduleLoaderFulfillFetchCode;
extern const int s_moduleLoaderFulfillFetchCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderFulfillFetchCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderFulfillFetchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderFulfillFetchCodeImplementationVisibility;
extern const char* const s_moduleLoaderRequestFetchCode;
extern const int s_moduleLoaderRequestFetchCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderRequestFetchCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderRequestFetchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderRequestFetchCodeImplementationVisibility;
extern const char* const s_moduleLoaderRequestInstantiateCode;
extern const int s_moduleLoaderRequestInstantiateCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderRequestInstantiateCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderRequestInstantiateCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderRequestInstantiateCodeImplementationVisibility;
extern const char* const s_moduleLoaderRequestSatisfyCode;
extern const int s_moduleLoaderRequestSatisfyCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderRequestSatisfyCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderRequestSatisfyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderRequestSatisfyCodeImplementationVisibility;
extern const char* const s_moduleLoaderLinkCode;
extern const int s_moduleLoaderLinkCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderLinkCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderLinkCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderLinkCodeImplementationVisibility;
extern const char* const s_moduleLoaderModuleEvaluationCode;
extern const int s_moduleLoaderModuleEvaluationCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderModuleEvaluationCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderModuleEvaluationCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderModuleEvaluationCodeImplementationVisibility;
extern const char* const s_moduleLoaderAsyncModuleEvaluationCode;
extern const int s_moduleLoaderAsyncModuleEvaluationCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderAsyncModuleEvaluationCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderAsyncModuleEvaluationCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderAsyncModuleEvaluationCodeImplementationVisibility;
extern const char* const s_moduleLoaderProvideFetchCode;
extern const int s_moduleLoaderProvideFetchCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderProvideFetchCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderProvideFetchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderProvideFetchCodeImplementationVisibility;
extern const char* const s_moduleLoaderLoadModuleCode;
extern const int s_moduleLoaderLoadModuleCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderLoadModuleCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderLoadModuleCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderLoadModuleCodeImplementationVisibility;
extern const char* const s_moduleLoaderLinkAndEvaluateModuleCode;
extern const int s_moduleLoaderLinkAndEvaluateModuleCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderLinkAndEvaluateModuleCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderLinkAndEvaluateModuleCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderLinkAndEvaluateModuleCodeImplementationVisibility;
extern const char* const s_moduleLoaderLoadAndEvaluateModuleCode;
extern const int s_moduleLoaderLoadAndEvaluateModuleCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderLoadAndEvaluateModuleCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderLoadAndEvaluateModuleCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderLoadAndEvaluateModuleCodeImplementationVisibility;
extern const char* const s_moduleLoaderRequestImportModuleCode;
extern const int s_moduleLoaderRequestImportModuleCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderRequestImportModuleCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderRequestImportModuleCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderRequestImportModuleCodeImplementationVisibility;
extern const char* const s_moduleLoaderDependencyKeysIfEvaluatedCode;
extern const int s_moduleLoaderDependencyKeysIfEvaluatedCodeLength;
extern const JSC::ConstructAbility s_moduleLoaderDependencyKeysIfEvaluatedCodeConstructAbility;
extern const JSC::ConstructorKind s_moduleLoaderDependencyKeysIfEvaluatedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_moduleLoaderDependencyKeysIfEvaluatedCodeImplementationVisibility;

#define JSC_FOREACH_MODULELOADER_BUILTIN_DATA(macro) \
    macro(setStateToMax, moduleLoaderSetStateToMax, 2) \
    macro(newRegistryEntry, moduleLoaderNewRegistryEntry, 1) \
    macro(ensureRegistered, moduleLoaderEnsureRegistered, 1) \
    macro(forceFulfillPromise, moduleLoaderForceFulfillPromise, 2) \
    macro(fulfillFetch, moduleLoaderFulfillFetch, 2) \
    macro(requestFetch, moduleLoaderRequestFetch, 3) \
    macro(requestInstantiate, moduleLoaderRequestInstantiate, 3) \
    macro(requestSatisfy, moduleLoaderRequestSatisfy, 4) \
    macro(link, moduleLoaderLink, 2) \
    macro(moduleEvaluation, moduleLoaderModuleEvaluation, 2) \
    macro(asyncModuleEvaluation, moduleLoaderAsyncModuleEvaluation, 3) \
    macro(provideFetch, moduleLoaderProvideFetch, 2) \
    macro(loadModule, moduleLoaderLoadModule, 3) \
    macro(linkAndEvaluateModule, moduleLoaderLinkAndEvaluateModule, 2) \
    macro(loadAndEvaluateModule, moduleLoaderLoadAndEvaluateModule, 3) \
    macro(requestImportModule, moduleLoaderRequestImportModule, 4) \
    macro(dependencyKeysIfEvaluated, moduleLoaderDependencyKeysIfEvaluated, 1) \

/* NumberConstructor */
extern const char* const s_numberConstructorIsFiniteCode;
extern const int s_numberConstructorIsFiniteCodeLength;
extern const JSC::ConstructAbility s_numberConstructorIsFiniteCodeConstructAbility;
extern const JSC::ConstructorKind s_numberConstructorIsFiniteCodeConstructorKind;
extern const JSC::ImplementationVisibility s_numberConstructorIsFiniteCodeImplementationVisibility;
extern const char* const s_numberConstructorIsNaNCode;
extern const int s_numberConstructorIsNaNCodeLength;
extern const JSC::ConstructAbility s_numberConstructorIsNaNCodeConstructAbility;
extern const JSC::ConstructorKind s_numberConstructorIsNaNCodeConstructorKind;
extern const JSC::ImplementationVisibility s_numberConstructorIsNaNCodeImplementationVisibility;

#define JSC_FOREACH_NUMBERCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(isFinite, numberConstructorIsFinite, 1) \
    macro(isNaN, numberConstructorIsNaN, 1) \

/* ObjectConstructor */
extern const char* const s_objectConstructorFromEntriesCode;
extern const int s_objectConstructorFromEntriesCodeLength;
extern const JSC::ConstructAbility s_objectConstructorFromEntriesCodeConstructAbility;
extern const JSC::ConstructorKind s_objectConstructorFromEntriesCodeConstructorKind;
extern const JSC::ImplementationVisibility s_objectConstructorFromEntriesCodeImplementationVisibility;

#define JSC_FOREACH_OBJECTCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(fromEntries, objectConstructorFromEntries, 1) \

/* PromiseConstructor */
extern const char* const s_promiseConstructorPromiseAllSlowCode;
extern const int s_promiseConstructorPromiseAllSlowCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseAllSlowCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseAllSlowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseAllSlowCodeImplementationVisibility;
extern const char* const s_promiseConstructorPromiseOnRejectedWithContextCode;
extern const int s_promiseConstructorPromiseOnRejectedWithContextCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseOnRejectedWithContextCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseOnRejectedWithContextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseOnRejectedWithContextCodeImplementationVisibility;
extern const char* const s_promiseConstructorPromiseAllOnFulfilledCode;
extern const int s_promiseConstructorPromiseAllOnFulfilledCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseAllOnFulfilledCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseAllOnFulfilledCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseAllOnFulfilledCodeImplementationVisibility;
extern const char* const s_promiseConstructorPromiseNewOnRejectedCode;
extern const int s_promiseConstructorPromiseNewOnRejectedCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseNewOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseNewOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseNewOnRejectedCodeImplementationVisibility;
extern const char* const s_promiseConstructorPromiseAllNewResolveElementCode;
extern const int s_promiseConstructorPromiseAllNewResolveElementCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseAllNewResolveElementCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseAllNewResolveElementCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseAllNewResolveElementCodeImplementationVisibility;
extern const char* const s_promiseConstructorAllCode;
extern const int s_promiseConstructorAllCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorAllCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorAllCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorAllCodeImplementationVisibility;
extern const char* const s_promiseConstructorAllSettledCode;
extern const int s_promiseConstructorAllSettledCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorAllSettledCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorAllSettledCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorAllSettledCodeImplementationVisibility;
extern const char* const s_promiseConstructorAnyCode;
extern const int s_promiseConstructorAnyCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorAnyCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorAnyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorAnyCodeImplementationVisibility;
extern const char* const s_promiseConstructorRaceCode;
extern const int s_promiseConstructorRaceCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorRaceCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorRaceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorRaceCodeImplementationVisibility;
extern const char* const s_promiseConstructorRejectCode;
extern const int s_promiseConstructorRejectCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorRejectCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorRejectCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorRejectCodeImplementationVisibility;
extern const char* const s_promiseConstructorResolveCode;
extern const int s_promiseConstructorResolveCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorResolveCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorResolveCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorResolveCodeImplementationVisibility;
extern const char* const s_promiseConstructorPromiseConstructorCode;
extern const int s_promiseConstructorPromiseConstructorCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorPromiseConstructorCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorPromiseConstructorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorPromiseConstructorCodeImplementationVisibility;
extern const char* const s_promiseConstructorInternalPromiseConstructorCode;
extern const int s_promiseConstructorInternalPromiseConstructorCodeLength;
extern const JSC::ConstructAbility s_promiseConstructorInternalPromiseConstructorCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseConstructorInternalPromiseConstructorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseConstructorInternalPromiseConstructorCodeImplementationVisibility;

#define JSC_FOREACH_PROMISECONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(promiseAllSlow, promiseConstructorPromiseAllSlow, 1) \
    macro(promiseOnRejectedWithContext, promiseConstructorPromiseOnRejectedWithContext, 2) \
    macro(promiseAllOnFulfilled, promiseConstructorPromiseAllOnFulfilled, 2) \
    macro(promiseNewOnRejected, promiseConstructorPromiseNewOnRejected, 1) \
    macro(promiseAllNewResolveElement, promiseConstructorPromiseAllNewResolveElement, 2) \
    macro(all, promiseConstructorAll, 1) \
    macro(allSettled, promiseConstructorAllSettled, 1) \
    macro(any, promiseConstructorAny, 1) \
    macro(race, promiseConstructorRace, 1) \
    macro(reject, promiseConstructorReject, 1) \
    macro(resolve, promiseConstructorResolve, 1) \
    macro(Promise, promiseConstructorPromiseConstructor, 1) \
    macro(InternalPromise, promiseConstructorInternalPromiseConstructor, 1) \

/* PromiseOperations */
extern const char* const s_promiseOperationsPushNewPromiseReactionCode;
extern const int s_promiseOperationsPushNewPromiseReactionCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPushNewPromiseReactionCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPushNewPromiseReactionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPushNewPromiseReactionCodeImplementationVisibility;
extern const char* const s_promiseOperationsNewPromiseCapabilitySlowCode;
extern const int s_promiseOperationsNewPromiseCapabilitySlowCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsNewPromiseCapabilitySlowCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsNewPromiseCapabilitySlowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsNewPromiseCapabilitySlowCodeImplementationVisibility;
extern const char* const s_promiseOperationsNewPromiseCapabilityCode;
extern const int s_promiseOperationsNewPromiseCapabilityCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsNewPromiseCapabilityCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsNewPromiseCapabilityCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsNewPromiseCapabilityCodeImplementationVisibility;
extern const char* const s_promiseOperationsPromiseResolveCode;
extern const int s_promiseOperationsPromiseResolveCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveCodeImplementationVisibility;
extern const char* const s_promiseOperationsPromiseResolveSlowCode;
extern const int s_promiseOperationsPromiseResolveSlowCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveSlowCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveSlowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveSlowCodeImplementationVisibility;
extern const char* const s_promiseOperationsPromiseRejectSlowCode;
extern const int s_promiseOperationsPromiseRejectSlowCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseRejectSlowCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseRejectSlowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseRejectSlowCodeImplementationVisibility;
extern const char* const s_promiseOperationsNewHandledRejectedPromiseCode;
extern const int s_promiseOperationsNewHandledRejectedPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsNewHandledRejectedPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsNewHandledRejectedPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsNewHandledRejectedPromiseCodeImplementationVisibility;
extern const char* const s_promiseOperationsTriggerPromiseReactionsCode;
extern const int s_promiseOperationsTriggerPromiseReactionsCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsTriggerPromiseReactionsCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsTriggerPromiseReactionsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsTriggerPromiseReactionsCodeImplementationVisibility;
extern const char* const s_promiseOperationsResolvePromiseCode;
extern const int s_promiseOperationsResolvePromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsResolvePromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsResolvePromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsResolvePromiseCodeImplementationVisibility;
extern const char* const s_promiseOperationsRejectPromiseCode;
extern const int s_promiseOperationsRejectPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsRejectPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsRejectPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsRejectPromiseCodeImplementationVisibility;
extern const char* const s_promiseOperationsFulfillPromiseCode;
extern const int s_promiseOperationsFulfillPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsFulfillPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsFulfillPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsFulfillPromiseCodeImplementationVisibility;
extern const char* const s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCode;
extern const int s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeImplementationVisibility;
extern const char* const s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCode;
extern const int s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeImplementationVisibility;
extern const char* const s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCode;
extern const int s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeImplementationVisibility;
extern const char* const s_promiseOperationsCreateResolvingFunctionsCode;
extern const int s_promiseOperationsCreateResolvingFunctionsCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsCreateResolvingFunctionsCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsCreateResolvingFunctionsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsCreateResolvingFunctionsCodeImplementationVisibility;
extern const char* const s_promiseOperationsPromiseReactionJobWithoutPromiseCode;
extern const int s_promiseOperationsPromiseReactionJobWithoutPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseReactionJobWithoutPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseReactionJobWithoutPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseReactionJobWithoutPromiseCodeImplementationVisibility;
extern const char* const s_promiseOperationsResolveWithoutPromiseCode;
extern const int s_promiseOperationsResolveWithoutPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsResolveWithoutPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsResolveWithoutPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsResolveWithoutPromiseCodeImplementationVisibility;
extern const char* const s_promiseOperationsRejectWithoutPromiseCode;
extern const int s_promiseOperationsRejectWithoutPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsRejectWithoutPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsRejectWithoutPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsRejectWithoutPromiseCodeImplementationVisibility;
extern const char* const s_promiseOperationsFulfillWithoutPromiseCode;
extern const int s_promiseOperationsFulfillWithoutPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsFulfillWithoutPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsFulfillWithoutPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsFulfillWithoutPromiseCodeImplementationVisibility;
extern const char* const s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCode;
extern const int s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeImplementationVisibility;
extern const char* const s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCode;
extern const int s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeImplementationVisibility;
extern const char* const s_promiseOperationsPromiseReactionJobCode;
extern const int s_promiseOperationsPromiseReactionJobCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseReactionJobCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseReactionJobCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseReactionJobCodeImplementationVisibility;
extern const char* const s_promiseOperationsPromiseResolveThenableJobFastCode;
extern const int s_promiseOperationsPromiseResolveThenableJobFastCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobFastCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobFastCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobFastCodeImplementationVisibility;
extern const char* const s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCode;
extern const int s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeImplementationVisibility;
extern const char* const s_promiseOperationsPromiseResolveThenableJobCode;
extern const int s_promiseOperationsPromiseResolveThenableJobCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobCodeImplementationVisibility;
extern const char* const s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCode;
extern const int s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeImplementationVisibility;
extern const char* const s_promiseOperationsPromiseEmptyOnFulfilledCode;
extern const int s_promiseOperationsPromiseEmptyOnFulfilledCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseEmptyOnFulfilledCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseEmptyOnFulfilledCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseEmptyOnFulfilledCodeImplementationVisibility;
extern const char* const s_promiseOperationsPromiseEmptyOnRejectedCode;
extern const int s_promiseOperationsPromiseEmptyOnRejectedCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPromiseEmptyOnRejectedCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPromiseEmptyOnRejectedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPromiseEmptyOnRejectedCodeImplementationVisibility;
extern const char* const s_promiseOperationsPerformPromiseThenCode;
extern const int s_promiseOperationsPerformPromiseThenCodeLength;
extern const JSC::ConstructAbility s_promiseOperationsPerformPromiseThenCodeConstructAbility;
extern const JSC::ConstructorKind s_promiseOperationsPerformPromiseThenCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promiseOperationsPerformPromiseThenCodeImplementationVisibility;

#define JSC_FOREACH_PROMISEOPERATIONS_BUILTIN_DATA(macro) \
    macro(pushNewPromiseReaction, promiseOperationsPushNewPromiseReaction, 6) \
    macro(newPromiseCapabilitySlow, promiseOperationsNewPromiseCapabilitySlow, 1) \
    macro(newPromiseCapability, promiseOperationsNewPromiseCapability, 1) \
    macro(promiseResolve, promiseOperationsPromiseResolve, 2) \
    macro(promiseResolveSlow, promiseOperationsPromiseResolveSlow, 2) \
    macro(promiseRejectSlow, promiseOperationsPromiseRejectSlow, 2) \
    macro(newHandledRejectedPromise, promiseOperationsNewHandledRejectedPromise, 1) \
    macro(triggerPromiseReactions, promiseOperationsTriggerPromiseReactions, 3) \
    macro(resolvePromise, promiseOperationsResolvePromise, 2) \
    macro(rejectPromise, promiseOperationsRejectPromise, 2) \
    macro(fulfillPromise, promiseOperationsFulfillPromise, 2) \
    macro(resolvePromiseWithFirstResolvingFunctionCallCheck, promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheck, 2) \
    macro(fulfillPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheck, 2) \
    macro(rejectPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheck, 2) \
    macro(createResolvingFunctions, promiseOperationsCreateResolvingFunctions, 1) \
    macro(promiseReactionJobWithoutPromise, promiseOperationsPromiseReactionJobWithoutPromise, 3) \
    macro(resolveWithoutPromise, promiseOperationsResolveWithoutPromise, 4) \
    macro(rejectWithoutPromise, promiseOperationsRejectWithoutPromise, 4) \
    macro(fulfillWithoutPromise, promiseOperationsFulfillWithoutPromise, 4) \
    macro(resolveWithoutPromiseForAsyncAwait, promiseOperationsResolveWithoutPromiseForAsyncAwait, 4) \
    macro(createResolvingFunctionsWithoutPromise, promiseOperationsCreateResolvingFunctionsWithoutPromise, 3) \
    macro(promiseReactionJob, promiseOperationsPromiseReactionJob, 4) \
    macro(promiseResolveThenableJobFast, promiseOperationsPromiseResolveThenableJobFast, 2) \
    macro(promiseResolveThenableJobWithoutPromiseFast, promiseOperationsPromiseResolveThenableJobWithoutPromiseFast, 4) \
    macro(promiseResolveThenableJob, promiseOperationsPromiseResolveThenableJob, 3) \
    macro(promiseResolveThenableJobWithDerivedPromise, promiseOperationsPromiseResolveThenableJobWithDerivedPromise, 3) \
    macro(promiseEmptyOnFulfilled, promiseOperationsPromiseEmptyOnFulfilled, 1) \
    macro(promiseEmptyOnRejected, promiseOperationsPromiseEmptyOnRejected, 1) \
    macro(performPromiseThen, promiseOperationsPerformPromiseThen, 5) \

/* PromisePrototype */
extern const char* const s_promisePrototypeCatchCode;
extern const int s_promisePrototypeCatchCodeLength;
extern const JSC::ConstructAbility s_promisePrototypeCatchCodeConstructAbility;
extern const JSC::ConstructorKind s_promisePrototypeCatchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promisePrototypeCatchCodeImplementationVisibility;
extern const char* const s_promisePrototypeThenCode;
extern const int s_promisePrototypeThenCodeLength;
extern const JSC::ConstructAbility s_promisePrototypeThenCodeConstructAbility;
extern const JSC::ConstructorKind s_promisePrototypeThenCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promisePrototypeThenCodeImplementationVisibility;
extern const char* const s_promisePrototypeFinallyCode;
extern const int s_promisePrototypeFinallyCodeLength;
extern const JSC::ConstructAbility s_promisePrototypeFinallyCodeConstructAbility;
extern const JSC::ConstructorKind s_promisePrototypeFinallyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_promisePrototypeFinallyCodeImplementationVisibility;

#define JSC_FOREACH_PROMISEPROTOTYPE_BUILTIN_DATA(macro) \
    macro(catch, promisePrototypeCatch, 1) \
    macro(then, promisePrototypeThen, 2) \
    macro(finally, promisePrototypeFinally, 1) \

/* ProxyHelpers */
extern const char* const s_proxyHelpersPerformProxyObjectHasCode;
extern const int s_proxyHelpersPerformProxyObjectHasCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectHasCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectHasCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectHasCodeImplementationVisibility;
extern const char* const s_proxyHelpersPerformProxyObjectGetCode;
extern const int s_proxyHelpersPerformProxyObjectGetCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectGetCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectGetCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectGetCodeImplementationVisibility;
extern const char* const s_proxyHelpersPerformProxyObjectGetByValCode;
extern const int s_proxyHelpersPerformProxyObjectGetByValCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectGetByValCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectGetByValCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectGetByValCodeImplementationVisibility;
extern const char* const s_proxyHelpersPerformProxyObjectSetSloppyCode;
extern const int s_proxyHelpersPerformProxyObjectSetSloppyCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectSetSloppyCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectSetSloppyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectSetSloppyCodeImplementationVisibility;
extern const char* const s_proxyHelpersPerformProxyObjectSetStrictCode;
extern const int s_proxyHelpersPerformProxyObjectSetStrictCodeLength;
extern const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectSetStrictCodeConstructAbility;
extern const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectSetStrictCodeConstructorKind;
extern const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectSetStrictCodeImplementationVisibility;

#define JSC_FOREACH_PROXYHELPERS_BUILTIN_DATA(macro) \
    macro(performProxyObjectHas, proxyHelpersPerformProxyObjectHas, 1) \
    macro(performProxyObjectGet, proxyHelpersPerformProxyObjectGet, 2) \
    macro(performProxyObjectGetByVal, proxyHelpersPerformProxyObjectGetByVal, 2) \
    macro(performProxyObjectSetSloppy, proxyHelpersPerformProxyObjectSetSloppy, 3) \
    macro(performProxyObjectSetStrict, proxyHelpersPerformProxyObjectSetStrict, 3) \

/* ReflectObject */
extern const char* const s_reflectObjectApplyCode;
extern const int s_reflectObjectApplyCodeLength;
extern const JSC::ConstructAbility s_reflectObjectApplyCodeConstructAbility;
extern const JSC::ConstructorKind s_reflectObjectApplyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_reflectObjectApplyCodeImplementationVisibility;
extern const char* const s_reflectObjectDeletePropertyCode;
extern const int s_reflectObjectDeletePropertyCodeLength;
extern const JSC::ConstructAbility s_reflectObjectDeletePropertyCodeConstructAbility;
extern const JSC::ConstructorKind s_reflectObjectDeletePropertyCodeConstructorKind;
extern const JSC::ImplementationVisibility s_reflectObjectDeletePropertyCodeImplementationVisibility;
extern const char* const s_reflectObjectGetCode;
extern const int s_reflectObjectGetCodeLength;
extern const JSC::ConstructAbility s_reflectObjectGetCodeConstructAbility;
extern const JSC::ConstructorKind s_reflectObjectGetCodeConstructorKind;
extern const JSC::ImplementationVisibility s_reflectObjectGetCodeImplementationVisibility;
extern const char* const s_reflectObjectHasCode;
extern const int s_reflectObjectHasCodeLength;
extern const JSC::ConstructAbility s_reflectObjectHasCodeConstructAbility;
extern const JSC::ConstructorKind s_reflectObjectHasCodeConstructorKind;
extern const JSC::ImplementationVisibility s_reflectObjectHasCodeImplementationVisibility;

#define JSC_FOREACH_REFLECTOBJECT_BUILTIN_DATA(macro) \
    macro(apply, reflectObjectApply, 3) \
    macro(deleteProperty, reflectObjectDeleteProperty, 2) \
    macro(get, reflectObjectGet, 2) \
    macro(has, reflectObjectHas, 2) \

/* RegExpPrototype */
extern const char* const s_regExpPrototypeRegExpStringIteratorConstructorCode;
extern const int s_regExpPrototypeRegExpStringIteratorConstructorCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeRegExpStringIteratorConstructorCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeRegExpStringIteratorConstructorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeRegExpStringIteratorConstructorCodeImplementationVisibility;
extern const char* const s_regExpPrototypeAdvanceStringIndexCode;
extern const int s_regExpPrototypeAdvanceStringIndexCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeAdvanceStringIndexCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeAdvanceStringIndexCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeAdvanceStringIndexCodeImplementationVisibility;
extern const char* const s_regExpPrototypeRegExpExecCode;
extern const int s_regExpPrototypeRegExpExecCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeRegExpExecCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeRegExpExecCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeRegExpExecCodeImplementationVisibility;
extern const char* const s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCode;
extern const int s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeImplementationVisibility;
extern const char* const s_regExpPrototypeMatchSlowCode;
extern const int s_regExpPrototypeMatchSlowCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeMatchSlowCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeMatchSlowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeMatchSlowCodeImplementationVisibility;
extern const char* const s_regExpPrototypeMatchCode;
extern const int s_regExpPrototypeMatchCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeMatchCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeMatchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeMatchCodeImplementationVisibility;
extern const char* const s_regExpPrototypeMatchAllCode;
extern const int s_regExpPrototypeMatchAllCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeMatchAllCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeMatchAllCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeMatchAllCodeImplementationVisibility;
extern const char* const s_regExpPrototypeGetSubstitutionCode;
extern const int s_regExpPrototypeGetSubstitutionCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeGetSubstitutionCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeGetSubstitutionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeGetSubstitutionCodeImplementationVisibility;
extern const char* const s_regExpPrototypeReplaceCode;
extern const int s_regExpPrototypeReplaceCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeReplaceCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeReplaceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeReplaceCodeImplementationVisibility;
extern const char* const s_regExpPrototypeSearchCode;
extern const int s_regExpPrototypeSearchCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeSearchCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeSearchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeSearchCodeImplementationVisibility;
extern const char* const s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCode;
extern const int s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeImplementationVisibility;
extern const char* const s_regExpPrototypeSplitCode;
extern const int s_regExpPrototypeSplitCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeSplitCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeSplitCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeSplitCodeImplementationVisibility;
extern const char* const s_regExpPrototypeTestCode;
extern const int s_regExpPrototypeTestCodeLength;
extern const JSC::ConstructAbility s_regExpPrototypeTestCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpPrototypeTestCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpPrototypeTestCodeImplementationVisibility;

#define JSC_FOREACH_REGEXPPROTOTYPE_BUILTIN_DATA(macro) \
    macro(RegExpStringIterator, regExpPrototypeRegExpStringIteratorConstructor, 4) \
    macro(advanceStringIndex, regExpPrototypeAdvanceStringIndex, 3) \
    macro(regExpExec, regExpPrototypeRegExpExec, 2) \
    macro(hasObservableSideEffectsForRegExpMatch, regExpPrototypeHasObservableSideEffectsForRegExpMatch, 1) \
    macro(matchSlow, regExpPrototypeMatchSlow, 2) \
    macro(match, regExpPrototypeMatch, 1) \
    macro(matchAll, regExpPrototypeMatchAll, 1) \
    macro(getSubstitution, regExpPrototypeGetSubstitution, 6) \
    macro(replace, regExpPrototypeReplace, 2) \
    macro(search, regExpPrototypeSearch, 1) \
    macro(hasObservableSideEffectsForRegExpSplit, regExpPrototypeHasObservableSideEffectsForRegExpSplit, 1) \
    macro(split, regExpPrototypeSplit, 2) \
    macro(test, regExpPrototypeTest, 1) \

/* RegExpStringIteratorPrototype */
extern const char* const s_regExpStringIteratorPrototypeNextCode;
extern const int s_regExpStringIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_regExpStringIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_regExpStringIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_regExpStringIteratorPrototypeNextCodeImplementationVisibility;

#define JSC_FOREACH_REGEXPSTRINGITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, regExpStringIteratorPrototypeNext, 0) \

/* SetIteratorPrototype */
extern const char* const s_setIteratorPrototypeSetIteratorNextCode;
extern const int s_setIteratorPrototypeSetIteratorNextCodeLength;
extern const JSC::ConstructAbility s_setIteratorPrototypeSetIteratorNextCodeConstructAbility;
extern const JSC::ConstructorKind s_setIteratorPrototypeSetIteratorNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setIteratorPrototypeSetIteratorNextCodeImplementationVisibility;
extern const char* const s_setIteratorPrototypeNextCode;
extern const int s_setIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_setIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_setIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setIteratorPrototypeNextCodeImplementationVisibility;

#define JSC_FOREACH_SETITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(setIteratorNext, setIteratorPrototypeSetIteratorNext, 2) \
    macro(next, setIteratorPrototypeNext, 0) \

/* SetPrototype */
extern const char* const s_setPrototypeForEachCode;
extern const int s_setPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_setPrototypeForEachCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeForEachCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeForEachCodeImplementationVisibility;
extern const char* const s_setPrototypeUnionCode;
extern const int s_setPrototypeUnionCodeLength;
extern const JSC::ConstructAbility s_setPrototypeUnionCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeUnionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeUnionCodeImplementationVisibility;
extern const char* const s_setPrototypeIntersectionCode;
extern const int s_setPrototypeIntersectionCodeLength;
extern const JSC::ConstructAbility s_setPrototypeIntersectionCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeIntersectionCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeIntersectionCodeImplementationVisibility;
extern const char* const s_setPrototypeDifferenceCode;
extern const int s_setPrototypeDifferenceCodeLength;
extern const JSC::ConstructAbility s_setPrototypeDifferenceCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeDifferenceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeDifferenceCodeImplementationVisibility;
extern const char* const s_setPrototypeSymmetricDifferenceCode;
extern const int s_setPrototypeSymmetricDifferenceCodeLength;
extern const JSC::ConstructAbility s_setPrototypeSymmetricDifferenceCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeSymmetricDifferenceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeSymmetricDifferenceCodeImplementationVisibility;
extern const char* const s_setPrototypeIsSubsetOfCode;
extern const int s_setPrototypeIsSubsetOfCodeLength;
extern const JSC::ConstructAbility s_setPrototypeIsSubsetOfCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeIsSubsetOfCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeIsSubsetOfCodeImplementationVisibility;
extern const char* const s_setPrototypeIsSupersetOfCode;
extern const int s_setPrototypeIsSupersetOfCodeLength;
extern const JSC::ConstructAbility s_setPrototypeIsSupersetOfCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeIsSupersetOfCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeIsSupersetOfCodeImplementationVisibility;
extern const char* const s_setPrototypeIsDisjointFromCode;
extern const int s_setPrototypeIsDisjointFromCodeLength;
extern const JSC::ConstructAbility s_setPrototypeIsDisjointFromCodeConstructAbility;
extern const JSC::ConstructorKind s_setPrototypeIsDisjointFromCodeConstructorKind;
extern const JSC::ImplementationVisibility s_setPrototypeIsDisjointFromCodeImplementationVisibility;

#define JSC_FOREACH_SETPROTOTYPE_BUILTIN_DATA(macro) \
    macro(forEach, setPrototypeForEach, 1) \
    macro(union, setPrototypeUnion, 1) \
    macro(intersection, setPrototypeIntersection, 1) \
    macro(difference, setPrototypeDifference, 1) \
    macro(symmetricDifference, setPrototypeSymmetricDifference, 1) \
    macro(isSubsetOf, setPrototypeIsSubsetOf, 1) \
    macro(isSupersetOf, setPrototypeIsSupersetOf, 1) \
    macro(isDisjointFrom, setPrototypeIsDisjointFrom, 1) \

/* ShadowRealmPrototype */
extern const char* const s_shadowRealmPrototypeWrapRemoteValueCode;
extern const int s_shadowRealmPrototypeWrapRemoteValueCodeLength;
extern const JSC::ConstructAbility s_shadowRealmPrototypeWrapRemoteValueCodeConstructAbility;
extern const JSC::ConstructorKind s_shadowRealmPrototypeWrapRemoteValueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_shadowRealmPrototypeWrapRemoteValueCodeImplementationVisibility;
extern const char* const s_shadowRealmPrototypeEvaluateCode;
extern const int s_shadowRealmPrototypeEvaluateCodeLength;
extern const JSC::ConstructAbility s_shadowRealmPrototypeEvaluateCodeConstructAbility;
extern const JSC::ConstructorKind s_shadowRealmPrototypeEvaluateCodeConstructorKind;
extern const JSC::ImplementationVisibility s_shadowRealmPrototypeEvaluateCodeImplementationVisibility;
extern const char* const s_shadowRealmPrototypeCrossRealmThrowCode;
extern const int s_shadowRealmPrototypeCrossRealmThrowCodeLength;
extern const JSC::ConstructAbility s_shadowRealmPrototypeCrossRealmThrowCodeConstructAbility;
extern const JSC::ConstructorKind s_shadowRealmPrototypeCrossRealmThrowCodeConstructorKind;
extern const JSC::ImplementationVisibility s_shadowRealmPrototypeCrossRealmThrowCodeImplementationVisibility;
extern const char* const s_shadowRealmPrototypeImportValueCode;
extern const int s_shadowRealmPrototypeImportValueCodeLength;
extern const JSC::ConstructAbility s_shadowRealmPrototypeImportValueCodeConstructAbility;
extern const JSC::ConstructorKind s_shadowRealmPrototypeImportValueCodeConstructorKind;
extern const JSC::ImplementationVisibility s_shadowRealmPrototypeImportValueCodeImplementationVisibility;

#define JSC_FOREACH_SHADOWREALMPROTOTYPE_BUILTIN_DATA(macro) \
    macro(wrapRemoteValue, shadowRealmPrototypeWrapRemoteValue, 3) \
    macro(evaluate, shadowRealmPrototypeEvaluate, 1) \
    macro(crossRealmThrow, shadowRealmPrototypeCrossRealmThrow, 1) \
    macro(importValue, shadowRealmPrototypeImportValue, 2) \

/* StringConstructor */
extern const char* const s_stringConstructorRawCode;
extern const int s_stringConstructorRawCodeLength;
extern const JSC::ConstructAbility s_stringConstructorRawCodeConstructAbility;
extern const JSC::ConstructorKind s_stringConstructorRawCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringConstructorRawCodeImplementationVisibility;

#define JSC_FOREACH_STRINGCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(raw, stringConstructorRaw, 1) \

/* StringIteratorPrototype */
extern const char* const s_stringIteratorPrototypeNextCode;
extern const int s_stringIteratorPrototypeNextCodeLength;
extern const JSC::ConstructAbility s_stringIteratorPrototypeNextCodeConstructAbility;
extern const JSC::ConstructorKind s_stringIteratorPrototypeNextCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringIteratorPrototypeNextCodeImplementationVisibility;

#define JSC_FOREACH_STRINGITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, stringIteratorPrototypeNext, 0) \

/* StringPrototype */
extern const char* const s_stringPrototypeMatchCode;
extern const int s_stringPrototypeMatchCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeMatchCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeMatchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeMatchCodeImplementationVisibility;
extern const char* const s_stringPrototypeMatchAllCode;
extern const int s_stringPrototypeMatchAllCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeMatchAllCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeMatchAllCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeMatchAllCodeImplementationVisibility;
extern const char* const s_stringPrototypeRepeatSlowPathCode;
extern const int s_stringPrototypeRepeatSlowPathCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeRepeatSlowPathCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeRepeatSlowPathCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeRepeatSlowPathCodeImplementationVisibility;
extern const char* const s_stringPrototypeRepeatCharactersSlowPathCode;
extern const int s_stringPrototypeRepeatCharactersSlowPathCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeRepeatCharactersSlowPathCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeRepeatCharactersSlowPathCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeRepeatCharactersSlowPathCodeImplementationVisibility;
extern const char* const s_stringPrototypeRepeatCode;
extern const int s_stringPrototypeRepeatCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeRepeatCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeRepeatCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeRepeatCodeImplementationVisibility;
extern const char* const s_stringPrototypePadStartCode;
extern const int s_stringPrototypePadStartCodeLength;
extern const JSC::ConstructAbility s_stringPrototypePadStartCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypePadStartCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypePadStartCodeImplementationVisibility;
extern const char* const s_stringPrototypePadEndCode;
extern const int s_stringPrototypePadEndCodeLength;
extern const JSC::ConstructAbility s_stringPrototypePadEndCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypePadEndCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypePadEndCodeImplementationVisibility;
extern const char* const s_stringPrototypeHasObservableSideEffectsForStringReplaceCode;
extern const int s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeImplementationVisibility;
extern const char* const s_stringPrototypeReplaceCode;
extern const int s_stringPrototypeReplaceCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeReplaceCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeReplaceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeReplaceCodeImplementationVisibility;
extern const char* const s_stringPrototypeReplaceAllCode;
extern const int s_stringPrototypeReplaceAllCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeReplaceAllCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeReplaceAllCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeReplaceAllCodeImplementationVisibility;
extern const char* const s_stringPrototypeSearchCode;
extern const int s_stringPrototypeSearchCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeSearchCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeSearchCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeSearchCodeImplementationVisibility;
extern const char* const s_stringPrototypeSplitCode;
extern const int s_stringPrototypeSplitCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeSplitCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeSplitCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeSplitCodeImplementationVisibility;
extern const char* const s_stringPrototypeStringConcatSlowPathCode;
extern const int s_stringPrototypeStringConcatSlowPathCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeStringConcatSlowPathCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeStringConcatSlowPathCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeStringConcatSlowPathCodeImplementationVisibility;
extern const char* const s_stringPrototypeConcatCode;
extern const int s_stringPrototypeConcatCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeConcatCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeConcatCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeConcatCodeImplementationVisibility;
extern const char* const s_stringPrototypeAtCode;
extern const int s_stringPrototypeAtCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeAtCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeAtCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeAtCodeImplementationVisibility;
extern const char* const s_stringPrototypeCreateHTMLCode;
extern const int s_stringPrototypeCreateHTMLCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeCreateHTMLCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeCreateHTMLCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeCreateHTMLCodeImplementationVisibility;
extern const char* const s_stringPrototypeAnchorCode;
extern const int s_stringPrototypeAnchorCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeAnchorCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeAnchorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeAnchorCodeImplementationVisibility;
extern const char* const s_stringPrototypeBigCode;
extern const int s_stringPrototypeBigCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeBigCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeBigCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeBigCodeImplementationVisibility;
extern const char* const s_stringPrototypeBlinkCode;
extern const int s_stringPrototypeBlinkCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeBlinkCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeBlinkCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeBlinkCodeImplementationVisibility;
extern const char* const s_stringPrototypeBoldCode;
extern const int s_stringPrototypeBoldCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeBoldCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeBoldCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeBoldCodeImplementationVisibility;
extern const char* const s_stringPrototypeFixedCode;
extern const int s_stringPrototypeFixedCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeFixedCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeFixedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeFixedCodeImplementationVisibility;
extern const char* const s_stringPrototypeFontcolorCode;
extern const int s_stringPrototypeFontcolorCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeFontcolorCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeFontcolorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeFontcolorCodeImplementationVisibility;
extern const char* const s_stringPrototypeFontsizeCode;
extern const int s_stringPrototypeFontsizeCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeFontsizeCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeFontsizeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeFontsizeCodeImplementationVisibility;
extern const char* const s_stringPrototypeItalicsCode;
extern const int s_stringPrototypeItalicsCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeItalicsCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeItalicsCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeItalicsCodeImplementationVisibility;
extern const char* const s_stringPrototypeLinkCode;
extern const int s_stringPrototypeLinkCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeLinkCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeLinkCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeLinkCodeImplementationVisibility;
extern const char* const s_stringPrototypeSmallCode;
extern const int s_stringPrototypeSmallCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeSmallCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeSmallCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeSmallCodeImplementationVisibility;
extern const char* const s_stringPrototypeStrikeCode;
extern const int s_stringPrototypeStrikeCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeStrikeCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeStrikeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeStrikeCodeImplementationVisibility;
extern const char* const s_stringPrototypeSubCode;
extern const int s_stringPrototypeSubCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeSubCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeSubCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeSubCodeImplementationVisibility;
extern const char* const s_stringPrototypeSupCode;
extern const int s_stringPrototypeSupCodeLength;
extern const JSC::ConstructAbility s_stringPrototypeSupCodeConstructAbility;
extern const JSC::ConstructorKind s_stringPrototypeSupCodeConstructorKind;
extern const JSC::ImplementationVisibility s_stringPrototypeSupCodeImplementationVisibility;

#define JSC_FOREACH_STRINGPROTOTYPE_BUILTIN_DATA(macro) \
    macro(match, stringPrototypeMatch, 1) \
    macro(matchAll, stringPrototypeMatchAll, 1) \
    macro(repeatSlowPath, stringPrototypeRepeatSlowPath, 2) \
    macro(repeatCharactersSlowPath, stringPrototypeRepeatCharactersSlowPath, 2) \
    macro(repeat, stringPrototypeRepeat, 1) \
    macro(padStart, stringPrototypePadStart, 1) \
    macro(padEnd, stringPrototypePadEnd, 1) \
    macro(hasObservableSideEffectsForStringReplace, stringPrototypeHasObservableSideEffectsForStringReplace, 2) \
    macro(replace, stringPrototypeReplace, 2) \
    macro(replaceAll, stringPrototypeReplaceAll, 2) \
    macro(search, stringPrototypeSearch, 1) \
    macro(split, stringPrototypeSplit, 2) \
    macro(stringConcatSlowPath, stringPrototypeStringConcatSlowPath, 0) \
    macro(concat, stringPrototypeConcat, 1) \
    macro(at, stringPrototypeAt, 1) \
    macro(createHTML, stringPrototypeCreateHTML, 5) \
    macro(anchor, stringPrototypeAnchor, 1) \
    macro(big, stringPrototypeBig, 0) \
    macro(blink, stringPrototypeBlink, 0) \
    macro(bold, stringPrototypeBold, 0) \
    macro(fixed, stringPrototypeFixed, 0) \
    macro(fontcolor, stringPrototypeFontcolor, 1) \
    macro(fontsize, stringPrototypeFontsize, 1) \
    macro(italics, stringPrototypeItalics, 0) \
    macro(link, stringPrototypeLink, 1) \
    macro(small, stringPrototypeSmall, 0) \
    macro(strike, stringPrototypeStrike, 0) \
    macro(sub, stringPrototypeSub, 0) \
    macro(sup, stringPrototypeSup, 0) \

/* TypedArrayConstructor */
extern const char* const s_typedArrayConstructorOfCode;
extern const int s_typedArrayConstructorOfCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorOfCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayConstructorOfCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayConstructorOfCodeImplementationVisibility;
extern const char* const s_typedArrayConstructorFromCode;
extern const int s_typedArrayConstructorFromCodeLength;
extern const JSC::ConstructAbility s_typedArrayConstructorFromCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayConstructorFromCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayConstructorFromCodeImplementationVisibility;

#define JSC_FOREACH_TYPEDARRAYCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(of, typedArrayConstructorOf, 0) \
    macro(from, typedArrayConstructorFrom, 1) \

/* TypedArrayPrototype */
extern const char* const s_typedArrayPrototypeTypedArraySpeciesConstructorCode;
extern const int s_typedArrayPrototypeTypedArraySpeciesConstructorCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeTypedArraySpeciesConstructorCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeTypedArraySpeciesConstructorCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeTypedArraySpeciesConstructorCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeEveryCode;
extern const int s_typedArrayPrototypeEveryCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeEveryCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeEveryCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeEveryCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeFindCode;
extern const int s_typedArrayPrototypeFindCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFindCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeFindCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeFindCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeFindLastCode;
extern const int s_typedArrayPrototypeFindLastCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFindLastCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeFindLastCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeFindLastCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeFindIndexCode;
extern const int s_typedArrayPrototypeFindIndexCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFindIndexCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeFindIndexCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeFindIndexCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeFindLastIndexCode;
extern const int s_typedArrayPrototypeFindLastIndexCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFindLastIndexCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeFindLastIndexCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeFindLastIndexCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeForEachCode;
extern const int s_typedArrayPrototypeForEachCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeForEachCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeForEachCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeForEachCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeSomeCode;
extern const int s_typedArrayPrototypeSomeCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeSomeCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeSomeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeSomeCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeTypedArrayMergeCode;
extern const int s_typedArrayPrototypeTypedArrayMergeCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeTypedArrayMergeCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeTypedArrayMergeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeTypedArrayMergeCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeTypedArrayMergeSortCode;
extern const int s_typedArrayPrototypeTypedArrayMergeSortCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeTypedArrayMergeSortCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeTypedArrayMergeSortCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeTypedArrayMergeSortCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeSortCode;
extern const int s_typedArrayPrototypeSortCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeSortCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeSortCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeSortCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeReduceCode;
extern const int s_typedArrayPrototypeReduceCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeReduceCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeReduceCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeReduceCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeReduceRightCode;
extern const int s_typedArrayPrototypeReduceRightCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeReduceRightCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeReduceRightCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeReduceRightCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeMapCode;
extern const int s_typedArrayPrototypeMapCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeMapCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeMapCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeMapCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeFilterCode;
extern const int s_typedArrayPrototypeFilterCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeFilterCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeFilterCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeFilterCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeToLocaleStringCode;
extern const int s_typedArrayPrototypeToLocaleStringCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeToLocaleStringCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeToLocaleStringCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeToLocaleStringCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeAtCode;
extern const int s_typedArrayPrototypeAtCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeAtCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeAtCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeAtCodeImplementationVisibility;
extern const char* const s_typedArrayPrototypeToSortedCode;
extern const int s_typedArrayPrototypeToSortedCodeLength;
extern const JSC::ConstructAbility s_typedArrayPrototypeToSortedCodeConstructAbility;
extern const JSC::ConstructorKind s_typedArrayPrototypeToSortedCodeConstructorKind;
extern const JSC::ImplementationVisibility s_typedArrayPrototypeToSortedCodeImplementationVisibility;

#define JSC_FOREACH_TYPEDARRAYPROTOTYPE_BUILTIN_DATA(macro) \
    macro(typedArraySpeciesConstructor, typedArrayPrototypeTypedArraySpeciesConstructor, 1) \
    macro(every, typedArrayPrototypeEvery, 1) \
    macro(find, typedArrayPrototypeFind, 1) \
    macro(findLast, typedArrayPrototypeFindLast, 1) \
    macro(findIndex, typedArrayPrototypeFindIndex, 1) \
    macro(findLastIndex, typedArrayPrototypeFindLastIndex, 1) \
    macro(forEach, typedArrayPrototypeForEach, 1) \
    macro(some, typedArrayPrototypeSome, 1) \
    macro(typedArrayMerge, typedArrayPrototypeTypedArrayMerge, 6) \
    macro(typedArrayMergeSort, typedArrayPrototypeTypedArrayMergeSort, 3) \
    macro(sort, typedArrayPrototypeSort, 1) \
    macro(reduce, typedArrayPrototypeReduce, 1) \
    macro(reduceRight, typedArrayPrototypeReduceRight, 1) \
    macro(map, typedArrayPrototypeMap, 1) \
    macro(filter, typedArrayPrototypeFilter, 1) \
    macro(toLocaleString, typedArrayPrototypeToLocaleString, 0) \
    macro(at, typedArrayPrototypeAt, 1) \
    macro(toSorted, typedArrayPrototypeToSorted, 1) \

/* WebAssembly */
extern const char* const s_webAssemblyCompileStreamingCode;
extern const int s_webAssemblyCompileStreamingCodeLength;
extern const JSC::ConstructAbility s_webAssemblyCompileStreamingCodeConstructAbility;
extern const JSC::ConstructorKind s_webAssemblyCompileStreamingCodeConstructorKind;
extern const JSC::ImplementationVisibility s_webAssemblyCompileStreamingCodeImplementationVisibility;
extern const char* const s_webAssemblyInstantiateStreamingCode;
extern const int s_webAssemblyInstantiateStreamingCodeLength;
extern const JSC::ConstructAbility s_webAssemblyInstantiateStreamingCodeConstructAbility;
extern const JSC::ConstructorKind s_webAssemblyInstantiateStreamingCodeConstructorKind;
extern const JSC::ImplementationVisibility s_webAssemblyInstantiateStreamingCodeImplementationVisibility;

#define JSC_FOREACH_WEBASSEMBLY_BUILTIN_DATA(macro) \
    macro(compileStreaming, webAssemblyCompileStreaming, 1) \
    macro(instantiateStreaming, webAssemblyInstantiateStreaming, 1) \

/* InjectedScriptSource */
extern const char* const s_injectedScriptSourceCreateObjectWithoutPrototypeCode;
extern const int s_injectedScriptSourceCreateObjectWithoutPrototypeCodeLength;
extern const JSC::ConstructAbility s_injectedScriptSourceCreateObjectWithoutPrototypeCodeConstructAbility;
extern const JSC::ConstructorKind s_injectedScriptSourceCreateObjectWithoutPrototypeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_injectedScriptSourceCreateObjectWithoutPrototypeCodeImplementationVisibility;
extern const char* const s_injectedScriptSourceCreateArrayWithoutPrototypeCode;
extern const int s_injectedScriptSourceCreateArrayWithoutPrototypeCodeLength;
extern const JSC::ConstructAbility s_injectedScriptSourceCreateArrayWithoutPrototypeCodeConstructAbility;
extern const JSC::ConstructorKind s_injectedScriptSourceCreateArrayWithoutPrototypeCodeConstructorKind;
extern const JSC::ImplementationVisibility s_injectedScriptSourceCreateArrayWithoutPrototypeCodeImplementationVisibility;
extern const char* const s_injectedScriptSourceCreateInspectorInjectedScriptCode;
extern const int s_injectedScriptSourceCreateInspectorInjectedScriptCodeLength;
extern const JSC::ConstructAbility s_injectedScriptSourceCreateInspectorInjectedScriptCodeConstructAbility;
extern const JSC::ConstructorKind s_injectedScriptSourceCreateInspectorInjectedScriptCodeConstructorKind;
extern const JSC::ImplementationVisibility s_injectedScriptSourceCreateInspectorInjectedScriptCodeImplementationVisibility;

#define JSC_FOREACH_INJECTEDSCRIPTSOURCE_BUILTIN_DATA(macro) \
    macro(createObjectWithoutPrototype, injectedScriptSourceCreateObjectWithoutPrototype, 0) \
    macro(createArrayWithoutPrototype, injectedScriptSourceCreateArrayWithoutPrototype, 0) \
    macro(createInspectorInjectedScript, injectedScriptSourceCreateInspectorInjectedScript, 3) \

#define JSC_FOREACH_BUILTIN_CODE(macro) \
    macro(asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorConstructorCode, AsyncFromSyncIterator, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorConstructorCodeLength) \
    macro(promiseConstructorInternalPromiseConstructorCode, InternalPromise, ASCIILiteral(), s_promiseConstructorInternalPromiseConstructorCodeLength) \
    macro(promiseConstructorPromiseConstructorCode, Promise, ASCIILiteral(), s_promiseConstructorPromiseConstructorCodeLength) \
    macro(regExpPrototypeRegExpStringIteratorConstructorCode, RegExpStringIterator, ASCIILiteral(), s_regExpPrototypeRegExpStringIteratorConstructorCodeLength) \
    macro(regExpPrototypeAdvanceStringIndexCode, advanceStringIndex, ASCIILiteral(), s_regExpPrototypeAdvanceStringIndexCodeLength) \
    macro(promiseConstructorAllCode, all, ASCIILiteral(), s_promiseConstructorAllCodeLength) \
    macro(promiseConstructorAllSettledCode, allSettled, ASCIILiteral(), s_promiseConstructorAllSettledCodeLength) \
    macro(stringPrototypeAnchorCode, anchor, ASCIILiteral(), s_stringPrototypeAnchorCodeLength) \
    macro(promiseConstructorAnyCode, any, ASCIILiteral(), s_promiseConstructorAnyCodeLength) \
    macro(functionPrototypeApplyCode, apply, ASCIILiteral(), s_functionPrototypeApplyCodeLength) \
    macro(reflectObjectApplyCode, apply, ASCIILiteral(), s_reflectObjectApplyCodeLength) \
    macro(arrayIteratorPrototypeArrayIteratorNextHelperCode, arrayIteratorNextHelper, ASCIILiteral(), s_arrayIteratorPrototypeArrayIteratorNextHelperCodeLength) \
    macro(asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCode, asyncFromSyncIteratorOnFulfilledContinue, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeLength) \
    macro(asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCode, asyncFromSyncIteratorOnFulfilledDone, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeLength) \
    macro(asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCode, asyncFromSyncIteratorOnRejected, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeLength) \
    macro(asyncFunctionPrototypeAsyncFunctionResumeCode, asyncFunctionResume, ASCIILiteral(), s_asyncFunctionPrototypeAsyncFunctionResumeCodeLength) \
    macro(asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCode, asyncFunctionResumeOnFulfilled, ASCIILiteral(), s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeLength) \
    macro(asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCode, asyncFunctionResumeOnRejected, ASCIILiteral(), s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorEnqueueCode, asyncGeneratorEnqueue, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCode, asyncGeneratorQueueDequeue, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCode, asyncGeneratorQueueEnqueue, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCode, asyncGeneratorQueueIsEmpty, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorRejectCode, asyncGeneratorReject, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResolveCode, asyncGeneratorResolve, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResumeNextCode, asyncGeneratorResumeNext, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCode, asyncGeneratorResumeNextOnFulfilled, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCode, asyncGeneratorResumeNextOnRejected, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorYieldCode, asyncGeneratorYield, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCode, asyncGeneratorYieldAwaited, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCode, asyncGeneratorYieldOnRejected, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeLength) \
    macro(moduleLoaderAsyncModuleEvaluationCode, asyncModuleEvaluation, ASCIILiteral(), s_moduleLoaderAsyncModuleEvaluationCodeLength) \
    macro(arrayPrototypeAtCode, at, ASCIILiteral(), s_arrayPrototypeAtCodeLength) \
    macro(stringPrototypeAtCode, at, ASCIILiteral(), s_stringPrototypeAtCodeLength) \
    macro(typedArrayPrototypeAtCode, at, ASCIILiteral(), s_typedArrayPrototypeAtCodeLength) \
    macro(asyncGeneratorPrototypeAwaitValueCode, awaitValue, ASCIILiteral(), s_asyncGeneratorPrototypeAwaitValueCodeLength) \
    macro(stringPrototypeBigCode, big, ASCIILiteral(), s_stringPrototypeBigCodeLength) \
    macro(stringPrototypeBlinkCode, blink, ASCIILiteral(), s_stringPrototypeBlinkCodeLength) \
    macro(stringPrototypeBoldCode, bold, ASCIILiteral(), s_stringPrototypeBoldCodeLength) \
    macro(iteratorHelpersBuiltinMapIterableCode, builtinMapIterable, ASCIILiteral(), s_iteratorHelpersBuiltinMapIterableCodeLength) \
    macro(iteratorHelpersBuiltinSetIterableCode, builtinSetIterable, ASCIILiteral(), s_iteratorHelpersBuiltinSetIterableCodeLength) \
    macro(functionPrototypeCallCode, call, ASCIILiteral(), s_functionPrototypeCallCodeLength) \
    macro(promisePrototypeCatchCode, catch, ASCIILiteral(), s_promisePrototypeCatchCodeLength) \
    macro(webAssemblyCompileStreamingCode, compileStreaming, ASCIILiteral(), s_webAssemblyCompileStreamingCodeLength) \
    macro(arrayPrototypeConcatCode, concat, ASCIILiteral(), s_arrayPrototypeConcatCodeLength) \
    macro(stringPrototypeConcatCode, concat, ASCIILiteral(), s_stringPrototypeConcatCodeLength) \
    macro(arrayPrototypeConcatSlowPathCode, concatSlowPath, ASCIILiteral(), s_arrayPrototypeConcatSlowPathCodeLength) \
    macro(arrayPrototypeCopyWithinCode, copyWithin, ASCIILiteral(), s_arrayPrototypeCopyWithinCodeLength) \
    macro(injectedScriptSourceCreateArrayWithoutPrototypeCode, createArrayWithoutPrototype, ASCIILiteral(), s_injectedScriptSourceCreateArrayWithoutPrototypeCodeLength) \
    macro(asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCode, createAsyncFromSyncIterator, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeLength) \
    macro(stringPrototypeCreateHTMLCode, createHTML, ASCIILiteral(), s_stringPrototypeCreateHTMLCodeLength) \
    macro(injectedScriptSourceCreateInspectorInjectedScriptCode, createInspectorInjectedScript, ASCIILiteral(), s_injectedScriptSourceCreateInspectorInjectedScriptCodeLength) \
    macro(injectedScriptSourceCreateObjectWithoutPrototypeCode, createObjectWithoutPrototype, ASCIILiteral(), s_injectedScriptSourceCreateObjectWithoutPrototypeCodeLength) \
    macro(promiseOperationsCreateResolvingFunctionsCode, createResolvingFunctions, ASCIILiteral(), s_promiseOperationsCreateResolvingFunctionsCodeLength) \
    macro(promiseOperationsCreateResolvingFunctionsWithoutPromiseCode, createResolvingFunctionsWithoutPromise, ASCIILiteral(), s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeLength) \
    macro(shadowRealmPrototypeCrossRealmThrowCode, crossRealmThrow, ASCIILiteral(), s_shadowRealmPrototypeCrossRealmThrowCodeLength) \
    macro(arrayConstructorDefaultAsyncFromAsyncArrayLikeCode, defaultAsyncFromAsyncArrayLike, ASCIILiteral(), s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeLength) \
    macro(arrayConstructorDefaultAsyncFromAsyncIteratorCode, defaultAsyncFromAsyncIterator, ASCIILiteral(), s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeLength) \
    macro(reflectObjectDeletePropertyCode, deleteProperty, ASCIILiteral(), s_reflectObjectDeletePropertyCodeLength) \
    macro(moduleLoaderDependencyKeysIfEvaluatedCode, dependencyKeysIfEvaluated, ASCIILiteral(), s_moduleLoaderDependencyKeysIfEvaluatedCodeLength) \
    macro(setPrototypeDifferenceCode, difference, ASCIILiteral(), s_setPrototypeDifferenceCodeLength) \
    macro(asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCode, doAsyncGeneratorBodyCall, ASCIILiteral(), s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeLength) \
    macro(asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCode, doAsyncGeneratorBodyCallOnFulfilledNormal, ASCIILiteral(), s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeLength) \
    macro(asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCode, doAsyncGeneratorBodyCallOnFulfilledReturn, ASCIILiteral(), s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeLength) \
    macro(moduleLoaderEnsureRegisteredCode, ensureRegistered, ASCIILiteral(), s_moduleLoaderEnsureRegisteredCodeLength) \
    macro(shadowRealmPrototypeEvaluateCode, evaluate, ASCIILiteral(), s_shadowRealmPrototypeEvaluateCodeLength) \
    macro(arrayPrototypeEveryCode, every, ASCIILiteral(), s_arrayPrototypeEveryCodeLength) \
    macro(typedArrayPrototypeEveryCode, every, ASCIILiteral(), s_typedArrayPrototypeEveryCodeLength) \
    macro(arrayPrototypeFillCode, fill, ASCIILiteral(), s_arrayPrototypeFillCodeLength) \
    macro(arrayPrototypeFilterCode, filter, ASCIILiteral(), s_arrayPrototypeFilterCodeLength) \
    macro(typedArrayPrototypeFilterCode, filter, ASCIILiteral(), s_typedArrayPrototypeFilterCodeLength) \
    macro(promisePrototypeFinallyCode, finally, ASCIILiteral(), s_promisePrototypeFinallyCodeLength) \
    macro(arrayPrototypeFindCode, find, ASCIILiteral(), s_arrayPrototypeFindCodeLength) \
    macro(typedArrayPrototypeFindCode, find, ASCIILiteral(), s_typedArrayPrototypeFindCodeLength) \
    macro(arrayPrototypeFindIndexCode, findIndex, ASCIILiteral(), s_arrayPrototypeFindIndexCodeLength) \
    macro(typedArrayPrototypeFindIndexCode, findIndex, ASCIILiteral(), s_typedArrayPrototypeFindIndexCodeLength) \
    macro(arrayPrototypeFindLastCode, findLast, ASCIILiteral(), s_arrayPrototypeFindLastCodeLength) \
    macro(typedArrayPrototypeFindLastCode, findLast, ASCIILiteral(), s_typedArrayPrototypeFindLastCodeLength) \
    macro(arrayPrototypeFindLastIndexCode, findLastIndex, ASCIILiteral(), s_arrayPrototypeFindLastIndexCodeLength) \
    macro(typedArrayPrototypeFindLastIndexCode, findLastIndex, ASCIILiteral(), s_typedArrayPrototypeFindLastIndexCodeLength) \
    macro(stringPrototypeFixedCode, fixed, ASCIILiteral(), s_stringPrototypeFixedCodeLength) \
    macro(arrayPrototypeFlatCode, flat, ASCIILiteral(), s_arrayPrototypeFlatCodeLength) \
    macro(arrayPrototypeFlatIntoArrayCode, flatIntoArray, ASCIILiteral(), s_arrayPrototypeFlatIntoArrayCodeLength) \
    macro(arrayPrototypeFlatIntoArrayWithCallbackCode, flatIntoArrayWithCallback, ASCIILiteral(), s_arrayPrototypeFlatIntoArrayWithCallbackCodeLength) \
    macro(arrayPrototypeFlatMapCode, flatMap, ASCIILiteral(), s_arrayPrototypeFlatMapCodeLength) \
    macro(stringPrototypeFontcolorCode, fontcolor, ASCIILiteral(), s_stringPrototypeFontcolorCodeLength) \
    macro(stringPrototypeFontsizeCode, fontsize, ASCIILiteral(), s_stringPrototypeFontsizeCodeLength) \
    macro(arrayPrototypeForEachCode, forEach, ASCIILiteral(), s_arrayPrototypeForEachCodeLength) \
    macro(mapPrototypeForEachCode, forEach, ASCIILiteral(), s_mapPrototypeForEachCodeLength) \
    macro(setPrototypeForEachCode, forEach, ASCIILiteral(), s_setPrototypeForEachCodeLength) \
    macro(typedArrayPrototypeForEachCode, forEach, ASCIILiteral(), s_typedArrayPrototypeForEachCodeLength) \
    macro(moduleLoaderForceFulfillPromiseCode, forceFulfillPromise, ASCIILiteral(), s_moduleLoaderForceFulfillPromiseCodeLength) \
    macro(arrayConstructorFromCode, from, ASCIILiteral(), s_arrayConstructorFromCodeLength) \
    macro(typedArrayConstructorFromCode, from, ASCIILiteral(), s_typedArrayConstructorFromCodeLength) \
    macro(arrayConstructorFromAsyncCode, fromAsync, ASCIILiteral(), s_arrayConstructorFromAsyncCodeLength) \
    macro(objectConstructorFromEntriesCode, fromEntries, ASCIILiteral(), s_objectConstructorFromEntriesCodeLength) \
    macro(moduleLoaderFulfillFetchCode, fulfillFetch, ASCIILiteral(), s_moduleLoaderFulfillFetchCodeLength) \
    macro(promiseOperationsFulfillPromiseCode, fulfillPromise, ASCIILiteral(), s_promiseOperationsFulfillPromiseCodeLength) \
    macro(promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCode, fulfillPromiseWithFirstResolvingFunctionCallCheck, ASCIILiteral(), s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeLength) \
    macro(promiseOperationsFulfillWithoutPromiseCode, fulfillWithoutPromise, ASCIILiteral(), s_promiseOperationsFulfillWithoutPromiseCodeLength) \
    macro(generatorPrototypeGeneratorResumeCode, generatorResume, ASCIILiteral(), s_generatorPrototypeGeneratorResumeCodeLength) \
    macro(reflectObjectGetCode, get, ASCIILiteral(), s_reflectObjectGetCodeLength) \
    macro(regExpPrototypeGetSubstitutionCode, getSubstitution, ASCIILiteral(), s_regExpPrototypeGetSubstitutionCodeLength) \
    macro(arrayPrototypeGroupCode, group, ASCIILiteral(), s_arrayPrototypeGroupCodeLength) \
    macro(arrayPrototypeGroupToMapCode, groupToMap, ASCIILiteral(), s_arrayPrototypeGroupToMapCodeLength) \
    macro(reflectObjectHasCode, has, ASCIILiteral(), s_reflectObjectHasCodeLength) \
    macro(regExpPrototypeHasObservableSideEffectsForRegExpMatchCode, hasObservableSideEffectsForRegExpMatch, ASCIILiteral(), s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeLength) \
    macro(regExpPrototypeHasObservableSideEffectsForRegExpSplitCode, hasObservableSideEffectsForRegExpSplit, ASCIILiteral(), s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeLength) \
    macro(stringPrototypeHasObservableSideEffectsForStringReplaceCode, hasObservableSideEffectsForStringReplace, ASCIILiteral(), s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeLength) \
    macro(shadowRealmPrototypeImportValueCode, importValue, ASCIILiteral(), s_shadowRealmPrototypeImportValueCodeLength) \
    macro(arrayPrototypeIncludesCode, includes, ASCIILiteral(), s_arrayPrototypeIncludesCodeLength) \
    macro(webAssemblyInstantiateStreamingCode, instantiateStreaming, ASCIILiteral(), s_webAssemblyInstantiateStreamingCodeLength) \
    macro(internalPromiseConstructorInternalAllCode, internalAll, ASCIILiteral(), s_internalPromiseConstructorInternalAllCodeLength) \
    macro(setPrototypeIntersectionCode, intersection, ASCIILiteral(), s_setPrototypeIntersectionCodeLength) \
    macro(arrayConstructorIsArrayCode, isArray, ASCIILiteral(), s_arrayConstructorIsArrayCodeLength) \
    macro(setPrototypeIsDisjointFromCode, isDisjointFrom, ASCIILiteral(), s_setPrototypeIsDisjointFromCodeLength) \
    macro(asyncGeneratorPrototypeIsExecutionStateCode, isExecutionState, ASCIILiteral(), s_asyncGeneratorPrototypeIsExecutionStateCodeLength) \
    macro(globalObjectIsFiniteCode, isFinite, ASCIILiteral(), s_globalObjectIsFiniteCodeLength) \
    macro(numberConstructorIsFiniteCode, isFinite, ASCIILiteral(), s_numberConstructorIsFiniteCodeLength) \
    macro(globalObjectIsNaNCode, isNaN, ASCIILiteral(), s_globalObjectIsNaNCodeLength) \
    macro(numberConstructorIsNaNCode, isNaN, ASCIILiteral(), s_numberConstructorIsNaNCodeLength) \
    macro(setPrototypeIsSubsetOfCode, isSubsetOf, ASCIILiteral(), s_setPrototypeIsSubsetOfCodeLength) \
    macro(setPrototypeIsSupersetOfCode, isSupersetOf, ASCIILiteral(), s_setPrototypeIsSupersetOfCodeLength) \
    macro(asyncGeneratorPrototypeIsSuspendYieldStateCode, isSuspendYieldState, ASCIILiteral(), s_asyncGeneratorPrototypeIsSuspendYieldStateCodeLength) \
    macro(stringPrototypeItalicsCode, italics, ASCIILiteral(), s_stringPrototypeItalicsCodeLength) \
    macro(moduleLoaderLinkCode, link, ASCIILiteral(), s_moduleLoaderLinkCodeLength) \
    macro(stringPrototypeLinkCode, link, ASCIILiteral(), s_stringPrototypeLinkCodeLength) \
    macro(moduleLoaderLinkAndEvaluateModuleCode, linkAndEvaluateModule, ASCIILiteral(), s_moduleLoaderLinkAndEvaluateModuleCodeLength) \
    macro(moduleLoaderLoadAndEvaluateModuleCode, loadAndEvaluateModule, ASCIILiteral(), s_moduleLoaderLoadAndEvaluateModuleCodeLength) \
    macro(moduleLoaderLoadModuleCode, loadModule, ASCIILiteral(), s_moduleLoaderLoadModuleCodeLength) \
    macro(arrayPrototypeMapCode, map, ASCIILiteral(), s_arrayPrototypeMapCodeLength) \
    macro(typedArrayPrototypeMapCode, map, ASCIILiteral(), s_typedArrayPrototypeMapCodeLength) \
    macro(mapIteratorPrototypeMapIteratorNextCode, mapIteratorNext, ASCIILiteral(), s_mapIteratorPrototypeMapIteratorNextCodeLength) \
    macro(regExpPrototypeMatchCode, match, "[Symbol.match]"_s, s_regExpPrototypeMatchCodeLength) \
    macro(stringPrototypeMatchCode, match, ASCIILiteral(), s_stringPrototypeMatchCodeLength) \
    macro(regExpPrototypeMatchAllCode, matchAll, "[Symbol.matchAll]"_s, s_regExpPrototypeMatchAllCodeLength) \
    macro(stringPrototypeMatchAllCode, matchAll, ASCIILiteral(), s_stringPrototypeMatchAllCodeLength) \
    macro(regExpPrototypeMatchSlowCode, matchSlow, ASCIILiteral(), s_regExpPrototypeMatchSlowCodeLength) \
    macro(arrayPrototypeMaxWithPositivesCode, maxWithPositives, ASCIILiteral(), s_arrayPrototypeMaxWithPositivesCodeLength) \
    macro(arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCode, minWithMaybeNegativeZeroAndPositive, ASCIILiteral(), s_arrayPrototypeMinWithMaybeNegativeZeroAndPositiveCodeLength) \
    macro(moduleLoaderModuleEvaluationCode, moduleEvaluation, ASCIILiteral(), s_moduleLoaderModuleEvaluationCodeLength) \
    macro(promiseOperationsNewHandledRejectedPromiseCode, newHandledRejectedPromise, ASCIILiteral(), s_promiseOperationsNewHandledRejectedPromiseCodeLength) \
    macro(promiseOperationsNewPromiseCapabilityCode, newPromiseCapability, ASCIILiteral(), s_promiseOperationsNewPromiseCapabilityCodeLength) \
    macro(promiseOperationsNewPromiseCapabilitySlowCode, newPromiseCapabilitySlow, ASCIILiteral(), s_promiseOperationsNewPromiseCapabilitySlowCodeLength) \
    macro(moduleLoaderNewRegistryEntryCode, newRegistryEntry, ASCIILiteral(), s_moduleLoaderNewRegistryEntryCodeLength) \
    macro(arrayIteratorPrototypeNextCode, next, ASCIILiteral(), s_arrayIteratorPrototypeNextCodeLength) \
    macro(asyncFromSyncIteratorPrototypeNextCode, next, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeNextCodeLength) \
    macro(asyncGeneratorPrototypeNextCode, next, ASCIILiteral(), s_asyncGeneratorPrototypeNextCodeLength) \
    macro(generatorPrototypeNextCode, next, ASCIILiteral(), s_generatorPrototypeNextCodeLength) \
    macro(mapIteratorPrototypeNextCode, next, ASCIILiteral(), s_mapIteratorPrototypeNextCodeLength) \
    macro(regExpStringIteratorPrototypeNextCode, next, ASCIILiteral(), s_regExpStringIteratorPrototypeNextCodeLength) \
    macro(setIteratorPrototypeNextCode, next, ASCIILiteral(), s_setIteratorPrototypeNextCodeLength) \
    macro(stringIteratorPrototypeNextCode, next, ASCIILiteral(), s_stringIteratorPrototypeNextCodeLength) \
    macro(arrayConstructorOfCode, of, ASCIILiteral(), s_arrayConstructorOfCodeLength) \
    macro(typedArrayConstructorOfCode, of, ASCIILiteral(), s_typedArrayConstructorOfCodeLength) \
    macro(stringPrototypePadEndCode, padEnd, ASCIILiteral(), s_stringPrototypePadEndCodeLength) \
    macro(stringPrototypePadStartCode, padStart, ASCIILiteral(), s_stringPrototypePadStartCodeLength) \
    macro(iteratorHelpersPerformIterationCode, performIteration, ASCIILiteral(), s_iteratorHelpersPerformIterationCodeLength) \
    macro(promiseOperationsPerformPromiseThenCode, performPromiseThen, ASCIILiteral(), s_promiseOperationsPerformPromiseThenCodeLength) \
    macro(proxyHelpersPerformProxyObjectGetCode, performProxyObjectGet, ASCIILiteral(), s_proxyHelpersPerformProxyObjectGetCodeLength) \
    macro(proxyHelpersPerformProxyObjectGetByValCode, performProxyObjectGetByVal, ASCIILiteral(), s_proxyHelpersPerformProxyObjectGetByValCodeLength) \
    macro(proxyHelpersPerformProxyObjectHasCode, performProxyObjectHas, ASCIILiteral(), s_proxyHelpersPerformProxyObjectHasCodeLength) \
    macro(proxyHelpersPerformProxyObjectSetSloppyCode, performProxyObjectSetSloppy, ASCIILiteral(), s_proxyHelpersPerformProxyObjectSetSloppyCodeLength) \
    macro(proxyHelpersPerformProxyObjectSetStrictCode, performProxyObjectSetStrict, ASCIILiteral(), s_proxyHelpersPerformProxyObjectSetStrictCodeLength) \
    macro(promiseConstructorPromiseAllNewResolveElementCode, promiseAllNewResolveElement, ASCIILiteral(), s_promiseConstructorPromiseAllNewResolveElementCodeLength) \
    macro(promiseConstructorPromiseAllOnFulfilledCode, promiseAllOnFulfilled, ASCIILiteral(), s_promiseConstructorPromiseAllOnFulfilledCodeLength) \
    macro(promiseConstructorPromiseAllSlowCode, promiseAllSlow, ASCIILiteral(), s_promiseConstructorPromiseAllSlowCodeLength) \
    macro(promiseOperationsPromiseEmptyOnFulfilledCode, promiseEmptyOnFulfilled, ASCIILiteral(), s_promiseOperationsPromiseEmptyOnFulfilledCodeLength) \
    macro(promiseOperationsPromiseEmptyOnRejectedCode, promiseEmptyOnRejected, ASCIILiteral(), s_promiseOperationsPromiseEmptyOnRejectedCodeLength) \
    macro(promiseConstructorPromiseNewOnRejectedCode, promiseNewOnRejected, ASCIILiteral(), s_promiseConstructorPromiseNewOnRejectedCodeLength) \
    macro(promiseConstructorPromiseOnRejectedWithContextCode, promiseOnRejectedWithContext, ASCIILiteral(), s_promiseConstructorPromiseOnRejectedWithContextCodeLength) \
    macro(promiseOperationsPromiseReactionJobCode, promiseReactionJob, ASCIILiteral(), s_promiseOperationsPromiseReactionJobCodeLength) \
    macro(promiseOperationsPromiseReactionJobWithoutPromiseCode, promiseReactionJobWithoutPromise, ASCIILiteral(), s_promiseOperationsPromiseReactionJobWithoutPromiseCodeLength) \
    macro(promiseOperationsPromiseRejectSlowCode, promiseRejectSlow, ASCIILiteral(), s_promiseOperationsPromiseRejectSlowCodeLength) \
    macro(promiseOperationsPromiseResolveCode, promiseResolve, ASCIILiteral(), s_promiseOperationsPromiseResolveCodeLength) \
    macro(promiseOperationsPromiseResolveSlowCode, promiseResolveSlow, ASCIILiteral(), s_promiseOperationsPromiseResolveSlowCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobCode, promiseResolveThenableJob, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobFastCode, promiseResolveThenableJobFast, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobFastCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCode, promiseResolveThenableJobWithDerivedPromise, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCode, promiseResolveThenableJobWithoutPromiseFast, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeLength) \
    macro(moduleLoaderProvideFetchCode, provideFetch, ASCIILiteral(), s_moduleLoaderProvideFetchCodeLength) \
    macro(promiseOperationsPushNewPromiseReactionCode, pushNewPromiseReaction, ASCIILiteral(), s_promiseOperationsPushNewPromiseReactionCodeLength) \
    macro(promiseConstructorRaceCode, race, ASCIILiteral(), s_promiseConstructorRaceCodeLength) \
    macro(stringConstructorRawCode, raw, ASCIILiteral(), s_stringConstructorRawCodeLength) \
    macro(arrayPrototypeReduceCode, reduce, ASCIILiteral(), s_arrayPrototypeReduceCodeLength) \
    macro(typedArrayPrototypeReduceCode, reduce, ASCIILiteral(), s_typedArrayPrototypeReduceCodeLength) \
    macro(arrayPrototypeReduceRightCode, reduceRight, ASCIILiteral(), s_arrayPrototypeReduceRightCodeLength) \
    macro(typedArrayPrototypeReduceRightCode, reduceRight, ASCIILiteral(), s_typedArrayPrototypeReduceRightCodeLength) \
    macro(regExpPrototypeRegExpExecCode, regExpExec, ASCIILiteral(), s_regExpPrototypeRegExpExecCodeLength) \
    macro(promiseConstructorRejectCode, reject, ASCIILiteral(), s_promiseConstructorRejectCodeLength) \
    macro(promiseOperationsRejectPromiseCode, rejectPromise, ASCIILiteral(), s_promiseOperationsRejectPromiseCodeLength) \
    macro(promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCode, rejectPromiseWithFirstResolvingFunctionCallCheck, ASCIILiteral(), s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeLength) \
    macro(promiseOperationsRejectWithoutPromiseCode, rejectWithoutPromise, ASCIILiteral(), s_promiseOperationsRejectWithoutPromiseCodeLength) \
    macro(stringPrototypeRepeatCode, repeat, ASCIILiteral(), s_stringPrototypeRepeatCodeLength) \
    macro(stringPrototypeRepeatCharactersSlowPathCode, repeatCharactersSlowPath, ASCIILiteral(), s_stringPrototypeRepeatCharactersSlowPathCodeLength) \
    macro(stringPrototypeRepeatSlowPathCode, repeatSlowPath, ASCIILiteral(), s_stringPrototypeRepeatSlowPathCodeLength) \
    macro(regExpPrototypeReplaceCode, replace, "[Symbol.replace]"_s, s_regExpPrototypeReplaceCodeLength) \
    macro(stringPrototypeReplaceCode, replace, ASCIILiteral(), s_stringPrototypeReplaceCodeLength) \
    macro(stringPrototypeReplaceAllCode, replaceAll, ASCIILiteral(), s_stringPrototypeReplaceAllCodeLength) \
    macro(moduleLoaderRequestFetchCode, requestFetch, ASCIILiteral(), s_moduleLoaderRequestFetchCodeLength) \
    macro(moduleLoaderRequestImportModuleCode, requestImportModule, ASCIILiteral(), s_moduleLoaderRequestImportModuleCodeLength) \
    macro(moduleLoaderRequestInstantiateCode, requestInstantiate, ASCIILiteral(), s_moduleLoaderRequestInstantiateCodeLength) \
    macro(moduleLoaderRequestSatisfyCode, requestSatisfy, ASCIILiteral(), s_moduleLoaderRequestSatisfyCodeLength) \
    macro(promiseConstructorResolveCode, resolve, ASCIILiteral(), s_promiseConstructorResolveCodeLength) \
    macro(promiseOperationsResolvePromiseCode, resolvePromise, ASCIILiteral(), s_promiseOperationsResolvePromiseCodeLength) \
    macro(promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCode, resolvePromiseWithFirstResolvingFunctionCallCheck, ASCIILiteral(), s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeLength) \
    macro(promiseOperationsResolveWithoutPromiseCode, resolveWithoutPromise, ASCIILiteral(), s_promiseOperationsResolveWithoutPromiseCodeLength) \
    macro(promiseOperationsResolveWithoutPromiseForAsyncAwaitCode, resolveWithoutPromiseForAsyncAwait, ASCIILiteral(), s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeLength) \
    macro(asyncFromSyncIteratorPrototypeReturnCode, return, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeReturnCodeLength) \
    macro(asyncGeneratorPrototypeReturnCode, return, ASCIILiteral(), s_asyncGeneratorPrototypeReturnCodeLength) \
    macro(generatorPrototypeReturnCode, return, ASCIILiteral(), s_generatorPrototypeReturnCodeLength) \
    macro(regExpPrototypeSearchCode, search, "[Symbol.search]"_s, s_regExpPrototypeSearchCodeLength) \
    macro(stringPrototypeSearchCode, search, ASCIILiteral(), s_stringPrototypeSearchCodeLength) \
    macro(setIteratorPrototypeSetIteratorNextCode, setIteratorNext, ASCIILiteral(), s_setIteratorPrototypeSetIteratorNextCodeLength) \
    macro(moduleLoaderSetStateToMaxCode, setStateToMax, ASCIILiteral(), s_moduleLoaderSetStateToMaxCodeLength) \
    macro(stringPrototypeSmallCode, small, ASCIILiteral(), s_stringPrototypeSmallCodeLength) \
    macro(arrayPrototypeSomeCode, some, ASCIILiteral(), s_arrayPrototypeSomeCodeLength) \
    macro(typedArrayPrototypeSomeCode, some, ASCIILiteral(), s_typedArrayPrototypeSomeCodeLength) \
    macro(arrayPrototypeSortCode, sort, ASCIILiteral(), s_arrayPrototypeSortCodeLength) \
    macro(typedArrayPrototypeSortCode, sort, ASCIILiteral(), s_typedArrayPrototypeSortCodeLength) \
    macro(arrayPrototypeSortBucketSortCode, sortBucketSort, ASCIILiteral(), s_arrayPrototypeSortBucketSortCodeLength) \
    macro(arrayPrototypeSortCommitCode, sortCommit, ASCIILiteral(), s_arrayPrototypeSortCommitCodeLength) \
    macro(arrayPrototypeSortCompactCode, sortCompact, ASCIILiteral(), s_arrayPrototypeSortCompactCodeLength) \
    macro(arrayPrototypeSortMergeCode, sortMerge, ASCIILiteral(), s_arrayPrototypeSortMergeCodeLength) \
    macro(arrayPrototypeSortMergeSortCode, sortMergeSort, ASCIILiteral(), s_arrayPrototypeSortMergeSortCodeLength) \
    macro(arrayPrototypeSortStringComparatorCode, sortStringComparator, ASCIILiteral(), s_arrayPrototypeSortStringComparatorCodeLength) \
    macro(globalOperationsSpeciesConstructorCode, speciesConstructor, ASCIILiteral(), s_globalOperationsSpeciesConstructorCodeLength) \
    macro(globalOperationsSpeciesGetterCode, speciesGetter, "get [Symbol.species]"_s, s_globalOperationsSpeciesGetterCodeLength) \
    macro(regExpPrototypeSplitCode, split, "[Symbol.split]"_s, s_regExpPrototypeSplitCodeLength) \
    macro(stringPrototypeSplitCode, split, ASCIILiteral(), s_stringPrototypeSplitCodeLength) \
    macro(stringPrototypeStrikeCode, strike, ASCIILiteral(), s_stringPrototypeStrikeCodeLength) \
    macro(stringPrototypeStringConcatSlowPathCode, stringConcatSlowPath, ASCIILiteral(), s_stringPrototypeStringConcatSlowPathCodeLength) \
    macro(stringPrototypeSubCode, sub, ASCIILiteral(), s_stringPrototypeSubCodeLength) \
    macro(stringPrototypeSupCode, sup, ASCIILiteral(), s_stringPrototypeSupCodeLength) \
    macro(asyncIteratorPrototypeSymbolAsyncIteratorGetterCode, symbolAsyncIteratorGetter, "[Symbol.asyncIterator]"_s, s_asyncIteratorPrototypeSymbolAsyncIteratorGetterCodeLength) \
    macro(functionPrototypeSymbolHasInstanceCode, symbolHasInstance, "[Symbol.hasInstance]"_s, s_functionPrototypeSymbolHasInstanceCodeLength) \
    macro(iteratorPrototypeSymbolIteratorGetterCode, symbolIteratorGetter, "[Symbol.iterator]"_s, s_iteratorPrototypeSymbolIteratorGetterCodeLength) \
    macro(setPrototypeSymmetricDifferenceCode, symmetricDifference, ASCIILiteral(), s_setPrototypeSymmetricDifferenceCodeLength) \
    macro(regExpPrototypeTestCode, test, ASCIILiteral(), s_regExpPrototypeTestCodeLength) \
    macro(promisePrototypeThenCode, then, ASCIILiteral(), s_promisePrototypeThenCodeLength) \
    macro(asyncFromSyncIteratorPrototypeThrowCode, throw, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeThrowCodeLength) \
    macro(asyncGeneratorPrototypeThrowCode, throw, ASCIILiteral(), s_asyncGeneratorPrototypeThrowCodeLength) \
    macro(generatorPrototypeThrowCode, throw, ASCIILiteral(), s_generatorPrototypeThrowCodeLength) \
    macro(datePrototypeToDateTimeOptionsAnyAllCode, toDateTimeOptionsAnyAll, ASCIILiteral(), s_datePrototypeToDateTimeOptionsAnyAllCodeLength) \
    macro(datePrototypeToDateTimeOptionsDateDateCode, toDateTimeOptionsDateDate, ASCIILiteral(), s_datePrototypeToDateTimeOptionsDateDateCodeLength) \
    macro(datePrototypeToDateTimeOptionsTimeTimeCode, toDateTimeOptionsTimeTime, ASCIILiteral(), s_datePrototypeToDateTimeOptionsTimeTimeCodeLength) \
    macro(globalOperationsToIntegerOrInfinityCode, toIntegerOrInfinity, ASCIILiteral(), s_globalOperationsToIntegerOrInfinityCodeLength) \
    macro(globalOperationsToLengthCode, toLength, ASCIILiteral(), s_globalOperationsToLengthCodeLength) \
    macro(datePrototypeToLocaleDateStringCode, toLocaleDateString, ASCIILiteral(), s_datePrototypeToLocaleDateStringCodeLength) \
    macro(datePrototypeToLocaleStringCode, toLocaleString, ASCIILiteral(), s_datePrototypeToLocaleStringCodeLength) \
    macro(typedArrayPrototypeToLocaleStringCode, toLocaleString, ASCIILiteral(), s_typedArrayPrototypeToLocaleStringCodeLength) \
    macro(datePrototypeToLocaleTimeStringCode, toLocaleTimeString, ASCIILiteral(), s_datePrototypeToLocaleTimeStringCodeLength) \
    macro(arrayPrototypeToReversedCode, toReversed, ASCIILiteral(), s_arrayPrototypeToReversedCodeLength) \
    macro(arrayPrototypeToSortedCode, toSorted, ASCIILiteral(), s_arrayPrototypeToSortedCodeLength) \
    macro(typedArrayPrototypeToSortedCode, toSorted, ASCIILiteral(), s_typedArrayPrototypeToSortedCodeLength) \
    macro(arrayPrototypeToSplicedCode, toSpliced, ASCIILiteral(), s_arrayPrototypeToSplicedCodeLength) \
    macro(promiseOperationsTriggerPromiseReactionsCode, triggerPromiseReactions, ASCIILiteral(), s_promiseOperationsTriggerPromiseReactionsCodeLength) \
    macro(typedArrayPrototypeTypedArrayMergeCode, typedArrayMerge, ASCIILiteral(), s_typedArrayPrototypeTypedArrayMergeCodeLength) \
    macro(typedArrayPrototypeTypedArrayMergeSortCode, typedArrayMergeSort, ASCIILiteral(), s_typedArrayPrototypeTypedArrayMergeSortCodeLength) \
    macro(typedArrayPrototypeTypedArraySpeciesConstructorCode, typedArraySpeciesConstructor, ASCIILiteral(), s_typedArrayPrototypeTypedArraySpeciesConstructorCodeLength) \
    macro(setPrototypeUnionCode, union, ASCIILiteral(), s_setPrototypeUnionCodeLength) \
    macro(arrayPrototypeWithCode, with, ASCIILiteral(), s_arrayPrototypeWithCodeLength) \
    macro(shadowRealmPrototypeWrapRemoteValueCode, wrapRemoteValue, ASCIILiteral(), s_shadowRealmPrototypeWrapRemoteValueCodeLength) \
    macro(iteratorHelpersWrappedIteratorCode, wrappedIterator, ASCIILiteral(), s_iteratorHelpersWrappedIteratorCodeLength) \

#define JSC_FOREACH_BUILTIN_FUNCTION_NAME(macro) \
    macro(AsyncFromSyncIterator) \
    macro(InternalPromise) \
    macro(Promise) \
    macro(RegExpStringIterator) \
    macro(advanceStringIndex) \
    macro(all) \
    macro(allSettled) \
    macro(anchor) \
    macro(any) \
    macro(apply) \
    macro(arrayIteratorNextHelper) \
    macro(asyncFromSyncIteratorOnFulfilledContinue) \
    macro(asyncFromSyncIteratorOnFulfilledDone) \
    macro(asyncFromSyncIteratorOnRejected) \
    macro(asyncFunctionResume) \
    macro(asyncFunctionResumeOnFulfilled) \
    macro(asyncFunctionResumeOnRejected) \
    macro(asyncGeneratorEnqueue) \
    macro(asyncGeneratorQueueDequeue) \
    macro(asyncGeneratorQueueEnqueue) \
    macro(asyncGeneratorQueueIsEmpty) \
    macro(asyncGeneratorReject) \
    macro(asyncGeneratorResolve) \
    macro(asyncGeneratorResumeNext) \
    macro(asyncGeneratorResumeNextOnFulfilled) \
    macro(asyncGeneratorResumeNextOnRejected) \
    macro(asyncGeneratorYield) \
    macro(asyncGeneratorYieldAwaited) \
    macro(asyncGeneratorYieldOnRejected) \
    macro(asyncModuleEvaluation) \
    macro(at) \
    macro(awaitValue) \
    macro(big) \
    macro(blink) \
    macro(bold) \
    macro(builtinMapIterable) \
    macro(builtinSetIterable) \
    macro(call) \
    macro(catch) \
    macro(compileStreaming) \
    macro(concat) \
    macro(concatSlowPath) \
    macro(copyWithin) \
    macro(createArrayWithoutPrototype) \
    macro(createAsyncFromSyncIterator) \
    macro(createHTML) \
    macro(createInspectorInjectedScript) \
    macro(createObjectWithoutPrototype) \
    macro(createResolvingFunctions) \
    macro(createResolvingFunctionsWithoutPromise) \
    macro(crossRealmThrow) \
    macro(defaultAsyncFromAsyncArrayLike) \
    macro(defaultAsyncFromAsyncIterator) \
    macro(deleteProperty) \
    macro(dependencyKeysIfEvaluated) \
    macro(difference) \
    macro(doAsyncGeneratorBodyCall) \
    macro(doAsyncGeneratorBodyCallOnFulfilledNormal) \
    macro(doAsyncGeneratorBodyCallOnFulfilledReturn) \
    macro(ensureRegistered) \
    macro(evaluate) \
    macro(every) \
    macro(fill) \
    macro(filter) \
    macro(finally) \
    macro(find) \
    macro(findIndex) \
    macro(findLast) \
    macro(findLastIndex) \
    macro(fixed) \
    macro(flat) \
    macro(flatIntoArray) \
    macro(flatIntoArrayWithCallback) \
    macro(flatMap) \
    macro(fontcolor) \
    macro(fontsize) \
    macro(forEach) \
    macro(forceFulfillPromise) \
    macro(from) \
    macro(fromAsync) \
    macro(fromEntries) \
    macro(fulfillFetch) \
    macro(fulfillPromise) \
    macro(fulfillPromiseWithFirstResolvingFunctionCallCheck) \
    macro(fulfillWithoutPromise) \
    macro(generatorResume) \
    macro(get) \
    macro(getSubstitution) \
    macro(group) \
    macro(groupToMap) \
    macro(has) \
    macro(hasObservableSideEffectsForRegExpMatch) \
    macro(hasObservableSideEffectsForRegExpSplit) \
    macro(hasObservableSideEffectsForStringReplace) \
    macro(importValue) \
    macro(includes) \
    macro(instantiateStreaming) \
    macro(internalAll) \
    macro(intersection) \
    macro(isArray) \
    macro(isDisjointFrom) \
    macro(isExecutionState) \
    macro(isFinite) \
    macro(isNaN) \
    macro(isSubsetOf) \
    macro(isSupersetOf) \
    macro(isSuspendYieldState) \
    macro(italics) \
    macro(link) \
    macro(linkAndEvaluateModule) \
    macro(loadAndEvaluateModule) \
    macro(loadModule) \
    macro(map) \
    macro(mapIteratorNext) \
    macro(match) \
    macro(matchAll) \
    macro(matchSlow) \
    macro(maxWithPositives) \
    macro(minWithMaybeNegativeZeroAndPositive) \
    macro(moduleEvaluation) \
    macro(newHandledRejectedPromise) \
    macro(newPromiseCapability) \
    macro(newPromiseCapabilitySlow) \
    macro(newRegistryEntry) \
    macro(next) \
    macro(of) \
    macro(padEnd) \
    macro(padStart) \
    macro(performIteration) \
    macro(performPromiseThen) \
    macro(performProxyObjectGet) \
    macro(performProxyObjectGetByVal) \
    macro(performProxyObjectHas) \
    macro(performProxyObjectSetSloppy) \
    macro(performProxyObjectSetStrict) \
    macro(promiseAllNewResolveElement) \
    macro(promiseAllOnFulfilled) \
    macro(promiseAllSlow) \
    macro(promiseEmptyOnFulfilled) \
    macro(promiseEmptyOnRejected) \
    macro(promiseNewOnRejected) \
    macro(promiseOnRejectedWithContext) \
    macro(promiseReactionJob) \
    macro(promiseReactionJobWithoutPromise) \
    macro(promiseRejectSlow) \
    macro(promiseResolve) \
    macro(promiseResolveSlow) \
    macro(promiseResolveThenableJob) \
    macro(promiseResolveThenableJobFast) \
    macro(promiseResolveThenableJobWithDerivedPromise) \
    macro(promiseResolveThenableJobWithoutPromiseFast) \
    macro(provideFetch) \
    macro(pushNewPromiseReaction) \
    macro(race) \
    macro(raw) \
    macro(reduce) \
    macro(reduceRight) \
    macro(regExpExec) \
    macro(reject) \
    macro(rejectPromise) \
    macro(rejectPromiseWithFirstResolvingFunctionCallCheck) \
    macro(rejectWithoutPromise) \
    macro(repeat) \
    macro(repeatCharactersSlowPath) \
    macro(repeatSlowPath) \
    macro(replace) \
    macro(replaceAll) \
    macro(requestFetch) \
    macro(requestImportModule) \
    macro(requestInstantiate) \
    macro(requestSatisfy) \
    macro(resolve) \
    macro(resolvePromise) \
    macro(resolvePromiseWithFirstResolvingFunctionCallCheck) \
    macro(resolveWithoutPromise) \
    macro(resolveWithoutPromiseForAsyncAwait) \
    macro(return) \
    macro(search) \
    macro(setIteratorNext) \
    macro(setStateToMax) \
    macro(small) \
    macro(some) \
    macro(sort) \
    macro(sortBucketSort) \
    macro(sortCommit) \
    macro(sortCompact) \
    macro(sortMerge) \
    macro(sortMergeSort) \
    macro(sortStringComparator) \
    macro(speciesConstructor) \
    macro(speciesGetter) \
    macro(split) \
    macro(strike) \
    macro(stringConcatSlowPath) \
    macro(sub) \
    macro(sup) \
    macro(symbolAsyncIteratorGetter) \
    macro(symbolHasInstance) \
    macro(symbolIteratorGetter) \
    macro(symmetricDifference) \
    macro(test) \
    macro(then) \
    macro(throw) \
    macro(toDateTimeOptionsAnyAll) \
    macro(toDateTimeOptionsDateDate) \
    macro(toDateTimeOptionsTimeTime) \
    macro(toIntegerOrInfinity) \
    macro(toLength) \
    macro(toLocaleDateString) \
    macro(toLocaleString) \
    macro(toLocaleTimeString) \
    macro(toReversed) \
    macro(toSorted) \
    macro(toSpliced) \
    macro(triggerPromiseReactions) \
    macro(typedArrayMerge) \
    macro(typedArrayMergeSort) \
    macro(typedArraySpeciesConstructor) \
    macro(union) \
    macro(with) \
    macro(wrapRemoteValue) \
    macro(wrappedIterator) \

#define JSC_FOREACH_BUILTIN_LINK_TIME_CONSTANT(macro) \
    macro(AsyncFromSyncIterator, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorConstructor) \
    macro(RegExpStringIterator, regExpPrototypeRegExpStringIteratorConstructor) \
    macro(advanceStringIndex, regExpPrototypeAdvanceStringIndex) \
    macro(arrayIteratorNextHelper, arrayIteratorPrototypeArrayIteratorNextHelper) \
    macro(asyncFromSyncIteratorOnFulfilledContinue, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinue) \
    macro(asyncFromSyncIteratorOnFulfilledDone, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDone) \
    macro(asyncFromSyncIteratorOnRejected, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejected) \
    macro(asyncFunctionResume, asyncFunctionPrototypeAsyncFunctionResume) \
    macro(asyncFunctionResumeOnFulfilled, asyncFunctionPrototypeAsyncFunctionResumeOnFulfilled) \
    macro(asyncFunctionResumeOnRejected, asyncFunctionPrototypeAsyncFunctionResumeOnRejected) \
    macro(asyncGeneratorEnqueue, asyncGeneratorPrototypeAsyncGeneratorEnqueue) \
    macro(asyncGeneratorQueueDequeue, asyncGeneratorPrototypeAsyncGeneratorQueueDequeue) \
    macro(asyncGeneratorQueueEnqueue, asyncGeneratorPrototypeAsyncGeneratorQueueEnqueue) \
    macro(asyncGeneratorQueueIsEmpty, asyncGeneratorPrototypeAsyncGeneratorQueueIsEmpty) \
    macro(asyncGeneratorReject, asyncGeneratorPrototypeAsyncGeneratorReject) \
    macro(asyncGeneratorResolve, asyncGeneratorPrototypeAsyncGeneratorResolve) \
    macro(asyncGeneratorResumeNext, asyncGeneratorPrototypeAsyncGeneratorResumeNext) \
    macro(asyncGeneratorResumeNextOnFulfilled, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilled) \
    macro(asyncGeneratorResumeNextOnRejected, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejected) \
    macro(asyncGeneratorYield, asyncGeneratorPrototypeAsyncGeneratorYield) \
    macro(asyncGeneratorYieldAwaited, asyncGeneratorPrototypeAsyncGeneratorYieldAwaited) \
    macro(asyncGeneratorYieldOnRejected, asyncGeneratorPrototypeAsyncGeneratorYieldOnRejected) \
    macro(awaitValue, asyncGeneratorPrototypeAwaitValue) \
    macro(builtinMapIterable, iteratorHelpersBuiltinMapIterable) \
    macro(builtinSetIterable, iteratorHelpersBuiltinSetIterable) \
    macro(concatSlowPath, arrayPrototypeConcatSlowPath) \
    macro(createArrayWithoutPrototype, injectedScriptSourceCreateArrayWithoutPrototype) \
    macro(createAsyncFromSyncIterator, asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIterator) \
    macro(createHTML, stringPrototypeCreateHTML) \
    macro(createInspectorInjectedScript, injectedScriptSourceCreateInspectorInjectedScript) \
    macro(createObjectWithoutPrototype, injectedScriptSourceCreateObjectWithoutPrototype) \
    macro(createResolvingFunctions, promiseOperationsCreateResolvingFunctions) \
    macro(createResolvingFunctionsWithoutPromise, promiseOperationsCreateResolvingFunctionsWithoutPromise) \
    macro(crossRealmThrow, shadowRealmPrototypeCrossRealmThrow) \
    macro(defaultAsyncFromAsyncArrayLike, arrayConstructorDefaultAsyncFromAsyncArrayLike) \
    macro(defaultAsyncFromAsyncIterator, arrayConstructorDefaultAsyncFromAsyncIterator) \
    macro(doAsyncGeneratorBodyCall, asyncGeneratorPrototypeDoAsyncGeneratorBodyCall) \
    macro(doAsyncGeneratorBodyCallOnFulfilledNormal, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormal) \
    macro(doAsyncGeneratorBodyCallOnFulfilledReturn, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturn) \
    macro(flatIntoArray, arrayPrototypeFlatIntoArray) \
    macro(flatIntoArrayWithCallback, arrayPrototypeFlatIntoArrayWithCallback) \
    macro(forceFulfillPromise, moduleLoaderForceFulfillPromise) \
    macro(fulfillFetch, moduleLoaderFulfillFetch) \
    macro(fulfillPromise, promiseOperationsFulfillPromise) \
    macro(fulfillPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheck) \
    macro(fulfillWithoutPromise, promiseOperationsFulfillWithoutPromise) \
    macro(generatorResume, generatorPrototypeGeneratorResume) \
    macro(getSubstitution, regExpPrototypeGetSubstitution) \
    macro(hasObservableSideEffectsForRegExpMatch, regExpPrototypeHasObservableSideEffectsForRegExpMatch) \
    macro(hasObservableSideEffectsForRegExpSplit, regExpPrototypeHasObservableSideEffectsForRegExpSplit) \
    macro(hasObservableSideEffectsForStringReplace, stringPrototypeHasObservableSideEffectsForStringReplace) \
    macro(isExecutionState, asyncGeneratorPrototypeIsExecutionState) \
    macro(isFinite, globalObjectIsFinite) \
    macro(isNaN, globalObjectIsNaN) \
    macro(isSuspendYieldState, asyncGeneratorPrototypeIsSuspendYieldState) \
    macro(mapIteratorNext, mapIteratorPrototypeMapIteratorNext) \
    macro(matchSlow, regExpPrototypeMatchSlow) \
    macro(maxWithPositives, arrayPrototypeMaxWithPositives) \
    macro(minWithMaybeNegativeZeroAndPositive, arrayPrototypeMinWithMaybeNegativeZeroAndPositive) \
    macro(newHandledRejectedPromise, promiseOperationsNewHandledRejectedPromise) \
    macro(newPromiseCapability, promiseOperationsNewPromiseCapability) \
    macro(newPromiseCapabilitySlow, promiseOperationsNewPromiseCapabilitySlow) \
    macro(newRegistryEntry, moduleLoaderNewRegistryEntry) \
    macro(performIteration, iteratorHelpersPerformIteration) \
    macro(performPromiseThen, promiseOperationsPerformPromiseThen) \
    macro(performProxyObjectGet, proxyHelpersPerformProxyObjectGet) \
    macro(performProxyObjectGetByVal, proxyHelpersPerformProxyObjectGetByVal) \
    macro(performProxyObjectHas, proxyHelpersPerformProxyObjectHas) \
    macro(performProxyObjectSetSloppy, proxyHelpersPerformProxyObjectSetSloppy) \
    macro(performProxyObjectSetStrict, proxyHelpersPerformProxyObjectSetStrict) \
    macro(promiseAllNewResolveElement, promiseConstructorPromiseAllNewResolveElement) \
    macro(promiseAllOnFulfilled, promiseConstructorPromiseAllOnFulfilled) \
    macro(promiseAllSlow, promiseConstructorPromiseAllSlow) \
    macro(promiseEmptyOnFulfilled, promiseOperationsPromiseEmptyOnFulfilled) \
    macro(promiseEmptyOnRejected, promiseOperationsPromiseEmptyOnRejected) \
    macro(promiseNewOnRejected, promiseConstructorPromiseNewOnRejected) \
    macro(promiseOnRejectedWithContext, promiseConstructorPromiseOnRejectedWithContext) \
    macro(promiseReactionJob, promiseOperationsPromiseReactionJob) \
    macro(promiseReactionJobWithoutPromise, promiseOperationsPromiseReactionJobWithoutPromise) \
    macro(promiseRejectSlow, promiseOperationsPromiseRejectSlow) \
    macro(promiseResolve, promiseOperationsPromiseResolve) \
    macro(promiseResolveSlow, promiseOperationsPromiseResolveSlow) \
    macro(promiseResolveThenableJob, promiseOperationsPromiseResolveThenableJob) \
    macro(promiseResolveThenableJobFast, promiseOperationsPromiseResolveThenableJobFast) \
    macro(promiseResolveThenableJobWithDerivedPromise, promiseOperationsPromiseResolveThenableJobWithDerivedPromise) \
    macro(promiseResolveThenableJobWithoutPromiseFast, promiseOperationsPromiseResolveThenableJobWithoutPromiseFast) \
    macro(pushNewPromiseReaction, promiseOperationsPushNewPromiseReaction) \
    macro(regExpExec, regExpPrototypeRegExpExec) \
    macro(rejectPromise, promiseOperationsRejectPromise) \
    macro(rejectPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheck) \
    macro(rejectWithoutPromise, promiseOperationsRejectWithoutPromise) \
    macro(repeatCharactersSlowPath, stringPrototypeRepeatCharactersSlowPath) \
    macro(repeatSlowPath, stringPrototypeRepeatSlowPath) \
    macro(resolvePromise, promiseOperationsResolvePromise) \
    macro(resolvePromiseWithFirstResolvingFunctionCallCheck, promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheck) \
    macro(resolveWithoutPromise, promiseOperationsResolveWithoutPromise) \
    macro(resolveWithoutPromiseForAsyncAwait, promiseOperationsResolveWithoutPromiseForAsyncAwait) \
    macro(setIteratorNext, setIteratorPrototypeSetIteratorNext) \
    macro(setStateToMax, moduleLoaderSetStateToMax) \
    macro(sortBucketSort, arrayPrototypeSortBucketSort) \
    macro(sortCommit, arrayPrototypeSortCommit) \
    macro(sortCompact, arrayPrototypeSortCompact) \
    macro(sortMerge, arrayPrototypeSortMerge) \
    macro(sortMergeSort, arrayPrototypeSortMergeSort) \
    macro(sortStringComparator, arrayPrototypeSortStringComparator) \
    macro(speciesConstructor, globalOperationsSpeciesConstructor) \
    macro(stringConcatSlowPath, stringPrototypeStringConcatSlowPath) \
    macro(toDateTimeOptionsAnyAll, datePrototypeToDateTimeOptionsAnyAll) \
    macro(toDateTimeOptionsDateDate, datePrototypeToDateTimeOptionsDateDate) \
    macro(toDateTimeOptionsTimeTime, datePrototypeToDateTimeOptionsTimeTime) \
    macro(toIntegerOrInfinity, globalOperationsToIntegerOrInfinity) \
    macro(toLength, globalOperationsToLength) \
    macro(triggerPromiseReactions, promiseOperationsTriggerPromiseReactions) \
    macro(typedArrayMerge, typedArrayPrototypeTypedArrayMerge) \
    macro(typedArrayMergeSort, typedArrayPrototypeTypedArrayMergeSort) \
    macro(typedArraySpeciesConstructor, typedArrayPrototypeTypedArraySpeciesConstructor) \
    macro(wrapRemoteValue, shadowRealmPrototypeWrapRemoteValue) \
    macro(wrappedIterator, iteratorHelpersWrappedIterator) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

JSC_FOREACH_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

} // namespace JSC
