/*
 * Copyright (C) 2025 Samuel Weinig <sam@webkit.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <WebCore/CSSValueConcepts.h>
#include <WebCore/CompositeOperation.h>
#include <WebCore/FontSizeAdjust.h>
#include <WebCore/GraphicsTypes.h>
#include <WebCore/PositionTryOrder.h>
#include <WebCore/RenderStyleConstants.h>
#include <WebCore/ScrollAxis.h>
#include <WebCore/ScrollTypes.h>
#include <WebCore/StyleAppearance.h>
#include <WebCore/StyleLineBoxContain.h>
#include <WebCore/StyleScrollBehavior.h>
#include <WebCore/StyleTextDecorationLine.h>
#include <WebCore/TextFlags.h>
#include <WebCore/ThemeTypes.h>
#include <WebCore/TouchAction.h>
#include <WebCore/UnicodeBidi.h>
#include <WebCore/WindRule.h>
#include <WebCore/WritingMode.h>

#if ENABLE(APPLE_PAY)
#include <WebCore/ApplePayButtonPart.h>
#endif

#if HAVE(CORE_MATERIAL)
#include <WebCore/AppleVisualEffect.h>
#endif

#if ENABLE(WEBKIT_TOUCH_CALLOUT_CSS_PROPERTY)
#include <WebCore/StyleWebKitOverflowScrolling.h>
#endif

#if ENABLE(WEBKIT_TOUCH_CALLOUT_CSS_PROPERTY)
#include <WebCore/StyleWebKitTouchCallout.h>
#endif

// FIXME: Add specializations of ValueRepresentation for all enums listed in this file.

// Helper to define an enum that still needs a value representation conformance.
#define DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(t) \
    template<> inline constexpr auto EnumHasValueRepresentation<t> = false;

namespace WebCore {

DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(AlignmentBaseline)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(AnimationDirection)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(AnimationFillMode)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(AnimationPlayState)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BackfaceVisibility)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BlendMode)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BlockStepAlign)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BlockStepInsert)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BlockStepRound)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BorderCollapse)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BorderStyle)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BoxAlignment)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BoxDecorationBreak)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BoxDirection)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BoxLines)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BoxOrient)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BoxPack)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BoxSizing)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BreakBetween)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BreakInside)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BufferedRendering)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(CaptionSide)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Clear)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ColorInterpolation)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ColumnAxis)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ColumnFill)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ColumnProgression)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ColumnSpan)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(CompositeOperation)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ContainerType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ContentVisibility)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(CSSBoxType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(CursorType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(DisplayType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(DominantBaseline)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(EmptyCell)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FieldSizing)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FillAttachment)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FillBox)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FillRepeat)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FlexDirection)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FlexWrap)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Float)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontOpticalSizing)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontSizeAdjust::Metric)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontSmoothingMode)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontSynthesisLonghandValue)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontVariantCaps)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontVariantEmoji)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontVariantPosition)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Hyphens)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ImageRendering)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(InputSecurity)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Isolation)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Kerning)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(LineAlign)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(LineBreak)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(LineCap)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(LineJoin)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(LineSnap)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ListStylePosition)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(MaskType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(MathShift)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(MathStyle)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(NBSPMode)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(NinePieceImageRule)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ObjectFit)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Order)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(OutlineStyle)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Overflow)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(OverflowAnchor)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(OverflowContinue)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(OverflowWrap)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(OverscrollBehavior)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(PointerEvents)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(PositionType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(PrintColorAdjust)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(QuoteType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ReflectionDirection)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Resize)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(RubyAlign)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(RubyOverhang)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(RubyPosition)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ScrollAxis)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ScrollbarWidth)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Scroller)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ScrollSnapAxis)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ScrollSnapAxisAlignType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ScrollSnapStop)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ShapeRendering)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Style::LineBoxContain)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Style::PositionTryOrder)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Style::ScrollBehavior)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(StyleAppearance)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TableLayoutType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextAlignLast)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextAlignMode)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextAnchor)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextBoxTrim)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextCombine)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextDecorationSkipInk)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextDecorationStyle)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextEdgeOver)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextEdgeUnder)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextEmphasisFill)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextEmphasisMark)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextGroupAlign)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextJustify)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextOrientation)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextOverflow)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextRenderingMode)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextSecurity)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextWrapMode)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextWrapStyle)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextZoom)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TransformBox)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TransformStyle3D)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TransitionBehavior)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(UnicodeBidi)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(UserDrag)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(UserModify)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(UserSelect)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(VectorEffect)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Visibility)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(WhiteSpaceCollapse)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(WindRule)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(WordBreak)

#if ENABLE(APPLE_PAY)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ApplePayButtonStyle)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ApplePayButtonType)
#endif

#if HAVE(CORE_MATERIAL)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(AppleVisualEffect)
#endif

#if ENABLE(CURSOR_VISIBILITY)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(CursorVisibility)
#endif

#if ENABLE(WEBKIT_OVERFLOW_SCROLLING_CSS_PROPERTY)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Style::WebkitOverflowScrolling)
#endif

#if ENABLE(WEBKIT_TOUCH_CALLOUT_CSS_PROPERTY)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Style::WebkitTouchCallout)
#endif

} // namespace WebCore

#undef DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE
