/*
 * Copyright (C) 2025 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 * Autogenerated, do not modify.
*/

#pragma once

#define FOR_EACH_BYTECODE_ID(macro) \
    macro(op_tail_call_varargs, 7) \
    macro(op_call_varargs, 8) \
    macro(op_iterator_next, 10) \
    macro(op_construct_varargs, 8) \
    macro(op_super_construct_varargs, 8) \
    macro(op_iterator_open, 9) \
    macro(op_instanceof, 7) \
    macro(op_set_private_brand, 3) \
    macro(op_check_private_brand, 3) \
    macro(op_put_by_id, 5) \
    macro(op_construct, 6) \
    macro(op_super_construct, 6) \
    macro(op_tail_call, 5) \
    macro(op_call_direct_eval, 9) \
    macro(op_tail_call_forward_arguments, 7) \
    macro(op_create_generator, 3) \
    macro(op_create_async_generator, 3) \
    macro(op_create_promise, 4) \
    macro(op_catch, 3) \
    macro(op_new_array_with_size, 3) \
    macro(op_new_array_buffer, 4) \
    macro(op_get_by_id, 5) \
    macro(op_get_length, 4) \
    macro(op_profile_type, 6) \
    macro(op_profile_control_flow, 2) \
    macro(op_new_array_with_species, 5) \
    macro(op_call, 6) \
    macro(op_call_ignore_result, 4) \
    macro(op_resolve_scope, 6) \
    macro(op_get_from_scope, 8) \
    macro(op_put_to_scope, 7) \
    macro(op_create_this, 4) \
    macro(op_new_object, 3) \
    macro(op_new_array, 5) \
    macro(op_put_private_name, 5) \
    macro(op_get_private_name, 5) \
    macro(op_get_by_val_with_this, 6) \
    macro(op_get_by_val, 5) \
    macro(op_put_by_val, 5) \
    macro(op_put_by_val_direct, 5) \
    macro(op_in_by_val, 4) \
    macro(op_enumerator_next, 6) \
    macro(op_enumerator_in_by_val, 7) \
    macro(op_enumerator_has_own_property, 7) \
    macro(op_enumerator_put_by_val, 8) \
    macro(op_to_this, 4) \
    macro(op_enumerator_get_by_val, 8) \
    macro(op_get_by_id_direct, 5) \
    macro(op_try_get_by_id, 5) \
    macro(op_jneq_ptr, 4) \
    macro(op_get_argument, 3) \
    macro(op_get_from_arguments, 4) \
    macro(op_get_prototype_of, 3) \
    macro(op_get_internal_field, 4) \
    macro(op_get_by_id_with_this, 5) \
    macro(op_to_object, 4) \
    macro(op_in_by_id, 3) \
    macro(op_has_private_name, 3) \
    macro(op_has_private_brand, 3) \
    macro(op_put_by_id_with_this, 5) \
    macro(op_del_by_id, 4) \
    macro(op_put_by_val_with_this, 5) \
    macro(op_del_by_val, 4) \
    macro(op_put_getter_by_id, 4) \
    macro(op_put_setter_by_id, 4) \
    macro(op_put_getter_setter_by_id, 5) \
    macro(op_put_getter_by_val, 4) \
    macro(op_put_setter_by_val, 4) \
    macro(op_define_data_property, 4) \
    macro(op_define_accessor_property, 5) \
    macro(op_jmp, 1) \
    macro(op_jtrue, 2) \
    macro(op_jfalse, 2) \
    macro(op_jeq_null, 2) \
    macro(op_jneq_null, 2) \
    macro(op_jundefined_or_null, 2) \
    macro(op_jnundefined_or_null, 2) \
    macro(op_jeq_ptr, 3) \
    macro(op_jeq, 3) \
    macro(op_jstricteq, 3) \
    macro(op_jneq, 3) \
    macro(op_jnstricteq, 3) \
    macro(op_jless, 3) \
    macro(op_jlesseq, 3) \
    macro(op_jgreater, 3) \
    macro(op_jgreatereq, 3) \
    macro(op_jnless, 3) \
    macro(op_jnlesseq, 3) \
    macro(op_jngreater, 3) \
    macro(op_jngreatereq, 3) \
    macro(op_jbelow, 3) \
    macro(op_jbeloweq, 3) \
    macro(op_loop_hint, 0) \
    macro(op_switch_imm, 2) \
    macro(op_switch_char, 2) \
    macro(op_switch_string, 2) \
    macro(op_new_func, 3) \
    macro(op_new_func_exp, 3) \
    macro(op_new_generator_func, 3) \
    macro(op_new_generator_func_exp, 3) \
    macro(op_new_async_func, 3) \
    macro(op_new_async_func_exp, 3) \
    macro(op_new_async_generator_func, 3) \
    macro(op_new_async_generator_func_exp, 3) \
    macro(op_set_function_name, 2) \
    macro(op_ret, 1) \
    macro(op_strcat, 3) \
    macro(op_to_primitive, 2) \
    macro(op_to_property_key, 2) \
    macro(op_to_property_key_or_number, 2) \
    macro(op_put_to_arguments, 3) \
    macro(op_push_with_scope, 3) \
    macro(op_create_lexical_environment, 4) \
    macro(op_create_generator_frame_environment, 4) \
    macro(op_get_parent_scope, 2) \
    macro(op_throw, 1) \
    macro(op_throw_static_error, 2) \
    macro(op_debug, 2) \
    macro(op_end, 1) \
    macro(op_get_property_enumerator, 2) \
    macro(op_unreachable, 0) \
    macro(op_create_rest, 3) \
    macro(op_get_rest_length, 2) \
    macro(op_yield, 2) \
    macro(op_check_traps, 0) \
    macro(op_log_shadow_chicken_prologue, 1) \
    macro(op_log_shadow_chicken_tail, 2) \
    macro(op_resolve_scope_for_hoisting_func_decl_in_eval, 3) \
    macro(op_put_internal_field, 3) \
    macro(op_nop, 0) \
    macro(op_super_sampler_begin, 0) \
    macro(op_wide16, 0) \
    macro(op_super_sampler_end, 0) \
    macro(op_wide32, 0) \
    macro(op_enter, 0) \
    macro(op_get_scope, 1) \
    macro(op_create_direct_arguments, 1) \
    macro(op_create_scoped_arguments, 2) \
    macro(op_create_cloned_arguments, 1) \
    macro(op_new_promise, 2) \
    macro(op_new_generator, 1) \
    macro(op_argument_count, 1) \
    macro(op_check_tdz, 1) \
    macro(op_new_array_with_spread, 4) \
    macro(op_spread, 2) \
    macro(op_new_reg_exp, 2) \
    macro(op_mov, 2) \
    macro(op_eq, 3) \
    macro(op_neq, 3) \
    macro(op_stricteq, 3) \
    macro(op_nstricteq, 3) \
    macro(op_less, 3) \
    macro(op_lesseq, 3) \
    macro(op_greater, 3) \
    macro(op_greatereq, 3) \
    macro(op_below, 3) \
    macro(op_beloweq, 3) \
    macro(op_mod, 3) \
    macro(op_pow, 3) \
    macro(op_urshift, 3) \
    macro(op_add, 5) \
    macro(op_mul, 5) \
    macro(op_div, 5) \
    macro(op_sub, 5) \
    macro(op_bitand, 5) \
    macro(op_bitor, 5) \
    macro(op_bitxor, 5) \
    macro(op_lshift, 4) \
    macro(op_rshift, 4) \
    macro(op_eq_null, 2) \
    macro(op_neq_null, 2) \
    macro(op_to_string, 2) \
    macro(op_unsigned, 2) \
    macro(op_is_empty, 2) \
    macro(op_typeof_is_undefined, 2) \
    macro(op_typeof_is_object, 2) \
    macro(op_typeof_is_function, 2) \
    macro(op_is_undefined_or_null, 2) \
    macro(op_is_boolean, 2) \
    macro(op_is_number, 2) \
    macro(op_is_big_int, 2) \
    macro(op_is_object, 2) \
    macro(op_is_callable, 2) \
    macro(op_is_constructor, 2) \
    macro(op_inc, 2) \
    macro(op_dec, 2) \
    macro(op_negate, 4) \
    macro(op_not, 2) \
    macro(op_identity_with_profile, 3) \
    macro(op_overrides_has_instance, 3) \
    macro(op_typeof, 2) \
    macro(op_is_cell_with_type, 3) \
    macro(op_has_structure_with_flags, 3) \
    macro(op_to_number, 3) \
    macro(op_to_numeric, 3) \
    macro(op_bitnot, 3) \

#define NUMBER_OF_BYTECODE_IDS 196
#define MAX_LENGTH_OF_BYTECODE_IDS 10
static constexpr unsigned bytecodeCheckpointCountTable[] = {
    2,
    2,
    3,
    2,
    2,
    2,
    3,
};

#define NUMBER_OF_BYTECODE_WITH_CHECKPOINTS 7

#define FOR_EACH_BYTECODE_METADATA_SIZE(macro) \
    macro(sizeof(OpTailCallVarargs::Metadata))\
    macro(sizeof(OpCallVarargs::Metadata))\
    macro(sizeof(OpIteratorNext::Metadata))\
    macro(sizeof(OpConstructVarargs::Metadata))\
    macro(sizeof(OpSuperConstructVarargs::Metadata))\
    macro(sizeof(OpIteratorOpen::Metadata))\
    macro(sizeof(OpInstanceof::Metadata))\
    macro(sizeof(OpSetPrivateBrand::Metadata))\
    macro(sizeof(OpCheckPrivateBrand::Metadata))\
    macro(sizeof(OpPutById::Metadata))\
    macro(sizeof(OpConstruct::Metadata))\
    macro(sizeof(OpSuperConstruct::Metadata))\
    macro(sizeof(OpTailCall::Metadata))\
    macro(sizeof(OpCallDirectEval::Metadata))\
    macro(sizeof(OpTailCallForwardArguments::Metadata))\
    macro(sizeof(OpCreateGenerator::Metadata))\
    macro(sizeof(OpCreateAsyncGenerator::Metadata))\
    macro(sizeof(OpCreatePromise::Metadata))\
    macro(sizeof(OpCatch::Metadata))\
    macro(sizeof(OpNewArrayWithSize::Metadata))\
    macro(sizeof(OpNewArrayBuffer::Metadata))\
    macro(sizeof(OpGetById::Metadata))\
    macro(sizeof(OpGetLength::Metadata))\
    macro(sizeof(OpProfileType::Metadata))\
    macro(sizeof(OpProfileControlFlow::Metadata))\
    macro(sizeof(OpNewArrayWithSpecies::Metadata))\
    macro(sizeof(OpCall::Metadata))\
    macro(sizeof(OpCallIgnoreResult::Metadata))\
    macro(sizeof(OpResolveScope::Metadata))\
    macro(sizeof(OpGetFromScope::Metadata))\
    macro(sizeof(OpPutToScope::Metadata))\
    macro(sizeof(OpCreateThis::Metadata))\
    macro(sizeof(OpNewObject::Metadata))\
    macro(sizeof(OpNewArray::Metadata))\
    macro(sizeof(OpPutPrivateName::Metadata))\
    macro(sizeof(OpGetPrivateName::Metadata))\
    macro(sizeof(OpGetByValWithThis::Metadata))\
    macro(sizeof(OpGetByVal::Metadata))\
    macro(sizeof(OpPutByVal::Metadata))\
    macro(sizeof(OpPutByValDirect::Metadata))\
    macro(sizeof(OpInByVal::Metadata))\
    macro(sizeof(OpEnumeratorNext::Metadata))\
    macro(sizeof(OpEnumeratorInByVal::Metadata))\
    macro(sizeof(OpEnumeratorHasOwnProperty::Metadata))\
    macro(sizeof(OpEnumeratorPutByVal::Metadata))\
    macro(sizeof(OpToThis::Metadata))\
    macro(sizeof(OpEnumeratorGetByVal::Metadata))\
    macro(sizeof(OpGetByIdDirect::Metadata))\
    macro(sizeof(OpTryGetById::Metadata))\
    macro(sizeof(OpJneqPtr::Metadata))\

#define NUMBER_OF_BYTECODE_WITH_METADATA 50

#define FOR_EACH_BYTECODE_METADATA_ALIGNMENT(macro) \
    macro(alignof(OpTailCallVarargs::Metadata))\
    macro(alignof(OpCallVarargs::Metadata))\
    macro(alignof(OpIteratorNext::Metadata))\
    macro(alignof(OpConstructVarargs::Metadata))\
    macro(alignof(OpSuperConstructVarargs::Metadata))\
    macro(alignof(OpIteratorOpen::Metadata))\
    macro(alignof(OpInstanceof::Metadata))\
    macro(alignof(OpSetPrivateBrand::Metadata))\
    macro(alignof(OpCheckPrivateBrand::Metadata))\
    macro(alignof(OpPutById::Metadata))\
    macro(alignof(OpConstruct::Metadata))\
    macro(alignof(OpSuperConstruct::Metadata))\
    macro(alignof(OpTailCall::Metadata))\
    macro(alignof(OpCallDirectEval::Metadata))\
    macro(alignof(OpTailCallForwardArguments::Metadata))\
    macro(alignof(OpCreateGenerator::Metadata))\
    macro(alignof(OpCreateAsyncGenerator::Metadata))\
    macro(alignof(OpCreatePromise::Metadata))\
    macro(alignof(OpCatch::Metadata))\
    macro(alignof(OpNewArrayWithSize::Metadata))\
    macro(alignof(OpNewArrayBuffer::Metadata))\
    macro(alignof(OpGetById::Metadata))\
    macro(alignof(OpGetLength::Metadata))\
    macro(alignof(OpProfileType::Metadata))\
    macro(alignof(OpProfileControlFlow::Metadata))\
    macro(alignof(OpNewArrayWithSpecies::Metadata))\
    macro(alignof(OpCall::Metadata))\
    macro(alignof(OpCallIgnoreResult::Metadata))\
    macro(alignof(OpResolveScope::Metadata))\
    macro(alignof(OpGetFromScope::Metadata))\
    macro(alignof(OpPutToScope::Metadata))\
    macro(alignof(OpCreateThis::Metadata))\
    macro(alignof(OpNewObject::Metadata))\
    macro(alignof(OpNewArray::Metadata))\
    macro(alignof(OpPutPrivateName::Metadata))\
    macro(alignof(OpGetPrivateName::Metadata))\
    macro(alignof(OpGetByValWithThis::Metadata))\
    macro(alignof(OpGetByVal::Metadata))\
    macro(alignof(OpPutByVal::Metadata))\
    macro(alignof(OpPutByValDirect::Metadata))\
    macro(alignof(OpInByVal::Metadata))\
    macro(alignof(OpEnumeratorNext::Metadata))\
    macro(alignof(OpEnumeratorInByVal::Metadata))\
    macro(alignof(OpEnumeratorHasOwnProperty::Metadata))\
    macro(alignof(OpEnumeratorPutByVal::Metadata))\
    macro(alignof(OpToThis::Metadata))\
    macro(alignof(OpEnumeratorGetByVal::Metadata))\
    macro(alignof(OpGetByIdDirect::Metadata))\
    macro(alignof(OpTryGetById::Metadata))\
    macro(alignof(OpJneqPtr::Metadata))\

#define op_tail_call_varargs_value_string "0"
#define op_call_varargs_value_string "1"
#define op_iterator_next_value_string "2"
#define op_construct_varargs_value_string "3"
#define op_super_construct_varargs_value_string "4"
#define op_iterator_open_value_string "5"
#define op_instanceof_value_string "6"
#define op_set_private_brand_value_string "7"
#define op_check_private_brand_value_string "8"
#define op_put_by_id_value_string "9"
#define op_construct_value_string "10"
#define op_super_construct_value_string "11"
#define op_tail_call_value_string "12"
#define op_call_direct_eval_value_string "13"
#define op_tail_call_forward_arguments_value_string "14"
#define op_create_generator_value_string "15"
#define op_create_async_generator_value_string "16"
#define op_create_promise_value_string "17"
#define op_catch_value_string "18"
#define op_new_array_with_size_value_string "19"
#define op_new_array_buffer_value_string "20"
#define op_get_by_id_value_string "21"
#define op_get_length_value_string "22"
#define op_profile_type_value_string "23"
#define op_profile_control_flow_value_string "24"
#define op_new_array_with_species_value_string "25"
#define op_call_value_string "26"
#define op_call_ignore_result_value_string "27"
#define op_resolve_scope_value_string "28"
#define op_get_from_scope_value_string "29"
#define op_put_to_scope_value_string "30"
#define op_create_this_value_string "31"
#define op_new_object_value_string "32"
#define op_new_array_value_string "33"
#define op_put_private_name_value_string "34"
#define op_get_private_name_value_string "35"
#define op_get_by_val_with_this_value_string "36"
#define op_get_by_val_value_string "37"
#define op_put_by_val_value_string "38"
#define op_put_by_val_direct_value_string "39"
#define op_in_by_val_value_string "40"
#define op_enumerator_next_value_string "41"
#define op_enumerator_in_by_val_value_string "42"
#define op_enumerator_has_own_property_value_string "43"
#define op_enumerator_put_by_val_value_string "44"
#define op_to_this_value_string "45"
#define op_enumerator_get_by_val_value_string "46"
#define op_get_by_id_direct_value_string "47"
#define op_try_get_by_id_value_string "48"
#define op_jneq_ptr_value_string "49"
#define op_get_argument_value_string "50"
#define op_get_from_arguments_value_string "51"
#define op_get_prototype_of_value_string "52"
#define op_get_internal_field_value_string "53"
#define op_get_by_id_with_this_value_string "54"
#define op_to_object_value_string "55"
#define op_in_by_id_value_string "56"
#define op_has_private_name_value_string "57"
#define op_has_private_brand_value_string "58"
#define op_put_by_id_with_this_value_string "59"
#define op_del_by_id_value_string "60"
#define op_put_by_val_with_this_value_string "61"
#define op_del_by_val_value_string "62"
#define op_put_getter_by_id_value_string "63"
#define op_put_setter_by_id_value_string "64"
#define op_put_getter_setter_by_id_value_string "65"
#define op_put_getter_by_val_value_string "66"
#define op_put_setter_by_val_value_string "67"
#define op_define_data_property_value_string "68"
#define op_define_accessor_property_value_string "69"
#define op_jmp_value_string "70"
#define op_jtrue_value_string "71"
#define op_jfalse_value_string "72"
#define op_jeq_null_value_string "73"
#define op_jneq_null_value_string "74"
#define op_jundefined_or_null_value_string "75"
#define op_jnundefined_or_null_value_string "76"
#define op_jeq_ptr_value_string "77"
#define op_jeq_value_string "78"
#define op_jstricteq_value_string "79"
#define op_jneq_value_string "80"
#define op_jnstricteq_value_string "81"
#define op_jless_value_string "82"
#define op_jlesseq_value_string "83"
#define op_jgreater_value_string "84"
#define op_jgreatereq_value_string "85"
#define op_jnless_value_string "86"
#define op_jnlesseq_value_string "87"
#define op_jngreater_value_string "88"
#define op_jngreatereq_value_string "89"
#define op_jbelow_value_string "90"
#define op_jbeloweq_value_string "91"
#define op_loop_hint_value_string "92"
#define op_switch_imm_value_string "93"
#define op_switch_char_value_string "94"
#define op_switch_string_value_string "95"
#define op_new_func_value_string "96"
#define op_new_func_exp_value_string "97"
#define op_new_generator_func_value_string "98"
#define op_new_generator_func_exp_value_string "99"
#define op_new_async_func_value_string "100"
#define op_new_async_func_exp_value_string "101"
#define op_new_async_generator_func_value_string "102"
#define op_new_async_generator_func_exp_value_string "103"
#define op_set_function_name_value_string "104"
#define op_ret_value_string "105"
#define op_strcat_value_string "106"
#define op_to_primitive_value_string "107"
#define op_to_property_key_value_string "108"
#define op_to_property_key_or_number_value_string "109"
#define op_put_to_arguments_value_string "110"
#define op_push_with_scope_value_string "111"
#define op_create_lexical_environment_value_string "112"
#define op_create_generator_frame_environment_value_string "113"
#define op_get_parent_scope_value_string "114"
#define op_throw_value_string "115"
#define op_throw_static_error_value_string "116"
#define op_debug_value_string "117"
#define op_end_value_string "118"
#define op_get_property_enumerator_value_string "119"
#define op_unreachable_value_string "120"
#define op_create_rest_value_string "121"
#define op_get_rest_length_value_string "122"
#define op_yield_value_string "123"
#define op_check_traps_value_string "124"
#define op_log_shadow_chicken_prologue_value_string "125"
#define op_log_shadow_chicken_tail_value_string "126"
#define op_resolve_scope_for_hoisting_func_decl_in_eval_value_string "127"
#define op_put_internal_field_value_string "128"
#define op_nop_value_string "129"
#define op_super_sampler_begin_value_string "130"
#define op_wide16_value_string "131"
#define op_super_sampler_end_value_string "132"
#define op_wide32_value_string "133"
#define op_enter_value_string "134"
#define op_get_scope_value_string "135"
#define op_create_direct_arguments_value_string "136"
#define op_create_scoped_arguments_value_string "137"
#define op_create_cloned_arguments_value_string "138"
#define op_new_promise_value_string "139"
#define op_new_generator_value_string "140"
#define op_argument_count_value_string "141"
#define op_check_tdz_value_string "142"
#define op_new_array_with_spread_value_string "143"
#define op_spread_value_string "144"
#define op_new_reg_exp_value_string "145"
#define op_mov_value_string "146"
#define op_eq_value_string "147"
#define op_neq_value_string "148"
#define op_stricteq_value_string "149"
#define op_nstricteq_value_string "150"
#define op_less_value_string "151"
#define op_lesseq_value_string "152"
#define op_greater_value_string "153"
#define op_greatereq_value_string "154"
#define op_below_value_string "155"
#define op_beloweq_value_string "156"
#define op_mod_value_string "157"
#define op_pow_value_string "158"
#define op_urshift_value_string "159"
#define op_add_value_string "160"
#define op_mul_value_string "161"
#define op_div_value_string "162"
#define op_sub_value_string "163"
#define op_bitand_value_string "164"
#define op_bitor_value_string "165"
#define op_bitxor_value_string "166"
#define op_lshift_value_string "167"
#define op_rshift_value_string "168"
#define op_eq_null_value_string "169"
#define op_neq_null_value_string "170"
#define op_to_string_value_string "171"
#define op_unsigned_value_string "172"
#define op_is_empty_value_string "173"
#define op_typeof_is_undefined_value_string "174"
#define op_typeof_is_object_value_string "175"
#define op_typeof_is_function_value_string "176"
#define op_is_undefined_or_null_value_string "177"
#define op_is_boolean_value_string "178"
#define op_is_number_value_string "179"
#define op_is_big_int_value_string "180"
#define op_is_object_value_string "181"
#define op_is_callable_value_string "182"
#define op_is_constructor_value_string "183"
#define op_inc_value_string "184"
#define op_dec_value_string "185"
#define op_negate_value_string "186"
#define op_not_value_string "187"
#define op_identity_with_profile_value_string "188"
#define op_overrides_has_instance_value_string "189"
#define op_typeof_value_string "190"
#define op_is_cell_with_type_value_string "191"
#define op_has_structure_with_flags_value_string "192"
#define op_to_number_value_string "193"
#define op_to_numeric_value_string "194"
#define op_bitnot_value_string "195"
#define op_tail_call_varargs_wide16_value_string "312"
#define op_call_varargs_wide16_value_string "313"
#define op_iterator_next_wide16_value_string "314"
#define op_construct_varargs_wide16_value_string "315"
#define op_super_construct_varargs_wide16_value_string "316"
#define op_iterator_open_wide16_value_string "317"
#define op_instanceof_wide16_value_string "318"
#define op_set_private_brand_wide16_value_string "319"
#define op_check_private_brand_wide16_value_string "320"
#define op_put_by_id_wide16_value_string "321"
#define op_construct_wide16_value_string "322"
#define op_super_construct_wide16_value_string "323"
#define op_tail_call_wide16_value_string "324"
#define op_call_direct_eval_wide16_value_string "325"
#define op_tail_call_forward_arguments_wide16_value_string "326"
#define op_create_generator_wide16_value_string "327"
#define op_create_async_generator_wide16_value_string "328"
#define op_create_promise_wide16_value_string "329"
#define op_catch_wide16_value_string "330"
#define op_new_array_with_size_wide16_value_string "331"
#define op_new_array_buffer_wide16_value_string "332"
#define op_get_by_id_wide16_value_string "333"
#define op_get_length_wide16_value_string "334"
#define op_profile_type_wide16_value_string "335"
#define op_profile_control_flow_wide16_value_string "336"
#define op_new_array_with_species_wide16_value_string "337"
#define op_call_wide16_value_string "338"
#define op_call_ignore_result_wide16_value_string "339"
#define op_resolve_scope_wide16_value_string "340"
#define op_get_from_scope_wide16_value_string "341"
#define op_put_to_scope_wide16_value_string "342"
#define op_create_this_wide16_value_string "343"
#define op_new_object_wide16_value_string "344"
#define op_new_array_wide16_value_string "345"
#define op_put_private_name_wide16_value_string "346"
#define op_get_private_name_wide16_value_string "347"
#define op_get_by_val_with_this_wide16_value_string "348"
#define op_get_by_val_wide16_value_string "349"
#define op_put_by_val_wide16_value_string "350"
#define op_put_by_val_direct_wide16_value_string "351"
#define op_in_by_val_wide16_value_string "352"
#define op_enumerator_next_wide16_value_string "353"
#define op_enumerator_in_by_val_wide16_value_string "354"
#define op_enumerator_has_own_property_wide16_value_string "355"
#define op_enumerator_put_by_val_wide16_value_string "356"
#define op_to_this_wide16_value_string "357"
#define op_enumerator_get_by_val_wide16_value_string "358"
#define op_get_by_id_direct_wide16_value_string "359"
#define op_try_get_by_id_wide16_value_string "360"
#define op_jneq_ptr_wide16_value_string "361"
#define op_get_argument_wide16_value_string "362"
#define op_get_from_arguments_wide16_value_string "363"
#define op_get_prototype_of_wide16_value_string "364"
#define op_get_internal_field_wide16_value_string "365"
#define op_get_by_id_with_this_wide16_value_string "366"
#define op_to_object_wide16_value_string "367"
#define op_in_by_id_wide16_value_string "368"
#define op_has_private_name_wide16_value_string "369"
#define op_has_private_brand_wide16_value_string "370"
#define op_put_by_id_with_this_wide16_value_string "371"
#define op_del_by_id_wide16_value_string "372"
#define op_put_by_val_with_this_wide16_value_string "373"
#define op_del_by_val_wide16_value_string "374"
#define op_put_getter_by_id_wide16_value_string "375"
#define op_put_setter_by_id_wide16_value_string "376"
#define op_put_getter_setter_by_id_wide16_value_string "377"
#define op_put_getter_by_val_wide16_value_string "378"
#define op_put_setter_by_val_wide16_value_string "379"
#define op_define_data_property_wide16_value_string "380"
#define op_define_accessor_property_wide16_value_string "381"
#define op_jmp_wide16_value_string "382"
#define op_jtrue_wide16_value_string "383"
#define op_jfalse_wide16_value_string "384"
#define op_jeq_null_wide16_value_string "385"
#define op_jneq_null_wide16_value_string "386"
#define op_jundefined_or_null_wide16_value_string "387"
#define op_jnundefined_or_null_wide16_value_string "388"
#define op_jeq_ptr_wide16_value_string "389"
#define op_jeq_wide16_value_string "390"
#define op_jstricteq_wide16_value_string "391"
#define op_jneq_wide16_value_string "392"
#define op_jnstricteq_wide16_value_string "393"
#define op_jless_wide16_value_string "394"
#define op_jlesseq_wide16_value_string "395"
#define op_jgreater_wide16_value_string "396"
#define op_jgreatereq_wide16_value_string "397"
#define op_jnless_wide16_value_string "398"
#define op_jnlesseq_wide16_value_string "399"
#define op_jngreater_wide16_value_string "400"
#define op_jngreatereq_wide16_value_string "401"
#define op_jbelow_wide16_value_string "402"
#define op_jbeloweq_wide16_value_string "403"
#define op_loop_hint_wide16_value_string "404"
#define op_switch_imm_wide16_value_string "405"
#define op_switch_char_wide16_value_string "406"
#define op_switch_string_wide16_value_string "407"
#define op_new_func_wide16_value_string "408"
#define op_new_func_exp_wide16_value_string "409"
#define op_new_generator_func_wide16_value_string "410"
#define op_new_generator_func_exp_wide16_value_string "411"
#define op_new_async_func_wide16_value_string "412"
#define op_new_async_func_exp_wide16_value_string "413"
#define op_new_async_generator_func_wide16_value_string "414"
#define op_new_async_generator_func_exp_wide16_value_string "415"
#define op_set_function_name_wide16_value_string "416"
#define op_ret_wide16_value_string "417"
#define op_strcat_wide16_value_string "418"
#define op_to_primitive_wide16_value_string "419"
#define op_to_property_key_wide16_value_string "420"
#define op_to_property_key_or_number_wide16_value_string "421"
#define op_put_to_arguments_wide16_value_string "422"
#define op_push_with_scope_wide16_value_string "423"
#define op_create_lexical_environment_wide16_value_string "424"
#define op_create_generator_frame_environment_wide16_value_string "425"
#define op_get_parent_scope_wide16_value_string "426"
#define op_throw_wide16_value_string "427"
#define op_throw_static_error_wide16_value_string "428"
#define op_debug_wide16_value_string "429"
#define op_end_wide16_value_string "430"
#define op_get_property_enumerator_wide16_value_string "431"
#define op_unreachable_wide16_value_string "432"
#define op_create_rest_wide16_value_string "433"
#define op_get_rest_length_wide16_value_string "434"
#define op_yield_wide16_value_string "435"
#define op_check_traps_wide16_value_string "436"
#define op_log_shadow_chicken_prologue_wide16_value_string "437"
#define op_log_shadow_chicken_tail_wide16_value_string "438"
#define op_resolve_scope_for_hoisting_func_decl_in_eval_wide16_value_string "439"
#define op_put_internal_field_wide16_value_string "440"
#define op_nop_wide16_value_string "441"
#define op_super_sampler_begin_wide16_value_string "442"
#define op_wide16_wide16_value_string "443"
#define op_super_sampler_end_wide16_value_string "444"
#define op_wide32_wide16_value_string "445"
#define op_enter_wide16_value_string "446"
#define op_get_scope_wide16_value_string "447"
#define op_create_direct_arguments_wide16_value_string "448"
#define op_create_scoped_arguments_wide16_value_string "449"
#define op_create_cloned_arguments_wide16_value_string "450"
#define op_new_promise_wide16_value_string "451"
#define op_new_generator_wide16_value_string "452"
#define op_argument_count_wide16_value_string "453"
#define op_check_tdz_wide16_value_string "454"
#define op_new_array_with_spread_wide16_value_string "455"
#define op_spread_wide16_value_string "456"
#define op_new_reg_exp_wide16_value_string "457"
#define op_mov_wide16_value_string "458"
#define op_eq_wide16_value_string "459"
#define op_neq_wide16_value_string "460"
#define op_stricteq_wide16_value_string "461"
#define op_nstricteq_wide16_value_string "462"
#define op_less_wide16_value_string "463"
#define op_lesseq_wide16_value_string "464"
#define op_greater_wide16_value_string "465"
#define op_greatereq_wide16_value_string "466"
#define op_below_wide16_value_string "467"
#define op_beloweq_wide16_value_string "468"
#define op_mod_wide16_value_string "469"
#define op_pow_wide16_value_string "470"
#define op_urshift_wide16_value_string "471"
#define op_add_wide16_value_string "472"
#define op_mul_wide16_value_string "473"
#define op_div_wide16_value_string "474"
#define op_sub_wide16_value_string "475"
#define op_bitand_wide16_value_string "476"
#define op_bitor_wide16_value_string "477"
#define op_bitxor_wide16_value_string "478"
#define op_lshift_wide16_value_string "479"
#define op_rshift_wide16_value_string "480"
#define op_eq_null_wide16_value_string "481"
#define op_neq_null_wide16_value_string "482"
#define op_to_string_wide16_value_string "483"
#define op_unsigned_wide16_value_string "484"
#define op_is_empty_wide16_value_string "485"
#define op_typeof_is_undefined_wide16_value_string "486"
#define op_typeof_is_object_wide16_value_string "487"
#define op_typeof_is_function_wide16_value_string "488"
#define op_is_undefined_or_null_wide16_value_string "489"
#define op_is_boolean_wide16_value_string "490"
#define op_is_number_wide16_value_string "491"
#define op_is_big_int_wide16_value_string "492"
#define op_is_object_wide16_value_string "493"
#define op_is_callable_wide16_value_string "494"
#define op_is_constructor_wide16_value_string "495"
#define op_inc_wide16_value_string "496"
#define op_dec_wide16_value_string "497"
#define op_negate_wide16_value_string "498"
#define op_not_wide16_value_string "499"
#define op_identity_with_profile_wide16_value_string "500"
#define op_overrides_has_instance_wide16_value_string "501"
#define op_typeof_wide16_value_string "502"
#define op_is_cell_with_type_wide16_value_string "503"
#define op_has_structure_with_flags_wide16_value_string "504"
#define op_to_number_wide16_value_string "505"
#define op_to_numeric_wide16_value_string "506"
#define op_bitnot_wide16_value_string "507"
#define op_tail_call_varargs_wide32_value_string "624"
#define op_call_varargs_wide32_value_string "625"
#define op_iterator_next_wide32_value_string "626"
#define op_construct_varargs_wide32_value_string "627"
#define op_super_construct_varargs_wide32_value_string "628"
#define op_iterator_open_wide32_value_string "629"
#define op_instanceof_wide32_value_string "630"
#define op_set_private_brand_wide32_value_string "631"
#define op_check_private_brand_wide32_value_string "632"
#define op_put_by_id_wide32_value_string "633"
#define op_construct_wide32_value_string "634"
#define op_super_construct_wide32_value_string "635"
#define op_tail_call_wide32_value_string "636"
#define op_call_direct_eval_wide32_value_string "637"
#define op_tail_call_forward_arguments_wide32_value_string "638"
#define op_create_generator_wide32_value_string "639"
#define op_create_async_generator_wide32_value_string "640"
#define op_create_promise_wide32_value_string "641"
#define op_catch_wide32_value_string "642"
#define op_new_array_with_size_wide32_value_string "643"
#define op_new_array_buffer_wide32_value_string "644"
#define op_get_by_id_wide32_value_string "645"
#define op_get_length_wide32_value_string "646"
#define op_profile_type_wide32_value_string "647"
#define op_profile_control_flow_wide32_value_string "648"
#define op_new_array_with_species_wide32_value_string "649"
#define op_call_wide32_value_string "650"
#define op_call_ignore_result_wide32_value_string "651"
#define op_resolve_scope_wide32_value_string "652"
#define op_get_from_scope_wide32_value_string "653"
#define op_put_to_scope_wide32_value_string "654"
#define op_create_this_wide32_value_string "655"
#define op_new_object_wide32_value_string "656"
#define op_new_array_wide32_value_string "657"
#define op_put_private_name_wide32_value_string "658"
#define op_get_private_name_wide32_value_string "659"
#define op_get_by_val_with_this_wide32_value_string "660"
#define op_get_by_val_wide32_value_string "661"
#define op_put_by_val_wide32_value_string "662"
#define op_put_by_val_direct_wide32_value_string "663"
#define op_in_by_val_wide32_value_string "664"
#define op_enumerator_next_wide32_value_string "665"
#define op_enumerator_in_by_val_wide32_value_string "666"
#define op_enumerator_has_own_property_wide32_value_string "667"
#define op_enumerator_put_by_val_wide32_value_string "668"
#define op_to_this_wide32_value_string "669"
#define op_enumerator_get_by_val_wide32_value_string "670"
#define op_get_by_id_direct_wide32_value_string "671"
#define op_try_get_by_id_wide32_value_string "672"
#define op_jneq_ptr_wide32_value_string "673"
#define op_get_argument_wide32_value_string "674"
#define op_get_from_arguments_wide32_value_string "675"
#define op_get_prototype_of_wide32_value_string "676"
#define op_get_internal_field_wide32_value_string "677"
#define op_get_by_id_with_this_wide32_value_string "678"
#define op_to_object_wide32_value_string "679"
#define op_in_by_id_wide32_value_string "680"
#define op_has_private_name_wide32_value_string "681"
#define op_has_private_brand_wide32_value_string "682"
#define op_put_by_id_with_this_wide32_value_string "683"
#define op_del_by_id_wide32_value_string "684"
#define op_put_by_val_with_this_wide32_value_string "685"
#define op_del_by_val_wide32_value_string "686"
#define op_put_getter_by_id_wide32_value_string "687"
#define op_put_setter_by_id_wide32_value_string "688"
#define op_put_getter_setter_by_id_wide32_value_string "689"
#define op_put_getter_by_val_wide32_value_string "690"
#define op_put_setter_by_val_wide32_value_string "691"
#define op_define_data_property_wide32_value_string "692"
#define op_define_accessor_property_wide32_value_string "693"
#define op_jmp_wide32_value_string "694"
#define op_jtrue_wide32_value_string "695"
#define op_jfalse_wide32_value_string "696"
#define op_jeq_null_wide32_value_string "697"
#define op_jneq_null_wide32_value_string "698"
#define op_jundefined_or_null_wide32_value_string "699"
#define op_jnundefined_or_null_wide32_value_string "700"
#define op_jeq_ptr_wide32_value_string "701"
#define op_jeq_wide32_value_string "702"
#define op_jstricteq_wide32_value_string "703"
#define op_jneq_wide32_value_string "704"
#define op_jnstricteq_wide32_value_string "705"
#define op_jless_wide32_value_string "706"
#define op_jlesseq_wide32_value_string "707"
#define op_jgreater_wide32_value_string "708"
#define op_jgreatereq_wide32_value_string "709"
#define op_jnless_wide32_value_string "710"
#define op_jnlesseq_wide32_value_string "711"
#define op_jngreater_wide32_value_string "712"
#define op_jngreatereq_wide32_value_string "713"
#define op_jbelow_wide32_value_string "714"
#define op_jbeloweq_wide32_value_string "715"
#define op_loop_hint_wide32_value_string "716"
#define op_switch_imm_wide32_value_string "717"
#define op_switch_char_wide32_value_string "718"
#define op_switch_string_wide32_value_string "719"
#define op_new_func_wide32_value_string "720"
#define op_new_func_exp_wide32_value_string "721"
#define op_new_generator_func_wide32_value_string "722"
#define op_new_generator_func_exp_wide32_value_string "723"
#define op_new_async_func_wide32_value_string "724"
#define op_new_async_func_exp_wide32_value_string "725"
#define op_new_async_generator_func_wide32_value_string "726"
#define op_new_async_generator_func_exp_wide32_value_string "727"
#define op_set_function_name_wide32_value_string "728"
#define op_ret_wide32_value_string "729"
#define op_strcat_wide32_value_string "730"
#define op_to_primitive_wide32_value_string "731"
#define op_to_property_key_wide32_value_string "732"
#define op_to_property_key_or_number_wide32_value_string "733"
#define op_put_to_arguments_wide32_value_string "734"
#define op_push_with_scope_wide32_value_string "735"
#define op_create_lexical_environment_wide32_value_string "736"
#define op_create_generator_frame_environment_wide32_value_string "737"
#define op_get_parent_scope_wide32_value_string "738"
#define op_throw_wide32_value_string "739"
#define op_throw_static_error_wide32_value_string "740"
#define op_debug_wide32_value_string "741"
#define op_end_wide32_value_string "742"
#define op_get_property_enumerator_wide32_value_string "743"
#define op_unreachable_wide32_value_string "744"
#define op_create_rest_wide32_value_string "745"
#define op_get_rest_length_wide32_value_string "746"
#define op_yield_wide32_value_string "747"
#define op_check_traps_wide32_value_string "748"
#define op_log_shadow_chicken_prologue_wide32_value_string "749"
#define op_log_shadow_chicken_tail_wide32_value_string "750"
#define op_resolve_scope_for_hoisting_func_decl_in_eval_wide32_value_string "751"
#define op_put_internal_field_wide32_value_string "752"
#define op_nop_wide32_value_string "753"
#define op_super_sampler_begin_wide32_value_string "754"
#define op_wide16_wide32_value_string "755"
#define op_super_sampler_end_wide32_value_string "756"
#define op_wide32_wide32_value_string "757"
#define op_enter_wide32_value_string "758"
#define op_get_scope_wide32_value_string "759"
#define op_create_direct_arguments_wide32_value_string "760"
#define op_create_scoped_arguments_wide32_value_string "761"
#define op_create_cloned_arguments_wide32_value_string "762"
#define op_new_promise_wide32_value_string "763"
#define op_new_generator_wide32_value_string "764"
#define op_argument_count_wide32_value_string "765"
#define op_check_tdz_wide32_value_string "766"
#define op_new_array_with_spread_wide32_value_string "767"
#define op_spread_wide32_value_string "768"
#define op_new_reg_exp_wide32_value_string "769"
#define op_mov_wide32_value_string "770"
#define op_eq_wide32_value_string "771"
#define op_neq_wide32_value_string "772"
#define op_stricteq_wide32_value_string "773"
#define op_nstricteq_wide32_value_string "774"
#define op_less_wide32_value_string "775"
#define op_lesseq_wide32_value_string "776"
#define op_greater_wide32_value_string "777"
#define op_greatereq_wide32_value_string "778"
#define op_below_wide32_value_string "779"
#define op_beloweq_wide32_value_string "780"
#define op_mod_wide32_value_string "781"
#define op_pow_wide32_value_string "782"
#define op_urshift_wide32_value_string "783"
#define op_add_wide32_value_string "784"
#define op_mul_wide32_value_string "785"
#define op_div_wide32_value_string "786"
#define op_sub_wide32_value_string "787"
#define op_bitand_wide32_value_string "788"
#define op_bitor_wide32_value_string "789"
#define op_bitxor_wide32_value_string "790"
#define op_lshift_wide32_value_string "791"
#define op_rshift_wide32_value_string "792"
#define op_eq_null_wide32_value_string "793"
#define op_neq_null_wide32_value_string "794"
#define op_to_string_wide32_value_string "795"
#define op_unsigned_wide32_value_string "796"
#define op_is_empty_wide32_value_string "797"
#define op_typeof_is_undefined_wide32_value_string "798"
#define op_typeof_is_object_wide32_value_string "799"
#define op_typeof_is_function_wide32_value_string "800"
#define op_is_undefined_or_null_wide32_value_string "801"
#define op_is_boolean_wide32_value_string "802"
#define op_is_number_wide32_value_string "803"
#define op_is_big_int_wide32_value_string "804"
#define op_is_object_wide32_value_string "805"
#define op_is_callable_wide32_value_string "806"
#define op_is_constructor_wide32_value_string "807"
#define op_inc_wide32_value_string "808"
#define op_dec_wide32_value_string "809"
#define op_negate_wide32_value_string "810"
#define op_not_wide32_value_string "811"
#define op_identity_with_profile_wide32_value_string "812"
#define op_overrides_has_instance_wide32_value_string "813"
#define op_typeof_wide32_value_string "814"
#define op_is_cell_with_type_wide32_value_string "815"
#define op_has_structure_with_flags_wide32_value_string "816"
#define op_to_number_wide32_value_string "817"
#define op_to_numeric_wide32_value_string "818"
#define op_bitnot_wide32_value_string "819"

#define FOR_EACH_CLOOP_BYTECODE_HELPER_ID(macro) \
    macro(llint_entry, 0) \
    macro(llint_vm_entry_to_javascript, 0) \
    macro(llint_vm_entry_to_native, 0) \

#define NUMBER_OF_CLOOP_BYTECODE_HELPER_IDS 3
#define MAX_LENGTH_OF_CLOOP_BYTECODE_HELPER_IDS 0

#define FOR_EACH_BYTECODE_HELPER_ID(macro) \
    macro(wasm_ipint_call_return_location, 0) \
    macro(llint_eval_prologue, 0) \
    macro(llint_module_program_prologue, 0) \
    macro(llint_function_for_call_prologue, 0) \
    macro(llint_function_for_construct_prologue, 0) \
    macro(llint_function_for_call_arity_check, 0) \
    macro(llint_function_for_construct_arity_check, 0) \
    macro(llint_generic_return_point, 0) \
    macro(llint_throw_from_slow_path_trampoline, 0) \
    macro(llint_throw_during_call_trampoline, 0) \
    macro(llint_native_call_trampoline, 0) \
    macro(llint_native_construct_trampoline, 0) \
    macro(llint_internal_function_call_trampoline, 0) \
    macro(llint_internal_function_construct_trampoline, 0) \
    macro(llint_default_call_trampoline, 0) \
    macro(llint_virtual_call_trampoline, 0) \
    macro(llint_virtual_construct_trampoline, 0) \
    macro(llint_virtual_tail_call_trampoline, 0) \
    macro(llint_polymorphic_normal_call_trampoline, 0) \
    macro(llint_polymorphic_closure_call_trampoline, 0) \
    macro(checkpoint_osr_exit_from_inlined_call_trampoline, 0) \
    macro(checkpoint_osr_exit_trampoline, 0) \
    macro(normal_osr_exit_trampoline, 0) \
    macro(fuzzer_return_early_from_loop_hint, 0) \
    macro(loop_osr_entry_gate, 0) \
    macro(llint_get_host_call_return_value, 0) \
    macro(llint_handle_uncaught_exception, 0) \
    macro(op_call_return_location, 0) \
    macro(op_call_ignore_result_return_location, 0) \
    macro(op_construct_return_location, 0) \
    macro(op_super_construct_return_location, 0) \
    macro(op_call_varargs_return_location, 0) \
    macro(op_construct_varargs_return_location, 0) \
    macro(op_super_construct_varargs_return_location, 0) \
    macro(op_get_by_id_return_location, 0) \
    macro(op_get_by_id_direct_return_location, 0) \
    macro(op_get_length_return_location, 0) \
    macro(op_get_by_val_return_location, 0) \
    macro(op_put_by_id_return_location, 0) \
    macro(op_put_by_val_return_location, 0) \
    macro(op_put_by_val_direct_return_location, 0) \
    macro(op_in_by_id_return_location, 0) \
    macro(op_in_by_val_return_location, 0) \
    macro(op_instanceof_return_location, 0) \
    macro(op_enumerator_get_by_val_return_location, 0) \
    macro(op_enumerator_put_by_val_return_location, 0) \
    macro(op_enumerator_in_by_val_return_location, 0) \
    macro(op_iterator_open_return_location, 0) \
    macro(op_iterator_next_return_location, 0) \
    macro(op_call_direct_eval_slow_return_location, 0) \
    macro(js_to_wasm_wrapper_entry, 0) \
    macro(wasm_to_wasm_ipint_wrapper_entry, 0) \
    macro(wasm_to_js_wrapper_entry, 0) \
    macro(ipint_trampoline, 0) \
    macro(ipint_entry, 0) \
    macro(llint_program_prologue, 0) \
    macro(ipint_catch_entry, 0) \
    macro(ipint_catch_all_entry, 0) \
    macro(ipint_table_catch_entry, 0) \
    macro(ipint_table_catch_ref_entry, 0) \
    macro(ipint_table_catch_all_entry, 0) \
    macro(ipint_table_catch_allref_entry, 0) \
    macro(js_trampoline_op_call, 0) \
    macro(js_trampoline_op_call_ignore_result, 0) \
    macro(js_trampoline_op_construct, 0) \
    macro(js_trampoline_op_super_construct, 0) \
    macro(js_trampoline_op_call_varargs, 0) \
    macro(js_trampoline_op_construct_varargs, 0) \
    macro(js_trampoline_op_super_construct_varargs, 0) \
    macro(js_trampoline_op_iterator_next, 0) \
    macro(js_trampoline_op_iterator_open, 0) \
    macro(js_trampoline_op_call_direct_eval_slow, 0) \
    macro(js_trampoline_llint_function_for_call_arity_check_untag, 0) \
    macro(js_trampoline_llint_function_for_call_arity_check_tag, 0) \
    macro(js_trampoline_llint_function_for_construct_arity_check_untag, 0) \
    macro(js_trampoline_llint_function_for_construct_arity_check_tag, 0) \
    macro(wasm_trampoline_wasm_ipint_call, 0) \
    macro(wasm_trampoline_wasm_ipint_tail_call, 0) \
    macro(wasm_throw_from_slow_path_trampoline, 0) \
    macro(wasm_throw_from_fault_handler_trampoline_reg_instance, 0) \
    macro(ipint_simd_entry, 0) \

#define NUMBER_OF_BYTECODE_HELPER_IDS 81
#define MAX_LENGTH_OF_BYTECODE_HELPER_IDS 0

#define FOR_EACH_CLOOP_RETURN_HELPER_ID(macro) \
    macro(llint_cloop_did_return_from_js_31, 0) \
    macro(llint_cloop_did_return_from_js_1, 0) \
    macro(llint_cloop_did_return_from_js_2, 0) \
    macro(llint_cloop_did_return_from_js_3, 0) \
    macro(llint_cloop_did_return_from_js_4, 0) \
    macro(llint_cloop_did_return_from_js_5, 0) \
    macro(llint_cloop_did_return_from_js_6, 0) \
    macro(llint_cloop_did_return_from_js_7, 0) \
    macro(llint_cloop_did_return_from_js_8, 0) \
    macro(llint_cloop_did_return_from_js_9, 0) \
    macro(llint_cloop_did_return_from_js_10, 0) \
    macro(llint_cloop_did_return_from_js_11, 0) \
    macro(llint_cloop_did_return_from_js_12, 0) \
    macro(llint_cloop_did_return_from_js_13, 0) \
    macro(llint_cloop_did_return_from_js_14, 0) \
    macro(llint_cloop_did_return_from_js_15, 0) \
    macro(llint_cloop_did_return_from_js_16, 0) \
    macro(llint_cloop_did_return_from_js_17, 0) \
    macro(llint_cloop_did_return_from_js_18, 0) \
    macro(llint_cloop_did_return_from_js_19, 0) \
    macro(llint_cloop_did_return_from_js_20, 0) \
    macro(llint_cloop_did_return_from_js_21, 0) \
    macro(llint_cloop_did_return_from_js_22, 0) \
    macro(llint_cloop_did_return_from_js_23, 0) \
    macro(llint_cloop_did_return_from_js_24, 0) \
    macro(llint_cloop_did_return_from_js_25, 0) \
    macro(llint_cloop_did_return_from_js_26, 0) \
    macro(llint_cloop_did_return_from_js_27, 0) \
    macro(llint_cloop_did_return_from_js_28, 0) \
    macro(llint_cloop_did_return_from_js_29, 0) \
    macro(llint_cloop_did_return_from_js_30, 0) \
    macro(llint_return_to_host, 0) \

#define NUMBER_OF_CLOOP_RETURN_HELPER_IDS 32
#define MAX_LENGTH_OF_CLOOP_RETURN_HELPER_IDS 0

#define FOR_EACH_BYTECODE_STRUCT(macro) \
    macro(OpTailCallVarargs) \
    macro(OpCallVarargs) \
    macro(OpIteratorNext) \
    macro(OpConstructVarargs) \
    macro(OpSuperConstructVarargs) \
    macro(OpIteratorOpen) \
    macro(OpInstanceof) \
    macro(OpSetPrivateBrand) \
    macro(OpCheckPrivateBrand) \
    macro(OpPutById) \
    macro(OpConstruct) \
    macro(OpSuperConstruct) \
    macro(OpTailCall) \
    macro(OpCallDirectEval) \
    macro(OpTailCallForwardArguments) \
    macro(OpCreateGenerator) \
    macro(OpCreateAsyncGenerator) \
    macro(OpCreatePromise) \
    macro(OpCatch) \
    macro(OpNewArrayWithSize) \
    macro(OpNewArrayBuffer) \
    macro(OpGetById) \
    macro(OpGetLength) \
    macro(OpProfileType) \
    macro(OpProfileControlFlow) \
    macro(OpNewArrayWithSpecies) \
    macro(OpCall) \
    macro(OpCallIgnoreResult) \
    macro(OpResolveScope) \
    macro(OpGetFromScope) \
    macro(OpPutToScope) \
    macro(OpCreateThis) \
    macro(OpNewObject) \
    macro(OpNewArray) \
    macro(OpPutPrivateName) \
    macro(OpGetPrivateName) \
    macro(OpGetByValWithThis) \
    macro(OpGetByVal) \
    macro(OpPutByVal) \
    macro(OpPutByValDirect) \
    macro(OpInByVal) \
    macro(OpEnumeratorNext) \
    macro(OpEnumeratorInByVal) \
    macro(OpEnumeratorHasOwnProperty) \
    macro(OpEnumeratorPutByVal) \
    macro(OpToThis) \
    macro(OpEnumeratorGetByVal) \
    macro(OpGetByIdDirect) \
    macro(OpTryGetById) \
    macro(OpJneqPtr) \
    macro(OpGetArgument) \
    macro(OpGetFromArguments) \
    macro(OpGetPrototypeOf) \
    macro(OpGetInternalField) \
    macro(OpGetByIdWithThis) \
    macro(OpToObject) \
    macro(OpInById) \
    macro(OpHasPrivateName) \
    macro(OpHasPrivateBrand) \
    macro(OpPutByIdWithThis) \
    macro(OpDelById) \
    macro(OpPutByValWithThis) \
    macro(OpDelByVal) \
    macro(OpPutGetterById) \
    macro(OpPutSetterById) \
    macro(OpPutGetterSetterById) \
    macro(OpPutGetterByVal) \
    macro(OpPutSetterByVal) \
    macro(OpDefineDataProperty) \
    macro(OpDefineAccessorProperty) \
    macro(OpJmp) \
    macro(OpJtrue) \
    macro(OpJfalse) \
    macro(OpJeqNull) \
    macro(OpJneqNull) \
    macro(OpJundefinedOrNull) \
    macro(OpJnundefinedOrNull) \
    macro(OpJeqPtr) \
    macro(OpJeq) \
    macro(OpJstricteq) \
    macro(OpJneq) \
    macro(OpJnstricteq) \
    macro(OpJless) \
    macro(OpJlesseq) \
    macro(OpJgreater) \
    macro(OpJgreatereq) \
    macro(OpJnless) \
    macro(OpJnlesseq) \
    macro(OpJngreater) \
    macro(OpJngreatereq) \
    macro(OpJbelow) \
    macro(OpJbeloweq) \
    macro(OpLoopHint) \
    macro(OpSwitchImm) \
    macro(OpSwitchChar) \
    macro(OpSwitchString) \
    macro(OpNewFunc) \
    macro(OpNewFuncExp) \
    macro(OpNewGeneratorFunc) \
    macro(OpNewGeneratorFuncExp) \
    macro(OpNewAsyncFunc) \
    macro(OpNewAsyncFuncExp) \
    macro(OpNewAsyncGeneratorFunc) \
    macro(OpNewAsyncGeneratorFuncExp) \
    macro(OpSetFunctionName) \
    macro(OpRet) \
    macro(OpStrcat) \
    macro(OpToPrimitive) \
    macro(OpToPropertyKey) \
    macro(OpToPropertyKeyOrNumber) \
    macro(OpPutToArguments) \
    macro(OpPushWithScope) \
    macro(OpCreateLexicalEnvironment) \
    macro(OpCreateGeneratorFrameEnvironment) \
    macro(OpGetParentScope) \
    macro(OpThrow) \
    macro(OpThrowStaticError) \
    macro(OpDebug) \
    macro(OpEnd) \
    macro(OpGetPropertyEnumerator) \
    macro(OpUnreachable) \
    macro(OpCreateRest) \
    macro(OpGetRestLength) \
    macro(OpYield) \
    macro(OpCheckTraps) \
    macro(OpLogShadowChickenPrologue) \
    macro(OpLogShadowChickenTail) \
    macro(OpResolveScopeForHoistingFuncDeclInEval) \
    macro(OpPutInternalField) \
    macro(OpNop) \
    macro(OpSuperSamplerBegin) \
    macro(OpWide16) \
    macro(OpSuperSamplerEnd) \
    macro(OpWide32) \
    macro(OpEnter) \
    macro(OpGetScope) \
    macro(OpCreateDirectArguments) \
    macro(OpCreateScopedArguments) \
    macro(OpCreateClonedArguments) \
    macro(OpNewPromise) \
    macro(OpNewGenerator) \
    macro(OpArgumentCount) \
    macro(OpCheckTdz) \
    macro(OpNewArrayWithSpread) \
    macro(OpSpread) \
    macro(OpNewRegExp) \
    macro(OpMov) \
    macro(OpEq) \
    macro(OpNeq) \
    macro(OpStricteq) \
    macro(OpNstricteq) \
    macro(OpLess) \
    macro(OpLesseq) \
    macro(OpGreater) \
    macro(OpGreatereq) \
    macro(OpBelow) \
    macro(OpBeloweq) \
    macro(OpMod) \
    macro(OpPow) \
    macro(OpUrshift) \
    macro(OpAdd) \
    macro(OpMul) \
    macro(OpDiv) \
    macro(OpSub) \
    macro(OpBitand) \
    macro(OpBitor) \
    macro(OpBitxor) \
    macro(OpLshift) \
    macro(OpRshift) \
    macro(OpEqNull) \
    macro(OpNeqNull) \
    macro(OpToString) \
    macro(OpUnsigned) \
    macro(OpIsEmpty) \
    macro(OpTypeofIsUndefined) \
    macro(OpTypeofIsObject) \
    macro(OpTypeofIsFunction) \
    macro(OpIsUndefinedOrNull) \
    macro(OpIsBoolean) \
    macro(OpIsNumber) \
    macro(OpIsBigInt) \
    macro(OpIsObject) \
    macro(OpIsCallable) \
    macro(OpIsConstructor) \
    macro(OpInc) \
    macro(OpDec) \
    macro(OpNegate) \
    macro(OpNot) \
    macro(OpIdentityWithProfile) \
    macro(OpOverridesHasInstance) \
    macro(OpTypeof) \
    macro(OpIsCellWithType) \
    macro(OpHasStructureWithFlags) \
    macro(OpToNumber) \
    macro(OpToNumeric) \
    macro(OpBitnot) \

//  SHA1Hash: 49b889bfc401bd04ad9d76a174e13ab43fc4be77
