import{Widget as e,UIUtils as t,Context as i,Toolbar as n,ARIAUtils as s,Tooltip as a,PopoverHelper as r,Geometry as o,ContextMenu as h}from"../ui/ui.js";import{Linkifier as l,Color as d,Revealer as _}from"../common/common.js";import{i18n as m}from"../i18n/i18n.js";import{BezierUI as c}from"../inline_editor/inline_editor.js";import{userMetrics as u,UserMetrics as p}from"../host/host.js";import{ArrayUtilities as f}from"../platform/platform.js";import{SDKModel as b,RuntimeModel as g,ResourceTreeModel as y,ScreenCaptureModel as v,DOMModel as w}from"../sdk/sdk.js";class M extends b.SDKModel{constructor(e){super(e),this._runtimeModel=e.model(g.RuntimeModel),this._agent=e.animationAgent(),e.registerAnimationDispatcher(new R(this)),this._animationsById=new Map,this._animationGroups=new Map,this._pendingAnimations=new Set,this._playbackRate=1;e.model(y.ResourceTreeModel).addEventListener(y.Events.MainFrameNavigated,this._reset,this);const t=e.model(v.ScreenCaptureModel);t&&(this._screenshotCapture=new E(this,t))}_reset(){this._animationsById.clear(),this._animationGroups.clear(),this._pendingAnimations.clear(),this.dispatchEventToListeners(A.ModelReset)}animationCreated(e){this._pendingAnimations.add(e)}_animationCanceled(e){this._pendingAnimations.delete(e),this._flushPendingAnimationsIfNeeded()}animationStarted(e){if(!e.source||!e.source.backendNodeId)return;const t=k.parsePayload(this,e);if(!t)return;const i=t.source().keyframesRule();"WebAnimation"===t.type()&&i&&0===i.keyframes().length?this._pendingAnimations.delete(t.id()):(this._animationsById.set(t.id(),t),this._pendingAnimations.add(t.id())),this._flushPendingAnimationsIfNeeded()}_flushPendingAnimationsIfNeeded(){for(const e of this._pendingAnimations)if(!this._animationsById.get(e))return;for(;this._pendingAnimations.size;)this._matchExistingGroups(this._createGroupFromPendingAnimations())}_matchExistingGroups(e){let t=null;for(const i of this._animationGroups.values())if(i._matches(e)){t=i,i._update(e);break}return t||(this._animationGroups.set(e.id(),e),this._screenshotCapture&&this._screenshotCapture.captureScreenshots(e.finiteDuration(),e._screenshots)),this.dispatchEventToListeners(A.AnimationGroupStarted,t||e),!!t}_createGroupFromPendingAnimations(){console.assert(this._pendingAnimations.size>0);const e=this._pendingAnimations.values().next().value;this._pendingAnimations.delete(e);const t=this._animationsById.get(e);if(!t)throw new Error("Unable to locate first animation");const i=[t],n=t.startTime(),s=new Set;for(const e of this._pendingAnimations){const t=this._animationsById.get(e);t.startTime()===n?i.push(t):s.add(e)}return this._pendingAnimations=s,new x(this,e,i)}setPlaybackRate(e){this._playbackRate=e,this._agent.invoke_setPlaybackRate({playbackRate:e})}_releaseAnimations(e){this._agent.invoke_releaseAnimations({animations:e})}async suspendModel(){this._reset(),await this._agent.invoke_disable()}async resumeModel(){this._enabled&&await this._agent.invoke_enable()}async ensureEnabled(){this._enabled||(await this._agent.invoke_enable(),this._enabled=!0)}}const A={AnimationGroupStarted:Symbol("AnimationGroupStarted"),ModelReset:Symbol("ModelReset")};class k{constructor(e,t){this._animationModel=e,this._payload=t,this._source=new C(e,this._payload.source)}static parsePayload(e,t){return new k(e,t)}payload(){return this._payload}id(){return this._payload.id}name(){return this._payload.name}paused(){return this._payload.pausedState}playState(){return this._playState||this._payload.playState}setPlayState(e){this._playState=e}playbackRate(){return this._payload.playbackRate}startTime(){return this._payload.startTime}endTime(){return this.source().iterations?this.startTime()+this.source().delay()+this.source().duration()*this.source().iterations()+this.source().endDelay():1/0}_finiteDuration(){const e=Math.min(this.source().iterations(),3);return this.source().delay()+this.source().duration()*e}currentTime(){return this._payload.currentTime}source(){return this._source}type(){return this._payload.type}overlaps(e){if(!this.source().iterations()||!e.source().iterations())return!0;const t=this.startTime()<e.startTime()?this:e,i=t===this?e:this;return t.endTime()>=i.startTime()}setTiming(e,t){this._source.node().then((i=>{if(!i)throw new Error("Unable to find node");this._updateNodeStyle(e,t,i)})),this._source._duration=e,this._source._delay=t,this._animationModel._agent.invoke_setTiming({animationId:this.id(),duration:e,delay:t})}_updateNodeStyle(e,t,i){let n;if(this.type()===S.CSSTransition)n="transition-";else{if(this.type()!==S.CSSAnimation)return;n="animation-"}if(!i.id)throw new Error("Node has no id");const s=i.domModel().cssModel();s.setEffectivePropertyValueForNode(i.id,n+"duration",e+"ms"),s.setEffectivePropertyValueForNode(i.id,n+"delay",t+"ms")}async remoteObjectPromise(){const e=await this._animationModel._agent.invoke_resolveAnimation({animationId:this.id()});return e?this._animationModel._runtimeModel.createRemoteObject(e.remoteObject):null}_cssId(){return this._payload.cssId||""}}const S={CSSTransition:"CSSTransition",CSSAnimation:"CSSAnimation",WebAnimation:"WebAnimation"};class C{constructor(e,t){this._animationModel=e,this._payload=t,t.keyframesRule&&(this._keyframesRule=new T(t.keyframesRule)),this._delay=this._payload.delay,this._duration=this._payload.duration}delay(){return this._delay}endDelay(){return this._payload.endDelay}iterationStart(){return this._payload.iterationStart}iterations(){return this.delay()||this.endDelay()||this.duration()?this._payload.iterations||1/0:0}duration(){return this._duration}direction(){return this._payload.direction}fill(){return this._payload.fill}node(){return this._deferredNode||(this._deferredNode=new w.DeferredDOMNode(this._animationModel.target(),this.backendNodeId())),this._deferredNode.resolvePromise()}deferredNode(){return new w.DeferredDOMNode(this._animationModel.target(),this.backendNodeId())}backendNodeId(){return this._payload.backendNodeId}keyframesRule(){return this._keyframesRule||null}easing(){return this._payload.easing}}class T{constructor(e){this._payload=e,this._keyframes=this._payload.keyframes.map((function(e){return new P(e)}))}_setKeyframesPayload(e){this._keyframes=e.map((function(e){return new P(e)}))}name(){return this._payload.name}keyframes(){return this._keyframes}}class P{constructor(e){this._payload=e,this._offset=this._payload.offset}offset(){return this._offset}setOffset(e){this._offset=100*e+"%"}offsetAsNumber(){return parseFloat(this._offset)/100}easing(){return this._payload.easing}}class x{constructor(e,t,i){this._animationModel=e,this._id=t,this._animations=i,this._paused=!1,this._screenshots=[],this._screenshotImages=[]}id(){return this._id}animations(){return this._animations}release(){this._animationModel._animationGroups.delete(this.id()),this._animationModel._releaseAnimations(this._animationIds())}_animationIds(){return this._animations.map((function(e){return e.id()}))}startTime(){return this._animations[0].startTime()}finiteDuration(){let e=0;for(let t=0;t<this._animations.length;++t)e=Math.max(e,this._animations[t]._finiteDuration());return e}seekTo(e){this._animationModel._agent.invoke_seekAnimations({animations:this._animationIds(),currentTime:e})}paused(){return this._paused}togglePause(e){e!==this._paused&&(this._paused=e,this._animationModel._agent.invoke_setPaused({animations:this._animationIds(),paused:e}))}currentTimePromise(){let e=null;for(const t of this._animations)(!e||t.endTime()>e.endTime())&&(e=t);if(!e)throw new Error("No longest animation found");return this._animationModel._agent.invoke_getCurrentTime({id:e.id()}).then((({currentTime:e})=>e||0))}_matches(e){function t(e){return e.type()===S.WebAnimation?e.type()+e.id():e._cssId()}if(this._animations.length!==e._animations.length)return!1;const i=this._animations.map(t).sort(),n=e._animations.map(t).sort();for(let e=0;e<i.length;e++)if(i[e]!==n[e])return!1;return!0}_update(e){this._animationModel._releaseAnimations(this._animationIds()),this._animations=e._animations}screenshots(){for(let e=0;e<this._screenshots.length;++e){const t=new Image;t.src="data:image/jpeg;base64,"+this._screenshots[e],this._screenshotImages.push(t)}return this._screenshots=[],this._screenshotImages}}class R{constructor(e){this._animationModel=e}animationCreated({id:e}){this._animationModel.animationCreated(e)}animationCanceled({id:e}){this._animationModel._animationCanceled(e)}animationStarted({animation:e}){this._animationModel.animationStarted(e)}}class E{constructor(e,t){this._requests=[],this._screenCaptureModel=t,this._animationModel=e,this._animationModel.addEventListener(A.ModelReset,this._stopScreencast,this)}captureScreenshots(e,t){const i=Math.min(e/this._animationModel._playbackRate,3e3),n=i+window.performance.now();this._requests.push({endTime:n,screenshots:t}),(!this._endTime||n>this._endTime)&&(clearTimeout(this._stopTimer),this._stopTimer=window.setTimeout(this._stopScreencast.bind(this),i),this._endTime=n),this._capturing||(this._capturing=!0,this._screenCaptureModel.startScreencast(Protocol.Page.StartScreencastRequestFormat.Jpeg,80,void 0,300,2,this._screencastFrame.bind(this),(e=>{})))}_screencastFrame(e,t){if(!this._capturing)return;const i=window.performance.now();this._requests=this._requests.filter((function(e){return e.endTime>=i}));for(const t of this._requests)t.screenshots.push(e)}_stopScreencast(){this._capturing&&(delete this._stopTimer,delete this._endTime,this._requests=[],this._capturing=!1,this._screenCaptureModel.stopScreencast())}}b.SDKModel.register(M,b.Capability.DOM,!1);var B=Object.freeze({__proto__:null,AnimationModel:M,Events:A,AnimationImpl:k,Type:S,AnimationEffect:C,KeyframesRule:T,KeyframeStyle:P,AnimationGroup:x,AnimationDispatcher:R,ScreenshotCapture:E,Request:undefined});class G extends e.VBox{constructor(e){super(!0),console.assert(e.length>0),this.registerRequiredCSS("animation/animationScreenshotPopover.css",{enableLegacyPatching:!1}),this.contentElement.classList.add("animation-screenshot-popover"),this._frames=e;for(const t of e)this.contentElement.appendChild(t),t.style.display="none";this._rafId=0,this._currentFrame=0,this._frames[0].style.display="block",this._progressBar=this.contentElement.createChild("div","animation-progress")}wasShown(){this._rafId=this.contentElement.window().requestAnimationFrame(this._changeFrame.bind(this))}willHide(){this.contentElement.window().cancelAnimationFrame(this._rafId),delete this._endDelay}_changeFrame(){if(this._rafId=this.contentElement.window().requestAnimationFrame(this._changeFrame.bind(this)),this._endDelay)return void this._endDelay--;if(this._showFrame=!this._showFrame,!this._showFrame)return;const e=this._frames.length;this._frames[this._currentFrame%e].style.display="none",this._currentFrame++,this._frames[this._currentFrame%e].style.display="block",this._currentFrame%e==e-1&&(this._endDelay=50),this._progressBar.style.width=(this._currentFrame%e+1)/e*100+"%"}}var L=Object.freeze({__proto__:null,AnimationScreenshotPopover:G});const I={selectAnEffectAboveToInspectAnd:"Select an effect above to inspect and modify.",clearAll:"Clear all",pauseAll:"Pause all",playbackRates:"Playback rates",playbackRatePlaceholder:"{PH1}%",pause:"Pause",setSpeedToS:"Set speed to {PH1}",animationPreviews:"Animation previews",listeningForAnimations:"Listening for animations...",replayTimeline:"Replay timeline",resumeAll:"Resume all",playTimeline:"Play timeline",pauseTimeline:"Pause timeline",animationPreviewS:"Animation Preview {PH1}"},D=m.registerUIStrings("animation/AnimationTimeline.js",I),F=m.getLocalizedString.bind(void 0,D),N=new WeakMap,H=new WeakMap;class O extends e.VBox{constructor(){super(!0),this.registerRequiredCSS("animation/animationTimeline.css",{enableLegacyPatching:!1}),this.element.classList.add("animations-timeline"),this._gridWrapper=this.contentElement.createChild("div","grid-overflow-wrapper"),this._grid=t.createSVGChild(this._gridWrapper,"svg","animation-timeline-grid"),this._playbackRate=1,this._allPaused=!1,this._createHeader(),this._animationsContainer=this.contentElement.createChild("div","animation-timeline-rows");this.contentElement.createChild("div","animation-timeline-rows-hint").textContent=F(I.selectAnEffectAboveToInspectAnd),this._playbackRateButtons,this._previewContainer,this._timelineScrubber,this._currentTime,this._popoverHelper,this._clearButton,this._selectedGroup,this._renderQueue,this._defaultDuration=100,this._duration=this._defaultDuration,this._timelineControlsWidth=150,this._nodesMap=new Map,this._uiAnimations=[],this._groupBuffer=[],this._previewMap=new Map,this._symbol=Symbol("animationTimeline"),this._animationsMap=new Map,b.TargetManager.instance().addModelListener(w.DOMModel,w.Events.NodeRemoved,this._nodeRemoved,this),b.TargetManager.instance().observeModels(M,this),i.Context.instance().addFlavorChangeListener(w.DOMNode,this._nodeChanged,this)}wasShown(){for(const e of b.TargetManager.instance().models(M))this._addEventListeners(e)}willHide(){for(const e of b.TargetManager.instance().models(M))this._removeEventListeners(e);this._popoverHelper&&this._popoverHelper.hidePopover()}modelAdded(e){this.isShowing()&&this._addEventListeners(e)}modelRemoved(e){this._removeEventListeners(e)}_addEventListeners(e){e.ensureEnabled(),e.addEventListener(A.AnimationGroupStarted,this._animationGroupStarted,this),e.addEventListener(A.ModelReset,this._reset,this)}_removeEventListeners(e){e.removeEventListener(A.AnimationGroupStarted,this._animationGroupStarted,this),e.removeEventListener(A.ModelReset,this._reset,this)}_nodeChanged(){for(const e of this._nodesMap.values())e._nodeChanged()}_createScrubber(){return this._timelineScrubber=document.createElement("div"),this._timelineScrubber.classList.add("animation-scrubber"),this._timelineScrubber.classList.add("hidden"),this._timelineScrubberLine=this._timelineScrubber.createChild("div","animation-scrubber-line"),this._timelineScrubberLine.createChild("div","animation-scrubber-head"),this._timelineScrubber.createChild("div","animation-time-overlay"),this._timelineScrubber}_createHeader(){const e=this.contentElement.createChild("div","animation-timeline-toolbar-container"),i=new n.Toolbar("animation-timeline-toolbar",e);this._clearButton=new n.ToolbarButton(F(I.clearAll),"largeicon-clear"),this._clearButton.addEventListener(n.ToolbarButton.Events.Click,this._reset.bind(this)),i.appendToolbarItem(this._clearButton),i.appendSeparator(),this._pauseButton=new n.ToolbarToggle(F(I.pauseAll),"largeicon-pause","largeicon-resume"),this._pauseButton.addEventListener(n.ToolbarButton.Events.Click,this._togglePauseAll.bind(this)),i.appendToolbarItem(this._pauseButton);const o=e.createChild("div","animation-playback-rate-control");o.addEventListener("keydown",this._handlePlaybackRateControlKeyDown.bind(this)),s.markAsListBox(o),s.setAccessibleName(o,F(I.playbackRates)),this._playbackRateButtons=[];for(const e of K){const t=o.createChild("button","animation-playback-rate-button");t.textContent=e?F(I.playbackRatePlaceholder,{PH1:100*e}):F(I.pause),H.set(t,e),t.addEventListener("click",this._setPlaybackRate.bind(this,e)),s.markAsOption(t),a.Tooltip.install(t,F(I.setSpeedToS,{PH1:t.textContent})),t.tabIndex=-1,this._playbackRateButtons.push(t)}this._updatePlaybackControls(),this._previewContainer=this.contentElement.createChild("div","animation-timeline-buffer"),s.markAsListBox(this._previewContainer),s.setAccessibleName(this._previewContainer,F(I.animationPreviews)),this._popoverHelper=new r.PopoverHelper(this._previewContainer,this._getPopoverRequest.bind(this)),this._popoverHelper.setDisableOnClick(!0),this._popoverHelper.setTimeout(0);this.contentElement.createChild("div","animation-timeline-buffer-hint").textContent=F(I.listeningForAnimations);const h=this.contentElement.createChild("div","animation-timeline-header"),l=h.createChild("div","animation-controls");this._currentTime=l.createChild("div","animation-timeline-current-time monospace");const d=new n.Toolbar("animation-controls-toolbar",l);this._controlButton=new n.ToolbarToggle(F(I.replayTimeline),"largeicon-replay-animation"),this._controlState=U.Replay,this._controlButton.setToggled(!0),this._controlButton.addEventListener(n.ToolbarButton.Events.Click,this._controlButtonToggle.bind(this)),d.appendToolbarItem(this._controlButton);const _=h.createChild("div","animation-grid-header");return t.installDragHandle(_,this._repositionScrubber.bind(this),this._scrubberDragMove.bind(this),this._scrubberDragEnd.bind(this),"text"),this._gridWrapper.appendChild(this._createScrubber()),this._timelineScrubberLine&&t.installDragHandle(this._timelineScrubberLine,this._scrubberDragStart.bind(this),this._scrubberDragMove.bind(this),this._scrubberDragEnd.bind(this),"col-resize"),this._currentTime.textContent="",h}_handlePlaybackRateControlKeyDown(e){switch(e.key){case"ArrowLeft":case"ArrowUp":this._focusNextPlaybackRateButton(e.target,!0);break;case"ArrowRight":case"ArrowDown":this._focusNextPlaybackRateButton(e.target)}}_focusNextPlaybackRateButton(e,t){const i=e,n=this._playbackRateButtons.indexOf(i),s=t?n-1:n+1;if(s<0||s>=this._playbackRateButtons.length)return;const a=this._playbackRateButtons[s];a.tabIndex=0,a.focus(),e&&(e.tabIndex=-1)}_getPopoverRequest(e){const t=e.target;return t&&t.isDescendant(this._previewContainer)?{box:t.boxInWindow(),show:e=>{let i;for(const[e,n]of this._previewMap)n.element===t.parentElement&&(i=e);if(console.assert(void 0!==i),!i)return Promise.resolve(!1);const n=i.screenshots();if(!n.length)return Promise.resolve(!1);let s;const a=new Promise((e=>{s=e}));return n[0].complete?r(n):n[0].onload=r.bind(null,n),a;function r(t){new G(t).show(e.contentElement),s(!0)}},hide:void 0}:null}_togglePauseAll(){this._allPaused=!this._allPaused,this._pauseButton&&this._pauseButton.setToggled(this._allPaused),this._setPlaybackRate(this._playbackRate),this._pauseButton&&this._pauseButton.setTitle(this._allPaused?F(I.resumeAll):F(I.pauseAll))}_setPlaybackRate(e){this._playbackRate=e;for(const e of b.TargetManager.instance().models(M))e.setPlaybackRate(this._allPaused?0:this._playbackRate);u.actionTaken(p.Action.AnimationsPlaybackRateChanged),this._scrubberPlayer&&(this._scrubberPlayer.playbackRate=this._effectivePlaybackRate()),this._updatePlaybackControls()}_updatePlaybackControls(){for(const e of this._playbackRateButtons){const t=this._playbackRate===H.get(e);e.classList.toggle("selected",t),e.tabIndex=t?0:-1}}_controlButtonToggle(){this._controlState===U.Play?this._togglePause(!1):this._controlState===U.Replay?this._replay():this._togglePause(!0)}_updateControlButton(){this._controlButton&&(this._controlButton.setEnabled(!!this._selectedGroup),this._selectedGroup&&this._selectedGroup.paused()?(this._controlState=U.Play,this._controlButton.setToggled(!0),this._controlButton.setTitle(F(I.playTimeline)),this._controlButton.setGlyph("largeicon-play-animation")):!this._scrubberPlayer||!this._scrubberPlayer.currentTime||this._scrubberPlayer.currentTime>=this.duration()?(this._controlState=U.Replay,this._controlButton.setToggled(!0),this._controlButton.setTitle(F(I.replayTimeline)),this._controlButton.setGlyph("largeicon-replay-animation")):(this._controlState=U.Pause,this._controlButton.setToggled(!1),this._controlButton.setTitle(F(I.pauseTimeline)),this._controlButton.setGlyph("largeicon-pause-animation")))}_effectivePlaybackRate(){return this._allPaused||this._selectedGroup&&this._selectedGroup.paused()?0:this._playbackRate}_togglePause(e){if(this._scrubberPlayer&&(this._scrubberPlayer.playbackRate=this._effectivePlaybackRate()),this._selectedGroup){this._selectedGroup.togglePause(e);const t=this._previewMap.get(this._selectedGroup);t&&t.element.classList.toggle("paused",e)}this._updateControlButton()}_replay(){this._selectedGroup&&(this._selectedGroup.seekTo(0),this._animateTime(0),this._updateControlButton())}duration(){return this._duration}setDuration(e){this._duration=e,this.scheduleRedraw()}_clearTimeline(){this._uiAnimations=[],this._nodesMap.clear(),this._animationsMap.clear(),this._animationsContainer.removeChildren(),this._duration=this._defaultDuration,this._timelineScrubber.classList.add("hidden"),this._selectedGroup=null,this._scrubberPlayer&&this._scrubberPlayer.cancel(),delete this._scrubberPlayer,this._currentTime.textContent="",this._updateControlButton()}_reset(){this._clearTimeline(),this._allPaused?this._togglePauseAll():this._setPlaybackRate(this._playbackRate);for(const e of this._groupBuffer)e.release();this._groupBuffer=[],this._previewMap.clear(),this._previewContainer.removeChildren(),this._popoverHelper.hidePopover(),this._renderGrid()}_animationGroupStarted(e){this._addAnimationGroup(e.data)}_addAnimationGroup(e){const t=this._previewMap.get(e);if(t)return void(this._selectedGroup===e?this._syncScrubber():t.replay());this._groupBuffer.sort((function(e,t){return e.startTime()===t.startTime()?0:e.startTime()>t.startTime()?1:-1}));const i=[],n=this.width()/50;for(;this._groupBuffer.length>n;){const e=this._groupBuffer.splice(this._groupBuffer[0]===this._selectedGroup?1:0,1);i.push(e[0])}for(const e of i){const t=this._previewMap.get(e);t&&(t.element.remove(),this._previewMap.delete(e),e.release())}const a=new ee(e);if(this._groupBuffer.push(e),this._previewMap.set(e,a),this._previewContainer.appendChild(a.element),a.removeButton().addEventListener("click",this._removeAnimationGroup.bind(this,e)),a.element.addEventListener("click",this._selectAnimationGroup.bind(this,e)),a.element.addEventListener("keydown",this._handleAnimationGroupKeyDown.bind(this,e)),s.setAccessibleName(a.element,F(I.animationPreviewS,{PH1:this._groupBuffer.indexOf(e)+1})),s.markAsOption(a.element),1===this._previewMap.size){const e=this._previewMap.get(this._groupBuffer[0]);e&&(e.element.tabIndex=0)}}_handleAnimationGroupKeyDown(e,t){switch(t.key){case" ":case"Enter":this._selectAnimationGroup(e);break;case"Backspace":case"Delete":this._removeAnimationGroup(e,t);break;case"ArrowLeft":case"ArrowUp":this._focusNextGroup(e,t.target,!0);break;case"ArrowRight":case"ArrowDown":this._focusNextGroup(e,t.target)}}_focusNextGroup(e,t,i){const n=this._groupBuffer.indexOf(e),s=i?n-1:n+1;if(s<0||s>=this._groupBuffer.length)return;const a=this._previewMap.get(this._groupBuffer[s]);a&&(a.element.tabIndex=0,a.element.focus()),t&&(t.tabIndex=-1)}_removeAnimationGroup(e,t){const i=this._groupBuffer.indexOf(e);f.removeElement(this._groupBuffer,e);const n=this._previewMap.get(e);n&&n.element.remove(),this._previewMap.delete(e),e.release(),t.consume(!0),this._selectedGroup===e&&(this._clearTimeline(),this._renderGrid());if(0===this._groupBuffer.length)return void this._clearButton.element.focus();const s=i>=this._groupBuffer.length?this._previewMap.get(this._groupBuffer[this._groupBuffer.length-1]):this._previewMap.get(this._groupBuffer[i]);s&&(s.element.tabIndex=0,s.element.focus())}_selectAnimationGroup(e){if(this._selectedGroup===e)return this._togglePause(!1),void this._replay();this._clearTimeline(),this._selectedGroup=e,this._previewMap.forEach((function(e,t){e.element.classList.toggle("selected",this._selectedGroup===t)}),this),this.setDuration(Math.max(500,e.finiteDuration()+100));for(const t of e.animations())this._addAnimation(t);this.scheduleRedraw(),this._timelineScrubber.classList.remove("hidden"),this._togglePause(!1),this._replay()}_addAnimation(e){let t=this._nodesMap.get(e.source().backendNodeId());t||(t=new V(e.source()),this._animationsContainer.appendChild(t.element),this._nodesMap.set(e.source().backendNodeId(),t));const i=t.createNewRow(),n=new Q(e,this,i);e.source().deferredNode().resolve(function(e){n.setNode(e),e&&t&&(t.nodeResolved(e),N.set(e,t))}.bind(this)),this._uiAnimations.push(n),this._animationsMap.set(e.id(),e)}_nodeRemoved(e){const t=e.data.node,i=N.get(t);i&&i.nodeRemoved()}_renderGrid(){const e=(this.width()+10).toString(),i=((this._cachedTimelineHeight||0)+30).toString();this._gridWrapper.style.width=e+"px",this._gridWrapper.style.height=i.toString()+"px",this._grid.setAttribute("width",e),this._grid.setAttribute("height",i.toString()),this._grid.setAttribute("shape-rendering","crispEdges"),this._grid.removeChildren();let n=void 0;for(let e=0;e<this.duration();e+=250){const i=t.createSVGChild(this._grid,"rect","animation-timeline-grid-line");i.setAttribute("x",(e*this.pixelMsRatio()+10).toString()),i.setAttribute("y","23"),i.setAttribute("height","100%"),i.setAttribute("width","1")}for(let e=0;e<this.duration();e+=250){const i=e*this.pixelMsRatio();if(void 0===n||i-n>50){n=i;const s=t.createSVGChild(this._grid,"text","animation-timeline-grid-label");s.textContent=Number.millisToString(e),s.setAttribute("x",(i+10).toString()),s.setAttribute("y","16")}}}scheduleRedraw(){this._renderQueue=[];for(const e of this._uiAnimations)this._renderQueue.push(e);this._redrawing||(this._redrawing=!0,this._renderGrid(),this._animationsContainer.window().requestAnimationFrame(this._render.bind(this)))}_render(e){for(;this._renderQueue.length&&(!e||window.performance.now()-e<50);){const e=this._renderQueue.shift();e&&e.redraw()}this._renderQueue.length?this._animationsContainer.window().requestAnimationFrame(this._render.bind(this)):delete this._redrawing}onResize(){this._cachedTimelineWidth=Math.max(0,this._animationsContainer.offsetWidth-this._timelineControlsWidth)||0,this._cachedTimelineHeight=this._animationsContainer.offsetHeight,this.scheduleRedraw(),this._scrubberPlayer&&this._syncScrubber(),delete this._gridOffsetLeft}width(){return this._cachedTimelineWidth||0}_resizeWindow(e){let t=!1;const i=e.source().duration()*Math.min(2,e.source().iterations()),n=e.source().delay()+i+e.source().endDelay();return n>this._duration&&(t=!0,this._duration=n+200),t}_syncScrubber(){this._selectedGroup&&this._selectedGroup.currentTimePromise().then(this._animateTime.bind(this)).then(this._updateControlButton.bind(this))}_animateTime(e){this._scrubberPlayer&&this._scrubberPlayer.cancel(),this._scrubberPlayer=this._timelineScrubber.animate([{transform:"translateX(0px)"},{transform:"translateX("+this.width()+"px)"}],{duration:this.duration(),fill:"forwards"}),this._scrubberPlayer.playbackRate=this._effectivePlaybackRate(),this._scrubberPlayer.onfinish=this._updateControlButton.bind(this),this._scrubberPlayer.currentTime=e,this.element.window().requestAnimationFrame(this._updateScrubber.bind(this))}pixelMsRatio(){return this.width()/this.duration()||0}_updateScrubber(e){this._scrubberPlayer&&(this._currentTime.textContent=Number.millisToString(this._scrubberPlayer.currentTime||0),"pending"===this._scrubberPlayer.playState.toString()||"running"===this._scrubberPlayer.playState?this.element.window().requestAnimationFrame(this._updateScrubber.bind(this)):"finished"===this._scrubberPlayer.playState&&(this._currentTime.textContent=""))}_repositionScrubber(e){if(!this._selectedGroup)return!1;this._gridOffsetLeft||(this._gridOffsetLeft=this._grid.totalOffsetLeft()+10);const{x:t}=e,i=Math.max(0,t-this._gridOffsetLeft)/this.pixelMsRatio();return this._selectedGroup.seekTo(i),this._togglePause(!0),this._animateTime(i),this._originalScrubberTime=i,this._originalMousePosition=t,!0}_scrubberDragStart(e){if(!this._scrubberPlayer||!this._selectedGroup)return!1;this._originalScrubberTime=this._scrubberPlayer.currentTime,this._timelineScrubber.classList.remove("animation-timeline-end"),this._scrubberPlayer.pause();const{x:t}=e;return this._originalMousePosition=t,this._togglePause(!0),!0}_scrubberDragMove(e){const{x:t}=e,i=t-this._originalMousePosition,n=Math.max(0,Math.min((this._originalScrubberTime||0)+i/this.pixelMsRatio(),this.duration()));this._scrubberPlayer&&(this._scrubberPlayer.currentTime=n),this._currentTime.textContent=Number.millisToString(Math.round(n)),this._selectedGroup&&this._selectedGroup.seekTo(n)}_scrubberDragEnd(e){if(this._scrubberPlayer){const e=Math.max(0,this._scrubberPlayer.currentTime||0);this._scrubberPlayer.play(),this._scrubberPlayer.currentTime=e}this._currentTime.window().requestAnimationFrame(this._updateScrubber.bind(this))}}const K=[1,.25,.1],U={Play:"play-outline",Replay:"replay-outline",Pause:"pause-outline"};class V{constructor(e){this.element=document.createElement("div"),this.element.classList.add("animation-node-row"),this._description=this.element.createChild("div","animation-node-description"),this._description.tabIndex=0,this._timelineElement=this.element.createChild("div","animation-node-timeline"),s.markAsApplication(this._timelineElement)}nodeResolved(e){e?(this._node=e,this._nodeChanged(),l.Linkifier.linkify(e).then((e=>this._description.appendChild(e))),e.ownerDocument||this.nodeRemoved()):t.createTextChild(this._description,"<node>")}createNewRow(){return this._timelineElement.createChild("div","animation-timeline-row")}nodeRemoved(){this.element.classList.add("animation-node-removed"),this._node=null}_nodeChanged(){let e=!1;this._node&&(e=this._node===i.Context.instance().flavor(w.DOMNode)),this.element.classList.toggle("animation-node-selected",e)}}class j{constructor(e,t){this.steps=e,this.stepAtPosition=t}static parse(e){let t=e.match(/^steps\((\d+), (start|middle)\)$/);return t?new j(parseInt(t[1],10),t[2]):(t=e.match(/^steps\((\d+)\)$/),t?new j(parseInt(t[1],10),"end"):null)}}var q=Object.freeze({__proto__:null,UIStrings:I,AnimationTimeline:O,GlobalPlaybackRates:K,_ControlState:U,NodeUI:V,StepTimingFunction:j});const W={animationEndpointSlider:"Animation Endpoint slider",animationKeyframeSlider:"Animation Keyframe slider",sSlider:"{PH1} slider"},z=m.registerUIStrings("animation/AnimationUI.js",W),X=m.getLocalizedString.bind(void 0,z);class Q{constructor(e,i,n){this._animation=e,this._timeline=i,this._parentElement=n;const s=this._animation.source().keyframesRule();s&&(this._keyframes=s.keyframes()),this._nameElement=n.createChild("div","animation-name"),this._nameElement.textContent=this._animation.name(),this._svg=t.createSVGChild(n,"svg","animation-ui"),this._svg.setAttribute("height",J.AnimationSVGHeight.toString()),this._svg.style.marginLeft="-"+J.AnimationMargin+"px",this._svg.addEventListener("contextmenu",this._onContextMenu.bind(this)),this._activeIntervalGroup=t.createSVGChild(this._svg,"g"),t.installDragHandle(this._activeIntervalGroup,this._mouseDown.bind(this,$.AnimationDrag,null),this._mouseMove.bind(this),this._mouseUp.bind(this),"-webkit-grabbing","-webkit-grab"),Q.installDragHandleKeyboard(this._activeIntervalGroup,this._keydownMove.bind(this,$.AnimationDrag,null)),this._cachedElements=[],this._movementInMs=0,this._keyboardMovementRateMs=50,this._color=Q.Color(this._animation)}static Color(e){const t=Array.from(Z.keys()),i=t[String.hashCode(e.name()||e.id())%t.length],n=Z.get(i);if(!n)throw new Error("Unable to locate color");return n.asString(d.Format.RGB)||""}static installDragHandleKeyboard(e,t){e.addEventListener("keydown",t,!1)}animation(){return this._animation}setNode(e){this._node=e}_createLine(e,i){const n=t.createSVGChild(e,"line",i);return n.setAttribute("x1",J.AnimationMargin.toString()),n.setAttribute("y1",J.AnimationHeight.toString()),n.setAttribute("y2",J.AnimationHeight.toString()),n.style.stroke=this._color,n}_drawAnimationLine(e,t){const i=this._cachedElements[e];i.animationLine||(i.animationLine=this._createLine(t,"animation-line")),i.animationLine&&i.animationLine.setAttribute("x2",(this._duration()*this._timeline.pixelMsRatio()+J.AnimationMargin).toFixed(2))}_drawDelayLine(e){this._delayLine&&this._endDelayLine||(this._delayLine=this._createLine(e,"animation-delay-line"),this._endDelayLine=this._createLine(e,"animation-delay-line"));const t=this._animation.source().fill();this._delayLine.classList.toggle("animation-fill","backwards"===t||"both"===t);const i=J.AnimationMargin;this._delayLine.setAttribute("x1",i.toString()),this._delayLine.setAttribute("x2",(this._delay()*this._timeline.pixelMsRatio()+i).toFixed(2));const n="forwards"===t||"both"===t;this._endDelayLine.classList.toggle("animation-fill",n);const s=Math.min(this._timeline.width(),(this._delay()+this._duration()*this._animation.source().iterations())*this._timeline.pixelMsRatio());this._endDelayLine.style.transform="translateX("+s.toFixed(2)+"px)",this._endDelayLine.setAttribute("x1",i.toString()),this._endDelayLine.setAttribute("x2",n?(this._timeline.width()-s+i).toFixed(2):(this._animation.source().endDelay()*this._timeline.pixelMsRatio()+i).toFixed(2))}_drawPoint(e,i,n,a,r){if(this._cachedElements[e].keyframePoints[a])return void this._cachedElements[e].keyframePoints[a].setAttribute("cx",n.toFixed(2));const o=t.createSVGChild(i,"circle",a<=0?"animation-endpoint":"animation-keyframe-point");if(o.setAttribute("cx",n.toFixed(2)),o.setAttribute("cy",J.AnimationHeight.toString()),o.style.stroke=this._color,o.setAttribute("r",(J.AnimationMargin/2).toString()),o.tabIndex=0,s.setAccessibleName(o,X(a<=0?W.animationEndpointSlider:W.animationKeyframeSlider)),a<=0&&(o.style.fill=this._color),this._cachedElements[e].keyframePoints[a]=o,!r)return;let h;h=0===a?$.StartEndpointMove:-1===a?$.FinishEndpointMove:$.KeyframeMove,t.installDragHandle(o,this._mouseDown.bind(this,h,a),this._mouseMove.bind(this),this._mouseUp.bind(this),"ew-resize"),Q.installDragHandleKeyboard(o,this._keydownMove.bind(this,h,a))}_renderKeyframe(e,i,n,a,r,h){function l(e,i,n){const s=t.createSVGChild(e,"line");s.setAttribute("x1",i.toString()),s.setAttribute("x2",i.toString()),s.setAttribute("y1",J.AnimationMargin.toString()),s.setAttribute("y2",J.AnimationHeight.toString()),s.style.stroke=n}const d=o.CubicBezier.parse(h),_=this._cachedElements[e].keyframeRender;if(!_[i]){const e=d?t.createSVGChild(n,"path","animation-keyframe"):t.createSVGChild(n,"g","animation-keyframe-step");_[i]=e}const m=_[i];if(m.tabIndex=0,s.setAccessibleName(m,X(W.sSlider,{PH1:this._animation.name()})),m.style.transform="translateX("+a.toFixed(2)+"px)","linear"===h){m.style.fill=this._color;const e=c.Height;m.setAttribute("d",["M",0,e,"L",0,5,"L",r.toFixed(2),5,"L",r.toFixed(2),e,"Z"].join(" "))}else if(d)m.style.fill=this._color,c.BezierUI.drawVelocityChart(d,m,r);else{const e=j.parse(h);m.removeChildren();const t={start:0,middle:.5,end:1};if(e){const i=t[e.stepAtPosition];for(let t=0;t<e.steps;t++)l(m,(t+i)*r/e.steps,this._color)}}}redraw(){const e=this._timeline.width()-J.AnimationMargin;if(this._svg.setAttribute("width",(e+2*J.AnimationMargin).toFixed(2)),this._activeIntervalGroup.style.transform="translateX("+(this._delay()*this._timeline.pixelMsRatio()).toFixed(2)+"px)",this._nameElement.style.transform="translateX("+(this._delay()*this._timeline.pixelMsRatio()+J.AnimationMargin).toFixed(2)+"px)",this._nameElement.style.width=(this._duration()*this._timeline.pixelMsRatio()).toFixed(2)+"px",this._drawDelayLine(this._svg),"CSSTransition"===this._animation.type())return void this._renderTransition();this._renderIteration(this._activeIntervalGroup,0),this._tailGroup||(this._tailGroup=t.createSVGChild(this._activeIntervalGroup,"g","animation-tail-iterations"));const i=this._duration()*this._timeline.pixelMsRatio();let n;for(n=1;n<this._animation.source().iterations()&&i*(n-1)<this._timeline.width();n++)this._renderIteration(this._tailGroup,n);for(;n<this._cachedElements.length;){const e=this._cachedElements.pop();e&&e.group&&e.group.remove()}}_renderTransition(){const e=this._activeIntervalGroup;this._cachedElements[0]||(this._cachedElements[0]={animationLine:null,keyframePoints:{},keyframeRender:{},group:null}),this._drawAnimationLine(0,e),this._renderKeyframe(0,0,e,J.AnimationMargin,this._duration()*this._timeline.pixelMsRatio(),this._animation.source().easing()),this._drawPoint(0,e,J.AnimationMargin,0,!0),this._drawPoint(0,e,this._duration()*this._timeline.pixelMsRatio()+J.AnimationMargin,-1,!0)}_renderIteration(e,i){this._cachedElements[i]||(this._cachedElements[i]={animationLine:null,keyframePoints:{},keyframeRender:{},group:t.createSVGChild(e,"g")});const n=this._cachedElements[i].group;if(n){if(n.style.transform="translateX("+(i*this._duration()*this._timeline.pixelMsRatio()).toFixed(2)+"px)",this._drawAnimationLine(i,n),this._keyframes&&this._keyframes.length>1)for(let e=0;e<this._keyframes.length-1;e++){const t=this._offset(e)*this._duration()*this._timeline.pixelMsRatio()+J.AnimationMargin,s=this._duration()*(this._offset(e+1)-this._offset(e))*this._timeline.pixelMsRatio();this._renderKeyframe(i,e,n,t,s,this._keyframes[e].easing()),(e||!e&&0===i)&&this._drawPoint(i,n,t,e,0===i)}this._drawPoint(i,n,this._duration()*this._timeline.pixelMsRatio()+J.AnimationMargin,-1,0===i)}}_delay(){let e=this._animation.source().delay();return this._mouseEventType!==$.AnimationDrag&&this._mouseEventType!==$.StartEndpointMove||(e+=this._movementInMs),Math.max(0,e)}_duration(){let e=this._animation.source().duration();return this._mouseEventType===$.FinishEndpointMove?e+=this._movementInMs:this._mouseEventType===$.StartEndpointMove&&(e-=Math.max(this._movementInMs,-this._animation.source().delay())),Math.max(0,e)}_offset(e){if(!this._keyframes)throw new Error("Unable to calculate offset; keyframes do not exist");let t=this._keyframes[e].offsetAsNumber();return this._mouseEventType===$.KeyframeMove&&e===this._keyframeMoved&&(console.assert(e>0&&e<this._keyframes.length-1,"First and last keyframe cannot be moved"),t+=this._movementInMs/this._animation.source().duration(),t=Math.max(t,this._keyframes[e-1].offsetAsNumber()),t=Math.min(t,this._keyframes[e+1].offsetAsNumber())),t}_mouseDown(e,t,i){const n=i;return 2!==n.buttons&&(!this._svg.enclosingNodeOrSelfWithClass("animation-node-removed")&&(this._mouseEventType=e,this._keyframeMoved=t,this._downMouseX=n.clientX,i.consume(!0),this._node&&_.reveal(this._node),!0))}_mouseMove(e){const t=e;this._setMovementAndRedraw((t.clientX-(this._downMouseX||0))/this._timeline.pixelMsRatio())}_setMovementAndRedraw(e){this._movementInMs=e,this._delay()+this._duration()>.8*this._timeline.duration()&&this._timeline.setDuration(1.2*this._timeline.duration()),this.redraw()}_mouseUp(e){const t=e;this._movementInMs=(t.clientX-(this._downMouseX||0))/this._timeline.pixelMsRatio(),this._mouseEventType===$.KeyframeMove?this._keyframes&&null!==this._keyframeMoved&&void 0!==this._keyframeMoved&&this._keyframes[this._keyframeMoved].setOffset(this._offset(this._keyframeMoved)):this._animation.setTiming(this._duration(),this._delay()),this._movementInMs=0,this.redraw(),delete this._mouseEventType,delete this._downMouseX,delete this._keyframeMoved}_keydownMove(e,t,i){const n=i;switch(this._mouseEventType=e,this._keyframeMoved=t,n.key){case"ArrowLeft":case"ArrowUp":this._movementInMs=-this._keyboardMovementRateMs;break;case"ArrowRight":case"ArrowDown":this._movementInMs=this._keyboardMovementRateMs;break;default:return}this._mouseEventType===$.KeyframeMove?this._keyframes&&null!==this._keyframeMoved&&this._keyframes[this._keyframeMoved].setOffset(this._offset(this._keyframeMoved)):this._animation.setTiming(this._duration(),this._delay()),this._setMovementAndRedraw(0),delete this._mouseEventType,delete this._keyframeMoved,i.consume(!0)}_onContextMenu(e){this._animation.remoteObjectPromise().then((function(t){if(!t)return;const i=new h.ContextMenu(e);i.appendApplicableItems(t),i.show()})),e.consume(!0)}}const $={AnimationDrag:"AnimationDrag",KeyframeMove:"KeyframeMove",StartEndpointMove:"StartEndpointMove",FinishEndpointMove:"FinishEndpointMove"},J={AnimationHeight:26,AnimationSVGHeight:50,AnimationMargin:7,EndpointsClickRegionSize:10,GridCanvasHeight:40},Z=new Map([["Purple",d.Color.parse("#9C27B0")],["Light Blue",d.Color.parse("#03A9F4")],["Deep Orange",d.Color.parse("#FF5722")],["Blue",d.Color.parse("#5677FC")],["Lime",d.Color.parse("#CDDC39")],["Blue Grey",d.Color.parse("#607D8B")],["Pink",d.Color.parse("#E91E63")],["Green",d.Color.parse("#0F9D58")],["Brown",d.Color.parse("#795548")],["Cyan",d.Color.parse("#00BCD4")]]);var Y=Object.freeze({__proto__:null,UIStrings:W,AnimationUI:Q,Events:$,Options:J,Colors:Z});class ee{constructor(e){this._model=e,this.element=document.createElement("div"),this.element.classList.add("animation-buffer-preview"),this.element.createChild("div","animation-paused fill"),this._removeButton=this.element.createChild("div","animation-remove-button"),this._removeButton.textContent="✕",this._replayOverlayElement=this.element.createChild("div","animation-buffer-preview-animation"),this._svg=t.createSVGChild(this.element,"svg"),this._svg.setAttribute("width","100%"),this._svg.setAttribute("preserveAspectRatio","none"),this._svg.setAttribute("height","100%"),this._viewBoxHeight=32,this._svg.setAttribute("viewBox","0 0 100 "+this._viewBoxHeight),this._svg.setAttribute("shape-rendering","crispEdges"),this._render()}_groupDuration(){let e=0;for(const t of this._model.animations()){const i=t.source().delay()+t.source().duration();i>e&&(e=i)}return e}removeButton(){return this._removeButton}replay(){this._replayOverlayElement.animate([{offset:0,width:"0%",opacity:1},{offset:.9,width:"100%",opacity:1},{offset:1,width:"100%",opacity:0}],{duration:200,easing:"cubic-bezier(0, 0, 0.2, 1)"})}_render(){this._svg.removeChildren();const e=Math.min(this._model.animations().length,10),i=100/Math.max(this._groupDuration(),750);for(let n=0;n<e;n++){const s=this._model.animations()[n].source(),a=t.createSVGChild(this._svg,"line");a.setAttribute("x1",String(s.delay()*i)),a.setAttribute("x2",String((s.delay()+s.duration())*i));const r=String(Math.floor(this._viewBoxHeight/Math.max(6,e)*n+1));a.setAttribute("y1",r),a.setAttribute("y2",r),a.style.stroke=Q.Color(this._model.animations()[n])}}}var te=Object.freeze({__proto__:null,AnimationGroupPreviewUI:ee});export{te as AnimationGroupPreviewUI,B as AnimationModel,L as AnimationScreenshotPopover,q as AnimationTimeline,Y as AnimationUI};
