/*
Open Asset Import Library (ASSIMP)
----------------------------------------------------------------------

Copyright (c) 2006-2018, ASSIMP Development Team
All rights reserved.

Redistribution and use of this software in source and binary forms, 
with or without modification, are permitted provided that the 
following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.

* Redistributions in binary form must reproduce the above
  copyright notice, this list of conditions and the
  following disclaimer in the documentation and/or other
  materials provided with the distribution.

* Neither the name of the ASSIMP team, nor the names of its
  contributors may be used to endorse or promote products
  derived from this software without specific prior
  written permission of the ASSIMP Development Team.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY 
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

----------------------------------------------------------------------
*/

/** MACHINE-GENERATED by scripts/ICFImporter/CppGenerator.py */

#ifndef INCLUDED_STEPFILE_READER_GEN_H
#define INCLUDED_STEPFILE_READER_GEN_H

#include "code/Step/STEPFile.h"

namespace Assimp {
namespace StepFile {
	using namespace STEP;
	using namespace STEP::EXPRESS;
	
	
	struct NotImplemented : public ObjectHelper<NotImplemented,0> {
		
	};
	

	// ******************************************************************************
	// StepFile Custom data types
	// ******************************************************************************


    // C++ wrapper type for absorbed_dose_measure
    typedef REAL absorbed_dose_measure;
    // C++ wrapper type for acceleration_measure
    typedef REAL acceleration_measure;
    // C++ wrapper type for action_items
    typedef SELECT action_items;
    // C++ wrapper type for action_method_items
    typedef SELECT action_method_items;
    // C++ wrapper type for action_request_item
    typedef SELECT action_request_item;
    // C++ wrapper type for ahead_or_behind
    typedef ENUMERATION ahead_or_behind;
    // C++ wrapper type for amount_of_substance_measure
    typedef REAL amount_of_substance_measure;
    // C++ wrapper type for angle_direction_reference_select
    typedef SELECT angle_direction_reference_select;
    // C++ wrapper type for angle_direction_reference_with_a2p3d_select
    typedef SELECT angle_direction_reference_with_a2p3d_select;
    // C++ wrapper type for angle_relator
    typedef ENUMERATION angle_relator;
    // C++ wrapper type for annotation_plane_element
    typedef SELECT annotation_plane_element;
    // C++ wrapper type for annotation_representation_select
    typedef SELECT annotation_representation_select;
    // C++ wrapper type for annotation_symbol_occurrence_item
    typedef SELECT annotation_symbol_occurrence_item;
    // C++ wrapper type for annotation_text_occurrence_item
    typedef SELECT annotation_text_occurrence_item;
    // C++ wrapper type for approval_item
    typedef SELECT approval_item;
    // C++ wrapper type for approved_item
    typedef SELECT approved_item;
    // C++ wrapper type for area_measure
    typedef REAL area_measure;
    // C++ wrapper type for area_or_view
    typedef SELECT area_or_view;
    // C++ wrapper type for attribute_classification_item
    typedef SELECT attribute_classification_item;
    // C++ wrapper type for attribute_language_item
    typedef SELECT attribute_language_item;
    // C++ wrapper type for attribute_type
    typedef SELECT attribute_type;
    // C++ wrapper type for axis2_placement
    typedef SELECT axis2_placement;
    // C++ wrapper type for b_spline_curve_form
    typedef ENUMERATION b_spline_curve_form;
    // C++ wrapper type for b_spline_surface_form
    typedef ENUMERATION b_spline_surface_form;
    // C++ wrapper type for base_solid_select
    typedef SELECT base_solid_select;
    // C++ wrapper type for blend_end_condition_select
    typedef SELECT blend_end_condition_select;
    // C++ wrapper type for blend_radius_variation_type
    typedef ENUMERATION blend_radius_variation_type;
    // C++ wrapper type for boolean_operand
    typedef SELECT boolean_operand;
    // C++ wrapper type for boolean_operator
    typedef ENUMERATION boolean_operator;
    // C++ wrapper type for box_characteristic_select
    typedef SELECT box_characteristic_select;
    // C++ wrapper type for box_height
    typedef REAL box_height;
    // C++ wrapper type for box_rotate_angle
    typedef REAL box_rotate_angle;
    // C++ wrapper type for box_slant_angle
    typedef REAL box_slant_angle;
    // C++ wrapper type for box_width
    typedef REAL box_width;
    // C++ wrapper type for camera_model_d3_multi_clipping_interection_select
    typedef SELECT camera_model_d3_multi_clipping_interection_select;
    // C++ wrapper type for camera_model_d3_multi_clipping_union_select
    typedef SELECT camera_model_d3_multi_clipping_union_select;
    // C++ wrapper type for capacitance_measure
    typedef REAL capacitance_measure;
    // C++ wrapper type for category_usage_item
    typedef SELECT category_usage_item;
    // C++ wrapper type for cc_classified_item
    typedef SELECT cc_classified_item;
    // C++ wrapper type for cc_person_organization_item
    typedef SELECT cc_person_organization_item;
    // C++ wrapper type for cc_specified_item
    typedef SELECT cc_specified_item;
    // C++ wrapper type for celsius_temperature_measure
    typedef REAL celsius_temperature_measure;
    // C++ wrapper type for central_or_parallel
    typedef ENUMERATION central_or_parallel;
    // C++ wrapper type for certification_item
    typedef SELECT certification_item;
    // C++ wrapper type for certified_item
    typedef SELECT certified_item;
    // C++ wrapper type for change_request_item
    typedef SELECT change_request_item;
    // C++ wrapper type for character_spacing_select
    typedef SELECT character_spacing_select;
    // C++ wrapper type for character_style_select
    typedef SELECT character_style_select;
    // C++ wrapper type for characterized_action_definition
    typedef SELECT characterized_action_definition;
    // C++ wrapper type for characterized_definition
    typedef SELECT characterized_definition;
    // C++ wrapper type for characterized_material_property
    typedef SELECT characterized_material_property;
    // C++ wrapper type for characterized_product_composition_value
    typedef SELECT characterized_product_composition_value;
    // C++ wrapper type for characterized_product_definition
    typedef SELECT characterized_product_definition;
    // C++ wrapper type for class_usage_effectivity_context_item
    typedef SELECT class_usage_effectivity_context_item;
    // C++ wrapper type for classification_item
    typedef SELECT classification_item;
    // C++ wrapper type for classified_item
    typedef SELECT classified_item;
    // C++ wrapper type for compound_item_definition
    typedef SELECT compound_item_definition;
    // C++ wrapper type for conductance_measure
    typedef REAL conductance_measure;
    // C++ wrapper type for configuration_design_item
    typedef SELECT configuration_design_item;
    // C++ wrapper type for configured_effectivity_context_item
    typedef SELECT configured_effectivity_context_item;
    // C++ wrapper type for configured_effectivity_item
    typedef SELECT configured_effectivity_item;
    // C++ wrapper type for constructive_geometry_representation_or_shape_represenation
    typedef SELECT constructive_geometry_representation_or_shape_represenation;
    // C++ wrapper type for context_dependent_measure
    typedef REAL context_dependent_measure;
    // C++ wrapper type for contract_item
    typedef SELECT contract_item;
    // C++ wrapper type for contracted_item
    typedef SELECT contracted_item;
    // C++ wrapper type for count_measure
    typedef NUMBER count_measure;
    // C++ wrapper type for csg_primitive
    typedef SELECT csg_primitive;
    // C++ wrapper type for csg_select
    typedef SELECT csg_select;
    // C++ wrapper type for curve_font_or_scaled_curve_font_select
    typedef SELECT curve_font_or_scaled_curve_font_select;
    // C++ wrapper type for curve_on_surface
    typedef SELECT curve_on_surface;
    // C++ wrapper type for curve_or_annotation_curve_occurrence
    typedef SELECT curve_or_annotation_curve_occurrence;
    // C++ wrapper type for curve_or_render
    typedef SELECT curve_or_render;
    // C++ wrapper type for curve_style_font_select
    typedef SELECT curve_style_font_select;
    // C++ wrapper type for date_and_time_item
    typedef SELECT date_and_time_item;
    // C++ wrapper type for date_item
    typedef SELECT date_item;
    // C++ wrapper type for date_time_item
    typedef SELECT date_time_item;
    // C++ wrapper type for date_time_or_event_occurrence
    typedef SELECT date_time_or_event_occurrence;
    // C++ wrapper type for date_time_select
    typedef SELECT date_time_select;
    // C++ wrapper type for day_in_month_number
    typedef INTEGER day_in_month_number;
    // C++ wrapper type for day_in_week_number
    typedef INTEGER day_in_week_number;
    // C++ wrapper type for day_in_year_number
    typedef INTEGER day_in_year_number;
    // C++ wrapper type for defined_symbol_select
    typedef SELECT defined_symbol_select;
    // C++ wrapper type for derived_property_select
    typedef SELECT derived_property_select;
    // C++ wrapper type for description_attribute_select
    typedef SELECT description_attribute_select;
    // C++ wrapper type for descriptive_measure
    typedef STRING descriptive_measure;
    // C++ wrapper type for dimension_count
    typedef INTEGER dimension_count;
    // C++ wrapper type for dimension_extent_usage
    typedef ENUMERATION dimension_extent_usage;
    // C++ wrapper type for dimensional_characteristic
    typedef SELECT dimensional_characteristic;
    // C++ wrapper type for direction_count_select
    typedef SELECT direction_count_select;
    // C++ wrapper type for document_identifier_assigned_item
    typedef SELECT document_identifier_assigned_item;
    // C++ wrapper type for document_reference_item
    typedef SELECT document_reference_item;
    // C++ wrapper type for dose_equivalent_measure
    typedef REAL dose_equivalent_measure;
    // C++ wrapper type for draughting_callout_element
    typedef SELECT draughting_callout_element;
    // C++ wrapper type for draughting_model_item_association_select
    typedef SELECT draughting_model_item_association_select;
    // C++ wrapper type for draughting_model_item_select
    typedef SELECT draughting_model_item_select;
    // C++ wrapper type for draughting_titled_item
    typedef SELECT draughting_titled_item;
    // C++ wrapper type for effectivity_item
    typedef SELECT effectivity_item;
    // C++ wrapper type for electric_charge_measure
    typedef REAL electric_charge_measure;
    // C++ wrapper type for electric_current_measure
    typedef REAL electric_current_measure;
    // C++ wrapper type for electric_potential_measure
    typedef REAL electric_potential_measure;
    // C++ wrapper type for energy_measure
    typedef REAL energy_measure;
    // C++ wrapper type for event_occurrence_item
    typedef SELECT event_occurrence_item;
    // C++ wrapper type for external_identification_item
    typedef SELECT external_identification_item;
    // C++ wrapper type for fill_area_style_tile_shape_select
    typedef SELECT fill_area_style_tile_shape_select;
    // C++ wrapper type for fill_style_select
    typedef SELECT fill_style_select;
    // C++ wrapper type for font_select
    typedef SELECT font_select;
    // C++ wrapper type for force_measure
    typedef REAL force_measure;
    // C++ wrapper type for founded_item_select
    typedef SELECT founded_item_select;
    // C++ wrapper type for frequency_measure
    typedef REAL frequency_measure;
    // C++ wrapper type for generalized_surface_select
    typedef SELECT generalized_surface_select;
    // C++ wrapper type for geometric_item_specific_usage_select
    typedef SELECT geometric_item_specific_usage_select;
    // C++ wrapper type for geometric_set_select
    typedef SELECT geometric_set_select;
    // C++ wrapper type for groupable_item
    typedef SELECT groupable_item;
    // C++ wrapper type for hour_in_day
    typedef INTEGER hour_in_day;
    // C++ wrapper type for id_attribute_select
    typedef SELECT id_attribute_select;
    // C++ wrapper type for identification_item
    typedef SELECT identification_item;
    // C++ wrapper type for identifier
    typedef STRING identifier;
    // C++ wrapper type for illuminance_measure
    typedef REAL illuminance_measure;
    // C++ wrapper type for inductance_measure
    typedef REAL inductance_measure;
    // C++ wrapper type for instance_usage_context_select
    typedef SELECT instance_usage_context_select;
    // C++ wrapper type for invisibility_context
    typedef SELECT invisibility_context;
    // C++ wrapper type for invisible_item
    typedef SELECT invisible_item;
    // C++ wrapper type for ir_usage_item
    typedef SELECT ir_usage_item;
    // C++ wrapper type for knot_type
    typedef ENUMERATION knot_type;
    // C++ wrapper type for label
    typedef STRING label;
    // C++ wrapper type for layered_item
    typedef SELECT layered_item;
    // C++ wrapper type for length_measure
    typedef REAL length_measure;
    // C++ wrapper type for limit_condition
    typedef ENUMERATION limit_condition;
    // C++ wrapper type for list_of_reversible_topology_item
    typedef ListOf< SELECT, 0, 0 > list_of_reversible_topology_item;
    // C++ wrapper type for luminous_flux_measure
    typedef REAL luminous_flux_measure;
    // C++ wrapper type for luminous_intensity_measure
    typedef REAL luminous_intensity_measure;
    // C++ wrapper type for magnetic_flux_density_measure
    typedef REAL magnetic_flux_density_measure;
    // C++ wrapper type for magnetic_flux_measure
    typedef REAL magnetic_flux_measure;
    // C++ wrapper type for marker_select
    typedef SELECT marker_select;
    // C++ wrapper type for marker_type
    typedef ENUMERATION marker_type;
    // C++ wrapper type for mass_measure
    typedef REAL mass_measure;
    // C++ wrapper type for measure_value
    typedef SELECT measure_value;
    // C++ wrapper type for mechanical_design_and_draughting_relationship_select
    typedef SELECT mechanical_design_and_draughting_relationship_select;
    // C++ wrapper type for mechanical_design_geometric_presentation_area_items
    typedef SELECT mechanical_design_geometric_presentation_area_items;
    // C++ wrapper type for mechanical_design_geometric_presentation_representation_items
    typedef SELECT mechanical_design_geometric_presentation_representation_items;
    // C++ wrapper type for message
    typedef STRING message;
    // C++ wrapper type for minute_in_hour
    typedef INTEGER minute_in_hour;
    // C++ wrapper type for month_in_year_number
    typedef INTEGER month_in_year_number;
    // C++ wrapper type for multi_language_attribute_item
    typedef SELECT multi_language_attribute_item;
    // C++ wrapper type for name_attribute_select
    typedef SELECT name_attribute_select;
    // C++ wrapper type for name_item
    typedef SELECT name_item;
    // C++ wrapper type for non_negative_length_measure
    typedef REAL non_negative_length_measure;
    // C++ wrapper type for nonnegative_integer
    typedef INTEGER nonnegative_integer;
    // C++ wrapper type for null_style
    typedef ENUMERATION null_style;
    // C++ wrapper type for numeric_measure
    typedef NUMBER numeric_measure;
    // C++ wrapper type for organization_item
    typedef SELECT organization_item;
    // C++ wrapper type for orientation_basis_select
    typedef SELECT orientation_basis_select;
    // C++ wrapper type for parameter_value
    typedef REAL parameter_value;
    // C++ wrapper type for pcurve_or_surface
    typedef SELECT pcurve_or_surface;
    // C++ wrapper type for person_and_organization_item
    typedef SELECT person_and_organization_item;
    // C++ wrapper type for person_organization_select
    typedef SELECT person_organization_select;
    // C++ wrapper type for picture_representation_item_select
    typedef SELECT picture_representation_item_select;
    // C++ wrapper type for plane_angle_measure
    typedef REAL plane_angle_measure;
    // C++ wrapper type for plane_or_planar_box
    typedef SELECT plane_or_planar_box;
    // C++ wrapper type for point_and_vector_member
    typedef SELECT point_and_vector_member;
    // C++ wrapper type for point_and_vector_members
    typedef ListOf< SELECT, 2, 3 > point_and_vector_members;
    // C++ wrapper type for positive_integer
    typedef INTEGER positive_integer;
    // C++ wrapper type for positive_length_measure
    typedef REAL positive_length_measure;
    // C++ wrapper type for positive_plane_angle_measure
    typedef REAL positive_plane_angle_measure;
    // C++ wrapper type for positive_ratio_measure
    typedef REAL positive_ratio_measure;
    // C++ wrapper type for power_measure
    typedef REAL power_measure;
    // C++ wrapper type for preferred_surface_curve_representation
    typedef ENUMERATION preferred_surface_curve_representation;
    // C++ wrapper type for presentable_text
    typedef STRING presentable_text;
    // C++ wrapper type for presentation_representation_select
    typedef SELECT presentation_representation_select;
    // C++ wrapper type for presentation_size_assignment_select
    typedef SELECT presentation_size_assignment_select;
    // C++ wrapper type for presentation_style_select
    typedef SELECT presentation_style_select;
    // C++ wrapper type for presented_item_select
    typedef SELECT presented_item_select;
    // C++ wrapper type for pressure_measure
    typedef REAL pressure_measure;
    // C++ wrapper type for product_definition_or_assembly_relationship
    typedef SELECT product_definition_or_assembly_relationship;
    // C++ wrapper type for product_definition_or_breakdown_element_usage
    typedef SELECT product_definition_or_breakdown_element_usage;
    // C++ wrapper type for product_definition_or_product_definition_relationship
    typedef SELECT product_definition_or_product_definition_relationship;
    // C++ wrapper type for product_or_formation_or_definition
    typedef SELECT product_or_formation_or_definition;
    // C++ wrapper type for project_item
    typedef SELECT project_item;
    // C++ wrapper type for radioactivity_measure
    typedef REAL radioactivity_measure;
    // C++ wrapper type for ratio_measure
    typedef REAL ratio_measure;
    // C++ wrapper type for rendering_properties_select
    typedef SELECT rendering_properties_select;
    // C++ wrapper type for represented_definition
    typedef SELECT represented_definition;
    // C++ wrapper type for requirement_assigned_item
    typedef SELECT requirement_assigned_item;
    // C++ wrapper type for requirement_satisfaction_item
    typedef SELECT requirement_satisfaction_item;
    // C++ wrapper type for requirement_source_item
    typedef SELECT requirement_source_item;
    // C++ wrapper type for resistance_measure
    typedef REAL resistance_measure;
    // C++ wrapper type for reversible_topology
    typedef SELECT reversible_topology;
    // C++ wrapper type for reversible_topology_item
    typedef SELECT reversible_topology_item;
    // C++ wrapper type for role_select
    typedef SELECT role_select;
    // C++ wrapper type for rule_superseded_item
    typedef SELECT rule_superseded_item;
    // C++ wrapper type for second_in_minute
    typedef REAL second_in_minute;
    // C++ wrapper type for security_classification_item
    typedef SELECT security_classification_item;
    // C++ wrapper type for set_of_reversible_topology_item
    typedef ListOf< SELECT, 0, 0 > set_of_reversible_topology_item;
    // C++ wrapper type for shading_curve_method
    typedef ENUMERATION shading_curve_method;
    // C++ wrapper type for shading_surface_method
    typedef ENUMERATION shading_surface_method;
    // C++ wrapper type for shape_definition
    typedef SELECT shape_definition;
    // C++ wrapper type for shell
    typedef SELECT shell;
    // C++ wrapper type for si_prefix
    typedef ENUMERATION si_prefix;
    // C++ wrapper type for si_unit_name
    typedef ENUMERATION si_unit_name;
    // C++ wrapper type for size_select
    typedef SELECT size_select;
    // C++ wrapper type for sketch_basis_select
    typedef SELECT sketch_basis_select;
    // C++ wrapper type for solid_angle_measure
    typedef REAL solid_angle_measure;
    // C++ wrapper type for source
    typedef ENUMERATION source;
    // C++ wrapper type for source_item
    typedef SELECT source_item;
    // C++ wrapper type for start_request_item
    typedef SELECT start_request_item;
    // C++ wrapper type for string_representation_item_select
    typedef SELECT string_representation_item_select;
    // C++ wrapper type for style_context_select
    typedef SELECT style_context_select;
    // C++ wrapper type for surface_side
    typedef ENUMERATION surface_side;
    // C++ wrapper type for surface_side_style_select
    typedef SELECT surface_side_style_select;
    // C++ wrapper type for surface_style_element_select
    typedef SELECT surface_style_element_select;
    // C++ wrapper type for symbol_style_select
    typedef SELECT symbol_style_select;
    // C++ wrapper type for text
    typedef STRING text;
    // C++ wrapper type for text_alignment
    typedef STRING text_alignment;
    // C++ wrapper type for text_delineation
    typedef STRING text_delineation;
    // C++ wrapper type for text_or_character
    typedef SELECT text_or_character;
    // C++ wrapper type for text_path
    typedef ENUMERATION text_path;
    // C++ wrapper type for text_string_representation_item
    typedef SELECT text_string_representation_item;
    // C++ wrapper type for thermodynamic_temperature_measure
    typedef REAL thermodynamic_temperature_measure;
    // C++ wrapper type for time_interval_item
    typedef SELECT time_interval_item;
    // C++ wrapper type for time_measure
    typedef REAL time_measure;
    // C++ wrapper type for tolerance_method_definition
    typedef SELECT tolerance_method_definition;
    // C++ wrapper type for transformation
    typedef SELECT transformation;
    // C++ wrapper type for transition_code
    typedef ENUMERATION transition_code;
    // C++ wrapper type for trim_condition_select
    typedef SELECT trim_condition_select;
    // C++ wrapper type for trim_intent
    typedef ENUMERATION trim_intent;
    // C++ wrapper type for trimming_preference
    typedef ENUMERATION trimming_preference;
    // C++ wrapper type for trimming_select
    typedef SELECT trimming_select;
    // C++ wrapper type for u_direction_count
    typedef INTEGER u_direction_count;
    // C++ wrapper type for unit
    typedef SELECT unit;
    // C++ wrapper type for v_direction_count
    typedef INTEGER v_direction_count;
    // C++ wrapper type for value_qualifier
    typedef SELECT value_qualifier;
    // C++ wrapper type for vector_or_direction
    typedef SELECT vector_or_direction;
    // C++ wrapper type for velocity_measure
    typedef REAL velocity_measure;
    // C++ wrapper type for volume_measure
    typedef REAL volume_measure;
    // C++ wrapper type for week_in_year_number
    typedef INTEGER week_in_year_number;
    // C++ wrapper type for work_item
    typedef SELECT work_item;
    // C++ wrapper type for year_number
    typedef INTEGER year_number;


	// ******************************************************************************
	// StepFile Entities
	// ******************************************************************************

	struct measure_with_unit;
	struct absorbed_dose_measure_with_unit;
	struct derived_unit;
	struct absorbed_dose_unit;
	struct abstract_variable;
	struct acceleration_measure_with_unit;
	struct acceleration_unit;
	struct action;
	struct action_assignment;
	typedef NotImplemented action_directive; // (not currently used by Assimp)
	struct action_method;
	struct action_method_assignment;
	struct action_method_relationship;
	typedef NotImplemented action_method_role; // (not currently used by Assimp)
	typedef NotImplemented action_property; // (not currently used by Assimp)
	typedef NotImplemented action_property_representation; // (not currently used by Assimp)
	typedef NotImplemented action_relationship; // (not currently used by Assimp)
	struct action_request_assignment;
	typedef NotImplemented action_request_solution; // (not currently used by Assimp)
	typedef NotImplemented action_request_status; // (not currently used by Assimp)
	typedef NotImplemented action_status; // (not currently used by Assimp)
	struct address;
	struct representation;
	struct shape_representation;
	struct advanced_brep_shape_representation;
	struct face_surface;
	struct advanced_face;
	typedef NotImplemented alternate_product_relationship; // (not currently used by Assimp)
	struct amount_of_substance_measure_with_unit;
	struct named_unit;
	struct amount_of_substance_unit;
	struct angle_direction_reference;
	struct representation_item;
	struct geometric_representation_item;
	struct draughting_callout;
	struct dimension_curve_directed_callout;
	struct angular_dimension;
	struct shape_aspect_relationship;
	struct dimensional_location;
	struct angular_location;
	struct dimensional_size;
	struct angular_size;
	struct geometric_tolerance;
	struct geometric_tolerance_with_datum_reference;
	struct angularity_tolerance;
	struct styled_item;
	struct annotation_occurrence;
	struct annotation_curve_occurrence;
	struct annotation_fill_area;
	struct annotation_fill_area_occurrence;
	struct annotation_occurrence_relationship;
	struct annotation_occurrence_associativity;
	struct annotation_plane;
	struct annotation_symbol_occurrence;
	struct annotation_subfigure_occurrence;
	struct mapped_item;
	struct annotation_symbol;
	struct annotation_text;
	struct annotation_text_character;
	struct annotation_text_occurrence;
	struct shape_aspect;
	struct derived_shape_aspect;
	struct apex;
	typedef NotImplemented application_context; // (not currently used by Assimp)
	struct application_context_element;
	typedef NotImplemented application_protocol_definition; // (not currently used by Assimp)
	struct applied_action_assignment;
	struct applied_action_method_assignment;
	struct applied_action_request_assignment;
	struct approval_assignment;
	struct applied_approval_assignment;
	struct attribute_classification_assignment;
	struct applied_attribute_classification_assignment;
	struct certification_assignment;
	struct applied_certification_assignment;
	struct classification_assignment;
	struct applied_classification_assignment;
	struct contract_assignment;
	struct applied_contract_assignment;
	struct date_and_time_assignment;
	struct applied_date_and_time_assignment;
	struct date_assignment;
	struct applied_date_assignment;
	struct document_reference;
	struct applied_document_reference;
	struct document_usage_constraint_assignment;
	struct applied_document_usage_constraint_assignment;
	struct effectivity_assignment;
	struct applied_effectivity_assignment;
	struct event_occurrence_assignment;
	struct applied_event_occurrence_assignment;
	struct identification_assignment;
	struct external_identification_assignment;
	struct applied_external_identification_assignment;
	struct group_assignment;
	struct applied_group_assignment;
	struct applied_identification_assignment;
	struct name_assignment;
	struct applied_name_assignment;
	struct organization_assignment;
	struct applied_organization_assignment;
	struct organizational_project_assignment;
	struct applied_organizational_project_assignment;
	struct person_and_organization_assignment;
	struct applied_person_and_organization_assignment;
	struct presented_item;
	struct applied_presented_item;
	struct security_classification_assignment;
	struct applied_security_classification_assignment;
	struct time_interval_assignment;
	struct applied_time_interval_assignment;
	struct applied_usage_right;
	typedef NotImplemented approval; // (not currently used by Assimp)
	typedef NotImplemented approval_date_time; // (not currently used by Assimp)
	typedef NotImplemented approval_person_organization; // (not currently used by Assimp)
	typedef NotImplemented approval_relationship; // (not currently used by Assimp)
	typedef NotImplemented approval_role; // (not currently used by Assimp)
	typedef NotImplemented approval_status; // (not currently used by Assimp)
	struct area_in_set;
	struct area_measure_with_unit;
	struct area_unit;
	struct product_definition_relationship;
	struct product_definition_usage;
	struct assembly_component_usage;
	typedef NotImplemented assembly_component_usage_substitute; // (not currently used by Assimp)
	struct assigned_requirement;
	struct compound_representation_item;
	struct atomic_formula;
	struct attribute_assertion;
	struct attribute_language_assignment;
	struct attribute_value_assignment;
	typedef NotImplemented attribute_value_role; // (not currently used by Assimp)
	struct auxiliary_geometric_representation_item;
	struct placement;
	struct axis1_placement;
	struct axis2_placement_2d;
	struct axis2_placement_3d;
	struct curve;
	struct bounded_curve;
	struct b_spline_curve;
	struct b_spline_curve_with_knots;
	struct surface;
	struct bounded_surface;
	struct b_spline_surface;
	struct b_spline_surface_with_knots;
	struct product_definition;
	struct rule_software_definition;
	struct rule_definition;
	struct back_chaining_rule;
	struct back_chaining_rule_body;
	struct colour;
	struct background_colour;
	struct beveled_sheet_representation;
	struct bezier_curve;
	struct bezier_surface;
	struct generic_expression;
	struct binary_generic_expression;
	struct binary_numeric_expression;
	struct binary_representation_item;
	struct block;
	struct expression;
	struct boolean_expression;
	struct boolean_literal;
	struct boolean_representation_item;
	struct boolean_result;
	struct composite_curve;
	struct composite_curve_on_surface;
	struct boundary_curve;
	struct bounded_pcurve;
	struct bounded_surface_curve;
	struct founded_item;
	struct box_domain;
	struct half_space_solid;
	struct boxed_half_space;
	struct breakdown_context;
	struct breakdown_element_group_assignment;
	struct breakdown_element_realization;
	struct breakdown_element_usage;
	struct breakdown_of;
	struct solid_model;
	struct manifold_solid_brep;
	struct brep_with_voids;
	struct bytes_representation_item;
	struct date;
	struct calendar_date;
	struct camera_image;
	struct camera_image_3d_with_scale;
	struct camera_model;
	struct camera_model_d3;
	struct camera_model_d3_multi_clipping;
	struct camera_model_d3_multi_clipping_intersection;
	struct camera_model_d3_multi_clipping_union;
	struct camera_model_d3_with_hlhsr;
	struct camera_model_with_light_sources;
	struct representation_map;
	struct camera_usage;
	struct capacitance_measure_with_unit;
	struct capacitance_unit;
	struct point;
	struct cartesian_point;
	struct cartesian_transformation_operator;
	struct cartesian_transformation_operator_2d;
	struct cartesian_transformation_operator_3d;
	struct cc_design_approval;
	struct cc_design_certification;
	struct cc_design_contract;
	struct cc_design_date_and_time_assignment;
	struct cc_design_person_and_organization_assignment;
	struct cc_design_security_classification;
	struct cc_design_specification_reference;
	struct celsius_temperature_measure_with_unit;
	struct centre_of_symmetry;
	typedef NotImplemented certification; // (not currently used by Assimp)
	typedef NotImplemented certification_type; // (not currently used by Assimp)
	struct change;
	struct change_request;
	typedef NotImplemented character_glyph_font_usage; // (not currently used by Assimp)
	struct character_glyph_style_outline;
	struct character_glyph_style_stroke;
	struct symbol_representation;
	struct generic_character_glyph_symbol;
	struct character_glyph_symbol;
	struct character_glyph_symbol_outline;
	struct character_glyph_symbol_stroke;
	struct general_property;
	struct characteristic_data_column_header;
	struct general_property_relationship;
	struct characteristic_data_column_header_link;
	struct characteristic_data_table_header;
	struct characteristic_data_table_header_decomposition;
	struct group;
	struct characteristic_type;
	struct characterized_class;
	struct characterized_object;
	struct conic;
	struct circle;
	struct circular_runout_tolerance;
	typedef NotImplemented class_t; // (not currently used by Assimp)
	struct class_by_extension;
	struct class_by_intension;
	struct class_system;
	struct effectivity_context_assignment;
	struct class_usage_effectivity_context_assignment;
	typedef NotImplemented classification_role; // (not currently used by Assimp)
	struct topological_representation_item;
	struct connected_face_set;
	struct closed_shell;
	struct coaxiality_tolerance;
	struct colour_specification;
	struct colour_rgb;
	struct common_datum;
	struct comparison_expression;
	struct complex_clause;
	struct complex_conjunctive_clause;
	struct complex_disjunctive_clause;
	struct modified_solid;
	struct shelled_solid;
	struct complex_shelled_solid;
	struct composite_assembly_definition;
	struct composite_assembly_sequence_definition;
	struct laminate_table;
	struct part_laminate_table;
	struct composite_assembly_table;
	struct composite_curve_segment;
	struct material_designation;
	struct composite_material_designation;
	struct composite_shape_aspect;
	struct composite_sheet_representation;
	struct composite_text;
	struct composite_text_with_associated_curves;
	struct composite_text_with_blanking_box;
	struct composite_text_with_delineation;
	struct composite_text_with_extent;
	struct compound_shape_representation;
	struct concentricity_tolerance;
	typedef NotImplemented concept_feature_operator; // (not currently used by Assimp)
	struct concept_feature_relationship;
	struct concept_feature_relationship_with_condition;
	struct product_concept_feature;
	struct conditional_concept_feature;
	struct conductance_measure_with_unit;
	struct conductance_unit;
	struct configuration_item;
	struct configurable_item;
	typedef NotImplemented configuration_design; // (not currently used by Assimp)
	struct effectivity;
	struct product_definition_effectivity;
	struct configuration_effectivity;
	struct configuration_item_relationship;
	struct configuration_item_hierarchical_relationship;
	struct configuration_item_revision_sequence;
	struct configured_effectivity_assignment;
	struct configured_effectivity_context_assignment;
	struct conical_stepped_hole_transition;
	struct elementary_surface;
	struct conical_surface;
	struct connected_edge_set;
	struct connected_face_sub_set;
	struct constructive_geometry_representation;
	struct representation_relationship;
	struct constructive_geometry_representation_relationship;
	struct contact_ratio_representation;
	struct invisibility;
	struct context_dependent_invisibility;
	struct over_riding_styled_item;
	struct context_dependent_over_riding_styled_item;
	typedef NotImplemented context_dependent_shape_representation; // (not currently used by Assimp)
	struct context_dependent_unit;
	typedef NotImplemented contract; // (not currently used by Assimp)
	typedef NotImplemented contract_relationship; // (not currently used by Assimp)
	typedef NotImplemented contract_type; // (not currently used by Assimp)
	struct conversion_based_unit;
	typedef NotImplemented coordinated_universal_time_offset; // (not currently used by Assimp)
	struct csg_shape_representation;
	struct csg_solid;
	struct currency;
	struct currency_measure_with_unit;
	struct curve_bounded_surface;
	struct curve_dimension;
	struct curve_replica;
	struct curve_style;
	struct curve_style_font;
	struct curve_style_font_and_scaling;
	struct curve_style_font_pattern;
	typedef NotImplemented curve_style_rendering; // (not currently used by Assimp)
	struct curve_swept_solid_shape_representation;
	struct cylindrical_surface;
	struct cylindricity_tolerance;
	typedef NotImplemented data_environment; // (not currently used by Assimp)
	typedef NotImplemented date_and_time; // (not currently used by Assimp)
	struct date_representation_item;
	typedef NotImplemented date_role; // (not currently used by Assimp)
	struct date_time_representation_item;
	typedef NotImplemented date_time_role; // (not currently used by Assimp)
	struct dated_effectivity;
	struct datum;
	struct datum_feature;
	struct datum_feature_callout;
	struct datum_reference;
	struct datum_target;
	struct datum_target_callout;
	struct default_tolerance_table;
	struct default_tolerance_table_cell;
	struct defined_symbol;
	struct definitional_representation;
	struct definitional_representation_relationship;
	struct definitional_representation_relationship_with_same_context;
	struct degenerate_pcurve;
	struct toroidal_surface;
	struct degenerate_toroidal_surface;
	typedef NotImplemented derived_unit_element; // (not currently used by Assimp)
	typedef NotImplemented description_attribute; // (not currently used by Assimp)
	struct descriptive_representation_item;
	struct product_definition_context;
	struct design_context;
	struct design_make_from_relationship;
	struct diameter_dimension;
	struct ratio_measure_with_unit;
	struct dielectric_constant_measure_with_unit;
	struct dimension_callout;
	struct draughting_callout_relationship;
	struct dimension_callout_component_relationship;
	struct dimension_callout_relationship;
	struct dimension_curve;
	struct terminator_symbol;
	struct dimension_curve_terminator;
	struct dimension_curve_terminator_to_projection_curve_associativity;
	struct dimension_pair;
	typedef NotImplemented dimension_related_tolerance_zone_element; // (not currently used by Assimp)
	struct dimension_text_associativity;
	typedef NotImplemented dimensional_characteristic_representation; // (not currently used by Assimp)
	typedef NotImplemented dimensional_exponents; // (not currently used by Assimp)
	struct dimensional_location_with_path;
	struct dimensional_size_with_path;
	struct executed_action;
	struct directed_action;
	struct directed_dimensional_location;
	struct direction;
	typedef NotImplemented document; // (not currently used by Assimp)
	struct document_file;
	struct document_identifier;
	struct document_identifier_assignment;
	struct document_product_association;
	struct document_product_equivalence;
	typedef NotImplemented document_relationship; // (not currently used by Assimp)
	typedef NotImplemented document_representation_type; // (not currently used by Assimp)
	typedef NotImplemented document_type; // (not currently used by Assimp)
	typedef NotImplemented document_usage_constraint; // (not currently used by Assimp)
	typedef NotImplemented document_usage_role; // (not currently used by Assimp)
	struct dose_equivalent_measure_with_unit;
	struct dose_equivalent_unit;
	struct double_offset_shelled_solid;
	struct item_defined_transformation;
	struct transformation_with_derived_angle;
	struct draped_defined_transformation;
	struct draughting_annotation_occurrence;
	struct draughting_elements;
	struct draughting_model;
	struct item_identified_representation_usage;
	struct draughting_model_item_association;
	struct pre_defined_colour;
	struct draughting_pre_defined_colour;
	struct pre_defined_item;
	struct pre_defined_curve_font;
	struct draughting_pre_defined_curve_font;
	struct pre_defined_text_font;
	struct draughting_pre_defined_text_font;
	struct draughting_subfigure_representation;
	struct draughting_symbol_representation;
	struct text_literal;
	struct text_literal_with_delineation;
	struct draughting_text_literal_with_delineation;
	typedef NotImplemented draughting_title; // (not currently used by Assimp)
	typedef NotImplemented drawing_definition; // (not currently used by Assimp)
	struct presentation_set;
	struct drawing_revision;
	typedef NotImplemented drawing_revision_sequence; // (not currently used by Assimp)
	struct presentation_representation;
	struct presentation_area;
	struct drawing_sheet_revision;
	struct drawing_sheet_revision_sequence;
	struct drawing_sheet_revision_usage;
	struct edge;
	struct edge_based_wireframe_model;
	struct edge_based_wireframe_shape_representation;
	struct edge_blended_solid;
	struct edge_curve;
	struct edge_loop;
	typedef NotImplemented effectivity_context_role; // (not currently used by Assimp)
	typedef NotImplemented effectivity_relationship; // (not currently used by Assimp)
	struct electric_charge_measure_with_unit;
	struct electric_charge_unit;
	struct electric_current_measure_with_unit;
	struct electric_current_unit;
	struct electric_potential_measure_with_unit;
	struct electric_potential_unit;
	struct elementary_brep_shape_representation;
	struct ellipse;
	struct energy_measure_with_unit;
	struct energy_unit;
	struct property_definition;
	struct fact_type;
	struct entity_assertion;
	struct enum_reference_prefix;
	typedef NotImplemented environment; // (not currently used by Assimp)
	struct evaluated_characteristic;
	struct evaluated_degenerate_pcurve;
	struct evaluation_product_definition;
	struct event_occurrence;
	typedef NotImplemented event_occurrence_relationship; // (not currently used by Assimp)
	typedef NotImplemented event_occurrence_role; // (not currently used by Assimp)
	struct product_concept_feature_category;
	struct exclusive_product_concept_feature_category;
	struct uncertainty_qualifier;
	struct standard_uncertainty;
	struct expanded_uncertainty;
	struct representation_item_relationship;
	struct explicit_procedural_representation_item_relationship;
	struct explicit_procedural_geometric_representation_item_relationship;
	struct explicit_procedural_representation_relationship;
	struct explicit_procedural_shape_representation_relationship;
	struct expression_conversion_based_unit;
	struct extension;
	struct extent;
	struct external_source;
	struct external_class_library;
	typedef NotImplemented external_source_relationship; // (not currently used by Assimp)
	struct externally_defined_class;
	struct externally_defined_colour;
	struct externally_defined_context_dependent_unit;
	struct externally_defined_conversion_based_unit;
	struct externally_defined_currency;
	struct externally_defined_item;
	struct externally_defined_curve_font;
	struct externally_defined_dimension_definition;
	struct externally_defined_general_property;
	struct externally_defined_hatch_style;
	typedef NotImplemented externally_defined_item_relationship; // (not currently used by Assimp)
	struct externally_defined_marker;
	struct picture_representation_item;
	struct externally_defined_picture_representation_item;
	struct externally_defined_representation_item;
	struct externally_defined_string;
	struct externally_defined_symbol;
	struct externally_defined_terminator_symbol;
	struct externally_defined_text_font;
	struct externally_defined_tile;
	struct externally_defined_tile_style;
	struct swept_area_solid;
	struct extruded_area_solid;
	struct swept_face_solid;
	struct extruded_face_solid;
	struct extruded_face_solid_with_trim_conditions;
	struct extruded_face_solid_with_draft_angle;
	struct extruded_face_solid_with_multiple_draft_angles;
	struct face;
	struct face_based_surface_model;
	struct face_bound;
	struct face_outer_bound;
	struct faceted_brep;
	struct faceted_brep_shape_representation;
	struct fill_area_style;
	typedef NotImplemented fill_area_style_colour; // (not currently used by Assimp)
	struct fill_area_style_hatching;
	struct fill_area_style_tile_coloured_region;
	struct fill_area_style_tile_curve_with_style;
	struct fill_area_style_tile_symbol_with_style;
	struct fill_area_style_tiles;
	struct shape_representation_relationship;
	struct flat_pattern_ply_representation_relationship;
	struct flatness_tolerance;
	struct force_measure_with_unit;
	struct force_unit;
	struct forward_chaining_rule;
	struct forward_chaining_rule_premise;
	struct frequency_measure_with_unit;
	struct frequency_unit;
	struct func;
	struct functional_breakdown_context;
	struct functional_element_usage;
	typedef NotImplemented functionally_defined_transformation; // (not currently used by Assimp)
	struct general_material_property;
	typedef NotImplemented general_property_association; // (not currently used by Assimp)
	struct simple_generic_expression;
	struct generic_literal;
	struct generic_variable;
	struct geometric_alignment;
	struct geometric_set;
	struct geometric_curve_set;
	struct geometric_intersection;
	struct geometric_item_specific_usage;
	struct geometric_model_element_relationship;
	struct representation_context;
	struct geometric_representation_context;
	typedef NotImplemented geometric_tolerance_relationship; // (not currently used by Assimp)
	struct geometric_tolerance_with_defined_unit;
	struct geometrical_tolerance_callout;
	struct geometrically_bounded_2d_wireframe_representation;
	struct geometrically_bounded_surface_shape_representation;
	struct geometrically_bounded_wireframe_shape_representation;
	struct global_assignment;
	struct global_uncertainty_assigned_context;
	struct global_unit_assigned_context;
	struct ground_fact;
	typedef NotImplemented group_relationship; // (not currently used by Assimp)
	struct hardness_representation;
	struct hidden_element_over_riding_styled_item;
	struct hyperbola;
	typedef NotImplemented id_attribute; // (not currently used by Assimp)
	typedef NotImplemented identification_role; // (not currently used by Assimp)
	struct illuminance_measure_with_unit;
	struct illuminance_unit;
	struct included_text_block;
	struct inclusion_product_concept_feature;
	struct user_selected_elements;
	struct indirectly_selected_elements;
	struct indirectly_selected_shape_elements;
	struct inductance_measure_with_unit;
	struct inductance_unit;
	struct information_right;
	struct information_usage_right;
	struct instance_usage_context_assignment;
	struct instanced_feature;
	struct literal_number;
	struct int_literal;
	struct integer_representation_item;
	struct surface_curve;
	struct intersection_curve;
	struct interval_expression;
	struct iso4217_currency;
	struct known_source;
	struct laid_defined_transformation;
	struct language;
	struct leader_curve;
	struct leader_directed_callout;
	struct leader_directed_dimension;
	struct leader_terminator;
	struct length_measure_with_unit;
	struct length_unit;
	struct light_source;
	struct light_source_ambient;
	struct light_source_directional;
	struct light_source_positional;
	struct light_source_spot;
	typedef NotImplemented limits_and_fits; // (not currently used by Assimp)
	struct line;
	struct line_profile_tolerance;
	struct linear_dimension;
	struct simple_clause;
	struct literal_conjunction;
	struct literal_disjunction;
	typedef NotImplemented local_time; // (not currently used by Assimp)
	struct logical_literal;
	struct logical_representation_item;
	struct loop;
	struct loss_tangent_measure_with_unit;
	struct lot_effectivity;
	struct luminous_flux_measure_with_unit;
	struct luminous_flux_unit;
	struct luminous_intensity_measure_with_unit;
	struct luminous_intensity_unit;
	struct magnetic_flux_density_measure_with_unit;
	struct magnetic_flux_density_unit;
	struct magnetic_flux_measure_with_unit;
	struct magnetic_flux_unit;
	struct make_from_usage_option;
	struct manifold_subsurface_shape_representation;
	struct manifold_surface_shape_representation;
	struct mass_measure_with_unit;
	struct mass_unit;
	typedef NotImplemented material_designation_characterization; // (not currently used by Assimp)
	struct material_property;
	struct property_definition_representation;
	struct material_property_representation;
	typedef NotImplemented measure_qualification; // (not currently used by Assimp)
	struct measure_representation_item;
	struct product_context;
	struct mechanical_context;
	struct mechanical_design_and_draughting_relationship;
	struct mechanical_design_geometric_presentation_area;
	struct mechanical_design_geometric_presentation_representation;
	struct mechanical_design_presentation_representation_with_draughting;
	struct mechanical_design_shaded_presentation_area;
	struct mechanical_design_shaded_presentation_representation;
	struct min_and_major_ply_orientation_basis;
	struct modified_geometric_tolerance;
	struct modified_solid_with_placed_configuration;
	struct moments_of_inertia_representation;
	struct multi_language_attribute_assignment;
	struct multiple_arity_boolean_expression;
	struct multiple_arity_generic_expression;
	struct multiple_arity_numeric_expression;
	typedef NotImplemented name_attribute; // (not currently used by Assimp)
	struct next_assembly_usage_occurrence;
	struct non_manifold_surface_shape_representation;
	struct null_representation_item;
	struct numeric_expression;
	typedef NotImplemented object_role; // (not currently used by Assimp)
	struct offset_curve_2d;
	struct offset_curve_3d;
	struct offset_surface;
	struct one_direction_repeat_factor;
	struct open_shell;
	struct ordinal_date;
	struct projection_directed_callout;
	struct ordinate_dimension;
	typedef NotImplemented organization; // (not currently used by Assimp)
	typedef NotImplemented organization_relationship; // (not currently used by Assimp)
	typedef NotImplemented organization_role; // (not currently used by Assimp)
	struct organizational_address;
	typedef NotImplemented organizational_project; // (not currently used by Assimp)
	typedef NotImplemented organizational_project_relationship; // (not currently used by Assimp)
	typedef NotImplemented organizational_project_role; // (not currently used by Assimp)
	struct oriented_closed_shell;
	struct oriented_edge;
	struct oriented_face;
	struct oriented_open_shell;
	struct path;
	struct oriented_path;
	struct oriented_surface;
	struct outer_boundary_curve;
	struct package_product_concept_feature;
	struct parabola;
	struct parallel_offset;
	struct parallelism_tolerance;
	struct parametric_representation_context;
	struct partial_document_with_structured_text_representation_assignment;
	struct pcurve;
	struct percentage_laminate_definition;
	struct zone_structural_makeup;
	struct percentage_laminate_table;
	struct percentage_ply_definition;
	struct perpendicular_to;
	struct perpendicularity_tolerance;
	typedef NotImplemented person; // (not currently used by Assimp)
	typedef NotImplemented person_and_organization; // (not currently used by Assimp)
	struct person_and_organization_address;
	typedef NotImplemented person_and_organization_role; // (not currently used by Assimp)
	struct personal_address;
	struct physical_breakdown_context;
	struct physical_element_usage;
	struct presentation_view;
	struct picture_representation;
	struct placed_datum_target_feature;
	struct placed_feature;
	struct planar_extent;
	struct planar_box;
	struct plane;
	struct plane_angle_measure_with_unit;
	struct plane_angle_unit;
	typedef NotImplemented plus_minus_tolerance; // (not currently used by Assimp)
	struct ply_laminate_definition;
	struct ply_laminate_sequence_definition;
	struct ply_laminate_table;
	struct point_and_vector;
	struct point_on_curve;
	struct point_on_surface;
	struct point_path;
	struct point_replica;
	struct point_style;
	struct polar_complex_number_literal;
	struct poly_loop;
	struct polyline;
	struct position_tolerance;
	struct positioned_sketch;
	struct power_measure_with_unit;
	struct power_unit;
	struct pre_defined_symbol;
	struct pre_defined_dimension_symbol;
	struct pre_defined_geometrical_tolerance_symbol;
	struct pre_defined_marker;
	struct pre_defined_point_marker_symbol;
	struct pre_defined_surface_condition_symbol;
	struct pre_defined_surface_side_style;
	struct pre_defined_terminator_symbol;
	struct pre_defined_tile;
	typedef NotImplemented precision_qualifier; // (not currently used by Assimp)
	struct predefined_picture_representation_item;
	typedef NotImplemented presentation_layer_assignment; // (not currently used by Assimp)
	typedef NotImplemented presentation_size; // (not currently used by Assimp)
	struct presentation_style_assignment;
	struct presentation_style_by_context;
	typedef NotImplemented presented_item_representation; // (not currently used by Assimp)
	struct pressure_measure_with_unit;
	struct pressure_unit;
	struct procedural_representation;
	struct procedural_representation_sequence;
	struct procedural_shape_representation;
	struct procedural_shape_representation_sequence;
	typedef NotImplemented product; // (not currently used by Assimp)
	struct product_category;
	struct product_class;
	typedef NotImplemented product_concept; // (not currently used by Assimp)
	struct product_concept_context;
	typedef NotImplemented product_concept_feature_association; // (not currently used by Assimp)
	struct product_concept_feature_category_usage;
	typedef NotImplemented product_concept_relationship; // (not currently used by Assimp)
	typedef NotImplemented product_definition_context_association; // (not currently used by Assimp)
	typedef NotImplemented product_definition_context_role; // (not currently used by Assimp)
	struct product_definition_element_relationship;
	struct product_definition_formation;
	typedef NotImplemented product_definition_formation_relationship; // (not currently used by Assimp)
	struct product_definition_formation_with_specified_source;
	struct product_definition_group_assignment;
	typedef NotImplemented product_definition_occurrence_relationship; // (not currently used by Assimp)
	struct product_definition_shape;
	typedef NotImplemented product_definition_substitute; // (not currently used by Assimp)
	struct product_definition_with_associated_documents;
	struct product_identification;
	struct product_material_composition_relationship;
	struct product_related_product_category;
	struct product_specification;
	struct tolerance_zone_definition;
	struct projected_zone_definition;
	struct projection_curve;
	struct promissory_usage_occurrence;
	typedef NotImplemented property_definition_relationship; // (not currently used by Assimp)
	struct qualified_representation_item;
	struct qualitative_uncertainty;
	struct quantified_assembly_component_usage;
	struct quasi_uniform_curve;
	struct quasi_uniform_surface;
	struct radioactivity_measure_with_unit;
	struct radioactivity_unit;
	struct radius_dimension;
	struct range_characteristic;
	struct ratio_unit;
	struct rational_b_spline_curve;
	struct rational_b_spline_surface;
	struct rational_representation_item;
	struct real_literal;
	struct real_representation_item;
	struct rectangular_composite_surface;
	struct rectangular_trimmed_surface;
	struct referenced_modified_datum;
	struct relative_event_occurrence;
	struct rep_item_group;
	struct reparametrised_composite_curve_segment;
	struct representation_relationship_with_transformation;
	struct requirement_assigned_object;
	struct requirement_assignment;
	struct requirement_source;
	struct requirement_view_definition_relationship;
	struct resistance_measure_with_unit;
	struct resistance_unit;
	struct revolved_area_solid;
	struct revolved_face_solid;
	struct revolved_face_solid_with_trim_conditions;
	struct right_angular_wedge;
	struct right_circular_cone;
	struct right_circular_cylinder;
	struct right_to_usage_association;
	typedef NotImplemented role_association; // (not currently used by Assimp)
	struct roundness_tolerance;
	struct row_representation_item;
	struct row_value;
	struct row_variable;
	struct rule_action;
	struct rule_condition;
	struct rule_set;
	struct rule_set_group;
	struct rule_superseded_assignment;
	struct rule_supersedence;
	struct surface_curve_swept_area_solid;
	struct ruled_surface_swept_area_solid;
	struct runout_zone_definition;
	struct runout_zone_orientation;
	struct runout_zone_orientation_reference_direction;
	struct satisfied_requirement;
	struct satisfies_requirement;
	struct satisfying_item;
	struct scalar_variable;
	struct scattering_parameter;
	struct sculptured_solid;
	struct seam_curve;
	typedef NotImplemented security_classification; // (not currently used by Assimp)
	typedef NotImplemented security_classification_level; // (not currently used by Assimp)
	struct serial_numbered_effectivity;
	struct shape_aspect_associativity;
	struct shape_aspect_deriving_relationship;
	struct shape_definition_representation;
	struct shape_dimension_representation;
	struct shape_feature_definition;
	struct shape_representation_with_parameters;
	struct shell_based_surface_model;
	struct shell_based_wireframe_model;
	struct shell_based_wireframe_shape_representation;
	struct si_absorbed_dose_unit;
	struct si_capacitance_unit;
	struct si_conductance_unit;
	struct si_dose_equivalent_unit;
	struct si_electric_charge_unit;
	struct si_electric_potential_unit;
	struct si_energy_unit;
	struct si_force_unit;
	struct si_frequency_unit;
	struct si_illuminance_unit;
	struct si_inductance_unit;
	struct si_magnetic_flux_density_unit;
	struct si_magnetic_flux_unit;
	struct si_power_unit;
	struct si_pressure_unit;
	struct si_radioactivity_unit;
	struct si_resistance_unit;
	struct si_unit;
	struct simple_boolean_expression;
	struct simple_numeric_expression;
	struct slash_expression;
	struct smeared_material_definition;
	struct solid_angle_measure_with_unit;
	struct solid_angle_unit;
	struct solid_curve_font;
	struct solid_replica;
	struct solid_with_chamfered_edges;
	struct solid_with_angle_based_chamfer;
	struct solid_with_shape_element_pattern;
	struct solid_with_circular_pattern;
	struct solid_with_depression;
	struct solid_with_pocket;
	struct solid_with_circular_pocket;
	struct solid_with_protrusion;
	struct solid_with_circular_protrusion;
	struct solid_with_hole;
	struct solid_with_stepped_round_hole;
	struct solid_with_conical_bottom_round_hole;
	struct solid_with_constant_radius_edge_blend;
	struct solid_with_slot;
	struct solid_with_curved_slot;
	struct solid_with_double_offset_chamfer;
	struct solid_with_flat_bottom_round_hole;
	struct solid_with_general_pocket;
	struct solid_with_general_protrusion;
	struct solid_with_groove;
	struct solid_with_incomplete_circular_pattern;
	struct solid_with_rectangular_pattern;
	struct solid_with_incomplete_rectangular_pattern;
	struct solid_with_rectangular_pocket;
	struct solid_with_rectangular_protrusion;
	struct solid_with_single_offset_chamfer;
	struct solid_with_spherical_bottom_round_hole;
	struct solid_with_stepped_round_hole_and_conical_transitions;
	struct solid_with_straight_slot;
	struct solid_with_tee_section_slot;
	struct solid_with_through_depression;
	struct solid_with_trapezoidal_section_slot;
	struct solid_with_variable_radius_edge_blend;
	struct source_for_requirement;
	struct sourced_requirement;
	struct specification_definition;
	struct specified_higher_usage_occurrence;
	struct sphere;
	struct spherical_surface;
	struct start_request;
	struct start_work;
	struct straightness_tolerance;
	struct structured_dimension_callout;
	struct structured_text_composition;
	struct structured_text_representation;
	struct subedge;
	struct subface;
	struct supplied_part_relationship;
	struct surface_condition_callout;
	struct swept_surface;
	struct surface_of_linear_extrusion;
	struct surface_of_revolution;
	struct surface_patch;
	struct surface_profile_tolerance;
	typedef NotImplemented surface_rendering_properties; // (not currently used by Assimp)
	struct surface_replica;
	struct surface_side_style;
	struct surface_style_boundary;
	struct surface_style_control_grid;
	struct surface_style_fill_area;
	struct surface_style_parameter_line;
	struct surface_style_reflectance_ambient;
	struct surface_style_reflectance_ambient_diffuse;
	struct surface_style_reflectance_ambient_diffuse_specular;
	struct surface_style_rendering;
	struct surface_style_rendering_with_properties;
	struct surface_style_segmentation_curve;
	struct surface_style_silhouette;
	typedef NotImplemented surface_style_transparent; // (not currently used by Assimp)
	struct surface_style_usage;
	struct surface_texture_representation;
	struct surfaced_open_shell;
	struct swept_disk_solid;
	struct symbol;
	typedef NotImplemented symbol_colour; // (not currently used by Assimp)
	struct symbol_representation_map;
	struct symbol_style;
	struct symbol_target;
	struct symmetric_shape_aspect;
	struct symmetry_tolerance;
	struct table_representation_item;
	struct tactile_appearance_representation;
	struct tagged_text_format;
	struct tagged_text_item;
	struct tangent;
	typedef NotImplemented text_font; // (not currently used by Assimp)
	typedef NotImplemented text_font_family; // (not currently used by Assimp)
	typedef NotImplemented text_font_in_family; // (not currently used by Assimp)
	struct text_literal_with_associated_curves;
	struct text_literal_with_blanking_box;
	struct text_literal_with_extent;
	struct text_string_representation;
	struct text_style;
	typedef NotImplemented text_style_for_defined_font; // (not currently used by Assimp)
	struct text_style_with_box_characteristics;
	struct text_style_with_mirror;
	struct text_style_with_spacing;
	struct thermal_resistance_measure_with_unit;
	struct thermal_resistance_unit;
	struct thermodynamic_temperature_measure_with_unit;
	struct thermodynamic_temperature_unit;
	struct thickened_face_solid;
	struct thickness_laminate_definition;
	struct thickness_laminate_table;
	struct time_interval;
	struct time_interval_based_effectivity;
	typedef NotImplemented time_interval_relationship; // (not currently used by Assimp)
	typedef NotImplemented time_interval_role; // (not currently used by Assimp)
	struct time_interval_with_bounds;
	struct time_measure_with_unit;
	struct time_unit;
	typedef NotImplemented tolerance_value; // (not currently used by Assimp)
	struct tolerance_zone;
	typedef NotImplemented tolerance_zone_form; // (not currently used by Assimp)
	struct torus;
	struct total_runout_tolerance;
	struct track_blended_solid;
	struct track_blended_solid_with_end_conditions;
	struct trimmed_curve;
	struct two_direction_repeat_factor;
	typedef NotImplemented type_qualifier; // (not currently used by Assimp)
	struct unary_generic_expression;
	struct unary_numeric_expression;
	struct uncertainty_assigned_representation;
	struct uncertainty_measure_with_unit;
	struct uniform_curve;
	struct uniform_resource_identifier;
	struct uniform_surface;
	struct usage_association;
	struct user_defined_curve_font;
	struct user_defined_marker;
	struct user_defined_terminator_symbol;
	struct user_selected_shape_elements;
	struct value_range;
	struct value_representation_item;
	struct variable_semantics;
	struct variational_representation_item;
	struct vector;
	struct vector_style;
	struct velocity_measure_with_unit;
	struct velocity_unit;
	typedef NotImplemented versioned_action_request; // (not currently used by Assimp)
	struct vertex;
	struct vertex_loop;
	struct vertex_point;
	struct vertex_shell;
	struct view_volume;
	struct visual_appearance_representation;
	struct volume_measure_with_unit;
	struct volume_unit;
	struct week_of_year_and_day_date;
	struct wire_shell;
	struct year_month;



    // C++ wrapper for measure_with_unit
    struct measure_with_unit :  ObjectHelper<measure_with_unit,2> { measure_with_unit() : Object("measure_with_unit") {}
		measure_value::Out value_component;
		unit::Out unit_component;
    };

    // C++ wrapper for absorbed_dose_measure_with_unit
    struct absorbed_dose_measure_with_unit : measure_with_unit, ObjectHelper<absorbed_dose_measure_with_unit,0> { absorbed_dose_measure_with_unit() : Object("absorbed_dose_measure_with_unit") {}

    };

    // C++ wrapper for derived_unit
    struct derived_unit :  ObjectHelper<derived_unit,1> { derived_unit() : Object("derived_unit") {}
		ListOf< Lazy< NotImplemented >, 1, 0 > elements;
    };

    // C++ wrapper for absorbed_dose_unit
    struct absorbed_dose_unit : derived_unit, ObjectHelper<absorbed_dose_unit,0> { absorbed_dose_unit() : Object("absorbed_dose_unit") {}

    };

    // C++ wrapper for abstract_variable
    struct abstract_variable :  ObjectHelper<abstract_variable,0> { abstract_variable() : Object("abstract_variable") {}

    };

    // C++ wrapper for acceleration_measure_with_unit
    struct acceleration_measure_with_unit : measure_with_unit, ObjectHelper<acceleration_measure_with_unit,0> { acceleration_measure_with_unit() : Object("acceleration_measure_with_unit") {}

    };

    // C++ wrapper for acceleration_unit
    struct acceleration_unit : derived_unit, ObjectHelper<acceleration_unit,0> { acceleration_unit() : Object("acceleration_unit") {}

    };

    // C++ wrapper for action
    struct action :  ObjectHelper<action,3> { action() : Object("action") {}
		label::Out name;
		Maybe< text::Out > description;
		Lazy< action_method > chosen_method;
    };

    // C++ wrapper for action_assignment
    struct action_assignment :  ObjectHelper<action_assignment,1> { action_assignment() : Object("action_assignment") {}
		Lazy< action > assigned_action;
    };

    // C++ wrapper for action_method
    struct action_method :  ObjectHelper<action_method,4> { action_method() : Object("action_method") {}
		label::Out name;
		Maybe< text::Out > description;
		text::Out consequence;
		text::Out purpose;
    };

    // C++ wrapper for action_method_assignment
    struct action_method_assignment :  ObjectHelper<action_method_assignment,2> { action_method_assignment() : Object("action_method_assignment") {}
		Lazy< action_method > assigned_action_method;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for action_method_relationship
    struct action_method_relationship :  ObjectHelper<action_method_relationship,4> { action_method_relationship() : Object("action_method_relationship") {}
		label::Out name;
		Maybe< text::Out > description;
		Lazy< action_method > relating_method;
		Lazy< action_method > related_method;
    };

    // C++ wrapper for action_request_assignment
    struct action_request_assignment :  ObjectHelper<action_request_assignment,1> { action_request_assignment() : Object("action_request_assignment") {}
		Lazy< NotImplemented > assigned_action_request;
    };

    // C++ wrapper for address
    struct address :  ObjectHelper<address,12> { address() : Object("address") {}
		Maybe< label::Out > internal_location;
		Maybe< label::Out > street_number;
		Maybe< label::Out > street;
		Maybe< label::Out > postal_box;
		Maybe< label::Out > town;
		Maybe< label::Out > region;
		Maybe< label::Out > postal_code;
		Maybe< label::Out > country;
		Maybe< label::Out > facsimile_number;
		Maybe< label::Out > telephone_number;
		Maybe< label::Out > electronic_mail_address;
		Maybe< label::Out > telex_number;
    };

    // C++ wrapper for representation
    struct representation :  ObjectHelper<representation,3> { representation() : Object("representation") {}
		label::Out name;
		ListOf< Lazy< representation_item >, 1, 0 > items;
		Lazy< representation_context > context_of_items;
    };

    // C++ wrapper for shape_representation
    struct shape_representation : representation, ObjectHelper<shape_representation,0> { shape_representation() : Object("shape_representation") {}

    };

    // C++ wrapper for advanced_brep_shape_representation
    struct advanced_brep_shape_representation : shape_representation, ObjectHelper<advanced_brep_shape_representation,0> { advanced_brep_shape_representation() : Object("advanced_brep_shape_representation") {}

    };

    // C++ wrapper for face_surface
    struct face_surface :  ObjectHelper<face_surface,2> { face_surface() : Object("face_surface") {}
		Lazy< surface > face_geometry;
		BOOLEAN::Out same_sense;
    };

    // C++ wrapper for advanced_face
    struct advanced_face : face_surface, ObjectHelper<advanced_face,0> { advanced_face() : Object("advanced_face") {}

    };

    // C++ wrapper for amount_of_substance_measure_with_unit
    struct amount_of_substance_measure_with_unit : measure_with_unit, ObjectHelper<amount_of_substance_measure_with_unit,0> { amount_of_substance_measure_with_unit() : Object("amount_of_substance_measure_with_unit") {}

    };

    // C++ wrapper for named_unit
    struct named_unit :  ObjectHelper<named_unit,1> { named_unit() : Object("named_unit") {}
		Lazy< NotImplemented > dimensions;
    };

    // C++ wrapper for amount_of_substance_unit
    struct amount_of_substance_unit : named_unit, ObjectHelper<amount_of_substance_unit,0> { amount_of_substance_unit() : Object("amount_of_substance_unit") {}

    };

    // C++ wrapper for angle_direction_reference
    struct angle_direction_reference :  ObjectHelper<angle_direction_reference,0> { angle_direction_reference() : Object("angle_direction_reference") {}

    };

    // C++ wrapper for representation_item
    struct representation_item :  ObjectHelper<representation_item,1> { representation_item() : Object("representation_item") {}
		label::Out name;
    };

    // C++ wrapper for geometric_representation_item
    struct geometric_representation_item : representation_item, ObjectHelper<geometric_representation_item,0> { geometric_representation_item() : Object("geometric_representation_item") {}

    };

    // C++ wrapper for draughting_callout
    struct draughting_callout : geometric_representation_item, ObjectHelper<draughting_callout,1> { draughting_callout() : Object("draughting_callout") {}
		ListOf< draughting_callout_element, 1, 0 >::Out contents;
    };

    // C++ wrapper for dimension_curve_directed_callout
    struct dimension_curve_directed_callout : draughting_callout, ObjectHelper<dimension_curve_directed_callout,0> { dimension_curve_directed_callout() : Object("dimension_curve_directed_callout") {}

    };

    // C++ wrapper for angular_dimension
    struct angular_dimension : dimension_curve_directed_callout, ObjectHelper<angular_dimension,0> { angular_dimension() : Object("angular_dimension") {}

    };

    // C++ wrapper for shape_aspect_relationship
    struct shape_aspect_relationship :  ObjectHelper<shape_aspect_relationship,4> { shape_aspect_relationship() : Object("shape_aspect_relationship") {}
		label::Out name;
		Maybe< text::Out > description;
		Lazy< shape_aspect > relating_shape_aspect;
		Lazy< shape_aspect > related_shape_aspect;
    };

    // C++ wrapper for dimensional_location
    struct dimensional_location : shape_aspect_relationship, ObjectHelper<dimensional_location,0> { dimensional_location() : Object("dimensional_location") {}

    };

    // C++ wrapper for angular_location
    struct angular_location : dimensional_location, ObjectHelper<angular_location,1> { angular_location() : Object("angular_location") {}
		angle_relator::Out angle_selection;
    };

    // C++ wrapper for dimensional_size
    struct dimensional_size :  ObjectHelper<dimensional_size,2> { dimensional_size() : Object("dimensional_size") {}
		Lazy< shape_aspect > applies_to;
		label::Out name;
    };

    // C++ wrapper for angular_size
    struct angular_size : dimensional_size, ObjectHelper<angular_size,1> { angular_size() : Object("angular_size") {}
		angle_relator::Out angle_selection;
    };

    // C++ wrapper for geometric_tolerance
    struct geometric_tolerance :  ObjectHelper<geometric_tolerance,4> { geometric_tolerance() : Object("geometric_tolerance") {}
		label::Out name;
		text::Out description;
		Lazy< measure_with_unit > magnitude;
		Lazy< shape_aspect > toleranced_shape_aspect;
    };

    // C++ wrapper for geometric_tolerance_with_datum_reference
    struct geometric_tolerance_with_datum_reference : geometric_tolerance, ObjectHelper<geometric_tolerance_with_datum_reference,1> { geometric_tolerance_with_datum_reference() : Object("geometric_tolerance_with_datum_reference") {}
		ListOf< Lazy< datum_reference >, 1, 0 > datum_system;
    };

    // C++ wrapper for angularity_tolerance
    struct angularity_tolerance : geometric_tolerance_with_datum_reference, ObjectHelper<angularity_tolerance,0> { angularity_tolerance() : Object("angularity_tolerance") {}

    };

    // C++ wrapper for styled_item
    struct styled_item : representation_item, ObjectHelper<styled_item,2> { styled_item() : Object("styled_item") {}
		ListOf< Lazy< presentation_style_assignment >, 1, 0 > styles;
		Lazy< representation_item > item;
    };

    // C++ wrapper for annotation_occurrence
    struct annotation_occurrence : styled_item, ObjectHelper<annotation_occurrence,0> { annotation_occurrence() : Object("annotation_occurrence") {}

    };

    // C++ wrapper for annotation_curve_occurrence
    struct annotation_curve_occurrence : annotation_occurrence, ObjectHelper<annotation_curve_occurrence,0> { annotation_curve_occurrence() : Object("annotation_curve_occurrence") {}

    };

    // C++ wrapper for annotation_fill_area
    struct annotation_fill_area : geometric_representation_item, ObjectHelper<annotation_fill_area,1> { annotation_fill_area() : Object("annotation_fill_area") {}
		ListOf< Lazy< curve >, 1, 0 > boundaries;
    };

    // C++ wrapper for annotation_fill_area_occurrence
    struct annotation_fill_area_occurrence : annotation_occurrence, ObjectHelper<annotation_fill_area_occurrence,1> { annotation_fill_area_occurrence() : Object("annotation_fill_area_occurrence") {}
		Lazy< point > fill_style_target;
    };

    // C++ wrapper for annotation_occurrence_relationship
    struct annotation_occurrence_relationship :  ObjectHelper<annotation_occurrence_relationship,4> { annotation_occurrence_relationship() : Object("annotation_occurrence_relationship") {}
		label::Out name;
		text::Out description;
		Lazy< annotation_occurrence > relating_annotation_occurrence;
		Lazy< annotation_occurrence > related_annotation_occurrence;
    };

    // C++ wrapper for annotation_occurrence_associativity
    struct annotation_occurrence_associativity : annotation_occurrence_relationship, ObjectHelper<annotation_occurrence_associativity,0> { annotation_occurrence_associativity() : Object("annotation_occurrence_associativity") {}

    };

    // C++ wrapper for annotation_plane
    struct annotation_plane :  ObjectHelper<annotation_plane,1> { annotation_plane() : Object("annotation_plane") {}
		Maybe< ListOf< annotation_plane_element, 1, 0 >::Out > elements;
    };

    // C++ wrapper for annotation_symbol_occurrence
    struct annotation_symbol_occurrence : annotation_occurrence, ObjectHelper<annotation_symbol_occurrence,0> { annotation_symbol_occurrence() : Object("annotation_symbol_occurrence") {}

    };

    // C++ wrapper for annotation_subfigure_occurrence
    struct annotation_subfigure_occurrence : annotation_symbol_occurrence, ObjectHelper<annotation_subfigure_occurrence,0> { annotation_subfigure_occurrence() : Object("annotation_subfigure_occurrence") {}

    };

    // C++ wrapper for mapped_item
    struct mapped_item : representation_item, ObjectHelper<mapped_item,2> { mapped_item() : Object("mapped_item") {}
		Lazy< representation_map > mapping_source;
		Lazy< representation_item > mapping_target;
    };

    // C++ wrapper for annotation_symbol
    struct annotation_symbol : mapped_item, ObjectHelper<annotation_symbol,0> { annotation_symbol() : Object("annotation_symbol") {}

    };

    // C++ wrapper for annotation_text
    struct annotation_text : mapped_item, ObjectHelper<annotation_text,0> { annotation_text() : Object("annotation_text") {}

    };

    // C++ wrapper for annotation_text_character
    struct annotation_text_character : mapped_item, ObjectHelper<annotation_text_character,1> { annotation_text_character() : Object("annotation_text_character") {}
		text_alignment::Out alignment;
    };

    // C++ wrapper for annotation_text_occurrence
    struct annotation_text_occurrence : annotation_occurrence, ObjectHelper<annotation_text_occurrence,0> { annotation_text_occurrence() : Object("annotation_text_occurrence") {}

    };

    // C++ wrapper for shape_aspect
    struct shape_aspect :  ObjectHelper<shape_aspect,4> { shape_aspect() : Object("shape_aspect") {}
		label::Out name;
		Maybe< text::Out > description;
		Lazy< product_definition_shape > of_shape;
		LOGICAL::Out product_definitional;
    };

    // C++ wrapper for derived_shape_aspect
    struct derived_shape_aspect : shape_aspect, ObjectHelper<derived_shape_aspect,0> { derived_shape_aspect() : Object("derived_shape_aspect") {}

    };

    // C++ wrapper for apex
    struct apex : derived_shape_aspect, ObjectHelper<apex,0> { apex() : Object("apex") {}

    };

    // C++ wrapper for application_context_element
    struct application_context_element :  ObjectHelper<application_context_element,2> { application_context_element() : Object("application_context_element") {}
		label::Out name;
		Lazy< NotImplemented > frame_of_reference;
    };

    // C++ wrapper for applied_action_assignment
    struct applied_action_assignment : action_assignment, ObjectHelper<applied_action_assignment,1> { applied_action_assignment() : Object("applied_action_assignment") {}
		ListOf< action_items, 1, 0 >::Out items;
    };

    // C++ wrapper for applied_action_method_assignment
    struct applied_action_method_assignment : action_method_assignment, ObjectHelper<applied_action_method_assignment,1> { applied_action_method_assignment() : Object("applied_action_method_assignment") {}
		ListOf< action_method_items, 1, 0 >::Out items;
    };

    // C++ wrapper for applied_action_request_assignment
    struct applied_action_request_assignment : action_request_assignment, ObjectHelper<applied_action_request_assignment,1> { applied_action_request_assignment() : Object("applied_action_request_assignment") {}
		ListOf< action_request_item, 1, 0 >::Out items;
    };

    // C++ wrapper for approval_assignment
    struct approval_assignment :  ObjectHelper<approval_assignment,1> { approval_assignment() : Object("approval_assignment") {}
		Lazy< NotImplemented > assigned_approval;
    };

    // C++ wrapper for applied_approval_assignment
    struct applied_approval_assignment : approval_assignment, ObjectHelper<applied_approval_assignment,1> { applied_approval_assignment() : Object("applied_approval_assignment") {}
		ListOf< approval_item, 1, 0 >::Out items;
    };

    // C++ wrapper for attribute_classification_assignment
    struct attribute_classification_assignment :  ObjectHelper<attribute_classification_assignment,3> { attribute_classification_assignment() : Object("attribute_classification_assignment") {}
		Lazy< group > assigned_class;
		label::Out attribute_name;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for applied_attribute_classification_assignment
    struct applied_attribute_classification_assignment : attribute_classification_assignment, ObjectHelper<applied_attribute_classification_assignment,1> { applied_attribute_classification_assignment() : Object("applied_attribute_classification_assignment") {}
		ListOf< attribute_classification_item, 1, 0 >::Out items;
    };

    // C++ wrapper for certification_assignment
    struct certification_assignment :  ObjectHelper<certification_assignment,1> { certification_assignment() : Object("certification_assignment") {}
		Lazy< NotImplemented > assigned_certification;
    };

    // C++ wrapper for applied_certification_assignment
    struct applied_certification_assignment : certification_assignment, ObjectHelper<applied_certification_assignment,1> { applied_certification_assignment() : Object("applied_certification_assignment") {}
		ListOf< certification_item, 1, 0 >::Out items;
    };

    // C++ wrapper for classification_assignment
    struct classification_assignment :  ObjectHelper<classification_assignment,2> { classification_assignment() : Object("classification_assignment") {}
		Lazy< group > assigned_class;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for applied_classification_assignment
    struct applied_classification_assignment : classification_assignment, ObjectHelper<applied_classification_assignment,1> { applied_classification_assignment() : Object("applied_classification_assignment") {}
		ListOf< classification_item, 1, 0 >::Out items;
    };

    // C++ wrapper for contract_assignment
    struct contract_assignment :  ObjectHelper<contract_assignment,1> { contract_assignment() : Object("contract_assignment") {}
		Lazy< NotImplemented > assigned_contract;
    };

    // C++ wrapper for applied_contract_assignment
    struct applied_contract_assignment : contract_assignment, ObjectHelper<applied_contract_assignment,1> { applied_contract_assignment() : Object("applied_contract_assignment") {}
		ListOf< contract_item, 1, 0 >::Out items;
    };

    // C++ wrapper for date_and_time_assignment
    struct date_and_time_assignment :  ObjectHelper<date_and_time_assignment,2> { date_and_time_assignment() : Object("date_and_time_assignment") {}
		Lazy< NotImplemented > assigned_date_and_time;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for applied_date_and_time_assignment
    struct applied_date_and_time_assignment : date_and_time_assignment, ObjectHelper<applied_date_and_time_assignment,1> { applied_date_and_time_assignment() : Object("applied_date_and_time_assignment") {}
		ListOf< date_and_time_item, 1, 0 >::Out items;
    };

    // C++ wrapper for date_assignment
    struct date_assignment :  ObjectHelper<date_assignment,2> { date_assignment() : Object("date_assignment") {}
		Lazy< date > assigned_date;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for applied_date_assignment
    struct applied_date_assignment : date_assignment, ObjectHelper<applied_date_assignment,1> { applied_date_assignment() : Object("applied_date_assignment") {}
		ListOf< date_item, 1, 0 >::Out items;
    };

    // C++ wrapper for document_reference
    struct document_reference :  ObjectHelper<document_reference,2> { document_reference() : Object("document_reference") {}
		Lazy< NotImplemented > assigned_document;
		label::Out source;
    };

    // C++ wrapper for applied_document_reference
    struct applied_document_reference : document_reference, ObjectHelper<applied_document_reference,1> { applied_document_reference() : Object("applied_document_reference") {}
		ListOf< document_reference_item, 1, 0 >::Out items;
    };

    // C++ wrapper for document_usage_constraint_assignment
    struct document_usage_constraint_assignment :  ObjectHelper<document_usage_constraint_assignment,2> { document_usage_constraint_assignment() : Object("document_usage_constraint_assignment") {}
		Lazy< NotImplemented > assigned_document_usage;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for applied_document_usage_constraint_assignment
    struct applied_document_usage_constraint_assignment : document_usage_constraint_assignment, ObjectHelper<applied_document_usage_constraint_assignment,1> { applied_document_usage_constraint_assignment() : Object("applied_document_usage_constraint_assignment") {}
		ListOf< document_reference_item, 1, 0 >::Out items;
    };

    // C++ wrapper for effectivity_assignment
    struct effectivity_assignment :  ObjectHelper<effectivity_assignment,1> { effectivity_assignment() : Object("effectivity_assignment") {}
		Lazy< effectivity > assigned_effectivity;
    };

    // C++ wrapper for applied_effectivity_assignment
    struct applied_effectivity_assignment : effectivity_assignment, ObjectHelper<applied_effectivity_assignment,1> { applied_effectivity_assignment() : Object("applied_effectivity_assignment") {}
		ListOf< effectivity_item, 1, 0 >::Out items;
    };

    // C++ wrapper for event_occurrence_assignment
    struct event_occurrence_assignment :  ObjectHelper<event_occurrence_assignment,2> { event_occurrence_assignment() : Object("event_occurrence_assignment") {}
		Lazy< event_occurrence > assigned_event_occurrence;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for applied_event_occurrence_assignment
    struct applied_event_occurrence_assignment : event_occurrence_assignment, ObjectHelper<applied_event_occurrence_assignment,1> { applied_event_occurrence_assignment() : Object("applied_event_occurrence_assignment") {}
		ListOf< event_occurrence_item, 1, 0 >::Out items;
    };

    // C++ wrapper for identification_assignment
    struct identification_assignment :  ObjectHelper<identification_assignment,2> { identification_assignment() : Object("identification_assignment") {}
		identifier::Out assigned_id;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for external_identification_assignment
    struct external_identification_assignment : identification_assignment, ObjectHelper<external_identification_assignment,1> { external_identification_assignment() : Object("external_identification_assignment") {}
		Lazy< external_source > source;
    };

    // C++ wrapper for applied_external_identification_assignment
    struct applied_external_identification_assignment : external_identification_assignment, ObjectHelper<applied_external_identification_assignment,1> { applied_external_identification_assignment() : Object("applied_external_identification_assignment") {}
		ListOf< external_identification_item, 1, 0 >::Out items;
    };

    // C++ wrapper for group_assignment
    struct group_assignment :  ObjectHelper<group_assignment,1> { group_assignment() : Object("group_assignment") {}
		Lazy< group > assigned_group;
    };

    // C++ wrapper for applied_group_assignment
    struct applied_group_assignment : group_assignment, ObjectHelper<applied_group_assignment,1> { applied_group_assignment() : Object("applied_group_assignment") {}
		ListOf< groupable_item, 1, 0 >::Out items;
    };

    // C++ wrapper for applied_identification_assignment
    struct applied_identification_assignment : identification_assignment, ObjectHelper<applied_identification_assignment,1> { applied_identification_assignment() : Object("applied_identification_assignment") {}
		ListOf< identification_item, 1, 0 >::Out items;
    };

    // C++ wrapper for name_assignment
    struct name_assignment :  ObjectHelper<name_assignment,1> { name_assignment() : Object("name_assignment") {}
		label::Out assigned_name;
    };

    // C++ wrapper for applied_name_assignment
    struct applied_name_assignment : name_assignment, ObjectHelper<applied_name_assignment,1> { applied_name_assignment() : Object("applied_name_assignment") {}
		name_item::Out item;
    };

    // C++ wrapper for organization_assignment
    struct organization_assignment :  ObjectHelper<organization_assignment,2> { organization_assignment() : Object("organization_assignment") {}
		Lazy< NotImplemented > assigned_organization;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for applied_organization_assignment
    struct applied_organization_assignment : organization_assignment, ObjectHelper<applied_organization_assignment,1> { applied_organization_assignment() : Object("applied_organization_assignment") {}
		ListOf< organization_item, 1, 0 >::Out items;
    };

    // C++ wrapper for organizational_project_assignment
    struct organizational_project_assignment :  ObjectHelper<organizational_project_assignment,2> { organizational_project_assignment() : Object("organizational_project_assignment") {}
		Lazy< NotImplemented > assigned_organizational_project;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for applied_organizational_project_assignment
    struct applied_organizational_project_assignment : organizational_project_assignment, ObjectHelper<applied_organizational_project_assignment,1> { applied_organizational_project_assignment() : Object("applied_organizational_project_assignment") {}
		ListOf< project_item, 1, 0 >::Out items;
    };

    // C++ wrapper for person_and_organization_assignment
    struct person_and_organization_assignment :  ObjectHelper<person_and_organization_assignment,2> { person_and_organization_assignment() : Object("person_and_organization_assignment") {}
		Lazy< NotImplemented > assigned_person_and_organization;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for applied_person_and_organization_assignment
    struct applied_person_and_organization_assignment : person_and_organization_assignment, ObjectHelper<applied_person_and_organization_assignment,1> { applied_person_and_organization_assignment() : Object("applied_person_and_organization_assignment") {}
		ListOf< person_and_organization_item, 1, 0 >::Out items;
    };

    // C++ wrapper for presented_item
    struct presented_item :  ObjectHelper<presented_item,0> { presented_item() : Object("presented_item") {}

    };

    // C++ wrapper for applied_presented_item
    struct applied_presented_item : presented_item, ObjectHelper<applied_presented_item,1> { applied_presented_item() : Object("applied_presented_item") {}
		ListOf< presented_item_select, 1, 0 >::Out items;
    };

    // C++ wrapper for security_classification_assignment
    struct security_classification_assignment :  ObjectHelper<security_classification_assignment,1> { security_classification_assignment() : Object("security_classification_assignment") {}
		Lazy< NotImplemented > assigned_security_classification;
    };

    // C++ wrapper for applied_security_classification_assignment
    struct applied_security_classification_assignment : security_classification_assignment, ObjectHelper<applied_security_classification_assignment,1> { applied_security_classification_assignment() : Object("applied_security_classification_assignment") {}
		ListOf< security_classification_item, 1, 0 >::Out items;
    };

    // C++ wrapper for time_interval_assignment
    struct time_interval_assignment :  ObjectHelper<time_interval_assignment,2> { time_interval_assignment() : Object("time_interval_assignment") {}
		Lazy< time_interval > assigned_time_interval;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for applied_time_interval_assignment
    struct applied_time_interval_assignment : time_interval_assignment, ObjectHelper<applied_time_interval_assignment,1> { applied_time_interval_assignment() : Object("applied_time_interval_assignment") {}
		ListOf< time_interval_item, 0, 0 >::Out items;
    };

    // C++ wrapper for applied_usage_right
    struct applied_usage_right : applied_action_assignment, ObjectHelper<applied_usage_right,0> { applied_usage_right() : Object("applied_usage_right") {}

    };

    // C++ wrapper for area_in_set
    struct area_in_set :  ObjectHelper<area_in_set,2> { area_in_set() : Object("area_in_set") {}
		Lazy< presentation_area > area;
		Lazy< presentation_set > in_set;
    };

    // C++ wrapper for area_measure_with_unit
    struct area_measure_with_unit : measure_with_unit, ObjectHelper<area_measure_with_unit,0> { area_measure_with_unit() : Object("area_measure_with_unit") {}

    };

    // C++ wrapper for area_unit
    struct area_unit : derived_unit, ObjectHelper<area_unit,0> { area_unit() : Object("area_unit") {}

    };

    // C++ wrapper for product_definition_relationship
    struct product_definition_relationship :  ObjectHelper<product_definition_relationship,5> { product_definition_relationship() : Object("product_definition_relationship") {}
		identifier::Out id;
		label::Out name;
		Maybe< text::Out > description;
		Lazy< product_definition > relating_product_definition;
		Lazy< product_definition > related_product_definition;
    };

    // C++ wrapper for product_definition_usage
    struct product_definition_usage : product_definition_relationship, ObjectHelper<product_definition_usage,0> { product_definition_usage() : Object("product_definition_usage") {}

    };

    // C++ wrapper for assembly_component_usage
    struct assembly_component_usage : product_definition_usage, ObjectHelper<assembly_component_usage,1> { assembly_component_usage() : Object("assembly_component_usage") {}
		Maybe< identifier::Out > reference_designator;
    };

    // C++ wrapper for assigned_requirement
    struct assigned_requirement : group_assignment, ObjectHelper<assigned_requirement,1> { assigned_requirement() : Object("assigned_requirement") {}
		ListOf< Lazy< product_definition >, 1, 1 > items;
    };

    // C++ wrapper for compound_representation_item
    struct compound_representation_item : representation_item, ObjectHelper<compound_representation_item,1> { compound_representation_item() : Object("compound_representation_item") {}
		compound_item_definition::Out item_element;
    };

    // C++ wrapper for atomic_formula
    struct atomic_formula : compound_representation_item, ObjectHelper<atomic_formula,0> { atomic_formula() : Object("atomic_formula") {}

    };

    // C++ wrapper for attribute_assertion
    struct attribute_assertion :  ObjectHelper<attribute_assertion,0> { attribute_assertion() : Object("attribute_assertion") {}

    };

    // C++ wrapper for attribute_language_assignment
    struct attribute_language_assignment : attribute_classification_assignment, ObjectHelper<attribute_language_assignment,1> { attribute_language_assignment() : Object("attribute_language_assignment") {}
		ListOf< attribute_language_item, 1, 0 >::Out items;
    };

    // C++ wrapper for attribute_value_assignment
    struct attribute_value_assignment :  ObjectHelper<attribute_value_assignment,3> { attribute_value_assignment() : Object("attribute_value_assignment") {}
		label::Out attribute_name;
		attribute_type::Out attribute_value;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for auxiliary_geometric_representation_item
    struct auxiliary_geometric_representation_item :  ObjectHelper<auxiliary_geometric_representation_item,0> { auxiliary_geometric_representation_item() : Object("auxiliary_geometric_representation_item") {}

    };

    // C++ wrapper for placement
    struct placement : geometric_representation_item, ObjectHelper<placement,1> { placement() : Object("placement") {}
		Lazy< cartesian_point > location;
    };

    // C++ wrapper for axis1_placement
    struct axis1_placement : placement, ObjectHelper<axis1_placement,1> { axis1_placement() : Object("axis1_placement") {}
		Maybe< Lazy< direction > > axis;
    };

    // C++ wrapper for axis2_placement_2d
    struct axis2_placement_2d : placement, ObjectHelper<axis2_placement_2d,1> { axis2_placement_2d() : Object("axis2_placement_2d") {}
		Maybe< Lazy< direction > > ref_direction;
    };

    // C++ wrapper for axis2_placement_3d
    struct axis2_placement_3d : placement, ObjectHelper<axis2_placement_3d,2> { axis2_placement_3d() : Object("axis2_placement_3d") {}
		Maybe< Lazy< direction > > axis;
		Maybe< Lazy< direction > > ref_direction;
    };

    // C++ wrapper for curve
    struct curve : geometric_representation_item, ObjectHelper<curve,0> { curve() : Object("curve") {}

    };

    // C++ wrapper for bounded_curve
    struct bounded_curve : curve, ObjectHelper<bounded_curve,0> { bounded_curve() : Object("bounded_curve") {}

    };

    // C++ wrapper for b_spline_curve
    struct b_spline_curve : bounded_curve, ObjectHelper<b_spline_curve,5> { b_spline_curve() : Object("b_spline_curve") {}
		INTEGER::Out degree;
		ListOf< Lazy< cartesian_point >, 2, 0 > control_points_list;
		b_spline_curve_form::Out curve_form;
		LOGICAL::Out closed_curve;
		LOGICAL::Out self_intersect;
    };

    // C++ wrapper for b_spline_curve_with_knots
    struct b_spline_curve_with_knots : b_spline_curve, ObjectHelper<b_spline_curve_with_knots,3> { b_spline_curve_with_knots() : Object("b_spline_curve_with_knots") {}
		ListOf< INTEGER, 2, 0 >::Out knot_multiplicities;
		ListOf< parameter_value, 2, 0 >::Out knots;
		knot_type::Out knot_spec;
    };

    // C++ wrapper for surface
    struct surface : geometric_representation_item, ObjectHelper<surface,0> { surface() : Object("surface") {}

    };

    // C++ wrapper for bounded_surface
    struct bounded_surface : surface, ObjectHelper<bounded_surface,0> { bounded_surface() : Object("bounded_surface") {}

    };

    // C++ wrapper for b_spline_surface
    struct b_spline_surface : bounded_surface, ObjectHelper<b_spline_surface,6> { b_spline_surface() : Object("b_spline_surface") {}
		INTEGER::Out u_degree;
		INTEGER::Out v_degree;
		b_spline_surface_form::Out surface_form;
		LOGICAL::Out u_closed;
		LOGICAL::Out v_closed;
		LOGICAL::Out self_intersect;
    };

    // C++ wrapper for b_spline_surface_with_knots
    struct b_spline_surface_with_knots : b_spline_surface, ObjectHelper<b_spline_surface_with_knots,5> { b_spline_surface_with_knots() : Object("b_spline_surface_with_knots") {}
		ListOf< INTEGER, 2, 0 >::Out u_multiplicities;
		ListOf< INTEGER, 2, 0 >::Out v_multiplicities;
		ListOf< parameter_value, 2, 0 >::Out u_knots;
		ListOf< parameter_value, 2, 0 >::Out v_knots;
		knot_type::Out knot_spec;
    };

    // C++ wrapper for product_definition
    struct product_definition :  ObjectHelper<product_definition,4> { product_definition() : Object("product_definition") {}
		identifier::Out id;
		Maybe< text::Out > description;
		Lazy< product_definition_formation > formation;
		Lazy< product_definition_context > frame_of_reference;
    };

    // C++ wrapper for rule_software_definition
    struct rule_software_definition : product_definition, ObjectHelper<rule_software_definition,0> { rule_software_definition() : Object("rule_software_definition") {}

    };

    // C++ wrapper for rule_definition
    struct rule_definition : rule_software_definition, ObjectHelper<rule_definition,0> { rule_definition() : Object("rule_definition") {}

    };

    // C++ wrapper for back_chaining_rule
    struct back_chaining_rule : rule_definition, ObjectHelper<back_chaining_rule,0> { back_chaining_rule() : Object("back_chaining_rule") {}

    };

    // C++ wrapper for back_chaining_rule_body
    struct back_chaining_rule_body :  ObjectHelper<back_chaining_rule_body,0> { back_chaining_rule_body() : Object("back_chaining_rule_body") {}

    };

    // C++ wrapper for colour
    struct colour :  ObjectHelper<colour,0> { colour() : Object("colour") {}

    };

    // C++ wrapper for background_colour
    struct background_colour : colour, ObjectHelper<background_colour,1> { background_colour() : Object("background_colour") {}
		area_or_view::Out presentation;
    };

    // C++ wrapper for beveled_sheet_representation
    struct beveled_sheet_representation : shape_representation, ObjectHelper<beveled_sheet_representation,0> { beveled_sheet_representation() : Object("beveled_sheet_representation") {}

    };

    // C++ wrapper for bezier_curve
    struct bezier_curve : b_spline_curve, ObjectHelper<bezier_curve,0> { bezier_curve() : Object("bezier_curve") {}

    };

    // C++ wrapper for bezier_surface
    struct bezier_surface : b_spline_surface, ObjectHelper<bezier_surface,0> { bezier_surface() : Object("bezier_surface") {}

    };

    // C++ wrapper for generic_expression
    struct generic_expression :  ObjectHelper<generic_expression,0> { generic_expression() : Object("generic_expression") {}

    };

    // C++ wrapper for binary_generic_expression
    struct binary_generic_expression : generic_expression, ObjectHelper<binary_generic_expression,1> { binary_generic_expression() : Object("binary_generic_expression") {}
		ListOf< Lazy< generic_expression >, 2, 2 > operands;
    };

    // C++ wrapper for binary_numeric_expression
    struct binary_numeric_expression :  ObjectHelper<binary_numeric_expression,0> { binary_numeric_expression() : Object("binary_numeric_expression") {}

    };

    // C++ wrapper for binary_representation_item
    struct binary_representation_item : representation_item, ObjectHelper<binary_representation_item,1> { binary_representation_item() : Object("binary_representation_item") {}
		BINARY::Out binary_value;
    };

    // C++ wrapper for block
    struct block : geometric_representation_item, ObjectHelper<block,4> { block() : Object("block") {}
		Lazy< axis2_placement_3d > position;
		positive_length_measure::Out x;
		positive_length_measure::Out y;
		positive_length_measure::Out z;
    };

    // C++ wrapper for expression
    struct expression : generic_expression, ObjectHelper<expression,0> { expression() : Object("expression") {}

    };

    // C++ wrapper for boolean_expression
    struct boolean_expression : expression, ObjectHelper<boolean_expression,0> { boolean_expression() : Object("boolean_expression") {}

    };

    // C++ wrapper for boolean_literal
    struct boolean_literal :  ObjectHelper<boolean_literal,1> { boolean_literal() : Object("boolean_literal") {}
		BOOLEAN::Out the_value;
    };

    // C++ wrapper for boolean_representation_item
    struct boolean_representation_item :  ObjectHelper<boolean_representation_item,0> { boolean_representation_item() : Object("boolean_representation_item") {}

    };

    // C++ wrapper for boolean_result
    struct boolean_result : geometric_representation_item, ObjectHelper<boolean_result,3> { boolean_result() : Object("boolean_result") {}
		boolean_operator::Out operator_;
		boolean_operand::Out first_operand;
		boolean_operand::Out second_operand;
    };

    // C++ wrapper for composite_curve
    struct composite_curve : bounded_curve, ObjectHelper<composite_curve,2> { composite_curve() : Object("composite_curve") {}
		ListOf< Lazy< composite_curve_segment >, 1, 0 > segments;
		LOGICAL::Out self_intersect;
    };

    // C++ wrapper for composite_curve_on_surface
    struct composite_curve_on_surface : composite_curve, ObjectHelper<composite_curve_on_surface,0> { composite_curve_on_surface() : Object("composite_curve_on_surface") {}

    };

    // C++ wrapper for boundary_curve
    struct boundary_curve : composite_curve_on_surface, ObjectHelper<boundary_curve,0> { boundary_curve() : Object("boundary_curve") {}

    };

    // C++ wrapper for bounded_pcurve
    struct bounded_pcurve :  ObjectHelper<bounded_pcurve,0> { bounded_pcurve() : Object("bounded_pcurve") {}

    };

    // C++ wrapper for bounded_surface_curve
    struct bounded_surface_curve :  ObjectHelper<bounded_surface_curve,0> { bounded_surface_curve() : Object("bounded_surface_curve") {}

    };

    // C++ wrapper for founded_item
    struct founded_item :  ObjectHelper<founded_item,0> { founded_item() : Object("founded_item") {}

    };

    // C++ wrapper for box_domain
    struct box_domain : founded_item, ObjectHelper<box_domain,4> { box_domain() : Object("box_domain") {}
		Lazy< cartesian_point > corner;
		positive_length_measure::Out xlength;
		positive_length_measure::Out ylength;
		positive_length_measure::Out zlength;
    };

    // C++ wrapper for half_space_solid
    struct half_space_solid : geometric_representation_item, ObjectHelper<half_space_solid,2> { half_space_solid() : Object("half_space_solid") {}
		Lazy< surface > base_surface;
		BOOLEAN::Out agreement_flag;
    };

    // C++ wrapper for boxed_half_space
    struct boxed_half_space : half_space_solid, ObjectHelper<boxed_half_space,1> { boxed_half_space() : Object("boxed_half_space") {}
		Lazy< box_domain > enclosure;
    };

    // C++ wrapper for breakdown_context
    struct breakdown_context : product_definition_relationship, ObjectHelper<breakdown_context,0> { breakdown_context() : Object("breakdown_context") {}

    };

    // C++ wrapper for breakdown_element_group_assignment
    struct breakdown_element_group_assignment : group_assignment, ObjectHelper<breakdown_element_group_assignment,1> { breakdown_element_group_assignment() : Object("breakdown_element_group_assignment") {}
		ListOf< product_definition_or_breakdown_element_usage, 1, 1 >::Out items;
    };

    // C++ wrapper for breakdown_element_realization
    struct breakdown_element_realization :  ObjectHelper<breakdown_element_realization,0> { breakdown_element_realization() : Object("breakdown_element_realization") {}

    };

    // C++ wrapper for breakdown_element_usage
    struct breakdown_element_usage : product_definition_relationship, ObjectHelper<breakdown_element_usage,0> { breakdown_element_usage() : Object("breakdown_element_usage") {}

    };

    // C++ wrapper for breakdown_of
    struct breakdown_of : product_definition_relationship, ObjectHelper<breakdown_of,0> { breakdown_of() : Object("breakdown_of") {}

    };

    // C++ wrapper for solid_model
    struct solid_model : geometric_representation_item, ObjectHelper<solid_model,0> { solid_model() : Object("solid_model") {}

    };

    // C++ wrapper for manifold_solid_brep
    struct manifold_solid_brep : solid_model, ObjectHelper<manifold_solid_brep,1> { manifold_solid_brep() : Object("manifold_solid_brep") {}
		Lazy< closed_shell > outer;
    };

    // C++ wrapper for brep_with_voids
    struct brep_with_voids : manifold_solid_brep, ObjectHelper<brep_with_voids,1> { brep_with_voids() : Object("brep_with_voids") {}
		ListOf< Lazy< oriented_closed_shell >, 1, 0 > voids;
    };

    // C++ wrapper for bytes_representation_item
    struct bytes_representation_item : binary_representation_item, ObjectHelper<bytes_representation_item,0> { bytes_representation_item() : Object("bytes_representation_item") {}

    };

    // C++ wrapper for date
    struct date :  ObjectHelper<date,1> { date() : Object("date") {}
		year_number::Out year_component;
    };

    // C++ wrapper for calendar_date
    struct calendar_date : date, ObjectHelper<calendar_date,2> { calendar_date() : Object("calendar_date") {}
		day_in_month_number::Out day_component;
		month_in_year_number::Out month_component;
    };

    // C++ wrapper for camera_image
    struct camera_image : mapped_item, ObjectHelper<camera_image,0> { camera_image() : Object("camera_image") {}

    };

    // C++ wrapper for camera_image_3d_with_scale
    struct camera_image_3d_with_scale : camera_image, ObjectHelper<camera_image_3d_with_scale,0> { camera_image_3d_with_scale() : Object("camera_image_3d_with_scale") {}

    };

    // C++ wrapper for camera_model
    struct camera_model : geometric_representation_item, ObjectHelper<camera_model,0> { camera_model() : Object("camera_model") {}

    };

    // C++ wrapper for camera_model_d3
    struct camera_model_d3 : camera_model, ObjectHelper<camera_model_d3,2> { camera_model_d3() : Object("camera_model_d3") {}
		Lazy< axis2_placement_3d > view_reference_system;
		Lazy< view_volume > perspective_of_volume;
    };

    // C++ wrapper for camera_model_d3_multi_clipping
    struct camera_model_d3_multi_clipping : camera_model_d3, ObjectHelper<camera_model_d3_multi_clipping,1> { camera_model_d3_multi_clipping() : Object("camera_model_d3_multi_clipping") {}
		ListOf< camera_model_d3_multi_clipping_interection_select, 1, 0 >::Out shape_clipping;
    };

    // C++ wrapper for camera_model_d3_multi_clipping_intersection
    struct camera_model_d3_multi_clipping_intersection : geometric_representation_item, ObjectHelper<camera_model_d3_multi_clipping_intersection,1> { camera_model_d3_multi_clipping_intersection() : Object("camera_model_d3_multi_clipping_intersection") {}
		ListOf< camera_model_d3_multi_clipping_interection_select, 2, 0 >::Out shape_clipping;
    };

    // C++ wrapper for camera_model_d3_multi_clipping_union
    struct camera_model_d3_multi_clipping_union : geometric_representation_item, ObjectHelper<camera_model_d3_multi_clipping_union,1> { camera_model_d3_multi_clipping_union() : Object("camera_model_d3_multi_clipping_union") {}
		ListOf< camera_model_d3_multi_clipping_union_select, 2, 0 >::Out shape_clipping;
    };

    // C++ wrapper for camera_model_d3_with_hlhsr
    struct camera_model_d3_with_hlhsr : camera_model_d3, ObjectHelper<camera_model_d3_with_hlhsr,1> { camera_model_d3_with_hlhsr() : Object("camera_model_d3_with_hlhsr") {}
		BOOLEAN::Out hidden_line_surface_removal;
    };

    // C++ wrapper for camera_model_with_light_sources
    struct camera_model_with_light_sources : camera_model_d3, ObjectHelper<camera_model_with_light_sources,1> { camera_model_with_light_sources() : Object("camera_model_with_light_sources") {}
		ListOf< Lazy< light_source >, 1, 0 > sources;
    };

    // C++ wrapper for representation_map
    struct representation_map :  ObjectHelper<representation_map,2> { representation_map() : Object("representation_map") {}
		Lazy< representation_item > mapping_origin;
		Lazy< representation > mapped_representation;
    };

    // C++ wrapper for camera_usage
    struct camera_usage : representation_map, ObjectHelper<camera_usage,0> { camera_usage() : Object("camera_usage") {}

    };

    // C++ wrapper for capacitance_measure_with_unit
    struct capacitance_measure_with_unit : measure_with_unit, ObjectHelper<capacitance_measure_with_unit,0> { capacitance_measure_with_unit() : Object("capacitance_measure_with_unit") {}

    };

    // C++ wrapper for capacitance_unit
    struct capacitance_unit : derived_unit, ObjectHelper<capacitance_unit,0> { capacitance_unit() : Object("capacitance_unit") {}

    };

    // C++ wrapper for point
    struct point : geometric_representation_item, ObjectHelper<point,0> { point() : Object("point") {}

    };

    // C++ wrapper for cartesian_point
    struct cartesian_point : point, ObjectHelper<cartesian_point,1> { cartesian_point() : Object("cartesian_point") {}
		ListOf< length_measure, 1, 3 >::Out coordinates;
    };

    // C++ wrapper for cartesian_transformation_operator
    struct cartesian_transformation_operator :  ObjectHelper<cartesian_transformation_operator,4> { cartesian_transformation_operator() : Object("cartesian_transformation_operator") {}
		Maybe< Lazy< direction > > axis1;
		Maybe< Lazy< direction > > axis2;
		Lazy< cartesian_point > local_origin;
		Maybe< REAL::Out > scale;
    };

    // C++ wrapper for cartesian_transformation_operator_2d
    struct cartesian_transformation_operator_2d : cartesian_transformation_operator, ObjectHelper<cartesian_transformation_operator_2d,0> { cartesian_transformation_operator_2d() : Object("cartesian_transformation_operator_2d") {}

    };

    // C++ wrapper for cartesian_transformation_operator_3d
    struct cartesian_transformation_operator_3d : cartesian_transformation_operator, ObjectHelper<cartesian_transformation_operator_3d,1> { cartesian_transformation_operator_3d() : Object("cartesian_transformation_operator_3d") {}
		Maybe< Lazy< direction > > axis3;
    };

    // C++ wrapper for cc_design_approval
    struct cc_design_approval : approval_assignment, ObjectHelper<cc_design_approval,1> { cc_design_approval() : Object("cc_design_approval") {}
		ListOf< approved_item, 1, 0 >::Out items;
    };

    // C++ wrapper for cc_design_certification
    struct cc_design_certification : certification_assignment, ObjectHelper<cc_design_certification,1> { cc_design_certification() : Object("cc_design_certification") {}
		ListOf< certified_item, 1, 0 >::Out items;
    };

    // C++ wrapper for cc_design_contract
    struct cc_design_contract : contract_assignment, ObjectHelper<cc_design_contract,1> { cc_design_contract() : Object("cc_design_contract") {}
		ListOf< contracted_item, 1, 0 >::Out items;
    };

    // C++ wrapper for cc_design_date_and_time_assignment
    struct cc_design_date_and_time_assignment : date_and_time_assignment, ObjectHelper<cc_design_date_and_time_assignment,1> { cc_design_date_and_time_assignment() : Object("cc_design_date_and_time_assignment") {}
		ListOf< date_time_item, 1, 0 >::Out items;
    };

    // C++ wrapper for cc_design_person_and_organization_assignment
    struct cc_design_person_and_organization_assignment : person_and_organization_assignment, ObjectHelper<cc_design_person_and_organization_assignment,1> { cc_design_person_and_organization_assignment() : Object("cc_design_person_and_organization_assignment") {}
		ListOf< cc_person_organization_item, 1, 0 >::Out items;
    };

    // C++ wrapper for cc_design_security_classification
    struct cc_design_security_classification : security_classification_assignment, ObjectHelper<cc_design_security_classification,1> { cc_design_security_classification() : Object("cc_design_security_classification") {}
		ListOf< cc_classified_item, 1, 0 >::Out items;
    };

    // C++ wrapper for cc_design_specification_reference
    struct cc_design_specification_reference : document_reference, ObjectHelper<cc_design_specification_reference,1> { cc_design_specification_reference() : Object("cc_design_specification_reference") {}
		ListOf< cc_specified_item, 1, 0 >::Out items;
    };

    // C++ wrapper for celsius_temperature_measure_with_unit
    struct celsius_temperature_measure_with_unit : measure_with_unit, ObjectHelper<celsius_temperature_measure_with_unit,0> { celsius_temperature_measure_with_unit() : Object("celsius_temperature_measure_with_unit") {}

    };

    // C++ wrapper for centre_of_symmetry
    struct centre_of_symmetry : derived_shape_aspect, ObjectHelper<centre_of_symmetry,0> { centre_of_symmetry() : Object("centre_of_symmetry") {}

    };

    // C++ wrapper for change
    struct change : action_assignment, ObjectHelper<change,1> { change() : Object("change") {}
		ListOf< work_item, 1, 0 >::Out items;
    };

    // C++ wrapper for change_request
    struct change_request : action_request_assignment, ObjectHelper<change_request,1> { change_request() : Object("change_request") {}
		ListOf< change_request_item, 1, 0 >::Out items;
    };

    // C++ wrapper for character_glyph_style_outline
    struct character_glyph_style_outline : founded_item, ObjectHelper<character_glyph_style_outline,1> { character_glyph_style_outline() : Object("character_glyph_style_outline") {}
		Lazy< curve_style > outline_style;
    };

    // C++ wrapper for character_glyph_style_stroke
    struct character_glyph_style_stroke : founded_item, ObjectHelper<character_glyph_style_stroke,1> { character_glyph_style_stroke() : Object("character_glyph_style_stroke") {}
		Lazy< curve_style > stroke_style;
    };

    // C++ wrapper for symbol_representation
    struct symbol_representation : representation, ObjectHelper<symbol_representation,0> { symbol_representation() : Object("symbol_representation") {}

    };

    // C++ wrapper for generic_character_glyph_symbol
    struct generic_character_glyph_symbol : symbol_representation, ObjectHelper<generic_character_glyph_symbol,0> { generic_character_glyph_symbol() : Object("generic_character_glyph_symbol") {}

    };

    // C++ wrapper for character_glyph_symbol
    struct character_glyph_symbol : generic_character_glyph_symbol, ObjectHelper<character_glyph_symbol,2> { character_glyph_symbol() : Object("character_glyph_symbol") {}
		Lazy< planar_extent > character_box;
		ratio_measure::Out baseline_ratio;
    };

    // C++ wrapper for character_glyph_symbol_outline
    struct character_glyph_symbol_outline : character_glyph_symbol, ObjectHelper<character_glyph_symbol_outline,1> { character_glyph_symbol_outline() : Object("character_glyph_symbol_outline") {}
		ListOf< Lazy< annotation_fill_area >, 1, 0 > outlines;
    };

    // C++ wrapper for character_glyph_symbol_stroke
    struct character_glyph_symbol_stroke : character_glyph_symbol, ObjectHelper<character_glyph_symbol_stroke,1> { character_glyph_symbol_stroke() : Object("character_glyph_symbol_stroke") {}
		ListOf< Lazy< curve >, 1, 0 > strokes;
    };

    // C++ wrapper for general_property
    struct general_property :  ObjectHelper<general_property,3> { general_property() : Object("general_property") {}
		identifier::Out id;
		label::Out name;
		Maybe< text::Out > description;
    };

    // C++ wrapper for characteristic_data_column_header
    struct characteristic_data_column_header : general_property, ObjectHelper<characteristic_data_column_header,0> { characteristic_data_column_header() : Object("characteristic_data_column_header") {}

    };

    // C++ wrapper for general_property_relationship
    struct general_property_relationship :  ObjectHelper<general_property_relationship,4> { general_property_relationship() : Object("general_property_relationship") {}
		label::Out name;
		Maybe< text::Out > description;
		Lazy< general_property > relating_property;
		Lazy< general_property > related_property;
    };

    // C++ wrapper for characteristic_data_column_header_link
    struct characteristic_data_column_header_link : general_property_relationship, ObjectHelper<characteristic_data_column_header_link,0> { characteristic_data_column_header_link() : Object("characteristic_data_column_header_link") {}

    };

    // C++ wrapper for characteristic_data_table_header
    struct characteristic_data_table_header : general_property, ObjectHelper<characteristic_data_table_header,0> { characteristic_data_table_header() : Object("characteristic_data_table_header") {}

    };

    // C++ wrapper for characteristic_data_table_header_decomposition
    struct characteristic_data_table_header_decomposition : general_property_relationship, ObjectHelper<characteristic_data_table_header_decomposition,0> { characteristic_data_table_header_decomposition() : Object("characteristic_data_table_header_decomposition") {}

    };

    // C++ wrapper for group
    struct group :  ObjectHelper<group,2> { group() : Object("group") {}
		label::Out name;
		Maybe< text::Out > description;
    };

    // C++ wrapper for characteristic_type
    struct characteristic_type : group, ObjectHelper<characteristic_type,0> { characteristic_type() : Object("characteristic_type") {}

    };

    // C++ wrapper for characterized_class
    struct characterized_class :  ObjectHelper<characterized_class,0> { characterized_class() : Object("characterized_class") {}

    };

    // C++ wrapper for characterized_object
    struct characterized_object :  ObjectHelper<characterized_object,2> { characterized_object() : Object("characterized_object") {}
		label::Out name;
		Maybe< text::Out > description;
    };

    // C++ wrapper for conic
    struct conic : curve, ObjectHelper<conic,1> { conic() : Object("conic") {}
		axis2_placement::Out position;
    };

    // C++ wrapper for circle
    struct circle : conic, ObjectHelper<circle,1> { circle() : Object("circle") {}
		positive_length_measure::Out radius;
    };

    // C++ wrapper for circular_runout_tolerance
    struct circular_runout_tolerance : geometric_tolerance_with_datum_reference, ObjectHelper<circular_runout_tolerance,0> { circular_runout_tolerance() : Object("circular_runout_tolerance") {}

    };

    // C++ wrapper for class_by_extension
    struct class_by_extension : class_t, ObjectHelper<class_by_extension,0> { class_by_extension() : Object("class_by_extension") {}

    };

    // C++ wrapper for class_by_intension
    struct class_by_intension : class_t, ObjectHelper<class_by_intension,0> { class_by_intension() : Object("class_by_intension") {}

    };

    // C++ wrapper for class_system
    struct class_system : group, ObjectHelper<class_system,0> { class_system() : Object("class_system") {}

    };

    // C++ wrapper for effectivity_context_assignment
    struct effectivity_context_assignment :  ObjectHelper<effectivity_context_assignment,2> { effectivity_context_assignment() : Object("effectivity_context_assignment") {}
		Lazy< effectivity_assignment > assigned_effectivity_assignment;
		Lazy< NotImplemented > role;
    };

    // C++ wrapper for class_usage_effectivity_context_assignment
    struct class_usage_effectivity_context_assignment : effectivity_context_assignment, ObjectHelper<class_usage_effectivity_context_assignment,1> { class_usage_effectivity_context_assignment() : Object("class_usage_effectivity_context_assignment") {}
		ListOf< class_usage_effectivity_context_item, 1, 0 >::Out items;
    };

    // C++ wrapper for topological_representation_item
    struct topological_representation_item : representation_item, ObjectHelper<topological_representation_item,0> { topological_representation_item() : Object("topological_representation_item") {}

    };

    // C++ wrapper for connected_face_set
    struct connected_face_set : topological_representation_item, ObjectHelper<connected_face_set,1> { connected_face_set() : Object("connected_face_set") {}
		ListOf< Lazy< face >, 1, 0 > cfs_faces;
    };

    // C++ wrapper for closed_shell
    struct closed_shell : connected_face_set, ObjectHelper<closed_shell,0> { closed_shell() : Object("closed_shell") {}

    };

    // C++ wrapper for coaxiality_tolerance
    struct coaxiality_tolerance : geometric_tolerance_with_datum_reference, ObjectHelper<coaxiality_tolerance,0> { coaxiality_tolerance() : Object("coaxiality_tolerance") {}

    };

    // C++ wrapper for colour_specification
    struct colour_specification : colour, ObjectHelper<colour_specification,1> { colour_specification() : Object("colour_specification") {}
		label::Out name;
    };

    // C++ wrapper for colour_rgb
    struct colour_rgb : colour_specification, ObjectHelper<colour_rgb,3> { colour_rgb() : Object("colour_rgb") {}
		REAL::Out red;
		REAL::Out green;
		REAL::Out blue;
    };

    // C++ wrapper for common_datum
    struct common_datum :  ObjectHelper<common_datum,0> { common_datum() : Object("common_datum") {}

    };

    // C++ wrapper for comparison_expression
    struct comparison_expression :  ObjectHelper<comparison_expression,0> { comparison_expression() : Object("comparison_expression") {}

    };

    // C++ wrapper for complex_clause
    struct complex_clause : compound_representation_item, ObjectHelper<complex_clause,0> { complex_clause() : Object("complex_clause") {}

    };

    // C++ wrapper for complex_conjunctive_clause
    struct complex_conjunctive_clause : complex_clause, ObjectHelper<complex_conjunctive_clause,0> { complex_conjunctive_clause() : Object("complex_conjunctive_clause") {}

    };

    // C++ wrapper for complex_disjunctive_clause
    struct complex_disjunctive_clause : complex_clause, ObjectHelper<complex_disjunctive_clause,0> { complex_disjunctive_clause() : Object("complex_disjunctive_clause") {}

    };

    // C++ wrapper for modified_solid
    struct modified_solid : solid_model, ObjectHelper<modified_solid,2> { modified_solid() : Object("modified_solid") {}
		text::Out rationale;
		base_solid_select::Out base_solid;
    };

    // C++ wrapper for shelled_solid
    struct shelled_solid : modified_solid, ObjectHelper<shelled_solid,2> { shelled_solid() : Object("shelled_solid") {}
		ListOf< Lazy< face_surface >, 1, 0 > deleted_face_set;
		length_measure::Out thickness;
    };

    // C++ wrapper for complex_shelled_solid
    struct complex_shelled_solid : shelled_solid, ObjectHelper<complex_shelled_solid,1> { complex_shelled_solid() : Object("complex_shelled_solid") {}
		ListOf< length_measure, 1, 0 >::Out thickness_list;
    };

    // C++ wrapper for composite_assembly_definition
    struct composite_assembly_definition : product_definition, ObjectHelper<composite_assembly_definition,0> { composite_assembly_definition() : Object("composite_assembly_definition") {}

    };

    // C++ wrapper for composite_assembly_sequence_definition
    struct composite_assembly_sequence_definition : product_definition, ObjectHelper<composite_assembly_sequence_definition,0> { composite_assembly_sequence_definition() : Object("composite_assembly_sequence_definition") {}

    };

    // C++ wrapper for laminate_table
    struct laminate_table : product_definition, ObjectHelper<laminate_table,0> { laminate_table() : Object("laminate_table") {}

    };

    // C++ wrapper for part_laminate_table
    struct part_laminate_table : laminate_table, ObjectHelper<part_laminate_table,0> { part_laminate_table() : Object("part_laminate_table") {}

    };

    // C++ wrapper for composite_assembly_table
    struct composite_assembly_table : part_laminate_table, ObjectHelper<composite_assembly_table,0> { composite_assembly_table() : Object("composite_assembly_table") {}

    };

    // C++ wrapper for composite_curve_segment
    struct composite_curve_segment : founded_item, ObjectHelper<composite_curve_segment,3> { composite_curve_segment() : Object("composite_curve_segment") {}
		transition_code::Out transition;
		BOOLEAN::Out same_sense;
		Lazy< curve > parent_curve;
    };

    // C++ wrapper for material_designation
    struct material_designation :  ObjectHelper<material_designation,2> { material_designation() : Object("material_designation") {}
		label::Out name;
		ListOf< characterized_definition, 1, 0 >::Out definitions;
    };

    // C++ wrapper for composite_material_designation
    struct composite_material_designation : material_designation, ObjectHelper<composite_material_designation,0> { composite_material_designation() : Object("composite_material_designation") {}

    };

    // C++ wrapper for composite_shape_aspect
    struct composite_shape_aspect : shape_aspect, ObjectHelper<composite_shape_aspect,0> { composite_shape_aspect() : Object("composite_shape_aspect") {}

    };

    // C++ wrapper for composite_sheet_representation
    struct composite_sheet_representation : shape_representation, ObjectHelper<composite_sheet_representation,0> { composite_sheet_representation() : Object("composite_sheet_representation") {}

    };

    // C++ wrapper for composite_text
    struct composite_text : geometric_representation_item, ObjectHelper<composite_text,1> { composite_text() : Object("composite_text") {}
		ListOf< text_or_character, 2, 0 >::Out collected_text;
    };

    // C++ wrapper for composite_text_with_associated_curves
    struct composite_text_with_associated_curves : composite_text, ObjectHelper<composite_text_with_associated_curves,1> { composite_text_with_associated_curves() : Object("composite_text_with_associated_curves") {}
		ListOf< Lazy< curve >, 1, 0 > associated_curves;
    };

    // C++ wrapper for composite_text_with_blanking_box
    struct composite_text_with_blanking_box : composite_text, ObjectHelper<composite_text_with_blanking_box,1> { composite_text_with_blanking_box() : Object("composite_text_with_blanking_box") {}
		Lazy< planar_box > blanking;
    };

    // C++ wrapper for composite_text_with_delineation
    struct composite_text_with_delineation : composite_text, ObjectHelper<composite_text_with_delineation,1> { composite_text_with_delineation() : Object("composite_text_with_delineation") {}
		text_delineation::Out delineation;
    };

    // C++ wrapper for composite_text_with_extent
    struct composite_text_with_extent : composite_text, ObjectHelper<composite_text_with_extent,1> { composite_text_with_extent() : Object("composite_text_with_extent") {}
		Lazy< planar_extent > extent;
    };

    // C++ wrapper for compound_shape_representation
    struct compound_shape_representation : shape_representation, ObjectHelper<compound_shape_representation,0> { compound_shape_representation() : Object("compound_shape_representation") {}

    };

    // C++ wrapper for concentricity_tolerance
    struct concentricity_tolerance : geometric_tolerance_with_datum_reference, ObjectHelper<concentricity_tolerance,0> { concentricity_tolerance() : Object("concentricity_tolerance") {}

    };

    // C++ wrapper for concept_feature_relationship
    struct concept_feature_relationship :  ObjectHelper<concept_feature_relationship,4> { concept_feature_relationship() : Object("concept_feature_relationship") {}
		label::Out name;
		Maybe< text::Out > description;
		Lazy< product_concept_feature > relating_product_concept_feature;
		Lazy< product_concept_feature > related_product_concept_feature;
    };

    // C++ wrapper for concept_feature_relationship_with_condition
    struct concept_feature_relationship_with_condition : concept_feature_relationship, ObjectHelper<concept_feature_relationship_with_condition,1> { concept_feature_relationship_with_condition() : Object("concept_feature_relationship_with_condition") {}
		Lazy< NotImplemented > conditional_operator;
    };

    // C++ wrapper for product_concept_feature
    struct product_concept_feature :  ObjectHelper<product_concept_feature,3> { product_concept_feature() : Object("product_concept_feature") {}
		identifier::Out id;
		label::Out name;
		Maybe< text::Out > description;
    };

    // C++ wrapper for conditional_concept_feature
    struct conditional_concept_feature : product_concept_feature, ObjectHelper<conditional_concept_feature,1> { conditional_concept_feature() : Object("conditional_concept_feature") {}
		Lazy< concept_feature_relationship_with_condition > condition;
    };

    // C++ wrapper for conductance_measure_with_unit
    struct conductance_measure_with_unit : measure_with_unit, ObjectHelper<conductance_measure_with_unit,0> { conductance_measure_with_unit() : Object("conductance_measure_with_unit") {}

    };

    // C++ wrapper for conductance_unit
    struct conductance_unit : derived_unit, ObjectHelper<conductance_unit,0> { conductance_unit() : Object("conductance_unit") {}

    };

    // C++ wrapper for configuration_item
    struct configuration_item :  ObjectHelper<configuration_item,5> { configuration_item() : Object("configuration_item") {}
		identifier::Out id;
		label::Out name;
		Maybe< text::Out > description;
		Lazy< NotImplemented > item_concept;
		Maybe< label::Out > purpose;
    };

    // C++ wrapper for configurable_item
    struct configurable_item : configuration_item, ObjectHelper<configurable_item,1> { configurable_item() : Object("configurable_item") {}
		ListOf< Lazy< NotImplemented >, 1, 0 > item_concept_feature;
    };

    // C++ wrapper for effectivity
    struct effectivity :  ObjectHelper<effectivity,1> { effectivity() : Object("effectivity") {}
		identifier::Out id;
    };

    // C++ wrapper for product_definition_effectivity
    struct product_definition_effectivity : effectivity, ObjectHelper<product_definition_effectivity,1> { product_definition_effectivity() : Object("product_definition_effectivity") {}
		Lazy< product_definition_relationship > usage;
    };

    // C++ wrapper for configuration_effectivity
    struct configuration_effectivity : product_definition_effectivity, ObjectHelper<configuration_effectivity,1> { configuration_effectivity() : Object("configuration_effectivity") {}
		Lazy< NotImplemented > configuration;
    };

    // C++ wrapper for configuration_item_relationship
    struct configuration_item_relationship :  ObjectHelper<configuration_item_relationship,4> { configuration_item_relationship() : Object("configuration_item_relationship") {}
		label::Out name;
		Maybe< text::Out > description;
		Lazy< configuration_item > relating_configuration_item;
		Lazy< configuration_item > related_configuration_item;
    };

    // C++ wrapper for configuration_item_hierarchical_relationship
    struct configuration_item_hierarchical_relationship : configuration_item_relationship, ObjectHelper<configuration_item_hierarchical_relationship,0> { configuration_item_hierarchical_relationship() : Object("configuration_item_hierarchical_relationship") {}

    };

    // C++ wrapper for configuration_item_revision_sequence
    struct configuration_item_revision_sequence : configuration_item_relationship, ObjectHelper<configuration_item_revision_sequence,0> { configuration_item_revision_sequence() : Object("configuration_item_revision_sequence") {}

    };

    // C++ wrapper for configured_effectivity_assignment
    struct configured_effectivity_assignment : effectivity_assignment, ObjectHelper<configured_effectivity_assignment,1> { configured_effectivity_assignment() : Object("configured_effectivity_assignment") {}
		ListOf< configured_effectivity_item, 1, 0 >::Out items;
    };

    // C++ wrapper for configured_effectivity_context_assignment
    struct configured_effectivity_context_assignment : effectivity_context_assignment, ObjectHelper<configured_effectivity_context_assignment,1> { configured_effectivity_context_assignment() : Object("configured_effectivity_context_assignment") {}
		ListOf< configured_effectivity_context_item, 1, 0 >::Out items;
    };

    // C++ wrapper for conical_stepped_hole_transition
    struct conical_stepped_hole_transition : geometric_representation_item, ObjectHelper<conical_stepped_hole_transition,3> { conical_stepped_hole_transition() : Object("conical_stepped_hole_transition") {}
		positive_integer::Out transition_number;
		plane_angle_measure::Out cone_apex_angle;
		positive_length_measure::Out cone_base_radius;
    };

    // C++ wrapper for elementary_surface
    struct elementary_surface : surface, ObjectHelper<elementary_surface,1> { elementary_surface() : Object("elementary_surface") {}
		Lazy< axis2_placement_3d > position;
    };

    // C++ wrapper for conical_surface
    struct conical_surface : elementary_surface, ObjectHelper<conical_surface,2> { conical_surface() : Object("conical_surface") {}
		length_measure::Out radius;
		plane_angle_measure::Out semi_angle;
    };

    // C++ wrapper for connected_edge_set
    struct connected_edge_set : topological_representation_item, ObjectHelper<connected_edge_set,1> { connected_edge_set() : Object("connected_edge_set") {}
		ListOf< Lazy< edge >, 1, 0 > ces_edges;
    };

    // C++ wrapper for connected_face_sub_set
    struct connected_face_sub_set : connected_face_set, ObjectHelper<connected_face_sub_set,1> { connected_face_sub_set() : Object("connected_face_sub_set") {}
		Lazy< connected_face_set > parent_face_set;
    };

    // C++ wrapper for constructive_geometry_representation
    struct constructive_geometry_representation : representation, ObjectHelper<constructive_geometry_representation,0> { constructive_geometry_representation() : Object("constructive_geometry_representation") {}

    };

    // C++ wrapper for representation_relationship
    struct representation_relationship :  ObjectHelper<representation_relationship,4> { representation_relationship() : Object("representation_relationship") {}
		label::Out name;
		Maybe< text::Out > description;
		Lazy< representation > rep_1;
		Lazy< representation > rep_2;
    };

    // C++ wrapper for constructive_geometry_representation_relationship
    struct constructive_geometry_representation_relationship : representation_relationship, ObjectHelper<constructive_geometry_representation_relationship,0> { constructive_geometry_representation_relationship() : Object("constructive_geometry_representation_relationship") {}

    };

    // C++ wrapper for contact_ratio_representation
    struct contact_ratio_representation : representation, ObjectHelper<contact_ratio_representation,0> { contact_ratio_representation() : Object("contact_ratio_representation") {}

    };

    // C++ wrapper for invisibility
    struct invisibility :  ObjectHelper<invisibility,1> { invisibility() : Object("invisibility") {}
		ListOf< invisible_item, 1, 0 >::Out invisible_items;
    };

    // C++ wrapper for context_dependent_invisibility
    struct context_dependent_invisibility : invisibility, ObjectHelper<context_dependent_invisibility,1> { context_dependent_invisibility() : Object("context_dependent_invisibility") {}
		invisibility_context::Out presentation_context;
    };

    // C++ wrapper for over_riding_styled_item
    struct over_riding_styled_item : styled_item, ObjectHelper<over_riding_styled_item,1> { over_riding_styled_item() : Object("over_riding_styled_item") {}
		Lazy< styled_item > over_ridden_style;
    };

    // C++ wrapper for context_dependent_over_riding_styled_item
    struct context_dependent_over_riding_styled_item : over_riding_styled_item, ObjectHelper<context_dependent_over_riding_styled_item,1> { context_dependent_over_riding_styled_item() : Object("context_dependent_over_riding_styled_item") {}
		ListOf< style_context_select, 1, 0 >::Out style_context;
    };

    // C++ wrapper for context_dependent_unit
    struct context_dependent_unit : named_unit, ObjectHelper<context_dependent_unit,1> { context_dependent_unit() : Object("context_dependent_unit") {}
		label::Out name;
    };

    // C++ wrapper for conversion_based_unit
    struct conversion_based_unit : named_unit, ObjectHelper<conversion_based_unit,2> { conversion_based_unit() : Object("conversion_based_unit") {}
		label::Out name;
		Lazy< measure_with_unit > conversion_factor;
    };

    // C++ wrapper for csg_shape_representation
    struct csg_shape_representation : shape_representation, ObjectHelper<csg_shape_representation,0> { csg_shape_representation() : Object("csg_shape_representation") {}

    };

    // C++ wrapper for csg_solid
    struct csg_solid : solid_model, ObjectHelper<csg_solid,1> { csg_solid() : Object("csg_solid") {}
		csg_select::Out tree_root_expression;
    };

    // C++ wrapper for currency
    struct currency : context_dependent_unit, ObjectHelper<currency,0> { currency() : Object("currency") {}

    };

    // C++ wrapper for currency_measure_with_unit
    struct currency_measure_with_unit : measure_with_unit, ObjectHelper<currency_measure_with_unit,0> { currency_measure_with_unit() : Object("currency_measure_with_unit") {}

    };

    // C++ wrapper for curve_bounded_surface
    struct curve_bounded_surface : bounded_surface, ObjectHelper<curve_bounded_surface,3> { curve_bounded_surface() : Object("curve_bounded_surface") {}
		Lazy< surface > basis_surface;
		ListOf< Lazy< boundary_curve >, 1, 0 > boundaries;
		BOOLEAN::Out implicit_outer;
    };

    // C++ wrapper for curve_dimension
    struct curve_dimension : dimension_curve_directed_callout, ObjectHelper<curve_dimension,0> { curve_dimension() : Object("curve_dimension") {}

    };

    // C++ wrapper for curve_replica
    struct curve_replica : curve, ObjectHelper<curve_replica,2> { curve_replica() : Object("curve_replica") {}
		Lazy< curve > parent_curve;
		Lazy< cartesian_transformation_operator > transformation;
    };

    // C++ wrapper for curve_style
    struct curve_style : founded_item, ObjectHelper<curve_style,4> { curve_style() : Object("curve_style") {}
		label::Out name;
		curve_font_or_scaled_curve_font_select::Out curve_font;
		size_select::Out curve_width;
		Lazy< colour > curve_colour;
    };

    // C++ wrapper for curve_style_font
    struct curve_style_font : founded_item, ObjectHelper<curve_style_font,2> { curve_style_font() : Object("curve_style_font") {}
		label::Out name;
		ListOf< Lazy< curve_style_font_pattern >, 1, 0 > pattern_list;
    };

    // C++ wrapper for curve_style_font_and_scaling
    struct curve_style_font_and_scaling : founded_item, ObjectHelper<curve_style_font_and_scaling,3> { curve_style_font_and_scaling() : Object("curve_style_font_and_scaling") {}
		label::Out name;
		curve_style_font_select::Out curve_font;
		REAL::Out curve_font_scaling;
    };

    // C++ wrapper for curve_style_font_pattern
    struct curve_style_font_pattern : founded_item, ObjectHelper<curve_style_font_pattern,2> { curve_style_font_pattern() : Object("curve_style_font_pattern") {}
		positive_length_measure::Out visible_segment_length;
		positive_length_measure::Out invisible_segment_length;
    };

    // C++ wrapper for curve_swept_solid_shape_representation
    struct curve_swept_solid_shape_representation : shape_representation, ObjectHelper<curve_swept_solid_shape_representation,0> { curve_swept_solid_shape_representation() : Object("curve_swept_solid_shape_representation") {}

    };

    // C++ wrapper for cylindrical_surface
    struct cylindrical_surface : elementary_surface, ObjectHelper<cylindrical_surface,1> { cylindrical_surface() : Object("cylindrical_surface") {}
		positive_length_measure::Out radius;
    };

    // C++ wrapper for cylindricity_tolerance
    struct cylindricity_tolerance : geometric_tolerance, ObjectHelper<cylindricity_tolerance,0> { cylindricity_tolerance() : Object("cylindricity_tolerance") {}

    };

    // C++ wrapper for date_representation_item
    struct date_representation_item :  ObjectHelper<date_representation_item,0> { date_representation_item() : Object("date_representation_item") {}

    };

    // C++ wrapper for date_time_representation_item
    struct date_time_representation_item :  ObjectHelper<date_time_representation_item,0> { date_time_representation_item() : Object("date_time_representation_item") {}

    };

    // C++ wrapper for dated_effectivity
    struct dated_effectivity : effectivity, ObjectHelper<dated_effectivity,2> { dated_effectivity() : Object("dated_effectivity") {}
		Maybe< date_time_or_event_occurrence::Out > effectivity_end_date;
		date_time_or_event_occurrence::Out effectivity_start_date;
    };

    // C++ wrapper for datum
    struct datum : shape_aspect, ObjectHelper<datum,1> { datum() : Object("datum") {}
		identifier::Out identification;
    };

    // C++ wrapper for datum_feature
    struct datum_feature : shape_aspect, ObjectHelper<datum_feature,0> { datum_feature() : Object("datum_feature") {}

    };

    // C++ wrapper for datum_feature_callout
    struct datum_feature_callout : draughting_callout, ObjectHelper<datum_feature_callout,0> { datum_feature_callout() : Object("datum_feature_callout") {}

    };

    // C++ wrapper for datum_reference
    struct datum_reference :  ObjectHelper<datum_reference,2> { datum_reference() : Object("datum_reference") {}
		INTEGER::Out precedence;
		Lazy< datum > referenced_datum;
    };

    // C++ wrapper for datum_target
    struct datum_target : shape_aspect, ObjectHelper<datum_target,1> { datum_target() : Object("datum_target") {}
		identifier::Out target_id;
    };

    // C++ wrapper for datum_target_callout
    struct datum_target_callout : draughting_callout, ObjectHelper<datum_target_callout,0> { datum_target_callout() : Object("datum_target_callout") {}

    };

    // C++ wrapper for default_tolerance_table
    struct default_tolerance_table : representation, ObjectHelper<default_tolerance_table,0> { default_tolerance_table() : Object("default_tolerance_table") {}

    };

    // C++ wrapper for default_tolerance_table_cell
    struct default_tolerance_table_cell : compound_representation_item, ObjectHelper<default_tolerance_table_cell,0> { default_tolerance_table_cell() : Object("default_tolerance_table_cell") {}

    };

    // C++ wrapper for defined_symbol
    struct defined_symbol : geometric_representation_item, ObjectHelper<defined_symbol,2> { defined_symbol() : Object("defined_symbol") {}
		defined_symbol_select::Out definition;
		Lazy< symbol_target > target;
    };

    // C++ wrapper for definitional_representation
    struct definitional_representation : representation, ObjectHelper<definitional_representation,0> { definitional_representation() : Object("definitional_representation") {}

    };

    // C++ wrapper for definitional_representation_relationship
    struct definitional_representation_relationship : representation_relationship, ObjectHelper<definitional_representation_relationship,0> { definitional_representation_relationship() : Object("definitional_representation_relationship") {}

    };

    // C++ wrapper for definitional_representation_relationship_with_same_context
    struct definitional_representation_relationship_with_same_context : definitional_representation_relationship, ObjectHelper<definitional_representation_relationship_with_same_context,0> { definitional_representation_relationship_with_same_context() : Object("definitional_representation_relationship_with_same_context") {}

    };

    // C++ wrapper for degenerate_pcurve
    struct degenerate_pcurve : point, ObjectHelper<degenerate_pcurve,2> { degenerate_pcurve() : Object("degenerate_pcurve") {}
		Lazy< surface > basis_surface;
		Lazy< definitional_representation > reference_to_curve;
    };

    // C++ wrapper for toroidal_surface
    struct toroidal_surface : elementary_surface, ObjectHelper<toroidal_surface,2> { toroidal_surface() : Object("toroidal_surface") {}
		positive_length_measure::Out major_radius;
		positive_length_measure::Out minor_radius;
    };

    // C++ wrapper for degenerate_toroidal_surface
    struct degenerate_toroidal_surface : toroidal_surface, ObjectHelper<degenerate_toroidal_surface,1> { degenerate_toroidal_surface() : Object("degenerate_toroidal_surface") {}
		BOOLEAN::Out select_outer;
    };

    // C++ wrapper for descriptive_representation_item
    struct descriptive_representation_item : representation_item, ObjectHelper<descriptive_representation_item,1> { descriptive_representation_item() : Object("descriptive_representation_item") {}
		text::Out description;
    };

    // C++ wrapper for product_definition_context
    struct product_definition_context : application_context_element, ObjectHelper<product_definition_context,1> { product_definition_context() : Object("product_definition_context") {}
		label::Out life_cycle_stage;
    };

    // C++ wrapper for design_context
    struct design_context : product_definition_context, ObjectHelper<design_context,0> { design_context() : Object("design_context") {}

    };

    // C++ wrapper for design_make_from_relationship
    struct design_make_from_relationship : product_definition_relationship, ObjectHelper<design_make_from_relationship,0> { design_make_from_relationship() : Object("design_make_from_relationship") {}

    };

    // C++ wrapper for diameter_dimension
    struct diameter_dimension : dimension_curve_directed_callout, ObjectHelper<diameter_dimension,0> { diameter_dimension() : Object("diameter_dimension") {}

    };

    // C++ wrapper for ratio_measure_with_unit
    struct ratio_measure_with_unit : measure_with_unit, ObjectHelper<ratio_measure_with_unit,0> { ratio_measure_with_unit() : Object("ratio_measure_with_unit") {}

    };

    // C++ wrapper for dielectric_constant_measure_with_unit
    struct dielectric_constant_measure_with_unit : ratio_measure_with_unit, ObjectHelper<dielectric_constant_measure_with_unit,0> { dielectric_constant_measure_with_unit() : Object("dielectric_constant_measure_with_unit") {}

    };

    // C++ wrapper for dimension_callout
    struct dimension_callout : draughting_callout, ObjectHelper<dimension_callout,0> { dimension_callout() : Object("dimension_callout") {}

    };

    // C++ wrapper for draughting_callout_relationship
    struct draughting_callout_relationship :  ObjectHelper<draughting_callout_relationship,4> { draughting_callout_relationship() : Object("draughting_callout_relationship") {}
		label::Out name;
		text::Out description;
		Lazy< draughting_callout > relating_draughting_callout;
		Lazy< draughting_callout > related_draughting_callout;
    };

    // C++ wrapper for dimension_callout_component_relationship
    struct dimension_callout_component_relationship : draughting_callout_relationship, ObjectHelper<dimension_callout_component_relationship,0> { dimension_callout_component_relationship() : Object("dimension_callout_component_relationship") {}

    };

    // C++ wrapper for dimension_callout_relationship
    struct dimension_callout_relationship : draughting_callout_relationship, ObjectHelper<dimension_callout_relationship,0> { dimension_callout_relationship() : Object("dimension_callout_relationship") {}

    };

    // C++ wrapper for dimension_curve
    struct dimension_curve : annotation_curve_occurrence, ObjectHelper<dimension_curve,0> { dimension_curve() : Object("dimension_curve") {}

    };

    // C++ wrapper for terminator_symbol
    struct terminator_symbol : annotation_symbol_occurrence, ObjectHelper<terminator_symbol,1> { terminator_symbol() : Object("terminator_symbol") {}
		Lazy< annotation_curve_occurrence > annotated_curve;
    };

    // C++ wrapper for dimension_curve_terminator
    struct dimension_curve_terminator : terminator_symbol, ObjectHelper<dimension_curve_terminator,1> { dimension_curve_terminator() : Object("dimension_curve_terminator") {}
		dimension_extent_usage::Out role;
    };

    // C++ wrapper for dimension_curve_terminator_to_projection_curve_associativity
    struct dimension_curve_terminator_to_projection_curve_associativity : annotation_occurrence_associativity, ObjectHelper<dimension_curve_terminator_to_projection_curve_associativity,0> { dimension_curve_terminator_to_projection_curve_associativity() : Object("dimension_curve_terminator_to_projection_curve_associativity") {}

    };

    // C++ wrapper for dimension_pair
    struct dimension_pair : draughting_callout_relationship, ObjectHelper<dimension_pair,0> { dimension_pair() : Object("dimension_pair") {}

    };

    // C++ wrapper for dimension_text_associativity
    struct dimension_text_associativity :  ObjectHelper<dimension_text_associativity,0> { dimension_text_associativity() : Object("dimension_text_associativity") {}

    };

    // C++ wrapper for dimensional_location_with_path
    struct dimensional_location_with_path : dimensional_location, ObjectHelper<dimensional_location_with_path,1> { dimensional_location_with_path() : Object("dimensional_location_with_path") {}
		Lazy< shape_aspect > path;
    };

    // C++ wrapper for dimensional_size_with_path
    struct dimensional_size_with_path : dimensional_size, ObjectHelper<dimensional_size_with_path,1> { dimensional_size_with_path() : Object("dimensional_size_with_path") {}
		Lazy< shape_aspect > path;
    };

    // C++ wrapper for executed_action
    struct executed_action : action, ObjectHelper<executed_action,0> { executed_action() : Object("executed_action") {}

    };

    // C++ wrapper for directed_action
    struct directed_action : executed_action, ObjectHelper<directed_action,1> { directed_action() : Object("directed_action") {}
		Lazy< NotImplemented > directive;
    };

    // C++ wrapper for directed_dimensional_location
    struct directed_dimensional_location : dimensional_location, ObjectHelper<directed_dimensional_location,0> { directed_dimensional_location() : Object("directed_dimensional_location") {}

    };

    // C++ wrapper for direction
    struct direction : geometric_representation_item, ObjectHelper<direction,1> { direction() : Object("direction") {}
		ListOf< REAL, 2, 3 >::Out direction_ratios;
    };

    // C++ wrapper for document_file
    struct document_file :  ObjectHelper<document_file,0> { document_file() : Object("document_file") {}

    };

    // C++ wrapper for document_identifier
    struct document_identifier : group, ObjectHelper<document_identifier,0> { document_identifier() : Object("document_identifier") {}

    };

    // C++ wrapper for document_identifier_assignment
    struct document_identifier_assignment : group_assignment, ObjectHelper<document_identifier_assignment,1> { document_identifier_assignment() : Object("document_identifier_assignment") {}
		ListOf< document_identifier_assigned_item, 1, 0 >::Out items;
    };

    // C++ wrapper for document_product_association
    struct document_product_association :  ObjectHelper<document_product_association,4> { document_product_association() : Object("document_product_association") {}
		label::Out name;
		Maybe< text::Out > description;
		Lazy< NotImplemented > relating_document;
		product_or_formation_or_definition::Out related_product;
    };

    // C++ wrapper for document_product_equivalence
    struct document_product_equivalence : document_product_association, ObjectHelper<document_product_equivalence,0> { document_product_equivalence() : Object("document_product_equivalence") {}

    };

    // C++ wrapper for dose_equivalent_measure_with_unit
    struct dose_equivalent_measure_with_unit : measure_with_unit, ObjectHelper<dose_equivalent_measure_with_unit,0> { dose_equivalent_measure_with_unit() : Object("dose_equivalent_measure_with_unit") {}

    };

    // C++ wrapper for dose_equivalent_unit
    struct dose_equivalent_unit : derived_unit, ObjectHelper<dose_equivalent_unit,0> { dose_equivalent_unit() : Object("dose_equivalent_unit") {}

    };

    // C++ wrapper for double_offset_shelled_solid
    struct double_offset_shelled_solid : shelled_solid, ObjectHelper<double_offset_shelled_solid,1> { double_offset_shelled_solid() : Object("double_offset_shelled_solid") {}
		length_measure::Out thickness2;
    };

    // C++ wrapper for item_defined_transformation
    struct item_defined_transformation :  ObjectHelper<item_defined_transformation,4> { item_defined_transformation() : Object("item_defined_transformation") {}
		label::Out name;
		Maybe< text::Out > description;
		Lazy< representation_item > transform_item_1;
		Lazy< representation_item > transform_item_2;
    };

    // C++ wrapper for transformation_with_derived_angle
    struct transformation_with_derived_angle : item_defined_transformation, ObjectHelper<transformation_with_derived_angle,0> { transformation_with_derived_angle() : Object("transformation_with_derived_angle") {}

    };

    // C++ wrapper for draped_defined_transformation
    struct draped_defined_transformation : transformation_with_derived_angle, ObjectHelper<draped_defined_transformation,0> { draped_defined_transformation() : Object("draped_defined_transformation") {}

    };

    // C++ wrapper for draughting_annotation_occurrence
    struct draughting_annotation_occurrence : annotation_occurrence, ObjectHelper<draughting_annotation_occurrence,0> { draughting_annotation_occurrence() : Object("draughting_annotation_occurrence") {}

    };

    // C++ wrapper for draughting_elements
    struct draughting_elements : draughting_callout, ObjectHelper<draughting_elements,0> { draughting_elements() : Object("draughting_elements") {}

    };

    // C++ wrapper for draughting_model
    struct draughting_model : representation, ObjectHelper<draughting_model,0> { draughting_model() : Object("draughting_model") {}

    };

    // C++ wrapper for item_identified_representation_usage
    struct item_identified_representation_usage :  ObjectHelper<item_identified_representation_usage,5> { item_identified_representation_usage() : Object("item_identified_representation_usage") {}
		label::Out name;
		Maybe< text::Out > description;
		represented_definition::Out definition;
		Lazy< representation > used_representation;
		Lazy< representation_item > identified_item;
    };

    // C++ wrapper for draughting_model_item_association
    struct draughting_model_item_association : item_identified_representation_usage, ObjectHelper<draughting_model_item_association,0> { draughting_model_item_association() : Object("draughting_model_item_association") {}

    };

    // C++ wrapper for pre_defined_colour
    struct pre_defined_colour :  ObjectHelper<pre_defined_colour,0> { pre_defined_colour() : Object("pre_defined_colour") {}

    };

    // C++ wrapper for draughting_pre_defined_colour
    struct draughting_pre_defined_colour : pre_defined_colour, ObjectHelper<draughting_pre_defined_colour,0> { draughting_pre_defined_colour() : Object("draughting_pre_defined_colour") {}

    };

    // C++ wrapper for pre_defined_item
    struct pre_defined_item :  ObjectHelper<pre_defined_item,1> { pre_defined_item() : Object("pre_defined_item") {}
		label::Out name;
    };

    // C++ wrapper for pre_defined_curve_font
    struct pre_defined_curve_font : pre_defined_item, ObjectHelper<pre_defined_curve_font,0> { pre_defined_curve_font() : Object("pre_defined_curve_font") {}

    };

    // C++ wrapper for draughting_pre_defined_curve_font
    struct draughting_pre_defined_curve_font : pre_defined_curve_font, ObjectHelper<draughting_pre_defined_curve_font,0> { draughting_pre_defined_curve_font() : Object("draughting_pre_defined_curve_font") {}

    };

    // C++ wrapper for pre_defined_text_font
    struct pre_defined_text_font : pre_defined_item, ObjectHelper<pre_defined_text_font,0> { pre_defined_text_font() : Object("pre_defined_text_font") {}

    };

    // C++ wrapper for draughting_pre_defined_text_font
    struct draughting_pre_defined_text_font : pre_defined_text_font, ObjectHelper<draughting_pre_defined_text_font,0> { draughting_pre_defined_text_font() : Object("draughting_pre_defined_text_font") {}

    };

    // C++ wrapper for draughting_subfigure_representation
    struct draughting_subfigure_representation : symbol_representation, ObjectHelper<draughting_subfigure_representation,0> { draughting_subfigure_representation() : Object("draughting_subfigure_representation") {}

    };

    // C++ wrapper for draughting_symbol_representation
    struct draughting_symbol_representation : symbol_representation, ObjectHelper<draughting_symbol_representation,0> { draughting_symbol_representation() : Object("draughting_symbol_representation") {}

    };

    // C++ wrapper for text_literal
    struct text_literal : geometric_representation_item, ObjectHelper<text_literal,5> { text_literal() : Object("text_literal") {}
		presentable_text::Out literal;
		axis2_placement::Out placement;
		text_alignment::Out alignment;
		text_path::Out path;
		font_select::Out font;
    };

    // C++ wrapper for text_literal_with_delineation
    struct text_literal_with_delineation : text_literal, ObjectHelper<text_literal_with_delineation,1> { text_literal_with_delineation() : Object("text_literal_with_delineation") {}
		text_delineation::Out delineation;
    };

    // C++ wrapper for draughting_text_literal_with_delineation
    struct draughting_text_literal_with_delineation : text_literal_with_delineation, ObjectHelper<draughting_text_literal_with_delineation,0> { draughting_text_literal_with_delineation() : Object("draughting_text_literal_with_delineation") {}

    };

    // C++ wrapper for presentation_set
    struct presentation_set :  ObjectHelper<presentation_set,0> { presentation_set() : Object("presentation_set") {}

    };

    // C++ wrapper for drawing_revision
    struct drawing_revision : presentation_set, ObjectHelper<drawing_revision,3> { drawing_revision() : Object("drawing_revision") {}
		identifier::Out revision_identifier;
		Lazy< NotImplemented > drawing_identifier;
		Maybe< text::Out > intended_scale;
    };

    // C++ wrapper for presentation_representation
    struct presentation_representation : representation, ObjectHelper<presentation_representation,0> { presentation_representation() : Object("presentation_representation") {}

    };

    // C++ wrapper for presentation_area
    struct presentation_area : presentation_representation, ObjectHelper<presentation_area,0> { presentation_area() : Object("presentation_area") {}

    };

    // C++ wrapper for drawing_sheet_revision
    struct drawing_sheet_revision : presentation_area, ObjectHelper<drawing_sheet_revision,1> { drawing_sheet_revision() : Object("drawing_sheet_revision") {}
		identifier::Out revision_identifier;
    };

    // C++ wrapper for drawing_sheet_revision_sequence
    struct drawing_sheet_revision_sequence : representation_relationship, ObjectHelper<drawing_sheet_revision_sequence,0> { drawing_sheet_revision_sequence() : Object("drawing_sheet_revision_sequence") {}

    };

    // C++ wrapper for drawing_sheet_revision_usage
    struct drawing_sheet_revision_usage : area_in_set, ObjectHelper<drawing_sheet_revision_usage,1> { drawing_sheet_revision_usage() : Object("drawing_sheet_revision_usage") {}
		identifier::Out sheet_number;
    };

    // C++ wrapper for edge
    struct edge : topological_representation_item, ObjectHelper<edge,2> { edge() : Object("edge") {}
		Lazy< vertex > edge_start;
		Lazy< vertex > edge_end;
    };

    // C++ wrapper for edge_based_wireframe_model
    struct edge_based_wireframe_model : geometric_representation_item, ObjectHelper<edge_based_wireframe_model,1> { edge_based_wireframe_model() : Object("edge_based_wireframe_model") {}
		ListOf< Lazy< connected_edge_set >, 1, 0 > ebwm_boundary;
    };

    // C++ wrapper for edge_based_wireframe_shape_representation
    struct edge_based_wireframe_shape_representation : shape_representation, ObjectHelper<edge_based_wireframe_shape_representation,0> { edge_based_wireframe_shape_representation() : Object("edge_based_wireframe_shape_representation") {}

    };

    // C++ wrapper for edge_blended_solid
    struct edge_blended_solid : modified_solid, ObjectHelper<edge_blended_solid,1> { edge_blended_solid() : Object("edge_blended_solid") {}
		ListOf< Lazy< edge_curve >, 1, 0 > blended_edges;
    };

    // C++ wrapper for edge_curve
    struct edge_curve :  ObjectHelper<edge_curve,2> { edge_curve() : Object("edge_curve") {}
		Lazy< curve > edge_geometry;
		BOOLEAN::Out same_sense;
    };

    // C++ wrapper for edge_loop
    struct edge_loop :  ObjectHelper<edge_loop,0> { edge_loop() : Object("edge_loop") {}

    };

    // C++ wrapper for electric_charge_measure_with_unit
    struct electric_charge_measure_with_unit : measure_with_unit, ObjectHelper<electric_charge_measure_with_unit,0> { electric_charge_measure_with_unit() : Object("electric_charge_measure_with_unit") {}

    };

    // C++ wrapper for electric_charge_unit
    struct electric_charge_unit : derived_unit, ObjectHelper<electric_charge_unit,0> { electric_charge_unit() : Object("electric_charge_unit") {}

    };

    // C++ wrapper for electric_current_measure_with_unit
    struct electric_current_measure_with_unit : measure_with_unit, ObjectHelper<electric_current_measure_with_unit,0> { electric_current_measure_with_unit() : Object("electric_current_measure_with_unit") {}

    };

    // C++ wrapper for electric_current_unit
    struct electric_current_unit : named_unit, ObjectHelper<electric_current_unit,0> { electric_current_unit() : Object("electric_current_unit") {}

    };

    // C++ wrapper for electric_potential_measure_with_unit
    struct electric_potential_measure_with_unit : measure_with_unit, ObjectHelper<electric_potential_measure_with_unit,0> { electric_potential_measure_with_unit() : Object("electric_potential_measure_with_unit") {}

    };

    // C++ wrapper for electric_potential_unit
    struct electric_potential_unit : derived_unit, ObjectHelper<electric_potential_unit,0> { electric_potential_unit() : Object("electric_potential_unit") {}

    };

    // C++ wrapper for elementary_brep_shape_representation
    struct elementary_brep_shape_representation : shape_representation, ObjectHelper<elementary_brep_shape_representation,0> { elementary_brep_shape_representation() : Object("elementary_brep_shape_representation") {}

    };

    // C++ wrapper for ellipse
    struct ellipse : conic, ObjectHelper<ellipse,2> { ellipse() : Object("ellipse") {}
		positive_length_measure::Out semi_axis_1;
		positive_length_measure::Out semi_axis_2;
    };

    // C++ wrapper for energy_measure_with_unit
    struct energy_measure_with_unit : measure_with_unit, ObjectHelper<energy_measure_with_unit,0> { energy_measure_with_unit() : Object("energy_measure_with_unit") {}

    };

    // C++ wrapper for energy_unit
    struct energy_unit : derived_unit, ObjectHelper<energy_unit,0> { energy_unit() : Object("energy_unit") {}

    };

    // C++ wrapper for property_definition
    struct property_definition :  ObjectHelper<property_definition,3> { property_definition() : Object("property_definition") {}
		label::Out name;
		Maybe< text::Out > description;
		characterized_definition::Out definition;
    };

    // C++ wrapper for fact_type
    struct fact_type : property_definition, ObjectHelper<fact_type,0> { fact_type() : Object("fact_type") {}

    };

    // C++ wrapper for entity_assertion
    struct entity_assertion : fact_type, ObjectHelper<entity_assertion,0> { entity_assertion() : Object("entity_assertion") {}

    };

    // C++ wrapper for enum_reference_prefix
    struct enum_reference_prefix : descriptive_representation_item, ObjectHelper<enum_reference_prefix,0> { enum_reference_prefix() : Object("enum_reference_prefix") {}

    };

    // C++ wrapper for evaluated_characteristic
    struct evaluated_characteristic :  ObjectHelper<evaluated_characteristic,0> { evaluated_characteristic() : Object("evaluated_characteristic") {}

    };

    // C++ wrapper for evaluated_degenerate_pcurve
    struct evaluated_degenerate_pcurve : degenerate_pcurve, ObjectHelper<evaluated_degenerate_pcurve,1> { evaluated_degenerate_pcurve() : Object("evaluated_degenerate_pcurve") {}
		Lazy< cartesian_point > equivalent_point;
    };

    // C++ wrapper for evaluation_product_definition
    struct evaluation_product_definition : product_definition, ObjectHelper<evaluation_product_definition,0> { evaluation_product_definition() : Object("evaluation_product_definition") {}

    };

    // C++ wrapper for event_occurrence
    struct event_occurrence :  ObjectHelper<event_occurrence,3> { event_occurrence() : Object("event_occurrence") {}
		identifier::Out id;
		label::Out name;
		Maybe< text::Out > description;
    };

    // C++ wrapper for product_concept_feature_category
    struct product_concept_feature_category : group, ObjectHelper<product_concept_feature_category,0> { product_concept_feature_category() : Object("product_concept_feature_category") {}

    };

    // C++ wrapper for exclusive_product_concept_feature_category
    struct exclusive_product_concept_feature_category : product_concept_feature_category, ObjectHelper<exclusive_product_concept_feature_category,0> { exclusive_product_concept_feature_category() : Object("exclusive_product_concept_feature_category") {}

    };

    // C++ wrapper for uncertainty_qualifier
    struct uncertainty_qualifier :  ObjectHelper<uncertainty_qualifier,2> { uncertainty_qualifier() : Object("uncertainty_qualifier") {}
		label::Out measure_name;
		text::Out description;
    };

    // C++ wrapper for standard_uncertainty
    struct standard_uncertainty : uncertainty_qualifier, ObjectHelper<standard_uncertainty,1> { standard_uncertainty() : Object("standard_uncertainty") {}
		REAL::Out uncertainty_value;
    };

    // C++ wrapper for expanded_uncertainty
    struct expanded_uncertainty : standard_uncertainty, ObjectHelper<expanded_uncertainty,1> { expanded_uncertainty() : Object("expanded_uncertainty") {}
		REAL::Out coverage_factor;
    };

    // C++ wrapper for representation_item_relationship
    struct representation_item_relationship :  ObjectHelper<representation_item_relationship,4> { representation_item_relationship() : Object("representation_item_relationship") {}
		label::Out name;
		Maybe< text::Out > description;
		Lazy< representation_item > relating_representation_item;
		Lazy< representation_item > related_representation_item;
    };

    // C++ wrapper for explicit_procedural_representation_item_relationship
    struct explicit_procedural_representation_item_relationship : representation_item_relationship, ObjectHelper<explicit_procedural_representation_item_relationship,0> { explicit_procedural_representation_item_relationship() : Object("explicit_procedural_representation_item_relationship") {}

    };

    // C++ wrapper for explicit_procedural_geometric_representation_item_relationship
    struct explicit_procedural_geometric_representation_item_relationship : explicit_procedural_representation_item_relationship, ObjectHelper<explicit_procedural_geometric_representation_item_relationship,0> { explicit_procedural_geometric_representation_item_relationship() : Object("explicit_procedural_geometric_representation_item_relationship") {}

    };

    // C++ wrapper for explicit_procedural_representation_relationship
    struct explicit_procedural_representation_relationship : representation_relationship, ObjectHelper<explicit_procedural_representation_relationship,0> { explicit_procedural_representation_relationship() : Object("explicit_procedural_representation_relationship") {}

    };

    // C++ wrapper for explicit_procedural_shape_representation_relationship
    struct explicit_procedural_shape_representation_relationship : explicit_procedural_representation_relationship, ObjectHelper<explicit_procedural_shape_representation_relationship,0> { explicit_procedural_shape_representation_relationship() : Object("explicit_procedural_shape_representation_relationship") {}

    };

    // C++ wrapper for expression_conversion_based_unit
    struct expression_conversion_based_unit :  ObjectHelper<expression_conversion_based_unit,0> { expression_conversion_based_unit() : Object("expression_conversion_based_unit") {}

    };

    // C++ wrapper for extension
    struct extension : derived_shape_aspect, ObjectHelper<extension,0> { extension() : Object("extension") {}

    };

    // C++ wrapper for extent
    struct extent : characterized_object, ObjectHelper<extent,0> { extent() : Object("extent") {}

    };

    // C++ wrapper for external_source
    struct external_source :  ObjectHelper<external_source,1> { external_source() : Object("external_source") {}
		source_item::Out source_id;
    };

    // C++ wrapper for external_class_library
    struct external_class_library : external_source, ObjectHelper<external_class_library,0> { external_class_library() : Object("external_class_library") {}

    };

    // C++ wrapper for externally_defined_class
    struct externally_defined_class :  ObjectHelper<externally_defined_class,0> { externally_defined_class() : Object("externally_defined_class") {}

    };

    // C++ wrapper for externally_defined_colour
    struct externally_defined_colour :  ObjectHelper<externally_defined_colour,0> { externally_defined_colour() : Object("externally_defined_colour") {}

    };

    // C++ wrapper for externally_defined_context_dependent_unit
    struct externally_defined_context_dependent_unit :  ObjectHelper<externally_defined_context_dependent_unit,0> { externally_defined_context_dependent_unit() : Object("externally_defined_context_dependent_unit") {}

    };

    // C++ wrapper for externally_defined_conversion_based_unit
    struct externally_defined_conversion_based_unit :  ObjectHelper<externally_defined_conversion_based_unit,0> { externally_defined_conversion_based_unit() : Object("externally_defined_conversion_based_unit") {}

    };

    // C++ wrapper for externally_defined_currency
    struct externally_defined_currency :  ObjectHelper<externally_defined_currency,0> { externally_defined_currency() : Object("externally_defined_currency") {}

    };

    // C++ wrapper for externally_defined_item
    struct externally_defined_item :  ObjectHelper<externally_defined_item,2> { externally_defined_item() : Object("externally_defined_item") {}
		source_item::Out item_id;
		Lazy< external_source > source;
    };

    // C++ wrapper for externally_defined_curve_font
    struct externally_defined_curve_font : externally_defined_item, ObjectHelper<externally_defined_curve_font,0> { externally_defined_curve_font() : Object("externally_defined_curve_font") {}

    };

    // C++ wrapper for externally_defined_dimension_definition
    struct externally_defined_dimension_definition :  ObjectHelper<externally_defined_dimension_definition,0> { externally_defined_dimension_definition() : Object("externally_defined_dimension_definition") {}

    };

    // C++ wrapper for externally_defined_general_property
    struct externally_defined_general_property :  ObjectHelper<externally_defined_general_property,0> { externally_defined_general_property() : Object("externally_defined_general_property") {}

    };

    // C++ wrapper for externally_defined_hatch_style
    struct externally_defined_hatch_style :  ObjectHelper<externally_defined_hatch_style,0> { externally_defined_hatch_style() : Object("externally_defined_hatch_style") {}

    };

    // C++ wrapper for externally_defined_marker
    struct externally_defined_marker :  ObjectHelper<externally_defined_marker,0> { externally_defined_marker() : Object("externally_defined_marker") {}

    };

    // C++ wrapper for picture_representation_item
    struct picture_representation_item : bytes_representation_item, ObjectHelper<picture_representation_item,0> { picture_representation_item() : Object("picture_representation_item") {}

    };

    // C++ wrapper for externally_defined_picture_representation_item
    struct externally_defined_picture_representation_item : picture_representation_item, ObjectHelper<externally_defined_picture_representation_item,0> { externally_defined_picture_representation_item() : Object("externally_defined_picture_representation_item") {}

    };

    // C++ wrapper for externally_defined_representation_item
    struct externally_defined_representation_item :  ObjectHelper<externally_defined_representation_item,0> { externally_defined_representation_item() : Object("externally_defined_representation_item") {}

    };

    // C++ wrapper for externally_defined_string
    struct externally_defined_string : externally_defined_representation_item, ObjectHelper<externally_defined_string,0> { externally_defined_string() : Object("externally_defined_string") {}

    };

    // C++ wrapper for externally_defined_symbol
    struct externally_defined_symbol : externally_defined_item, ObjectHelper<externally_defined_symbol,0> { externally_defined_symbol() : Object("externally_defined_symbol") {}

    };

    // C++ wrapper for externally_defined_terminator_symbol
    struct externally_defined_terminator_symbol : externally_defined_symbol, ObjectHelper<externally_defined_terminator_symbol,0> { externally_defined_terminator_symbol() : Object("externally_defined_terminator_symbol") {}

    };

    // C++ wrapper for externally_defined_text_font
    struct externally_defined_text_font : externally_defined_item, ObjectHelper<externally_defined_text_font,0> { externally_defined_text_font() : Object("externally_defined_text_font") {}

    };

    // C++ wrapper for externally_defined_tile
    struct externally_defined_tile : externally_defined_item, ObjectHelper<externally_defined_tile,0> { externally_defined_tile() : Object("externally_defined_tile") {}

    };

    // C++ wrapper for externally_defined_tile_style
    struct externally_defined_tile_style :  ObjectHelper<externally_defined_tile_style,0> { externally_defined_tile_style() : Object("externally_defined_tile_style") {}

    };

    // C++ wrapper for swept_area_solid
    struct swept_area_solid : solid_model, ObjectHelper<swept_area_solid,1> { swept_area_solid() : Object("swept_area_solid") {}
		Lazy< curve_bounded_surface > swept_area;
    };

    // C++ wrapper for extruded_area_solid
    struct extruded_area_solid : swept_area_solid, ObjectHelper<extruded_area_solid,2> { extruded_area_solid() : Object("extruded_area_solid") {}
		Lazy< direction > extruded_direction;
		positive_length_measure::Out depth;
    };

    // C++ wrapper for swept_face_solid
    struct swept_face_solid : solid_model, ObjectHelper<swept_face_solid,1> { swept_face_solid() : Object("swept_face_solid") {}
		Lazy< face_surface > swept_face;
    };

    // C++ wrapper for extruded_face_solid
    struct extruded_face_solid : swept_face_solid, ObjectHelper<extruded_face_solid,2> { extruded_face_solid() : Object("extruded_face_solid") {}
		Lazy< direction > extruded_direction;
		positive_length_measure::Out depth;
    };

    // C++ wrapper for extruded_face_solid_with_trim_conditions
    struct extruded_face_solid_with_trim_conditions : extruded_face_solid, ObjectHelper<extruded_face_solid_with_trim_conditions,6> { extruded_face_solid_with_trim_conditions() : Object("extruded_face_solid_with_trim_conditions") {}
		trim_condition_select::Out first_trim_condition;
		trim_condition_select::Out second_trim_condition;
		trim_intent::Out first_trim_intent;
		trim_intent::Out second_trim_intent;
		non_negative_length_measure::Out first_offset;
		non_negative_length_measure::Out second_offset;
    };

    // C++ wrapper for extruded_face_solid_with_draft_angle
    struct extruded_face_solid_with_draft_angle : extruded_face_solid_with_trim_conditions, ObjectHelper<extruded_face_solid_with_draft_angle,1> { extruded_face_solid_with_draft_angle() : Object("extruded_face_solid_with_draft_angle") {}
		plane_angle_measure::Out draft_angle;
    };

    // C++ wrapper for extruded_face_solid_with_multiple_draft_angles
    struct extruded_face_solid_with_multiple_draft_angles : extruded_face_solid_with_trim_conditions, ObjectHelper<extruded_face_solid_with_multiple_draft_angles,1> { extruded_face_solid_with_multiple_draft_angles() : Object("extruded_face_solid_with_multiple_draft_angles") {}
		ListOf< plane_angle_measure, 2, 0 >::Out draft_angles;
    };

    // C++ wrapper for face
    struct face : topological_representation_item, ObjectHelper<face,1> { face() : Object("face") {}
		ListOf< Lazy< face_bound >, 1, 0 > bounds;
    };

    // C++ wrapper for face_based_surface_model
    struct face_based_surface_model : geometric_representation_item, ObjectHelper<face_based_surface_model,1> { face_based_surface_model() : Object("face_based_surface_model") {}
		ListOf< Lazy< connected_face_set >, 1, 0 > fbsm_faces;
    };

    // C++ wrapper for face_bound
    struct face_bound : topological_representation_item, ObjectHelper<face_bound,2> { face_bound() : Object("face_bound") {}
		Lazy< loop > bound;
		BOOLEAN::Out orientation;
    };

    // C++ wrapper for face_outer_bound
    struct face_outer_bound : face_bound, ObjectHelper<face_outer_bound,0> { face_outer_bound() : Object("face_outer_bound") {}

    };

    // C++ wrapper for faceted_brep
    struct faceted_brep : manifold_solid_brep, ObjectHelper<faceted_brep,0> { faceted_brep() : Object("faceted_brep") {}

    };

    // C++ wrapper for faceted_brep_shape_representation
    struct faceted_brep_shape_representation : shape_representation, ObjectHelper<faceted_brep_shape_representation,0> { faceted_brep_shape_representation() : Object("faceted_brep_shape_representation") {}

    };

    // C++ wrapper for fill_area_style
    struct fill_area_style : founded_item, ObjectHelper<fill_area_style,2> { fill_area_style() : Object("fill_area_style") {}
		label::Out name;
		ListOf< fill_style_select, 1, 0 >::Out fill_styles;
    };

    // C++ wrapper for fill_area_style_hatching
    struct fill_area_style_hatching : geometric_representation_item, ObjectHelper<fill_area_style_hatching,5> { fill_area_style_hatching() : Object("fill_area_style_hatching") {}
		Lazy< curve_style > hatch_line_appearance;
		Lazy< one_direction_repeat_factor > start_of_next_hatch_line;
		Lazy< cartesian_point > point_of_reference_hatch_line;
		Lazy< cartesian_point > pattern_start;
		plane_angle_measure::Out hatch_line_angle;
    };

    // C++ wrapper for fill_area_style_tile_coloured_region
    struct fill_area_style_tile_coloured_region : geometric_representation_item, ObjectHelper<fill_area_style_tile_coloured_region,2> { fill_area_style_tile_coloured_region() : Object("fill_area_style_tile_coloured_region") {}
		curve_or_annotation_curve_occurrence::Out closed_curve;
		Lazy< colour > region_colour;
    };

    // C++ wrapper for fill_area_style_tile_curve_with_style
    struct fill_area_style_tile_curve_with_style : geometric_representation_item, ObjectHelper<fill_area_style_tile_curve_with_style,1> { fill_area_style_tile_curve_with_style() : Object("fill_area_style_tile_curve_with_style") {}
		Lazy< annotation_curve_occurrence > styled_curve;
    };

    // C++ wrapper for fill_area_style_tile_symbol_with_style
    struct fill_area_style_tile_symbol_with_style : geometric_representation_item, ObjectHelper<fill_area_style_tile_symbol_with_style,1> { fill_area_style_tile_symbol_with_style() : Object("fill_area_style_tile_symbol_with_style") {}
		Lazy< annotation_symbol_occurrence > symbol;
    };

    // C++ wrapper for fill_area_style_tiles
    struct fill_area_style_tiles : geometric_representation_item, ObjectHelper<fill_area_style_tiles,3> { fill_area_style_tiles() : Object("fill_area_style_tiles") {}
		Lazy< two_direction_repeat_factor > tiling_pattern;
		ListOf< fill_area_style_tile_shape_select, 1, 0 >::Out tiles;
		positive_ratio_measure::Out tiling_scale;
    };

    // C++ wrapper for shape_representation_relationship
    struct shape_representation_relationship : representation_relationship, ObjectHelper<shape_representation_relationship,0> { shape_representation_relationship() : Object("shape_representation_relationship") {}

    };

    // C++ wrapper for flat_pattern_ply_representation_relationship
    struct flat_pattern_ply_representation_relationship : shape_representation_relationship, ObjectHelper<flat_pattern_ply_representation_relationship,0> { flat_pattern_ply_representation_relationship() : Object("flat_pattern_ply_representation_relationship") {}

    };

    // C++ wrapper for flatness_tolerance
    struct flatness_tolerance : geometric_tolerance, ObjectHelper<flatness_tolerance,0> { flatness_tolerance() : Object("flatness_tolerance") {}

    };

    // C++ wrapper for force_measure_with_unit
    struct force_measure_with_unit : measure_with_unit, ObjectHelper<force_measure_with_unit,0> { force_measure_with_unit() : Object("force_measure_with_unit") {}

    };

    // C++ wrapper for force_unit
    struct force_unit : derived_unit, ObjectHelper<force_unit,0> { force_unit() : Object("force_unit") {}

    };

    // C++ wrapper for forward_chaining_rule
    struct forward_chaining_rule : rule_definition, ObjectHelper<forward_chaining_rule,0> { forward_chaining_rule() : Object("forward_chaining_rule") {}

    };

    // C++ wrapper for forward_chaining_rule_premise
    struct forward_chaining_rule_premise :  ObjectHelper<forward_chaining_rule_premise,0> { forward_chaining_rule_premise() : Object("forward_chaining_rule_premise") {}

    };

    // C++ wrapper for frequency_measure_with_unit
    struct frequency_measure_with_unit : measure_with_unit, ObjectHelper<frequency_measure_with_unit,0> { frequency_measure_with_unit() : Object("frequency_measure_with_unit") {}

    };

    // C++ wrapper for frequency_unit
    struct frequency_unit : derived_unit, ObjectHelper<frequency_unit,0> { frequency_unit() : Object("frequency_unit") {}

    };

    // C++ wrapper for func
    struct func : compound_representation_item, ObjectHelper<func,0> { func() : Object("func") {}

    };

    // C++ wrapper for functional_breakdown_context
    struct functional_breakdown_context : breakdown_context, ObjectHelper<functional_breakdown_context,0> { functional_breakdown_context() : Object("functional_breakdown_context") {}

    };

    // C++ wrapper for functional_element_usage
    struct functional_element_usage : breakdown_element_usage, ObjectHelper<functional_element_usage,0> { functional_element_usage() : Object("functional_element_usage") {}

    };

    // C++ wrapper for general_material_property
    struct general_material_property : general_property, ObjectHelper<general_material_property,0> { general_material_property() : Object("general_material_property") {}

    };

    // C++ wrapper for simple_generic_expression
    struct simple_generic_expression : generic_expression, ObjectHelper<simple_generic_expression,0> { simple_generic_expression() : Object("simple_generic_expression") {}

    };

    // C++ wrapper for generic_literal
    struct generic_literal : simple_generic_expression, ObjectHelper<generic_literal,0> { generic_literal() : Object("generic_literal") {}

    };

    // C++ wrapper for generic_variable
    struct generic_variable : simple_generic_expression, ObjectHelper<generic_variable,0> { generic_variable() : Object("generic_variable") {}

    };

    // C++ wrapper for geometric_alignment
    struct geometric_alignment : derived_shape_aspect, ObjectHelper<geometric_alignment,0> { geometric_alignment() : Object("geometric_alignment") {}

    };

    // C++ wrapper for geometric_set
    struct geometric_set : geometric_representation_item, ObjectHelper<geometric_set,1> { geometric_set() : Object("geometric_set") {}
		ListOf< geometric_set_select, 1, 0 >::Out elements;
    };

    // C++ wrapper for geometric_curve_set
    struct geometric_curve_set : geometric_set, ObjectHelper<geometric_curve_set,0> { geometric_curve_set() : Object("geometric_curve_set") {}

    };

    // C++ wrapper for geometric_intersection
    struct geometric_intersection : derived_shape_aspect, ObjectHelper<geometric_intersection,0> { geometric_intersection() : Object("geometric_intersection") {}

    };

    // C++ wrapper for geometric_item_specific_usage
    struct geometric_item_specific_usage : item_identified_representation_usage, ObjectHelper<geometric_item_specific_usage,0> { geometric_item_specific_usage() : Object("geometric_item_specific_usage") {}

    };

    // C++ wrapper for geometric_model_element_relationship
    struct geometric_model_element_relationship :  ObjectHelper<geometric_model_element_relationship,0> { geometric_model_element_relationship() : Object("geometric_model_element_relationship") {}

    };

    // C++ wrapper for representation_context
    struct representation_context :  ObjectHelper<representation_context,2> { representation_context() : Object("representation_context") {}
		identifier::Out context_identifier;
		text::Out context_type;
    };

    // C++ wrapper for geometric_representation_context
    struct geometric_representation_context : representation_context, ObjectHelper<geometric_representation_context,1> { geometric_representation_context() : Object("geometric_representation_context") {}
		dimension_count::Out coordinate_space_dimension;
    };

    // C++ wrapper for geometric_tolerance_with_defined_unit
    struct geometric_tolerance_with_defined_unit : geometric_tolerance, ObjectHelper<geometric_tolerance_with_defined_unit,1> { geometric_tolerance_with_defined_unit() : Object("geometric_tolerance_with_defined_unit") {}
		Lazy< measure_with_unit > unit_size;
    };

    // C++ wrapper for geometrical_tolerance_callout
    struct geometrical_tolerance_callout : draughting_callout, ObjectHelper<geometrical_tolerance_callout,0> { geometrical_tolerance_callout() : Object("geometrical_tolerance_callout") {}

    };

    // C++ wrapper for geometrically_bounded_2d_wireframe_representation
    struct geometrically_bounded_2d_wireframe_representation : shape_representation, ObjectHelper<geometrically_bounded_2d_wireframe_representation,0> { geometrically_bounded_2d_wireframe_representation() : Object("geometrically_bounded_2d_wireframe_representation") {}

    };

    // C++ wrapper for geometrically_bounded_surface_shape_representation
    struct geometrically_bounded_surface_shape_representation : shape_representation, ObjectHelper<geometrically_bounded_surface_shape_representation,0> { geometrically_bounded_surface_shape_representation() : Object("geometrically_bounded_surface_shape_representation") {}

    };

    // C++ wrapper for geometrically_bounded_wireframe_shape_representation
    struct geometrically_bounded_wireframe_shape_representation : shape_representation, ObjectHelper<geometrically_bounded_wireframe_shape_representation,0> { geometrically_bounded_wireframe_shape_representation() : Object("geometrically_bounded_wireframe_shape_representation") {}

    };

    // C++ wrapper for global_assignment
    struct global_assignment : representation_item_relationship, ObjectHelper<global_assignment,0> { global_assignment() : Object("global_assignment") {}

    };

    // C++ wrapper for global_uncertainty_assigned_context
    struct global_uncertainty_assigned_context : representation_context, ObjectHelper<global_uncertainty_assigned_context,1> { global_uncertainty_assigned_context() : Object("global_uncertainty_assigned_context") {}
		ListOf< Lazy< uncertainty_measure_with_unit >, 1, 0 > uncertainty;
    };

    // C++ wrapper for global_unit_assigned_context
    struct global_unit_assigned_context : representation_context, ObjectHelper<global_unit_assigned_context,1> { global_unit_assigned_context() : Object("global_unit_assigned_context") {}
		ListOf< unit, 1, 0 >::Out units;
    };

    // C++ wrapper for ground_fact
    struct ground_fact : atomic_formula, ObjectHelper<ground_fact,0> { ground_fact() : Object("ground_fact") {}

    };

    // C++ wrapper for hardness_representation
    struct hardness_representation : representation, ObjectHelper<hardness_representation,0> { hardness_representation() : Object("hardness_representation") {}

    };

    // C++ wrapper for hidden_element_over_riding_styled_item
    struct hidden_element_over_riding_styled_item : context_dependent_over_riding_styled_item, ObjectHelper<hidden_element_over_riding_styled_item,0> { hidden_element_over_riding_styled_item() : Object("hidden_element_over_riding_styled_item") {}

    };

    // C++ wrapper for hyperbola
    struct hyperbola : conic, ObjectHelper<hyperbola,2> { hyperbola() : Object("hyperbola") {}
		positive_length_measure::Out semi_axis;
		positive_length_measure::Out semi_imag_axis;
    };

    // C++ wrapper for illuminance_measure_with_unit
    struct illuminance_measure_with_unit : measure_with_unit, ObjectHelper<illuminance_measure_with_unit,0> { illuminance_measure_with_unit() : Object("illuminance_measure_with_unit") {}

    };

    // C++ wrapper for illuminance_unit
    struct illuminance_unit : derived_unit, ObjectHelper<illuminance_unit,0> { illuminance_unit() : Object("illuminance_unit") {}

    };

    // C++ wrapper for included_text_block
    struct included_text_block : mapped_item, ObjectHelper<included_text_block,0> { included_text_block() : Object("included_text_block") {}

    };

    // C++ wrapper for inclusion_product_concept_feature
    struct inclusion_product_concept_feature : conditional_concept_feature, ObjectHelper<inclusion_product_concept_feature,0> { inclusion_product_concept_feature() : Object("inclusion_product_concept_feature") {}

    };

    // C++ wrapper for user_selected_elements
    struct user_selected_elements : representation_item, ObjectHelper<user_selected_elements,1> { user_selected_elements() : Object("user_selected_elements") {}
		ListOf< Lazy< representation_item >, 1, 0 > picked_items;
    };

    // C++ wrapper for indirectly_selected_elements
    struct indirectly_selected_elements : user_selected_elements, ObjectHelper<indirectly_selected_elements,1> { indirectly_selected_elements() : Object("indirectly_selected_elements") {}
		ListOf< Lazy< representation_item >, 1, 0 > indirectly_picked_items;
    };

    // C++ wrapper for indirectly_selected_shape_elements
    struct indirectly_selected_shape_elements :  ObjectHelper<indirectly_selected_shape_elements,0> { indirectly_selected_shape_elements() : Object("indirectly_selected_shape_elements") {}

    };

    // C++ wrapper for inductance_measure_with_unit
    struct inductance_measure_with_unit : measure_with_unit, ObjectHelper<inductance_measure_with_unit,0> { inductance_measure_with_unit() : Object("inductance_measure_with_unit") {}

    };

    // C++ wrapper for inductance_unit
    struct inductance_unit : derived_unit, ObjectHelper<inductance_unit,0> { inductance_unit() : Object("inductance_unit") {}

    };

    // C++ wrapper for information_right
    struct information_right : action_method, ObjectHelper<information_right,0> { information_right() : Object("information_right") {}

    };

    // C++ wrapper for information_usage_right
    struct information_usage_right : action_method, ObjectHelper<information_usage_right,0> { information_usage_right() : Object("information_usage_right") {}

    };

    // C++ wrapper for instance_usage_context_assignment
    struct instance_usage_context_assignment : product_definition_context, ObjectHelper<instance_usage_context_assignment,1> { instance_usage_context_assignment() : Object("instance_usage_context_assignment") {}
		ListOf< instance_usage_context_select, 1, 0 >::Out items;
    };

    // C++ wrapper for instanced_feature
    struct instanced_feature :  ObjectHelper<instanced_feature,0> { instanced_feature() : Object("instanced_feature") {}

    };

    // C++ wrapper for literal_number
    struct literal_number :  ObjectHelper<literal_number,1> { literal_number() : Object("literal_number") {}
		NUMBER::Out the_value;
    };

    // C++ wrapper for int_literal
    struct int_literal : literal_number, ObjectHelper<int_literal,0> { int_literal() : Object("int_literal") {}

    };

    // C++ wrapper for integer_representation_item
    struct integer_representation_item :  ObjectHelper<integer_representation_item,0> { integer_representation_item() : Object("integer_representation_item") {}

    };

    // C++ wrapper for surface_curve
    struct surface_curve : curve, ObjectHelper<surface_curve,3> { surface_curve() : Object("surface_curve") {}
		Lazy< curve > curve_3d;
		ListOf< pcurve_or_surface, 1, 2 >::Out associated_geometry;
		preferred_surface_curve_representation::Out master_representation;
    };

    // C++ wrapper for intersection_curve
    struct intersection_curve : surface_curve, ObjectHelper<intersection_curve,0> { intersection_curve() : Object("intersection_curve") {}

    };

    // C++ wrapper for interval_expression
    struct interval_expression :  ObjectHelper<interval_expression,0> { interval_expression() : Object("interval_expression") {}

    };

    // C++ wrapper for iso4217_currency
    struct iso4217_currency : currency, ObjectHelper<iso4217_currency,0> { iso4217_currency() : Object("iso4217_currency") {}

    };

    // C++ wrapper for known_source
    struct known_source :  ObjectHelper<known_source,0> { known_source() : Object("known_source") {}

    };

    // C++ wrapper for laid_defined_transformation
    struct laid_defined_transformation : transformation_with_derived_angle, ObjectHelper<laid_defined_transformation,0> { laid_defined_transformation() : Object("laid_defined_transformation") {}

    };

    // C++ wrapper for language
    struct language : group, ObjectHelper<language,0> { language() : Object("language") {}

    };

    // C++ wrapper for leader_curve
    struct leader_curve : annotation_curve_occurrence, ObjectHelper<leader_curve,0> { leader_curve() : Object("leader_curve") {}

    };

    // C++ wrapper for leader_directed_callout
    struct leader_directed_callout : draughting_callout, ObjectHelper<leader_directed_callout,0> { leader_directed_callout() : Object("leader_directed_callout") {}

    };

    // C++ wrapper for leader_directed_dimension
    struct leader_directed_dimension : leader_directed_callout, ObjectHelper<leader_directed_dimension,0> { leader_directed_dimension() : Object("leader_directed_dimension") {}

    };

    // C++ wrapper for leader_terminator
    struct leader_terminator : terminator_symbol, ObjectHelper<leader_terminator,0> { leader_terminator() : Object("leader_terminator") {}

    };

    // C++ wrapper for length_measure_with_unit
    struct length_measure_with_unit : measure_with_unit, ObjectHelper<length_measure_with_unit,0> { length_measure_with_unit() : Object("length_measure_with_unit") {}

    };

    // C++ wrapper for length_unit
    struct length_unit : named_unit, ObjectHelper<length_unit,0> { length_unit() : Object("length_unit") {}

    };

    // C++ wrapper for light_source
    struct light_source : geometric_representation_item, ObjectHelper<light_source,1> { light_source() : Object("light_source") {}
		Lazy< colour > light_colour;
    };

    // C++ wrapper for light_source_ambient
    struct light_source_ambient : light_source, ObjectHelper<light_source_ambient,0> { light_source_ambient() : Object("light_source_ambient") {}

    };

    // C++ wrapper for light_source_directional
    struct light_source_directional : light_source, ObjectHelper<light_source_directional,1> { light_source_directional() : Object("light_source_directional") {}
		Lazy< direction > orientation;
    };

    // C++ wrapper for light_source_positional
    struct light_source_positional : light_source, ObjectHelper<light_source_positional,3> { light_source_positional() : Object("light_source_positional") {}
		Lazy< cartesian_point > position;
		REAL::Out constant_attenuation;
		REAL::Out distance_attenuation;
    };

    // C++ wrapper for light_source_spot
    struct light_source_spot : light_source, ObjectHelper<light_source_spot,6> { light_source_spot() : Object("light_source_spot") {}
		Lazy< cartesian_point > position;
		Lazy< direction > orientation;
		REAL::Out concentration_exponent;
		REAL::Out constant_attenuation;
		REAL::Out distance_attenuation;
		positive_plane_angle_measure::Out spread_angle;
    };

    // C++ wrapper for line
    struct line : curve, ObjectHelper<line,2> { line() : Object("line") {}
		Lazy< cartesian_point > pnt;
		Lazy< vector > dir;
    };

    // C++ wrapper for line_profile_tolerance
    struct line_profile_tolerance : geometric_tolerance, ObjectHelper<line_profile_tolerance,0> { line_profile_tolerance() : Object("line_profile_tolerance") {}

    };

    // C++ wrapper for linear_dimension
    struct linear_dimension : dimension_curve_directed_callout, ObjectHelper<linear_dimension,0> { linear_dimension() : Object("linear_dimension") {}

    };

    // C++ wrapper for simple_clause
    struct simple_clause : compound_representation_item, ObjectHelper<simple_clause,0> { simple_clause() : Object("simple_clause") {}

    };

    // C++ wrapper for literal_conjunction
    struct literal_conjunction : simple_clause, ObjectHelper<literal_conjunction,0> { literal_conjunction() : Object("literal_conjunction") {}

    };

    // C++ wrapper for literal_disjunction
    struct literal_disjunction : simple_clause, ObjectHelper<literal_disjunction,0> { literal_disjunction() : Object("literal_disjunction") {}

    };

    // C++ wrapper for logical_literal
    struct logical_literal : generic_literal, ObjectHelper<logical_literal,1> { logical_literal() : Object("logical_literal") {}
		LOGICAL::Out lit_value;
    };

    // C++ wrapper for logical_representation_item
    struct logical_representation_item :  ObjectHelper<logical_representation_item,0> { logical_representation_item() : Object("logical_representation_item") {}

    };

    // C++ wrapper for loop
    struct loop : topological_representation_item, ObjectHelper<loop,0> { loop() : Object("loop") {}

    };

    // C++ wrapper for loss_tangent_measure_with_unit
    struct loss_tangent_measure_with_unit : ratio_measure_with_unit, ObjectHelper<loss_tangent_measure_with_unit,0> { loss_tangent_measure_with_unit() : Object("loss_tangent_measure_with_unit") {}

    };

    // C++ wrapper for lot_effectivity
    struct lot_effectivity : effectivity, ObjectHelper<lot_effectivity,2> { lot_effectivity() : Object("lot_effectivity") {}
		identifier::Out effectivity_lot_id;
		Lazy< measure_with_unit > effectivity_lot_size;
    };

    // C++ wrapper for luminous_flux_measure_with_unit
    struct luminous_flux_measure_with_unit : measure_with_unit, ObjectHelper<luminous_flux_measure_with_unit,0> { luminous_flux_measure_with_unit() : Object("luminous_flux_measure_with_unit") {}

    };

    // C++ wrapper for luminous_flux_unit
    struct luminous_flux_unit : named_unit, ObjectHelper<luminous_flux_unit,0> { luminous_flux_unit() : Object("luminous_flux_unit") {}

    };

    // C++ wrapper for luminous_intensity_measure_with_unit
    struct luminous_intensity_measure_with_unit : measure_with_unit, ObjectHelper<luminous_intensity_measure_with_unit,0> { luminous_intensity_measure_with_unit() : Object("luminous_intensity_measure_with_unit") {}

    };

    // C++ wrapper for luminous_intensity_unit
    struct luminous_intensity_unit : named_unit, ObjectHelper<luminous_intensity_unit,0> { luminous_intensity_unit() : Object("luminous_intensity_unit") {}

    };

    // C++ wrapper for magnetic_flux_density_measure_with_unit
    struct magnetic_flux_density_measure_with_unit : measure_with_unit, ObjectHelper<magnetic_flux_density_measure_with_unit,0> { magnetic_flux_density_measure_with_unit() : Object("magnetic_flux_density_measure_with_unit") {}

    };

    // C++ wrapper for magnetic_flux_density_unit
    struct magnetic_flux_density_unit : derived_unit, ObjectHelper<magnetic_flux_density_unit,0> { magnetic_flux_density_unit() : Object("magnetic_flux_density_unit") {}

    };

    // C++ wrapper for magnetic_flux_measure_with_unit
    struct magnetic_flux_measure_with_unit : measure_with_unit, ObjectHelper<magnetic_flux_measure_with_unit,0> { magnetic_flux_measure_with_unit() : Object("magnetic_flux_measure_with_unit") {}

    };

    // C++ wrapper for magnetic_flux_unit
    struct magnetic_flux_unit : derived_unit, ObjectHelper<magnetic_flux_unit,0> { magnetic_flux_unit() : Object("magnetic_flux_unit") {}

    };

    // C++ wrapper for make_from_usage_option
    struct make_from_usage_option : product_definition_usage, ObjectHelper<make_from_usage_option,3> { make_from_usage_option() : Object("make_from_usage_option") {}
		INTEGER::Out ranking;
		text::Out ranking_rationale;
		Lazy< measure_with_unit > quantity;
    };

    // C++ wrapper for manifold_subsurface_shape_representation
    struct manifold_subsurface_shape_representation : shape_representation, ObjectHelper<manifold_subsurface_shape_representation,0> { manifold_subsurface_shape_representation() : Object("manifold_subsurface_shape_representation") {}

    };

    // C++ wrapper for manifold_surface_shape_representation
    struct manifold_surface_shape_representation : shape_representation, ObjectHelper<manifold_surface_shape_representation,0> { manifold_surface_shape_representation() : Object("manifold_surface_shape_representation") {}

    };

    // C++ wrapper for mass_measure_with_unit
    struct mass_measure_with_unit : measure_with_unit, ObjectHelper<mass_measure_with_unit,0> { mass_measure_with_unit() : Object("mass_measure_with_unit") {}

    };

    // C++ wrapper for mass_unit
    struct mass_unit : named_unit, ObjectHelper<mass_unit,0> { mass_unit() : Object("mass_unit") {}

    };

    // C++ wrapper for material_property
    struct material_property : property_definition, ObjectHelper<material_property,0> { material_property() : Object("material_property") {}

    };

    // C++ wrapper for property_definition_representation
    struct property_definition_representation :  ObjectHelper<property_definition_representation,2> { property_definition_representation() : Object("property_definition_representation") {}
		represented_definition::Out definition;
		Lazy< representation > used_representation;
    };

    // C++ wrapper for material_property_representation
    struct material_property_representation : property_definition_representation, ObjectHelper<material_property_representation,1> { material_property_representation() : Object("material_property_representation") {}
		Lazy< NotImplemented > dependent_environment;
    };

    // C++ wrapper for measure_representation_item
    struct measure_representation_item :  ObjectHelper<measure_representation_item,0> { measure_representation_item() : Object("measure_representation_item") {}

    };

    // C++ wrapper for product_context
    struct product_context : application_context_element, ObjectHelper<product_context,1> { product_context() : Object("product_context") {}
		label::Out discipline_type;
    };

    // C++ wrapper for mechanical_context
    struct mechanical_context : product_context, ObjectHelper<mechanical_context,0> { mechanical_context() : Object("mechanical_context") {}

    };

    // C++ wrapper for mechanical_design_and_draughting_relationship
    struct mechanical_design_and_draughting_relationship : definitional_representation_relationship_with_same_context, ObjectHelper<mechanical_design_and_draughting_relationship,0> { mechanical_design_and_draughting_relationship() : Object("mechanical_design_and_draughting_relationship") {}

    };

    // C++ wrapper for mechanical_design_geometric_presentation_area
    struct mechanical_design_geometric_presentation_area : presentation_area, ObjectHelper<mechanical_design_geometric_presentation_area,0> { mechanical_design_geometric_presentation_area() : Object("mechanical_design_geometric_presentation_area") {}

    };

    // C++ wrapper for mechanical_design_geometric_presentation_representation
    struct mechanical_design_geometric_presentation_representation : representation, ObjectHelper<mechanical_design_geometric_presentation_representation,0> { mechanical_design_geometric_presentation_representation() : Object("mechanical_design_geometric_presentation_representation") {}

    };

    // C++ wrapper for mechanical_design_presentation_representation_with_draughting
    struct mechanical_design_presentation_representation_with_draughting : representation, ObjectHelper<mechanical_design_presentation_representation_with_draughting,0> { mechanical_design_presentation_representation_with_draughting() : Object("mechanical_design_presentation_representation_with_draughting") {}

    };

    // C++ wrapper for mechanical_design_shaded_presentation_area
    struct mechanical_design_shaded_presentation_area : presentation_area, ObjectHelper<mechanical_design_shaded_presentation_area,0> { mechanical_design_shaded_presentation_area() : Object("mechanical_design_shaded_presentation_area") {}

    };

    // C++ wrapper for mechanical_design_shaded_presentation_representation
    struct mechanical_design_shaded_presentation_representation : representation, ObjectHelper<mechanical_design_shaded_presentation_representation,0> { mechanical_design_shaded_presentation_representation() : Object("mechanical_design_shaded_presentation_representation") {}

    };

    // C++ wrapper for min_and_major_ply_orientation_basis
    struct min_and_major_ply_orientation_basis :  ObjectHelper<min_and_major_ply_orientation_basis,0> { min_and_major_ply_orientation_basis() : Object("min_and_major_ply_orientation_basis") {}

    };

    // C++ wrapper for modified_geometric_tolerance
    struct modified_geometric_tolerance : geometric_tolerance, ObjectHelper<modified_geometric_tolerance,1> { modified_geometric_tolerance() : Object("modified_geometric_tolerance") {}
		limit_condition::Out modifier;
    };

    // C++ wrapper for modified_solid_with_placed_configuration
    struct modified_solid_with_placed_configuration : modified_solid, ObjectHelper<modified_solid_with_placed_configuration,1> { modified_solid_with_placed_configuration() : Object("modified_solid_with_placed_configuration") {}
		Lazy< axis2_placement_3d > placing;
    };

    // C++ wrapper for moments_of_inertia_representation
    struct moments_of_inertia_representation : representation, ObjectHelper<moments_of_inertia_representation,0> { moments_of_inertia_representation() : Object("moments_of_inertia_representation") {}

    };

    // C++ wrapper for multi_language_attribute_assignment
    struct multi_language_attribute_assignment : attribute_value_assignment, ObjectHelper<multi_language_attribute_assignment,1> { multi_language_attribute_assignment() : Object("multi_language_attribute_assignment") {}
		ListOf< multi_language_attribute_item, 1, 0 >::Out items;
    };

    // C++ wrapper for multiple_arity_boolean_expression
    struct multiple_arity_boolean_expression :  ObjectHelper<multiple_arity_boolean_expression,0> { multiple_arity_boolean_expression() : Object("multiple_arity_boolean_expression") {}

    };

    // C++ wrapper for multiple_arity_generic_expression
    struct multiple_arity_generic_expression : generic_expression, ObjectHelper<multiple_arity_generic_expression,1> { multiple_arity_generic_expression() : Object("multiple_arity_generic_expression") {}
		ListOf< Lazy< generic_expression >, 2, 0 > operands;
    };

    // C++ wrapper for multiple_arity_numeric_expression
    struct multiple_arity_numeric_expression :  ObjectHelper<multiple_arity_numeric_expression,0> { multiple_arity_numeric_expression() : Object("multiple_arity_numeric_expression") {}

    };

    // C++ wrapper for next_assembly_usage_occurrence
    struct next_assembly_usage_occurrence : assembly_component_usage, ObjectHelper<next_assembly_usage_occurrence,0> { next_assembly_usage_occurrence() : Object("next_assembly_usage_occurrence") {}

    };

    // C++ wrapper for non_manifold_surface_shape_representation
    struct non_manifold_surface_shape_representation : shape_representation, ObjectHelper<non_manifold_surface_shape_representation,0> { non_manifold_surface_shape_representation() : Object("non_manifold_surface_shape_representation") {}

    };

    // C++ wrapper for null_representation_item
    struct null_representation_item : representation_item, ObjectHelper<null_representation_item,0> { null_representation_item() : Object("null_representation_item") {}

    };

    // C++ wrapper for numeric_expression
    struct numeric_expression : expression, ObjectHelper<numeric_expression,0> { numeric_expression() : Object("numeric_expression") {}

    };

    // C++ wrapper for offset_curve_2d
    struct offset_curve_2d : curve, ObjectHelper<offset_curve_2d,3> { offset_curve_2d() : Object("offset_curve_2d") {}
		Lazy< curve > basis_curve;
		length_measure::Out distance;
		LOGICAL::Out self_intersect;
    };

    // C++ wrapper for offset_curve_3d
    struct offset_curve_3d : curve, ObjectHelper<offset_curve_3d,4> { offset_curve_3d() : Object("offset_curve_3d") {}
		Lazy< curve > basis_curve;
		length_measure::Out distance;
		LOGICAL::Out self_intersect;
		Lazy< direction > ref_direction;
    };

    // C++ wrapper for offset_surface
    struct offset_surface : surface, ObjectHelper<offset_surface,3> { offset_surface() : Object("offset_surface") {}
		Lazy< surface > basis_surface;
		length_measure::Out distance;
		LOGICAL::Out self_intersect;
    };

    // C++ wrapper for one_direction_repeat_factor
    struct one_direction_repeat_factor : geometric_representation_item, ObjectHelper<one_direction_repeat_factor,1> { one_direction_repeat_factor() : Object("one_direction_repeat_factor") {}
		Lazy< vector > repeat_factor;
    };

    // C++ wrapper for open_shell
    struct open_shell : connected_face_set, ObjectHelper<open_shell,0> { open_shell() : Object("open_shell") {}

    };

    // C++ wrapper for ordinal_date
    struct ordinal_date : date, ObjectHelper<ordinal_date,1> { ordinal_date() : Object("ordinal_date") {}
		day_in_year_number::Out day_component;
    };

    // C++ wrapper for projection_directed_callout
    struct projection_directed_callout : draughting_callout, ObjectHelper<projection_directed_callout,0> { projection_directed_callout() : Object("projection_directed_callout") {}

    };

    // C++ wrapper for ordinate_dimension
    struct ordinate_dimension : projection_directed_callout, ObjectHelper<ordinate_dimension,0> { ordinate_dimension() : Object("ordinate_dimension") {}

    };

    // C++ wrapper for organizational_address
    struct organizational_address : address, ObjectHelper<organizational_address,2> { organizational_address() : Object("organizational_address") {}
		ListOf< Lazy< NotImplemented >, 1, 0 > organizations;
		Maybe< text::Out > description;
    };

    // C++ wrapper for oriented_closed_shell
    struct oriented_closed_shell : closed_shell, ObjectHelper<oriented_closed_shell,2> { oriented_closed_shell() : Object("oriented_closed_shell") {}
		Lazy< closed_shell > closed_shell_element;
		BOOLEAN::Out orientation;
    };

    // C++ wrapper for oriented_edge
    struct oriented_edge : edge, ObjectHelper<oriented_edge,2> { oriented_edge() : Object("oriented_edge") {}
		Lazy< edge > edge_element;
		BOOLEAN::Out orientation;
    };

    // C++ wrapper for oriented_face
    struct oriented_face : face, ObjectHelper<oriented_face,2> { oriented_face() : Object("oriented_face") {}
		Lazy< face > face_element;
		BOOLEAN::Out orientation;
    };

    // C++ wrapper for oriented_open_shell
    struct oriented_open_shell : open_shell, ObjectHelper<oriented_open_shell,2> { oriented_open_shell() : Object("oriented_open_shell") {}
		Lazy< open_shell > open_shell_element;
		BOOLEAN::Out orientation;
    };

    // C++ wrapper for path
    struct path : topological_representation_item, ObjectHelper<path,1> { path() : Object("path") {}
		ListOf< Lazy< oriented_edge >, 1, 0 > edge_list;
    };

    // C++ wrapper for oriented_path
    struct oriented_path : path, ObjectHelper<oriented_path,2> { oriented_path() : Object("oriented_path") {}
		Lazy< path > path_element;
		BOOLEAN::Out orientation;
    };

    // C++ wrapper for oriented_surface
    struct oriented_surface : surface, ObjectHelper<oriented_surface,1> { oriented_surface() : Object("oriented_surface") {}
		BOOLEAN::Out orientation;
    };

    // C++ wrapper for outer_boundary_curve
    struct outer_boundary_curve : boundary_curve, ObjectHelper<outer_boundary_curve,0> { outer_boundary_curve() : Object("outer_boundary_curve") {}

    };

    // C++ wrapper for package_product_concept_feature
    struct package_product_concept_feature : product_concept_feature, ObjectHelper<package_product_concept_feature,0> { package_product_concept_feature() : Object("package_product_concept_feature") {}

    };

    // C++ wrapper for parabola
    struct parabola : conic, ObjectHelper<parabola,1> { parabola() : Object("parabola") {}
		length_measure::Out focal_dist;
    };

    // C++ wrapper for parallel_offset
    struct parallel_offset : derived_shape_aspect, ObjectHelper<parallel_offset,1> { parallel_offset() : Object("parallel_offset") {}
		Lazy< measure_with_unit > offset;
    };

    // C++ wrapper for parallelism_tolerance
    struct parallelism_tolerance : geometric_tolerance_with_datum_reference, ObjectHelper<parallelism_tolerance,0> { parallelism_tolerance() : Object("parallelism_tolerance") {}

    };

    // C++ wrapper for parametric_representation_context
    struct parametric_representation_context : representation_context, ObjectHelper<parametric_representation_context,0> { parametric_representation_context() : Object("parametric_representation_context") {}

    };

    // C++ wrapper for partial_document_with_structured_text_representation_assignment
    struct partial_document_with_structured_text_representation_assignment :  ObjectHelper<partial_document_with_structured_text_representation_assignment,0> { partial_document_with_structured_text_representation_assignment() : Object("partial_document_with_structured_text_representation_assignment") {}

    };

    // C++ wrapper for pcurve
    struct pcurve : curve, ObjectHelper<pcurve,2> { pcurve() : Object("pcurve") {}
		Lazy< surface > basis_surface;
		Lazy< definitional_representation > reference_to_curve;
    };

    // C++ wrapper for percentage_laminate_definition
    struct percentage_laminate_definition : product_definition, ObjectHelper<percentage_laminate_definition,0> { percentage_laminate_definition() : Object("percentage_laminate_definition") {}

    };

    // C++ wrapper for zone_structural_makeup
    struct zone_structural_makeup : laminate_table, ObjectHelper<zone_structural_makeup,0> { zone_structural_makeup() : Object("zone_structural_makeup") {}

    };

    // C++ wrapper for percentage_laminate_table
    struct percentage_laminate_table : zone_structural_makeup, ObjectHelper<percentage_laminate_table,0> { percentage_laminate_table() : Object("percentage_laminate_table") {}

    };

    // C++ wrapper for percentage_ply_definition
    struct percentage_ply_definition : product_definition, ObjectHelper<percentage_ply_definition,0> { percentage_ply_definition() : Object("percentage_ply_definition") {}

    };

    // C++ wrapper for perpendicular_to
    struct perpendicular_to : derived_shape_aspect, ObjectHelper<perpendicular_to,0> { perpendicular_to() : Object("perpendicular_to") {}

    };

    // C++ wrapper for perpendicularity_tolerance
    struct perpendicularity_tolerance : geometric_tolerance_with_datum_reference, ObjectHelper<perpendicularity_tolerance,0> { perpendicularity_tolerance() : Object("perpendicularity_tolerance") {}

    };

    // C++ wrapper for person_and_organization_address
    struct person_and_organization_address :  ObjectHelper<person_and_organization_address,0> { person_and_organization_address() : Object("person_and_organization_address") {}

    };

    // C++ wrapper for personal_address
    struct personal_address : address, ObjectHelper<personal_address,2> { personal_address() : Object("personal_address") {}
		ListOf< Lazy< NotImplemented >, 1, 0 > people;
		Maybe< text::Out > description;
    };

    // C++ wrapper for physical_breakdown_context
    struct physical_breakdown_context : breakdown_context, ObjectHelper<physical_breakdown_context,0> { physical_breakdown_context() : Object("physical_breakdown_context") {}

    };

    // C++ wrapper for physical_element_usage
    struct physical_element_usage : breakdown_element_usage, ObjectHelper<physical_element_usage,0> { physical_element_usage() : Object("physical_element_usage") {}

    };

    // C++ wrapper for presentation_view
    struct presentation_view : presentation_representation, ObjectHelper<presentation_view,0> { presentation_view() : Object("presentation_view") {}

    };

    // C++ wrapper for picture_representation
    struct picture_representation : presentation_view, ObjectHelper<picture_representation,0> { picture_representation() : Object("picture_representation") {}

    };

    // C++ wrapper for placed_datum_target_feature
    struct placed_datum_target_feature : datum_target, ObjectHelper<placed_datum_target_feature,0> { placed_datum_target_feature() : Object("placed_datum_target_feature") {}

    };

    // C++ wrapper for placed_feature
    struct placed_feature : shape_aspect, ObjectHelper<placed_feature,0> { placed_feature() : Object("placed_feature") {}

    };

    // C++ wrapper for planar_extent
    struct planar_extent : geometric_representation_item, ObjectHelper<planar_extent,2> { planar_extent() : Object("planar_extent") {}
		length_measure::Out size_in_x;
		length_measure::Out size_in_y;
    };

    // C++ wrapper for planar_box
    struct planar_box : planar_extent, ObjectHelper<planar_box,1> { planar_box() : Object("planar_box") {}
		axis2_placement::Out placement;
    };

    // C++ wrapper for plane
    struct plane : elementary_surface, ObjectHelper<plane,0> { plane() : Object("plane") {}

    };

    // C++ wrapper for plane_angle_measure_with_unit
    struct plane_angle_measure_with_unit : measure_with_unit, ObjectHelper<plane_angle_measure_with_unit,0> { plane_angle_measure_with_unit() : Object("plane_angle_measure_with_unit") {}

    };

    // C++ wrapper for plane_angle_unit
    struct plane_angle_unit : named_unit, ObjectHelper<plane_angle_unit,0> { plane_angle_unit() : Object("plane_angle_unit") {}

    };

    // C++ wrapper for ply_laminate_definition
    struct ply_laminate_definition : product_definition, ObjectHelper<ply_laminate_definition,0> { ply_laminate_definition() : Object("ply_laminate_definition") {}

    };

    // C++ wrapper for ply_laminate_sequence_definition
    struct ply_laminate_sequence_definition : product_definition, ObjectHelper<ply_laminate_sequence_definition,0> { ply_laminate_sequence_definition() : Object("ply_laminate_sequence_definition") {}

    };

    // C++ wrapper for ply_laminate_table
    struct ply_laminate_table : part_laminate_table, ObjectHelper<ply_laminate_table,0> { ply_laminate_table() : Object("ply_laminate_table") {}

    };

    // C++ wrapper for point_and_vector
    struct point_and_vector :  ObjectHelper<point_and_vector,0> { point_and_vector() : Object("point_and_vector") {}

    };

    // C++ wrapper for point_on_curve
    struct point_on_curve : point, ObjectHelper<point_on_curve,2> { point_on_curve() : Object("point_on_curve") {}
		Lazy< curve > basis_curve;
		parameter_value::Out point_parameter;
    };

    // C++ wrapper for point_on_surface
    struct point_on_surface : point, ObjectHelper<point_on_surface,3> { point_on_surface() : Object("point_on_surface") {}
		Lazy< surface > basis_surface;
		parameter_value::Out point_parameter_u;
		parameter_value::Out point_parameter_v;
    };

    // C++ wrapper for point_path
    struct point_path :  ObjectHelper<point_path,0> { point_path() : Object("point_path") {}

    };

    // C++ wrapper for point_replica
    struct point_replica : point, ObjectHelper<point_replica,2> { point_replica() : Object("point_replica") {}
		Lazy< point > parent_pt;
		Lazy< cartesian_transformation_operator > transformation;
    };

    // C++ wrapper for point_style
    struct point_style : founded_item, ObjectHelper<point_style,4> { point_style() : Object("point_style") {}
		label::Out name;
		marker_select::Out marker;
		size_select::Out marker_size;
		Lazy< colour > marker_colour;
    };

    // C++ wrapper for polar_complex_number_literal
    struct polar_complex_number_literal : generic_literal, ObjectHelper<polar_complex_number_literal,2> { polar_complex_number_literal() : Object("polar_complex_number_literal") {}
		REAL::Out radius;
		REAL::Out angle;
    };

    // C++ wrapper for poly_loop
    struct poly_loop :  ObjectHelper<poly_loop,1> { poly_loop() : Object("poly_loop") {}
		ListOf< Lazy< cartesian_point >, 3, 0 > polygon;
    };

    // C++ wrapper for polyline
    struct polyline : bounded_curve, ObjectHelper<polyline,1> { polyline() : Object("polyline") {}
		ListOf< Lazy< cartesian_point >, 2, 0 > points;
    };

    // C++ wrapper for position_tolerance
    struct position_tolerance : geometric_tolerance, ObjectHelper<position_tolerance,0> { position_tolerance() : Object("position_tolerance") {}

    };

    // C++ wrapper for positioned_sketch
    struct positioned_sketch : geometric_representation_item, ObjectHelper<positioned_sketch,2> { positioned_sketch() : Object("positioned_sketch") {}
		sketch_basis_select::Out sketch_basis;
		ListOf< Lazy< auxiliary_geometric_representation_item >, 0, 0 > auxiliary_elements;
    };

    // C++ wrapper for power_measure_with_unit
    struct power_measure_with_unit : measure_with_unit, ObjectHelper<power_measure_with_unit,0> { power_measure_with_unit() : Object("power_measure_with_unit") {}

    };

    // C++ wrapper for power_unit
    struct power_unit : derived_unit, ObjectHelper<power_unit,0> { power_unit() : Object("power_unit") {}

    };

    // C++ wrapper for pre_defined_symbol
    struct pre_defined_symbol : pre_defined_item, ObjectHelper<pre_defined_symbol,0> { pre_defined_symbol() : Object("pre_defined_symbol") {}

    };

    // C++ wrapper for pre_defined_dimension_symbol
    struct pre_defined_dimension_symbol : pre_defined_symbol, ObjectHelper<pre_defined_dimension_symbol,0> { pre_defined_dimension_symbol() : Object("pre_defined_dimension_symbol") {}

    };

    // C++ wrapper for pre_defined_geometrical_tolerance_symbol
    struct pre_defined_geometrical_tolerance_symbol : pre_defined_symbol, ObjectHelper<pre_defined_geometrical_tolerance_symbol,0> { pre_defined_geometrical_tolerance_symbol() : Object("pre_defined_geometrical_tolerance_symbol") {}

    };

    // C++ wrapper for pre_defined_marker
    struct pre_defined_marker : pre_defined_item, ObjectHelper<pre_defined_marker,0> { pre_defined_marker() : Object("pre_defined_marker") {}

    };

    // C++ wrapper for pre_defined_point_marker_symbol
    struct pre_defined_point_marker_symbol :  ObjectHelper<pre_defined_point_marker_symbol,0> { pre_defined_point_marker_symbol() : Object("pre_defined_point_marker_symbol") {}

    };

    // C++ wrapper for pre_defined_surface_condition_symbol
    struct pre_defined_surface_condition_symbol : pre_defined_symbol, ObjectHelper<pre_defined_surface_condition_symbol,0> { pre_defined_surface_condition_symbol() : Object("pre_defined_surface_condition_symbol") {}

    };

    // C++ wrapper for pre_defined_surface_side_style
    struct pre_defined_surface_side_style : pre_defined_item, ObjectHelper<pre_defined_surface_side_style,0> { pre_defined_surface_side_style() : Object("pre_defined_surface_side_style") {}

    };

    // C++ wrapper for pre_defined_terminator_symbol
    struct pre_defined_terminator_symbol : pre_defined_symbol, ObjectHelper<pre_defined_terminator_symbol,0> { pre_defined_terminator_symbol() : Object("pre_defined_terminator_symbol") {}

    };

    // C++ wrapper for pre_defined_tile
    struct pre_defined_tile : pre_defined_item, ObjectHelper<pre_defined_tile,0> { pre_defined_tile() : Object("pre_defined_tile") {}

    };

    // C++ wrapper for predefined_picture_representation_item
    struct predefined_picture_representation_item : picture_representation_item, ObjectHelper<predefined_picture_representation_item,0> { predefined_picture_representation_item() : Object("predefined_picture_representation_item") {}

    };

    // C++ wrapper for presentation_style_assignment
    struct presentation_style_assignment : founded_item, ObjectHelper<presentation_style_assignment,1> { presentation_style_assignment() : Object("presentation_style_assignment") {}
		ListOf< presentation_style_select, 1, 0 >::Out styles;
    };

    // C++ wrapper for presentation_style_by_context
    struct presentation_style_by_context : presentation_style_assignment, ObjectHelper<presentation_style_by_context,1> { presentation_style_by_context() : Object("presentation_style_by_context") {}
		style_context_select::Out style_context;
    };

    // C++ wrapper for pressure_measure_with_unit
    struct pressure_measure_with_unit : measure_with_unit, ObjectHelper<pressure_measure_with_unit,0> { pressure_measure_with_unit() : Object("pressure_measure_with_unit") {}

    };

    // C++ wrapper for pressure_unit
    struct pressure_unit : derived_unit, ObjectHelper<pressure_unit,0> { pressure_unit() : Object("pressure_unit") {}

    };

    // C++ wrapper for procedural_representation
    struct procedural_representation : representation, ObjectHelper<procedural_representation,0> { procedural_representation() : Object("procedural_representation") {}

    };

    // C++ wrapper for procedural_representation_sequence
    struct procedural_representation_sequence : representation_item, ObjectHelper<procedural_representation_sequence,3> { procedural_representation_sequence() : Object("procedural_representation_sequence") {}
		ListOf< Lazy< representation_item >, 1, 0 > elements;
		ListOf< Lazy< representation_item >, 0, 0 > suppressed_items;
		text::Out rationale;
    };

    // C++ wrapper for procedural_shape_representation
    struct procedural_shape_representation :  ObjectHelper<procedural_shape_representation,0> { procedural_shape_representation() : Object("procedural_shape_representation") {}

    };

    // C++ wrapper for procedural_shape_representation_sequence
    struct procedural_shape_representation_sequence :  ObjectHelper<procedural_shape_representation_sequence,0> { procedural_shape_representation_sequence() : Object("procedural_shape_representation_sequence") {}

    };

    // C++ wrapper for product_category
    struct product_category :  ObjectHelper<product_category,2> { product_category() : Object("product_category") {}
		label::Out name;
		Maybe< text::Out > description;
    };

    // C++ wrapper for product_class
    struct product_class :  ObjectHelper<product_class,0> { product_class() : Object("product_class") {}

    };

    // C++ wrapper for product_concept_context
    struct product_concept_context : application_context_element, ObjectHelper<product_concept_context,1> { product_concept_context() : Object("product_concept_context") {}
		label::Out market_segment_type;
    };

    // C++ wrapper for product_concept_feature_category_usage
    struct product_concept_feature_category_usage : group_assignment, ObjectHelper<product_concept_feature_category_usage,1> { product_concept_feature_category_usage() : Object("product_concept_feature_category_usage") {}
		ListOf< category_usage_item, 1, 0 >::Out items;
    };

    // C++ wrapper for product_definition_element_relationship
    struct product_definition_element_relationship : group, ObjectHelper<product_definition_element_relationship,0> { product_definition_element_relationship() : Object("product_definition_element_relationship") {}

    };

    // C++ wrapper for product_definition_formation
    struct product_definition_formation :  ObjectHelper<product_definition_formation,3> { product_definition_formation() : Object("product_definition_formation") {}
		identifier::Out id;
		Maybe< text::Out > description;
		Lazy< NotImplemented > of_product;
    };

    // C++ wrapper for product_definition_formation_with_specified_source
    struct product_definition_formation_with_specified_source : product_definition_formation, ObjectHelper<product_definition_formation_with_specified_source,1> { product_definition_formation_with_specified_source() : Object("product_definition_formation_with_specified_source") {}
		source::Out make_or_buy;
    };

    // C++ wrapper for product_definition_group_assignment
    struct product_definition_group_assignment : group_assignment, ObjectHelper<product_definition_group_assignment,1> { product_definition_group_assignment() : Object("product_definition_group_assignment") {}
		ListOf< product_definition_or_product_definition_relationship, 1, 1 >::Out items;
    };

    // C++ wrapper for product_definition_shape
    struct product_definition_shape : property_definition, ObjectHelper<product_definition_shape,0> { product_definition_shape() : Object("product_definition_shape") {}

    };

    // C++ wrapper for product_definition_with_associated_documents
    struct product_definition_with_associated_documents : product_definition, ObjectHelper<product_definition_with_associated_documents,1> { product_definition_with_associated_documents() : Object("product_definition_with_associated_documents") {}
		ListOf< Lazy< NotImplemented >, 1, 0 > documentation_ids;
    };

    // C++ wrapper for product_identification
    struct product_identification :  ObjectHelper<product_identification,0> { product_identification() : Object("product_identification") {}

    };

    // C++ wrapper for product_material_composition_relationship
    struct product_material_composition_relationship : product_definition_relationship, ObjectHelper<product_material_composition_relationship,4> { product_material_composition_relationship() : Object("product_material_composition_relationship") {}
		label::Out class_;
		ListOf< characterized_product_composition_value, 1, 0 >::Out constituent_amount;
		label::Out composition_basis;
		text::Out determination_method;
    };

    // C++ wrapper for product_related_product_category
    struct product_related_product_category : product_category, ObjectHelper<product_related_product_category,1> { product_related_product_category() : Object("product_related_product_category") {}
		ListOf< Lazy< NotImplemented >, 1, 0 > products;
    };

    // C++ wrapper for product_specification
    struct product_specification :  ObjectHelper<product_specification,0> { product_specification() : Object("product_specification") {}

    };

    // C++ wrapper for tolerance_zone_definition
    struct tolerance_zone_definition :  ObjectHelper<tolerance_zone_definition,2> { tolerance_zone_definition() : Object("tolerance_zone_definition") {}
		Lazy< tolerance_zone > zone;
		ListOf< Lazy< shape_aspect >, 1, 0 > boundaries;
    };

    // C++ wrapper for projected_zone_definition
    struct projected_zone_definition : tolerance_zone_definition, ObjectHelper<projected_zone_definition,2> { projected_zone_definition() : Object("projected_zone_definition") {}
		Lazy< shape_aspect > projection_end;
		Lazy< measure_with_unit > projected_length;
    };

    // C++ wrapper for projection_curve
    struct projection_curve : annotation_curve_occurrence, ObjectHelper<projection_curve,0> { projection_curve() : Object("projection_curve") {}

    };

    // C++ wrapper for promissory_usage_occurrence
    struct promissory_usage_occurrence : assembly_component_usage, ObjectHelper<promissory_usage_occurrence,0> { promissory_usage_occurrence() : Object("promissory_usage_occurrence") {}

    };

    // C++ wrapper for qualified_representation_item
    struct qualified_representation_item : representation_item, ObjectHelper<qualified_representation_item,1> { qualified_representation_item() : Object("qualified_representation_item") {}
		ListOf< value_qualifier, 1, 0 >::Out qualifiers;
    };

    // C++ wrapper for qualitative_uncertainty
    struct qualitative_uncertainty : uncertainty_qualifier, ObjectHelper<qualitative_uncertainty,1> { qualitative_uncertainty() : Object("qualitative_uncertainty") {}
		text::Out uncertainty_value;
    };

    // C++ wrapper for quantified_assembly_component_usage
    struct quantified_assembly_component_usage : assembly_component_usage, ObjectHelper<quantified_assembly_component_usage,1> { quantified_assembly_component_usage() : Object("quantified_assembly_component_usage") {}
		Lazy< measure_with_unit > quantity;
    };

    // C++ wrapper for quasi_uniform_curve
    struct quasi_uniform_curve : b_spline_curve, ObjectHelper<quasi_uniform_curve,0> { quasi_uniform_curve() : Object("quasi_uniform_curve") {}

    };

    // C++ wrapper for quasi_uniform_surface
    struct quasi_uniform_surface : b_spline_surface, ObjectHelper<quasi_uniform_surface,0> { quasi_uniform_surface() : Object("quasi_uniform_surface") {}

    };

    // C++ wrapper for radioactivity_measure_with_unit
    struct radioactivity_measure_with_unit : measure_with_unit, ObjectHelper<radioactivity_measure_with_unit,0> { radioactivity_measure_with_unit() : Object("radioactivity_measure_with_unit") {}

    };

    // C++ wrapper for radioactivity_unit
    struct radioactivity_unit : derived_unit, ObjectHelper<radioactivity_unit,0> { radioactivity_unit() : Object("radioactivity_unit") {}

    };

    // C++ wrapper for radius_dimension
    struct radius_dimension : dimension_curve_directed_callout, ObjectHelper<radius_dimension,0> { radius_dimension() : Object("radius_dimension") {}

    };

    // C++ wrapper for range_characteristic
    struct range_characteristic :  ObjectHelper<range_characteristic,0> { range_characteristic() : Object("range_characteristic") {}

    };

    // C++ wrapper for ratio_unit
    struct ratio_unit : named_unit, ObjectHelper<ratio_unit,0> { ratio_unit() : Object("ratio_unit") {}

    };

    // C++ wrapper for rational_b_spline_curve
    struct rational_b_spline_curve : b_spline_curve, ObjectHelper<rational_b_spline_curve,1> { rational_b_spline_curve() : Object("rational_b_spline_curve") {}
		ListOf< REAL, 2, 0 >::Out weights_data;
    };

    // C++ wrapper for rational_b_spline_surface
    struct rational_b_spline_surface : b_spline_surface, ObjectHelper<rational_b_spline_surface,0> { rational_b_spline_surface() : Object("rational_b_spline_surface") {}

    };

    // C++ wrapper for rational_representation_item
    struct rational_representation_item :  ObjectHelper<rational_representation_item,0> { rational_representation_item() : Object("rational_representation_item") {}

    };

    // C++ wrapper for real_literal
    struct real_literal : literal_number, ObjectHelper<real_literal,0> { real_literal() : Object("real_literal") {}

    };

    // C++ wrapper for real_representation_item
    struct real_representation_item :  ObjectHelper<real_representation_item,0> { real_representation_item() : Object("real_representation_item") {}

    };

    // C++ wrapper for rectangular_composite_surface
    struct rectangular_composite_surface : bounded_surface, ObjectHelper<rectangular_composite_surface,0> { rectangular_composite_surface() : Object("rectangular_composite_surface") {}

    };

    // C++ wrapper for rectangular_trimmed_surface
    struct rectangular_trimmed_surface : bounded_surface, ObjectHelper<rectangular_trimmed_surface,7> { rectangular_trimmed_surface() : Object("rectangular_trimmed_surface") {}
		Lazy< surface > basis_surface;
		parameter_value::Out u1;
		parameter_value::Out u2;
		parameter_value::Out v1;
		parameter_value::Out v2;
		BOOLEAN::Out usense;
		BOOLEAN::Out vsense;
    };

    // C++ wrapper for referenced_modified_datum
    struct referenced_modified_datum : datum_reference, ObjectHelper<referenced_modified_datum,1> { referenced_modified_datum() : Object("referenced_modified_datum") {}
		limit_condition::Out modifier;
    };

    // C++ wrapper for relative_event_occurrence
    struct relative_event_occurrence : event_occurrence, ObjectHelper<relative_event_occurrence,2> { relative_event_occurrence() : Object("relative_event_occurrence") {}
		Lazy< event_occurrence > base_event;
		Lazy< time_measure_with_unit > offset;
    };

    // C++ wrapper for rep_item_group
    struct rep_item_group :  ObjectHelper<rep_item_group,0> { rep_item_group() : Object("rep_item_group") {}

    };

    // C++ wrapper for reparametrised_composite_curve_segment
    struct reparametrised_composite_curve_segment : composite_curve_segment, ObjectHelper<reparametrised_composite_curve_segment,1> { reparametrised_composite_curve_segment() : Object("reparametrised_composite_curve_segment") {}
		parameter_value::Out param_length;
    };

    // C++ wrapper for representation_relationship_with_transformation
    struct representation_relationship_with_transformation : representation_relationship, ObjectHelper<representation_relationship_with_transformation,1> { representation_relationship_with_transformation() : Object("representation_relationship_with_transformation") {}
		transformation::Out transformation_operator;
    };

    // C++ wrapper for requirement_assigned_object
    struct requirement_assigned_object : group_assignment, ObjectHelper<requirement_assigned_object,1> { requirement_assigned_object() : Object("requirement_assigned_object") {}
		ListOf< requirement_assigned_item, 1, 1 >::Out items;
    };

    // C++ wrapper for requirement_assignment
    struct requirement_assignment :  ObjectHelper<requirement_assignment,0> { requirement_assignment() : Object("requirement_assignment") {}

    };

    // C++ wrapper for requirement_source
    struct requirement_source : group, ObjectHelper<requirement_source,0> { requirement_source() : Object("requirement_source") {}

    };

    // C++ wrapper for requirement_view_definition_relationship
    struct requirement_view_definition_relationship : product_definition_relationship, ObjectHelper<requirement_view_definition_relationship,0> { requirement_view_definition_relationship() : Object("requirement_view_definition_relationship") {}

    };

    // C++ wrapper for resistance_measure_with_unit
    struct resistance_measure_with_unit : measure_with_unit, ObjectHelper<resistance_measure_with_unit,0> { resistance_measure_with_unit() : Object("resistance_measure_with_unit") {}

    };

    // C++ wrapper for resistance_unit
    struct resistance_unit : derived_unit, ObjectHelper<resistance_unit,0> { resistance_unit() : Object("resistance_unit") {}

    };

    // C++ wrapper for revolved_area_solid
    struct revolved_area_solid : swept_area_solid, ObjectHelper<revolved_area_solid,2> { revolved_area_solid() : Object("revolved_area_solid") {}
		Lazy< axis1_placement > axis;
		plane_angle_measure::Out angle;
    };

    // C++ wrapper for revolved_face_solid
    struct revolved_face_solid : swept_face_solid, ObjectHelper<revolved_face_solid,2> { revolved_face_solid() : Object("revolved_face_solid") {}
		Lazy< axis1_placement > axis;
		plane_angle_measure::Out angle;
    };

    // C++ wrapper for revolved_face_solid_with_trim_conditions
    struct revolved_face_solid_with_trim_conditions : revolved_face_solid, ObjectHelper<revolved_face_solid_with_trim_conditions,2> { revolved_face_solid_with_trim_conditions() : Object("revolved_face_solid_with_trim_conditions") {}
		trim_condition_select::Out first_trim_condition;
		trim_condition_select::Out second_trim_condition;
    };

    // C++ wrapper for right_angular_wedge
    struct right_angular_wedge : geometric_representation_item, ObjectHelper<right_angular_wedge,5> { right_angular_wedge() : Object("right_angular_wedge") {}
		Lazy< axis2_placement_3d > position;
		positive_length_measure::Out x;
		positive_length_measure::Out y;
		positive_length_measure::Out z;
		length_measure::Out ltx;
    };

    // C++ wrapper for right_circular_cone
    struct right_circular_cone : geometric_representation_item, ObjectHelper<right_circular_cone,4> { right_circular_cone() : Object("right_circular_cone") {}
		Lazy< axis1_placement > position;
		positive_length_measure::Out height;
		length_measure::Out radius;
		plane_angle_measure::Out semi_angle;
    };

    // C++ wrapper for right_circular_cylinder
    struct right_circular_cylinder : geometric_representation_item, ObjectHelper<right_circular_cylinder,3> { right_circular_cylinder() : Object("right_circular_cylinder") {}
		Lazy< axis1_placement > position;
		positive_length_measure::Out height;
		positive_length_measure::Out radius;
    };

    // C++ wrapper for right_to_usage_association
    struct right_to_usage_association : action_method_relationship, ObjectHelper<right_to_usage_association,0> { right_to_usage_association() : Object("right_to_usage_association") {}

    };

    // C++ wrapper for roundness_tolerance
    struct roundness_tolerance : geometric_tolerance, ObjectHelper<roundness_tolerance,0> { roundness_tolerance() : Object("roundness_tolerance") {}

    };

    // C++ wrapper for row_representation_item
    struct row_representation_item : compound_representation_item, ObjectHelper<row_representation_item,0> { row_representation_item() : Object("row_representation_item") {}

    };

    // C++ wrapper for row_value
    struct row_value : compound_representation_item, ObjectHelper<row_value,0> { row_value() : Object("row_value") {}

    };

    // C++ wrapper for row_variable
    struct row_variable : abstract_variable, ObjectHelper<row_variable,0> { row_variable() : Object("row_variable") {}

    };

    // C++ wrapper for rule_action
    struct rule_action : action, ObjectHelper<rule_action,0> { rule_action() : Object("rule_action") {}

    };

    // C++ wrapper for rule_condition
    struct rule_condition : atomic_formula, ObjectHelper<rule_condition,0> { rule_condition() : Object("rule_condition") {}

    };

    // C++ wrapper for rule_set
    struct rule_set : rule_software_definition, ObjectHelper<rule_set,0> { rule_set() : Object("rule_set") {}

    };

    // C++ wrapper for rule_set_group
    struct rule_set_group : rule_software_definition, ObjectHelper<rule_set_group,0> { rule_set_group() : Object("rule_set_group") {}

    };

    // C++ wrapper for rule_superseded_assignment
    struct rule_superseded_assignment : action_assignment, ObjectHelper<rule_superseded_assignment,1> { rule_superseded_assignment() : Object("rule_superseded_assignment") {}
		ListOf< rule_superseded_item, 1, 0 >::Out items;
    };

    // C++ wrapper for rule_supersedence
    struct rule_supersedence : rule_action, ObjectHelper<rule_supersedence,0> { rule_supersedence() : Object("rule_supersedence") {}

    };

    // C++ wrapper for surface_curve_swept_area_solid
    struct surface_curve_swept_area_solid : swept_area_solid, ObjectHelper<surface_curve_swept_area_solid,4> { surface_curve_swept_area_solid() : Object("surface_curve_swept_area_solid") {}
		Lazy< curve > directrix;
		REAL::Out start_param;
		REAL::Out end_param;
		Lazy< surface > reference_surface;
    };

    // C++ wrapper for ruled_surface_swept_area_solid
    struct ruled_surface_swept_area_solid : surface_curve_swept_area_solid, ObjectHelper<ruled_surface_swept_area_solid,0> { ruled_surface_swept_area_solid() : Object("ruled_surface_swept_area_solid") {}

    };

    // C++ wrapper for runout_zone_definition
    struct runout_zone_definition : tolerance_zone_definition, ObjectHelper<runout_zone_definition,1> { runout_zone_definition() : Object("runout_zone_definition") {}
		Lazy< runout_zone_orientation > orientation;
    };

    // C++ wrapper for runout_zone_orientation
    struct runout_zone_orientation :  ObjectHelper<runout_zone_orientation,1> { runout_zone_orientation() : Object("runout_zone_orientation") {}
		Lazy< measure_with_unit > angle;
    };

    // C++ wrapper for runout_zone_orientation_reference_direction
    struct runout_zone_orientation_reference_direction : runout_zone_orientation, ObjectHelper<runout_zone_orientation_reference_direction,1> { runout_zone_orientation_reference_direction() : Object("runout_zone_orientation_reference_direction") {}
		Lazy< shape_aspect_relationship > orientation_defining_relationship;
    };

    // C++ wrapper for satisfied_requirement
    struct satisfied_requirement : group_assignment, ObjectHelper<satisfied_requirement,1> { satisfied_requirement() : Object("satisfied_requirement") {}
		ListOf< Lazy< product_definition >, 1, 1 > items;
    };

    // C++ wrapper for satisfies_requirement
    struct satisfies_requirement : group, ObjectHelper<satisfies_requirement,0> { satisfies_requirement() : Object("satisfies_requirement") {}

    };

    // C++ wrapper for satisfying_item
    struct satisfying_item : group_assignment, ObjectHelper<satisfying_item,1> { satisfying_item() : Object("satisfying_item") {}
		ListOf< requirement_satisfaction_item, 1, 1 >::Out items;
    };

    // C++ wrapper for scalar_variable
    struct scalar_variable : abstract_variable, ObjectHelper<scalar_variable,0> { scalar_variable() : Object("scalar_variable") {}

    };

    // C++ wrapper for scattering_parameter
    struct scattering_parameter : polar_complex_number_literal, ObjectHelper<scattering_parameter,0> { scattering_parameter() : Object("scattering_parameter") {}

    };

    // C++ wrapper for sculptured_solid
    struct sculptured_solid : modified_solid, ObjectHelper<sculptured_solid,2> { sculptured_solid() : Object("sculptured_solid") {}
		generalized_surface_select::Out sculpturing_element;
		BOOLEAN::Out positive_side;
    };

    // C++ wrapper for seam_curve
    struct seam_curve : surface_curve, ObjectHelper<seam_curve,0> { seam_curve() : Object("seam_curve") {}

    };

    // C++ wrapper for serial_numbered_effectivity
    struct serial_numbered_effectivity : effectivity, ObjectHelper<serial_numbered_effectivity,2> { serial_numbered_effectivity() : Object("serial_numbered_effectivity") {}
		identifier::Out effectivity_start_id;
		Maybe< identifier::Out > effectivity_end_id;
    };

    // C++ wrapper for shape_aspect_associativity
    struct shape_aspect_associativity : shape_aspect_relationship, ObjectHelper<shape_aspect_associativity,0> { shape_aspect_associativity() : Object("shape_aspect_associativity") {}

    };

    // C++ wrapper for shape_aspect_deriving_relationship
    struct shape_aspect_deriving_relationship : shape_aspect_relationship, ObjectHelper<shape_aspect_deriving_relationship,0> { shape_aspect_deriving_relationship() : Object("shape_aspect_deriving_relationship") {}

    };

    // C++ wrapper for shape_definition_representation
    struct shape_definition_representation : property_definition_representation, ObjectHelper<shape_definition_representation,0> { shape_definition_representation() : Object("shape_definition_representation") {}

    };

    // C++ wrapper for shape_dimension_representation
    struct shape_dimension_representation : shape_representation, ObjectHelper<shape_dimension_representation,0> { shape_dimension_representation() : Object("shape_dimension_representation") {}

    };

    // C++ wrapper for shape_feature_definition
    struct shape_feature_definition : characterized_object, ObjectHelper<shape_feature_definition,0> { shape_feature_definition() : Object("shape_feature_definition") {}

    };

    // C++ wrapper for shape_representation_with_parameters
    struct shape_representation_with_parameters : shape_representation, ObjectHelper<shape_representation_with_parameters,0> { shape_representation_with_parameters() : Object("shape_representation_with_parameters") {}

    };

    // C++ wrapper for shell_based_surface_model
    struct shell_based_surface_model : geometric_representation_item, ObjectHelper<shell_based_surface_model,1> { shell_based_surface_model() : Object("shell_based_surface_model") {}
		ListOf< shell, 1, 0 >::Out sbsm_boundary;
    };

    // C++ wrapper for shell_based_wireframe_model
    struct shell_based_wireframe_model : geometric_representation_item, ObjectHelper<shell_based_wireframe_model,1> { shell_based_wireframe_model() : Object("shell_based_wireframe_model") {}
		ListOf< shell, 1, 0 >::Out sbwm_boundary;
    };

    // C++ wrapper for shell_based_wireframe_shape_representation
    struct shell_based_wireframe_shape_representation : shape_representation, ObjectHelper<shell_based_wireframe_shape_representation,0> { shell_based_wireframe_shape_representation() : Object("shell_based_wireframe_shape_representation") {}

    };

    // C++ wrapper for si_absorbed_dose_unit
    struct si_absorbed_dose_unit :  ObjectHelper<si_absorbed_dose_unit,0> { si_absorbed_dose_unit() : Object("si_absorbed_dose_unit") {}

    };

    // C++ wrapper for si_capacitance_unit
    struct si_capacitance_unit :  ObjectHelper<si_capacitance_unit,0> { si_capacitance_unit() : Object("si_capacitance_unit") {}

    };

    // C++ wrapper for si_conductance_unit
    struct si_conductance_unit :  ObjectHelper<si_conductance_unit,0> { si_conductance_unit() : Object("si_conductance_unit") {}

    };

    // C++ wrapper for si_dose_equivalent_unit
    struct si_dose_equivalent_unit :  ObjectHelper<si_dose_equivalent_unit,0> { si_dose_equivalent_unit() : Object("si_dose_equivalent_unit") {}

    };

    // C++ wrapper for si_electric_charge_unit
    struct si_electric_charge_unit :  ObjectHelper<si_electric_charge_unit,0> { si_electric_charge_unit() : Object("si_electric_charge_unit") {}

    };

    // C++ wrapper for si_electric_potential_unit
    struct si_electric_potential_unit :  ObjectHelper<si_electric_potential_unit,0> { si_electric_potential_unit() : Object("si_electric_potential_unit") {}

    };

    // C++ wrapper for si_energy_unit
    struct si_energy_unit :  ObjectHelper<si_energy_unit,0> { si_energy_unit() : Object("si_energy_unit") {}

    };

    // C++ wrapper for si_force_unit
    struct si_force_unit :  ObjectHelper<si_force_unit,0> { si_force_unit() : Object("si_force_unit") {}

    };

    // C++ wrapper for si_frequency_unit
    struct si_frequency_unit :  ObjectHelper<si_frequency_unit,0> { si_frequency_unit() : Object("si_frequency_unit") {}

    };

    // C++ wrapper for si_illuminance_unit
    struct si_illuminance_unit :  ObjectHelper<si_illuminance_unit,0> { si_illuminance_unit() : Object("si_illuminance_unit") {}

    };

    // C++ wrapper for si_inductance_unit
    struct si_inductance_unit :  ObjectHelper<si_inductance_unit,0> { si_inductance_unit() : Object("si_inductance_unit") {}

    };

    // C++ wrapper for si_magnetic_flux_density_unit
    struct si_magnetic_flux_density_unit :  ObjectHelper<si_magnetic_flux_density_unit,0> { si_magnetic_flux_density_unit() : Object("si_magnetic_flux_density_unit") {}

    };

    // C++ wrapper for si_magnetic_flux_unit
    struct si_magnetic_flux_unit :  ObjectHelper<si_magnetic_flux_unit,0> { si_magnetic_flux_unit() : Object("si_magnetic_flux_unit") {}

    };

    // C++ wrapper for si_power_unit
    struct si_power_unit :  ObjectHelper<si_power_unit,0> { si_power_unit() : Object("si_power_unit") {}

    };

    // C++ wrapper for si_pressure_unit
    struct si_pressure_unit :  ObjectHelper<si_pressure_unit,0> { si_pressure_unit() : Object("si_pressure_unit") {}

    };

    // C++ wrapper for si_radioactivity_unit
    struct si_radioactivity_unit :  ObjectHelper<si_radioactivity_unit,0> { si_radioactivity_unit() : Object("si_radioactivity_unit") {}

    };

    // C++ wrapper for si_resistance_unit
    struct si_resistance_unit :  ObjectHelper<si_resistance_unit,0> { si_resistance_unit() : Object("si_resistance_unit") {}

    };

    // C++ wrapper for si_unit
    struct si_unit : named_unit, ObjectHelper<si_unit,2> { si_unit() : Object("si_unit") {}
		Maybe< si_prefix::Out > prefix;
		si_unit_name::Out name;
    };

    // C++ wrapper for simple_boolean_expression
    struct simple_boolean_expression :  ObjectHelper<simple_boolean_expression,0> { simple_boolean_expression() : Object("simple_boolean_expression") {}

    };

    // C++ wrapper for simple_numeric_expression
    struct simple_numeric_expression :  ObjectHelper<simple_numeric_expression,0> { simple_numeric_expression() : Object("simple_numeric_expression") {}

    };

    // C++ wrapper for slash_expression
    struct slash_expression : binary_numeric_expression, ObjectHelper<slash_expression,0> { slash_expression() : Object("slash_expression") {}

    };

    // C++ wrapper for smeared_material_definition
    struct smeared_material_definition : zone_structural_makeup, ObjectHelper<smeared_material_definition,0> { smeared_material_definition() : Object("smeared_material_definition") {}

    };

    // C++ wrapper for solid_angle_measure_with_unit
    struct solid_angle_measure_with_unit : measure_with_unit, ObjectHelper<solid_angle_measure_with_unit,0> { solid_angle_measure_with_unit() : Object("solid_angle_measure_with_unit") {}

    };

    // C++ wrapper for solid_angle_unit
    struct solid_angle_unit : named_unit, ObjectHelper<solid_angle_unit,0> { solid_angle_unit() : Object("solid_angle_unit") {}

    };

    // C++ wrapper for solid_curve_font
    struct solid_curve_font : pre_defined_curve_font, ObjectHelper<solid_curve_font,0> { solid_curve_font() : Object("solid_curve_font") {}

    };

    // C++ wrapper for solid_replica
    struct solid_replica : solid_model, ObjectHelper<solid_replica,2> { solid_replica() : Object("solid_replica") {}
		Lazy< solid_model > parent_solid;
		Lazy< cartesian_transformation_operator_3d > transformation;
    };

    // C++ wrapper for solid_with_chamfered_edges
    struct solid_with_chamfered_edges : edge_blended_solid, ObjectHelper<solid_with_chamfered_edges,0> { solid_with_chamfered_edges() : Object("solid_with_chamfered_edges") {}

    };

    // C++ wrapper for solid_with_angle_based_chamfer
    struct solid_with_angle_based_chamfer : solid_with_chamfered_edges, ObjectHelper<solid_with_angle_based_chamfer,3> { solid_with_angle_based_chamfer() : Object("solid_with_angle_based_chamfer") {}
		positive_length_measure::Out offset_distance;
		BOOLEAN::Out left_offset;
		positive_plane_angle_measure::Out offset_angle;
    };

    // C++ wrapper for solid_with_shape_element_pattern
    struct solid_with_shape_element_pattern : modified_solid_with_placed_configuration, ObjectHelper<solid_with_shape_element_pattern,1> { solid_with_shape_element_pattern() : Object("solid_with_shape_element_pattern") {}
		Lazy< modified_solid_with_placed_configuration > replicated_element;
    };

    // C++ wrapper for solid_with_circular_pattern
    struct solid_with_circular_pattern : solid_with_shape_element_pattern, ObjectHelper<solid_with_circular_pattern,4> { solid_with_circular_pattern() : Object("solid_with_circular_pattern") {}
		positive_integer::Out replicate_count;
		plane_angle_measure::Out angular_spacing;
		BOOLEAN::Out radial_alignment;
		Lazy< point > reference_point;
    };

    // C++ wrapper for solid_with_depression
    struct solid_with_depression : modified_solid_with_placed_configuration, ObjectHelper<solid_with_depression,1> { solid_with_depression() : Object("solid_with_depression") {}
		positive_length_measure::Out depth;
    };

    // C++ wrapper for solid_with_pocket
    struct solid_with_pocket : solid_with_depression, ObjectHelper<solid_with_pocket,2> { solid_with_pocket() : Object("solid_with_pocket") {}
		non_negative_length_measure::Out floor_blend_radius;
		plane_angle_measure::Out draft_angle;
    };

    // C++ wrapper for solid_with_circular_pocket
    struct solid_with_circular_pocket : solid_with_pocket, ObjectHelper<solid_with_circular_pocket,1> { solid_with_circular_pocket() : Object("solid_with_circular_pocket") {}
		positive_length_measure::Out pocket_radius;
    };

    // C++ wrapper for solid_with_protrusion
    struct solid_with_protrusion : modified_solid_with_placed_configuration, ObjectHelper<solid_with_protrusion,2> { solid_with_protrusion() : Object("solid_with_protrusion") {}
		positive_length_measure::Out protrusion_height;
		plane_angle_measure::Out protrusion_draft_angle;
    };

    // C++ wrapper for solid_with_circular_protrusion
    struct solid_with_circular_protrusion : solid_with_protrusion, ObjectHelper<solid_with_circular_protrusion,1> { solid_with_circular_protrusion() : Object("solid_with_circular_protrusion") {}
		positive_length_measure::Out protrusion_radius;
    };

    // C++ wrapper for solid_with_hole
    struct solid_with_hole : solid_with_depression, ObjectHelper<solid_with_hole,0> { solid_with_hole() : Object("solid_with_hole") {}

    };

    // C++ wrapper for solid_with_stepped_round_hole
    struct solid_with_stepped_round_hole : solid_with_hole, ObjectHelper<solid_with_stepped_round_hole,1> { solid_with_stepped_round_hole() : Object("solid_with_stepped_round_hole") {}
		positive_integer::Out segments;
    };

    // C++ wrapper for solid_with_conical_bottom_round_hole
    struct solid_with_conical_bottom_round_hole : solid_with_stepped_round_hole, ObjectHelper<solid_with_conical_bottom_round_hole,2> { solid_with_conical_bottom_round_hole() : Object("solid_with_conical_bottom_round_hole") {}
		positive_plane_angle_measure::Out semi_apex_angle;
		non_negative_length_measure::Out tip_radius;
    };

    // C++ wrapper for solid_with_constant_radius_edge_blend
    struct solid_with_constant_radius_edge_blend : edge_blended_solid, ObjectHelper<solid_with_constant_radius_edge_blend,1> { solid_with_constant_radius_edge_blend() : Object("solid_with_constant_radius_edge_blend") {}
		positive_length_measure::Out radius;
    };

    // C++ wrapper for solid_with_slot
    struct solid_with_slot : solid_with_depression, ObjectHelper<solid_with_slot,2> { solid_with_slot() : Object("solid_with_slot") {}
		positive_length_measure::Out slot_width;
		ListOf< LOGICAL, 2, 2 >::Out closed_ends;
    };

    // C++ wrapper for solid_with_curved_slot
    struct solid_with_curved_slot : solid_with_slot, ObjectHelper<solid_with_curved_slot,1> { solid_with_curved_slot() : Object("solid_with_curved_slot") {}
		Lazy< bounded_curve > slot_centreline;
    };

    // C++ wrapper for solid_with_double_offset_chamfer
    struct solid_with_double_offset_chamfer : solid_with_chamfered_edges, ObjectHelper<solid_with_double_offset_chamfer,2> { solid_with_double_offset_chamfer() : Object("solid_with_double_offset_chamfer") {}
		positive_length_measure::Out left_offset_distance;
		positive_length_measure::Out right_offset_distance;
    };

    // C++ wrapper for solid_with_flat_bottom_round_hole
    struct solid_with_flat_bottom_round_hole : solid_with_stepped_round_hole, ObjectHelper<solid_with_flat_bottom_round_hole,1> { solid_with_flat_bottom_round_hole() : Object("solid_with_flat_bottom_round_hole") {}
		non_negative_length_measure::Out fillet_radius;
    };

    // C++ wrapper for solid_with_general_pocket
    struct solid_with_general_pocket : solid_with_pocket, ObjectHelper<solid_with_general_pocket,2> { solid_with_general_pocket() : Object("solid_with_general_pocket") {}
		Lazy< positioned_sketch > profile;
		Lazy< point > reference_point;
    };

    // C++ wrapper for solid_with_general_protrusion
    struct solid_with_general_protrusion : solid_with_protrusion, ObjectHelper<solid_with_general_protrusion,2> { solid_with_general_protrusion() : Object("solid_with_general_protrusion") {}
		Lazy< positioned_sketch > profile;
		Lazy< point > reference_point;
    };

    // C++ wrapper for solid_with_groove
    struct solid_with_groove : solid_with_depression, ObjectHelper<solid_with_groove,5> { solid_with_groove() : Object("solid_with_groove") {}
		positive_length_measure::Out groove_radius;
		positive_length_measure::Out groove_width;
		plane_angle_measure::Out draft_angle;
		non_negative_length_measure::Out floor_fillet_radius;
		BOOLEAN::Out external_groove;
    };

    // C++ wrapper for solid_with_incomplete_circular_pattern
    struct solid_with_incomplete_circular_pattern : solid_with_circular_pattern, ObjectHelper<solid_with_incomplete_circular_pattern,1> { solid_with_incomplete_circular_pattern() : Object("solid_with_incomplete_circular_pattern") {}
		ListOf< positive_integer, 1, 0 >::Out omitted_instances;
    };

    // C++ wrapper for solid_with_rectangular_pattern
    struct solid_with_rectangular_pattern : solid_with_shape_element_pattern, ObjectHelper<solid_with_rectangular_pattern,4> { solid_with_rectangular_pattern() : Object("solid_with_rectangular_pattern") {}
		positive_integer::Out row_count;
		positive_integer::Out column_count;
		length_measure::Out row_spacing;
		length_measure::Out column_spacing;
    };

    // C++ wrapper for solid_with_incomplete_rectangular_pattern
    struct solid_with_incomplete_rectangular_pattern : solid_with_rectangular_pattern, ObjectHelper<solid_with_incomplete_rectangular_pattern,0> { solid_with_incomplete_rectangular_pattern() : Object("solid_with_incomplete_rectangular_pattern") {}

    };

    // C++ wrapper for solid_with_rectangular_pocket
    struct solid_with_rectangular_pocket : solid_with_pocket, ObjectHelper<solid_with_rectangular_pocket,3> { solid_with_rectangular_pocket() : Object("solid_with_rectangular_pocket") {}
		positive_length_measure::Out pocket_length;
		positive_length_measure::Out pocket_width;
		non_negative_length_measure::Out corner_radius;
    };

    // C++ wrapper for solid_with_rectangular_protrusion
    struct solid_with_rectangular_protrusion : solid_with_protrusion, ObjectHelper<solid_with_rectangular_protrusion,3> { solid_with_rectangular_protrusion() : Object("solid_with_rectangular_protrusion") {}
		positive_length_measure::Out protrusion_length;
		positive_length_measure::Out protrusion_width;
		non_negative_length_measure::Out protrusion_corner_radius;
    };

    // C++ wrapper for solid_with_single_offset_chamfer
    struct solid_with_single_offset_chamfer : solid_with_chamfered_edges, ObjectHelper<solid_with_single_offset_chamfer,1> { solid_with_single_offset_chamfer() : Object("solid_with_single_offset_chamfer") {}
		positive_length_measure::Out offset_distance;
    };

    // C++ wrapper for solid_with_spherical_bottom_round_hole
    struct solid_with_spherical_bottom_round_hole : solid_with_stepped_round_hole, ObjectHelper<solid_with_spherical_bottom_round_hole,1> { solid_with_spherical_bottom_round_hole() : Object("solid_with_spherical_bottom_round_hole") {}
		positive_length_measure::Out sphere_radius;
    };

    // C++ wrapper for solid_with_stepped_round_hole_and_conical_transitions
    struct solid_with_stepped_round_hole_and_conical_transitions : solid_with_stepped_round_hole, ObjectHelper<solid_with_stepped_round_hole_and_conical_transitions,1> { solid_with_stepped_round_hole_and_conical_transitions() : Object("solid_with_stepped_round_hole_and_conical_transitions") {}
		ListOf< Lazy< conical_stepped_hole_transition >, 1, 0 > conical_transitions;
    };

    // C++ wrapper for solid_with_straight_slot
    struct solid_with_straight_slot : solid_with_slot, ObjectHelper<solid_with_straight_slot,1> { solid_with_straight_slot() : Object("solid_with_straight_slot") {}
		positive_length_measure::Out slot_length;
    };

    // C++ wrapper for solid_with_tee_section_slot
    struct solid_with_tee_section_slot : solid_with_slot, ObjectHelper<solid_with_tee_section_slot,2> { solid_with_tee_section_slot() : Object("solid_with_tee_section_slot") {}
		positive_length_measure::Out tee_section_width;
		positive_length_measure::Out collar_depth;
    };

    // C++ wrapper for solid_with_through_depression
    struct solid_with_through_depression : solid_with_depression, ObjectHelper<solid_with_through_depression,1> { solid_with_through_depression() : Object("solid_with_through_depression") {}
		ListOf< Lazy< face_surface >, 1, 0 > exit_faces;
    };

    // C++ wrapper for solid_with_trapezoidal_section_slot
    struct solid_with_trapezoidal_section_slot : solid_with_slot, ObjectHelper<solid_with_trapezoidal_section_slot,2> { solid_with_trapezoidal_section_slot() : Object("solid_with_trapezoidal_section_slot") {}
		plane_angle_measure::Out draft_angle;
		non_negative_length_measure::Out floor_fillet_radius;
    };

    // C++ wrapper for solid_with_variable_radius_edge_blend
    struct solid_with_variable_radius_edge_blend :  ObjectHelper<solid_with_variable_radius_edge_blend,3> { solid_with_variable_radius_edge_blend() : Object("solid_with_variable_radius_edge_blend") {}
		ListOf< Lazy< point >, 2, 0 > point_list;
		ListOf< positive_length_measure, 2, 0 >::Out radius_list;
		ListOf< blend_radius_variation_type, 1, 0 >::Out edge_function_list;
    };

    // C++ wrapper for source_for_requirement
    struct source_for_requirement : group_assignment, ObjectHelper<source_for_requirement,1> { source_for_requirement() : Object("source_for_requirement") {}
		ListOf< requirement_source_item, 1, 1 >::Out items;
    };

    // C++ wrapper for sourced_requirement
    struct sourced_requirement : group_assignment, ObjectHelper<sourced_requirement,1> { sourced_requirement() : Object("sourced_requirement") {}
		ListOf< Lazy< product_definition >, 1, 1 > items;
    };

    // C++ wrapper for specification_definition
    struct specification_definition : product_definition, ObjectHelper<specification_definition,0> { specification_definition() : Object("specification_definition") {}

    };

    // C++ wrapper for specified_higher_usage_occurrence
    struct specified_higher_usage_occurrence : assembly_component_usage, ObjectHelper<specified_higher_usage_occurrence,2> { specified_higher_usage_occurrence() : Object("specified_higher_usage_occurrence") {}
		Lazy< assembly_component_usage > upper_usage;
		Lazy< next_assembly_usage_occurrence > next_usage;
    };

    // C++ wrapper for sphere
    struct sphere : geometric_representation_item, ObjectHelper<sphere,2> { sphere() : Object("sphere") {}
		positive_length_measure::Out radius;
		Lazy< point > centre;
    };

    // C++ wrapper for spherical_surface
    struct spherical_surface : elementary_surface, ObjectHelper<spherical_surface,1> { spherical_surface() : Object("spherical_surface") {}
		positive_length_measure::Out radius;
    };

    // C++ wrapper for start_request
    struct start_request : action_request_assignment, ObjectHelper<start_request,1> { start_request() : Object("start_request") {}
		ListOf< start_request_item, 1, 0 >::Out items;
    };

    // C++ wrapper for start_work
    struct start_work : action_assignment, ObjectHelper<start_work,1> { start_work() : Object("start_work") {}
		ListOf< work_item, 1, 0 >::Out items;
    };

    // C++ wrapper for straightness_tolerance
    struct straightness_tolerance : geometric_tolerance, ObjectHelper<straightness_tolerance,0> { straightness_tolerance() : Object("straightness_tolerance") {}

    };

    // C++ wrapper for structured_dimension_callout
    struct structured_dimension_callout : draughting_callout, ObjectHelper<structured_dimension_callout,0> { structured_dimension_callout() : Object("structured_dimension_callout") {}

    };

    // C++ wrapper for structured_text_composition
    struct structured_text_composition : compound_representation_item, ObjectHelper<structured_text_composition,0> { structured_text_composition() : Object("structured_text_composition") {}

    };

    // C++ wrapper for structured_text_representation
    struct structured_text_representation : representation, ObjectHelper<structured_text_representation,0> { structured_text_representation() : Object("structured_text_representation") {}

    };

    // C++ wrapper for subedge
    struct subedge : edge, ObjectHelper<subedge,1> { subedge() : Object("subedge") {}
		Lazy< edge > parent_edge;
    };

    // C++ wrapper for subface
    struct subface : face, ObjectHelper<subface,1> { subface() : Object("subface") {}
		Lazy< face > parent_face;
    };

    // C++ wrapper for supplied_part_relationship
    struct supplied_part_relationship : product_definition_relationship, ObjectHelper<supplied_part_relationship,0> { supplied_part_relationship() : Object("supplied_part_relationship") {}

    };

    // C++ wrapper for surface_condition_callout
    struct surface_condition_callout : draughting_callout, ObjectHelper<surface_condition_callout,0> { surface_condition_callout() : Object("surface_condition_callout") {}

    };

    // C++ wrapper for swept_surface
    struct swept_surface : surface, ObjectHelper<swept_surface,1> { swept_surface() : Object("swept_surface") {}
		Lazy< curve > swept_curve;
    };

    // C++ wrapper for surface_of_linear_extrusion
    struct surface_of_linear_extrusion : swept_surface, ObjectHelper<surface_of_linear_extrusion,1> { surface_of_linear_extrusion() : Object("surface_of_linear_extrusion") {}
		Lazy< vector > extrusion_axis;
    };

    // C++ wrapper for surface_of_revolution
    struct surface_of_revolution : swept_surface, ObjectHelper<surface_of_revolution,1> { surface_of_revolution() : Object("surface_of_revolution") {}
		Lazy< axis1_placement > axis_position;
    };

    // C++ wrapper for surface_patch
    struct surface_patch : founded_item, ObjectHelper<surface_patch,5> { surface_patch() : Object("surface_patch") {}
		Lazy< bounded_surface > parent_surface;
		transition_code::Out u_transition;
		transition_code::Out v_transition;
		BOOLEAN::Out u_sense;
		BOOLEAN::Out v_sense;
    };

    // C++ wrapper for surface_profile_tolerance
    struct surface_profile_tolerance : geometric_tolerance, ObjectHelper<surface_profile_tolerance,0> { surface_profile_tolerance() : Object("surface_profile_tolerance") {}

    };

    // C++ wrapper for surface_replica
    struct surface_replica : surface, ObjectHelper<surface_replica,2> { surface_replica() : Object("surface_replica") {}
		Lazy< surface > parent_surface;
		Lazy< cartesian_transformation_operator_3d > transformation;
    };

    // C++ wrapper for surface_side_style
    struct surface_side_style : founded_item, ObjectHelper<surface_side_style,2> { surface_side_style() : Object("surface_side_style") {}
		label::Out name;
		ListOf< surface_style_element_select, 1, 7 >::Out styles;
    };

    // C++ wrapper for surface_style_boundary
    struct surface_style_boundary : founded_item, ObjectHelper<surface_style_boundary,1> { surface_style_boundary() : Object("surface_style_boundary") {}
		curve_or_render::Out style_of_boundary;
    };

    // C++ wrapper for surface_style_control_grid
    struct surface_style_control_grid : founded_item, ObjectHelper<surface_style_control_grid,1> { surface_style_control_grid() : Object("surface_style_control_grid") {}
		curve_or_render::Out style_of_control_grid;
    };

    // C++ wrapper for surface_style_fill_area
    struct surface_style_fill_area : founded_item, ObjectHelper<surface_style_fill_area,1> { surface_style_fill_area() : Object("surface_style_fill_area") {}
		Lazy< fill_area_style > fill_area;
    };

    // C++ wrapper for surface_style_parameter_line
    struct surface_style_parameter_line : founded_item, ObjectHelper<surface_style_parameter_line,2> { surface_style_parameter_line() : Object("surface_style_parameter_line") {}
		curve_or_render::Out style_of_parameter_lines;
		ListOf< direction_count_select, 1, 2 >::Out direction_counts;
    };

    // C++ wrapper for surface_style_reflectance_ambient
    struct surface_style_reflectance_ambient :  ObjectHelper<surface_style_reflectance_ambient,1> { surface_style_reflectance_ambient() : Object("surface_style_reflectance_ambient") {}
		REAL::Out ambient_reflectance;
    };

    // C++ wrapper for surface_style_reflectance_ambient_diffuse
    struct surface_style_reflectance_ambient_diffuse : surface_style_reflectance_ambient, ObjectHelper<surface_style_reflectance_ambient_diffuse,1> { surface_style_reflectance_ambient_diffuse() : Object("surface_style_reflectance_ambient_diffuse") {}
		REAL::Out diffuse_reflectance;
    };

    // C++ wrapper for surface_style_reflectance_ambient_diffuse_specular
    struct surface_style_reflectance_ambient_diffuse_specular : surface_style_reflectance_ambient_diffuse, ObjectHelper<surface_style_reflectance_ambient_diffuse_specular,3> { surface_style_reflectance_ambient_diffuse_specular() : Object("surface_style_reflectance_ambient_diffuse_specular") {}
		REAL::Out specular_reflectance;
		REAL::Out specular_exponent;
		Lazy< colour > specular_colour;
    };

    // C++ wrapper for surface_style_rendering
    struct surface_style_rendering :  ObjectHelper<surface_style_rendering,2> { surface_style_rendering() : Object("surface_style_rendering") {}
		shading_surface_method::Out rendering_method;
		Lazy< colour > surface_colour;
    };

    // C++ wrapper for surface_style_rendering_with_properties
    struct surface_style_rendering_with_properties : surface_style_rendering, ObjectHelper<surface_style_rendering_with_properties,1> { surface_style_rendering_with_properties() : Object("surface_style_rendering_with_properties") {}
		ListOf< rendering_properties_select, 1, 2 >::Out properties;
    };

    // C++ wrapper for surface_style_segmentation_curve
    struct surface_style_segmentation_curve : founded_item, ObjectHelper<surface_style_segmentation_curve,1> { surface_style_segmentation_curve() : Object("surface_style_segmentation_curve") {}
		curve_or_render::Out style_of_segmentation_curve;
    };

    // C++ wrapper for surface_style_silhouette
    struct surface_style_silhouette : founded_item, ObjectHelper<surface_style_silhouette,1> { surface_style_silhouette() : Object("surface_style_silhouette") {}
		curve_or_render::Out style_of_silhouette;
    };

    // C++ wrapper for surface_style_usage
    struct surface_style_usage : founded_item, ObjectHelper<surface_style_usage,2> { surface_style_usage() : Object("surface_style_usage") {}
		surface_side::Out side;
		surface_side_style_select::Out style;
    };

    // C++ wrapper for surface_texture_representation
    struct surface_texture_representation : representation, ObjectHelper<surface_texture_representation,0> { surface_texture_representation() : Object("surface_texture_representation") {}

    };

    // C++ wrapper for surfaced_open_shell
    struct surfaced_open_shell : open_shell, ObjectHelper<surfaced_open_shell,0> { surfaced_open_shell() : Object("surfaced_open_shell") {}

    };

    // C++ wrapper for swept_disk_solid
    struct swept_disk_solid : solid_model, ObjectHelper<swept_disk_solid,5> { swept_disk_solid() : Object("swept_disk_solid") {}
		Lazy< curve > directrix;
		positive_length_measure::Out radius;
		Maybe< positive_length_measure::Out > inner_radius;
		REAL::Out start_param;
		REAL::Out end_param;
    };

    // C++ wrapper for symbol
    struct symbol : representation_item, ObjectHelper<symbol,0> { symbol() : Object("symbol") {}

    };

    // C++ wrapper for symbol_representation_map
    struct symbol_representation_map : representation_map, ObjectHelper<symbol_representation_map,0> { symbol_representation_map() : Object("symbol_representation_map") {}

    };

    // C++ wrapper for symbol_style
    struct symbol_style : founded_item, ObjectHelper<symbol_style,2> { symbol_style() : Object("symbol_style") {}
		label::Out name;
		symbol_style_select::Out style_of_symbol;
    };

    // C++ wrapper for symbol_target
    struct symbol_target : geometric_representation_item, ObjectHelper<symbol_target,3> { symbol_target() : Object("symbol_target") {}
		axis2_placement::Out placement;
		positive_ratio_measure::Out x_scale;
		positive_ratio_measure::Out y_scale;
    };

    // C++ wrapper for symmetric_shape_aspect
    struct symmetric_shape_aspect : shape_aspect, ObjectHelper<symmetric_shape_aspect,0> { symmetric_shape_aspect() : Object("symmetric_shape_aspect") {}

    };

    // C++ wrapper for symmetry_tolerance
    struct symmetry_tolerance : geometric_tolerance_with_datum_reference, ObjectHelper<symmetry_tolerance,0> { symmetry_tolerance() : Object("symmetry_tolerance") {}

    };

    // C++ wrapper for table_representation_item
    struct table_representation_item : compound_representation_item, ObjectHelper<table_representation_item,0> { table_representation_item() : Object("table_representation_item") {}

    };

    // C++ wrapper for tactile_appearance_representation
    struct tactile_appearance_representation : representation, ObjectHelper<tactile_appearance_representation,0> { tactile_appearance_representation() : Object("tactile_appearance_representation") {}

    };

    // C++ wrapper for tagged_text_format
    struct tagged_text_format : representation_context, ObjectHelper<tagged_text_format,0> { tagged_text_format() : Object("tagged_text_format") {}

    };

    // C++ wrapper for tagged_text_item
    struct tagged_text_item : descriptive_representation_item, ObjectHelper<tagged_text_item,0> { tagged_text_item() : Object("tagged_text_item") {}

    };

    // C++ wrapper for tangent
    struct tangent : derived_shape_aspect, ObjectHelper<tangent,0> { tangent() : Object("tangent") {}

    };

    // C++ wrapper for text_literal_with_associated_curves
    struct text_literal_with_associated_curves : text_literal, ObjectHelper<text_literal_with_associated_curves,1> { text_literal_with_associated_curves() : Object("text_literal_with_associated_curves") {}
		ListOf< Lazy< curve >, 1, 0 > associated_curves;
    };

    // C++ wrapper for text_literal_with_blanking_box
    struct text_literal_with_blanking_box : text_literal, ObjectHelper<text_literal_with_blanking_box,1> { text_literal_with_blanking_box() : Object("text_literal_with_blanking_box") {}
		Lazy< planar_box > blanking;
    };

    // C++ wrapper for text_literal_with_extent
    struct text_literal_with_extent : text_literal, ObjectHelper<text_literal_with_extent,1> { text_literal_with_extent() : Object("text_literal_with_extent") {}
		Lazy< planar_extent > extent;
    };

    // C++ wrapper for text_string_representation
    struct text_string_representation : representation, ObjectHelper<text_string_representation,0> { text_string_representation() : Object("text_string_representation") {}

    };

    // C++ wrapper for text_style
    struct text_style : founded_item, ObjectHelper<text_style,2> { text_style() : Object("text_style") {}
		label::Out name;
		character_style_select::Out character_appearance;
    };

    // C++ wrapper for text_style_with_box_characteristics
    struct text_style_with_box_characteristics : text_style, ObjectHelper<text_style_with_box_characteristics,1> { text_style_with_box_characteristics() : Object("text_style_with_box_characteristics") {}
		ListOf< box_characteristic_select, 1, 4 >::Out characteristics;
    };

    // C++ wrapper for text_style_with_mirror
    struct text_style_with_mirror : text_style, ObjectHelper<text_style_with_mirror,1> { text_style_with_mirror() : Object("text_style_with_mirror") {}
		axis2_placement::Out mirror_placement;
    };

    // C++ wrapper for text_style_with_spacing
    struct text_style_with_spacing : text_style, ObjectHelper<text_style_with_spacing,1> { text_style_with_spacing() : Object("text_style_with_spacing") {}
		character_spacing_select::Out character_spacing;
    };

    // C++ wrapper for thermal_resistance_measure_with_unit
    struct thermal_resistance_measure_with_unit : measure_with_unit, ObjectHelper<thermal_resistance_measure_with_unit,0> { thermal_resistance_measure_with_unit() : Object("thermal_resistance_measure_with_unit") {}

    };

    // C++ wrapper for thermal_resistance_unit
    struct thermal_resistance_unit : derived_unit, ObjectHelper<thermal_resistance_unit,0> { thermal_resistance_unit() : Object("thermal_resistance_unit") {}

    };

    // C++ wrapper for thermodynamic_temperature_measure_with_unit
    struct thermodynamic_temperature_measure_with_unit : measure_with_unit, ObjectHelper<thermodynamic_temperature_measure_with_unit,0> { thermodynamic_temperature_measure_with_unit() : Object("thermodynamic_temperature_measure_with_unit") {}

    };

    // C++ wrapper for thermodynamic_temperature_unit
    struct thermodynamic_temperature_unit : named_unit, ObjectHelper<thermodynamic_temperature_unit,0> { thermodynamic_temperature_unit() : Object("thermodynamic_temperature_unit") {}

    };

    // C++ wrapper for thickened_face_solid
    struct thickened_face_solid : solid_model, ObjectHelper<thickened_face_solid,3> { thickened_face_solid() : Object("thickened_face_solid") {}
		generalized_surface_select::Out base_element;
		length_measure::Out offset1;
		length_measure::Out offset2;
    };

    // C++ wrapper for thickness_laminate_definition
    struct thickness_laminate_definition : product_definition, ObjectHelper<thickness_laminate_definition,0> { thickness_laminate_definition() : Object("thickness_laminate_definition") {}

    };

    // C++ wrapper for thickness_laminate_table
    struct thickness_laminate_table : zone_structural_makeup, ObjectHelper<thickness_laminate_table,0> { thickness_laminate_table() : Object("thickness_laminate_table") {}

    };

    // C++ wrapper for time_interval
    struct time_interval :  ObjectHelper<time_interval,3> { time_interval() : Object("time_interval") {}
		identifier::Out id;
		label::Out name;
		Maybe< text::Out > description;
    };

    // C++ wrapper for time_interval_based_effectivity
    struct time_interval_based_effectivity : effectivity, ObjectHelper<time_interval_based_effectivity,1> { time_interval_based_effectivity() : Object("time_interval_based_effectivity") {}
		Lazy< time_interval > effectivity_period;
    };

    // C++ wrapper for time_interval_with_bounds
    struct time_interval_with_bounds : time_interval, ObjectHelper<time_interval_with_bounds,3> { time_interval_with_bounds() : Object("time_interval_with_bounds") {}
		Maybe< date_time_or_event_occurrence::Out > primary_bound;
		Maybe< date_time_or_event_occurrence::Out > secondary_bound;
		Maybe< Lazy< time_measure_with_unit > > duration;
    };

    // C++ wrapper for time_measure_with_unit
    struct time_measure_with_unit : measure_with_unit, ObjectHelper<time_measure_with_unit,0> { time_measure_with_unit() : Object("time_measure_with_unit") {}

    };

    // C++ wrapper for time_unit
    struct time_unit : named_unit, ObjectHelper<time_unit,0> { time_unit() : Object("time_unit") {}

    };

    // C++ wrapper for tolerance_zone
    struct tolerance_zone : shape_aspect, ObjectHelper<tolerance_zone,2> { tolerance_zone() : Object("tolerance_zone") {}
		ListOf< Lazy< geometric_tolerance >, 1, 0 > defining_tolerance;
		Lazy< NotImplemented > form;
    };

    // C++ wrapper for torus
    struct torus : geometric_representation_item, ObjectHelper<torus,3> { torus() : Object("torus") {}
		Lazy< axis1_placement > position;
		positive_length_measure::Out major_radius;
		positive_length_measure::Out minor_radius;
    };

    // C++ wrapper for total_runout_tolerance
    struct total_runout_tolerance : geometric_tolerance_with_datum_reference, ObjectHelper<total_runout_tolerance,0> { total_runout_tolerance() : Object("total_runout_tolerance") {}

    };

    // C++ wrapper for track_blended_solid
    struct track_blended_solid : edge_blended_solid, ObjectHelper<track_blended_solid,0> { track_blended_solid() : Object("track_blended_solid") {}

    };

    // C++ wrapper for track_blended_solid_with_end_conditions
    struct track_blended_solid_with_end_conditions : track_blended_solid, ObjectHelper<track_blended_solid_with_end_conditions,1> { track_blended_solid_with_end_conditions() : Object("track_blended_solid_with_end_conditions") {}
		ListOf< blend_end_condition_select, 2, 2 >::Out end_conditions;
    };

    // C++ wrapper for trimmed_curve
    struct trimmed_curve : bounded_curve, ObjectHelper<trimmed_curve,5> { trimmed_curve() : Object("trimmed_curve") {}
		Lazy< curve > basis_curve;
		ListOf< trimming_select, 1, 2 >::Out trim_1;
		ListOf< trimming_select, 1, 2 >::Out trim_2;
		BOOLEAN::Out sense_agreement;
		trimming_preference::Out master_representation;
    };

    // C++ wrapper for two_direction_repeat_factor
    struct two_direction_repeat_factor : one_direction_repeat_factor, ObjectHelper<two_direction_repeat_factor,1> { two_direction_repeat_factor() : Object("two_direction_repeat_factor") {}
		Lazy< vector > second_repeat_factor;
    };

    // C++ wrapper for unary_generic_expression
    struct unary_generic_expression : generic_expression, ObjectHelper<unary_generic_expression,1> { unary_generic_expression() : Object("unary_generic_expression") {}
		Lazy< generic_expression > operand;
    };

    // C++ wrapper for unary_numeric_expression
    struct unary_numeric_expression :  ObjectHelper<unary_numeric_expression,0> { unary_numeric_expression() : Object("unary_numeric_expression") {}

    };

    // C++ wrapper for uncertainty_assigned_representation
    struct uncertainty_assigned_representation : representation, ObjectHelper<uncertainty_assigned_representation,1> { uncertainty_assigned_representation() : Object("uncertainty_assigned_representation") {}
		ListOf< Lazy< uncertainty_measure_with_unit >, 1, 0 > uncertainty;
    };

    // C++ wrapper for uncertainty_measure_with_unit
    struct uncertainty_measure_with_unit : measure_with_unit, ObjectHelper<uncertainty_measure_with_unit,2> { uncertainty_measure_with_unit() : Object("uncertainty_measure_with_unit") {}
		label::Out name;
		Maybe< text::Out > description;
    };

    // C++ wrapper for uniform_curve
    struct uniform_curve : b_spline_curve, ObjectHelper<uniform_curve,0> { uniform_curve() : Object("uniform_curve") {}

    };

    // C++ wrapper for uniform_resource_identifier
    struct uniform_resource_identifier : descriptive_representation_item, ObjectHelper<uniform_resource_identifier,0> { uniform_resource_identifier() : Object("uniform_resource_identifier") {}

    };

    // C++ wrapper for uniform_surface
    struct uniform_surface : b_spline_surface, ObjectHelper<uniform_surface,0> { uniform_surface() : Object("uniform_surface") {}

    };

    // C++ wrapper for usage_association
    struct usage_association : action_method_relationship, ObjectHelper<usage_association,0> { usage_association() : Object("usage_association") {}

    };

    // C++ wrapper for user_defined_curve_font
    struct user_defined_curve_font :  ObjectHelper<user_defined_curve_font,0> { user_defined_curve_font() : Object("user_defined_curve_font") {}

    };

    // C++ wrapper for user_defined_marker
    struct user_defined_marker :  ObjectHelper<user_defined_marker,0> { user_defined_marker() : Object("user_defined_marker") {}

    };

    // C++ wrapper for user_defined_terminator_symbol
    struct user_defined_terminator_symbol :  ObjectHelper<user_defined_terminator_symbol,0> { user_defined_terminator_symbol() : Object("user_defined_terminator_symbol") {}

    };

    // C++ wrapper for user_selected_shape_elements
    struct user_selected_shape_elements : user_selected_elements, ObjectHelper<user_selected_shape_elements,0> { user_selected_shape_elements() : Object("user_selected_shape_elements") {}

    };

    // C++ wrapper for value_range
    struct value_range : compound_representation_item, ObjectHelper<value_range,0> { value_range() : Object("value_range") {}

    };

    // C++ wrapper for value_representation_item
    struct value_representation_item : representation_item, ObjectHelper<value_representation_item,1> { value_representation_item() : Object("value_representation_item") {}
		measure_value::Out value_component;
    };

    // C++ wrapper for variable_semantics
    struct variable_semantics :  ObjectHelper<variable_semantics,0> { variable_semantics() : Object("variable_semantics") {}

    };

    // C++ wrapper for variational_representation_item
    struct variational_representation_item : representation_item, ObjectHelper<variational_representation_item,0> { variational_representation_item() : Object("variational_representation_item") {}

    };

    // C++ wrapper for vector
    struct vector : geometric_representation_item, ObjectHelper<vector,2> { vector() : Object("vector") {}
		Lazy< direction > orientation;
		length_measure::Out magnitude;
    };

    // C++ wrapper for vector_style
    struct vector_style :  ObjectHelper<vector_style,0> { vector_style() : Object("vector_style") {}

    };

    // C++ wrapper for velocity_measure_with_unit
    struct velocity_measure_with_unit : measure_with_unit, ObjectHelper<velocity_measure_with_unit,0> { velocity_measure_with_unit() : Object("velocity_measure_with_unit") {}

    };

    // C++ wrapper for velocity_unit
    struct velocity_unit : derived_unit, ObjectHelper<velocity_unit,0> { velocity_unit() : Object("velocity_unit") {}

    };

    // C++ wrapper for vertex
    struct vertex : topological_representation_item, ObjectHelper<vertex,0> { vertex() : Object("vertex") {}

    };

    // C++ wrapper for vertex_loop
    struct vertex_loop : loop, ObjectHelper<vertex_loop,1> { vertex_loop() : Object("vertex_loop") {}
		Lazy< vertex > loop_vertex;
    };

    // C++ wrapper for vertex_point
    struct vertex_point :  ObjectHelper<vertex_point,1> { vertex_point() : Object("vertex_point") {}
		Lazy< point > vertex_geometry;
    };

    // C++ wrapper for vertex_shell
    struct vertex_shell : topological_representation_item, ObjectHelper<vertex_shell,1> { vertex_shell() : Object("vertex_shell") {}
		Lazy< vertex_loop > vertex_shell_extent;
    };

    // C++ wrapper for view_volume
    struct view_volume : founded_item, ObjectHelper<view_volume,9> { view_volume() : Object("view_volume") {}
		central_or_parallel::Out projection_type;
		Lazy< cartesian_point > projection_point;
		length_measure::Out view_plane_distance;
		length_measure::Out front_plane_distance;
		BOOLEAN::Out front_plane_clipping;
		length_measure::Out back_plane_distance;
		BOOLEAN::Out back_plane_clipping;
		BOOLEAN::Out view_volume_sides_clipping;
		Lazy< planar_box > view_window;
    };

    // C++ wrapper for visual_appearance_representation
    struct visual_appearance_representation : representation, ObjectHelper<visual_appearance_representation,0> { visual_appearance_representation() : Object("visual_appearance_representation") {}

    };

    // C++ wrapper for volume_measure_with_unit
    struct volume_measure_with_unit : measure_with_unit, ObjectHelper<volume_measure_with_unit,0> { volume_measure_with_unit() : Object("volume_measure_with_unit") {}

    };

    // C++ wrapper for volume_unit
    struct volume_unit : derived_unit, ObjectHelper<volume_unit,0> { volume_unit() : Object("volume_unit") {}

    };

    // C++ wrapper for week_of_year_and_day_date
    struct week_of_year_and_day_date : date, ObjectHelper<week_of_year_and_day_date,2> { week_of_year_and_day_date() : Object("week_of_year_and_day_date") {}
		week_in_year_number::Out week_component;
		Maybe< day_in_week_number::Out > day_component;
    };

    // C++ wrapper for wire_shell
    struct wire_shell : topological_representation_item, ObjectHelper<wire_shell,1> { wire_shell() : Object("wire_shell") {}
		ListOf< Lazy< loop >, 1, 0 > wire_shell_extent;
    };

    // C++ wrapper for year_month
    struct year_month : date, ObjectHelper<year_month,1> { year_month() : Object("year_month") {}
		month_in_year_number::Out month_component;
    };

	void GetSchema(EXPRESS::ConversionSchema& out);

} //! StepFile
namespace STEP {

	// ******************************************************************************
	// Converter stubs
	// ******************************************************************************
	
#define DECL_CONV_STUB(type) template <> size_t GenericFill<StepFile::type>(const STEP::DB& db, const EXPRESS::LIST& params, StepFile::type* in)
	
	DECL_CONV_STUB(measure_with_unit);
	DECL_CONV_STUB(absorbed_dose_measure_with_unit);
	DECL_CONV_STUB(derived_unit);
	DECL_CONV_STUB(absorbed_dose_unit);
	DECL_CONV_STUB(abstract_variable);
	DECL_CONV_STUB(acceleration_measure_with_unit);
	DECL_CONV_STUB(acceleration_unit);
	DECL_CONV_STUB(action);
	DECL_CONV_STUB(action_assignment);
	DECL_CONV_STUB(action_method);
	DECL_CONV_STUB(action_method_assignment);
	DECL_CONV_STUB(action_method_relationship);
	DECL_CONV_STUB(action_request_assignment);
	DECL_CONV_STUB(address);
	DECL_CONV_STUB(representation);
	DECL_CONV_STUB(shape_representation);
	DECL_CONV_STUB(advanced_brep_shape_representation);
	DECL_CONV_STUB(face_surface);
	DECL_CONV_STUB(advanced_face);
	DECL_CONV_STUB(amount_of_substance_measure_with_unit);
	DECL_CONV_STUB(named_unit);
	DECL_CONV_STUB(amount_of_substance_unit);
	DECL_CONV_STUB(angle_direction_reference);
	DECL_CONV_STUB(representation_item);
	DECL_CONV_STUB(geometric_representation_item);
	DECL_CONV_STUB(draughting_callout);
	DECL_CONV_STUB(dimension_curve_directed_callout);
	DECL_CONV_STUB(angular_dimension);
	DECL_CONV_STUB(shape_aspect_relationship);
	DECL_CONV_STUB(dimensional_location);
	DECL_CONV_STUB(angular_location);
	DECL_CONV_STUB(dimensional_size);
	DECL_CONV_STUB(angular_size);
	DECL_CONV_STUB(geometric_tolerance);
	DECL_CONV_STUB(geometric_tolerance_with_datum_reference);
	DECL_CONV_STUB(angularity_tolerance);
	DECL_CONV_STUB(styled_item);
	DECL_CONV_STUB(annotation_occurrence);
	DECL_CONV_STUB(annotation_curve_occurrence);
	DECL_CONV_STUB(annotation_fill_area);
	DECL_CONV_STUB(annotation_fill_area_occurrence);
	DECL_CONV_STUB(annotation_occurrence_relationship);
	DECL_CONV_STUB(annotation_occurrence_associativity);
	DECL_CONV_STUB(annotation_plane);
	DECL_CONV_STUB(annotation_symbol_occurrence);
	DECL_CONV_STUB(annotation_subfigure_occurrence);
	DECL_CONV_STUB(mapped_item);
	DECL_CONV_STUB(annotation_symbol);
	DECL_CONV_STUB(annotation_text);
	DECL_CONV_STUB(annotation_text_character);
	DECL_CONV_STUB(annotation_text_occurrence);
	DECL_CONV_STUB(shape_aspect);
	DECL_CONV_STUB(derived_shape_aspect);
	DECL_CONV_STUB(apex);
	DECL_CONV_STUB(application_context_element);
	DECL_CONV_STUB(applied_action_assignment);
	DECL_CONV_STUB(applied_action_method_assignment);
	DECL_CONV_STUB(applied_action_request_assignment);
	DECL_CONV_STUB(approval_assignment);
	DECL_CONV_STUB(applied_approval_assignment);
	DECL_CONV_STUB(attribute_classification_assignment);
	DECL_CONV_STUB(applied_attribute_classification_assignment);
	DECL_CONV_STUB(certification_assignment);
	DECL_CONV_STUB(applied_certification_assignment);
	DECL_CONV_STUB(classification_assignment);
	DECL_CONV_STUB(applied_classification_assignment);
	DECL_CONV_STUB(contract_assignment);
	DECL_CONV_STUB(applied_contract_assignment);
	DECL_CONV_STUB(date_and_time_assignment);
	DECL_CONV_STUB(applied_date_and_time_assignment);
	DECL_CONV_STUB(date_assignment);
	DECL_CONV_STUB(applied_date_assignment);
	DECL_CONV_STUB(document_reference);
	DECL_CONV_STUB(applied_document_reference);
	DECL_CONV_STUB(document_usage_constraint_assignment);
	DECL_CONV_STUB(applied_document_usage_constraint_assignment);
	DECL_CONV_STUB(effectivity_assignment);
	DECL_CONV_STUB(applied_effectivity_assignment);
	DECL_CONV_STUB(event_occurrence_assignment);
	DECL_CONV_STUB(applied_event_occurrence_assignment);
	DECL_CONV_STUB(identification_assignment);
	DECL_CONV_STUB(external_identification_assignment);
	DECL_CONV_STUB(applied_external_identification_assignment);
	DECL_CONV_STUB(group_assignment);
	DECL_CONV_STUB(applied_group_assignment);
	DECL_CONV_STUB(applied_identification_assignment);
	DECL_CONV_STUB(name_assignment);
	DECL_CONV_STUB(applied_name_assignment);
	DECL_CONV_STUB(organization_assignment);
	DECL_CONV_STUB(applied_organization_assignment);
	DECL_CONV_STUB(organizational_project_assignment);
	DECL_CONV_STUB(applied_organizational_project_assignment);
	DECL_CONV_STUB(person_and_organization_assignment);
	DECL_CONV_STUB(applied_person_and_organization_assignment);
	DECL_CONV_STUB(presented_item);
	DECL_CONV_STUB(applied_presented_item);
	DECL_CONV_STUB(security_classification_assignment);
	DECL_CONV_STUB(applied_security_classification_assignment);
	DECL_CONV_STUB(time_interval_assignment);
	DECL_CONV_STUB(applied_time_interval_assignment);
	DECL_CONV_STUB(applied_usage_right);
	DECL_CONV_STUB(area_in_set);
	DECL_CONV_STUB(area_measure_with_unit);
	DECL_CONV_STUB(area_unit);
	DECL_CONV_STUB(product_definition_relationship);
	DECL_CONV_STUB(product_definition_usage);
	DECL_CONV_STUB(assembly_component_usage);
	DECL_CONV_STUB(assigned_requirement);
	DECL_CONV_STUB(compound_representation_item);
	DECL_CONV_STUB(atomic_formula);
	DECL_CONV_STUB(attribute_assertion);
	DECL_CONV_STUB(attribute_language_assignment);
	DECL_CONV_STUB(attribute_value_assignment);
	DECL_CONV_STUB(auxiliary_geometric_representation_item);
	DECL_CONV_STUB(placement);
	DECL_CONV_STUB(axis1_placement);
	DECL_CONV_STUB(axis2_placement_2d);
	DECL_CONV_STUB(axis2_placement_3d);
	DECL_CONV_STUB(curve);
	DECL_CONV_STUB(bounded_curve);
	DECL_CONV_STUB(b_spline_curve);
	DECL_CONV_STUB(b_spline_curve_with_knots);
	DECL_CONV_STUB(surface);
	DECL_CONV_STUB(bounded_surface);
	DECL_CONV_STUB(b_spline_surface);
	DECL_CONV_STUB(b_spline_surface_with_knots);
	DECL_CONV_STUB(product_definition);
	DECL_CONV_STUB(rule_software_definition);
	DECL_CONV_STUB(rule_definition);
	DECL_CONV_STUB(back_chaining_rule);
	DECL_CONV_STUB(back_chaining_rule_body);
	DECL_CONV_STUB(colour);
	DECL_CONV_STUB(background_colour);
	DECL_CONV_STUB(beveled_sheet_representation);
	DECL_CONV_STUB(bezier_curve);
	DECL_CONV_STUB(bezier_surface);
	DECL_CONV_STUB(generic_expression);
	DECL_CONV_STUB(binary_generic_expression);
	DECL_CONV_STUB(binary_numeric_expression);
	DECL_CONV_STUB(binary_representation_item);
	DECL_CONV_STUB(block);
	DECL_CONV_STUB(expression);
	DECL_CONV_STUB(boolean_expression);
	DECL_CONV_STUB(boolean_literal);
	DECL_CONV_STUB(boolean_representation_item);
	DECL_CONV_STUB(boolean_result);
	DECL_CONV_STUB(composite_curve);
	DECL_CONV_STUB(composite_curve_on_surface);
	DECL_CONV_STUB(boundary_curve);
	DECL_CONV_STUB(bounded_pcurve);
	DECL_CONV_STUB(bounded_surface_curve);
	DECL_CONV_STUB(founded_item);
	DECL_CONV_STUB(box_domain);
	DECL_CONV_STUB(half_space_solid);
	DECL_CONV_STUB(boxed_half_space);
	DECL_CONV_STUB(breakdown_context);
	DECL_CONV_STUB(breakdown_element_group_assignment);
	DECL_CONV_STUB(breakdown_element_realization);
	DECL_CONV_STUB(breakdown_element_usage);
	DECL_CONV_STUB(breakdown_of);
	DECL_CONV_STUB(solid_model);
	DECL_CONV_STUB(manifold_solid_brep);
	DECL_CONV_STUB(brep_with_voids);
	DECL_CONV_STUB(bytes_representation_item);
	DECL_CONV_STUB(date);
	DECL_CONV_STUB(calendar_date);
	DECL_CONV_STUB(camera_image);
	DECL_CONV_STUB(camera_image_3d_with_scale);
	DECL_CONV_STUB(camera_model);
	DECL_CONV_STUB(camera_model_d3);
	DECL_CONV_STUB(camera_model_d3_multi_clipping);
	DECL_CONV_STUB(camera_model_d3_multi_clipping_intersection);
	DECL_CONV_STUB(camera_model_d3_multi_clipping_union);
	DECL_CONV_STUB(camera_model_d3_with_hlhsr);
	DECL_CONV_STUB(camera_model_with_light_sources);
	DECL_CONV_STUB(representation_map);
	DECL_CONV_STUB(camera_usage);
	DECL_CONV_STUB(capacitance_measure_with_unit);
	DECL_CONV_STUB(capacitance_unit);
	DECL_CONV_STUB(point);
	DECL_CONV_STUB(cartesian_point);
	DECL_CONV_STUB(cartesian_transformation_operator);
	DECL_CONV_STUB(cartesian_transformation_operator_2d);
	DECL_CONV_STUB(cartesian_transformation_operator_3d);
	DECL_CONV_STUB(cc_design_approval);
	DECL_CONV_STUB(cc_design_certification);
	DECL_CONV_STUB(cc_design_contract);
	DECL_CONV_STUB(cc_design_date_and_time_assignment);
	DECL_CONV_STUB(cc_design_person_and_organization_assignment);
	DECL_CONV_STUB(cc_design_security_classification);
	DECL_CONV_STUB(cc_design_specification_reference);
	DECL_CONV_STUB(celsius_temperature_measure_with_unit);
	DECL_CONV_STUB(centre_of_symmetry);
	DECL_CONV_STUB(change);
	DECL_CONV_STUB(change_request);
	DECL_CONV_STUB(character_glyph_style_outline);
	DECL_CONV_STUB(character_glyph_style_stroke);
	DECL_CONV_STUB(symbol_representation);
	DECL_CONV_STUB(generic_character_glyph_symbol);
	DECL_CONV_STUB(character_glyph_symbol);
	DECL_CONV_STUB(character_glyph_symbol_outline);
	DECL_CONV_STUB(character_glyph_symbol_stroke);
	DECL_CONV_STUB(general_property);
	DECL_CONV_STUB(characteristic_data_column_header);
	DECL_CONV_STUB(general_property_relationship);
	DECL_CONV_STUB(characteristic_data_column_header_link);
	DECL_CONV_STUB(characteristic_data_table_header);
	DECL_CONV_STUB(characteristic_data_table_header_decomposition);
	DECL_CONV_STUB(group);
	DECL_CONV_STUB(characteristic_type);
	DECL_CONV_STUB(characterized_class);
	DECL_CONV_STUB(characterized_object);
	DECL_CONV_STUB(conic);
	DECL_CONV_STUB(circle);
	DECL_CONV_STUB(circular_runout_tolerance);
	DECL_CONV_STUB(class_by_extension);
	DECL_CONV_STUB(class_by_intension);
	DECL_CONV_STUB(class_system);
	DECL_CONV_STUB(effectivity_context_assignment);
	DECL_CONV_STUB(class_usage_effectivity_context_assignment);
	DECL_CONV_STUB(topological_representation_item);
	DECL_CONV_STUB(connected_face_set);
	DECL_CONV_STUB(closed_shell);
	DECL_CONV_STUB(coaxiality_tolerance);
	DECL_CONV_STUB(colour_specification);
	DECL_CONV_STUB(colour_rgb);
	DECL_CONV_STUB(common_datum);
	DECL_CONV_STUB(comparison_expression);
	DECL_CONV_STUB(complex_clause);
	DECL_CONV_STUB(complex_conjunctive_clause);
	DECL_CONV_STUB(complex_disjunctive_clause);
	DECL_CONV_STUB(modified_solid);
	DECL_CONV_STUB(shelled_solid);
	DECL_CONV_STUB(complex_shelled_solid);
	DECL_CONV_STUB(composite_assembly_definition);
	DECL_CONV_STUB(composite_assembly_sequence_definition);
	DECL_CONV_STUB(laminate_table);
	DECL_CONV_STUB(part_laminate_table);
	DECL_CONV_STUB(composite_assembly_table);
	DECL_CONV_STUB(composite_curve_segment);
	DECL_CONV_STUB(material_designation);
	DECL_CONV_STUB(composite_material_designation);
	DECL_CONV_STUB(composite_shape_aspect);
	DECL_CONV_STUB(composite_sheet_representation);
	DECL_CONV_STUB(composite_text);
	DECL_CONV_STUB(composite_text_with_associated_curves);
	DECL_CONV_STUB(composite_text_with_blanking_box);
	DECL_CONV_STUB(composite_text_with_delineation);
	DECL_CONV_STUB(composite_text_with_extent);
	DECL_CONV_STUB(compound_shape_representation);
	DECL_CONV_STUB(concentricity_tolerance);
	DECL_CONV_STUB(concept_feature_relationship);
	DECL_CONV_STUB(concept_feature_relationship_with_condition);
	DECL_CONV_STUB(product_concept_feature);
	DECL_CONV_STUB(conditional_concept_feature);
	DECL_CONV_STUB(conductance_measure_with_unit);
	DECL_CONV_STUB(conductance_unit);
	DECL_CONV_STUB(configuration_item);
	DECL_CONV_STUB(configurable_item);
	DECL_CONV_STUB(effectivity);
	DECL_CONV_STUB(product_definition_effectivity);
	DECL_CONV_STUB(configuration_effectivity);
	DECL_CONV_STUB(configuration_item_relationship);
	DECL_CONV_STUB(configuration_item_hierarchical_relationship);
	DECL_CONV_STUB(configuration_item_revision_sequence);
	DECL_CONV_STUB(configured_effectivity_assignment);
	DECL_CONV_STUB(configured_effectivity_context_assignment);
	DECL_CONV_STUB(conical_stepped_hole_transition);
	DECL_CONV_STUB(elementary_surface);
	DECL_CONV_STUB(conical_surface);
	DECL_CONV_STUB(connected_edge_set);
	DECL_CONV_STUB(connected_face_sub_set);
	DECL_CONV_STUB(constructive_geometry_representation);
	DECL_CONV_STUB(representation_relationship);
	DECL_CONV_STUB(constructive_geometry_representation_relationship);
	DECL_CONV_STUB(contact_ratio_representation);
	DECL_CONV_STUB(invisibility);
	DECL_CONV_STUB(context_dependent_invisibility);
	DECL_CONV_STUB(over_riding_styled_item);
	DECL_CONV_STUB(context_dependent_over_riding_styled_item);
	DECL_CONV_STUB(context_dependent_unit);
	DECL_CONV_STUB(conversion_based_unit);
	DECL_CONV_STUB(csg_shape_representation);
	DECL_CONV_STUB(csg_solid);
	DECL_CONV_STUB(currency);
	DECL_CONV_STUB(currency_measure_with_unit);
	DECL_CONV_STUB(curve_bounded_surface);
	DECL_CONV_STUB(curve_dimension);
	DECL_CONV_STUB(curve_replica);
	DECL_CONV_STUB(curve_style);
	DECL_CONV_STUB(curve_style_font);
	DECL_CONV_STUB(curve_style_font_and_scaling);
	DECL_CONV_STUB(curve_style_font_pattern);
	DECL_CONV_STUB(curve_swept_solid_shape_representation);
	DECL_CONV_STUB(cylindrical_surface);
	DECL_CONV_STUB(cylindricity_tolerance);
	DECL_CONV_STUB(date_representation_item);
	DECL_CONV_STUB(date_time_representation_item);
	DECL_CONV_STUB(dated_effectivity);
	DECL_CONV_STUB(datum);
	DECL_CONV_STUB(datum_feature);
	DECL_CONV_STUB(datum_feature_callout);
	DECL_CONV_STUB(datum_reference);
	DECL_CONV_STUB(datum_target);
	DECL_CONV_STUB(datum_target_callout);
	DECL_CONV_STUB(default_tolerance_table);
	DECL_CONV_STUB(default_tolerance_table_cell);
	DECL_CONV_STUB(defined_symbol);
	DECL_CONV_STUB(definitional_representation);
	DECL_CONV_STUB(definitional_representation_relationship);
	DECL_CONV_STUB(definitional_representation_relationship_with_same_context);
	DECL_CONV_STUB(degenerate_pcurve);
	DECL_CONV_STUB(toroidal_surface);
	DECL_CONV_STUB(degenerate_toroidal_surface);
	DECL_CONV_STUB(descriptive_representation_item);
	DECL_CONV_STUB(product_definition_context);
	DECL_CONV_STUB(design_context);
	DECL_CONV_STUB(design_make_from_relationship);
	DECL_CONV_STUB(diameter_dimension);
	DECL_CONV_STUB(ratio_measure_with_unit);
	DECL_CONV_STUB(dielectric_constant_measure_with_unit);
	DECL_CONV_STUB(dimension_callout);
	DECL_CONV_STUB(draughting_callout_relationship);
	DECL_CONV_STUB(dimension_callout_component_relationship);
	DECL_CONV_STUB(dimension_callout_relationship);
	DECL_CONV_STUB(dimension_curve);
	DECL_CONV_STUB(terminator_symbol);
	DECL_CONV_STUB(dimension_curve_terminator);
	DECL_CONV_STUB(dimension_curve_terminator_to_projection_curve_associativity);
	DECL_CONV_STUB(dimension_pair);
	DECL_CONV_STUB(dimension_text_associativity);
	DECL_CONV_STUB(dimensional_location_with_path);
	DECL_CONV_STUB(dimensional_size_with_path);
	DECL_CONV_STUB(executed_action);
	DECL_CONV_STUB(directed_action);
	DECL_CONV_STUB(directed_dimensional_location);
	DECL_CONV_STUB(direction);
	DECL_CONV_STUB(document_file);
	DECL_CONV_STUB(document_identifier);
	DECL_CONV_STUB(document_identifier_assignment);
	DECL_CONV_STUB(document_product_association);
	DECL_CONV_STUB(document_product_equivalence);
	DECL_CONV_STUB(dose_equivalent_measure_with_unit);
	DECL_CONV_STUB(dose_equivalent_unit);
	DECL_CONV_STUB(double_offset_shelled_solid);
	DECL_CONV_STUB(item_defined_transformation);
	DECL_CONV_STUB(transformation_with_derived_angle);
	DECL_CONV_STUB(draped_defined_transformation);
	DECL_CONV_STUB(draughting_annotation_occurrence);
	DECL_CONV_STUB(draughting_elements);
	DECL_CONV_STUB(draughting_model);
	DECL_CONV_STUB(item_identified_representation_usage);
	DECL_CONV_STUB(draughting_model_item_association);
	DECL_CONV_STUB(pre_defined_colour);
	DECL_CONV_STUB(draughting_pre_defined_colour);
	DECL_CONV_STUB(pre_defined_item);
	DECL_CONV_STUB(pre_defined_curve_font);
	DECL_CONV_STUB(draughting_pre_defined_curve_font);
	DECL_CONV_STUB(pre_defined_text_font);
	DECL_CONV_STUB(draughting_pre_defined_text_font);
	DECL_CONV_STUB(draughting_subfigure_representation);
	DECL_CONV_STUB(draughting_symbol_representation);
	DECL_CONV_STUB(text_literal);
	DECL_CONV_STUB(text_literal_with_delineation);
	DECL_CONV_STUB(draughting_text_literal_with_delineation);
	DECL_CONV_STUB(presentation_set);
	DECL_CONV_STUB(drawing_revision);
	DECL_CONV_STUB(presentation_representation);
	DECL_CONV_STUB(presentation_area);
	DECL_CONV_STUB(drawing_sheet_revision);
	DECL_CONV_STUB(drawing_sheet_revision_sequence);
	DECL_CONV_STUB(drawing_sheet_revision_usage);
	DECL_CONV_STUB(edge);
	DECL_CONV_STUB(edge_based_wireframe_model);
	DECL_CONV_STUB(edge_based_wireframe_shape_representation);
	DECL_CONV_STUB(edge_blended_solid);
	DECL_CONV_STUB(edge_curve);
	DECL_CONV_STUB(edge_loop);
	DECL_CONV_STUB(electric_charge_measure_with_unit);
	DECL_CONV_STUB(electric_charge_unit);
	DECL_CONV_STUB(electric_current_measure_with_unit);
	DECL_CONV_STUB(electric_current_unit);
	DECL_CONV_STUB(electric_potential_measure_with_unit);
	DECL_CONV_STUB(electric_potential_unit);
	DECL_CONV_STUB(elementary_brep_shape_representation);
	DECL_CONV_STUB(ellipse);
	DECL_CONV_STUB(energy_measure_with_unit);
	DECL_CONV_STUB(energy_unit);
	DECL_CONV_STUB(property_definition);
	DECL_CONV_STUB(fact_type);
	DECL_CONV_STUB(entity_assertion);
	DECL_CONV_STUB(enum_reference_prefix);
	DECL_CONV_STUB(evaluated_characteristic);
	DECL_CONV_STUB(evaluated_degenerate_pcurve);
	DECL_CONV_STUB(evaluation_product_definition);
	DECL_CONV_STUB(event_occurrence);
	DECL_CONV_STUB(product_concept_feature_category);
	DECL_CONV_STUB(exclusive_product_concept_feature_category);
	DECL_CONV_STUB(uncertainty_qualifier);
	DECL_CONV_STUB(standard_uncertainty);
	DECL_CONV_STUB(expanded_uncertainty);
	DECL_CONV_STUB(representation_item_relationship);
	DECL_CONV_STUB(explicit_procedural_representation_item_relationship);
	DECL_CONV_STUB(explicit_procedural_geometric_representation_item_relationship);
	DECL_CONV_STUB(explicit_procedural_representation_relationship);
	DECL_CONV_STUB(explicit_procedural_shape_representation_relationship);
	DECL_CONV_STUB(expression_conversion_based_unit);
	DECL_CONV_STUB(extension);
	DECL_CONV_STUB(extent);
	DECL_CONV_STUB(external_source);
	DECL_CONV_STUB(external_class_library);
	DECL_CONV_STUB(externally_defined_class);
	DECL_CONV_STUB(externally_defined_colour);
	DECL_CONV_STUB(externally_defined_context_dependent_unit);
	DECL_CONV_STUB(externally_defined_conversion_based_unit);
	DECL_CONV_STUB(externally_defined_currency);
	DECL_CONV_STUB(externally_defined_item);
	DECL_CONV_STUB(externally_defined_curve_font);
	DECL_CONV_STUB(externally_defined_dimension_definition);
	DECL_CONV_STUB(externally_defined_general_property);
	DECL_CONV_STUB(externally_defined_hatch_style);
	DECL_CONV_STUB(externally_defined_marker);
	DECL_CONV_STUB(picture_representation_item);
	DECL_CONV_STUB(externally_defined_picture_representation_item);
	DECL_CONV_STUB(externally_defined_representation_item);
	DECL_CONV_STUB(externally_defined_string);
	DECL_CONV_STUB(externally_defined_symbol);
	DECL_CONV_STUB(externally_defined_terminator_symbol);
	DECL_CONV_STUB(externally_defined_text_font);
	DECL_CONV_STUB(externally_defined_tile);
	DECL_CONV_STUB(externally_defined_tile_style);
	DECL_CONV_STUB(swept_area_solid);
	DECL_CONV_STUB(extruded_area_solid);
	DECL_CONV_STUB(swept_face_solid);
	DECL_CONV_STUB(extruded_face_solid);
	DECL_CONV_STUB(extruded_face_solid_with_trim_conditions);
	DECL_CONV_STUB(extruded_face_solid_with_draft_angle);
	DECL_CONV_STUB(extruded_face_solid_with_multiple_draft_angles);
	DECL_CONV_STUB(face);
	DECL_CONV_STUB(face_based_surface_model);
	DECL_CONV_STUB(face_bound);
	DECL_CONV_STUB(face_outer_bound);
	DECL_CONV_STUB(faceted_brep);
	DECL_CONV_STUB(faceted_brep_shape_representation);
	DECL_CONV_STUB(fill_area_style);
	DECL_CONV_STUB(fill_area_style_hatching);
	DECL_CONV_STUB(fill_area_style_tile_coloured_region);
	DECL_CONV_STUB(fill_area_style_tile_curve_with_style);
	DECL_CONV_STUB(fill_area_style_tile_symbol_with_style);
	DECL_CONV_STUB(fill_area_style_tiles);
	DECL_CONV_STUB(shape_representation_relationship);
	DECL_CONV_STUB(flat_pattern_ply_representation_relationship);
	DECL_CONV_STUB(flatness_tolerance);
	DECL_CONV_STUB(force_measure_with_unit);
	DECL_CONV_STUB(force_unit);
	DECL_CONV_STUB(forward_chaining_rule);
	DECL_CONV_STUB(forward_chaining_rule_premise);
	DECL_CONV_STUB(frequency_measure_with_unit);
	DECL_CONV_STUB(frequency_unit);
	DECL_CONV_STUB(func);
	DECL_CONV_STUB(functional_breakdown_context);
	DECL_CONV_STUB(functional_element_usage);
	DECL_CONV_STUB(general_material_property);
	DECL_CONV_STUB(simple_generic_expression);
	DECL_CONV_STUB(generic_literal);
	DECL_CONV_STUB(generic_variable);
	DECL_CONV_STUB(geometric_alignment);
	DECL_CONV_STUB(geometric_set);
	DECL_CONV_STUB(geometric_curve_set);
	DECL_CONV_STUB(geometric_intersection);
	DECL_CONV_STUB(geometric_item_specific_usage);
	DECL_CONV_STUB(geometric_model_element_relationship);
	DECL_CONV_STUB(representation_context);
	DECL_CONV_STUB(geometric_representation_context);
	DECL_CONV_STUB(geometric_tolerance_with_defined_unit);
	DECL_CONV_STUB(geometrical_tolerance_callout);
	DECL_CONV_STUB(geometrically_bounded_2d_wireframe_representation);
	DECL_CONV_STUB(geometrically_bounded_surface_shape_representation);
	DECL_CONV_STUB(geometrically_bounded_wireframe_shape_representation);
	DECL_CONV_STUB(global_assignment);
	DECL_CONV_STUB(global_uncertainty_assigned_context);
	DECL_CONV_STUB(global_unit_assigned_context);
	DECL_CONV_STUB(ground_fact);
	DECL_CONV_STUB(hardness_representation);
	DECL_CONV_STUB(hidden_element_over_riding_styled_item);
	DECL_CONV_STUB(hyperbola);
	DECL_CONV_STUB(illuminance_measure_with_unit);
	DECL_CONV_STUB(illuminance_unit);
	DECL_CONV_STUB(included_text_block);
	DECL_CONV_STUB(inclusion_product_concept_feature);
	DECL_CONV_STUB(user_selected_elements);
	DECL_CONV_STUB(indirectly_selected_elements);
	DECL_CONV_STUB(indirectly_selected_shape_elements);
	DECL_CONV_STUB(inductance_measure_with_unit);
	DECL_CONV_STUB(inductance_unit);
	DECL_CONV_STUB(information_right);
	DECL_CONV_STUB(information_usage_right);
	DECL_CONV_STUB(instance_usage_context_assignment);
	DECL_CONV_STUB(instanced_feature);
	DECL_CONV_STUB(literal_number);
	DECL_CONV_STUB(int_literal);
	DECL_CONV_STUB(integer_representation_item);
	DECL_CONV_STUB(surface_curve);
	DECL_CONV_STUB(intersection_curve);
	DECL_CONV_STUB(interval_expression);
	DECL_CONV_STUB(iso4217_currency);
	DECL_CONV_STUB(known_source);
	DECL_CONV_STUB(laid_defined_transformation);
	DECL_CONV_STUB(language);
	DECL_CONV_STUB(leader_curve);
	DECL_CONV_STUB(leader_directed_callout);
	DECL_CONV_STUB(leader_directed_dimension);
	DECL_CONV_STUB(leader_terminator);
	DECL_CONV_STUB(length_measure_with_unit);
	DECL_CONV_STUB(length_unit);
	DECL_CONV_STUB(light_source);
	DECL_CONV_STUB(light_source_ambient);
	DECL_CONV_STUB(light_source_directional);
	DECL_CONV_STUB(light_source_positional);
	DECL_CONV_STUB(light_source_spot);
	DECL_CONV_STUB(line);
	DECL_CONV_STUB(line_profile_tolerance);
	DECL_CONV_STUB(linear_dimension);
	DECL_CONV_STUB(simple_clause);
	DECL_CONV_STUB(literal_conjunction);
	DECL_CONV_STUB(literal_disjunction);
	DECL_CONV_STUB(logical_literal);
	DECL_CONV_STUB(logical_representation_item);
	DECL_CONV_STUB(loop);
	DECL_CONV_STUB(loss_tangent_measure_with_unit);
	DECL_CONV_STUB(lot_effectivity);
	DECL_CONV_STUB(luminous_flux_measure_with_unit);
	DECL_CONV_STUB(luminous_flux_unit);
	DECL_CONV_STUB(luminous_intensity_measure_with_unit);
	DECL_CONV_STUB(luminous_intensity_unit);
	DECL_CONV_STUB(magnetic_flux_density_measure_with_unit);
	DECL_CONV_STUB(magnetic_flux_density_unit);
	DECL_CONV_STUB(magnetic_flux_measure_with_unit);
	DECL_CONV_STUB(magnetic_flux_unit);
	DECL_CONV_STUB(make_from_usage_option);
	DECL_CONV_STUB(manifold_subsurface_shape_representation);
	DECL_CONV_STUB(manifold_surface_shape_representation);
	DECL_CONV_STUB(mass_measure_with_unit);
	DECL_CONV_STUB(mass_unit);
	DECL_CONV_STUB(material_property);
	DECL_CONV_STUB(property_definition_representation);
	DECL_CONV_STUB(material_property_representation);
	DECL_CONV_STUB(measure_representation_item);
	DECL_CONV_STUB(product_context);
	DECL_CONV_STUB(mechanical_context);
	DECL_CONV_STUB(mechanical_design_and_draughting_relationship);
	DECL_CONV_STUB(mechanical_design_geometric_presentation_area);
	DECL_CONV_STUB(mechanical_design_geometric_presentation_representation);
	DECL_CONV_STUB(mechanical_design_presentation_representation_with_draughting);
	DECL_CONV_STUB(mechanical_design_shaded_presentation_area);
	DECL_CONV_STUB(mechanical_design_shaded_presentation_representation);
	DECL_CONV_STUB(min_and_major_ply_orientation_basis);
	DECL_CONV_STUB(modified_geometric_tolerance);
	DECL_CONV_STUB(modified_solid_with_placed_configuration);
	DECL_CONV_STUB(moments_of_inertia_representation);
	DECL_CONV_STUB(multi_language_attribute_assignment);
	DECL_CONV_STUB(multiple_arity_boolean_expression);
	DECL_CONV_STUB(multiple_arity_generic_expression);
	DECL_CONV_STUB(multiple_arity_numeric_expression);
	DECL_CONV_STUB(next_assembly_usage_occurrence);
	DECL_CONV_STUB(non_manifold_surface_shape_representation);
	DECL_CONV_STUB(null_representation_item);
	DECL_CONV_STUB(numeric_expression);
	DECL_CONV_STUB(offset_curve_2d);
	DECL_CONV_STUB(offset_curve_3d);
	DECL_CONV_STUB(offset_surface);
	DECL_CONV_STUB(one_direction_repeat_factor);
	DECL_CONV_STUB(open_shell);
	DECL_CONV_STUB(ordinal_date);
	DECL_CONV_STUB(projection_directed_callout);
	DECL_CONV_STUB(ordinate_dimension);
	DECL_CONV_STUB(organizational_address);
	DECL_CONV_STUB(oriented_closed_shell);
	DECL_CONV_STUB(oriented_edge);
	DECL_CONV_STUB(oriented_face);
	DECL_CONV_STUB(oriented_open_shell);
	DECL_CONV_STUB(path);
	DECL_CONV_STUB(oriented_path);
	DECL_CONV_STUB(oriented_surface);
	DECL_CONV_STUB(outer_boundary_curve);
	DECL_CONV_STUB(package_product_concept_feature);
	DECL_CONV_STUB(parabola);
	DECL_CONV_STUB(parallel_offset);
	DECL_CONV_STUB(parallelism_tolerance);
	DECL_CONV_STUB(parametric_representation_context);
	DECL_CONV_STUB(partial_document_with_structured_text_representation_assignment);
	DECL_CONV_STUB(pcurve);
	DECL_CONV_STUB(percentage_laminate_definition);
	DECL_CONV_STUB(zone_structural_makeup);
	DECL_CONV_STUB(percentage_laminate_table);
	DECL_CONV_STUB(percentage_ply_definition);
	DECL_CONV_STUB(perpendicular_to);
	DECL_CONV_STUB(perpendicularity_tolerance);
	DECL_CONV_STUB(person_and_organization_address);
	DECL_CONV_STUB(personal_address);
	DECL_CONV_STUB(physical_breakdown_context);
	DECL_CONV_STUB(physical_element_usage);
	DECL_CONV_STUB(presentation_view);
	DECL_CONV_STUB(picture_representation);
	DECL_CONV_STUB(placed_datum_target_feature);
	DECL_CONV_STUB(placed_feature);
	DECL_CONV_STUB(planar_extent);
	DECL_CONV_STUB(planar_box);
	DECL_CONV_STUB(plane);
	DECL_CONV_STUB(plane_angle_measure_with_unit);
	DECL_CONV_STUB(plane_angle_unit);
	DECL_CONV_STUB(ply_laminate_definition);
	DECL_CONV_STUB(ply_laminate_sequence_definition);
	DECL_CONV_STUB(ply_laminate_table);
	DECL_CONV_STUB(point_and_vector);
	DECL_CONV_STUB(point_on_curve);
	DECL_CONV_STUB(point_on_surface);
	DECL_CONV_STUB(point_path);
	DECL_CONV_STUB(point_replica);
	DECL_CONV_STUB(point_style);
	DECL_CONV_STUB(polar_complex_number_literal);
	DECL_CONV_STUB(poly_loop);
	DECL_CONV_STUB(polyline);
	DECL_CONV_STUB(position_tolerance);
	DECL_CONV_STUB(positioned_sketch);
	DECL_CONV_STUB(power_measure_with_unit);
	DECL_CONV_STUB(power_unit);
	DECL_CONV_STUB(pre_defined_symbol);
	DECL_CONV_STUB(pre_defined_dimension_symbol);
	DECL_CONV_STUB(pre_defined_geometrical_tolerance_symbol);
	DECL_CONV_STUB(pre_defined_marker);
	DECL_CONV_STUB(pre_defined_point_marker_symbol);
	DECL_CONV_STUB(pre_defined_surface_condition_symbol);
	DECL_CONV_STUB(pre_defined_surface_side_style);
	DECL_CONV_STUB(pre_defined_terminator_symbol);
	DECL_CONV_STUB(pre_defined_tile);
	DECL_CONV_STUB(predefined_picture_representation_item);
	DECL_CONV_STUB(presentation_style_assignment);
	DECL_CONV_STUB(presentation_style_by_context);
	DECL_CONV_STUB(pressure_measure_with_unit);
	DECL_CONV_STUB(pressure_unit);
	DECL_CONV_STUB(procedural_representation);
	DECL_CONV_STUB(procedural_representation_sequence);
	DECL_CONV_STUB(procedural_shape_representation);
	DECL_CONV_STUB(procedural_shape_representation_sequence);
	DECL_CONV_STUB(product_category);
	DECL_CONV_STUB(product_class);
	DECL_CONV_STUB(product_concept_context);
	DECL_CONV_STUB(product_concept_feature_category_usage);
	DECL_CONV_STUB(product_definition_element_relationship);
	DECL_CONV_STUB(product_definition_formation);
	DECL_CONV_STUB(product_definition_formation_with_specified_source);
	DECL_CONV_STUB(product_definition_group_assignment);
	DECL_CONV_STUB(product_definition_shape);
	DECL_CONV_STUB(product_definition_with_associated_documents);
	DECL_CONV_STUB(product_identification);
	DECL_CONV_STUB(product_material_composition_relationship);
	DECL_CONV_STUB(product_related_product_category);
	DECL_CONV_STUB(product_specification);
	DECL_CONV_STUB(tolerance_zone_definition);
	DECL_CONV_STUB(projected_zone_definition);
	DECL_CONV_STUB(projection_curve);
	DECL_CONV_STUB(promissory_usage_occurrence);
	DECL_CONV_STUB(qualified_representation_item);
	DECL_CONV_STUB(qualitative_uncertainty);
	DECL_CONV_STUB(quantified_assembly_component_usage);
	DECL_CONV_STUB(quasi_uniform_curve);
	DECL_CONV_STUB(quasi_uniform_surface);
	DECL_CONV_STUB(radioactivity_measure_with_unit);
	DECL_CONV_STUB(radioactivity_unit);
	DECL_CONV_STUB(radius_dimension);
	DECL_CONV_STUB(range_characteristic);
	DECL_CONV_STUB(ratio_unit);
	DECL_CONV_STUB(rational_b_spline_curve);
	DECL_CONV_STUB(rational_b_spline_surface);
	DECL_CONV_STUB(rational_representation_item);
	DECL_CONV_STUB(real_literal);
	DECL_CONV_STUB(real_representation_item);
	DECL_CONV_STUB(rectangular_composite_surface);
	DECL_CONV_STUB(rectangular_trimmed_surface);
	DECL_CONV_STUB(referenced_modified_datum);
	DECL_CONV_STUB(relative_event_occurrence);
	DECL_CONV_STUB(rep_item_group);
	DECL_CONV_STUB(reparametrised_composite_curve_segment);
	DECL_CONV_STUB(representation_relationship_with_transformation);
	DECL_CONV_STUB(requirement_assigned_object);
	DECL_CONV_STUB(requirement_assignment);
	DECL_CONV_STUB(requirement_source);
	DECL_CONV_STUB(requirement_view_definition_relationship);
	DECL_CONV_STUB(resistance_measure_with_unit);
	DECL_CONV_STUB(resistance_unit);
	DECL_CONV_STUB(revolved_area_solid);
	DECL_CONV_STUB(revolved_face_solid);
	DECL_CONV_STUB(revolved_face_solid_with_trim_conditions);
	DECL_CONV_STUB(right_angular_wedge);
	DECL_CONV_STUB(right_circular_cone);
	DECL_CONV_STUB(right_circular_cylinder);
	DECL_CONV_STUB(right_to_usage_association);
	DECL_CONV_STUB(roundness_tolerance);
	DECL_CONV_STUB(row_representation_item);
	DECL_CONV_STUB(row_value);
	DECL_CONV_STUB(row_variable);
	DECL_CONV_STUB(rule_action);
	DECL_CONV_STUB(rule_condition);
	DECL_CONV_STUB(rule_set);
	DECL_CONV_STUB(rule_set_group);
	DECL_CONV_STUB(rule_superseded_assignment);
	DECL_CONV_STUB(rule_supersedence);
	DECL_CONV_STUB(surface_curve_swept_area_solid);
	DECL_CONV_STUB(ruled_surface_swept_area_solid);
	DECL_CONV_STUB(runout_zone_definition);
	DECL_CONV_STUB(runout_zone_orientation);
	DECL_CONV_STUB(runout_zone_orientation_reference_direction);
	DECL_CONV_STUB(satisfied_requirement);
	DECL_CONV_STUB(satisfies_requirement);
	DECL_CONV_STUB(satisfying_item);
	DECL_CONV_STUB(scalar_variable);
	DECL_CONV_STUB(scattering_parameter);
	DECL_CONV_STUB(sculptured_solid);
	DECL_CONV_STUB(seam_curve);
	DECL_CONV_STUB(serial_numbered_effectivity);
	DECL_CONV_STUB(shape_aspect_associativity);
	DECL_CONV_STUB(shape_aspect_deriving_relationship);
	DECL_CONV_STUB(shape_definition_representation);
	DECL_CONV_STUB(shape_dimension_representation);
	DECL_CONV_STUB(shape_feature_definition);
	DECL_CONV_STUB(shape_representation_with_parameters);
	DECL_CONV_STUB(shell_based_surface_model);
	DECL_CONV_STUB(shell_based_wireframe_model);
	DECL_CONV_STUB(shell_based_wireframe_shape_representation);
	DECL_CONV_STUB(si_absorbed_dose_unit);
	DECL_CONV_STUB(si_capacitance_unit);
	DECL_CONV_STUB(si_conductance_unit);
	DECL_CONV_STUB(si_dose_equivalent_unit);
	DECL_CONV_STUB(si_electric_charge_unit);
	DECL_CONV_STUB(si_electric_potential_unit);
	DECL_CONV_STUB(si_energy_unit);
	DECL_CONV_STUB(si_force_unit);
	DECL_CONV_STUB(si_frequency_unit);
	DECL_CONV_STUB(si_illuminance_unit);
	DECL_CONV_STUB(si_inductance_unit);
	DECL_CONV_STUB(si_magnetic_flux_density_unit);
	DECL_CONV_STUB(si_magnetic_flux_unit);
	DECL_CONV_STUB(si_power_unit);
	DECL_CONV_STUB(si_pressure_unit);
	DECL_CONV_STUB(si_radioactivity_unit);
	DECL_CONV_STUB(si_resistance_unit);
	DECL_CONV_STUB(si_unit);
	DECL_CONV_STUB(simple_boolean_expression);
	DECL_CONV_STUB(simple_numeric_expression);
	DECL_CONV_STUB(slash_expression);
	DECL_CONV_STUB(smeared_material_definition);
	DECL_CONV_STUB(solid_angle_measure_with_unit);
	DECL_CONV_STUB(solid_angle_unit);
	DECL_CONV_STUB(solid_curve_font);
	DECL_CONV_STUB(solid_replica);
	DECL_CONV_STUB(solid_with_chamfered_edges);
	DECL_CONV_STUB(solid_with_angle_based_chamfer);
	DECL_CONV_STUB(solid_with_shape_element_pattern);
	DECL_CONV_STUB(solid_with_circular_pattern);
	DECL_CONV_STUB(solid_with_depression);
	DECL_CONV_STUB(solid_with_pocket);
	DECL_CONV_STUB(solid_with_circular_pocket);
	DECL_CONV_STUB(solid_with_protrusion);
	DECL_CONV_STUB(solid_with_circular_protrusion);
	DECL_CONV_STUB(solid_with_hole);
	DECL_CONV_STUB(solid_with_stepped_round_hole);
	DECL_CONV_STUB(solid_with_conical_bottom_round_hole);
	DECL_CONV_STUB(solid_with_constant_radius_edge_blend);
	DECL_CONV_STUB(solid_with_slot);
	DECL_CONV_STUB(solid_with_curved_slot);
	DECL_CONV_STUB(solid_with_double_offset_chamfer);
	DECL_CONV_STUB(solid_with_flat_bottom_round_hole);
	DECL_CONV_STUB(solid_with_general_pocket);
	DECL_CONV_STUB(solid_with_general_protrusion);
	DECL_CONV_STUB(solid_with_groove);
	DECL_CONV_STUB(solid_with_incomplete_circular_pattern);
	DECL_CONV_STUB(solid_with_rectangular_pattern);
	DECL_CONV_STUB(solid_with_incomplete_rectangular_pattern);
	DECL_CONV_STUB(solid_with_rectangular_pocket);
	DECL_CONV_STUB(solid_with_rectangular_protrusion);
	DECL_CONV_STUB(solid_with_single_offset_chamfer);
	DECL_CONV_STUB(solid_with_spherical_bottom_round_hole);
	DECL_CONV_STUB(solid_with_stepped_round_hole_and_conical_transitions);
	DECL_CONV_STUB(solid_with_straight_slot);
	DECL_CONV_STUB(solid_with_tee_section_slot);
	DECL_CONV_STUB(solid_with_through_depression);
	DECL_CONV_STUB(solid_with_trapezoidal_section_slot);
	DECL_CONV_STUB(solid_with_variable_radius_edge_blend);
	DECL_CONV_STUB(source_for_requirement);
	DECL_CONV_STUB(sourced_requirement);
	DECL_CONV_STUB(specification_definition);
	DECL_CONV_STUB(specified_higher_usage_occurrence);
	DECL_CONV_STUB(sphere);
	DECL_CONV_STUB(spherical_surface);
	DECL_CONV_STUB(start_request);
	DECL_CONV_STUB(start_work);
	DECL_CONV_STUB(straightness_tolerance);
	DECL_CONV_STUB(structured_dimension_callout);
	DECL_CONV_STUB(structured_text_composition);
	DECL_CONV_STUB(structured_text_representation);
	DECL_CONV_STUB(subedge);
	DECL_CONV_STUB(subface);
	DECL_CONV_STUB(supplied_part_relationship);
	DECL_CONV_STUB(surface_condition_callout);
	DECL_CONV_STUB(swept_surface);
	DECL_CONV_STUB(surface_of_linear_extrusion);
	DECL_CONV_STUB(surface_of_revolution);
	DECL_CONV_STUB(surface_patch);
	DECL_CONV_STUB(surface_profile_tolerance);
	DECL_CONV_STUB(surface_replica);
	DECL_CONV_STUB(surface_side_style);
	DECL_CONV_STUB(surface_style_boundary);
	DECL_CONV_STUB(surface_style_control_grid);
	DECL_CONV_STUB(surface_style_fill_area);
	DECL_CONV_STUB(surface_style_parameter_line);
	DECL_CONV_STUB(surface_style_reflectance_ambient);
	DECL_CONV_STUB(surface_style_reflectance_ambient_diffuse);
	DECL_CONV_STUB(surface_style_reflectance_ambient_diffuse_specular);
	DECL_CONV_STUB(surface_style_rendering);
	DECL_CONV_STUB(surface_style_rendering_with_properties);
	DECL_CONV_STUB(surface_style_segmentation_curve);
	DECL_CONV_STUB(surface_style_silhouette);
	DECL_CONV_STUB(surface_style_usage);
	DECL_CONV_STUB(surface_texture_representation);
	DECL_CONV_STUB(surfaced_open_shell);
	DECL_CONV_STUB(swept_disk_solid);
	DECL_CONV_STUB(symbol);
	DECL_CONV_STUB(symbol_representation_map);
	DECL_CONV_STUB(symbol_style);
	DECL_CONV_STUB(symbol_target);
	DECL_CONV_STUB(symmetric_shape_aspect);
	DECL_CONV_STUB(symmetry_tolerance);
	DECL_CONV_STUB(table_representation_item);
	DECL_CONV_STUB(tactile_appearance_representation);
	DECL_CONV_STUB(tagged_text_format);
	DECL_CONV_STUB(tagged_text_item);
	DECL_CONV_STUB(tangent);
	DECL_CONV_STUB(text_literal_with_associated_curves);
	DECL_CONV_STUB(text_literal_with_blanking_box);
	DECL_CONV_STUB(text_literal_with_extent);
	DECL_CONV_STUB(text_string_representation);
	DECL_CONV_STUB(text_style);
	DECL_CONV_STUB(text_style_with_box_characteristics);
	DECL_CONV_STUB(text_style_with_mirror);
	DECL_CONV_STUB(text_style_with_spacing);
	DECL_CONV_STUB(thermal_resistance_measure_with_unit);
	DECL_CONV_STUB(thermal_resistance_unit);
	DECL_CONV_STUB(thermodynamic_temperature_measure_with_unit);
	DECL_CONV_STUB(thermodynamic_temperature_unit);
	DECL_CONV_STUB(thickened_face_solid);
	DECL_CONV_STUB(thickness_laminate_definition);
	DECL_CONV_STUB(thickness_laminate_table);
	DECL_CONV_STUB(time_interval);
	DECL_CONV_STUB(time_interval_based_effectivity);
	DECL_CONV_STUB(time_interval_with_bounds);
	DECL_CONV_STUB(time_measure_with_unit);
	DECL_CONV_STUB(time_unit);
	DECL_CONV_STUB(tolerance_zone);
	DECL_CONV_STUB(torus);
	DECL_CONV_STUB(total_runout_tolerance);
	DECL_CONV_STUB(track_blended_solid);
	DECL_CONV_STUB(track_blended_solid_with_end_conditions);
	DECL_CONV_STUB(trimmed_curve);
	DECL_CONV_STUB(two_direction_repeat_factor);
	DECL_CONV_STUB(unary_generic_expression);
	DECL_CONV_STUB(unary_numeric_expression);
	DECL_CONV_STUB(uncertainty_assigned_representation);
	DECL_CONV_STUB(uncertainty_measure_with_unit);
	DECL_CONV_STUB(uniform_curve);
	DECL_CONV_STUB(uniform_resource_identifier);
	DECL_CONV_STUB(uniform_surface);
	DECL_CONV_STUB(usage_association);
	DECL_CONV_STUB(user_defined_curve_font);
	DECL_CONV_STUB(user_defined_marker);
	DECL_CONV_STUB(user_defined_terminator_symbol);
	DECL_CONV_STUB(user_selected_shape_elements);
	DECL_CONV_STUB(value_range);
	DECL_CONV_STUB(value_representation_item);
	DECL_CONV_STUB(variable_semantics);
	DECL_CONV_STUB(variational_representation_item);
	DECL_CONV_STUB(vector);
	DECL_CONV_STUB(vector_style);
	DECL_CONV_STUB(velocity_measure_with_unit);
	DECL_CONV_STUB(velocity_unit);
	DECL_CONV_STUB(vertex);
	DECL_CONV_STUB(vertex_loop);
	DECL_CONV_STUB(vertex_point);
	DECL_CONV_STUB(vertex_shell);
	DECL_CONV_STUB(view_volume);
	DECL_CONV_STUB(visual_appearance_representation);
	DECL_CONV_STUB(volume_measure_with_unit);
	DECL_CONV_STUB(volume_unit);
	DECL_CONV_STUB(week_of_year_and_day_date);
	DECL_CONV_STUB(wire_shell);
	DECL_CONV_STUB(year_month);


#undef DECL_CONV_STUB

} //! STEP
} //! Assimp

#endif // INCLUDED_STEPFILE_READER_GEN_H
