// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#pragma once


#include "clangtoolsdiagnostic.h"

#include <optional>

namespace Utils { class FilePath; }

namespace ClangTools {
namespace Internal {

using AcceptDiagsFromFilePath = std::function<bool(const Utils::FilePath &)>;

// Reads diagnostics generated by "clang-tidy/clazy-standalone -export-fixes=path/to/file"
Diagnostics readExportedDiagnostics(const Utils::FilePath &logFilePath,
                                    const AcceptDiagsFromFilePath &acceptFromFilePath,
                                    QString *errorMessage = nullptr);

// Exposed for tests
struct LineColumnInfo {
    int line = 1; // 1-based
    int column = 1; // 1-based
    int lineStartOffset = 0; // for optimiation/caching purposes
};
using OptionalLineColumnInfo = std::optional<LineColumnInfo>;
OptionalLineColumnInfo byteOffsetInUtf8TextToLineColumn(const char *text,
                                                        int offset,
                                                        int startLine = 1);

} // namespace Internal
} // namespace ClangTools
