/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#ifndef COREICONS_H
#define COREICONS_H

#include "core_global.h"

#include <utils/icon.h>

namespace Core {
namespace Icons {

CORE_EXPORT extern const Utils::Icon NEWFILE;
CORE_EXPORT extern const Utils::Icon OPENFILE;
CORE_EXPORT extern const Utils::Icon SAVEFILE;
CORE_EXPORT extern const Utils::Icon SAVEFILE_TOOLBAR;
CORE_EXPORT extern const Utils::Icon UNDO;
CORE_EXPORT extern const Utils::Icon REDO;
CORE_EXPORT extern const Utils::Icon COPY;
CORE_EXPORT extern const Utils::Icon PASTE;
CORE_EXPORT extern const Utils::Icon CUT;
CORE_EXPORT extern const Utils::Icon DIR;
CORE_EXPORT extern const Utils::Icon RESET;
CORE_EXPORT extern const Utils::Icon DARK_CLOSE;
CORE_EXPORT extern const Utils::Icon LOCKED_TOOLBAR;
CORE_EXPORT extern const Utils::Icon LOCKED;
CORE_EXPORT extern const Utils::Icon UNLOCKED_TOOLBAR;
CORE_EXPORT extern const Utils::Icon FIND_CASE_INSENSITIVELY;
CORE_EXPORT extern const Utils::Icon FIND_WHOLE_WORD;
CORE_EXPORT extern const Utils::Icon FIND_REGEXP;
CORE_EXPORT extern const Utils::Icon FIND_PRESERVE_CASE;
CORE_EXPORT extern const Utils::Icon QTLOGO_32;
CORE_EXPORT extern const Utils::Icon QTLOGO_64;
CORE_EXPORT extern const Utils::Icon QTLOGO_128;

CORE_EXPORT extern const Utils::Icon ARROW_UP;
CORE_EXPORT extern const Utils::Icon ARROW_DOWN;
CORE_EXPORT extern const Utils::Icon MINUS;
CORE_EXPORT extern const Utils::Icon PLUS;
CORE_EXPORT extern const Utils::Icon NEXT;
CORE_EXPORT extern const Utils::Icon NEXT_TOOLBAR;
CORE_EXPORT extern const Utils::Icon PREV;
CORE_EXPORT extern const Utils::Icon PREV_TOOLBAR;
CORE_EXPORT extern const Utils::Icon MAGNIFIER;
CORE_EXPORT extern const Utils::Icon CLEAN_PANE;
CORE_EXPORT extern const Utils::Icon RELOAD;
CORE_EXPORT extern const Utils::Icon TOGGLE_SIDEBAR;
CORE_EXPORT extern const Utils::Icon TOGGLE_SIDEBAR_TOOLBAR;
CORE_EXPORT extern const Utils::Icon CLOSE_TOOLBAR;
CORE_EXPORT extern const Utils::Icon CLOSE_FOREGROUND;
CORE_EXPORT extern const Utils::Icon CLOSE_BACKGROUND;
CORE_EXPORT extern const Utils::Icon SPLIT_HORIZONTAL;
CORE_EXPORT extern const Utils::Icon SPLIT_HORIZONTAL_TOOLBAR;
CORE_EXPORT extern const Utils::Icon SPLIT_VERTICAL;
CORE_EXPORT extern const Utils::Icon SPLIT_VERTICAL_TOOLBAR;
CORE_EXPORT extern const Utils::Icon CLOSE_SPLIT_TOP;
CORE_EXPORT extern const Utils::Icon CLOSE_SPLIT_BOTTOM;
CORE_EXPORT extern const Utils::Icon CLOSE_SPLIT_LEFT;
CORE_EXPORT extern const Utils::Icon CLOSE_SPLIT_RIGHT;
CORE_EXPORT extern const Utils::Icon FILTER;
CORE_EXPORT extern const Utils::Icon LINK;
CORE_EXPORT extern const Utils::Icon WARNING;
CORE_EXPORT extern const Utils::Icon WARNING_TOOLBAR;
CORE_EXPORT extern const Utils::Icon ERROR;
CORE_EXPORT extern const Utils::Icon ERROR_TOOLBAR;
CORE_EXPORT extern const Utils::Icon ERROR_TASKBAR;
CORE_EXPORT extern const Utils::Icon INFO;
CORE_EXPORT extern const Utils::Icon INFO_TOOLBAR;
CORE_EXPORT extern const Utils::Icon EXPAND;
CORE_EXPORT extern const Utils::Icon ZOOM;
CORE_EXPORT extern const Utils::Icon ZOOM_TOOLBAR;
CORE_EXPORT extern const Utils::Icon TOOLBAR_EXTENSION;
CORE_EXPORT extern const Utils::Icon RUN_SMALL;
CORE_EXPORT extern const Utils::Icon RUN_SMALL_TOOLBAR;
CORE_EXPORT extern const Utils::Icon STOP_SMALL;
CORE_EXPORT extern const Utils::Icon STOP_SMALL_TOOLBAR;
CORE_EXPORT extern const Utils::Icon INTERRUPT_SMALL;
CORE_EXPORT extern const Utils::Icon INTERRUPT_SMALL_TOOLBAR;
CORE_EXPORT extern const Utils::Icon BOUNDING_RECT;
CORE_EXPORT extern const Utils::Icon EYE_OPEN_TOOLBAR;
CORE_EXPORT extern const Utils::Icon EYE_CLOSED_TOOLBAR;

CORE_EXPORT extern const Utils::Icon MODE_EDIT_CLASSIC;
CORE_EXPORT extern const Utils::Icon MODE_EDIT_FLAT;
CORE_EXPORT extern const Utils::Icon MODE_EDIT_FLAT_ACTIVE;
CORE_EXPORT extern const Utils::Icon MODE_DESIGN_CLASSIC;
CORE_EXPORT extern const Utils::Icon MODE_DESIGN_FLAT;
CORE_EXPORT extern const Utils::Icon MODE_DESIGN_FLAT_ACTIVE;

} // namespace Icons
} // namespace Core

#endif // COREICONS_H
