/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick

Item {
    id: simulation
    property real speed: 120
    property bool running: false
    property var keypress

    onRunningChanged: {
        if (running) {
            speed = 120;
            speedTimer.step = -1;
            speedTimer.restart();
            animation.restart();
        }
    }

    SequentialAnimation {
        id: animation
        loops: Animation.Infinite
        running: simulation.running

        PauseAnimation { duration: 10000 }

        // Change lane to the right
        ScriptAction { script: keypress = Qt.Key_Right }
        PauseAnimation { duration: 10000 }

        // Change lane to the left
        ScriptAction { script: keypress = Qt.Key_Left }
        PauseAnimation { duration: 10000 }

        // Toggle LKAS
        ScriptAction { script: keypress = Qt.Key_W }
        PauseAnimation { duration: 5000 }

        // Change lane to the left
        ScriptAction { script: keypress = Qt.Key_Left }
        PauseAnimation { duration: 10000 }

        // Change mode
        ScriptAction { script: keypress = Qt.Key_1 }
        PauseAnimation { duration: 10000 }

        // Change mode
        ScriptAction { script: keypress = Qt.Key_2 }
        PauseAnimation { duration: 10000 }

        // Change lane to the right
        ScriptAction { script: keypress = Qt.Key_Right }
        PauseAnimation { duration: 10000 }

        // Change mode
        ScriptAction { script: keypress = Qt.Key_3 }
        PauseAnimation { duration: 10000 }

        // Change distance
        ScriptAction { script: keypress = Qt.Key_Down }
        PauseAnimation { duration: 2000 }

        // Overtake
        ScriptAction { script: speedTimer.stop(); }
        ScriptAction { script: keypress = Qt.Key_N }
        PauseAnimation { duration: 15000 }
        ScriptAction { script: speedTimer.start(); }

        // Change distance
        ScriptAction { script: keypress = Qt.Key_Down }
        PauseAnimation { duration: 2000 }

        // Change distance
        ScriptAction { script: keypress = Qt.Key_Up }
        PauseAnimation { duration: 2000 }

        // Change distance
        ScriptAction { script: keypress = Qt.Key_Up }
        PauseAnimation { duration: 2000 }

        // Charge
        ScriptAction { script: keypress = Qt.Key_5 }
        PauseAnimation { duration: 4000 }
        ScriptAction { script: keypress = Qt.Key_6 }
        PauseAnimation { duration: 4000 }
        ScriptAction { script: keypress = Qt.Key_7 }
        PauseAnimation { duration: 10000 }

        // Change mode
        ScriptAction { script: keypress = Qt.Key_2 }
        PauseAnimation { duration: 10000 }

        // Run the next loop with the other mode (day/night)
        ScriptAction { script: keypress = Qt.Key_Escape }
    }

    Timer {
        id: speedTimer
        running: simulation.running
        interval: 100
        repeat: true
        property int step: -1
        onTriggered: {
            // TODO: If we want more lively speed data (as it can't be done using animations)
            // we'd need a list of numbers to be added to or removed from speed
            step++;
            if (step < 50) // -> 220
                simulation.speed += 2;
            else if (step < 200)
                // no-op
                ;
            else if (step < 250) // -> 120
                simulation.speed -= 2;
            else if (step < 350)
                // no-op
                ;
            else if (step < 390) // -> 40
                simulation.speed -= 2;
            else if (step < 500)
                // no-op
                ;
            else if (step < 540) // -> 120
                simulation.speed += 2;
            else if (step < 600)
                // no-op
                ;
            else
                step = -1;
        }
    }
}

