############################################################################
##
## Copyright (C) 2016 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of the examples of Qt for Python.
##
## $QT_BEGIN_LICENSE:BSD$
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## BSD License Usage
## Alternatively, you may use this file under the terms of the BSD license
## as follows:
##
## "Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions are
## met:
##   * Redistributions of source code must retain the above copyright
##     notice, this list of conditions and the following disclaimer.
##   * Redistributions in binary form must reproduce the above copyright
##     notice, this list of conditions and the following disclaimer in
##     the documentation and/or other materials provided with the
##     distribution.
##   * Neither the name of The Qt Company Ltd nor the names of its
##     contributors may be used to endorse or promote products derived
##     from this software without specific prior written permission.
##
##
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
## "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
## LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
## A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
## OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
## SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
## LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
## DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
## THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
## (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
## OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
##
## $QT_END_LICENSE$
##
############################################################################

//! [0]
        polygon = QPolygon()
        polygon << QPoint(10, 20) << QPoint(20, 30)
//! [0]

//! [1]
        polygon = QPolygonF()
        polygon << QPointF(10.4, 20.5) << QPointF(20.2, 30.2)
//! [1]

//! [2]
        points = [ 10, 20, 30, 40 ]
        polygon = QPolygon()
        polygon.setPoints(2, points)
//! [2]

//! [3]
        polygon = QPolygon()
        polygon.setPoints(2, 10, 20, 30, 40)
//! [3]

//! [4]
        polygon = QPolygon(1)
        polygon[0] = QPoint(4, 5)
        polygon.putPoints(1, 2, 6,7, 8,9)
//! [4]

//! [5]
        polygon = QPolygon(3)
        polygon.putPoints(0, 3, 4,5, 0,0, 8,9)
        polygon.putPoints(1, 1, 6,7)
//! [5]

//! [6]
        polygon1 = QPolygon()
        polygon1.putPoints(0, 3, 1,2, 0,0, 5,6)
        # polygon1 is now the three-point polygon(1,2, 0,0, 5,6)

        polygon2 = QPolygon()
        polygon2.putPoints(0, 3, 4,4, 5,5, 6,6)
        # polygon2 is now (4,4, 5,5, 6,6)

        polygon1.putPoints(2, 3, polygon2)
        # polygon1 is now the five-point polygon(1,2, 0,0, 4,4, 5,5, 6,6)
//! [6]

