/****************************************************************************
**
** Copyright (C) 2016 Klaralvdalens Datakonsult AB (KDAB).
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt3D module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/


#include <QtTest/QTest>

#include "testdeviceproxy.h"

class tst_QAbstractPhysicalDeviceProxy : public QObject
{
    Q_OBJECT

private Q_SLOTS:

    void checkDefaultConstruction()
    {
        // GIVEN
        TestProxy abstractPhysicalDeviceProxy;

        // THEN
        QCOMPARE(abstractPhysicalDeviceProxy.deviceName(), QLatin1String("TestProxy"));
        QCOMPARE(abstractPhysicalDeviceProxy.status(), Qt3DInput::QAbstractPhysicalDeviceProxy::NotFound);
        QCOMPARE(abstractPhysicalDeviceProxy.axisCount(), 0);
        QCOMPARE(abstractPhysicalDeviceProxy.buttonCount(), 0);
        QCOMPARE(abstractPhysicalDeviceProxy.axisNames(), QStringList());
        QCOMPARE(abstractPhysicalDeviceProxy.buttonNames(), QStringList());
        QVERIFY(abstractPhysicalDeviceProxy.device() == nullptr);
    }

    void checkDeviceBookkeeping()
    {
        // GIVEN
        TestProxy *abstractPhysicalDeviceProxy = new TestProxy();

        // WHEN
        TestPhysicalDevice *device = new TestPhysicalDevice();
        abstractPhysicalDeviceProxy->setDevice(device);

        // THEN
        QVERIFY(abstractPhysicalDeviceProxy->device() == device);

        // WHEN
        delete device;

        // THEN -> should not crash
        QVERIFY(abstractPhysicalDeviceProxy->device() == nullptr);
    }
};

QTEST_MAIN(tst_QAbstractPhysicalDeviceProxy)

#include "tst_qabstractphysicaldeviceproxy.moc"
