/****************************************************************************
**
** Copyright (C) 2020 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Add dynamic dependency for mingw TC for Android packages on Windows. Releases before
    // Qt 5.15 are still using mingw 7.3
    if (installer.value("os") == "win") {
        var mingw_tc_component = "qt.tools.win64_mingw730";
        var pkg_version = "51211"
        if (pkg_version.startsWith("515")) {
            mingw_tc_component = "qt.tools.win64_mingw810";
        }
        component.addDependency(mingw_tc_component);
    }
    // Determine if this is a online snapshot build
    var snapshotBuild = false;
    var isSnapshotStr = "false";
    if (['true', 'yes', '1'].indexOf(isSnapshotStr) >= 0)
        snapshotBuild = true;

    if (snapshotBuild) {
        // Add automatic dependency for preview component
        var autoDependency = component.value("AutoDependOn");
        var dependencyStr = "preview.qt.qt5.512.android_arm64_v8a";
        if (autoDependency) {
            component.setValue("AutoDependOn", autoDependency+","+dependencyStr)
        }
        else {
            component.setValue("AutoDependOn", dependencyStr)
        }
    }
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    var qmakeBinary = "";
    var platform = "";
    if (installer.value("os") == "x11") {
        qmakeBinary = "@TargetDir@" + "/5.12.11/android_arm64_v8a/bin/qmake";
        platform = "linux";
    }
    if (installer.value("os") == "mac") {
        qmakeBinary = "@TargetDir@" + "/5.12.11/android_arm64_v8a/bin/qmake";
        platform = "mac";
    }
    if (installer.value("os") == "win") {
        qmakeBinary = "@TargetDir@" + "/5.12.11/android_arm64_v8a/bin/qmake.exe";
        platform = "windows";
    }

    var qtPath = "@TargetDir@" + "/5.12.11/android_arm64_v8a";
    addInitQtPatchOperation(component, platform, qtPath, qmakeBinary, "emb-arm-qt5");

    if (installer.value("SDKToolBinary") == "")
        return;

    // add Qt into QtCreator
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", component.name,
                            "--name", "Qt %{Qt:Version} for Android ARM64-v8a",
                            "--type", "Qt4ProjectManager.QtVersion.Android",
                            "--qmake", qmakeBinary,
                            "UNDOEXECUTE",
                            "@SDKToolBinary@", "rmQt", "--id", component.name]);

    // patch/register docs and examples
    var installationPath = installer.value("TargetDir") + "/5.12.11/android_arm64_v8a";
    print("Register documentation and examples for: " + installationPath);
    patchQtExamplesAndDoc(component, installationPath, "Qt-5.12.11");

    // is this OpenSource installation?
    var isOpenSource = "true";
    if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
        // patch qconfig.pri
        var qconfigFile = qtPath + "/mkspecs/qconfig.pri";
        component.addOperation("LineReplace", qconfigFile, "QT_EDITION =", "QT_EDITION = OpenSource");
        if (installer.value("os") == "x11") {
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck64", "QT_LICHECK =");
        }
        if (installer.value("os") == "mac") {
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck_mac", "QT_LICHECK =");
        }
        if (installer.value("os") == "win") {
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck.exe", "QT_LICHECK =");
        }
    }
}

