/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index;

import java.util.Objects;

public class Block {
    private final long startPosition;
    private long size;

    public Block(long startPosition, long size) {
        this.startPosition = startPosition;
        this.size = size;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public long getEndPosition() {
        return this.startPosition + this.size;
    }

    public void setEndPosition(long endPosition) {
        if (endPosition < this.startPosition) {
            throw new IllegalArgumentException("Attempting to set block end position to " + endPosition + " which is before the start of " + this.startPosition);
        }
        this.size = endPosition - this.startPosition;
    }

    public long getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block block = (Block)o;
        return this.startPosition == block.startPosition && this.size == block.size;
    }

    public int hashCode() {
        return Objects.hash(this.startPosition, this.size);
    }
}

