/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManager;
import android.text.TextUtils;
import com.google.android.gms.analytics.CampaignTrackingReceiver;
import com.google.android.gms.analytics.internal.zzaf;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.common.internal.zzu;

public class CampaignTrackingService
extends Service {
    private Handler mHandler;
    private static Boolean zzIe;

    public static boolean zzU(Context context) {
        zzu.zzu(context);
        if (zzIe != null) {
            return zzIe;
        }
        boolean bl = zzam.zza(context, CampaignTrackingService.class);
        zzIe = bl;
        return bl;
    }

    public void onCreate() {
        super.onCreate();
        zzf zzf2 = zzf.zzV((Context)this);
        zzaf zzaf2 = zzf2.zzhQ();
        zzaf2.zzaT("CampaignTrackingService is starting up");
    }

    public void onDestroy() {
        zzf zzf2 = zzf.zzV((Context)this);
        zzaf zzaf2 = zzf2.zzhQ();
        zzaf2.zzaT("CampaignTrackingService is shutting down");
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, final int startId) {
        String string2;
        this.zzhd();
        zzf zzf2 = zzf.zzV((Context)this);
        final zzaf zzaf2 = zzf2.zzhQ();
        String string3 = null;
        if (zzf2.zzhR().zziW()) {
            zzaf2.zzaX("Unexpected installation campaign (package side)");
        } else {
            string3 = intent.getStringExtra("referrer");
        }
        final Handler handler = this.getHandler();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            if (!zzf2.zzhR().zziW()) {
                zzaf2.zzaW("No campaign found on com.android.vending.INSTALL_REFERRER \"referrer\" extra");
            }
            zzf2.zzhS().zze(new Runnable(){

                @Override
                public void run() {
                    CampaignTrackingService.this.zza(zzaf2, handler, startId);
                }
            });
            return 2;
        }
        int n = zzf2.zzhR().zzja();
        if (string3.length() <= n) {
            string2 = string3;
        } else {
            zzaf2.zzc("Campaign data exceed the maximum supported size and will be clipped. size, limit", string3.length(), n);
            string2 = string3.substring(0, n);
        }
        zzaf2.zza("CampaignTrackingService called. startId, campaign", startId, string2);
        zzf2.zzhl().zza(string2, new Runnable(){

            @Override
            public void run() {
                CampaignTrackingService.this.zza(zzaf2, handler, startId);
            }
        });
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzhd() {
        try {
            Object object = CampaignTrackingReceiver.zzoW;
            synchronized (object) {
                PowerManager.WakeLock wakeLock = CampaignTrackingReceiver.zzIc;
                if (wakeLock != null && wakeLock.isHeld()) {
                    wakeLock.release();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    protected void zza(final zzaf zzaf2, Handler handler, final int n) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                boolean bl = CampaignTrackingService.this.stopSelfResult(n);
                if (bl) {
                    zzaf2.zza("Install campaign broadcast processed", bl);
                }
            }
        });
    }

    private Handler getHandler() {
        Handler handler = this.mHandler;
        if (handler == null) {
            this.mHandler = handler = new Handler(this.getMainLooper());
        }
        return handler;
    }
}

