/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import com.google.android.gms.analytics.Logger;
import com.google.android.gms.analytics.Tracker;
import com.google.android.gms.analytics.internal.zzae;
import com.google.android.gms.analytics.internal.zzak;
import com.google.android.gms.analytics.internal.zzal;
import com.google.android.gms.analytics.internal.zzan;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzy;
import com.google.android.gms.common.internal.zzu;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class GoogleAnalytics
extends com.google.android.gms.analytics.zza {
    private static List<Runnable> zzIt = new ArrayList<Runnable>();
    private boolean zzpb;
    private boolean zzIu;
    private Set<zza> zzIv = new HashSet<zza>();
    private boolean zzIw;
    private boolean zzIx;
    private volatile boolean zzIy;
    private boolean zzIz;

    public void zza() {
        this.zzhi();
        this.zzpb = true;
    }

    void zzhi() {
        Logger logger;
        zzan zzan2 = this.zzhm();
        if (zzan2.zzjO()) {
            this.getLogger().setLogLevel(zzan2.getLogLevel());
        }
        if (zzan2.zzjS()) {
            this.setDryRun(zzan2.zzjT());
        }
        if (zzan2.zzjO() && (logger = zzae.getLogger()) != null) {
            logger.setLogLevel(zzan2.getLogLevel());
        }
    }

    public boolean isInitialized() {
        return this.zzpb && !this.zzIu;
    }

    public GoogleAnalytics(zzf context) {
        super(context);
    }

    public static GoogleAnalytics getInstance(Context context) {
        return zzf.zzV(context).zzie();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zzhj() {
        Class<GoogleAnalytics> clazz = GoogleAnalytics.class;
        synchronized (GoogleAnalytics.class) {
            if (zzIt != null) {
                for (Runnable runnable : zzIt) {
                    runnable.run();
                }
                zzIt = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public void setDryRun(boolean dryRun) {
        this.zzIx = dryRun;
    }

    public boolean isDryRunEnabled() {
        return this.zzIx;
    }

    public void enableAutoActivityReports(Application application) {
        if (Build.VERSION.SDK_INT >= 14 && !this.zzIw) {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new zzb());
            this.zzIw = true;
        }
    }

    public void reportActivityStart(Activity activity) {
        if (!this.zzIw) {
            this.zzl(activity);
        }
    }

    void zzl(Activity activity) {
        for (zza zza2 : this.zzIv) {
            zza2.zzn(activity);
        }
    }

    public void reportActivityStop(Activity activity) {
        if (!this.zzIw) {
            this.zzm(activity);
        }
    }

    void zzm(Activity activity) {
        for (zza zza2 : this.zzIv) {
            zza2.zzo(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(String trackingId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            Tracker tracker = new Tracker(this.zzhb(), trackingId, null);
            tracker.zza();
            return tracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracker newTracker(int configResId) {
        GoogleAnalytics googleAnalytics = this;
        synchronized (googleAnalytics) {
            zzak zzak2;
            zzal zzal2;
            Tracker tracker = new Tracker(this.zzhb(), null, null);
            if (configResId > 0 && (zzal2 = (zzal)(zzak2 = new zzak(this.zzhb())).zzab(configResId)) != null) {
                tracker.zza(zzal2);
            }
            tracker.zza();
            return tracker;
        }
    }

    void zza(zza zza2) {
        this.zzIv.add(zza2);
        Context context = this.zzhb().getContext();
        if (context instanceof Application) {
            this.enableAutoActivityReports((Application)context);
        }
    }

    void zzb(zza zza2) {
        this.zzIv.remove(zza2);
    }

    public void setAppOptOut(boolean optOut) {
        this.zzIy = optOut;
        if (this.zzIy) {
            this.zzhl().zzhG();
        }
    }

    public boolean getAppOptOut() {
        return this.zzIy;
    }

    @Deprecated
    public Logger getLogger() {
        return zzae.getLogger();
    }

    @Deprecated
    public void setLogger(Logger logger) {
        zzae.setLogger(logger);
        if (!this.zzIz) {
            Log.i((String)zzy.zzLb.get(), (String)("GoogleAnalytics.setLogger() is deprecated. To enable debug logging, please run:\nadb shell setprop log.tag." + zzy.zzLb.get() + " DEBUG"));
            this.zzIz = true;
        }
    }

    public String getClientId() {
        zzu.zzbZ("getClientId can not be called from the main thread");
        return this.zzhb().zzih().zziP();
    }

    public void setLocalDispatchPeriod(int dispatchPeriodInSeconds) {
        this.zzhl().setLocalDispatchPeriod(dispatchPeriodInSeconds);
    }

    public void dispatchLocalHits() {
        this.zzhl().zzhH();
    }

    void zzhk() {
        this.zzhl().zzhI();
    }

    private com.google.android.gms.analytics.internal.zzb zzhl() {
        return this.zzhb().zzhl();
    }

    private zzan zzhm() {
        return this.zzhb().zzhm();
    }

    class zzb
    implements Application.ActivityLifecycleCallbacks {
        zzb() {
        }

        public void onActivityStarted(Activity activity) {
            GoogleAnalytics.this.zzl(activity);
        }

        public void onActivityStopped(Activity activity) {
            GoogleAnalytics.this.zzm(activity);
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }
    }

    static interface zza {
        public void zzn(Activity var1);

        public void zzo(Activity var1);
    }
}

