/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.analytics.ExceptionParser;
import com.google.android.gms.analytics.internal.zzae;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

public class StandardExceptionParser
implements ExceptionParser {
    private final TreeSet<String> zzIG = new TreeSet();

    public StandardExceptionParser(Context context, Collection<String> additionalPackages) {
        this.setIncludedPackages(context, additionalPackages);
    }

    public void setIncludedPackages(Context context, Collection<String> additionalPackages) {
        this.zzIG.clear();
        HashSet<String> hashSet = new HashSet<String>();
        if (additionalPackages != null) {
            hashSet.addAll(additionalPackages);
        }
        if (context != null) {
            try {
                String string2 = context.getApplicationContext().getPackageName();
                this.zzIG.add(string2);
                String string3 = context.getApplicationContext().getPackageManager().getPackageInfo(string2, 1);
                ActivityInfo[] activityInfoArray = ((PackageInfo)string3).activities;
                if (activityInfoArray != null) {
                    for (ActivityInfo activityInfo : activityInfoArray) {
                        hashSet.add(activityInfo.packageName);
                    }
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                zzae.zzaA("No package found");
            }
        }
        for (String string3 : hashSet) {
            boolean bl = true;
            for (String string4 : this.zzIG) {
                if (!string3.startsWith(string4)) {
                    if (!string4.startsWith(string3)) break;
                    this.zzIG.remove(string4);
                    break;
                }
                bl = false;
            }
            if (!bl) continue;
            this.zzIG.add(string3);
        }
    }

    protected Throwable getCause(Throwable t) {
        Throwable throwable = t;
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    protected StackTraceElement getBestStackTraceElement(Throwable t) {
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        if (stackTraceElementArray == null || stackTraceElementArray.length == 0) {
            return null;
        }
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string2 = stackTraceElement.getClassName();
            for (String string3 : this.zzIG) {
                if (!string2.startsWith(string3)) continue;
                return stackTraceElement;
            }
        }
        return stackTraceElementArray[0];
    }

    protected String getDescription(Throwable cause, StackTraceElement element, String threadName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(cause.getClass().getSimpleName());
        if (element != null) {
            String[] stringArray = element.getClassName().split("\\.");
            String string2 = "unknown";
            if (stringArray != null && stringArray.length > 0) {
                string2 = stringArray[stringArray.length - 1];
            }
            stringBuilder.append(String.format(" (@%s:%s:%s)", string2, element.getMethodName(), element.getLineNumber()));
        }
        if (threadName != null) {
            stringBuilder.append(String.format(" {%s}", threadName));
        }
        return stringBuilder.toString();
    }

    @Override
    public String getDescription(String threadName, Throwable t) {
        return this.getDescription(this.getCause(t), this.getBestStackTraceElement(this.getCause(t)), threadName);
    }
}

