/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.fitness.SessionsApi;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.SessionInsertRequest;
import com.google.android.gms.fitness.request.SessionReadRequest;
import com.google.android.gms.fitness.request.SessionRegistrationRequest;
import com.google.android.gms.fitness.request.SessionStartRequest;
import com.google.android.gms.fitness.request.SessionStopRequest;
import com.google.android.gms.fitness.request.SessionUnregistrationRequest;
import com.google.android.gms.fitness.result.SessionReadResult;
import com.google.android.gms.fitness.result.SessionStopResult;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzms;
import com.google.android.gms.internal.zzmt;
import com.google.android.gms.internal.zzng;
import java.util.concurrent.TimeUnit;

public class zznf
implements SessionsApi {
    @Override
    public PendingResult<Status> startSession(GoogleApiClient client, final Session session) {
        zzu.zzb(session, (Object)"Session cannot be null");
        zzu.zzb(session.getEndTime(TimeUnit.MILLISECONDS) == 0L, (Object)"Cannot start a session which has already ended");
        return client.zzb(new zzmd.zzc(client){

            @Override
            protected void zza(zzmd zzmd2) throws RemoteException {
                zzng zzng2 = new zzng(this);
                String string2 = zzmd2.getContext().getPackageName();
                ((zzmo)zzmd2.zznM()).zza(new SessionStartRequest(session, zzng2, string2));
            }
        });
    }

    private PendingResult<SessionStopResult> zza(GoogleApiClient googleApiClient, final String string2, final String string3) {
        return googleApiClient.zzb(new zzmd.zza<SessionStopResult>(googleApiClient){

            @Override
            protected void zza(zzmd zzmd2) throws RemoteException {
                zzb zzb2 = new zzb(this);
                String string22 = zzmd2.getContext().getPackageName();
                ((zzmo)zzmd2.zznM()).zza(new SessionStopRequest(string2, string3, zzb2, string22));
            }

            protected SessionStopResult zzH(Status status) {
                return SessionStopResult.zzP(status);
            }

            @Override
            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzH(x0);
            }
        });
    }

    @Override
    public PendingResult<SessionStopResult> stopSession(GoogleApiClient client, String identifier) {
        String string2 = null;
        return this.zza(client, string2, identifier);
    }

    @Override
    public PendingResult<Status> insertSession(GoogleApiClient client, final SessionInsertRequest request) {
        return client.zza(new zzmd.zzc(client){

            @Override
            protected void zza(zzmd zzmd2) throws RemoteException {
                zzng zzng2 = new zzng(this);
                String string2 = zzmd2.getContext().getPackageName();
                ((zzmo)zzmd2.zznM()).zza(new SessionInsertRequest(request, zzng2, string2));
            }
        });
    }

    @Override
    public PendingResult<SessionReadResult> readSession(GoogleApiClient client, final SessionReadRequest request) {
        return client.zza(new zzmd.zza<SessionReadResult>(client){

            @Override
            protected void zza(zzmd zzmd2) throws RemoteException {
                zza zza2 = new zza(this);
                String string2 = zzmd2.getContext().getPackageName();
                ((zzmo)zzmd2.zznM()).zza(new SessionReadRequest(request, zza2, string2));
            }

            protected SessionReadResult zzI(Status status) {
                return SessionReadResult.zzO(status);
            }

            @Override
            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzI(x0);
            }
        });
    }

    @Override
    public PendingResult<Status> registerForSessions(GoogleApiClient client, PendingIntent intent) {
        return this.zza(client, intent, 0);
    }

    public PendingResult<Status> zza(GoogleApiClient googleApiClient, final PendingIntent pendingIntent, final int n) {
        return googleApiClient.zzb(new zzmd.zzc(googleApiClient){

            @Override
            protected void zza(zzmd zzmd2) throws RemoteException {
                zzng zzng2 = new zzng(this);
                String string2 = zzmd2.getContext().getPackageName();
                ((zzmo)zzmd2.zznM()).zza(new SessionRegistrationRequest(pendingIntent, zzng2, string2, n));
            }
        });
    }

    @Override
    public PendingResult<Status> unregisterForSessions(GoogleApiClient client, final PendingIntent intent) {
        return client.zzb(new zzmd.zzc(client){

            @Override
            protected void zza(zzmd zzmd2) throws RemoteException {
                zzng zzng2 = new zzng(this);
                String string2 = zzmd2.getContext().getPackageName();
                ((zzmo)zzmd2.zznM()).zza(new SessionUnregistrationRequest(intent, zzng2, string2));
            }
        });
    }

    private static class zza
    extends zzms.zza {
        private final zza.zzb<SessionReadResult> zzOs;

        private zza(zza.zzb<SessionReadResult> zzb2) {
            this.zzOs = zzb2;
        }

        @Override
        public void zza(SessionReadResult sessionReadResult) throws RemoteException {
            this.zzOs.zzm(sessionReadResult);
        }
    }

    private static class zzb
    extends zzmt.zza {
        private final zza.zzb<SessionStopResult> zzOs;

        private zzb(zza.zzb<SessionStopResult> zzb2) {
            this.zzOs = zzb2;
        }

        @Override
        public void zza(SessionStopResult sessionStopResult) {
            this.zzOs.zzm(sessionStopResult);
        }
    }
}

