/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.request.AdRequestInfoParcel;
import com.google.android.gms.ads.internal.request.AdResponseParcel;
import com.google.android.gms.ads.internal.request.zza;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzbb;
import com.google.android.gms.internal.zzbe;
import com.google.android.gms.internal.zzbr;
import com.google.android.gms.internal.zzbz;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzdh;
import com.google.android.gms.internal.zzdl;
import com.google.android.gms.internal.zzdt;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgg;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhh;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzid;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzgd
public class zzl
extends zzhh {
    static final long zzDf = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zzoW = new Object();
    private static boolean zzDg = false;
    private static zzdt zzDh = null;
    private static zzdh zzDi = null;
    private static zzdl zzDj = null;
    private static zzdg zzDk = null;
    private final zza.zza zzCd;
    private final AdRequestInfoParcel.zza zzCe;
    private final Object zzBr = new Object();
    private final Context mContext;
    private zzdt.zzd zzDl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzl(Context context, AdRequestInfoParcel.zza zza2, zza.zza zza3) {
        this.zzCd = zza3;
        this.mContext = context;
        this.zzCe = zza2;
        Object object = zzoW;
        synchronized (object) {
            if (!zzDg) {
                zzDj = new zzdl();
                zzDi = new zzdh(context.getApplicationContext(), zza2.zzpJ);
                zzDk = new zzc();
                zzDh = new zzdt(this.mContext.getApplicationContext(), this.zzCe.zzpJ, zzbz.zztD.get(), new zzb(), new zza());
                zzDg = true;
            }
        }
    }

    protected static void zzc(zzbb zzbb2) {
        zzbb2.zza("/loadAd", zzDj);
        zzbb2.zza("/fetchHttpRequest", zzDi);
        zzbb2.zza("/invalidRequest", zzDk);
    }

    protected static void zzd(zzbb zzbb2) {
        zzbb2.zzb("/loadAd", zzDj);
        zzbb2.zzb("/fetchHttpRequest", zzDi);
        zzbb2.zzb("/invalidRequest", zzDk);
    }

    @Override
    public void zzdP() {
        com.google.android.gms.ads.internal.util.client.zzb.zzay("SdkLessAdLoaderBackgroundTask started.");
        AdRequestInfoParcel adRequestInfoParcel = new AdRequestInfoParcel(this.zzCe, null, null);
        AdResponseParcel adResponseParcel = this.zzf(adRequestInfoParcel);
        long l = zzo.zzbz().elapsedRealtime();
        final zzha.zza zza2 = new zzha.zza(adRequestInfoParcel, adResponseParcel, null, null, adResponseParcel.errorCode, l, adResponseParcel.zzCO, null);
        com.google.android.gms.ads.internal.util.client.zza.zzGF.post(new Runnable(){

            @Override
            public void run() {
                zzl.this.zzCd.zza(zza2);
                if (zzl.this.zzDl != null) {
                    zzl.this.zzDl.release();
                    zzl.this.zzDl = null;
                }
            }
        });
    }

    private AdResponseParcel zzf(AdRequestInfoParcel adRequestInfoParcel) {
        JSONObject jSONObject;
        final String string2 = UUID.randomUUID().toString();
        final JSONObject jSONObject2 = this.zza(adRequestInfoParcel, string2);
        if (jSONObject2 == null) {
            return new AdResponseParcel(0);
        }
        long l = zzo.zzbz().elapsedRealtime();
        Future<JSONObject> future = zzDj.zzU(string2);
        com.google.android.gms.ads.internal.util.client.zza.zzGF.post(new Runnable(){

            @Override
            public void run() {
                zzl.this.zzDl = zzDh.zzdU();
                zzl.this.zzDl.zza(new zzhx.zzc<zzbe>(){

                    public void zzb(zzbe zzbe2) {
                        try {
                            zzbe2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            com.google.android.gms.ads.internal.util.client.zzb.zzb("Error requesting an ad url", exception);
                            zzDj.zzV(string2);
                        }
                    }

                    @Override
                    public /* synthetic */ void zzc(Object object) {
                        this.zzb((zzbe)object);
                    }
                }, new zzhx.zza(){

                    @Override
                    public void run() {
                        zzDj.zzV(string2);
                    }
                });
            }
        });
        long l2 = zzDf - (zzo.zzbz().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new AdResponseParcel(-1);
        }
        catch (TimeoutException timeoutException) {
            return new AdResponseParcel(2);
        }
        catch (ExecutionException executionException) {
            return new AdResponseParcel(0);
        }
        if (jSONObject == null) {
            return new AdResponseParcel(-1);
        }
        AdResponseParcel adResponseParcel = zzgg.zza(this.mContext, adRequestInfoParcel, jSONObject.toString());
        if (adResponseParcel.errorCode != -3 && TextUtils.isEmpty((CharSequence)adResponseParcel.zzCI)) {
            return new AdResponseParcel(3);
        }
        return adResponseParcel;
    }

    private JSONObject zza(AdRequestInfoParcel adRequestInfoParcel, String string2) {
        Bundle bundle = adRequestInfoParcel.zzCm.extras.getBundle("sdk_less_server_data");
        String string3 = adRequestInfoParcel.zzCm.extras.getString("sdk_less_network_id");
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = zzgg.zza(adRequestInfoParcel, zzo.zzbB().zzC(this.mContext), null, new zzbr(zzbz.zztD.get()), null, null, new ArrayList<String>());
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo(this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException exception) {
            com.google.android.gms.ads.internal.util.client.zzb.zzd("Cannot get advertising id info", exception);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("network_id", string3);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzo.zzbv().zzy(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzBr;
        synchronized (object) {
            com.google.android.gms.ads.internal.util.client.zza.zzGF.post(new Runnable(){

                @Override
                public void run() {
                    if (zzl.this.zzDl != null) {
                        zzl.this.zzDl.release();
                        zzl.this.zzDl = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzdt.zzb<zzbb> {
        public void zza(zzbb zzbb2) {
            zzl.zzd(zzbb2);
        }

        @Override
        public /* synthetic */ void zzc(Object object) {
            this.zza((zzbb)object);
        }
    }

    public static class zzb
    implements zzdt.zzb<zzbb> {
        public void zza(zzbb zzbb2) {
            zzl.zzc(zzbb2);
        }

        @Override
        public /* synthetic */ void zzc(Object object) {
            this.zza((zzbb)object);
        }
    }

    public static class zzc
    implements zzdg {
        @Override
        public void zza(zzid zzid2, Map<String, String> map) {
            String string2 = map.get("request_id");
            String string3 = map.get("errors");
            com.google.android.gms.ads.internal.util.client.zzb.zzaC("Invalid request: " + string3);
            zzDj.zzV(string2);
        }
    }
}

