/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzo;
import com.google.android.gms.internal.zzbq;
import com.google.android.gms.internal.zzeu;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzid;
import java.util.Map;

@zzgd
public class zzer
extends zzeu {
    private final Map<String, String> zzyn;
    private final Context mContext;

    public zzer(zzid zzid2, Map<String, String> map) {
        super(zzid2, "storePicture");
        this.zzyn = map;
        this.mContext = zzid2.zzgB();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzae("Activity context is not available");
            return;
        }
        zzbq zzbq2 = zzo.zzbv().zzK(this.mContext);
        if (!zzbq2.zzcS()) {
            this.zzae("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzyn.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzae("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            this.zzae("Invalid image url: " + string2);
            return;
        }
        final String string3 = this.zzad(string2);
        if (!zzo.zzbv().zzav(string3)) {
            this.zzae("Image type not recognized: " + string3);
            return;
        }
        AlertDialog.Builder builder = zzo.zzbv().zzJ(this.mContext);
        builder.setTitle((CharSequence)zzo.zzby().zzc(R.string.store_picture_title, "Save image"));
        builder.setMessage((CharSequence)zzo.zzby().zzc(R.string.store_picture_message, "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)zzo.zzby().zzc(R.string.accept, "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DownloadManager downloadManager = (DownloadManager)zzer.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzer.this.zzf(string2, string3);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzer.this.zzae("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)zzo.zzby().zzc(R.string.decline, "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                zzer.this.zzae("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzf(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzo.zzbx().zza(request);
        return request;
    }

    String zzad(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

