/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.NumericValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralPositionalPattern
extends Pattern {
    private NodeTest nodeTest;
    private Expression positionExpr;
    private boolean usesPosition = true;

    public GeneralPositionalPattern(NodeTest base, Expression positionExpr) {
        this.nodeTest = base;
        this.positionExpr = positionExpr;
    }

    public Expression getPositionExpr() {
        return this.positionExpr;
    }

    public NodeTest getNodeTest() {
        return this.nodeTest;
    }

    @Override
    public Pattern simplify(ExpressionVisitor visitor) throws XPathException {
        this.positionExpr = visitor.simplify(this.positionExpr);
        return this;
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(this.getItemType(), false);
        this.positionExpr = visitor.typeCheck(this.positionExpr, cit);
        this.positionExpr = ExpressionTool.unsortedIfHomogeneous(opt, this.positionExpr);
        this.positionExpr = visitor.optimize(this.positionExpr, cit);
        if (Literal.isConstantBoolean(this.positionExpr, true)) {
            return new ItemTypePattern(this.nodeTest);
        }
        if (Literal.isConstantBoolean(this.positionExpr, false)) {
            return new ItemTypePattern(EmptySequenceTest.getInstance());
        }
        if ((this.positionExpr.getDependencies() & 4) == 0) {
            this.usesPosition = false;
        }
        return this;
    }

    @Override
    public int getDependencies() {
        return this.positionExpr.getDependencies() & 0x80;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator<Expression>(this.positionExpr);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.positionExpr == original) {
            this.positionExpr = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        return ExpressionTool.allocateSlots(this.positionExpr, nextFree, slotManager);
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        Binding[] savedBindingList = offer.bindingList;
        this.positionExpr = this.positionExpr.promote(offer, parent);
        offer.bindingList = savedBindingList;
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        return item instanceof NodeInfo && this.matchesBeneathAnchor((NodeInfo)item, null, context);
    }

    @Override
    public boolean matchesBeneathAnchor(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        return this.internalMatches(node, anchor, context);
    }

    private boolean internalMatches(NodeInfo node, NodeInfo anchor, XPathContext context) throws XPathException {
        if (!this.nodeTest.matches(node, context)) {
            return false;
        }
        XPathContextMinor c2 = context.newMinorContext();
        UnfailingIterator<NodeInfo> iter = SingletonIterator.makeIterator(node);
        iter.next();
        c2.setCurrentIterator(iter);
        try {
            Item predicate;
            XPathContextMinor c = c2;
            if (this.usesPosition) {
                ManualIterator man = new ManualIterator(node, this.getActualPosition(node, context, Integer.MAX_VALUE));
                XPathContextMinor c3 = c2.newMinorContext();
                c3.setCurrentIterator(man);
                c = c3;
            }
            if ((predicate = this.positionExpr.evaluateItem(c)) instanceof NumericValue) {
                NumericValue position = (NumericValue)this.positionExpr.evaluateItem(context);
                if (position.isWholeNumber() && position.compareTo(0L) > 0) {
                    int requiredPos = (int)position.longValue();
                    return this.getActualPosition(node, context, requiredPos) == requiredPos;
                }
                return false;
            }
            return ExpressionTool.effectiveBooleanValue(predicate);
        }
        catch (XPathException e) {
            if ("XTDE0640".equals(e.getErrorCodeLocalPart())) {
                throw e;
            }
            XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", e);
            err.setXPathContext(c2);
            err.setErrorCodeQName(e.getErrorCodeQName());
            err.setLocator(this);
            c2.getController().recoverableError(err);
            return false;
        }
    }

    private int getActualPosition(NodeInfo node, XPathContext context, int max) throws XPathException {
        return context.getConfiguration().getSiblingPosition(node, this.nodeTest, max);
    }

    @Override
    public int getNodeKind() {
        return this.nodeTest.getPrimitiveType();
    }

    @Override
    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    @Override
    public ItemType getItemType() {
        return this.nodeTest;
    }

    public boolean equals(Object other) {
        if (other instanceof GeneralPositionalPattern) {
            GeneralPositionalPattern fp = (GeneralPositionalPattern)other;
            return this.nodeTest.equals(fp.nodeTest) && this.positionExpr.equals(fp.positionExpr);
        }
        return false;
    }

    public int hashCode() {
        return this.nodeTest.hashCode() ^ this.positionExpr.hashCode();
    }
}

